/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class FileBuiltQueryImpl
extends ProjectOpenedHook
implements FileBuiltQueryImplementation {
    final Project project;
    final Map<FileObject, FileBuiltQuery.Status> cache = new WeakHashMap<FileObject, FileBuiltQuery.Status>();
    private static final Set<String> SUPPORTED_EXTS = new HashSet<String>();
    private final PropertyChangeListener pcl;
    private final AtomicBoolean enabled = new AtomicBoolean();
    private static final FileBuiltQuery.Status NONE;

    public FileBuiltQueryImpl(Project project) {
        this.project = project;
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ProjectInfo".equals(evt.getPropertyName())) {
                    FileBuiltQueryImpl.this.cache.clear();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBuiltQuery.Status getStatus(FileObject file) {
        FileBuiltQuery.Status ret;
        if (!this.enabled.get()) {
            return null;
        }
        Map<FileObject, FileBuiltQuery.Status> map = this.cache;
        synchronized (map) {
            ret = this.cache.get(file);
        }
        if (ret == null) {
            ret = this.createStatus(file);
            map = this.cache;
            synchronized (map) {
                this.cache.put(file, ret);
            }
        }
        return ret != NONE ? ret : null;
    }

    private FileBuiltQuery.Status createStatus(FileObject file) {
        File f;
        GradleJavaSourceSet sourceSet;
        FileBuiltQuery.Status ret = NONE;
        GradleJavaProject gjp = GradleJavaProject.get(this.project);
        if (SUPPORTED_EXTS.contains(file.getExt()) && gjp != null && (sourceSet = gjp.containingSourceSet(f = FileUtil.toFile((FileObject)file))) != null) {
            String relFile = sourceSet.relativePath(f);
            String relClass = relFile.substring(0, relFile.lastIndexOf(46)) + ".class";
            try {
                ret = new StatusImpl(file, sourceSet.getOutputClassDirs(), relClass);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return ret;
    }

    protected void projectOpened() {
        this.enabled.set(true);
        NbGradleProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this.pcl);
    }

    protected void projectClosed() {
        this.enabled.set(false);
        NbGradleProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this.pcl);
        this.cache.clear();
    }

    static {
        SUPPORTED_EXTS.addAll(Arrays.asList("java", "groovy", "scala"));
        NONE = new FileBuiltQuery.Status(){

            public boolean isBuilt() {
                return true;
            }

            public void addChangeListener(ChangeListener l) {
            }

            public void removeChangeListener(ChangeListener l) {
            }
        };
    }

    private static class StatusImpl
    implements FileBuiltQuery.Status {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final DataObject source;
        private final Set<File> roots;
        private final String relClass;
        private final PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("modified".equals(evt.getPropertyName())) {
                    this.checkBuilt();
                }
            }
        };
        private final FileChangeListener listener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fe) {
                this.checkBuilt();
            }

            public void fileChanged(FileEvent fe) {
                this.checkBuilt();
            }

            public void fileDeleted(FileEvent fe) {
                this.checkBuilt();
            }

            public void fileAttributeChanged(FileAttributeEvent fe) {
                this.checkBuilt();
            }
        };
        boolean status;

        public StatusImpl(FileObject source, Set<File> roots, String relClass) throws DataObjectNotFoundException {
            this.roots = roots;
            this.relClass = relClass;
            this.source = DataObject.find((FileObject)source);
            this.source.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)this.source));
            for (File root : roots) {
                FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)FileUtil.normalizeFile((File)new File(root, relClass)));
            }
            this.checkBuilt();
        }

        public boolean isBuilt() {
            return this.status;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        private void checkBuilt() {
            FileObject fo = this.source.getPrimaryFile();
            boolean built = false;
            if (fo != null) {
                for (File root : this.roots) {
                    File target = FileUtil.normalizeFile((File)new File(root, this.relClass));
                    if (!target.exists()) continue;
                    long sourceTime = fo.lastModified().getTime();
                    long targetTime = target.lastModified();
                    built = !this.source.isModified() && targetTime > sourceTime;
                    if (!built) continue;
                    break;
                }
            }
            if (built != this.status) {
                this.status = built;
                this.cs.fireChange();
            }
        }
    }
}

