/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.api.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.filesystems.FileObject;

public final class Location {
    final String fileName;
    final String target;
    private Integer lineNum = null;
    private static final Pattern CALLSTACK_ITEM_PARSER = Pattern.compile("(.*)at (\\w[\\w\\.\\$<>]*)\\.(\\w+)\\((\\w+)\\.java\\:([0-9]+)\\)");

    public Location(String fileName, String target) {
        this.fileName = fileName;
        this.target = target;
        try {
            this.lineNum = Integer.parseInt(target);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Location(String loc) {
        int i;
        int n = i = loc != null ? loc.indexOf(58) : 0;
        if (i > 0 && loc != null) {
            this.fileName = loc.substring(0, i);
            this.target = loc.substring(i + 1);
        } else {
            this.fileName = loc;
            this.target = null;
        }
        try {
            this.lineNum = Integer.parseInt(this.target);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTarget() {
        return this.target;
    }

    public Integer getLineNum() {
        return this.lineNum;
    }

    public boolean isLine() {
        return this.lineNum != null;
    }

    public boolean isMethod() {
        return this.target != null && this.lineNum == null;
    }

    public String toString() {
        return this.target != null ? this.fileName + ":" + this.target : this.fileName;
    }

    public static final Location locationFromCallStackItem(String item) {
        Matcher m = CALLSTACK_ITEM_PARSER.matcher(item);
        if (m.matches()) {
            String pkg;
            StringBuilder ret = new StringBuilder(item.length());
            String className = m.group(2);
            String methodName = m.group(3);
            String fileNameBase = m.group(4);
            String line = m.group(5);
            int lastDot = className.lastIndexOf(46);
            String string = pkg = lastDot > 0 ? className.substring(0, lastDot) : "";
            if (fileNameBase != null) {
                ret.append(pkg.replace('.', '/')).append('/').append(fileNameBase);
            } else {
                ret.append(className.replace('.', '/'));
            }
            ret.append(".java");
            return new Location(ret.toString(), line != null ? line : methodName);
        }
        return null;
    }

    public static interface Finder {
        public FileObject findFileObject(Location var1);
    }
}

