/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProvider;
import org.netbeans.modules.web.common.api.UsageLogger;

public final class UsageLogging {
    private static final Logger LOGGER = Logger.getLogger(UsageLogging.class.getName());
    private final UsageLogger testConfigUsageLogger = new UsageLogger.Builder("org.netbeans.ui.metrics.php").message(PhpProjectUtils.class, "USG_TEST_CONFIG_PHP").firstMessageOnly(false).create();
    private final UsageLogger phpTestRunUsageLogger = new UsageLogger.Builder("org.netbeans.ui.metrics.php").message(PhpProjectUtils.class, "USG_TEST_RUN_PHP").create();
    private final UsageLogger jsTestRunUsageLogger = UsageLogger.jsTestRunUsageLogger((String)"org.netbeans.ui.metrics.php");

    public static void logTestConfig(PhpProject project, List<String> testingProviders) {
        assert (project != null);
        ((UsageLogging)project.getLookup().lookup(UsageLogging.class)).logPhpTestConfig(testingProviders);
    }

    public static void logPhpTestRun(PhpProject project, List<PhpTestingProvider> testingProviders) {
        assert (project != null);
        ((UsageLogging)project.getLookup().lookup(UsageLogging.class)).logPhpTestRun(testingProviders);
    }

    public static void logJsTestRun(PhpProject project, JsTestingProvider jsTestingProvider) {
        assert (project != null);
        ((UsageLogging)project.getLookup().lookup(UsageLogging.class)).logJsTestRun(jsTestingProvider);
    }

    private void logPhpTestConfig(List<String> testingProviders) {
        assert (testingProviders != null);
        LOGGER.finest("Usage logging for PHP test config");
        this.testConfigUsageLogger.log(new Object[]{StringUtils.implode(testingProviders, (String)"|")});
    }

    private void logPhpTestRun(List<PhpTestingProvider> testingProviders) {
        assert (testingProviders != null);
        LOGGER.finest("Usage logging for PHP test run");
        this.phpTestRunUsageLogger.log(new Object[]{UsageLogging.getTestingProvidersForUsage(testingProviders)});
    }

    private void logJsTestRun(JsTestingProvider jsTestingProvider) {
        assert (jsTestingProvider != null);
        this.jsTestRunUsageLogger.log(new Object[]{"org.netbeans.modules.php.project", jsTestingProvider.getIdentifier()});
    }

    private static String getTestingProvidersForUsage(Collection<PhpTestingProvider> testingProviders) {
        assert (testingProviders != null);
        ArrayList<String> identifiers = new ArrayList<String>(testingProviders.size());
        for (PhpTestingProvider provider : testingProviders) {
            identifiers.add(provider.getIdentifier());
        }
        return StringUtils.implode(identifiers, (String)"|");
    }
}

