/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.IncludePathSupport;
import org.netbeans.modules.php.project.problems.Bundle;
import org.netbeans.modules.php.project.problems.CustomizerProblemResolver;
import org.netbeans.modules.php.project.problems.DirectoryProblemResolver;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.SeleniumTestDirectoriesPathSupport;
import org.netbeans.modules.php.project.ui.customizer.TestDirectoriesPathSupport;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public final class ProjectPropertiesProblemProvider
implements ProjectProblemsProvider {
    static final List<String> WATCHED_PROPERTIES = new CopyOnWriteArrayList<String>(Arrays.asList("src.dir", "selenium.src.dir", "web.root", "include.path", "include.path.private"));
    static final List<String> WATCHED_PROPERTY_PREFIXES = new CopyOnWriteArrayList<String>(Arrays.asList("test.src.dir"));
    final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    private final PhpProject project;
    private final PropertyChangeListener projectPropertiesListener = new ProjectPropertiesListener();
    private volatile FileChangeListener fileChangesListener = new FileChangesListener();

    private ProjectPropertiesProblemProvider(PhpProject project) {
        this.project = project;
    }

    public static ProjectPropertiesProblemProvider createForProject(PhpProject project) {
        ProjectPropertiesProblemProvider projectProblems = new ProjectPropertiesProblemProvider(project);
        projectProblems.addProjectPropertiesListeners();
        projectProblems.addFileChangesListeners();
        return projectProblems;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<ProjectProblemsProvider.ProjectProblem> collectProblems() {
                ArrayList<ProjectProblemsProvider.ProjectProblem> currentProblems = new ArrayList<ProjectProblemsProvider.ProjectProblem>(5);
                ProjectPropertiesProblemProvider.this.checkSrcDir(currentProblems);
                if (currentProblems.isEmpty()) {
                    ProjectPropertiesProblemProvider.this.checkTestDirs(currentProblems);
                    ProjectPropertiesProblemProvider.this.checkSeleniumDir(currentProblems);
                    ProjectPropertiesProblemProvider.this.checkWebRoot(currentProblems);
                    ProjectPropertiesProblemProvider.this.checkIncludePath(currentProblems);
                }
                return currentProblems;
            }
        });
    }

    void checkSrcDir(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File invalidDirectory = this.getInvalidDirectory(ProjectPropertiesSupport.getSourcesDirectory(this.project), "src.dir");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidSrcDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidSrcDir_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new DirectoryProblemResolver(this.project, "src.dir", Bundle.ProjectPropertiesProblemProvider_invalidSrcDir_dialog_title(this.project.getName())));
            currentProblems.add(problem);
        }
    }

    void checkTestDirs(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        TestDirectoriesPathSupport testDirectoriesPathSupport = new TestDirectoriesPathSupport(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getRefHelper(), this.project.getHelper());
        Enumeration<BasePathSupport.Item> items = new PhpProjectProperties(this.project, null, null, testDirectoriesPathSupport, null).getTestDirectoriesListModel().elements();
        int i = 0;
        while (items.hasMoreElements()) {
            BasePathSupport.Item item = items.nextElement();
            ValidationResult result = new TestDirectoriesPathSupport.Validator().validatePath(this.project, item).getResult();
            if (!result.hasErrors()) continue;
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidTestDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidTestDir_description(item.getAbsoluteFilePath(this.project.getProjectDirectory())), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "Testing", "test.src.dir" + i));
            currentProblems.add(problem);
            ++i;
        }
    }

    void checkSeleniumDir(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        SeleniumTestDirectoriesPathSupport seleniumTestDirectoriesPathSupport = new SeleniumTestDirectoriesPathSupport(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getRefHelper(), this.project.getHelper());
        Enumeration<BasePathSupport.Item> items = new PhpProjectProperties(this.project, null, null, null, seleniumTestDirectoriesPathSupport).getSeleniumTestDirectoriesListModel().elements();
        int i = 0;
        while (items.hasMoreElements()) {
            BasePathSupport.Item item = items.nextElement();
            ValidationResult result = new SeleniumTestDirectoriesPathSupport.Validator().validatePath(this.project, item).getResult();
            if (!result.hasErrors()) continue;
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidSeleniumDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidSeleniumDir_description(item.getAbsoluteFilePath(this.project.getProjectDirectory())), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "SeleniumTesting", "selenium.src.dir" + i));
            currentProblems.add(problem);
            ++i;
        }
    }

    void checkWebRoot(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File webRoot = this.getWebRoot();
        if (webRoot == null) {
            return;
        }
        File invalidDirectory = this.getInvalidDirectory(FileUtil.toFileObject((File)webRoot), "web.root");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidWebRoot_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidWebRoot_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "Sources", "web.root"));
            currentProblems.add(problem);
        }
    }

    void checkIncludePath(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        ProjectProblemsProvider.ProjectProblem projectProblem = this.checkIncludePath("include.path");
        if (projectProblem != null) {
            currentProblems.add(projectProblem);
            return;
        }
        projectProblem = this.checkIncludePath("include.path.private");
        if (projectProblem != null) {
            currentProblems.add(projectProblem);
        }
    }

    @CheckForNull
    private ProjectProblemsProvider.ProjectProblem checkIncludePath(String includePathProperty) {
        IncludePathSupport includePathSupport = new IncludePathSupport(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getRefHelper(), this.project.getHelper());
        List<BasePathSupport.Item> items = includePathSupport.itemsList(ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(includePathProperty));
        ValidationResult result = new IncludePathSupport.Validator().validateBroken(items).validatePaths(this.project, items).getResult();
        if (!result.hasErrors()) {
            return null;
        }
        return ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidIncludePath_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidIncludePath_description(), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "PhpIncludePath", includePathProperty));
    }

    private File getInvalidDirectory(FileObject directory, String propertyName) {
        assert (this.isWatchedProperty(propertyName)) : "Property '" + propertyName + "' should be watched for changes";
        if (directory != null) {
            if (directory.isValid()) {
                return null;
            }
            return FileUtil.toFile((FileObject)directory);
        }
        String propValue = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(propertyName);
        if (propValue == null) {
            return null;
        }
        File dir = ProjectPropertiesSupport.getSubdirectory(this.project, this.project.getProjectDirectory(), propValue);
        if (dir.isDirectory()) {
            return null;
        }
        return dir;
    }

    private File getWebRoot() {
        if (PhpProjectValidator.isFatallyBroken(this.project)) {
            return null;
        }
        return ProjectPropertiesSupport.getSourceSubdirectory(this.project, ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty("web.root"));
    }

    private void addProjectPropertiesListeners() {
        ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(this.project, this.projectPropertiesListener);
    }

    private void addFileChangesListeners() {
        this.addFileChangesListener(this.project.getSourceRoots());
        this.addFileChangesListener(this.project.getTestRoots());
        this.addFileChangesListener(this.project.getSeleniumRoots());
        File webRoot = this.getWebRoot();
        if (webRoot != null) {
            this.addFileChangeListener(webRoot);
        }
    }

    private void addFileChangesListener(SourceRoots sourceRoots) {
        for (FileObject root : sourceRoots.getRoots()) {
            File file = FileUtil.toFile((FileObject)root);
            if (file == null) continue;
            this.addFileChangeListener(file);
        }
    }

    private void addFileChangeListener(File file) {
        try {
            FileUtil.addFileChangeListener((FileChangeListener)this.fileChangesListener, (File)file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    boolean isWatchedProperty(String propertyName) {
        if (WATCHED_PROPERTIES.contains(propertyName)) {
            return true;
        }
        for (String prefix : WATCHED_PROPERTY_PREFIXES) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    void propertiesChanged() {
        this.fileChangesListener = new FileChangesListener();
        this.addFileChangesListeners();
    }

    private final class FileChangesListener
    implements FileChangeListener {
        private FileChangesListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private final class ProjectPropertiesListener
    implements PropertyChangeListener {
        private ProjectPropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (ProjectPropertiesProblemProvider.this.isWatchedProperty(evt.getPropertyName())) {
                ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
                ProjectPropertiesProblemProvider.this.propertiesChanged();
            }
        }
    }
}

