/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sync.diff;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.project.connections.sync.diff.Bundle;
import org.openide.filesystems.FileObject;

abstract class BaseStreamSource
extends StreamSource {
    protected static final Logger LOGGER = Logger.getLogger(BaseStreamSource.class.getName());
    private final String name;
    private final String mimeType;
    private final boolean remote;

    BaseStreamSource(String name, String mimeType, boolean remote) {
        this.name = name;
        this.mimeType = mimeType;
        this.remote = remote;
    }

    protected abstract Reader createReaderInternal() throws IOException;

    public final String getName() {
        return this.name;
    }

    public final String getTitle() {
        return this.remote ? Bundle.BaseStreamSource_title_remote() : Bundle.BaseStreamSource_title_local();
    }

    public final String getMIMEType() {
        return this.mimeType;
    }

    public final Reader createReader() throws IOException {
        if (!this.mimeType.startsWith("text/")) {
            LOGGER.log(Level.INFO, "No reader for non-text file; MIME type is {0}", this.mimeType);
            return null;
        }
        return this.createReaderInternal();
    }

    public final Writer createWriter(Difference[] conflicts) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected static Reader createReader(FileObject fileObject) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(fileObject.getInputStream(), FileEncodingQuery.getEncoding((FileObject)fileObject)));
    }
}

