/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.app;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.impl.application.ApplicationProxy;
import org.netbeans.modules.j2ee.ddloaders.app.DDChangeEvent;
import org.netbeans.modules.j2ee.ddloaders.app.DDChangeListener;
import org.netbeans.modules.j2ee.ddloaders.app.DDChangesPanel;
import org.netbeans.modules.j2ee.ddloaders.app.EarDDUtils;
import org.netbeans.modules.j2ee.ddloaders.app.EarDataLoader;
import org.netbeans.modules.j2ee.ddloaders.app.EarDataNode;
import org.netbeans.modules.j2ee.ddloaders.common.DD2beansDataObject;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.SAXParseError;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class EarDataObject
extends DD2beansDataObject
implements DDChangeListener,
ApplicationProxy.OutputProvider,
FileChangeListener,
ChangeListener {
    private Application ejbJar;
    private FileObject[] srcRoots;
    private static final RequestProcessor RP2 = new RequestProcessor();
    private static final long serialVersionUID = 8857563089355069362L;
    public static final String PROP_DOCUMENT_DTD = "documentDTD";
    private boolean unparsable = true;
    private Vector updates;
    private RequestProcessor.Task updateTask;
    private RequestProcessor.Task elementTask;
    private List deletedEjbNames;
    private List newFileNames;

    public EarDataObject(FileObject pf, EarDataLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        this.init(pf, loader);
    }

    public static MultiViewEditorElement createMultiViewEditorElement(Lookup context) {
        return new MultiViewEditorElement(context);
    }

    @Override
    protected String getEditorMimeType() {
        return "text/x-dd-application";
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public boolean isUnparsable() {
        return this.unparsable;
    }

    private void init(FileObject fo, EarDataLoader loader) {
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sources.addChangeListener((ChangeListener)this);
        }
        this.refreshSourceFolders();
    }

    private void refreshSourceFolders() {
        ArrayList<FileObject> srcRootList = new ArrayList<FileObject>();
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sources.removeChangeListener((ChangeListener)this);
            sources.addChangeListener((ChangeListener)this);
            SourceGroup[] groups = sources.getSourceGroups("java");
            for (int i = 0; i < groups.length; ++i) {
                EjbJar ejbModule = EjbJar.getEjbJar((FileObject)groups[i].getRootFolder());
                if (ejbModule == null || ejbModule.getDeploymentDescriptor() == null) continue;
                try {
                    FileObject fo = groups[i].getRootFolder();
                    srcRootList.add(groups[i].getRootFolder());
                    FileSystem fs = fo.getFileSystem();
                    fs.removeFileChangeListener((FileChangeListener)this);
                    fs.addFileChangeListener((FileChangeListener)this);
                    continue;
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        this.srcRoots = srcRootList.toArray(new FileObject[srcRootList.size()]);
    }

    private String getPackageName(FileObject clazz) {
        for (int i = 0; i < this.srcRoots.length; ++i) {
            String rp = FileUtil.getRelativePath((FileObject)this.srcRoots[i], (FileObject)clazz);
            if (rp == null) continue;
            if (clazz.getExt().length() > 0) {
                rp = rp.substring(0, rp.length() - clazz.getExt().length() - 1);
            }
            return rp.replace('/', '.');
        }
        return null;
    }

    public Application getApplication() {
        if (this.ejbJar == null) {
            this.parsingDocument();
        }
        return this.ejbJar;
    }

    public Application getOriginalApplication() throws IOException {
        return DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
    }

    protected Node createNodeDelegate() {
        return new EarDataNode(this);
    }

    protected int associateLookup() {
        return 1;
    }

    @Override
    protected String getIconBaseForValidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/ejb/DDDataIcon.gif";
    }

    @Override
    protected String getIconBaseForInvalidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/ejb/DDDataIcon1.gif";
    }

    public String getStringForValidDocument() {
        return NbBundle.getMessage(EarDataObject.class, (String)"LAB_deploymentDescriptor");
    }

    public String getStringForInvalidDocument(SAXParseError error) {
        return NbBundle.getMessage(EarDataObject.class, (String)"TXT_errorOnLine", (Object)new Integer(error.getErrorLine()));
    }

    @Override
    protected String generateDocument() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.ejbJar.write((OutputStream)out);
            out.close();
            return out.toString("UTF8");
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        catch (IllegalStateException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        return out.toString();
    }

    protected String updateDocument(Document doc) {
        return null;
    }

    public void write(Application ejbJarProxy) throws IOException {
        Application app = this.getApplication();
        if (app != null) {
            app.merge((RootInterface)ejbJarProxy, 2);
        }
        this.setNodeDirty(true);
    }

    public FileObject getTarget() {
        return this.getPrimaryFile();
    }

    @Override
    protected SAXParseError updateNode(InputSource is) throws IOException {
        if (this.ejbJar == null) {
            try {
                this.ejbJar = DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
                this.firePropertyChange("propertySets", null, null);
                if (this.unparsable) {
                    this.unparsable = false;
                }
                return null;
            }
            catch (RuntimeException e) {
                if (!this.unparsable) {
                    this.unparsable = true;
                }
                return new SAXParseError(new SAXParseException(e.getMessage(), new LocatorImpl()));
            }
        }
        Application app = null;
        try {
            app = EarDDUtils.createApplication(is);
            if (!this.ejbJar.getVersion().equals(app.getVersion())) {
                ((ApplicationProxy)this.ejbJar).setOriginal(app);
            }
            this.unparsable = false;
            if (app.getError() != null) {
                System.out.println(app.getError().getMessage());
            }
        }
        catch (SAXParseException e) {
            if (!this.unparsable) {
                this.unparsable = true;
            }
            return new SAXParseError(e);
        }
        catch (SAXException e) {
            if (!this.unparsable) {
                this.unparsable = true;
            }
            throw new IOException();
        }
        if (app != null) {
            this.ejbJar.merge((RootInterface)app, 3);
        }
        return null;
    }

    protected DataObject handleCopy(DataFolder f) throws IOException {
        DataObject dObj = super.handleCopy(f);
        try {
            dObj.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        EarDataObject earDataObject = this;
        synchronized (earDataObject) {
            this.updates = null;
            if (this.updateTask != null) {
                this.updateTask.cancel();
            }
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploymentChange(DDChangeEvent evt) {
        EarDataObject earDataObject = this;
        synchronized (earDataObject) {
            if (this.updates == null) {
                this.updates = new Vector();
            }
            this.updates.addElement(evt);
        }
        if (this.updateTask == null) {
            this.updateTask = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Vector changes = null;
                    EarDataObject earDataObject = EarDataObject.this;
                    synchronized (earDataObject) {
                        if (!EarDataObject.this.isValid()) {
                            return;
                        }
                        if (EarDataObject.this.updates != null) {
                            changes = EarDataObject.this.updates;
                            EarDataObject.this.updates = null;
                        }
                    }
                    if (changes != null) {
                        EarDataObject.this.showDDChangesDialog(changes);
                    }
                }
            }, 2000, 1);
        } else {
            this.updateTask.schedule(2000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDDChangesDialog(List changes) {
        ProjectInformation projectInfo;
        final Dialog[] confirmChangesDialog = new Dialog[]{null};
        final JButton processButton = new JButton(NbBundle.getMessage(EarDataObject.class, (String)"LAB_processButton"));
        processButton.setMnemonic(NbBundle.getMessage(EarDataObject.class, (String)"LAB_processButton_Mnemonic").charAt(0));
        processButton.setToolTipText(NbBundle.getMessage(EarDataObject.class, (String)"ACS_processButtonA11yDesc"));
        JButton processAllButton = new JButton(NbBundle.getMessage(EarDataObject.class, (String)"LAB_processAllButton"));
        processAllButton.setMnemonic(NbBundle.getMessage(EarDataObject.class, (String)"LAB_processAllButton_Mnemonic").charAt(0));
        processAllButton.setToolTipText(NbBundle.getMessage(EarDataObject.class, (String)"ACS_processAllButtonA11yDesc"));
        JButton closeButton = new JButton(NbBundle.getMessage(EarDataObject.class, (String)"LAB_closeButton"));
        closeButton.setMnemonic(NbBundle.getMessage(EarDataObject.class, (String)"LAB_closeButton_Mnemonic").charAt(0));
        closeButton.setToolTipText(NbBundle.getMessage(EarDataObject.class, (String)"ACS_closeButtonA11yDesc"));
        final Object[] options = new Object[]{processButton, processAllButton};
        final Object[] additionalOptions = new Object[]{closeButton};
        String fsname = "";
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null && (projectInfo = ProjectUtils.getInformation((Project)project)) != null) {
            fsname = projectInfo.getName();
        }
        String caption = NbBundle.getMessage(EarDataObject.class, (String)"MSG_SynchronizeCaption", (Object)fsname);
        final DDChangesPanel connectionPanel = new DDChangesPanel(caption, processButton);
        DialogDescriptor confirmChangesDescriptor = new DialogDescriptor((Object)connectionPanel, NbBundle.getMessage(EarDataObject.class, (String)"LAB_ConfirmDialog"), true, options, (Object)processButton, 1, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component root;
                if (e.getSource() instanceof Component && !(root = SwingUtilities.getRoot((Component)e.getSource())).isDisplayable()) {
                    return;
                }
                if (options[0].equals(e.getSource())) {
                    int max;
                    int min = connectionPanel.changesList.getMinSelectionIndex();
                    for (int i = max = connectionPanel.changesList.getMaxSelectionIndex(); i >= min; --i) {
                        if (!connectionPanel.changesList.isSelectedIndex(i)) continue;
                        DDChangeEvent ev = (DDChangeEvent)connectionPanel.listModel.getElementAt(i);
                        EarDataObject.this.processDDChangeEvent(ev);
                        connectionPanel.listModel.removeElementAt(i);
                    }
                    if (connectionPanel.listModel.isEmpty()) {
                        confirmChangesDialog[0].setVisible(false);
                    } else {
                        processButton.setEnabled(false);
                    }
                } else if (options[1].equals(e.getSource())) {
                    Enumeration en = connectionPanel.listModel.elements();
                    while (en.hasMoreElements()) {
                        EarDataObject.this.processDDChangeEvent((DDChangeEvent)en.nextElement());
                    }
                    confirmChangesDialog[0].setVisible(false);
                    connectionPanel.setChanges(null);
                } else if (additionalOptions[0].equals(e.getSource())) {
                    confirmChangesDialog[0].setVisible(false);
                    connectionPanel.setChanges(null);
                }
            }
        });
        confirmChangesDescriptor.setAdditionalOptions(additionalOptions);
        processButton.setEnabled(false);
        processAllButton.requestFocus();
        connectionPanel.setChanges(changes);
        try {
            confirmChangesDialog[0] = DialogDisplayer.getDefault().createDialog(confirmChangesDescriptor);
            confirmChangesDialog[0].setVisible(true);
        }
        finally {
            confirmChangesDialog[0].dispose();
        }
    }

    private void processDDChangeEvent(DDChangeEvent evt) {
        if (!this.isValid()) {
            return;
        }
        if (evt.getType() != 1) {
            this.updateDD(evt.getOldValue(), evt.getNewValue(), evt.getType());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(EarDataObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void elementCreated(String elementName) {
        EarDataObject earDataObject = this;
        synchronized (earDataObject) {
            if (this.newFileNames == null) {
                this.newFileNames = new ArrayList();
            }
            this.newFileNames.add(elementName);
        }
        if (this.elementTask == null) {
            this.elementTask = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EarDataObject earDataObject;
                    if (EarDataObject.this.deletedEjbNames != null) {
                        for (int i = 0; i < EarDataObject.this.deletedEjbNames.size(); ++i) {
                            String deletedServletName;
                            String deletedName = deletedServletName = (String)EarDataObject.this.deletedEjbNames.get(i);
                            int index = deletedServletName.lastIndexOf(".");
                            if (index > 0) {
                                deletedName = deletedServletName.substring(index + 1);
                            }
                            boolean found = false;
                            for (int j = 0; j < EarDataObject.this.newFileNames.size(); ++j) {
                                String newFileName;
                                String newName = newFileName = (String)EarDataObject.this.newFileNames.get(j);
                                int ind = newFileName.lastIndexOf(".");
                                if (ind > 0) {
                                    newName = newFileName.substring(ind + 1);
                                }
                                if (!deletedName.equals(newName)) continue;
                                found = true;
                                DDChangeEvent ddEvent = new DDChangeEvent(EarDataObject.this, EarDataObject.this, deletedServletName, newFileName, 2);
                                EarDataObject.this.deploymentChange(ddEvent);
                                EarDataObject earDataObject2 = EarDataObject.this;
                                synchronized (earDataObject2) {
                                    EarDataObject.this.newFileNames.remove(newFileName);
                                    break;
                                }
                            }
                            if (found) continue;
                            DDChangeEvent ddEvent = new DDChangeEvent(EarDataObject.this, EarDataObject.this, null, deletedServletName, 3);
                            EarDataObject.this.deploymentChange(ddEvent);
                        }
                        earDataObject = EarDataObject.this;
                        synchronized (earDataObject) {
                            EarDataObject.this.deletedEjbNames = null;
                        }
                    }
                    earDataObject = EarDataObject.this;
                    synchronized (earDataObject) {
                        EarDataObject.this.newFileNames = null;
                    }
                }
            }, 1500, 1);
        } else {
            this.elementTask.schedule(1500);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fo = fileRenameEvent.getFile();
        String resourceName = this.getPackageName(fo);
        if (resourceName != null) {
            int index = resourceName.lastIndexOf(".");
            String oldName = fileRenameEvent.getName();
            String oldResourceName = (index >= 0 ? resourceName.substring(0, index + 1) : "") + oldName;
            Application ejbJar = this.getApplication();
            if (ejbJar.getStatus() == 0) {
                this.fireEvent(oldResourceName, resourceName, 2);
            }
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDeleted(FileEvent fileEvent) {
        FileObject fo = fileEvent.getFile();
        String resourceName = this.getPackageName(fo);
        if (resourceName != null && this.newFileNames == null) {
            this.fireEvent(null, resourceName, 3);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fo = fileEvent.getFile();
        String resourceName = this.getPackageName(fo);
        if (resourceName != null) {
            this.elementCreated(resourceName);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        RP2.post(new Runnable(){

            @Override
            public void run() {
                EarDataObject.this.refreshSourceFolders();
            }
        });
    }

    private boolean fireEvent(String oldResourceName, String resourceName, int eventType) {
        boolean elementFound = false;
        int specificEventType = -1;
        if (elementFound) {
            assert (specificEventType > 0);
            DDChangeEvent ddEvent = new DDChangeEvent(this, this, oldResourceName, resourceName, specificEventType);
            this.deploymentChange(ddEvent);
        }
        return elementFound;
    }

    private void updateDD(String oldResourceName, String resourceName, int eventType) {
        boolean ddModified = false;
        switch (eventType) {
            case 13: {
                if (oldResourceName != null) break;
                return;
            }
            case 14: {
                if (resourceName != null) break;
                return;
            }
            case 5: {
                if (oldResourceName != null) break;
                return;
            }
            case 6: {
                if (oldResourceName != null) break;
                return;
            }
            case 7: {
                if (oldResourceName != null) break;
                return;
            }
            case 8: {
                if (oldResourceName != null) break;
                return;
            }
            case 9: {
                if (resourceName != null) break;
                return;
            }
            case 10: {
                if (resourceName != null) break;
                return;
            }
            case 11: {
                if (resourceName != null) break;
                return;
            }
            case 12: {
                if (resourceName != null) break;
                return;
            }
        }
        if (ddModified) {
            this.setNodeDirty(true);
        }
    }
}

