/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.editors.StringArrayCustomEditor;
import org.netbeans.modules.form.editors.StringArrayEditor;
import org.openide.util.NbBundle;

public class ListModelEditor
extends StringArrayEditor
implements NamedPropertyEditor,
FormAwareEditor {
    private ListModel listModel;
    private RADProperty property;

    @Override
    public void setValue(Object val) {
        if (val instanceof ListModel) {
            this.listModel = (ListModel)val;
            super.setValue(ListModelEditor.getDataFromModel(this.listModel));
        } else if (val instanceof String[]) {
            this.listModel = ListModelEditor.getModelForData((String[])val);
            super.setValue(val);
        } else {
            this.listModel = ListModelEditor.getModelForData(new String[0]);
            super.setValue(null);
        }
    }

    @Override
    public Object getValue() {
        return this.listModel;
    }

    @Override
    public void setStringArray(String[] value) {
        this.listModel = ListModelEditor.getModelForData(value);
        super.setValue(value);
    }

    @Override
    public String[] getStringArray() {
        return (String[])super.getValue();
    }

    @Override
    public String getJavaInitializationString() {
        if (this.getStrings(true).equals("")) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("new javax.swing.AbstractListModel");
        buf.append(FormUtils.getTypeParametersCode(this.property, true));
        buf.append("() {\n");
        buf.append("String[] strings = { ");
        buf.append(this.getStrings(true));
        buf.append(" };\n");
        buf.append("public int getSize() { return strings.length; }\n");
        buf.append("public ");
        String typeParam = this.property != null ? FormUtils.getTypeParameters(this.property.getRADComponent()) : null;
        buf.append("String".equals(typeParam) ? typeParam : "Object");
        buf.append(" getElementAt(int i) { return strings[i]; }\n");
        buf.append("}");
        return buf.toString();
    }

    static String[] getDataFromModel(ListModel model) {
        String[] data = new String[model.getSize()];
        for (int i = 0; i < data.length; ++i) {
            Object obj = model.getElementAt(i);
            data[i] = obj instanceof String ? (String)obj : "";
        }
        return data;
    }

    static ListModel getModelForData(String[] data) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (int i = 0; i < data.length; ++i) {
            model.addElement(data[i]);
        }
        return model;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getBundle(ListModelEditor.class).getString("CTL_ListModelEditor_DisplayName");
    }

    @Override
    public Component getCustomEditor() {
        return new StringArrayCustomEditor(this, NbBundle.getMessage(ListModelEditor.class, (String)"ListModelEditor.label.text"));
    }

    @Override
    public void setContext(FormModel formModel, FormProperty property) {
        if (property instanceof RADProperty) {
            this.property = (RADProperty)property;
        }
    }

    @Override
    public void updateFormVersionLevel() {
    }
}

