/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class MultiClassLoader
extends ClassLoader {
    private ClassLoader[] loaders;

    public MultiClassLoader(ClassLoader ... loaders) {
        this.loaders = loaders;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.findClass(name);
    }

    @Override
    protected URL findResource(String name) {
        ClassLoader loader;
        URL url = null;
        ClassLoader[] classLoaderArray = this.loaders;
        int n = classLoaderArray.length;
        for (int i = 0; i < n && (url = (loader = classLoaderArray[i]).getResource(name)) == null; ++i) {
        }
        return url;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Vector<URL> vector = new Vector<URL>();
        for (ClassLoader loader : this.loaders) {
            Enumeration<URL> enumeration = loader.getResources(name);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                if (vector.contains(url)) continue;
                vector.add(url);
            }
        }
        return vector.elements();
    }
}

