/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class NotInitializedVariable
implements ErrorRule<Void> {
    private static final String DIAGNOSTIC_KEY = "compiler.err.var.might.not.have.been.initialized";
    private volatile boolean canceled;

    public Set<String> getCodes() {
        return Collections.singleton(DIAGNOSTIC_KEY);
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        assert (DIAGNOSTIC_KEY.equals(diagnosticKey));
        ArrayList<NIVFix> result = new ArrayList<NIVFix>();
        if (!this.canceled) {
            Trees t = compilationInfo.getTrees();
            Element e = t.getElement(treePath);
            if (!this.canceled && e != null && e.getKind() == ElementKind.LOCAL_VARIABLE) {
                TreePath declaration = t.getPath(e);
                if (!this.canceled && declaration != null) {
                    result.add(new NIVFix(compilationInfo.getFileObject(), e.getSimpleName().toString(), TreePathHandle.create((TreePath)declaration, (CompilationInfo)compilationInfo)));
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public String getId() {
        return "NotInitializedVariable";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(NotInitializedVariable.class, (String)"LBL_NotInitializedVariable");
    }

    public void cancel() {
        this.canceled = true;
    }

    private static class NIVFix
    implements Fix {
        private final FileObject file;
        private final String variableName;
        private final TreePathHandle variable;

        public NIVFix(FileObject file, String variableName, TreePathHandle variable) {
            assert (file != null);
            assert (variableName != null);
            assert (variable != null);
            this.file = file;
            this.variableName = variableName;
            this.variable = variable;
        }

        public String getText() {
            return NbBundle.getMessage(NotInitializedVariable.class, (String)"LBL_NotInitializedVariable_fix", (Object)this.variableName);
        }

        public ChangeInfo implement() throws Exception {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            if (js != null) {
                js.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy wc) throws Exception {
                        wc.toPhase(JavaSource.Phase.RESOLVED);
                        TreePath tp = variable.resolve((CompilationInfo)wc);
                        if (tp == null) {
                            return;
                        }
                        VariableTree vt = (VariableTree)tp.getLeaf();
                        ExpressionTree init = vt.getInitializer();
                        if (init != null) {
                            return;
                        }
                        Element decl = wc.getTrees().getElement(tp);
                        if (decl == null) {
                            return;
                        }
                        TypeMirror type = decl.asType();
                        TypeKind kind = type.getKind();
                        Comparable<Boolean> value = kind.isPrimitive() ? (kind == TypeKind.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)) : null;
                        LiteralTree newInit = wc.getTreeMaker().Literal((Object)value);
                        VariableTree newVt = wc.getTreeMaker().Variable(vt.getModifiers(), (CharSequence)vt.getName(), vt.getType(), (ExpressionTree)newInit);
                        wc.rewrite((Tree)vt, (Tree)newVt);
                    }
                }).commit();
            }
            return null;
        }
    }
}

