/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import nu.validator.checker.AttributeUtil;
import nu.validator.checker.Checker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UnsupportedFeatureChecker
extends Checker {
    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" != uri) {
            return;
        }
        if (atts.getIndex("", "contextmenu") > -1) {
            this.warn("The \u201ccontextmenu\u201d attribute is not supported by browsers yet. It would probably be better to wait for implementations.");
        }
        if (atts.getIndex("", "dropzone") > -1) {
            this.warn("The \u201cdropzone\u201d attribute is not supported by browsers yet. It would probably be better to wait for implementations.");
        }
        if ("menu" == localName) {
            this.warn("The \u201cmenu\u201d element is not supported by browsers yet. It would probably be better to wait for implementations.");
        } else if ("dialog" == localName) {
            this.warn("The \u201cdialog\u201d element is not supported by browsers yet. It would probably be better to wait for implementations.");
        } else if ("details" == localName) {
            this.warn("The \u201cdetails\u201d element is not supported properly by browsers yet. It would probably be better to wait for implementations.");
        } else if ("bdi" == localName) {
            this.warn("The \u201cbdi\u201d element is not supported by browsers yet.");
        } else if ("video" == localName) {
            if (atts.getIndex("", "mediagroup") > -1) {
                this.warn("The \u201cmediagroup\u201d attribute on the \u201cvideo\u201d element is not supported by browsers yet. It would probably be better to wait for implementations.");
            }
        } else if ("audio" == localName) {
            if (atts.getIndex("", "mediagroup") > -1) {
                this.warn("The \u201cmediagroup\u201d attribute on the \u201caudio\u201d element is not supported by browsers yet. It would probably be better to wait for implementations.");
            }
        } else if ("iframe" == localName) {
            if (atts.getIndex("", "seamless") > -1) {
                this.warn("The \u201cseamless\u201d attribute on the \u201ciframe\u201d element is not supported by browsers yet. It would probably be better to wait for implementations.");
            }
        } else if ("textarea" == localName) {
            if (atts.getIndex("", "dirname") > -1) {
                this.warn("The \u201cdirname\u201d attribute on the \u201ctextarea\u201d element is not supported by browsers yet.");
            }
            if (atts.getIndex("", "inputmode") > -1) {
                this.warn("The \u201cinputmode\u201d attribute is not widely supported in browsers.");
            }
        } else if ("input" == localName) {
            String type;
            if (atts.getIndex("", "dirname") > -1) {
                this.warn("The \u201cdirname\u201d attribute on the \u201cinput\u201d element is not supported by browsers yet.");
            }
            if (atts.getIndex("", "inputmode") > -1) {
                this.warn("The \u201cinputmode\u201d attribute is not widely supported in browsers.");
            }
            if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("datetime", type = atts.getValue("", "type"))) {
                this.warn("The \u201cdatetime\u201d input type is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("date", type)) {
                this.warn("The \u201cdate\u201d input type is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("month", type)) {
                this.warn("The \u201cmonth\u201d input type is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("week", type)) {
                this.warn("The \u201cweek\u201d input type is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("time", type)) {
                this.warn("The \u201ctime\u201d input type is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("datetime-local", type)) {
                this.warn("The \u201cdatetime-local\u201d input type is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("color", type)) {
                this.warn("The \u201ccolor\u201d input type is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
            }
        }
    }
}

