/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2se;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.nbimpl.project.JavaProjectProfilingSupportProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;

public class J2SEProjectProfilingSupportProvider
extends JavaProjectProfilingSupportProvider {
    private static final Logger LOG = Logger.getLogger(J2SEProjectProfilingSupportProvider.class.getName());

    public org.netbeans.modules.profiler.api.JavaPlatform resolveProjectJavaPlatform() {
        PropertyEvaluator props = J2SEProjectProfilingSupportProvider.getProjectProperties(this.getProject());
        String platformName = props.getProperty("platform.runtime");
        if (platformName == null || platformName.isEmpty()) {
            platformName = props.getProperty("platform.active");
        }
        if (platformName == null) {
            return null;
        }
        return org.netbeans.modules.profiler.api.JavaPlatform.getJavaPlatformById((String)platformName);
    }

    public void setupProjectSessionSettings(SessionSettings ss) {
        PropertyEvaluator pp = J2SEProjectProfilingSupportProvider.getProjectProperties(this.getProject());
        this.setMainClass(pp, ss);
        String appArgs = pp.getProperty("application.args");
        ss.setMainArgs(appArgs != null ? appArgs : "");
        String runCP = pp.getProperty("run.classpath");
        ss.setMainClassPath(runCP != null ? runCP : "");
        String jvmArgs = pp.getProperty("run.jvmargs");
        ss.setJVMArgs(jvmArgs != null ? jvmArgs : "");
        String host = J2SEProjectProfilingSupportProvider.getRemotePlatformHost(this.getProjectJavaPlatform());
        if (host != null) {
            ss.setRemoteHost(host);
        }
        super.setupProjectSessionSettings(ss);
    }

    protected void setMainClass(PropertyEvaluator pp, SessionSettings ss) {
        String mainClass = pp.getProperty("main.class");
        ss.setMainClass(mainClass != null ? mainClass : "");
    }

    private static String getRemotePlatformHost(org.netbeans.modules.profiler.api.JavaPlatform platform) {
        for (JavaPlatform jp : JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se-remote", null))) {
            if (!platform.getPlatformId().equals(jp.getProperties().get("platform.ant.name"))) continue;
            return (String)jp.getProperties().get("platform.host");
        }
        return null;
    }

    static PropertyEvaluator getProjectProperties(Project project) {
        final Properties privateProps = new Properties();
        final Properties projectProps = new Properties();
        final Properties userPropsProps = new Properties();
        final Properties configProps = new Properties();
        final FileObject privatePropsFile = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final FileObject projectPropsFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final File userPropsFile = InstalledFileLocator.getDefault().locate("build.properties", null, false);
        final FileObject configPropsFile = project.getProjectDirectory().getFileObject("nbproject/private/config.properties");
        final FileObject configPropsDir = project.getProjectDirectory().getFileObject("nbproject/configs");
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block30: {
                    InputStream is;
                    if (privatePropsFile != null) {
                        try {
                            is = privatePropsFile.getInputStream();
                            try {
                                privateProps.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            LOG.log(Level.INFO, null, e);
                        }
                    }
                    if (projectPropsFile != null) {
                        try {
                            is = projectPropsFile.getInputStream();
                            try {
                                projectProps.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            LOG.log(Level.INFO, null, e);
                        }
                    }
                    if (userPropsFile != null) {
                        try {
                            is = new BufferedInputStream(new FileInputStream(userPropsFile));
                            try {
                                userPropsProps.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            LOG.log(Level.INFO, null, e);
                        }
                    }
                    if (configPropsDir != null && configPropsFile != null) {
                        try {
                            is = configPropsFile.getInputStream();
                            Properties activeConfigProps = new Properties();
                            try {
                                FileObject configSpecPropFile;
                                activeConfigProps.load(is);
                                String activeConfig = activeConfigProps.getProperty("config");
                                if (activeConfig == null || activeConfig.length() <= 0 || (configSpecPropFile = configPropsDir.getFileObject(activeConfig + ".properties")) == null) break block30;
                                InputStream configSpecIn = configSpecPropFile.getInputStream();
                                try {
                                    configProps.load(configSpecIn);
                                }
                                finally {
                                    configSpecIn.close();
                                }
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            LOG.log(Level.INFO, null, e);
                        }
                    }
                }
            }
        });
        PropertyEvaluator pe = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{new MyPropertyProvider(configProps), new MyPropertyProvider(privateProps), new MyPropertyProvider(userPropsProps), new MyPropertyProvider(projectProps)});
        return pe;
    }

    public J2SEProjectProfilingSupportProvider(Project project) {
        super(project);
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private Properties props;

        private MyPropertyProvider(Properties props) {
            this.props = props;
        }

        public Map getProperties() {
            return this.props;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

