/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.MavenConfiguration;
import org.netbeans.modules.maven.configurations.Bundle;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionProfile;
import org.netbeans.modules.maven.execute.model.NetbeansActionReader;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Writer;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public class M2Configuration
extends AbstractMavenActionsProvider
implements MavenConfiguration,
Comparable<M2Configuration> {
    private static final Logger LOG = Logger.getLogger(M2Configuration.class.getName());
    public static final String DEFAULT = "%%DEFAULT%%";
    @NonNull
    private final String id;
    private List<String> profiles;
    public static final String FILENAME = "nbactions.xml";
    public static final String FILENAME_PREFIX = "nbactions-";
    public static final String FILENAME_SUFFIX = ".xml";
    private final Map<String, String> properties = new HashMap<String, String>();
    private final FileObject projectDirectory;
    private final AtomicBoolean resetCache = new AtomicBoolean(false);
    private FileChangeListener listener = null;

    public static M2Configuration createDefault(FileObject projectDirectory) {
        return new M2Configuration(DEFAULT, projectDirectory);
    }

    public M2Configuration(String id, FileObject projectDirectory) {
        assert (id != null);
        this.id = id;
        this.projectDirectory = projectDirectory;
        this.profiles = Collections.emptyList();
    }

    public String getDisplayName() {
        if (DEFAULT.equals(this.id)) {
            return Bundle.TXT_DefaultConfig();
        }
        return this.id;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public void setActivatedProfiles(List<String> profs) {
        this.profiles = profs;
    }

    @Override
    public List<String> getActivatedProfiles() {
        return this.profiles;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> props) {
        if (props == null) {
            props = Collections.emptyMap();
        }
        this.properties.clear();
        this.properties.putAll(props);
    }

    public static String getFileNameExt(String id) {
        if (DEFAULT.equals(id)) {
            return FILENAME;
        }
        return FILENAME_PREFIX + id + FILENAME_SUFFIX;
    }

    public boolean equals(Object obj) {
        return obj instanceof M2Configuration && this.id.equals(((M2Configuration)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    @Override
    public int compareTo(M2Configuration o) {
        return this.id.compareTo(o.id);
    }

    @Override
    public InputStream getActionDefinitionStream() {
        return this.getActionDefinitionStream(this.id);
    }

    final InputStream getActionDefinitionStream(String forId) {
        this.checkListener();
        FileObject fo = this.projectDirectory.getFileObject(M2Configuration.getFileNameExt(forId));
        this.resetCache.set(false);
        if (fo != null) {
            try {
                return fo.getInputStream();
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.WARNING, "Cannot read " + fo, ex);
            }
        }
        return null;
    }

    private synchronized void checkListener() {
        final String fid = M2Configuration.getFileNameExt(this.id);
        if (this.listener == null) {
            this.listener = new FileChangeAdapter(){

                public void fileRenamed(FileRenameEvent fe) {
                    if (fid.equals(fe.getName() + "." + fe.getExt())) {
                        M2Configuration.this.resetCache();
                    }
                }

                public void fileDeleted(FileEvent fe) {
                    if (fid.equals(fe.getFile().getNameExt())) {
                        M2Configuration.this.resetCache();
                    }
                }

                public void fileChanged(FileEvent fe) {
                    if (fid.equals(fe.getFile().getNameExt())) {
                        M2Configuration.this.resetCache();
                    }
                }

                public void fileDataCreated(FileEvent fe) {
                    if (fid.equals(fe.getFile().getNameExt())) {
                        M2Configuration.this.resetCache();
                    }
                }
            };
            this.projectDirectory.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)this.projectDirectory));
        }
    }

    private void resetCache() {
        this.resetCache.compareAndSet(false, true);
    }

    public NetbeansActionMapping[] getCustomMappings() {
        NetbeansActionMapping[] fallbackActions = new NetbeansActionMapping[]{};
        try {
            ArrayList<NetbeansActionMapping> toRet = new ArrayList<NetbeansActionMapping>();
            Reader read = this.performDynamicSubstitutions(Collections.emptyMap(), this.getRawMappingsAsString());
            ActionToGoalMapping mapping = this.reader.read(read);
            for (NetbeansActionMapping mapp : mapping.getActions()) {
                if (!mapp.getActionName().startsWith("CUSTOM-")) continue;
                toRet.add(mapp);
            }
            return toRet.toArray(new NetbeansActionMapping[toRet.size()]);
        }
        catch (XmlPullParserException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        return fallbackActions;
    }

    @Override
    protected boolean reloadStream() {
        return this.resetCache.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionToGoalMapping getRawMappings() {
        if (this.originalMappings == null || this.reloadStream()) {
            block21: {
                InputStreamReader rdr = null;
                InputStream in = this.getActionDefinitionStream();
                try {
                    if (in == null) {
                        in = this.getActionDefinitionStream(DEFAULT);
                        if (in != null) {
                            rdr = new InputStreamReader(in);
                            ActionToGoalMapping def = this.reader.read(rdr);
                            for (NetbeansActionProfile p : def.getProfiles()) {
                                if (!this.id.equals(p.getId())) continue;
                                ActionToGoalMapping m = new ActionToGoalMapping();
                                m.setActions(m.getActions());
                                m.setModelEncoding(m.getModelEncoding());
                                this.originalMappings = m;
                                break block21;
                            }
                            break block21;
                        }
                        this.originalMappings = new ActionToGoalMapping();
                        break block21;
                    }
                    rdr = new InputStreamReader(in);
                    this.originalMappings = this.reader.read(rdr);
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Loading raw mappings", ex);
                }
                catch (XmlPullParserException ex) {
                    LOG.log(Level.INFO, "Loading raw mappings", ex);
                }
                finally {
                    if (rdr != null) {
                        try {
                            ((Reader)rdr).close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            if (this.originalMappings == null) {
                this.originalMappings = new ActionToGoalMapping();
            }
        }
        return this.originalMappings;
    }

    public NetbeansActionMapping getProfileMappingForAction(String action, Project project, Map<String, String> replaceMap, boolean[] fallback) {
        NetbeansActionReader parsed = new NetbeansActionReader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String getRawMappingsAsString() {
                NetbeansBuildActionXpp3Writer writer = new NetbeansBuildActionXpp3Writer();
                StringWriter str = new StringWriter();
                InputStreamReader rdr = null;
                try {
                    InputStream in = M2Configuration.this.getActionDefinitionStream();
                    if (in == null) {
                        in = M2Configuration.this.getActionDefinitionStream(M2Configuration.DEFAULT);
                    }
                    if (in == null) {
                        String string = null;
                        return string;
                    }
                    rdr = new InputStreamReader(in);
                    ActionToGoalMapping map = M2Configuration.this.reader.read(rdr);
                    writer.write(str, map);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Loading raw mappings", ex);
                }
                catch (XmlPullParserException ex) {
                    LOG.log(Level.WARNING, "Loading raw mappings", ex);
                }
                finally {
                    if (rdr != null) {
                        try {
                            rdr.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                return str.toString();
            }

            @Override
            protected Reader performDynamicSubstitutions(Map<String, String> replaceMap, String in) throws IOException {
                return M2Configuration.this.performDynamicSubstitutions(replaceMap, in);
            }
        };
        NetbeansActionMapping ret = parsed.getMappingForAction(this.reader, LOG, action, null, project, this.id, replaceMap);
        if (ret == null) {
            boolean[] hasProfiles = new boolean[]{false};
            ret = parsed.getMappingForAction(this.reader, LOG, action, hasProfiles, project, null, replaceMap);
            if (fallback != null && ret != null && hasProfiles[0]) {
                fallback[0] = true;
            }
        }
        return ret;
    }

    public NetbeansActionMapping findMappingFor(Map<String, String> replaceMap, Project project, String actionName, boolean[] fallback) {
        NetbeansActionMapping action = this.getProfileMappingForAction(actionName, project, replaceMap, fallback);
        if (action != null) {
            return action;
        }
        return new NetbeansActionReader(){

            @Override
            protected String getRawMappingsAsString() {
                return M2Configuration.this.getRawMappingsAsString();
            }

            @Override
            protected Reader performDynamicSubstitutions(Map<String, String> replaceMap, String in) throws IOException {
                return M2Configuration.this.performDynamicSubstitutions(replaceMap, in);
            }
        }.getMappingForAction(this.reader, LOG, actionName, null, project, null, replaceMap);
    }
}

