/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.textmate.lexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.grammar.IToken;
import org.eclipse.tm4e.core.grammar.ITokenizeLineResult;
import org.eclipse.tm4e.core.grammar.StackElement;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.textmate.lexer.TextmateTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.TokenFactory;

public class TextmateLexer
implements Lexer<TextmateTokenId> {
    private static final Object DO_NOT_RESUME_HERE = new Object();
    private final LexerInput li;
    private final TokenFactory<TextmateTokenId> factory;
    private final IGrammar grammar;
    private int lineLen;
    private int currentOffset;
    private List<IToken> lineTokens;
    private int currentIdx;
    private StackElement state;

    public TextmateLexer(LexerInput li, Object state, TokenFactory<TextmateTokenId> factory, IGrammar grammar) {
        if (state == DO_NOT_RESUME_HERE) {
            throw new IllegalStateException("Invalid resume state!");
        }
        this.li = li;
        this.state = (StackElement)state;
        this.factory = factory;
        this.grammar = grammar;
    }

    public Token<TextmateTokenId> nextToken() {
        if (this.currentOffset >= this.lineLen) {
            int read;
            while ((read = this.li.read()) != -1 && read != 10) {
            }
            if (this.li.readLength() != 0) {
                System.err.println(this.li.readText().toString());
                this.lineLen = this.li.readText().length();
                this.currentOffset = 0;
                ITokenizeLineResult tokenized = this.grammar.tokenizeLine(this.li.readText().toString(), this.state);
                this.lineTokens = new ArrayList<IToken>(Arrays.asList(tokenized.getTokens()));
                this.currentIdx = 0;
                this.state = tokenized.getRuleStack();
            }
        }
        if (this.lineTokens != null && this.currentIdx < this.lineTokens.size()) {
            IToken current = this.lineTokens.get(this.currentIdx);
            if (this.currentOffset < current.getStartIndex()) {
                int len = current.getStartIndex() - this.currentOffset;
                this.currentOffset += len;
                return this.factory.createToken((TokenId)TextmateTokenId.UNTOKENIZED, this.lineLen - this.currentOffset);
            }
            if (this.currentOffset == current.getStartIndex()) {
                ++this.currentIdx;
                int len = current.getEndIndex() - current.getStartIndex();
                len = Math.min(len, this.lineLen - this.currentOffset);
                this.currentOffset += len;
                List categories = Collections.unmodifiableList(new ArrayList(current.getScopes()));
                return this.factory.createPropertyToken((TokenId)TextmateTokenId.TEXTMATE, len, (token, key) -> {
                    if ("categories".equals(key)) {
                        return categories;
                    }
                    return null;
                });
            }
        }
        if (this.currentOffset < this.lineLen) {
            int len = this.lineLen - this.currentOffset;
            this.currentOffset += len;
            return this.factory.createToken((TokenId)TextmateTokenId.UNTOKENIZED, len);
        }
        return null;
    }

    public Object state() {
        return this.lineLen != this.currentOffset ? DO_NOT_RESUME_HERE : this.state;
    }

    public void release() {
    }
}

