/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.jsf.palette.items.Bundle;
import org.netbeans.modules.web.jsf.palette.items.JsfLibrariesSupport;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.openide.util.Exceptions;

public class PaletteUtils {
    private PaletteUtils() {
    }

    protected static String createViewTag(JsfLibrariesSupport jls, JTextComponent jtc, boolean ending) {
        StringBuilder sb = new StringBuilder(ending ? "</" : "<");
        sb.append(jls.getLibraryPrefix(DefaultLibraryInfo.JSF_CORE));
        sb.append(":view>");
        return sb.toString();
    }

    protected static JsfLibrariesSupport getJsfLibrariesSupport(JTextComponent targetComponent) {
        AtomicBoolean cancel = new AtomicBoolean();
        JsfLibrariesGetter jsfLibrariesGetter = new JsfLibrariesGetter(targetComponent, cancel);
        ProgressUtils.runOffEventDispatchThread((Runnable)jsfLibrariesGetter, (String)Bundle.PaletteUtils_lbl_preparing_palette_component(), (AtomicBoolean)cancel, (boolean)false, (int)100, (int)3000);
        return jsfLibrariesGetter.getJsfLibrariesSupport();
    }

    private static class JsfLibrariesGetter
    implements Runnable {
        private final JTextComponent textComponent;
        private AtomicBoolean cancel;
        private volatile JsfLibrariesSupport jsfLibrariesSupport;

        public JsfLibrariesGetter(JTextComponent textComponent, AtomicBoolean cancel) {
            this.textComponent = textComponent;
            this.cancel = cancel;
        }

        @Override
        public void run() {
            try {
                ParserManager.parse(Collections.singletonList(Source.create((Document)this.textComponent.getDocument())), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        if (JsfLibrariesGetter.this.cancel.get()) {
                            return;
                        }
                        JsfLibrariesGetter.this.jsfLibrariesSupport = JsfLibrariesSupport.get(JsfLibrariesGetter.this.textComponent);
                        if (JsfLibrariesGetter.this.cancel.get()) {
                            JsfLibrariesGetter.this.jsfLibrariesSupport = null;
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public JsfLibrariesSupport getJsfLibrariesSupport() {
            return this.jsfLibrariesSupport;
        }
    }
}

