/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableProvider;
import org.openide.util.ChangeSupport;

public class TableClosure {
    private final Set<Table> tables;
    private final Set<Table> availableTables = new HashSet<Table>();
    private final Set<Table> wantedTables = new HashSet<Table>();
    private final Set<Table> selectedTables = new HashSet<Table>();
    private final Set<Table> referencedTables = new HashSet<Table>();
    private final Set<Table> unmodifAvailableTables = Collections.unmodifiableSet(this.availableTables);
    private final Set<Table> unmodifWantedTables = Collections.unmodifiableSet(this.wantedTables);
    private final Set<Table> unmodifSelectedTables = Collections.unmodifiableSet(this.selectedTables);
    private final Set<Table> unmodifReferencedTables = Collections.unmodifiableSet(this.referencedTables);
    private boolean closureEnabled = true;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public TableClosure(TableProvider tableProvider) {
        this.tables = tableProvider.getTables();
        this.availableTables.addAll(this.tables);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public Set<Table> getAvailableTables() {
        return this.unmodifAvailableTables;
    }

    public Set<Table> getSelectedTables() {
        return this.unmodifSelectedTables;
    }

    public Set<Table> getReferencedTables() {
        return this.unmodifReferencedTables;
    }

    Set<Table> getWantedTables() {
        return this.unmodifWantedTables;
    }

    public void addTables(Set<Table> tables) {
        if (!this.canAddAllTables(tables)) {
            return;
        }
        if (this.closureEnabled) {
            if (this.wantedTables.addAll(tables)) {
                Set<Table> refTables = TableClosure.removeDisabledTables(this.getReferencedTablesTransitively(tables));
                HashSet<Table> addedTables = new HashSet<Table>(tables);
                addedTables.addAll(refTables);
                this.selectedTables.addAll(addedTables);
                this.referencedTables.addAll(refTables);
                this.availableTables.removeAll(addedTables);
                Set<Table> joinTables = TableClosure.removeDisabledTables(this.getJoinTablesTransitively(addedTables));
                joinTables.removeAll(this.selectedTables);
                this.selectedTables.addAll(joinTables);
                this.referencedTables.addAll(joinTables);
                this.availableTables.removeAll(joinTables);
                this.changeSupport.fireChange();
            }
        } else {
            this.wantedTables.addAll(tables);
            this.selectedTables.addAll(tables);
            this.availableTables.removeAll(tables);
            this.changeSupport.fireChange();
        }
    }

    public void removeTables(Set<Table> tables) {
        if (!this.canRemoveAllTables(tables)) {
            return;
        }
        if (this.closureEnabled) {
            if (this.wantedTables.removeAll(tables)) {
                this.redoClosure();
                this.changeSupport.fireChange();
            }
        } else {
            this.wantedTables.removeAll(tables);
            this.selectedTables.removeAll(tables);
            this.availableTables.addAll(tables);
            this.changeSupport.fireChange();
        }
    }

    public void addAllTables() {
        this.wantedTables.clear();
        for (Table table : this.tables) {
            if (table.isDisabled()) continue;
            this.wantedTables.add(table);
        }
        if (this.closureEnabled) {
            this.redoClosure();
            this.changeSupport.fireChange();
        } else {
            this.selectedTables.addAll(this.wantedTables);
            this.availableTables.addAll(this.tables);
            this.availableTables.removeAll(this.wantedTables);
            this.changeSupport.fireChange();
        }
    }

    public void removeAllTables() {
        this.wantedTables.clear();
        this.selectedTables.clear();
        this.referencedTables.clear();
        this.availableTables.addAll(this.tables);
        this.changeSupport.fireChange();
    }

    public boolean getClosureEnabled() {
        return this.closureEnabled;
    }

    public void setClosureEnabled(boolean closureEnabled) {
        if (this.closureEnabled == closureEnabled) {
            return;
        }
        this.closureEnabled = closureEnabled;
        if (closureEnabled) {
            this.redoClosure();
        } else {
            this.selectedTables.clear();
            this.selectedTables.addAll(this.wantedTables);
            this.referencedTables.clear();
            this.availableTables.addAll(this.tables);
            this.availableTables.removeAll(this.wantedTables);
        }
        this.changeSupport.fireChange();
    }

    public boolean canAddAllTables(Set<Table> tables) {
        return tables.size() > 0;
    }

    public boolean canAddSomeTables(Set<Table> tables) {
        return tables.size() > 0;
    }

    public boolean canRemoveAllTables(Set<Table> tables) {
        if (tables.size() <= 0) {
            return false;
        }
        if (!this.closureEnabled) {
            return true;
        }
        for (Table table : tables) {
            if (!this.referencedTables.contains(table)) continue;
            return false;
        }
        return true;
    }

    private void redoClosure() {
        this.referencedTables.clear();
        this.referencedTables.addAll(TableClosure.removeDisabledTables(this.getReferencedTablesTransitively(this.wantedTables)));
        this.selectedTables.clear();
        this.selectedTables.addAll(this.wantedTables);
        this.selectedTables.addAll(this.referencedTables);
        Set<Table> joinTables = TableClosure.removeDisabledTables(this.getJoinTablesTransitively(this.selectedTables));
        joinTables.removeAll(this.selectedTables);
        this.selectedTables.addAll(joinTables);
        this.referencedTables.addAll(joinTables);
        this.availableTables.clear();
        this.availableTables.addAll(this.tables);
        this.availableTables.removeAll(this.selectedTables);
    }

    private Set<Table> getReferencedTablesTransitively(Set<Table> tables) {
        Queue<Table> tableQueue = new Queue<Table>(tables);
        HashSet<Table> referencedTables = new HashSet<Table>();
        while (!tableQueue.isEmpty()) {
            Table table = tableQueue.poll();
            for (Table referencedTable : table.getReferencedTables()) {
                if (!referencedTable.equals(table)) {
                    referencedTables.add(referencedTable);
                }
                tableQueue.offer(referencedTable);
            }
        }
        return referencedTables;
    }

    private Set<Table> getJoinTablesTransitively(Set<Table> tables) {
        Queue<Table> tableQueue = new Queue<Table>(tables);
        HashSet<Table> joinTables = new HashSet<Table>();
        while (!tableQueue.isEmpty()) {
            Table table = tableQueue.poll();
            for (Table joinTable : table.getJoinTables()) {
                if (!this.areReferencedTablesSelected(joinTable, joinTables)) continue;
                joinTables.add(joinTable);
                tableQueue.offer(joinTable);
            }
        }
        return joinTables;
    }

    private boolean areReferencedTablesSelected(Table table, Set<Table> additionalTables) {
        for (Table referencedTable : table.getReferencedTables()) {
            if (this.selectedTables.contains(referencedTable) || additionalTables.contains(referencedTable)) continue;
            return false;
        }
        return true;
    }

    private static Set<Table> removeDisabledTables(Set<Table> tables) {
        Iterator<Table> i = tables.iterator();
        while (i.hasNext()) {
            Table table = i.next();
            if (!table.isDisabled() || table.getDisabledReason() instanceof Table.ExistingDisabledReason) continue;
            i.remove();
        }
        return tables;
    }

    static final class Queue<T> {
        private final List<T> queue;
        private final Set<T> contents;
        private int currentIndex;

        public Queue(Set<T> initialContents) {
            assert (!initialContents.contains(null));
            this.queue = new ArrayList<T>(initialContents);
            this.contents = new HashSet<T>(initialContents);
        }

        public void offer(T element) {
            assert (element != null);
            if (!this.contents.contains(element)) {
                this.contents.add(element);
                this.queue.add(element);
            }
        }

        public boolean isEmpty() {
            return this.currentIndex >= this.queue.size();
        }

        public T poll() {
            T result = null;
            if (!this.isEmpty()) {
                result = this.queue.get(this.currentIndex);
                ++this.currentIndex;
            }
            return result;
        }
    }
}

