/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;

public class PlainTextByLineStream
implements ObjectStream<String> {
    private final FileChannel channel;
    private final String encoding;
    private InputStreamFactory inputStreamFactory;
    private BufferedReader in;

    public PlainTextByLineStream(InputStreamFactory inputStreamFactory, String charsetName) throws IOException {
        this(inputStreamFactory, Charset.forName(charsetName));
    }

    public PlainTextByLineStream(InputStreamFactory inputStreamFactory, Charset charset) throws IOException {
        this.inputStreamFactory = inputStreamFactory;
        this.channel = null;
        this.encoding = charset.name();
        this.reset();
    }

    @Override
    public String read() throws IOException {
        return this.in.readLine();
    }

    @Override
    public void reset() throws IOException {
        if (this.inputStreamFactory != null) {
            this.in = new BufferedReader(new InputStreamReader(this.inputStreamFactory.createInputStream(), this.encoding));
        } else if (this.channel == null) {
            this.in.reset();
        } else {
            this.channel.position(0L);
            this.in = new BufferedReader(Channels.newReader((ReadableByteChannel)this.channel, this.encoding));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in != null && this.channel == null) {
            this.in.close();
        } else if (this.channel != null) {
            this.channel.close();
        }
    }
}

