/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMapBase;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenProvider;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 I2\u00020\u0001:\u0001IB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010:\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020<H\u0014J\b\u0010>\u001a\u00020<H\u0004J\b\u0010?\u001a\u00020<H\u0002J\b\u0010@\u001a\u00020<H$J\b\u0010A\u001a\u00020<H\u0002J\b\u0010B\u001a\u00020<H\u0002J\u001c\u0010C\u001a\u00020<2\n\u0010D\u001a\u0006\u0012\u0002\b\u00030E2\u0006\u0010F\u001a\u00020\u0011H$J\u0018\u0010G\u001a\u00020<2\u0006\u0010H\u001a\u00020)2\u0006\u0010F\u001a\u00020\u0011H\u0004R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0007\u001a\u00020\b8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001eR\u001a\u0010(\u001a\u00020)X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0010\u0010\t\u001a\u00020\n8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\u0004\u0018\u00010/X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00106\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u0011078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0002098\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/codegen/when/SwitchCodegen;", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "isStatement", "", "isExhaustive", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "subjectType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;ZZLorg/jetbrains/kotlin/codegen/ExpressionCodegen;Lorg/jetbrains/org/objectweb/asm/Type;)V", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "defaultLabel", "Lorg/jetbrains/org/objectweb/asm/Label;", "getDefaultLabel", "()Lorg/jetbrains/org/objectweb/asm/Label;", "setDefaultLabel", "(Lorg/jetbrains/org/objectweb/asm/Label;)V", "elseLabel", "endLabel", "entryLabels", "", "()Z", "resultKotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getResultKotlinType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "resultType", "getResultType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "subjectExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getSubjectExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "subjectKotlinType", "getSubjectKotlinType", "subjectLocal", "", "getSubjectLocal", "()I", "setSubjectLocal", "(I)V", "subjectVariable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getSubjectVariable", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "subjectVariableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "switchCodegenProvider", "Lorg/jetbrains/kotlin/codegen/when/SwitchCodegenProvider;", "transitionsTable", "Ljava/util/NavigableMap;", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "findNullEntryIndex", "generate", "", "generateEntries", "generateNullCheckIfNeeded", "generateSubjectValue", "generateSubjectValueToIndex", "generateSwitchInstructionByTransitionsTable", "prepareConfiguration", "processConstant", "constant", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "entryLabel", "putTransitionOnce", "value", "Companion", "backend"})
public abstract class SwitchCodegen {
    @NotNull
    private final BindingContext bindingContext;
    @Nullable
    private final KtProperty subjectVariable;
    @NotNull
    private final KtExpression subjectExpression;
    @NotNull
    private final KotlinType subjectKotlinType;
    @JvmField
    @NotNull
    protected final Type subjectType;
    private int subjectLocal;
    @Nullable
    private final KotlinType resultKotlinType;
    @NotNull
    private final Type resultType;
    @JvmField
    @NotNull
    protected final InstructionAdapter v;
    @JvmField
    @NotNull
    protected final NavigableMap<Integer, Label> transitionsTable;
    private final List<Label> entryLabels;
    private Label elseLabel;
    private Label endLabel;
    @NotNull
    protected Label defaultLabel;
    private final SwitchCodegenProvider switchCodegenProvider;
    private VariableDescriptor subjectVariableDescriptor;
    @JvmField
    @NotNull
    protected final KtWhenExpression expression;
    private final boolean isStatement;
    private final boolean isExhaustive;
    @JvmField
    @NotNull
    protected final ExpressionCodegen codegen;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Nullable
    protected final KtProperty getSubjectVariable() {
        return this.subjectVariable;
    }

    @NotNull
    protected final KtExpression getSubjectExpression() {
        return this.subjectExpression;
    }

    @NotNull
    protected final KotlinType getSubjectKotlinType() {
        return this.subjectKotlinType;
    }

    protected final int getSubjectLocal() {
        return this.subjectLocal;
    }

    protected final void setSubjectLocal(int n) {
        this.subjectLocal = n;
    }

    @Nullable
    protected final KotlinType getResultKotlinType() {
        return this.resultKotlinType;
    }

    @NotNull
    protected final Type getResultType() {
        return this.resultType;
    }

    @NotNull
    protected final Label getDefaultLabel() {
        Label label = this.defaultLabel;
        if (label == null) {
            Intrinsics.throwUninitializedPropertyAccessException("defaultLabel");
        }
        return label;
    }

    protected final void setDefaultLabel(@NotNull Label label) {
        Intrinsics.checkParameterIsNotNull(label, "<set-?>");
        this.defaultLabel = label;
    }

    public void generate() {
        block1: {
            this.prepareConfiguration();
            boolean hasElse = this.expression.getElseExpression() != null;
            this.defaultLabel = hasElse || !this.isStatement || this.isExhaustive ? this.elseLabel : this.endLabel;
            this.generateSubjectValue();
            this.generateSubjectValueToIndex();
            Label beginLabel = new Label();
            this.v.mark(beginLabel);
            this.generateSwitchInstructionByTransitionsTable();
            this.generateEntries();
            if (!(hasElse || this.isStatement && !this.isExhaustive)) {
                this.v.visitLabel(this.elseLabel);
                this.codegen.putUnitInstanceOntoStackForNonExhaustiveWhen(this.expression, this.isStatement);
            }
            this.codegen.markLineNumber(this.expression, this.isStatement);
            this.v.mark(this.endLabel);
            VariableDescriptor variableDescriptor = this.subjectVariableDescriptor;
            if (variableDescriptor == null) break block1;
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            VariableDescriptor it = variableDescriptor2;
            boolean bl3 = false;
            this.codegen.getFrameMap().leave(it);
            this.v.visitLocalVariable(it.getName().asString(), this.subjectType.getDescriptor(), null, beginLabel, this.endLabel, this.subjectLocal);
        }
    }

    private final void prepareConfiguration() {
        for (KtWhenEntry entry : this.expression.getEntries()) {
            Label entryLabel = new Label();
            KtWhenEntry ktWhenEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktWhenEntry, "entry");
            for (ConstantValue<?> constant : this.switchCodegenProvider.getConstantsFromEntry(ktWhenEntry)) {
                if (constant instanceof NullValue || constant == null) continue;
                this.processConstant(constant, entryLabel);
            }
            if (entry.isElse()) {
                this.elseLabel = entryLabel;
            }
            this.entryLabels.add(entryLabel);
        }
    }

    protected abstract void processConstant(@NotNull ConstantValue<?> var1, @NotNull Label var2);

    protected final void putTransitionOnce(int value, @NotNull Label entryLabel) {
        Intrinsics.checkParameterIsNotNull(entryLabel, "entryLabel");
        if (!this.transitionsTable.containsKey(value)) {
            ((Map)this.transitionsTable).put(value, entryLabel);
        }
    }

    private final void generateSubjectValue() {
        if (this.subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)this.bindingContext.get(BindingContext.VARIABLE, this.subjectVariable);
            if (variableDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Unresolved subject variable: " + this.expression)));
            }
            VariableDescriptor mySubjectVariable = variableDescriptor;
            this.subjectLocal = this.codegen.getFrameMap().enter(mySubjectVariable, this.subjectType);
            this.codegen.visitProperty(this.subjectVariable, null);
            StackValue.local(this.subjectLocal, this.subjectType, this.subjectKotlinType).put(this.subjectType, this.subjectKotlinType, this.codegen.v);
            this.subjectVariableDescriptor = mySubjectVariable;
        } else {
            this.codegen.gen(this.subjectExpression, this.subjectType, this.subjectKotlinType);
            this.subjectVariableDescriptor = null;
        }
    }

    protected abstract void generateSubjectValueToIndex();

    protected final void generateNullCheckIfNeeded() {
        if (TypeUtils.isNullableType(this.subjectKotlinType)) {
            Label label;
            int nullEntryIndex = this.findNullEntryIndex(this.expression);
            if (nullEntryIndex == -1) {
                label = this.defaultLabel;
                if (label == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("defaultLabel");
                }
            } else {
                label = this.entryLabels.get(nullEntryIndex);
            }
            Label nullLabel = label;
            Label notNullLabel = new Label();
            InstructionAdapter instructionAdapter = this.v;
            boolean bl = false;
            boolean bl2 = false;
            InstructionAdapter $this$with = instructionAdapter;
            boolean bl3 = false;
            $this$with.dup();
            $this$with.ifnonnull(notNullLabel);
            $this$with.pop();
            $this$with.goTo(nullLabel);
            $this$with.visitLabel(notNullLabel);
        }
    }

    private final int findNullEntryIndex(KtWhenExpression expression2) {
        IndexedValue indexedValue;
        block5: {
            List<KtWhenEntry> list2 = expression2.getEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, "expression.entries");
            Iterable $this$firstOrNull$iv = CollectionsKt.withIndex((Iterable)list2);
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                IndexedValue element$iv;
                block4: {
                    KtWhenEntry entry;
                    IndexedValue $dstr$_u24__u24$entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    KtWhenEntry ktWhenEntry = entry = (KtWhenEntry)$dstr$_u24__u24$entry.component2();
                    Intrinsics.checkExpressionValueIsNotNull(ktWhenEntry, "entry");
                    Iterable<ConstantValue<?>> $this$any$iv = this.switchCodegenProvider.getConstantsFromEntry(ktWhenEntry);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<ConstantValue<?>> iterator3 = $this$any$iv.iterator();
                        while (iterator3.hasNext()) {
                            ConstantValue<?> element$iv2;
                            ConstantValue<?> it = element$iv2 = iterator3.next();
                            boolean bl3 = false;
                            if (!(it instanceof NullValue)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                indexedValue = element$iv;
                break block5;
            }
            indexedValue = null;
        }
        IndexedValue indexedValue2 = indexedValue;
        return indexedValue2 != null ? indexedValue2.getIndex() : -1;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSwitchInstructionByTransitionsTable() {
        Set set = this.transitionsTable.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "transitionsTable.keys");
        int[] keys = CollectionsKt.toIntArray(set);
        int labelsNumber = keys.length;
        int maxValue = ArraysKt.last(keys);
        int minValue = ArraysKt.first(keys);
        long rangeLength = (long)maxValue - (long)minValue + 1L;
        if (Companion.preferLookupOverSwitch(labelsNumber, rangeLength)) {
            Collection collection = this.transitionsTable.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, "transitionsTable.values");
            Collection $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            Collection collection2 = $this$toTypedArray$iv;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection2;
            Label[] labelArray = thisCollection$iv.toArray(new Label[0]);
            if (labelArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Label[] labels2 = labelArray;
            Label label = this.defaultLabel;
            if (label == null) {
                Intrinsics.throwUninitializedPropertyAccessException("defaultLabel");
            }
            this.v.lookupswitch(label, keys, labels2);
            return;
        }
        int n = (int)rangeLength;
        Label[] labelArray = new Label[n];
        for (int i = 0; i < n; ++i) {
            Label label;
            void index2;
            int n2 = i;
            int n3 = i;
            Label[] labelArray2 = labelArray;
            boolean bl = false;
            Label label2 = (Label)this.transitionsTable.get((int)(index2 + minValue));
            if (label2 == null && (label2 = this.defaultLabel) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("defaultLabel");
            }
            labelArray2[n3] = label = label2;
        }
        Label[] sparseLabels = labelArray;
        Label label = this.defaultLabel;
        if (label == null) {
            Intrinsics.throwUninitializedPropertyAccessException("defaultLabel");
        }
        this.v.tableswitch(minValue, maxValue, label, Arrays.copyOf(sparseLabels, sparseLabels.length));
    }

    protected void generateEntries() {
        Iterator<Label> entryLabelsIterator = this.entryLabels.iterator();
        for (KtWhenEntry entry : this.expression.getEntries()) {
            this.v.visitLabel(entryLabelsIterator.next());
            FrameMapBase.Mark mark = this.codegen.myFrameMap.mark();
            KtWhenEntry ktWhenEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktWhenEntry, "entry");
            this.codegen.gen(ktWhenEntry.getExpression(), this.resultType, this.resultKotlinType);
            mark.dropTo();
            if (entry.isElse()) continue;
            this.v.goTo(this.endLabel);
        }
    }

    protected final boolean isStatement() {
        return this.isStatement;
    }

    public SwitchCodegen(@NotNull KtWhenExpression expression2, boolean isStatement, boolean isExhaustive, @NotNull ExpressionCodegen codegen2, @Nullable Type subjectType) {
        Type type2;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(codegen2, "codegen");
        this.expression = expression2;
        this.isStatement = isStatement;
        this.isExhaustive = isExhaustive;
        this.codegen = codegen2;
        BindingContext bindingContext = this.codegen.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "codegen.bindingContext");
        this.bindingContext = bindingContext;
        this.subjectVariable = this.expression.getSubjectVariable();
        KtExpression ktExpression = this.expression.getSubjectExpression();
        if (ktExpression == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No subject expression: " + this.expression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression.subjectExpres\u2026ion: ${expression.text}\")");
        this.subjectExpression = ktExpression;
        KotlinType kotlinType2 = WhenChecker.INSTANCE.whenSubjectTypeWithoutSmartCasts(this.expression, this.bindingContext);
        if (kotlinType2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No subject type: " + this.expression)));
        }
        this.subjectKotlinType = kotlinType2;
        Type type3 = subjectType;
        if (type3 == null) {
            Type type4 = this.codegen.asmType(this.subjectKotlinType);
            type3 = type4;
            Intrinsics.checkExpressionValueIsNotNull(type4, "codegen.asmType(subjectKotlinType)");
        }
        this.subjectType = type3;
        this.subjectLocal = -1;
        KotlinType kotlinType3 = this.resultKotlinType = !this.isStatement ? this.codegen.kotlinType(this.expression) : null;
        if (this.isStatement) {
            Type type5 = Type.VOID_TYPE;
            type2 = type5;
            Intrinsics.checkExpressionValueIsNotNull(type5, "Type.VOID_TYPE");
        } else {
            Type type6 = this.codegen.expressionType(this.expression);
            type2 = type6;
            Intrinsics.checkExpressionValueIsNotNull(type6, "codegen.expressionType(expression)");
        }
        this.resultType = type2;
        InstructionAdapter instructionAdapter = this.codegen.v;
        Intrinsics.checkExpressionValueIsNotNull(instructionAdapter, "codegen.v");
        this.v = instructionAdapter;
        this.transitionsTable = new TreeMap();
        this.entryLabels = new ArrayList();
        this.elseLabel = new Label();
        this.endLabel = new Label();
        this.switchCodegenProvider = new SwitchCodegenProvider(this.codegen);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/codegen/when/SwitchCodegen$Companion;", "", "()V", "preferLookupOverSwitch", "", "labelsNumber", "", "rangeLength", "", "backend"})
    public static final class Companion {
        public final boolean preferLookupOverSwitch(int labelsNumber, long rangeLength) {
            return rangeLength > 2L * (long)labelsNumber || rangeLength > (long)Integer.MAX_VALUE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

