/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as literal from '../../node_types/literal';
import * as wildcard from '../../node_types/wildcard';
export function getFields(node, indexPattern) {
  if (node.type === 'literal') {
    var fieldName = literal.toElasticsearchQuery(node);
    var field = indexPattern.fields.find(function (field) {
      return field.name === fieldName;
    });

    if (!field) {
      return [];
    }

    return [field];
  } else if (node.type === 'wildcard') {
    var fields = indexPattern.fields.filter(function (field) {
      return wildcard.test(node, field.name);
    });
    return fields;
  }
}