/**
 * @since 1.0.0
 */
export const identity = (a) => {
    return a;
};
/**
 * @since 1.0.0
 */
export const unsafeCoerce = identity;
/**
 * @since 1.0.0
 */
export const not = (predicate) => {
    return a => !predicate(a);
};
export function or(p1, p2) {
    return a => p1(a) || p2(a);
}
/**
 * @since 1.0.0
 */
export const and = (p1, p2) => {
    return a => p1(a) && p2(a);
};
/**
 * @since 1.0.0
 */
export const constant = (a) => {
    return () => a;
};
/**
 * A thunk that returns always `true`
 *
 * @since 1.0.0
 */
export const constTrue = () => {
    return true;
};
/**
 * A thunk that returns always `false`
 *
 * @since 1.0.0
 */
export const constFalse = () => {
    return false;
};
/**
 * A thunk that returns always `null`
 *
 * @since 1.0.0
 */
export const constNull = () => {
    return null;
};
/**
 * A thunk that returns always `undefined`
 *
 * @since 1.0.0
 */
export const constUndefined = () => {
    return;
};
/**
 * A thunk that returns always `void`
 *
 * @since 1.14.0
 */
export const constVoid = () => {
    return;
};
/**
 * Flips the order of the arguments to a function of two arguments.
 *
 * @since 1.0.0
 */
export const flip = (f) => {
    return b => a => f(a)(b);
};
/**
 * The `on` function is used to change the domain of a binary operator.
 *
 * @since 1.0.0
 */
export const on = (op) => (f) => {
    return (x, y) => op(f(x), f(y));
};
export function compose(...fns) {
    const len = fns.length - 1;
    return function (x) {
        let y = x;
        for (let i = len; i > -1; i--) {
            y = fns[i].call(this, y);
        }
        return y;
    };
}
export function pipe(...fns) {
    const len = fns.length - 1;
    return function (x) {
        let y = x;
        for (let i = 0; i <= len; i++) {
            y = fns[i].call(this, y);
        }
        return y;
    };
}
/**
 * @since 1.0.0
 */
export const concat = (x, y) => {
    const lenx = x.length;
    const leny = y.length;
    const r = Array(lenx + leny);
    for (let i = 0; i < lenx; i++) {
        r[i] = x[i];
    }
    for (let i = 0; i < leny; i++) {
        r[i + lenx] = y[i];
    }
    return r;
};
/**
 * @since 1.0.0
 */
export function curried(f, n, acc) {
    return function (x) {
        const combined = concat(acc, [x]);
        return n === 0 ? f.apply(this, combined) : curried(f, n - 1, combined);
    };
}
export function curry(f) {
    return curried(f, f.length - 1, []);
}
/* tslint:disable-next-line */
const getFunctionName = (f) => f.displayName || f.name || `<function${f.length}>`;
/**
 * @since 1.0.0
 */
export const toString = (x) => {
    if (typeof x === 'string') {
        return JSON.stringify(x);
    }
    if (x instanceof Date) {
        return `new Date('${x.toISOString()}')`;
    }
    if (Array.isArray(x)) {
        return `[${x.map(toString).join(', ')}]`;
    }
    if (typeof x === 'function') {
        return getFunctionName(x);
    }
    if (x == null) {
        return String(x);
    }
    if (typeof x.toString === 'function' && x.toString !== Object.prototype.toString) {
        return x.toString();
    }
    try {
        return JSON.stringify(x, null, 2);
    }
    catch (e) {
        return String(x);
    }
};
/**
 * @since 1.0.0
 */
export const tuple = (...t) => {
    return t;
};
/**
 * @since 1.0.0
 * @deprecated
 */
export const tupleCurried = (a) => (b) => {
    return [a, b];
};
/**
 * Applies a function to an argument ($)
 *
 * @since 1.0.0
 */
export const apply = (f) => (a) => {
    return f(a);
};
/**
 * Applies an argument to a function (#)
 *
 * @since 1.0.0
 */
export const applyFlipped = (a) => (f) => {
    return f(a);
};
/**
 * For use with phantom fields
 *
 * @since 1.0.0
 */
export const phantom = undefined;
/**
 * A thunk that returns always the `identity` function.
 * For use with `applySecond` methods.
 *
 * @since 1.5.0
 */
export const constIdentity = () => {
    return identity;
};
/**
 * @since 1.9.0
 */
export const increment = (n) => {
    return n + 1;
};
/**
 * @since 1.9.0
 */
export const decrement = (n) => {
    return n - 1;
};
