var documenterSearchIndex = {"docs": [

{
    "location": "index.html#",
    "page": "Home",
    "title": "Home",
    "category": "page",
    "text": "io = IOBuffer()\nrelease = isempty(VERSION.prerelease)\nv = \"$(VERSION.major).$(VERSION.minor)\"\n!release && (v = v*\"-$(first(VERSION.prerelease))\")\nprint(io, \"\"\"\n    # Julia $(v) Documentation\n\n    Welcome to the documentation for Julia $(v).\n\n    \"\"\")\nif !release\n    print(io,\"\"\"\n        !!! warning \"Work in progress!\"\n            This documentation is for an unreleased, in-development, version of Julia.\n        \"\"\")\nend\nimport Markdown\nMarkdown.parse(String(take!(io)))Please read the release notes to see what has changed since the last release.release = isempty(VERSION.prerelease)\nfile = release ? \"julia-$(VERSION).pdf\" :\n       \"julia-$(VERSION.major).$(VERSION.minor).$(VERSION.patch)-$(first(VERSION.prerelease)).pdf\"\nurl = \"https://raw.githubusercontent.com/JuliaLang/docs.julialang.org/assets/$(file)\"\nimport Markdown\nMarkdown.parse(\"\"\"\n!!! note\n    The documentation is also available in PDF format: [$file]($url).\n\"\"\")"
},

{
    "location": "index.html#man-introduction-1",
    "page": "Home",
    "title": "Introduction",
    "category": "section",
    "text": "Scientific computing has traditionally required the highest performance, yet domain experts have largely moved to slower dynamic languages for daily work. We believe there are many good reasons to prefer dynamic languages for these applications, and we do not expect their use to diminish. Fortunately, modern language design and compiler techniques make it possible to mostly eliminate the performance trade-off and provide a single environment productive enough for prototyping and efficient enough for deploying performance-intensive applications. The Julia programming language fills this role: it is a flexible dynamic language, appropriate for scientific and numerical computing, with performance comparable to traditional statically-typed languages.Because Julia\'s compiler is different from the interpreters used for languages like Python or R, you may find that Julia\'s performance is unintuitive at first. If you find that something is slow, we highly recommend reading through the Performance Tips section before trying anything else. Once you understand how Julia works, it\'s easy to write code that\'s nearly as fast as C.Julia features optional typing, multiple dispatch, and good performance, achieved using type inference and just-in-time (JIT) compilation, implemented using LLVM. It is multi-paradigm, combining features of imperative, functional, and object-oriented programming. Julia provides ease and expressiveness for high-level numerical computing, in the same way as languages such as R, MATLAB, and Python, but also supports general programming. To achieve this, Julia builds upon the lineage of mathematical programming languages, but also borrows much from popular dynamic languages, including Lisp, Perl, Python, Lua, and Ruby.The most significant departures of Julia from typical dynamic languages are:The core language imposes very little; Julia Base and the standard library is written in Julia itself, including primitive operations like integer arithmetic\nA rich language of types for constructing and describing objects, that can also optionally be used to make type declarations\nThe ability to define function behavior across many combinations of argument types via multiple dispatch\nAutomatic generation of efficient, specialized code for different argument types\nGood performance, approaching that of statically-compiled languages like CAlthough one sometimes speaks of dynamic languages as being \"typeless\", they are definitely not: every object, whether primitive or user-defined, has a type. The lack of type declarations in most dynamic languages, however, means that one cannot instruct the compiler about the types of values, and often cannot explicitly talk about types at all. In static languages, on the other hand, while one can – and usually must – annotate types for the compiler, types exist only at compile time and cannot be manipulated or expressed at run time. In Julia, types are themselves run-time objects, and can also be used to convey information to the compiler.While the casual programmer need not explicitly use types or multiple dispatch, they are the core unifying features of Julia: functions are defined on different combinations of argument types, and applied by dispatching to the most specific matching definition. This model is a good fit for mathematical programming, where it is unnatural for the first argument to \"own\" an operation as in traditional object-oriented dispatch. Operators are just functions with special notation – to extend addition to new user-defined data types, you define new methods for the + function. Existing code then seamlessly applies to the new data types.Partly because of run-time type inference (augmented by optional type annotations), and partly because of a strong focus on performance from the inception of the project, Julia\'s computational efficiency exceeds that of other dynamic languages, and even rivals that of statically-compiled languages. For large scale numerical problems, speed always has been, continues to be, and probably always will be crucial: the amount of data being processed has easily kept pace with Moore\'s Law over the past decades.Julia aims to create an unprecedented combination of ease-of-use, power, and efficiency in a single language. In addition to the above, some advantages of Julia over comparable systems include:Free and open source (MIT licensed)\nUser-defined types are as fast and compact as built-ins\nNo need to vectorize code for performance; devectorized code is fast\nDesigned for parallelism and distributed computation\nLightweight \"green\" threading (coroutines)\nUnobtrusive yet powerful type system\nElegant and extensible conversions and promotions for numeric and other types\nEfficient support for Unicode, including but not limited to UTF-8\nCall C functions directly (no wrappers or special APIs needed)\nPowerful shell-like capabilities for managing other processes\nLisp-like macros and other metaprogramming facilities"
},

{
    "location": "NEWS.html#",
    "page": "Julia v1.1 Release Notes",
    "title": "Julia v1.1 Release Notes",
    "category": "page",
    "text": ""
},

{
    "location": "NEWS.html#Julia-v1.1-Release-Notes-1",
    "page": "Julia v1.1 Release Notes",
    "title": "Julia v1.1 Release Notes",
    "category": "section",
    "text": ""
},

{
    "location": "NEWS.html#New-language-features-1",
    "page": "Julia v1.1 Release Notes",
    "title": "New language features",
    "category": "section",
    "text": "An exception stack is maintained on each task to make exception handling more robust and enable root cause analysis. The stack may be accessed using the experimental function Base.catch_stack (#28878).\nThe experimental macro Base.@locals returns a dictionary of current local variable names and values (#29733).\nBinary ~ can now be dotted, as in x .~ y (#30341)."
},

{
    "location": "NEWS.html#Language-changes-1",
    "page": "Julia v1.1 Release Notes",
    "title": "Language changes",
    "category": "section",
    "text": "Parser inputs ending with a comma are now consistently treated as incomplete. Previously they were sometimes parsed as tuples, depending on whitespace (#28506).\nSpaces were accidentally allowed in broadcast call syntax, e.g. f. (x). They are now disallowed, consistent with normal function call syntax (#29781).\nBig integer literals and command syntax (backticks) are now parsed with the name of the macro (@int128_str, @uint128_str, @big_str, @cmd) qualified to refer to the Core module (#29968).\nUsing the same name for both a local variable and a static parameter is now an error instead of a warning (#29429).\nfindall(in(b), a) now returns a CartesianIndex when a is a matrix or a higher-dimensional array, for consistency with other findall methods. Use LinearIndices(a)[findall(in(b), a)] to get the old behavior, or CartesianIndices(a)[findall(in(b), a)] to get the new behavior on previous Julia versions (#30226).\nfindmin(::BitArray) and findmax(::BitArray) now return a CartesianIndex when a is a matrix or a higher-dimensional array, for consistency with other array types. Use LinearIndices(a)[findmin(a)[2]] to get the old behavior, or CartesianIndices(a)[findmin(a)[2]] to get the new behavior on previous Julia versions (#30102).\nMethod signatures such as f(::Type{T}, ::T) where {T <: X} and f(::Type{X}, ::Any) are now considered ambiguous. Previously a bug caused the first one to be considered more specific in some cases (#30160)."
},

{
    "location": "NEWS.html#Command-line-option-changes-1",
    "page": "Julia v1.1 Release Notes",
    "title": "Command-line option changes",
    "category": "section",
    "text": "When a script run in interactive mode (-i) throws an error, the REPL now starts after the error is displayed. Previously the REPL only started if the script completed without error (#21233).\nThe code-coverage option now supports output in the LCOV tracefile format and gets propagated to child processes, such as precompile steps and test workers (#30381)."
},

{
    "location": "NEWS.html#New-library-functions-1",
    "page": "Julia v1.1 Release Notes",
    "title": "New library functions",
    "category": "section",
    "text": "splitpath(p::String) function, which is the opposite of joinpath(parts...): it splits a filepath into its components (#28156).\nisnothing(::Any) predicate, to check whether the argument is nothing. (#29679).\ngetpid(::Process) method (#24064).\neachrow, eachcol and eachslice functions provide efficient iterators over slices of arrays (#29749).\nfieldtypes(T::Type) which returns the declared types of the field in type T (#29600).\nuuid5 has been added to the UUIDs standard library (#28761).\nPredicates Sys.isfreebsd, Sys.isopenbsd, Sys.isnetbsd, and Sys.isdragonfly for detecting BSD systems have been added (#30249).\nInternal Base.disable_library_threading that sets libraries to use one thread. It executes function hooks that have been registered with Base.at_disable_library_threading (#30004)."
},

{
    "location": "NEWS.html#Standard-library-changes-1",
    "page": "Julia v1.1 Release Notes",
    "title": "Standard library changes",
    "category": "section",
    "text": "CartesianIndices can now be constructed from two CartesianIndexes I and J with I:J (#29440).\nCartesianIndices support broadcasting arithmetic (+ and -) with a CartesianIndex (#29890).\ncopy! support for arrays, dicts, and sets has been moved to Base from the Future package (#29173).\nChannels now convert inserted values (like containers) instead of requiring types to match (#29092).\nrange can accept the stop value as a positional argument, e.g. range(1,10,step=2) (#28708).\ndiff now supports arrays of arbitrary dimensionality and can operate over any dimension (#29827).\nThe constructor BigFloat(::BigFloat) now respects the global precision setting and always returns a BigFloat with precision equal to precision(BigFloat) (#29127). The optional precision argument to override the global setting is now a keyword instead of positional argument (#29157).\nThe use of scientific notation when printing BigFloat values is now consistent with other floating point types (#29211).\nRegex now behaves like a scalar when used in broadcasting (#29913).\nChar now behaves like a read-only 0-dimensional array (#29819).\nparse now allows strings representing integer 0 and 1 for type Bool (#29980).\nBase.tail now works on named tuples (#29595).\nThe process id is appended to malloc log files in order to track memory allocations of multiple processes (#29969).\nBase.julia_cmd now propagates the --inline=(yes|no) flag (#29858).\nBase.@kwdef can now be used for parametric structs, and for structs with supertypes (#29316).\nmerge(::NamedTuple, ::NamedTuple...) can now be used with more than 2 NamedTuples (#29259).\nNew ncodeunits(c::Char) method as a fast equivalent to ncodeunits(string(c)) (#29153).\nNew sort!(::AbstractArray; dims) method that can sort the array along the dims dimension (#28902).\nget(A::AbstractArray, (), default) now returns A[] instead of an empty array (#30270).\nparse(Bool, str) is now supported (#29997).\ncopyto!(::AbstractMatrix, ::UniformScaling) now supports rectangular matrices (#28790).\ncurrent_project() now searches the parent directories of a Git repository for a Project.toml file. This also affects the behavior of the --project command line option when using the default --project=@. (#29108).\nThe spawn API is now more flexible and supports taking IOBuffer directly as an I/O stream, converting to a system pipe as needed (#30278)."
},

{
    "location": "NEWS.html#Dates-1",
    "page": "Julia v1.1 Release Notes",
    "title": "Dates",
    "category": "section",
    "text": "New DateTime(::Date, ::Time) constructor (#29754).\nTimeZone now behaves like a scalar when used in broadcasting (#30159)."
},

{
    "location": "NEWS.html#InteractiveUtils-1",
    "page": "Julia v1.1 Release Notes",
    "title": "InteractiveUtils",
    "category": "section",
    "text": "edit can now be called on a module to edit the file that defines it (#29636).\nAll compiler-reflection tools (i.e. the code_ class of functions and macros) now print accurate line number and inlining information in a common style, and take an optional parameter (debuginfo=:default) to control the verbosity of the metadata shown (#29893)."
},

{
    "location": "NEWS.html#LinearAlgebra-1",
    "page": "Julia v1.1 Release Notes",
    "title": "LinearAlgebra",
    "category": "section",
    "text": "isdiag and isposdef for Diagonal and UniformScaling (#29638).\nmul!, rmul! and lmul! methods for UniformScaling (#29506).\nSymmetric and Hermitian matrices now preserve the wrapper when scaled with a number (#29469).\nExponentiation operator ^ now supports raising an Irrational to an AbstractMatrix power (#29782).\nAdded keyword arguments rtol, atol to pinv, nullspace and rank (#29998, #29926)."
},

{
    "location": "NEWS.html#Random-1",
    "page": "Julia v1.1 Release Notes",
    "title": "Random",
    "category": "section",
    "text": "randperm and randcycle now use the type of their argument to determine the element type of the returned array (#29670).\nA new method rand(::Tuple) implements sampling from the values of a tuple (#25278).\nserialize and deserialize now accept a filename argument, like write and read (#30151)."
},

{
    "location": "NEWS.html#SparseArrays-1",
    "page": "Julia v1.1 Release Notes",
    "title": "SparseArrays",
    "category": "section",
    "text": "sprandn now supports specifying the output element type (#30083)."
},

{
    "location": "NEWS.html#Statistics-1",
    "page": "Julia v1.1 Release Notes",
    "title": "Statistics",
    "category": "section",
    "text": "mean and var now handle more kinds of empty inputs (#29033)."
},

{
    "location": "NEWS.html#External-dependencies-1",
    "page": "Julia v1.1 Release Notes",
    "title": "External dependencies",
    "category": "section",
    "text": "7zip (bundled with Julia on Windows) has been upgraded from version 16.04 to 18.05 (#30035).\nBusybox is no longer bundled with Julia on Windows (#30022).\nOpenBLAS has been upgraded from 0.3.2 to 0.3.3 (#29845).\nThe source code for Pkg is no longer included in JuliaLang/julia. Pkg is instead downloaded during the build process (#29615).\nLLVM has been upgraded to 6.0.1 and support for LLVM < 6.0 has been dropped (#28745, #28696).\nPkg has been upgraded to version 1.1 (#30342)."
},

{
    "location": "NEWS.html#Deprecated-or-removed-1",
    "page": "Julia v1.1 Release Notes",
    "title": "Deprecated or removed",
    "category": "section",
    "text": "one(i::CartesianIndex) should be replaced with oneunit(i::CartesianIndex) (#29442).\nThe internal array Base.Grisu.DIGITS is deprecated; new code should use Base.Grisu.getbuf() to get an appropriate task-local buffer and pass it to grisu() instead (#29907).\nThe internal function Base._default_type(T) has been removed. Calls to it should be replaced with just the argument T (#29739).\npeakflops has been scheduled to move from InteractiveUtils to LinearAlgebra but is already now available as LinearAlgebra.peakflops (#29978)."
},

{
    "location": "manual/getting-started.html#",
    "page": "Getting Started",
    "title": "Getting Started",
    "category": "page",
    "text": ""
},

{
    "location": "manual/getting-started.html#man-getting-started-1",
    "page": "Getting Started",
    "title": "Getting Started",
    "category": "section",
    "text": "Julia installation is straightforward, whether using precompiled binaries or compiling from source. Download and install Julia by following the instructions at https://julialang.org/downloads/.The easiest way to learn and experiment with Julia is by starting an interactive session (also known as a read-eval-print loop or \"REPL\") by double-clicking the Julia executable or running julia from the command line:io = IOBuffer()\nBase.banner(io)\nbanner = String(take!(io))\nimport Markdown\nMarkdown.parse(\"```\\n\\$ julia\\n\\n$(banner)\\njulia> 1 + 2\\n3\\n\\njulia> ans\\n3\\n```\")To exit the interactive session, type CTRL-D (press the Control/^ key together with the d key), or type exit(). When run in interactive mode, julia displays a banner and prompts the user for input. Once the user has entered a complete expression, such as 1 + 2, and hits enter, the interactive session evaluates the expression and shows its value. If an expression is entered into an interactive session with a trailing semicolon, its value is not shown. The variable ans is bound to the value of the last evaluated expression whether it is shown or not. The ans variable is only bound in interactive sessions, not when Julia code is run in other ways.To evaluate expressions written in a source file file.jl, write include(\"file.jl\").To run code in a file non-interactively, you can give it as the first argument to the julia command:$ julia script.jl arg1 arg2...As the example implies, the following command-line arguments to julia are interpreted as command-line arguments to the program script.jl, passed in the global constant ARGS. The name of the script itself is passed in as the global PROGRAM_FILE. Note that ARGS is also set when a Julia expression is given using the -e option on the command line (see the julia help output below) but PROGRAM_FILE will be empty. For example, to just print the arguments given to a script, you could do this:$ julia -e \'println(PROGRAM_FILE); for x in ARGS; println(x); end\' foo bar\n\nfoo\nbarOr you could put that code into a script and run it:$ echo \'println(PROGRAM_FILE); for x in ARGS; println(x); end\' > script.jl\n$ julia script.jl foo bar\nscript.jl\nfoo\nbarThe -- delimiter can be used to separate command-line arguments intended for the script file from arguments intended for Julia:$ julia --color=yes -O -- foo.jl arg1 arg2..See also Scripting for more information on writing Julia scripts.Julia can be started in parallel mode with either the -p or the --machine-file options. -p n will launch an additional n worker processes, while --machine-file file will launch a worker for each line in file file. The machines defined in file must be accessible via a password-less ssh login, with Julia installed at the same location as the current host. Each machine definition takes the form [count*][user@]host[:port] [bind_addr[:port]]. user defaults to current user, port to the standard ssh port. count is the number of workers to spawn on the node, and defaults to 1. The optional bind-to bind_addr[:port] specifies the IP address and port that other workers should use to connect to this worker.If you have code that you want executed whenever Julia is run, you can put it in ~/.julia/config/startup.jl:$ echo \'println(\"Greetings! 你好! 안녕하세요?\")\' > ~/.julia/config/startup.jl\n$ julia\nGreetings! 你好! 안녕하세요?\n\n...There are various ways to run Julia code and provide options, similar to those available for the perl and ruby programs:julia [switches] -- [programfile] [args...]Switch Description\n-v, --version Display version information\n-h, --help Print this message\n--project[={<dir>|@.}] Set <dir> as the home project/environment. The default @. option will search through parent directories until a Project.toml or JuliaProject.toml file is found.\n-J, --sysimage <file> Start up with the given system image file\n-H, --home <dir> Set location of julia executable\n--startup-file={yes|no} Load ~/.julia/config/startup.jl\n--handle-signals={yes|no} Enable or disable Julia\'s default signal handlers\n--sysimage-native-code={yes|no} Use native code from system image if available\n--compiled-modules={yes|no} Enable or disable incremental precompilation of modules\n-e, --eval <expr> Evaluate <expr>\n-E, --print <expr> Evaluate <expr> and display the result\n-L, --load <file> Load <file> immediately on all processors\n-p, --procs {N|auto} Integer value N launches N additional local worker processes; auto launches as many workers as the number of local CPU threads (logical cores)\n--machine-file <file> Run processes on hosts listed in <file>\n-i Interactive mode; REPL runs and isinteractive() is true\n-q, --quiet Quiet startup: no banner, suppress REPL warnings\n--banner={yes|no|auto} Enable or disable startup banner\n--color={yes|no|auto} Enable or disable color text\n--history-file={yes|no} Load or save history\n--depwarn={yes|no|error} Enable or disable syntax and method deprecation warnings (error turns warnings into errors)\n--warn-overwrite={yes|no} Enable or disable method overwrite warnings\n-C, --cpu-target <target> Limit usage of CPU features up to <target>; set to help to see the available options\n-O, --optimize={0,1,2,3} Set the optimization level (default level is 2 if unspecified or 3 if used without a level)\n-g, -g <level> Enable / Set the level of debug info generation (default level is 1 if unspecified or 2 if used without a level)\n--inline={yes|no} Control whether inlining is permitted, including overriding @inline declarations\n--check-bounds={yes|no} Emit bounds checks always or never (ignoring declarations)\n--math-mode={ieee,fast} Disallow or enable unsafe floating point optimizations (overrides @fastmath declaration)\n--code-coverage={none|user|all} Count executions of source lines\n--code-coverage equivalent to --code-coverage=user\n--track-allocation={none|user|all} Count bytes allocated by each source line\n--track-allocation equivalent to --track-allocation=usercompat: Julia 1.1\nIn Julia 1.0, the default --project=@. option did not search up from the root directory of a Git repository for the Project.toml file. From Julia 1.1 forward, it does."
},

{
    "location": "manual/getting-started.html#Resources-1",
    "page": "Getting Started",
    "title": "Resources",
    "category": "section",
    "text": "A curated list of useful learning resources to help new users get started can be found on the learning page of the main Julia web site."
},

{
    "location": "manual/variables.html#",
    "page": "Variables",
    "title": "Variables",
    "category": "page",
    "text": ""
},

{
    "location": "manual/variables.html#Variables-1",
    "page": "Variables",
    "title": "Variables",
    "category": "section",
    "text": "A variable, in Julia, is a name associated (or bound) to a value. It\'s useful when you want to store a value (that you obtained after some math, for example) for later use. For example:# Assign the value 10 to the variable x\njulia> x = 10\n10\n\n# Doing math with x\'s value\njulia> x + 1\n11\n\n# Reassign x\'s value\njulia> x = 1 + 1\n2\n\n# You can assign values of other types, like strings of text\njulia> x = \"Hello World!\"\n\"Hello World!\"Julia provides an extremely flexible system for naming variables. Variable names are case-sensitive, and have no semantic meaning (that is, the language will not treat variables differently based on their names).julia> x = 1.0\n1.0\n\njulia> y = -3\n-3\n\njulia> Z = \"My string\"\n\"My string\"\n\njulia> customary_phrase = \"Hello world!\"\n\"Hello world!\"\n\njulia> UniversalDeclarationOfHumanRightsStart = \"人人生而自由，在尊严和权利上一律平等。\"\n\"人人生而自由，在尊严和权利上一律平等。\"Unicode names (in UTF-8 encoding) are allowed:julia> δ = 0.00001\n1.0e-5\n\njulia> 안녕하세요 = \"Hello\"\n\"Hello\"In the Julia REPL and several other Julia editing environments, you can type many Unicode math symbols by typing the backslashed LaTeX symbol name followed by tab. For example, the variable name δ can be entered by typing \\delta-tab, or even α̂₂ by \\alpha-tab-\\hat- tab-\\_2-tab. (If you find a symbol somewhere, e.g. in someone else\'s code, that you don\'t know how to type, the REPL help will tell you: just type ? and then paste the symbol.)Julia will even let you redefine built-in constants and functions if needed (although this is not recommended to avoid potential confusions):julia> pi = 3\n3\n\njulia> pi\n3\n\njulia> sqrt = 4\n4However, if you try to redefine a built-in constant or function already in use, Julia will give you an error:julia> pi\nπ = 3.1415926535897...\n\njulia> pi = 3\nERROR: cannot assign variable MathConstants.pi from module Main\n\njulia> sqrt(100)\n10.0\n\njulia> sqrt = 4\nERROR: cannot assign variable Base.sqrt from module Main"
},

{
    "location": "manual/variables.html#Allowed-Variable-Names-1",
    "page": "Variables",
    "title": "Allowed Variable Names",
    "category": "section",
    "text": "Variable names must begin with a letter (A-Z or a-z), underscore, or a subset of Unicode code points greater than 00A0; in particular, Unicode character categories Lu/Ll/Lt/Lm/Lo/Nl (letters), Sc/So (currency and other symbols), and a few other letter-like characters (e.g. a subset of the Sm math symbols) are allowed. Subsequent characters may also include ! and digits (0-9 and other characters in categories Nd/No), as well as other Unicode code points: diacritics and other modifying marks (categories Mn/Mc/Me/Sk), some punctuation connectors (category Pc), primes, and a few other characters.Operators like + are also valid identifiers, but are parsed specially. In some contexts, operators can be used just like variables; for example (+) refers to the addition function, and (+) = f will reassign it. Most of the Unicode infix operators (in category Sm), such as ⊕, are parsed as infix operators and are available for user-defined methods (e.g. you can use const ⊗ = kron to define ⊗ as an infix Kronecker product).  Operators can also be suffixed with modifying marks, primes, and sub/superscripts, e.g. +̂ₐ″ is parsed as an infix operator with the same precedence as +.The only explicitly disallowed names for variables are the names of built-in statements:julia> else = false\nERROR: syntax: unexpected \"else\"\n\njulia> try = \"No\"\nERROR: syntax: unexpected \"=\"Some Unicode characters are considered to be equivalent in identifiers. Different ways of entering Unicode combining characters (e.g., accents) are treated as equivalent (specifically, Julia identifiers are NFC-normalized). The Unicode characters ɛ (U+025B: Latin small letter open e) and µ (U+00B5: micro sign) are treated as equivalent to the corresponding Greek letters, because the former are easily accessible via some input methods."
},

{
    "location": "manual/variables.html#Stylistic-Conventions-1",
    "page": "Variables",
    "title": "Stylistic Conventions",
    "category": "section",
    "text": "While Julia imposes few restrictions on valid names, it has become useful to adopt the following conventions:Names of variables are in lower case.\nWord separation can be indicated by underscores (\'_\'), but use of underscores is discouraged unless the name would be hard to read otherwise.\nNames of Types and Modules begin with a capital letter and word separation is shown with upper camel case instead of underscores.\nNames of functions and macros are in lower case, without underscores.\nFunctions that write to their arguments have names that end in !. These are sometimes called \"mutating\" or \"in-place\" functions because they are intended to produce changes in their arguments after the function is called, not just return a value.For more information about stylistic conventions, see the Style Guide."
},

{
    "location": "manual/integers-and-floating-point-numbers.html#",
    "page": "Integers and Floating-Point Numbers",
    "title": "Integers and Floating-Point Numbers",
    "category": "page",
    "text": ""
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Integers-and-Floating-Point-Numbers-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Integers and Floating-Point Numbers",
    "category": "section",
    "text": "Integers and floating-point values are the basic building blocks of arithmetic and computation. Built-in representations of such values are called numeric primitives, while representations of integers and floating-point numbers as immediate values in code are known as numeric literals. For example, 1 is an integer literal, while 1.0 is a floating-point literal; their binary in-memory representations as objects are numeric primitives.Julia provides a broad range of primitive numeric types, and a full complement of arithmetic and bitwise operators as well as standard mathematical functions are defined over them. These map directly onto numeric types and operations that are natively supported on modern computers, thus allowing Julia to take full advantage of computational resources. Additionally, Julia provides software support for Arbitrary Precision Arithmetic, which can handle operations on numeric values that cannot be represented effectively in native hardware representations, but at the cost of relatively slower performance.The following are Julia\'s primitive numeric types:Integer types:Type Signed? Number of bits Smallest value Largest value\nInt8 ✓ 8 -2^7 2^7 - 1\nUInt8  8 0 2^8 - 1\nInt16 ✓ 16 -2^15 2^15 - 1\nUInt16  16 0 2^16 - 1\nInt32 ✓ 32 -2^31 2^31 - 1\nUInt32  32 0 2^32 - 1\nInt64 ✓ 64 -2^63 2^63 - 1\nUInt64  64 0 2^64 - 1\nInt128 ✓ 128 -2^127 2^127 - 1\nUInt128  128 0 2^128 - 1\nBool N/A 8 false (0) true (1)Floating-point types:Type Precision Number of bits\nFloat16 half 16\nFloat32 single 32\nFloat64 double 64Additionally, full support for Complex and Rational Numbers is built on top of these primitive numeric types. All numeric types interoperate naturally without explicit casting, thanks to a flexible, user-extensible type promotion system."
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Integers-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Integers",
    "category": "section",
    "text": "Literal integers are represented in the standard manner:julia> 1\n1\n\njulia> 1234\n1234The default type for an integer literal depends on whether the target system has a 32-bit architecture or a 64-bit architecture:# 32-bit system:\njulia> typeof(1)\nInt32\n\n# 64-bit system:\njulia> typeof(1)\nInt64The Julia internal variable Sys.WORD_SIZE indicates whether the target system is 32-bit or 64-bit:# 32-bit system:\njulia> Sys.WORD_SIZE\n32\n\n# 64-bit system:\njulia> Sys.WORD_SIZE\n64Julia also defines the types Int and UInt, which are aliases for the system\'s signed and unsigned native integer types respectively:# 32-bit system:\njulia> Int\nInt32\njulia> UInt\nUInt32\n\n# 64-bit system:\njulia> Int\nInt64\njulia> UInt\nUInt64Larger integer literals that cannot be represented using only 32 bits but can be represented in 64 bits always create 64-bit integers, regardless of the system type:# 32-bit or 64-bit system:\njulia> typeof(3000000000)\nInt64Unsigned integers are input and output using the 0x prefix and hexadecimal (base 16) digits 0-9a-f (the capitalized digits A-F also work for input). The size of the unsigned value is determined by the number of hex digits used:julia> 0x1\n0x01\n\njulia> typeof(ans)\nUInt8\n\njulia> 0x123\n0x0123\n\njulia> typeof(ans)\nUInt16\n\njulia> 0x1234567\n0x01234567\n\njulia> typeof(ans)\nUInt32\n\njulia> 0x123456789abcdef\n0x0123456789abcdef\n\njulia> typeof(ans)\nUInt64\n\njulia> 0x11112222333344445555666677778888\n0x11112222333344445555666677778888\n\njulia> typeof(ans)\nUInt128This behavior is based on the observation that when one uses unsigned hex literals for integer values, one typically is using them to represent a fixed numeric byte sequence, rather than just an integer value.Recall that the variable ans is set to the value of the last expression evaluated in an interactive session. This does not occur when Julia code is run in other ways.Binary and octal literals are also supported:julia> 0b10\n0x02\n\njulia> typeof(ans)\nUInt8\n\njulia> 0o010\n0x08\n\njulia> typeof(ans)\nUInt8\n\njulia> 0x00000000000000001111222233334444\n0x00000000000000001111222233334444\n\njulia> typeof(ans)\nUInt128As for hexadecimal literals, binary and octal literals produce unsigned integer types. The size of the binary data item is the minimal needed size, if the leading digit of the literal is not 0. In the case of leading zeros, the size is determined by the minimal needed size for a literal, which has the same length but leading digit 1. That allows the user to control the size. Values which cannot be stored in UInt128 cannot be written as such literals.Binary, octal, and hexadecimal literals may be signed by a - immediately preceding the unsigned literal. They produce an unsigned integer of the same size as the unsigned literal would do, with the two\'s complement of the value:julia> -0x2\n0xfe\n\njulia> -0x0002\n0xfffeThe minimum and maximum representable values of primitive numeric types such as integers are given by the typemin and typemax functions:julia> (typemin(Int32), typemax(Int32))\n(-2147483648, 2147483647)\n\njulia> for T in [Int8,Int16,Int32,Int64,Int128,UInt8,UInt16,UInt32,UInt64,UInt128]\n           println(\"$(lpad(T,7)): [$(typemin(T)),$(typemax(T))]\")\n       end\n   Int8: [-128,127]\n  Int16: [-32768,32767]\n  Int32: [-2147483648,2147483647]\n  Int64: [-9223372036854775808,9223372036854775807]\n Int128: [-170141183460469231731687303715884105728,170141183460469231731687303715884105727]\n  UInt8: [0,255]\n UInt16: [0,65535]\n UInt32: [0,4294967295]\n UInt64: [0,18446744073709551615]\nUInt128: [0,340282366920938463463374607431768211455]The values returned by typemin and typemax are always of the given argument type. (The above expression uses several features that have yet to be introduced, including for loops, Strings, and Interpolation, but should be easy enough to understand for users with some existing programming experience.)"
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Overflow-behavior-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Overflow behavior",
    "category": "section",
    "text": "In Julia, exceeding the maximum representable value of a given type results in a wraparound behavior:julia> x = typemax(Int64)\n9223372036854775807\n\njulia> x + 1\n-9223372036854775808\n\njulia> x + 1 == typemin(Int64)\ntrueThus, arithmetic with Julia integers is actually a form of modular arithmetic. This reflects the characteristics of the underlying arithmetic of integers as implemented on modern computers. In applications where overflow is possible, explicit checking for wraparound produced by overflow is essential; otherwise, the BigInt type in Arbitrary Precision Arithmetic is recommended instead."
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Division-errors-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Division errors",
    "category": "section",
    "text": "Integer division (the div function) has two exceptional cases: dividing by zero, and dividing the lowest negative number (typemin) by -1. Both of these cases throw a DivideError. The remainder and modulus functions (rem and mod) throw a DivideError when their second argument is zero."
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Floating-Point-Numbers-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Floating-Point Numbers",
    "category": "section",
    "text": "Literal floating-point numbers are represented in the standard formats, using E-notation when necessary:julia> 1.0\n1.0\n\njulia> 1.\n1.0\n\njulia> 0.5\n0.5\n\njulia> .5\n0.5\n\njulia> -1.23\n-1.23\n\njulia> 1e10\n1.0e10\n\njulia> 2.5e-4\n0.00025The above results are all Float64 values. Literal Float32 values can be entered by writing an f in place of e:julia> 0.5f0\n0.5f0\n\njulia> typeof(ans)\nFloat32\n\njulia> 2.5f-4\n0.00025f0Values can be converted to Float32 easily:julia> Float32(-1.5)\n-1.5f0\n\njulia> typeof(ans)\nFloat32Hexadecimal floating-point literals are also valid, but only as Float64 values, with p preceding the base-2 exponent:julia> 0x1p0\n1.0\n\njulia> 0x1.8p3\n12.0\n\njulia> 0x.4p-1\n0.125\n\njulia> typeof(ans)\nFloat64Half-precision floating-point numbers are also supported (Float16), but they are implemented in software and use Float32 for calculations.julia> sizeof(Float16(4.))\n2\n\njulia> 2*Float16(4.)\nFloat16(8.0)The underscore _ can be used as digit separator:julia> 10_000, 0.000_000_005, 0xdead_beef, 0b1011_0010\n(10000, 5.0e-9, 0xdeadbeef, 0xb2)"
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Floating-point-zero-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Floating-point zero",
    "category": "section",
    "text": "Floating-point numbers have two zeros, positive zero and negative zero. They are equal to each other but have different binary representations, as can be seen using the bitstring function:julia> 0.0 == -0.0\ntrue\n\njulia> bitstring(0.0)\n\"0000000000000000000000000000000000000000000000000000000000000000\"\n\njulia> bitstring(-0.0)\n\"1000000000000000000000000000000000000000000000000000000000000000\""
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Special-floating-point-values-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Special floating-point values",
    "category": "section",
    "text": "There are three specified standard floating-point values that do not correspond to any point on the real number line:Float16 Float32 Float64 Name Description\nInf16 Inf32 Inf positive infinity a value greater than all finite floating-point values\n-Inf16 -Inf32 -Inf negative infinity a value less than all finite floating-point values\nNaN16 NaN32 NaN not a number a value not == to any floating-point value (including itself)For further discussion of how these non-finite floating-point values are ordered with respect to each other and other floats, see Numeric Comparisons. By the IEEE 754 standard, these floating-point values are the results of certain arithmetic operations:julia> 1/Inf\n0.0\n\njulia> 1/0\nInf\n\njulia> -5/0\n-Inf\n\njulia> 0.000001/0\nInf\n\njulia> 0/0\nNaN\n\njulia> 500 + Inf\nInf\n\njulia> 500 - Inf\n-Inf\n\njulia> Inf + Inf\nInf\n\njulia> Inf - Inf\nNaN\n\njulia> Inf * Inf\nInf\n\njulia> Inf / Inf\nNaN\n\njulia> 0 * Inf\nNaNThe typemin and typemax functions also apply to floating-point types:julia> (typemin(Float16),typemax(Float16))\n(-Inf16, Inf16)\n\njulia> (typemin(Float32),typemax(Float32))\n(-Inf32, Inf32)\n\njulia> (typemin(Float64),typemax(Float64))\n(-Inf, Inf)"
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Machine-epsilon-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Machine epsilon",
    "category": "section",
    "text": "Most real numbers cannot be represented exactly with floating-point numbers, and so for many purposes it is important to know the distance between two adjacent representable floating-point numbers, which is often known as machine epsilon.Julia provides eps, which gives the distance between 1.0 and the next larger representable floating-point value:julia> eps(Float32)\n1.1920929f-7\n\njulia> eps(Float64)\n2.220446049250313e-16\n\njulia> eps() # same as eps(Float64)\n2.220446049250313e-16These values are 2.0^-23 and 2.0^-52 as Float32 and Float64 values, respectively. The eps function can also take a floating-point value as an argument, and gives the absolute difference between that value and the next representable floating point value. That is, eps(x) yields a value of the same type as x such that x + eps(x) is the next representable floating-point value larger than x:julia> eps(1.0)\n2.220446049250313e-16\n\njulia> eps(1000.)\n1.1368683772161603e-13\n\njulia> eps(1e-27)\n1.793662034335766e-43\n\njulia> eps(0.0)\n5.0e-324The distance between two adjacent representable floating-point numbers is not constant, but is smaller for smaller values and larger for larger values. In other words, the representable floating-point numbers are densest in the real number line near zero, and grow sparser exponentially as one moves farther away from zero. By definition, eps(1.0) is the same as eps(Float64) since 1.0 is a 64-bit floating-point value.Julia also provides the nextfloat and prevfloat functions which return the next largest or smallest representable floating-point number to the argument respectively:julia> x = 1.25f0\n1.25f0\n\njulia> nextfloat(x)\n1.2500001f0\n\njulia> prevfloat(x)\n1.2499999f0\n\njulia> bitstring(prevfloat(x))\n\"00111111100111111111111111111111\"\n\njulia> bitstring(x)\n\"00111111101000000000000000000000\"\n\njulia> bitstring(nextfloat(x))\n\"00111111101000000000000000000001\"This example highlights the general principle that the adjacent representable floating-point numbers also have adjacent binary integer representations."
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Rounding-modes-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Rounding modes",
    "category": "section",
    "text": "If a number doesn\'t have an exact floating-point representation, it must be rounded to an appropriate representable value. However, the manner in which this rounding is done can be changed if required according to the rounding modes presented in the IEEE 754 standard.The default mode used is always RoundNearest, which rounds to the nearest representable value, with ties rounded towards the nearest value with an even least significant bit."
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Background-and-References-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Background and References",
    "category": "section",
    "text": "Floating-point arithmetic entails many subtleties which can be surprising to users who are unfamiliar with the low-level implementation details. However, these subtleties are described in detail in most books on scientific computation, and also in the following references:The definitive guide to floating point arithmetic is the IEEE 754-2008 Standard; however, it is not available for free online.\nFor a brief but lucid presentation of how floating-point numbers are represented, see John D. Cook\'s article on the subject as well as his introduction to some of the issues arising from how this representation differs in behavior from the idealized abstraction of real numbers.\nAlso recommended is Bruce Dawson\'s series of blog posts on floating-point numbers.\nFor an excellent, in-depth discussion of floating-point numbers and issues of numerical accuracy encountered when computing with them, see David Goldberg\'s paper What Every Computer Scientist Should Know About Floating-Point Arithmetic.\nFor even more extensive documentation of the history of, rationale for, and issues with floating-point numbers, as well as discussion of many other topics in numerical computing, see the collected writings of William Kahan, commonly known as the \"Father of Floating-Point\". Of particular interest may be An Interview with the Old Man of Floating-Point."
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Arbitrary-Precision-Arithmetic-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Arbitrary Precision Arithmetic",
    "category": "section",
    "text": "To allow computations with arbitrary-precision integers and floating point numbers, Julia wraps the GNU Multiple Precision Arithmetic Library (GMP) and the GNU MPFR Library, respectively. The BigInt and BigFloat types are available in Julia for arbitrary precision integer and floating point numbers respectively.Constructors exist to create these types from primitive numerical types, and parse can be used to construct them from AbstractStrings.  Once created, they participate in arithmetic with all other numeric types thanks to Julia\'s type promotion and conversion mechanism:julia> BigInt(typemax(Int64)) + 1\n9223372036854775808\n\njulia> parse(BigInt, \"123456789012345678901234567890\") + 1\n123456789012345678901234567891\n\njulia> parse(BigFloat, \"1.23456789012345678901\")\n1.234567890123456789010000000000000000000000000000000000000000000000000000000004\n\njulia> BigFloat(2.0^66) / 3\n2.459565876494606882133333333333333333333333333333333333333333333333333333333344e+19\n\njulia> factorial(BigInt(40))\n815915283247897734345611269596115894272000000000However, type promotion between the primitive types above and BigInt/BigFloat is not automatic and must be explicitly stated.julia> x = typemin(Int64)\n-9223372036854775808\n\njulia> x = x - 1\n9223372036854775807\n\njulia> typeof(x)\nInt64\n\njulia> y = BigInt(typemin(Int64))\n-9223372036854775808\n\njulia> y = y - 1\n-9223372036854775809\n\njulia> typeof(y)\nBigIntThe default precision (in number of bits of the significand) and rounding mode of BigFloat operations can be changed globally by calling setprecision and setrounding, and all further calculations will take these changes in account.  Alternatively, the precision or the rounding can be changed only within the execution of a particular block of code by using the same functions with a do block:julia> setrounding(BigFloat, RoundUp) do\n           BigFloat(1) + parse(BigFloat, \"0.1\")\n       end\n1.100000000000000000000000000000000000000000000000000000000000000000000000000003\n\njulia> setrounding(BigFloat, RoundDown) do\n           BigFloat(1) + parse(BigFloat, \"0.1\")\n       end\n1.099999999999999999999999999999999999999999999999999999999999999999999999999986\n\njulia> setprecision(40) do\n           BigFloat(1) + parse(BigFloat, \"0.1\")\n       end\n1.1000000000004"
},

{
    "location": "manual/integers-and-floating-point-numbers.html#man-numeric-literal-coefficients-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Numeric Literal Coefficients",
    "category": "section",
    "text": "To make common numeric formulae and expressions clearer, Julia allows variables to be immediately preceded by a numeric literal, implying multiplication. This makes writing polynomial expressions much cleaner:julia> x = 3\n3\n\njulia> 2x^2 - 3x + 1\n10\n\njulia> 1.5x^2 - .5x + 1\n13.0It also makes writing exponential functions more elegant:julia> 2^2x\n64The precedence of numeric literal coefficients is slightly lower than that of unary operators such as negation. So -2x is parsed as (-2) * x and √2x is parsed as (√2) * x. However, numeric literal coefficients parse similarly to unary operators when combined with exponentiation. For example 2^3x is parsed as 2^(3x), and 2x^3 is parsed as 2*(x^3).Numeric literals also work as coefficients to parenthesized expressions:julia> 2(x-1)^2 - 3(x-1) + 1\n3note: Note\nThe precedence of numeric literal coefficients used for implicit multiplication is higher than other binary operators such as multiplication (*), and division (/, \\, and //).  This means, for example, that 1 / 2im equals -0.5im and 6 // 2(2 + 1) equals 1 // 1.Additionally, parenthesized expressions can be used as coefficients to variables, implying multiplication of the expression by the variable:julia> (x-1)x\n6Neither juxtaposition of two parenthesized expressions, nor placing a variable before a parenthesized expression, however, can be used to imply multiplication:julia> (x-1)(x+1)\nERROR: MethodError: objects of type Int64 are not callable\n\njulia> x(x+1)\nERROR: MethodError: objects of type Int64 are not callableBoth expressions are interpreted as function application: any expression that is not a numeric literal, when immediately followed by a parenthetical, is interpreted as a function applied to the values in parentheses (see Functions for more about functions). Thus, in both of these cases, an error occurs since the left-hand value is not a function.The above syntactic enhancements significantly reduce the visual noise incurred when writing common mathematical formulae. Note that no whitespace may come between a numeric literal coefficient and the identifier or parenthesized expression which it multiplies."
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Syntax-Conflicts-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Syntax Conflicts",
    "category": "section",
    "text": "Juxtaposed literal coefficient syntax may conflict with two numeric literal syntaxes: hexadecimal integer literals and engineering notation for floating-point literals. Here are some situations where syntactic conflicts arise:The hexadecimal integer literal expression 0xff could be interpreted as the numeric literal 0 multiplied by the variable xff.\nThe floating-point literal expression 1e10 could be interpreted as the numeric literal 1 multiplied by the variable e10, and similarly with the equivalent E form.\nThe 32-bit floating-point literal expression 1.5f22 could be interpreted as the numeric literal 1.5 multiplied by the variable f22.In all cases the ambiguity is resolved in favor of interpretation as numeric literals:Expressions starting with 0x are always hexadecimal literals.\nExpressions starting with a numeric literal followed by e or E are always floating-point literals.\nExpressions starting with a numeric literal followed by f are always 32-bit floating-point literals.Unlike E, which is equivalent to e in numeric literals for historical reasons, F is just another letter and does not behave like f in numeric literals. Hence, expressions starting with a numeric literal followed by F are interpreted as the numerical literal multiplied by a variable, which means that, for example, 1.5F22 is equal to 1.5 * F22."
},

{
    "location": "manual/integers-and-floating-point-numbers.html#Literal-zero-and-one-1",
    "page": "Integers and Floating-Point Numbers",
    "title": "Literal zero and one",
    "category": "section",
    "text": "Julia provides functions which return literal 0 and 1 corresponding to a specified type or the type of a given variable.Function Description\nzero(x) Literal zero of type x or type of variable x\none(x) Literal one of type x or type of variable xThese functions are useful in Numeric Comparisons to avoid overhead from unnecessary type conversion.Examples:julia> zero(Float32)\n0.0f0\n\njulia> zero(1.0)\n0.0\n\njulia> one(Int32)\n1\n\njulia> one(BigFloat)\n1.0"
},

{
    "location": "manual/mathematical-operations.html#",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Mathematical Operations and Elementary Functions",
    "category": "page",
    "text": ""
},

{
    "location": "manual/mathematical-operations.html#Mathematical-Operations-and-Elementary-Functions-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Mathematical Operations and Elementary Functions",
    "category": "section",
    "text": "Julia provides a complete collection of basic arithmetic and bitwise operators across all of its numeric primitive types, as well as providing portable, efficient implementations of a comprehensive collection of standard mathematical functions."
},

{
    "location": "manual/mathematical-operations.html#Arithmetic-Operators-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Arithmetic Operators",
    "category": "section",
    "text": "The following arithmetic operators are supported on all primitive numeric types:Expression Name Description\n+x unary plus the identity operation\n-x unary minus maps values to their additive inverses\nx + y binary plus performs addition\nx - y binary minus performs subtraction\nx * y times performs multiplication\nx / y divide performs division\nx ÷ y integer divide x / y, truncated to an integer\nx \\ y inverse divide equivalent to y / x\nx ^ y power raises x to the yth power\nx % y remainder equivalent to rem(x,y)as well as the negation on Bool types:Expression Name Description\n!x negation changes true to false and vice versaJulia\'s promotion system makes arithmetic operations on mixtures of argument types \"just work\" naturally and automatically. See Conversion and Promotion for details of the promotion system.Here are some simple examples using arithmetic operators:julia> 1 + 2 + 3\n6\n\njulia> 1 - 2\n-1\n\njulia> 3*2/12\n0.5(By convention, we tend to space operators more tightly if they get applied before other nearby operators. For instance, we would generally write -x + 2 to reflect that first x gets negated, and then 2 is added to that result.)"
},

{
    "location": "manual/mathematical-operations.html#Bitwise-Operators-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Bitwise Operators",
    "category": "section",
    "text": "The following bitwise operators are supported on all primitive integer types:Expression Name\n~x bitwise not\nx & y bitwise and\nx | y bitwise or\nx ⊻ y bitwise xor (exclusive or)\nx >>> y logical shift right\nx >> y arithmetic shift right\nx << y logical/arithmetic shift leftHere are some examples with bitwise operators:julia> ~123\n-124\n\njulia> 123 & 234\n106\n\njulia> 123 | 234\n251\n\njulia> 123 ⊻ 234\n145\n\njulia> xor(123, 234)\n145\n\njulia> ~UInt32(123)\n0xffffff84\n\njulia> ~UInt8(123)\n0x84"
},

{
    "location": "manual/mathematical-operations.html#Updating-operators-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Updating operators",
    "category": "section",
    "text": "Every binary arithmetic and bitwise operator also has an updating version that assigns the result of the operation back into its left operand. The updating version of the binary operator is formed by placing a = immediately after the operator. For example, writing x += 3 is equivalent to writing x = x + 3:julia> x = 1\n1\n\njulia> x += 3\n4\n\njulia> x\n4The updating versions of all the binary arithmetic and bitwise operators are:+=  -=  *=  /=  \\=  ÷=  %=  ^=  &=  |=  ⊻=  >>>=  >>=  <<=note: Note\nAn updating operator rebinds the variable on the left-hand side. As a result, the type of the variable may change.julia> x = 0x01; typeof(x)\nUInt8\n\njulia> x *= 2 # Same as x = x * 2\n2\n\njulia> typeof(x)\nInt64"
},

{
    "location": "manual/mathematical-operations.html#man-dot-operators-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Vectorized \"dot\" operators",
    "category": "section",
    "text": "For every binary operation like ^, there is a corresponding \"dot\" operation .^ that is automatically defined to perform ^ element-by-element on arrays. For example, [1,2,3] ^ 3 is not defined, since there is no standard mathematical meaning to \"cubing\" a (non-square) array, but [1,2,3] .^ 3 is defined as computing the elementwise (or \"vectorized\") result [1^3, 2^3, 3^3].  Similarly for unary operators like ! or √, there is a corresponding .√ that applies the operator elementwise.julia> [1,2,3] .^ 3\n3-element Array{Int64,1}:\n  1\n  8\n 27More specifically, a .^ b is parsed as the \"dot\" call (^).(a,b), which performs a broadcast operation: it can combine arrays and scalars, arrays of the same size (performing the operation elementwise), and even arrays of different shapes (e.g. combining row and column vectors to produce a matrix). Moreover, like all vectorized \"dot calls,\" these \"dot operators\" are fusing. For example, if you compute 2 .* A.^2 .+ sin.(A) (or equivalently @. 2A^2 + sin(A), using the @. macro) for an array A, it performs a single loop over A, computing 2a^2 + sin(a) for each element of A. In particular, nested dot calls like f.(g.(x)) are fused, and \"adjacent\" binary operators like x .+ 3 .* x.^2 are equivalent to nested dot calls (+).(x, (*).(3, (^).(x, 2))).Furthermore, \"dotted\" updating operators like a .+= b (or @. a += b) are parsed as a .= a .+ b, where .= is a fused in-place assignment operation (see the dot syntax documentation).Note the dot syntax is also applicable to user-defined operators. For example, if you define ⊗(A,B) = kron(A,B) to give a convenient infix syntax A ⊗ B for Kronecker products (kron), then [A,B] .⊗ [C,D] will compute [A⊗C, B⊗D] with no additional coding.Combining dot operators with numeric literals can be ambiguous. For example, it is not clear whether 1.+x means 1. + x or 1 .+ x. Therefore this syntax is disallowed, and spaces must be used around the operator in such cases."
},

{
    "location": "manual/mathematical-operations.html#Numeric-Comparisons-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Numeric Comparisons",
    "category": "section",
    "text": "Standard comparison operations are defined for all the primitive numeric types:Operator Name\n== equality\n!=, ≠ inequality\n< less than\n<=, ≤ less than or equal to\n> greater than\n>=, ≥ greater than or equal toHere are some simple examples:julia> 1 == 1\ntrue\n\njulia> 1 == 2\nfalse\n\njulia> 1 != 2\ntrue\n\njulia> 1 == 1.0\ntrue\n\njulia> 1 < 2\ntrue\n\njulia> 1.0 > 3\nfalse\n\njulia> 1 >= 1.0\ntrue\n\njulia> -1 <= 1\ntrue\n\njulia> -1 <= -1\ntrue\n\njulia> -1 <= -2\nfalse\n\njulia> 3 < -0.5\nfalseIntegers are compared in the standard manner – by comparison of bits. Floating-point numbers are compared according to the IEEE 754 standard:Finite numbers are ordered in the usual manner.\nPositive zero is equal but not greater than negative zero.\nInf is equal to itself and greater than everything else except NaN.\n-Inf is equal to itself and less then everything else except NaN.\nNaN is not equal to, not less than, and not greater than anything, including itself.The last point is potentially surprising and thus worth noting:julia> NaN == NaN\nfalse\n\njulia> NaN != NaN\ntrue\n\njulia> NaN < NaN\nfalse\n\njulia> NaN > NaN\nfalseand can cause especial headaches with arrays:julia> [1 NaN] == [1 NaN]\nfalseJulia provides additional functions to test numbers for special values, which can be useful in situations like hash key comparisons:Function Tests if\nisequal(x, y) x and y are identical\nisfinite(x) x is a finite number\nisinf(x) x is infinite\nisnan(x) x is not a numberisequal considers NaNs equal to each other:julia> isequal(NaN, NaN)\ntrue\n\njulia> isequal([1 NaN], [1 NaN])\ntrue\n\njulia> isequal(NaN, NaN32)\ntrueisequal can also be used to distinguish signed zeros:julia> -0.0 == 0.0\ntrue\n\njulia> isequal(-0.0, 0.0)\nfalseMixed-type comparisons between signed integers, unsigned integers, and floats can be tricky. A great deal of care has been taken to ensure that Julia does them correctly.For other types, isequal defaults to calling ==, so if you want to define equality for your own types then you only need to add a == method.  If you define your own equality function, you should probably define a corresponding hash method to ensure that isequal(x,y) implies hash(x) == hash(y)."
},

{
    "location": "manual/mathematical-operations.html#Chaining-comparisons-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Chaining comparisons",
    "category": "section",
    "text": "Unlike most languages, with the notable exception of Python, comparisons can be arbitrarily chained:julia> 1 < 2 <= 2 < 3 == 3 > 2 >= 1 == 1 < 3 != 5\ntrueChaining comparisons is often quite convenient in numerical code. Chained comparisons use the && operator for scalar comparisons, and the & operator for elementwise comparisons, which allows them to work on arrays. For example, 0 .< A .< 1 gives a boolean array whose entries are true where the corresponding elements of A are between 0 and 1.Note the evaluation behavior of chained comparisons:julia> v(x) = (println(x); x)\nv (generic function with 1 method)\n\njulia> v(1) < v(2) <= v(3)\n2\n1\n3\ntrue\n\njulia> v(1) > v(2) <= v(3)\n2\n1\nfalseThe middle expression is only evaluated once, rather than twice as it would be if the expression were written as v(1) < v(2) && v(2) <= v(3). However, the order of evaluations in a chained comparison is undefined. It is strongly recommended not to use expressions with side effects (such as printing) in chained comparisons. If side effects are required, the short-circuit && operator should be used explicitly (see Short-Circuit Evaluation)."
},

{
    "location": "manual/mathematical-operations.html#Elementary-Functions-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Elementary Functions",
    "category": "section",
    "text": "Julia provides a comprehensive collection of mathematical functions and operators. These mathematical operations are defined over as broad a class of numerical values as permit sensible definitions, including integers, floating-point numbers, rationals, and complex numbers, wherever such definitions make sense.Moreover, these functions (like any Julia function) can be applied in \"vectorized\" fashion to arrays and other collections with the dot syntax f.(A), e.g. sin.(A) will compute the sine of each element of an array A."
},

{
    "location": "manual/mathematical-operations.html#Operator-Precedence-and-Associativity-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Operator Precedence and Associativity",
    "category": "section",
    "text": "Julia applies the following order and associativity of operations, from highest precedence to lowest:Category Operators Associativity\nSyntax . followed by :: Left\nExponentiation ^ Right\nUnary + - √ Right[1]\nBitshifts << >> >>> Left\nFractions // Left\nMultiplication * / % & \\ ÷ Left[2]\nAddition + - | ⊻ Left[2]\nSyntax : .. Left\nSyntax |> Left\nSyntax <| Right\nComparisons > < >= <= == === != !== <: Non-associative\nControl flow && followed by || followed by ? Right\nPair => Right\nAssignments = += -= *= /= //= \\= ^= ÷= %= |= &= ⊻= <<= >>= >>>= Right[1]: The unary operators + and - require explicit parentheses around their argument to disambiguate them from the operator ++, etc. Other compositions of unary operators are parsed with right-associativity, e. g., √√-a as √(√(-a)).[2]: The operators +, ++ and * are non-associative. a + b + c is parsed as +(a, b, c) not +(+(a, b), c). However, the fallback methods for +(a, b, c, d...) and *(a, b, c, d...) both default to left-associative evaluation.For a complete list of every Julia operator\'s precedence, see the top of this file: src/julia-parser.scmYou can also find the numerical precedence for any given operator via the built-in function Base.operator_precedence, where higher numbers take precedence:julia> Base.operator_precedence(:+), Base.operator_precedence(:*), Base.operator_precedence(:.)\n(11, 13, 17)\n\njulia> Base.operator_precedence(:sin), Base.operator_precedence(:+=), Base.operator_precedence(:(=))  # (Note the necessary parens on `:(=)`)\n(0, 1, 1)A symbol representing the operator associativity can also be found by calling the built-in function Base.operator_associativity:julia> Base.operator_associativity(:-), Base.operator_associativity(:+), Base.operator_associativity(:^)\n(:left, :none, :right)\n\njulia> Base.operator_associativity(:⊗), Base.operator_associativity(:sin), Base.operator_associativity(:→)\n(:left, :none, :right)Note that symbols such as :sin return precedence 0. This value represents invalid operators and not operators of lowest precedence. Similarly, such operators are assigned associativity :none."
},

{
    "location": "manual/mathematical-operations.html#Numerical-Conversions-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Numerical Conversions",
    "category": "section",
    "text": "Julia supports three forms of numerical conversion, which differ in their handling of inexact conversions.The notation T(x) or convert(T,x) converts x to a value of type T.\nIf T is a floating-point type, the result is the nearest representable value, which could be positive or negative infinity.\nIf T is an integer type, an InexactError is raised if x is not representable by T.\nx % T converts an integer x to a value of integer type T congruent to x modulo 2^n, where n is the number of bits in T. In other words, the binary representation is truncated to fit.\nThe Rounding functions take a type T as an optional argument. For example, round(Int,x) is a shorthand for Int(round(x)).The following examples show the different forms.julia> Int8(127)\n127\n\njulia> Int8(128)\nERROR: InexactError: trunc(Int8, 128)\nStacktrace:\n[...]\n\njulia> Int8(127.0)\n127\n\njulia> Int8(3.14)\nERROR: InexactError: Int8(3.14)\nStacktrace:\n[...]\n\njulia> Int8(128.0)\nERROR: InexactError: Int8(128.0)\nStacktrace:\n[...]\n\njulia> 127 % Int8\n127\n\njulia> 128 % Int8\n-128\n\njulia> round(Int8,127.4)\n127\n\njulia> round(Int8,127.6)\nERROR: InexactError: trunc(Int8, 128.0)\nStacktrace:\n[...]See Conversion and Promotion for how to define your own conversions and promotions."
},

{
    "location": "manual/mathematical-operations.html#Rounding-functions-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Rounding functions",
    "category": "section",
    "text": "Function Description Return type\nround(x) round x to the nearest integer typeof(x)\nround(T, x) round x to the nearest integer T\nfloor(x) round x towards -Inf typeof(x)\nfloor(T, x) round x towards -Inf T\nceil(x) round x towards +Inf typeof(x)\nceil(T, x) round x towards +Inf T\ntrunc(x) round x towards zero typeof(x)\ntrunc(T, x) round x towards zero T"
},

{
    "location": "manual/mathematical-operations.html#Division-functions-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Division functions",
    "category": "section",
    "text": "Function Description\ndiv(x,y), x÷y truncated division; quotient rounded towards zero\nfld(x,y) floored division; quotient rounded towards -Inf\ncld(x,y) ceiling division; quotient rounded towards +Inf\nrem(x,y) remainder; satisfies x == div(x,y)*y + rem(x,y); sign matches x\nmod(x,y) modulus; satisfies x == fld(x,y)*y + mod(x,y); sign matches y\nmod1(x,y) mod with offset 1; returns r∈(0,y] for y>0 or r∈[y,0) for y<0, where mod(r, y) == mod(x, y)\nmod2pi(x) modulus with respect to 2pi;  0 <= mod2pi(x)    < 2pi\ndivrem(x,y) returns (div(x,y),rem(x,y))\nfldmod(x,y) returns (fld(x,y),mod(x,y))\ngcd(x,y...) greatest positive common divisor of x, y,...\nlcm(x,y...) least positive common multiple of x, y,..."
},

{
    "location": "manual/mathematical-operations.html#Sign-and-absolute-value-functions-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Sign and absolute value functions",
    "category": "section",
    "text": "Function Description\nabs(x) a positive value with the magnitude of x\nabs2(x) the squared magnitude of x\nsign(x) indicates the sign of x, returning -1, 0, or +1\nsignbit(x) indicates whether the sign bit is on (true) or off (false)\ncopysign(x,y) a value with the magnitude of x and the sign of y\nflipsign(x,y) a value with the magnitude of x and the sign of x*y"
},

{
    "location": "manual/mathematical-operations.html#Powers,-logs-and-roots-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Powers, logs and roots",
    "category": "section",
    "text": "Function Description\nsqrt(x), √x square root of x\ncbrt(x), ∛x cube root of x\nhypot(x,y) hypotenuse of right-angled triangle with other sides of length x and y\nexp(x) natural exponential function at x\nexpm1(x) accurate exp(x)-1 for x near zero\nldexp(x,n) x*2^n computed efficiently for integer values of n\nlog(x) natural logarithm of x\nlog(b,x) base b logarithm of x\nlog2(x) base 2 logarithm of x\nlog10(x) base 10 logarithm of x\nlog1p(x) accurate log(1+x) for x near zero\nexponent(x) binary exponent of x\nsignificand(x) binary significand (a.k.a. mantissa) of a floating-point number xFor an overview of why functions like hypot, expm1, and log1p are necessary and useful, see John D. Cook\'s excellent pair of blog posts on the subject: expm1, log1p, erfc, and hypot."
},

{
    "location": "manual/mathematical-operations.html#Trigonometric-and-hyperbolic-functions-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Trigonometric and hyperbolic functions",
    "category": "section",
    "text": "All the standard trigonometric and hyperbolic functions are also defined:sin    cos    tan    cot    sec    csc\nsinh   cosh   tanh   coth   sech   csch\nasin   acos   atan   acot   asec   acsc\nasinh  acosh  atanh  acoth  asech  acsch\nsinc   coscThese are all single-argument functions, with atan also accepting two arguments corresponding to a traditional atan2 function.Additionally, sinpi(x) and cospi(x) are provided for more accurate computations of sin(pi*x) and cos(pi*x) respectively.In order to compute trigonometric functions with degrees instead of radians, suffix the function with d. For example, sind(x) computes the sine of x where x is specified in degrees. The complete list of trigonometric functions with degree variants is:sind   cosd   tand   cotd   secd   cscd\nasind  acosd  atand  acotd  asecd  acscd"
},

{
    "location": "manual/mathematical-operations.html#Special-functions-1",
    "page": "Mathematical Operations and Elementary Functions",
    "title": "Special functions",
    "category": "section",
    "text": "Many other special mathematical functions are provided by the package SpecialFunctions.jl."
},

{
    "location": "manual/complex-and-rational-numbers.html#",
    "page": "Complex and Rational Numbers",
    "title": "Complex and Rational Numbers",
    "category": "page",
    "text": ""
},

{
    "location": "manual/complex-and-rational-numbers.html#Complex-and-Rational-Numbers-1",
    "page": "Complex and Rational Numbers",
    "title": "Complex and Rational Numbers",
    "category": "section",
    "text": "Julia includes predefined types for both complex and rational numbers, and supports all the standard Mathematical Operations and Elementary Functions on them. Conversion and Promotion are defined so that operations on any combination of predefined numeric types, whether primitive or composite, behave as expected."
},

{
    "location": "manual/complex-and-rational-numbers.html#Complex-Numbers-1",
    "page": "Complex and Rational Numbers",
    "title": "Complex Numbers",
    "category": "section",
    "text": "The global constant im is bound to the complex number i, representing the principal square root of -1. (Using mathematicians\' i or engineers\' j for this global constant were rejected since they are such popular index variable names.) Since Julia allows numeric literals to be juxtaposed with identifiers as coefficients, this binding suffices to provide convenient syntax for complex numbers, similar to the traditional mathematical notation:julia> 1+2im\n1 + 2imYou can perform all the standard arithmetic operations with complex numbers:julia> (1 + 2im)*(2 - 3im)\n8 + 1im\n\njulia> (1 + 2im)/(1 - 2im)\n-0.6 + 0.8im\n\njulia> (1 + 2im) + (1 - 2im)\n2 + 0im\n\njulia> (-3 + 2im) - (5 - 1im)\n-8 + 3im\n\njulia> (-1 + 2im)^2\n-3 - 4im\n\njulia> (-1 + 2im)^2.5\n2.729624464784009 - 6.9606644595719im\n\njulia> (-1 + 2im)^(1 + 1im)\n-0.27910381075826657 + 0.08708053414102428im\n\njulia> 3(2 - 5im)\n6 - 15im\n\njulia> 3(2 - 5im)^2\n-63 - 60im\n\njulia> 3(2 - 5im)^-1.0\n0.20689655172413796 + 0.5172413793103449imThe promotion mechanism ensures that combinations of operands of different types just work:julia> 2(1 - 1im)\n2 - 2im\n\njulia> (2 + 3im) - 1\n1 + 3im\n\njulia> (1 + 2im) + 0.5\n1.5 + 2.0im\n\njulia> (2 + 3im) - 0.5im\n2.0 + 2.5im\n\njulia> 0.75(1 + 2im)\n0.75 + 1.5im\n\njulia> (2 + 3im) / 2\n1.0 + 1.5im\n\njulia> (1 - 3im) / (2 + 2im)\n-0.5 - 1.0im\n\njulia> 2im^2\n-2 + 0im\n\njulia> 1 + 3/4im\n1.0 - 0.75imNote that 3/4im == 3/(4*im) == -(3/4*im), since a literal coefficient binds more tightly than division.Standard functions to manipulate complex values are provided:julia> z = 1 + 2im\n1 + 2im\n\njulia> real(1 + 2im) # real part of z\n1\n\njulia> imag(1 + 2im) # imaginary part of z\n2\n\njulia> conj(1 + 2im) # complex conjugate of z\n1 - 2im\n\njulia> abs(1 + 2im) # absolute value of z\n2.23606797749979\n\njulia> abs2(1 + 2im) # squared absolute value\n5\n\njulia> angle(1 + 2im) # phase angle in radians\n1.1071487177940904As usual, the absolute value (abs) of a complex number is its distance from zero. abs2 gives the square of the absolute value, and is of particular use for complex numbers since it avoids taking a square root. angle returns the phase angle in radians (also known as the argument or arg function). The full gamut of other Elementary Functions is also defined for complex numbers:julia> sqrt(1im)\n0.7071067811865476 + 0.7071067811865475im\n\njulia> sqrt(1 + 2im)\n1.272019649514069 + 0.7861513777574233im\n\njulia> cos(1 + 2im)\n2.0327230070196656 - 3.0518977991518im\n\njulia> exp(1 + 2im)\n-1.1312043837568135 + 2.4717266720048188im\n\njulia> sinh(1 + 2im)\n-0.4890562590412937 + 1.4031192506220405imNote that mathematical functions typically return real values when applied to real numbers and complex values when applied to complex numbers. For example, sqrt behaves differently when applied to -1 versus -1 + 0im even though -1 == -1 + 0im:julia> sqrt(-1)\nERROR: DomainError with -1.0:\nsqrt will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\nStacktrace:\n[...]\n\njulia> sqrt(-1 + 0im)\n0.0 + 1.0imThe literal numeric coefficient notation does not work when constructing a complex number from variables. Instead, the multiplication must be explicitly written out:julia> a = 1; b = 2; a + b*im\n1 + 2imHowever, this is not recommended. Instead, use the more efficient complex function to construct a complex value directly from its real and imaginary parts:julia> a = 1; b = 2; complex(a, b)\n1 + 2imThis construction avoids the multiplication and addition operations.Inf and NaN propagate through complex numbers in the real and imaginary parts of a complex number as described in the Special floating-point values section:julia> 1 + Inf*im\n1.0 + Inf*im\n\njulia> 1 + NaN*im\n1.0 + NaN*im"
},

{
    "location": "manual/complex-and-rational-numbers.html#Rational-Numbers-1",
    "page": "Complex and Rational Numbers",
    "title": "Rational Numbers",
    "category": "section",
    "text": "Julia has a rational number type to represent exact ratios of integers. Rationals are constructed using the // operator:julia> 2//3\n2//3If the numerator and denominator of a rational have common factors, they are reduced to lowest terms such that the denominator is non-negative:julia> 6//9\n2//3\n\njulia> -4//8\n-1//2\n\njulia> 5//-15\n-1//3\n\njulia> -4//-12\n1//3This normalized form for a ratio of integers is unique, so equality of rational values can be tested by checking for equality of the numerator and denominator. The standardized numerator and denominator of a rational value can be extracted using the numerator and denominator functions:julia> numerator(2//3)\n2\n\njulia> denominator(2//3)\n3Direct comparison of the numerator and denominator is generally not necessary, since the standard arithmetic and comparison operations are defined for rational values:julia> 2//3 == 6//9\ntrue\n\njulia> 2//3 == 9//27\nfalse\n\njulia> 3//7 < 1//2\ntrue\n\njulia> 3//4 > 2//3\ntrue\n\njulia> 2//4 + 1//6\n2//3\n\njulia> 5//12 - 1//4\n1//6\n\njulia> 5//8 * 3//12\n5//32\n\njulia> 6//5 / 10//7\n21//25Rationals can easily be converted to floating-point numbers:julia> float(3//4)\n0.75Conversion from rational to floating-point respects the following identity for any integral values of a and b, with the exception of the case a == 0 and b == 0:julia> a = 1; b = 2;\n\njulia> isequal(float(a//b), a/b)\ntrueConstructing infinite rational values is acceptable:julia> 5//0\n1//0\n\njulia> -3//0\n-1//0\n\njulia> typeof(ans)\nRational{Int64}Trying to construct a NaN rational value, however, is invalid:julia> 0//0\nERROR: ArgumentError: invalid rational: zero(Int64)//zero(Int64)\nStacktrace:\n[...]As usual, the promotion system makes interactions with other numeric types effortless:julia> 3//5 + 1\n8//5\n\njulia> 3//5 - 0.5\n0.09999999999999998\n\njulia> 2//7 * (1 + 2im)\n2//7 + 4//7*im\n\njulia> 2//7 * (1.5 + 2im)\n0.42857142857142855 + 0.5714285714285714im\n\njulia> 3//2 / (1 + 2im)\n3//10 - 3//5*im\n\njulia> 1//2 + 2im\n1//2 + 2//1*im\n\njulia> 1 + 2//3im\n1//1 - 2//3*im\n\njulia> 0.5 == 1//2\ntrue\n\njulia> 0.33 == 1//3\nfalse\n\njulia> 0.33 < 1//3\ntrue\n\njulia> 1//3 - 0.33\n0.0033333333333332993"
},

{
    "location": "manual/strings.html#",
    "page": "Strings",
    "title": "Strings",
    "category": "page",
    "text": ""
},

{
    "location": "manual/strings.html#man-strings-1",
    "page": "Strings",
    "title": "Strings",
    "category": "section",
    "text": "Strings are finite sequences of characters. Of course, the real trouble comes when one asks what a character is. The characters that English speakers are familiar with are the letters A, B, C, etc., together with numerals and common punctuation symbols. These characters are standardized together with a mapping to integer values between 0 and 127 by the ASCII standard. There are, of course, many other characters used in non-English languages, including variants of the ASCII characters with accents and other modifications, related scripts such as Cyrillic and Greek, and scripts completely unrelated to ASCII and English, including Arabic, Chinese, Hebrew, Hindi, Japanese, and Korean. The Unicode standard tackles the complexities of what exactly a character is, and is generally accepted as the definitive standard addressing this problem. Depending on your needs, you can either ignore these complexities entirely and just pretend that only ASCII characters exist, or you can write code that can handle any of the characters or encodings that one may encounter when handling non-ASCII text. Julia makes dealing with plain ASCII text simple and efficient, and handling Unicode is as simple and efficient as possible. In particular, you can write C-style string code to process ASCII strings, and they will work as expected, both in terms of performance and semantics. If such code encounters non-ASCII text, it will gracefully fail with a clear error message, rather than silently introducing corrupt results. When this happens, modifying the code to handle non-ASCII data is straightforward.There are a few noteworthy high-level features about Julia\'s strings:The built-in concrete type used for strings (and string literals) in Julia is String. This supports the full range of Unicode characters via the UTF-8 encoding. (A transcode function is provided to convert to/from other Unicode encodings.)\nAll string types are subtypes of the abstract type AbstractString, and external packages define additional AbstractString subtypes (e.g. for other encodings).  If you define a function expecting a string argument, you should declare the type as AbstractString in order to accept any string type.\nLike C and Java, but unlike most dynamic languages, Julia has a first-class type for representing a single character, called AbstractChar. The built-in Char subtype of AbstractChar is a 32-bit primitive type that can represent any Unicode character (and which is based on the UTF-8 encoding).\nAs in Java, strings are immutable: the value of an AbstractString object cannot be changed. To construct a different string value, you construct a new string from parts of other strings.\nConceptually, a string is a partial function from indices to characters: for some index values, no character value is returned, and instead an exception is thrown. This allows for efficient indexing into strings by the byte index of an encoded representation rather than by a character index, which cannot be implemented both efficiently and simply for variable-width encodings of Unicode strings."
},

{
    "location": "manual/strings.html#man-characters-1",
    "page": "Strings",
    "title": "Characters",
    "category": "section",
    "text": "A Char value represents a single character: it is just a 32-bit primitive type with a special literal representation and appropriate arithmetic behaviors, and which can be converted to a numeric value representing a Unicode code point.  (Julia packages may define other subtypes of AbstractChar, e.g. to optimize operations for other text encodings.) Here is how Char values are input and shown:julia> \'x\'\n\'x\': ASCII/Unicode U+0078 (category Ll: Letter, lowercase)\n\njulia> typeof(ans)\nCharYou can easily convert a Char to its integer value, i.e. code point:julia> Int(\'x\')\n120\n\njulia> typeof(ans)\nInt64On 32-bit architectures, typeof(ans) will be Int32. You can convert an integer value back to a Char just as easily:julia> Char(120)\n\'x\': ASCII/Unicode U+0078 (category Ll: Letter, lowercase)Not all integer values are valid Unicode code points, but for performance, the Char conversion does not check that every character value is valid. If you want to check that each converted value is a valid code point, use the isvalid function:julia> Char(0x110000)\n\'\\U110000\': Unicode U+110000 (category In: Invalid, too high)\n\njulia> isvalid(Char, 0x110000)\nfalseAs of this writing, the valid Unicode code points are U+00 through U+d7ff and U+e000 through U+10ffff. These have not all been assigned intelligible meanings yet, nor are they necessarily interpretable by applications, but all of these values are considered to be valid Unicode characters.You can input any Unicode character in single quotes using \\u followed by up to four hexadecimal digits or \\U followed by up to eight hexadecimal digits (the longest valid value only requires six):julia> \'\\u0\'\n\'\\0\': ASCII/Unicode U+0000 (category Cc: Other, control)\n\njulia> \'\\u78\'\n\'x\': ASCII/Unicode U+0078 (category Ll: Letter, lowercase)\n\njulia> \'\\u2200\'\n\'∀\': Unicode U+2200 (category Sm: Symbol, math)\n\njulia> \'\\U10ffff\'\n\'\\U10ffff\': Unicode U+10ffff (category Cn: Other, not assigned)Julia uses your system\'s locale and language settings to determine which characters can be printed as-is and which must be output using the generic, escaped \\u or \\U input forms. In addition to these Unicode escape forms, all of C\'s traditional escaped input forms can also be used:julia> Int(\'\\0\')\n0\n\njulia> Int(\'\\t\')\n9\n\njulia> Int(\'\\n\')\n10\n\njulia> Int(\'\\e\')\n27\n\njulia> Int(\'\\x7f\')\n127\n\njulia> Int(\'\\177\')\n127You can do comparisons and a limited amount of arithmetic with Char values:julia> \'A\' < \'a\'\ntrue\n\njulia> \'A\' <= \'a\' <= \'Z\'\nfalse\n\njulia> \'A\' <= \'X\' <= \'Z\'\ntrue\n\njulia> \'x\' - \'a\'\n23\n\njulia> \'A\' + 1\n\'B\': ASCII/Unicode U+0042 (category Lu: Letter, uppercase)"
},

{
    "location": "manual/strings.html#String-Basics-1",
    "page": "Strings",
    "title": "String Basics",
    "category": "section",
    "text": "String literals are delimited by double quotes or triple double quotes:julia> str = \"Hello, world.\\n\"\n\"Hello, world.\\n\"\n\njulia> \"\"\"Contains \"quote\" characters\"\"\"\n\"Contains \\\"quote\\\" characters\"If you want to extract a character from a string, you index into it:julia> str[1]\n\'H\': ASCII/Unicode U+0048 (category Lu: Letter, uppercase)\n\njulia> str[6]\n\',\': ASCII/Unicode U+002c (category Po: Punctuation, other)\n\njulia> str[end]\n\'\\n\': ASCII/Unicode U+000a (category Cc: Other, control)Many Julia objects, including strings, can be indexed with integers. The index of the first element is returned by firstindex(str), and the index of the last element with lastindex(str). The keyword end can be used inside an indexing operation as shorthand for the last index along the given dimension. Most indexing in Julia is 1-based: the first element of many integer-indexed objects is found at index 1. (As we will see below, this does not necessarily mean that the last element is found at index n, where n is the length of the string.)You can perform arithmetic and other operations with end, just like a normal value:julia> str[end-1]\n\'.\': ASCII/Unicode U+002e (category Po: Punctuation, other)\n\njulia> str[end÷2]\n\' \': ASCII/Unicode U+0020 (category Zs: Separator, space)Using an index less than 1 or greater than end raises an error:julia> str[0]\nERROR: BoundsError: attempt to access \"Hello, world.\\n\"\n  at index [0]\n[...]\n\njulia> str[end+1]\nERROR: BoundsError: attempt to access \"Hello, world.\\n\"\n  at index [15]\nStacktrace:\n[...]You can also extract a substring using range indexing:julia> str[4:9]\n\"lo, wo\"Notice that the expressions str[k] and str[k:k] do not give the same result:julia> str[6]\n\',\': ASCII/Unicode U+002c (category Po: Punctuation, other)\n\njulia> str[6:6]\n\",\"The former is a single character value of type Char, while the latter is a string value that happens to contain only a single character. In Julia these are very different things.Range indexing makes a copy of the selected part of the original string. Alternatively, it is possible to create a view into a string using the type SubString, for example:julia> str = \"long string\"\n\"long string\"\n\njulia> substr = SubString(str, 1, 4)\n\"long\"\n\njulia> typeof(substr)\nSubString{String}Several standard functions like chop, chomp or strip return a SubString."
},

{
    "location": "manual/strings.html#Unicode-and-UTF-8-1",
    "page": "Strings",
    "title": "Unicode and UTF-8",
    "category": "section",
    "text": "Julia fully supports Unicode characters and strings. As discussed above, in character literals, Unicode code points can be represented using Unicode \\u and \\U escape sequences, as well as all the standard C escape sequences. These can likewise be used to write string literals:julia> s = \"\\u2200 x \\u2203 y\"\n\"∀ x ∃ y\"Whether these Unicode characters are displayed as escapes or shown as special characters depends on your terminal\'s locale settings and its support for Unicode. String literals are encoded using the UTF-8 encoding. UTF-8 is a variable-width encoding, meaning that not all characters are encoded in the same number of bytes. In UTF-8, ASCII characters – i.e. those with code points less than 0x80 (128) – are encoded as they are in ASCII, using a single byte, while code points 0x80 and above are encoded using multiple bytes – up to four per character. This means that not every byte index into a UTF-8 string is necessarily a valid index for a character. If you index into a string at such an invalid byte index, an error is thrown:julia> s[1]\n\'∀\': Unicode U+2200 (category Sm: Symbol, math)\n\njulia> s[2]\nERROR: StringIndexError(\"∀ x ∃ y\", 2)\n[...]\n\njulia> s[3]\nERROR: StringIndexError(\"∀ x ∃ y\", 3)\nStacktrace:\n[...]\n\njulia> s[4]\n\' \': ASCII/Unicode U+0020 (category Zs: Separator, space)In this case, the character ∀ is a three-byte character, so the indices 2 and 3 are invalid and the next character\'s index is 4; this next valid index can be computed by nextind(s,1), and the next index after that by nextind(s,4) and so on.Extraction of a substring using range indexing also expects valid byte indices or an error is thrown:julia> s[1:1]\n\"∀\"\n\njulia> s[1:2]\nERROR: StringIndexError(\"∀ x ∃ y\", 2)\nStacktrace:\n[...]\n\njulia> s[1:4]\n\"∀ \"Because of variable-length encodings, the number of characters in a string (given by length(s)) is not always the same as the last index. If you iterate through the indices 1 through lastindex(s) and index into s, the sequence of characters returned when errors aren\'t thrown is the sequence of characters comprising the string s. Thus we have the identity that length(s) <= lastindex(s), since each character in a string must have its own index. The following is an inefficient and verbose way to iterate through the characters of s:julia> for i = firstindex(s):lastindex(s)\n           try\n               println(s[i])\n           catch\n               # ignore the index error\n           end\n       end\n∀\n\nx\n\n∃\n\nyThe blank lines actually have spaces on them. Fortunately, the above awkward idiom is unnecessary for iterating through the characters in a string, since you can just use the string as an iterable object, no exception handling required:julia> for c in s\n           println(c)\n       end\n∀\n\nx\n\n∃\n\nyStrings in Julia can contain invalid UTF-8 code unit sequences. This convention allows to treat any byte sequence as a String. In such situations a rule is that when parsing a sequence of code units from left to right characters are formed by the longest sequence of 8-bit code units that matches the start of one of the following bit patterns (each x can be 0 or 1):0xxxxxxx;\n110xxxxx 10xxxxxx;\n1110xxxx 10xxxxxx 10xxxxxx;\n11110xxx 10xxxxxx 10xxxxxx 10xxxxxx;\n10xxxxxx;\n11111xxx.In particular this implies that overlong and too high code unit sequences are accepted. This rule is best explained by an example:julia> s = \"\\xc0\\xa0\\xe2\\x88\\xe2|\"\n\"\\xc0\\xa0\\xe2\\x88\\xe2|\"\n\njulia> foreach(display, s)\n\'\\xc0\\xa0\': [overlong] ASCII/Unicode U+0020 (category Zs: Separator, space)\n\'\\xe2\\x88\': Malformed UTF-8 (category Ma: Malformed, bad data)\n\'\\xe2\': Malformed UTF-8 (category Ma: Malformed, bad data)\n\'|\': ASCII/Unicode U+007c (category Sm: Symbol, math)\n\njulia> isvalid.(collect(s))\n4-element BitArray{1}:\n false\n false\n false\n  true\n\njulia> s2 = \"\\xf7\\xbf\\xbf\\xbf\"\n\"\\U1fffff\"\n\njulia> foreach(display, s2)\n\'\\U1fffff\': Unicode U+1fffff (category In: Invalid, too high)We can see that the first two code units in the string s form an overlong encoding of space character. It is invalid, but is accepted in a string as a single character. The next two code units form a valid start of a three-byte UTF-8 sequence. However, the fifth code unit \\xe2 is not its valid continuation. Therefore code units 3 and 4 are also interpreted as malformed characters in this string. Similarly code unit 5 forms a malformed character because | is not a valid continuation to it. Finally the string s2 contains one too high code point.Julia uses the UTF-8 encoding by default, and support for new encodings can be added by packages. For example, the LegacyStrings.jl package implements UTF16String and UTF32String types. Additional discussion of other encodings and how to implement support for them is beyond the scope of this document for the time being. For further discussion of UTF-8 encoding issues, see the section below on byte array literals. The transcode function is provided to convert data between the various UTF-xx encodings, primarily for working with external data and libraries."
},

{
    "location": "manual/strings.html#man-concatenation-1",
    "page": "Strings",
    "title": "Concatenation",
    "category": "section",
    "text": "One of the most common and useful string operations is concatenation:julia> greet = \"Hello\"\n\"Hello\"\n\njulia> whom = \"world\"\n\"world\"\n\njulia> string(greet, \", \", whom, \".\\n\")\n\"Hello, world.\\n\"It\'s important to be aware of potentially dangerous situations such as concatenation of invalid UTF-8 strings. The resulting string may contain different characters than the input strings, and its number of characters may be lower than sum of numbers of characters of the concatenated strings, e.g.:julia> a, b = \"\\xe2\\x88\", \"\\x80\"\n(\"\\xe2\\x88\", \"\\x80\")\n\njulia> c = a*b\n\"∀\"\n\njulia> collect.([a, b, c])\n3-element Array{Array{Char,1},1}:\n [\'\\xe2\\x88\']\n [\'\\x80\']\n [\'∀\']\n\njulia> length.([a, b, c])\n3-element Array{Int64,1}:\n 1\n 1\n 1This situation can happen only for invalid UTF-8 strings. For valid UTF-8 strings concatenation preserves all characters in strings and additivity of string lengths.Julia also provides * for string concatenation:julia> greet * \", \" * whom * \".\\n\"\n\"Hello, world.\\n\"While * may seem like a surprising choice to users of languages that provide + for string concatenation, this use of * has precedent in mathematics, particularly in abstract algebra.In mathematics, + usually denotes a commutative operation, where the order of the operands does not matter. An example of this is matrix addition, where A + B == B + A for any matrices A and B that have the same shape. In contrast, * typically denotes a noncommutative operation, where the order of the operands does matter. An example of this is matrix multiplication, where in general A * B != B * A. As with matrix multiplication, string concatenation is noncommutative: greet * whom != whom * greet. As such, * is a more natural choice for an infix string concatenation operator, consistent with common mathematical use.More precisely, the set of all finite-length strings S together with the string concatenation operator * forms a free monoid (S, *). The identity element of this set is the empty string, \"\". Whenever a free monoid is not commutative, the operation is typically represented as \\cdot, *, or a similar symbol, rather than +, which as stated usually implies commutativity."
},

{
    "location": "manual/strings.html#string-interpolation-1",
    "page": "Strings",
    "title": "Interpolation",
    "category": "section",
    "text": "Constructing strings using concatenation can become a bit cumbersome, however. To reduce the need for these verbose calls to string or repeated multiplications, Julia allows interpolation into string literals using $, as in Perl:julia> \"$greet, $whom.\\n\"\n\"Hello, world.\\n\"This is more readable and convenient and equivalent to the above string concatenation – the system rewrites this apparent single string literal into a concatenation of string literals with variables.The shortest complete expression after the $ is taken as the expression whose value is to be interpolated into the string. Thus, you can interpolate any expression into a string using parentheses:julia> \"1 + 2 = $(1 + 2)\"\n\"1 + 2 = 3\"Both concatenation and string interpolation call string to convert objects into string form. Most non-AbstractString objects are converted to strings closely corresponding to how they are entered as literal expressions:julia> v = [1,2,3]\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> \"v: $v\"\n\"v: [1, 2, 3]\"string is the identity for AbstractString and AbstractChar values, so these are interpolated into strings as themselves, unquoted and unescaped:julia> c = \'x\'\n\'x\': ASCII/Unicode U+0078 (category Ll: Letter, lowercase)\n\njulia> \"hi, $c\"\n\"hi, x\"To include a literal $ in a string literal, escape it with a backslash:julia> print(\"I have \\$100 in my account.\\n\")\nI have $100 in my account."
},

{
    "location": "manual/strings.html#Triple-Quoted-String-Literals-1",
    "page": "Strings",
    "title": "Triple-Quoted String Literals",
    "category": "section",
    "text": "When strings are created using triple-quotes (\"\"\"...\"\"\") they have some special behavior that can be useful for creating longer blocks of text.First, triple-quoted strings are also dedented to the level of the least-indented line. This is useful for defining strings within code that is indented. For example:julia> str = \"\"\"\n           Hello,\n           world.\n         \"\"\"\n\"  Hello,\\n  world.\\n\"In this case the final (empty) line before the closing \"\"\" sets the indentation level.The dedentation level is determined as the longest common starting sequence of spaces or tabs in all lines, excluding the line following the opening \"\"\" and lines containing only spaces or tabs (the line containing the closing \"\"\" is always included). Then for all lines, excluding the text following the opening \"\"\", the common starting sequence is removed (including lines containing only spaces and tabs if they start with this sequence), e.g.:julia> \"\"\"    This\n         is\n           a test\"\"\"\n\"    This\\nis\\n  a test\"Next, if the opening \"\"\" is followed by a newline, the newline is stripped from the resulting string.\"\"\"hello\"\"\"is equivalent to\"\"\"\nhello\"\"\"but\"\"\"\n\nhello\"\"\"will contain a literal newline at the beginning.Stripping of the newline is performed after the dedentation. For example:julia> \"\"\"\n         Hello,\n         world.\"\"\"\n\"Hello,\\nworld.\"Trailing whitespace is left unaltered.Triple-quoted string literals can contain \" symbols without escaping.Note that line breaks in literal strings, whether single- or triple-quoted, result in a newline (LF) character \\n in the string, even if your editor uses a carriage return \\r (CR) or CRLF combination to end lines. To include a CR in a string, use an explicit escape \\r; for example, you can enter the literal string \"a CRLF line ending\\r\\n\"."
},

{
    "location": "manual/strings.html#Common-Operations-1",
    "page": "Strings",
    "title": "Common Operations",
    "category": "section",
    "text": "You can lexicographically compare strings using the standard comparison operators:julia> \"abracadabra\" < \"xylophone\"\ntrue\n\njulia> \"abracadabra\" == \"xylophone\"\nfalse\n\njulia> \"Hello, world.\" != \"Goodbye, world.\"\ntrue\n\njulia> \"1 + 2 = 3\" == \"1 + 2 = $(1 + 2)\"\ntrueYou can search for the index of a particular character using the findfirst and findlast functions:julia> findfirst(isequal(\'o\'), \"xylophone\")\n4\n\njulia> findlast(isequal(\'o\'), \"xylophone\")\n7\n\njulia> findfirst(isequal(\'z\'), \"xylophone\")You can start the search for a character at a given offset by using the functions findnext and findprev:julia> findnext(isequal(\'o\'), \"xylophone\", 1)\n4\n\njulia> findnext(isequal(\'o\'), \"xylophone\", 5)\n7\n\njulia> findprev(isequal(\'o\'), \"xylophone\", 5)\n4\n\njulia> findnext(isequal(\'o\'), \"xylophone\", 8)You can use the occursin function to check if a substring is found within a string:julia> occursin(\"world\", \"Hello, world.\")\ntrue\n\njulia> occursin(\"o\", \"Xylophon\")\ntrue\n\njulia> occursin(\"a\", \"Xylophon\")\nfalse\n\njulia> occursin(\'o\', \"Xylophon\")\ntrueThe last example shows that occursin can also look for a character literal.Two other handy string functions are repeat and join:julia> repeat(\".:Z:.\", 10)\n\".:Z:..:Z:..:Z:..:Z:..:Z:..:Z:..:Z:..:Z:..:Z:..:Z:.\"\n\njulia> join([\"apples\", \"bananas\", \"pineapples\"], \", \", \" and \")\n\"apples, bananas and pineapples\"Some other useful functions include:firstindex(str) gives the minimal (byte) index that can be used to index into str (always 1 for strings, not necessarily true for other containers).\nlastindex(str) gives the maximal (byte) index that can be used to index into str.\nlength(str) the number of characters in str.\nlength(str, i, j) the number of valid character indices in str from i to j.\nncodeunits(str) number of code units in a string.\ncodeunit(str, i) gives the code unit value in the string str at index i.\nthisind(str, i) given an arbitrary index into a string find the first index of the character into which the index points.\nnextind(str, i, n=1) find the start of the nth character starting after index i.\nprevind(str, i, n=1) find the start of the nth character starting before index i."
},

{
    "location": "manual/strings.html#non-standard-string-literals-1",
    "page": "Strings",
    "title": "Non-Standard String Literals",
    "category": "section",
    "text": "There are situations when you want to construct a string or use string semantics, but the behavior of the standard string construct is not quite what is needed. For these kinds of situations, Julia provides non-standard string literals. A non-standard string literal looks like a regular double-quoted string literal, but is immediately prefixed by an identifier, and doesn\'t behave quite like a normal string literal.  Regular expressions, byte array literals and version number literals, as described below, are some examples of non-standard string literals. Other examples are given in the Metaprogramming section."
},

{
    "location": "manual/strings.html#Regular-Expressions-1",
    "page": "Strings",
    "title": "Regular Expressions",
    "category": "section",
    "text": "Julia has Perl-compatible regular expressions (regexes), as provided by the PCRE library. Regular expressions are related to strings in two ways: the obvious connection is that regular expressions are used to find regular patterns in strings; the other connection is that regular expressions are themselves input as strings, which are parsed into a state machine that can be used to efficiently search for patterns in strings. In Julia, regular expressions are input using non-standard string literals prefixed with various identifiers beginning with r. The most basic regular expression literal without any options turned on just uses r\"...\":julia> r\"^\\s*(?:#|$)\"\nr\"^\\s*(?:#|$)\"\n\njulia> typeof(ans)\nRegexTo check if a regex matches a string, use occursin:julia> occursin(r\"^\\s*(?:#|$)\", \"not a comment\")\nfalse\n\njulia> occursin(r\"^\\s*(?:#|$)\", \"# a comment\")\ntrueAs one can see here, occursin simply returns true or false, indicating whether a match for the given regex occurs in the string. Commonly, however, one wants to know not just whether a string matched, but also how it matched. To capture this information about a match, use the match function instead:julia> match(r\"^\\s*(?:#|$)\", \"not a comment\")\n\njulia> match(r\"^\\s*(?:#|$)\", \"# a comment\")\nRegexMatch(\"#\")If the regular expression does not match the given string, match returns nothing – a special value that does not print anything at the interactive prompt. Other than not printing, it is a completely normal value and you can test for it programmatically:m = match(r\"^\\s*(?:#|$)\", line)\nif m === nothing\n    println(\"not a comment\")\nelse\n    println(\"blank or comment\")\nendIf a regular expression does match, the value returned by match is a RegexMatch object. These objects record how the expression matches, including the substring that the pattern matches and any captured substrings, if there are any. This example only captures the portion of the substring that matches, but perhaps we want to capture any non-blank text after the comment character. We could do the following:julia> m = match(r\"^\\s*(?:#\\s*(.*?)\\s*$|$)\", \"# a comment \")\nRegexMatch(\"# a comment \", 1=\"a comment\")When calling match, you have the option to specify an index at which to start the search. For example:julia> m = match(r\"[0-9]\",\"aaaa1aaaa2aaaa3\",1)\nRegexMatch(\"1\")\n\njulia> m = match(r\"[0-9]\",\"aaaa1aaaa2aaaa3\",6)\nRegexMatch(\"2\")\n\njulia> m = match(r\"[0-9]\",\"aaaa1aaaa2aaaa3\",11)\nRegexMatch(\"3\")You can extract the following info from a RegexMatch object:the entire substring matched: m.match\nthe captured substrings as an array of strings: m.captures\nthe offset at which the whole match begins: m.offset\nthe offsets of the captured substrings as a vector: m.offsetsFor when a capture doesn\'t match, instead of a substring, m.captures contains nothing in that position, and m.offsets has a zero offset (recall that indices in Julia are 1-based, so a zero offset into a string is invalid). Here is a pair of somewhat contrived examples:julia> m = match(r\"(a|b)(c)?(d)\", \"acd\")\nRegexMatch(\"acd\", 1=\"a\", 2=\"c\", 3=\"d\")\n\njulia> m.match\n\"acd\"\n\njulia> m.captures\n3-element Array{Union{Nothing, SubString{String}},1}:\n \"a\"\n \"c\"\n \"d\"\n\njulia> m.offset\n1\n\njulia> m.offsets\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> m = match(r\"(a|b)(c)?(d)\", \"ad\")\nRegexMatch(\"ad\", 1=\"a\", 2=nothing, 3=\"d\")\n\njulia> m.match\n\"ad\"\n\njulia> m.captures\n3-element Array{Union{Nothing, SubString{String}},1}:\n \"a\"\n nothing\n \"d\"\n\njulia> m.offset\n1\n\njulia> m.offsets\n3-element Array{Int64,1}:\n 1\n 0\n 2It is convenient to have captures returned as an array so that one can use destructuring syntax to bind them to local variables:julia> first, second, third = m.captures; first\n\"a\"Captures can also be accessed by indexing the RegexMatch object with the number or name of the capture group:julia> m=match(r\"(?<hour>\\d+):(?<minute>\\d+)\",\"12:45\")\nRegexMatch(\"12:45\", hour=\"12\", minute=\"45\")\n\njulia> m[:minute]\n\"45\"\n\njulia> m[2]\n\"45\"Captures can be referenced in a substitution string when using replace by using \\n to refer to the nth capture group and prefixing the substitution string with s. Capture group 0 refers to the entire match object. Named capture groups can be referenced in the substitution with \\g<groupname>. For example:julia> replace(\"first second\", r\"(\\w+) (?<agroup>\\w+)\" => s\"\\g<agroup> \\1\")\n\"second first\"Numbered capture groups can also be referenced as \\g<n> for disambiguation, as in:julia> replace(\"a\", r\".\" => s\"\\g<0>1\")\n\"a1\"You can modify the behavior of regular expressions by some combination of the flags i, m, s, and x after the closing double quote mark. These flags have the same meaning as they do in Perl, as explained in this excerpt from the perlre manpage:i   Do case-insensitive pattern matching.\n\n    If locale matching rules are in effect, the case map is taken\n    from the current locale for code points less than 255, and\n    from Unicode rules for larger code points. However, matches\n    that would cross the Unicode rules/non-Unicode rules boundary\n    (ords 255/256) will not succeed.\n\nm   Treat string as multiple lines.  That is, change \"^\" and \"$\"\n    from matching the start or end of the string to matching the\n    start or end of any line anywhere within the string.\n\ns   Treat string as single line.  That is, change \".\" to match any\n    character whatsoever, even a newline, which normally it would\n    not match.\n\n    Used together, as r\"\"ms, they let the \".\" match any character\n    whatsoever, while still allowing \"^\" and \"$\" to match,\n    respectively, just after and just before newlines within the\n    string.\n\nx   Tells the regular expression parser to ignore most whitespace\n    that is neither backslashed nor within a character class. You\n    can use this to break up your regular expression into\n    (slightly) more readable parts. The \'#\' character is also\n    treated as a metacharacter introducing a comment, just as in\n    ordinary code.For example, the following regex has all three flags turned on:julia> r\"a+.*b+.*?d$\"ism\nr\"a+.*b+.*?d$\"ims\n\njulia> match(r\"a+.*b+.*?d$\"ism, \"Goodbye,\\nOh, angry,\\nBad world\\n\")\nRegexMatch(\"angry,\\nBad world\")The r\"...\" literal is constructed without interpolation and unescaping (except for quotation mark \" which still has to be escaped). Here is an example showing the difference from standard string literals:julia> x = 10\n10\n\njulia> r\"$x\"\nr\"$x\"\n\njulia> \"$x\"\n\"10\"\n\njulia> r\"\\x\"\nr\"\\x\"\n\njulia> \"\\x\"\nERROR: syntax: invalid escape sequenceTriple-quoted regex strings, of the form r\"\"\"...\"\"\", are also supported (and may be convenient for regular expressions containing quotation marks or newlines).The Regex() constructor may be used to create a valid regex string programmatically.  This permits using the contents of string variables and other string operations when constructing the regex string. Any of the regex codes above can be used within the single string argument to Regex(). Here are some examples:julia> using Dates\n\njulia> d = Date(1962,7,10)\n1962-07-10\n\njulia> regex_d = Regex(\"Day \" * string(day(d)))\nr\"Day 10\"\n\njulia> match(regex_d, \"It happened on Day 10\")\nRegexMatch(\"Day 10\")\n\njulia> name = \"Jon\"\n\"Jon\"\n\njulia> regex_name = Regex(\"[\\\"( ]$name[\\\") ]\")  # interpolate value of name\nr\"[\\\"( ]Jon[\\\") ]\"\n\njulia> match(regex_name,\" Jon \")\nRegexMatch(\" Jon \")\n\njulia> match(regex_name,\"[Jon]\") === nothing\ntrue"
},

{
    "location": "manual/strings.html#man-byte-array-literals-1",
    "page": "Strings",
    "title": "Byte Array Literals",
    "category": "section",
    "text": "Another useful non-standard string literal is the byte-array string literal: b\"...\". This form lets you use string notation to express read only literal byte arrays – i.e. arrays of UInt8 values. The type of those objects is CodeUnits{UInt8, String}. The rules for byte array literals are the following:ASCII characters and ASCII escapes produce a single byte.\n\\x and octal escape sequences produce the byte corresponding to the escape value.\nUnicode escape sequences produce a sequence of bytes encoding that code point in UTF-8.There is some overlap between these rules since the behavior of \\x and octal escapes less than 0x80 (128) are covered by both of the first two rules, but here these rules agree. Together, these rules allow one to easily use ASCII characters, arbitrary byte values, and UTF-8 sequences to produce arrays of bytes. Here is an example using all three:julia> b\"DATA\\xff\\u2200\"\n8-element Base.CodeUnits{UInt8,String}:\n 0x44\n 0x41\n 0x54\n 0x41\n 0xff\n 0xe2\n 0x88\n 0x80The ASCII string \"DATA\" corresponds to the bytes 68, 65, 84, 65. \\xff produces the single byte 255. The Unicode escape \\u2200 is encoded in UTF-8 as the three bytes 226, 136, 128. Note that the resulting byte array does not correspond to a valid UTF-8 string:julia> isvalid(\"DATA\\xff\\u2200\")\nfalseAs it was mentioned CodeUnits{UInt8,String} type behaves like read only array of UInt8 and if you need a standard vector you can convert it using Vector{UInt8}:julia> x = b\"123\"\n3-element Base.CodeUnits{UInt8,String}:\n 0x31\n 0x32\n 0x33\n\njulia> x[1]\n0x31\n\njulia> x[1] = 0x32\nERROR: setindex! not defined for Base.CodeUnits{UInt8,String}\n[...]\n\njulia> Vector{UInt8}(x)\n3-element Array{UInt8,1}:\n 0x31\n 0x32\n 0x33Also observe the significant distinction between \\xff and \\uff: the former escape sequence encodes the byte 255, whereas the latter escape sequence represents the code point 255, which is encoded as two bytes in UTF-8:julia> b\"\\xff\"\n1-element Base.CodeUnits{UInt8,String}:\n 0xff\n\njulia> b\"\\uff\"\n2-element Base.CodeUnits{UInt8,String}:\n 0xc3\n 0xbfCharacter literals use the same behavior.For code points less than \\u80, it happens that the UTF-8 encoding of each code point is just the single byte produced by the corresponding \\x escape, so the distinction can safely be ignored. For the escapes \\x80 through \\xff as compared to \\u80 through \\uff, however, there is a major difference: the former escapes all encode single bytes, which – unless followed by very specific continuation bytes – do not form valid UTF-8 data, whereas the latter escapes all represent Unicode code points with two-byte encodings.If this is all extremely confusing, try reading \"The Absolute Minimum Every Software Developer Absolutely, Positively Must Know About Unicode and Character Sets\". It\'s an excellent introduction to Unicode and UTF-8, and may help alleviate some confusion regarding the matter."
},

{
    "location": "manual/strings.html#man-version-number-literals-1",
    "page": "Strings",
    "title": "Version Number Literals",
    "category": "section",
    "text": "Version numbers can easily be expressed with non-standard string literals of the form v\"...\". Version number literals create VersionNumber objects which follow the specifications of semantic versioning, and therefore are composed of major, minor and patch numeric values, followed by pre-release and build alpha-numeric annotations. For example, v\"0.2.1-rc1+win64\" is broken into major version 0, minor version 2, patch version 1, pre-release rc1 and build win64. When entering a version literal, everything except the major version number is optional, therefore e.g.  v\"0.2\" is equivalent to v\"0.2.0\" (with empty pre-release/build annotations), v\"2\" is equivalent to v\"2.0.0\", and so on.VersionNumber objects are mostly useful to easily and correctly compare two (or more) versions. For example, the constant VERSION holds Julia version number as a VersionNumber object, and therefore one can define some version-specific behavior using simple statements as:if v\"0.2\" <= VERSION < v\"0.3-\"\n    # do something specific to 0.2 release series\nendNote that in the above example the non-standard version number v\"0.3-\" is used, with a trailing -: this notation is a Julia extension of the standard, and it\'s used to indicate a version which is lower than any 0.3 release, including all of its pre-releases. So in the above example the code would only run with stable 0.2 versions, and exclude such versions as v\"0.3.0-rc1\". In order to also allow for unstable (i.e. pre-release) 0.2 versions, the lower bound check should be modified like this: v\"0.2-\" <= VERSION.Another non-standard version specification extension allows one to use a trailing + to express an upper limit on build versions, e.g.  VERSION > v\"0.2-rc1+\" can be used to mean any version above 0.2-rc1 and any of its builds: it will return false for version v\"0.2-rc1+win64\" and true for v\"0.2-rc2\".It is good practice to use such special versions in comparisons (particularly, the trailing - should always be used on upper bounds unless there\'s a good reason not to), but they must not be used as the actual version number of anything, as they are invalid in the semantic versioning scheme.Besides being used for the VERSION constant, VersionNumber objects are widely used in the Pkg module, to specify packages versions and their dependencies."
},

{
    "location": "manual/strings.html#man-raw-string-literals-1",
    "page": "Strings",
    "title": "Raw String Literals",
    "category": "section",
    "text": "Raw strings without interpolation or unescaping can be expressed with non-standard string literals of the form raw\"...\". Raw string literals create ordinary String objects which contain the enclosed contents exactly as entered with no interpolation or unescaping. This is useful for strings which contain code or markup in other languages which use $ or \\ as special characters.The exception is that quotation marks still must be escaped, e.g. raw\"\\\"\" is equivalent to \"\\\"\". To make it possible to express all strings, backslashes then also must be escaped, but only when appearing right before a quote character:julia> println(raw\"\\\\ \\\\\\\"\")\n\\\\ \\\"Notice that the first two backslashes appear verbatim in the output, since they do not precede a quote character. However, the next backslash character escapes the backslash that follows it, and the last backslash escapes a quote, since these backslashes appear before a quote."
},

{
    "location": "manual/functions.html#",
    "page": "Functions",
    "title": "Functions",
    "category": "page",
    "text": ""
},

{
    "location": "manual/functions.html#man-functions-1",
    "page": "Functions",
    "title": "Functions",
    "category": "section",
    "text": "In Julia, a function is an object that maps a tuple of argument values to a return value. Julia functions are not pure mathematical functions, in the sense that functions can alter and be affected by the global state of the program. The basic syntax for defining functions in Julia is:julia> function f(x,y)\n           x + y\n       end\nf (generic function with 1 method)There is a second, more terse syntax for defining a function in Julia. The traditional function declaration syntax demonstrated above is equivalent to the following compact \"assignment form\":julia> f(x,y) = x + y\nf (generic function with 1 method)In the assignment form, the body of the function must be a single expression, although it can be a compound expression (see Compound Expressions). Short, simple function definitions are common in Julia. The short function syntax is accordingly quite idiomatic, considerably reducing both typing and visual noise.A function is called using the traditional parenthesis syntax:julia> f(2,3)\n5Without parentheses, the expression f refers to the function object, and can be passed around like any value:julia> g = f;\n\njulia> g(2,3)\n5As with variables, Unicode can also be used for function names:julia> ∑(x,y) = x + y\n∑ (generic function with 1 method)\n\njulia> ∑(2, 3)\n5"
},

{
    "location": "manual/functions.html#Argument-Passing-Behavior-1",
    "page": "Functions",
    "title": "Argument Passing Behavior",
    "category": "section",
    "text": "Julia function arguments follow a convention sometimes called \"pass-by-sharing\", which means that values are not copied when they are passed to functions. Function arguments themselves act as new variable bindings (new locations that can refer to values), but the values they refer to are identical to the passed values. Modifications to mutable values (such as Arrays) made within a function will be visible to the caller. This is the same behavior found in Scheme, most Lisps, Python, Ruby and Perl, among other dynamic languages."
},

{
    "location": "manual/functions.html#The-return-Keyword-1",
    "page": "Functions",
    "title": "The return Keyword",
    "category": "section",
    "text": "The value returned by a function is the value of the last expression evaluated, which, by default, is the last expression in the body of the function definition. In the example function, f, from the previous section this is the value of the expression x + y. As in C and most other imperative or functional languages, the return keyword causes a function to return immediately, providing an expression whose value is returned:function g(x,y)\n    return x * y\n    x + y\nendSince function definitions can be entered into interactive sessions, it is easy to compare these definitions:julia> f(x,y) = x + y\nf (generic function with 1 method)\n\njulia> function g(x,y)\n           return x * y\n           x + y\n       end\ng (generic function with 1 method)\n\njulia> f(2,3)\n5\n\njulia> g(2,3)\n6Of course, in a purely linear function body like g, the usage of return is pointless since the expression x + y is never evaluated and we could simply make x * y the last expression in the function and omit the return. In conjunction with other control flow, however, return is of real use. Here, for example, is a function that computes the hypotenuse length of a right triangle with sides of length x and y, avoiding overflow:julia> function hypot(x,y)\n           x = abs(x)\n           y = abs(y)\n           if x > y\n               r = y/x\n               return x*sqrt(1+r*r)\n           end\n           if y == 0\n               return zero(x)\n           end\n           r = x/y\n           return y*sqrt(1+r*r)\n       end\nhypot (generic function with 1 method)\n\njulia> hypot(3, 4)\n5.0There are three possible points of return from this function, returning the values of three different expressions, depending on the values of x and y. The return on the last line could be omitted since it is the last expression.A return type can also be specified in the function declaration using the :: operator. This converts the return value to the specified type.julia> function g(x, y)::Int8\n           return x * y\n       end;\n\njulia> typeof(g(1, 2))\nInt8This function will always return an Int8 regardless of the types of x and y. See Type Declarations for more on return types."
},

{
    "location": "manual/functions.html#Operators-Are-Functions-1",
    "page": "Functions",
    "title": "Operators Are Functions",
    "category": "section",
    "text": "In Julia, most operators are just functions with support for special syntax. (The exceptions are operators with special evaluation semantics like && and ||. These operators cannot be functions since Short-Circuit Evaluation requires that their operands are not evaluated before evaluation of the operator.) Accordingly, you can also apply them using parenthesized argument lists, just as you would any other function:julia> 1 + 2 + 3\n6\n\njulia> +(1,2,3)\n6The infix form is exactly equivalent to the function application form – in fact the former is parsed to produce the function call internally. This also means that you can assign and pass around operators such as + and * just like you would with other function values:julia> f = +;\n\njulia> f(1,2,3)\n6Under the name f, the function does not support infix notation, however."
},

{
    "location": "manual/functions.html#Operators-With-Special-Names-1",
    "page": "Functions",
    "title": "Operators With Special Names",
    "category": "section",
    "text": "A few special expressions correspond to calls to functions with non-obvious names. These are:Expression Calls\n[A B C ...] hcat\n[A; B; C; ...] vcat\n[A B; C D; ...] hvcat\nA\' adjoint\nA[i] getindex\nA[i] = x setindex!\nA.n getproperty\nA.n = x setproperty!"
},

{
    "location": "manual/functions.html#man-anonymous-functions-1",
    "page": "Functions",
    "title": "Anonymous Functions",
    "category": "section",
    "text": "Functions in Julia are first-class objects: they can be assigned to variables, and called using the standard function call syntax from the variable they have been assigned to. They can be used as arguments, and they can be returned as values. They can also be created anonymously, without being given a name, using either of these syntaxes:julia> x -> x^2 + 2x - 1\n#1 (generic function with 1 method)\n\njulia> function (x)\n           x^2 + 2x - 1\n       end\n#3 (generic function with 1 method)This creates a function taking one argument x and returning the value of the polynomial x^2 + 2x - 1 at that value. Notice that the result is a generic function, but with a compiler-generated name based on consecutive numbering.The primary use for anonymous functions is passing them to functions which take other functions as arguments. A classic example is map, which applies a function to each value of an array and returns a new array containing the resulting values:julia> map(round, [1.2,3.5,1.7])\n3-element Array{Float64,1}:\n 1.0\n 4.0\n 2.0This is fine if a named function effecting the transform already exists to pass as the first argument to map. Often, however, a ready-to-use, named function does not exist. In these situations, the anonymous function construct allows easy creation of a single-use function object without needing a name:julia> map(x -> x^2 + 2x - 1, [1,3,-1])\n3-element Array{Int64,1}:\n  2\n 14\n -2An anonymous function accepting multiple arguments can be written using the syntax (x,y,z)->2x+y-z. A zero-argument anonymous function is written as ()->3. The idea of a function with no arguments may seem strange, but is useful for \"delaying\" a computation. In this usage, a block of code is wrapped in a zero-argument function, which is later invoked by calling it as f."
},

{
    "location": "manual/functions.html#Tuples-1",
    "page": "Functions",
    "title": "Tuples",
    "category": "section",
    "text": "Julia has a built-in data structure called a tuple that is closely related to function arguments and return values. A tuple is a fixed-length container that can hold any values, but cannot be modified (it is immutable). Tuples are constructed with commas and parentheses, and can be accessed via indexing:julia> (1, 1+1)\n(1, 2)\n\njulia> (1,)\n(1,)\n\njulia> x = (0.0, \"hello\", 6*7)\n(0.0, \"hello\", 42)\n\njulia> x[2]\n\"hello\"Notice that a length-1 tuple must be written with a comma, (1,), since (1) would just be a parenthesized value. () represents the empty (length-0) tuple."
},

{
    "location": "manual/functions.html#Named-Tuples-1",
    "page": "Functions",
    "title": "Named Tuples",
    "category": "section",
    "text": "The components of tuples can optionally be named, in which case a named tuple is constructed:julia> x = (a=1, b=1+1)\n(a = 1, b = 2)\n\njulia> x.a\n1Named tuples are very similar to tuples, except that fields can additionally be accessed by name using dot syntax (x.a)."
},

{
    "location": "manual/functions.html#Multiple-Return-Values-1",
    "page": "Functions",
    "title": "Multiple Return Values",
    "category": "section",
    "text": "In Julia, one returns a tuple of values to simulate returning multiple values. However, tuples can be created and destructured without needing parentheses, thereby providing an illusion that multiple values are being returned, rather than a single tuple value. For example, the following function returns a pair of values:julia> function foo(a,b)\n           a+b, a*b\n       end\nfoo (generic function with 1 method)If you call it in an interactive session without assigning the return value anywhere, you will see the tuple returned:julia> foo(2,3)\n(5, 6)A typical usage of such a pair of return values, however, extracts each value into a variable. Julia supports simple tuple \"destructuring\" that facilitates this:julia> x, y = foo(2,3)\n(5, 6)\n\njulia> x\n5\n\njulia> y\n6You can also return multiple values via an explicit usage of the return keyword:function foo(a,b)\n    return a+b, a*b\nendThis has the exact same effect as the previous definition of foo."
},

{
    "location": "manual/functions.html#Argument-destructuring-1",
    "page": "Functions",
    "title": "Argument destructuring",
    "category": "section",
    "text": "The destructuring feature can also be used within a function argument. If a function argument name is written as a tuple (e.g. (x, y)) instead of just a symbol, then an assignment (x, y) = argument will be inserted for you:julia> minmax(x, y) = (y < x) ? (y, x) : (x, y)\n\njulia> range((min, max)) = max - min\n\njulia> range(minmax(10, 2))\n8Notice the extra set of parentheses in the definition of range. Without those, range would be a two-argument function, and this example would not work."
},

{
    "location": "manual/functions.html#Varargs-Functions-1",
    "page": "Functions",
    "title": "Varargs Functions",
    "category": "section",
    "text": "It is often convenient to be able to write functions taking an arbitrary number of arguments. Such functions are traditionally known as \"varargs\" functions, which is short for \"variable number of arguments\". You can define a varargs function by following the last argument with an ellipsis:julia> bar(a,b,x...) = (a,b,x)\nbar (generic function with 1 method)The variables a and b are bound to the first two argument values as usual, and the variable x is bound to an iterable collection of the zero or more values passed to bar after its first two arguments:julia> bar(1,2)\n(1, 2, ())\n\njulia> bar(1,2,3)\n(1, 2, (3,))\n\njulia> bar(1, 2, 3, 4)\n(1, 2, (3, 4))\n\njulia> bar(1,2,3,4,5,6)\n(1, 2, (3, 4, 5, 6))In all these cases, x is bound to a tuple of the trailing values passed to bar.It is possible to constrain the number of values passed as a variable argument; this will be discussed later in Parametrically-constrained Varargs methods.On the flip side, it is often handy to \"splat\" the values contained in an iterable collection into a function call as individual arguments. To do this, one also uses ... but in the function call instead:julia> x = (3, 4)\n(3, 4)\n\njulia> bar(1,2,x...)\n(1, 2, (3, 4))In this case a tuple of values is spliced into a varargs call precisely where the variable number of arguments go. This need not be the case, however:julia> x = (2, 3, 4)\n(2, 3, 4)\n\njulia> bar(1,x...)\n(1, 2, (3, 4))\n\njulia> x = (1, 2, 3, 4)\n(1, 2, 3, 4)\n\njulia> bar(x...)\n(1, 2, (3, 4))Furthermore, the iterable object splatted into a function call need not be a tuple:julia> x = [3,4]\n2-element Array{Int64,1}:\n 3\n 4\n\njulia> bar(1,2,x...)\n(1, 2, (3, 4))\n\njulia> x = [1,2,3,4]\n4-element Array{Int64,1}:\n 1\n 2\n 3\n 4\n\njulia> bar(x...)\n(1, 2, (3, 4))Also, the function that arguments are splatted into need not be a varargs function (although it often is):julia> baz(a,b) = a + b;\n\njulia> args = [1,2]\n2-element Array{Int64,1}:\n 1\n 2\n\njulia> baz(args...)\n3\n\njulia> args = [1,2,3]\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> baz(args...)\nERROR: MethodError: no method matching baz(::Int64, ::Int64, ::Int64)\nClosest candidates are:\n  baz(::Any, ::Any) at none:1As you can see, if the wrong number of elements are in the splatted container, then the function call will fail, just as it would if too many arguments were given explicitly."
},

{
    "location": "manual/functions.html#Optional-Arguments-1",
    "page": "Functions",
    "title": "Optional Arguments",
    "category": "section",
    "text": "In many cases, function arguments have sensible default values and therefore might not need to be passed explicitly in every call. For example, the function Date(y, [m, d]) from Dates module constructs a Date type for a given year y, month m and day d. However, m and d arguments are optional and their default value is 1. This behavior can be expressed concisely as:function Date(y::Int64, m::Int64=1, d::Int64=1)\n    err = validargs(Date, y, m, d)\n    err === nothing || throw(err)\n    return Date(UTD(totaldays(y, m, d)))\nendObserve, that this definition calls another method of Date function that takes one argument of UTInstant{Day} type.With this definition, the function can be called with either one, two or three arguments, and 1 is automatically passed when any of the arguments is not specified:julia> using Dates\n\njulia> Date(2000, 12, 12)\n2000-12-12\n\njulia> Date(2000, 12)\n2000-12-01\n\njulia> Date(2000)\n2000-01-01Optional arguments are actually just a convenient syntax for writing multiple method definitions with different numbers of arguments (see Note on Optional and keyword Arguments). This can be checked for our Date function example by calling methods function."
},

{
    "location": "manual/functions.html#Keyword-Arguments-1",
    "page": "Functions",
    "title": "Keyword Arguments",
    "category": "section",
    "text": "Some functions need a large number of arguments, or have a large number of behaviors. Remembering how to call such functions can be difficult. Keyword arguments can make these complex interfaces easier to use and extend by allowing arguments to be identified by name instead of only by position.For example, consider a function plot that plots a line. This function might have many options, for controlling line style, width, color, and so on. If it accepts keyword arguments, a possible call might look like plot(x, y, width=2), where we have chosen to specify only line width. Notice that this serves two purposes. The call is easier to read, since we can label an argument with its meaning. It also becomes possible to pass any subset of a large number of arguments, in any order.Functions with keyword arguments are defined using a semicolon in the signature:function plot(x, y; style=\"solid\", width=1, color=\"black\")\n    ###\nendWhen the function is called, the semicolon is optional: one can either call plot(x, y, width=2) or plot(x, y; width=2), but the former style is more common. An explicit semicolon is required only for passing varargs or computed keywords as described below.Keyword argument default values are evaluated only when necessary (when a corresponding keyword argument is not passed), and in left-to-right order. Therefore default expressions may refer to prior keyword arguments.The types of keyword arguments can be made explicit as follows:function f(;x::Int=1)\n    ###\nendExtra keyword arguments can be collected using ..., as in varargs functions:function f(x; y=0, kwargs...)\n    ###\nendInside f, kwargs will be a key-value iterator over a named tuple. Named tuples (as well as dictionaries with keys of Symbol) can be passed as keyword arguments using a semicolon in a call, e.g. f(x, z=1; kwargs...).If a keyword argument is not assigned a default value in the method definition, then it is required: an UndefKeywordError exception will be thrown if the caller does not assign it a value:function f(x; y)\n    ###\nend\nf(3, y=5) # ok, y is assigned\nf(3)      # throws UndefKeywordError(:y)One can also pass key => value expressions after a semicolon. For example, plot(x, y; :width => 2) is equivalent to plot(x, y, width=2). This is useful in situations where the keyword name is computed at runtime.The nature of keyword arguments makes it possible to specify the same argument more than once. For example, in the call plot(x, y; options..., width=2) it is possible that the options structure also contains a value for width. In such a case the rightmost occurrence takes precedence; in this example, width is certain to have the value 2. However, explicitly specifying the same keyword argument multiple times, for example plot(x, y, width=2, width=3), is not allowed and results in a syntax error."
},

{
    "location": "manual/functions.html#Evaluation-Scope-of-Default-Values-1",
    "page": "Functions",
    "title": "Evaluation Scope of Default Values",
    "category": "section",
    "text": "When optional and keyword argument default expressions are evaluated, only previous arguments are in scope. For example, given this definition:function f(x, a=b, b=1)\n    ###\nendthe b in a=b refers to a b in an outer scope, not the subsequent argument b."
},

{
    "location": "manual/functions.html#Do-Block-Syntax-for-Function-Arguments-1",
    "page": "Functions",
    "title": "Do-Block Syntax for Function Arguments",
    "category": "section",
    "text": "Passing functions as arguments to other functions is a powerful technique, but the syntax for it is not always convenient. Such calls are especially awkward to write when the function argument requires multiple lines. As an example, consider calling map on a function with several cases:map(x->begin\n           if x < 0 && iseven(x)\n               return 0\n           elseif x == 0\n               return 1\n           else\n               return x\n           end\n       end,\n    [A, B, C])Julia provides a reserved word do for rewriting this code more clearly:map([A, B, C]) do x\n    if x < 0 && iseven(x)\n        return 0\n    elseif x == 0\n        return 1\n    else\n        return x\n    end\nendThe do x syntax creates an anonymous function with argument x and passes it as the first argument to map. Similarly, do a,b would create a two-argument anonymous function, and a plain do would declare that what follows is an anonymous function of the form () -> ....How these arguments are initialized depends on the \"outer\" function; here, map will sequentially set x to A, B, C, calling the anonymous function on each, just as would happen in the syntax map(func, [A, B, C]).This syntax makes it easier to use functions to effectively extend the language, since calls look like normal code blocks. There are many possible uses quite different from map, such as managing system state. For example, there is a version of open that runs code ensuring that the opened file is eventually closed:open(\"outfile\", \"w\") do io\n    write(io, data)\nendThis is accomplished by the following definition:function open(f::Function, args...)\n    io = open(args...)\n    try\n        f(io)\n    finally\n        close(io)\n    end\nendHere, open first opens the file for writing and then passes the resulting output stream to the anonymous function you defined in the do ... end block. After your function exits, open will make sure that the stream is properly closed, regardless of whether your function exited normally or threw an exception. (The try/finally construct will be described in Control Flow.)With the do block syntax, it helps to check the documentation or implementation to know how the arguments of the user function are initialized.A do block, like any other inner function, can \"capture\" variables from its enclosing scope. For example, the variable data in the above example of open...do is captured from the outer scope. Captured variables can create performance challenges as discussed in performance tips."
},

{
    "location": "manual/functions.html#man-vectorized-1",
    "page": "Functions",
    "title": "Dot Syntax for Vectorizing Functions",
    "category": "section",
    "text": "In technical-computing languages, it is common to have \"vectorized\" versions of functions, which simply apply a given function f(x) to each element of an array A to yield a new array via f(A). This kind of syntax is convenient for data processing, but in other languages vectorization is also often required for performance: if loops are slow, the \"vectorized\" version of a function can call fast library code written in a low-level language. In Julia, vectorized functions are not required for performance, and indeed it is often beneficial to write your own loops (see Performance Tips), but they can still be convenient. Therefore, any Julia function f can be applied elementwise to any array (or other collection) with the syntax f.(A). For example, sin can be applied to all elements in the vector A like so:julia> A = [1.0, 2.0, 3.0]\n3-element Array{Float64,1}:\n 1.0\n 2.0\n 3.0\n\njulia> sin.(A)\n3-element Array{Float64,1}:\n 0.8414709848078965\n 0.9092974268256817\n 0.1411200080598672Of course, you can omit the dot if you write a specialized \"vector\" method of f, e.g. via f(A::AbstractArray) = map(f, A), and this is just as efficient as f.(A). But that approach requires you to decide in advance which functions you want to vectorize.More generally, f.(args...) is actually equivalent to broadcast(f, args...), which allows you to operate on multiple arrays (even of different shapes), or a mix of arrays and scalars (see Broadcasting). For example, if you have f(x,y) = 3x + 4y, then f.(pi,A) will return a new array consisting of f(pi,a) for each a in A, and f.(vector1,vector2) will return a new vector consisting of f(vector1[i],vector2[i]) for each index i (throwing an exception if the vectors have different length).julia> f(x,y) = 3x + 4y;\n\njulia> A = [1.0, 2.0, 3.0];\n\njulia> B = [4.0, 5.0, 6.0];\n\njulia> f.(pi, A)\n3-element Array{Float64,1}:\n 13.42477796076938\n 17.42477796076938\n 21.42477796076938\n\njulia> f.(A, B)\n3-element Array{Float64,1}:\n 19.0\n 26.0\n 33.0Moreover, nested f.(args...) calls are fused into a single broadcast loop. For example, sin.(cos.(X)) is equivalent to broadcast(x -> sin(cos(x)), X), similar to [sin(cos(x)) for x in X]: there is only a single loop over X, and a single array is allocated for the result. [In contrast, sin(cos(X)) in a typical \"vectorized\" language would first allocate one temporary array for tmp=cos(X), and then compute sin(tmp) in a separate loop, allocating a second array.] This loop fusion is not a compiler optimization that may or may not occur, it is a syntactic guarantee whenever nested f.(args...) calls are encountered. Technically, the fusion stops as soon as a \"non-dot\" function call is encountered; for example, in sin.(sort(cos.(X))) the sin and cos loops cannot be merged because of the intervening sort function.Finally, the maximum efficiency is typically achieved when the output array of a vectorized operation is pre-allocated, so that repeated calls do not allocate new arrays over and over again for the results (see Pre-allocating outputs). A convenient syntax for this is X .= ..., which is equivalent to broadcast!(identity, X, ...) except that, as above, the broadcast! loop is fused with any nested \"dot\" calls. For example, X .= sin.(Y) is equivalent to broadcast!(sin, X, Y), overwriting X with sin.(Y) in-place. If the left-hand side is an array-indexing expression, e.g. X[2:end] .= sin.(Y), then it translates to broadcast! on a view, e.g. broadcast!(sin, view(X, 2:lastindex(X)), Y), so that the left-hand side is updated in-place.Since adding dots to many operations and function calls in an expression can be tedious and lead to code that is difficult to read, the macro @. is provided to convert every function call, operation, and assignment in an expression into the \"dotted\" version.julia> Y = [1.0, 2.0, 3.0, 4.0];\n\njulia> X = similar(Y); # pre-allocate output array\n\njulia> @. X = sin(cos(Y)) # equivalent to X .= sin.(cos.(Y))\n4-element Array{Float64,1}:\n  0.5143952585235492\n -0.4042391538522658\n -0.8360218615377305\n -0.6080830096407656Binary (or unary) operators like .+ are handled with the same mechanism: they are equivalent to broadcast calls and are fused with other nested \"dot\" calls.  X .+= Y etcetera is equivalent to X .= X .+ Y and results in a fused in-place assignment;  see also dot operators.You can also combine dot operations with function chaining using |>, as in this example:julia> [1:5;] .|> [x->x^2, inv, x->2*x, -, isodd]\n5-element Array{Real,1}:\n    1\n    0.5\n    6\n   -4\n true"
},

{
    "location": "manual/functions.html#Further-Reading-1",
    "page": "Functions",
    "title": "Further Reading",
    "category": "section",
    "text": "We should mention here that this is far from a complete picture of defining functions. Julia has a sophisticated type system and allows multiple dispatch on argument types. None of the examples given here provide any type annotations on their arguments, meaning that they are applicable to all types of arguments. The type system is described in Types and defining a function in terms of methods chosen by multiple dispatch on run-time argument types is described in Methods."
},

{
    "location": "manual/control-flow.html#",
    "page": "Control Flow",
    "title": "Control Flow",
    "category": "page",
    "text": ""
},

{
    "location": "manual/control-flow.html#Control-Flow-1",
    "page": "Control Flow",
    "title": "Control Flow",
    "category": "section",
    "text": "Julia provides a variety of control flow constructs:Compound Expressions: begin and (;).\nConditional Evaluation: if-elseif-else and ?: (ternary operator).\nShort-Circuit Evaluation: &&, || and chained comparisons.\nRepeated Evaluation: Loops: while and for.\nException Handling: try-catch, error and throw.\nTasks (aka Coroutines): yieldto.The first five control flow mechanisms are standard to high-level programming languages. Tasks are not so standard: they provide non-local control flow, making it possible to switch between temporarily-suspended computations. This is a powerful construct: both exception handling and cooperative multitasking are implemented in Julia using tasks. Everyday programming requires no direct usage of tasks, but certain problems can be solved much more easily by using tasks."
},

{
    "location": "manual/control-flow.html#man-compound-expressions-1",
    "page": "Control Flow",
    "title": "Compound Expressions",
    "category": "section",
    "text": "Sometimes it is convenient to have a single expression which evaluates several subexpressions in order, returning the value of the last subexpression as its value. There are two Julia constructs that accomplish this: begin blocks and (;) chains. The value of both compound expression constructs is that of the last subexpression. Here\'s an example of a begin block:julia> z = begin\n           x = 1\n           y = 2\n           x + y\n       end\n3Since these are fairly small, simple expressions, they could easily be placed onto a single line, which is where the (;) chain syntax comes in handy:julia> z = (x = 1; y = 2; x + y)\n3This syntax is particularly useful with the terse single-line function definition form introduced in Functions. Although it is typical, there is no requirement that begin blocks be multiline or that (;) chains be single-line:julia> begin x = 1; y = 2; x + y end\n3\n\njulia> (x = 1;\n        y = 2;\n        x + y)\n3"
},

{
    "location": "manual/control-flow.html#man-conditional-evaluation-1",
    "page": "Control Flow",
    "title": "Conditional Evaluation",
    "category": "section",
    "text": "Conditional evaluation allows portions of code to be evaluated or not evaluated depending on the value of a boolean expression. Here is the anatomy of the if-elseif-else conditional syntax:if x < y\n    println(\"x is less than y\")\nelseif x > y\n    println(\"x is greater than y\")\nelse\n    println(\"x is equal to y\")\nendIf the condition expression x < y is true, then the corresponding block is evaluated; otherwise the condition expression x > y is evaluated, and if it is true, the corresponding block is evaluated; if neither expression is true, the else block is evaluated. Here it is in action:julia> function test(x, y)\n           if x < y\n               println(\"x is less than y\")\n           elseif x > y\n               println(\"x is greater than y\")\n           else\n               println(\"x is equal to y\")\n           end\n       end\ntest (generic function with 1 method)\n\njulia> test(1, 2)\nx is less than y\n\njulia> test(2, 1)\nx is greater than y\n\njulia> test(1, 1)\nx is equal to yThe elseif and else blocks are optional, and as many elseif blocks as desired can be used. The condition expressions in the if-elseif-else construct are evaluated until the first one evaluates to true, after which the associated block is evaluated, and no further condition expressions or blocks are evaluated.if blocks are \"leaky\", i.e. they do not introduce a local scope. This means that new variables defined inside the if clauses can be used after the if block, even if they weren\'t defined before. So, we could have defined the test function above asjulia> function test(x,y)\n           if x < y\n               relation = \"less than\"\n           elseif x == y\n               relation = \"equal to\"\n           else\n               relation = \"greater than\"\n           end\n           println(\"x is \", relation, \" y.\")\n       end\ntest (generic function with 1 method)\n\njulia> test(2, 1)\nx is greater than y.The variable relation is declared inside the if block, but used outside. However, when depending on this behavior, make sure all possible code paths define a value for the variable. The following change to the above function results in a runtime errorjulia> function test(x,y)\n           if x < y\n               relation = \"less than\"\n           elseif x == y\n               relation = \"equal to\"\n           end\n           println(\"x is \", relation, \" y.\")\n       end\ntest (generic function with 1 method)\n\njulia> test(1,2)\nx is less than y.\n\njulia> test(2,1)\nERROR: UndefVarError: relation not defined\nStacktrace:\n [1] test(::Int64, ::Int64) at ./none:7if blocks also return a value, which may seem unintuitive to users coming from many other languages. This value is simply the return value of the last executed statement in the branch that was chosen, sojulia> x = 3\n3\n\njulia> if x > 0\n           \"positive!\"\n       else\n           \"negative...\"\n       end\n\"positive!\"Note that very short conditional statements (one-liners) are frequently expressed using Short-Circuit Evaluation in Julia, as outlined in the next section.Unlike C, MATLAB, Perl, Python, and Ruby – but like Java, and a few other stricter, typed languages – it is an error if the value of a conditional expression is anything but true or false:julia> if 1\n           println(\"true\")\n       end\nERROR: TypeError: non-boolean (Int64) used in boolean contextThis error indicates that the conditional was of the wrong type: Int64 rather than the required Bool.The so-called \"ternary operator\", ?:, is closely related to the if-elseif-else syntax, but is used where a conditional choice between single expression values is required, as opposed to conditional execution of longer blocks of code. It gets its name from being the only operator in most languages taking three operands:a ? b : cThe expression a, before the ?, is a condition expression, and the ternary operation evaluates the expression b, before the :, if the condition a is true or the expression c, after the :, if it is false. Note that the spaces around ? and : are mandatory: an expression like a?b:c is not a valid ternary expression (but a newline is acceptable after both the ? and the :).The easiest way to understand this behavior is to see an example. In the previous example, the println call is shared by all three branches: the only real choice is which literal string to print. This could be written more concisely using the ternary operator. For the sake of clarity, let\'s try a two-way version first:julia> x = 1; y = 2;\n\njulia> println(x < y ? \"less than\" : \"not less than\")\nless than\n\njulia> x = 1; y = 0;\n\njulia> println(x < y ? \"less than\" : \"not less than\")\nnot less thanIf the expression x < y is true, the entire ternary operator expression evaluates to the string \"less than\" and otherwise it evaluates to the string \"not less than\". The original three-way example requires chaining multiple uses of the ternary operator together:julia> test(x, y) = println(x < y ? \"x is less than y\"    :\n                            x > y ? \"x is greater than y\" : \"x is equal to y\")\ntest (generic function with 1 method)\n\njulia> test(1, 2)\nx is less than y\n\njulia> test(2, 1)\nx is greater than y\n\njulia> test(1, 1)\nx is equal to yTo facilitate chaining, the operator associates from right to left.It is significant that like if-elseif-else, the expressions before and after the : are only evaluated if the condition expression evaluates to true or false, respectively:julia> v(x) = (println(x); x)\nv (generic function with 1 method)\n\njulia> 1 < 2 ? v(\"yes\") : v(\"no\")\nyes\n\"yes\"\n\njulia> 1 > 2 ? v(\"yes\") : v(\"no\")\nno\n\"no\""
},

{
    "location": "manual/control-flow.html#Short-Circuit-Evaluation-1",
    "page": "Control Flow",
    "title": "Short-Circuit Evaluation",
    "category": "section",
    "text": "Short-circuit evaluation is quite similar to conditional evaluation. The behavior is found in most imperative programming languages having the && and || boolean operators: in a series of boolean expressions connected by these operators, only the minimum number of expressions are evaluated as are necessary to determine the final boolean value of the entire chain. Explicitly, this means that:In the expression a && b, the subexpression b is only evaluated if a evaluates to true.\nIn the expression a || b, the subexpression b is only evaluated if a evaluates to false.The reasoning is that a && b must be false if a is false, regardless of the value of b, and likewise, the value of a || b must be true if a is true, regardless of the value of b. Both && and || associate to the right, but && has higher precedence than || does. It\'s easy to experiment with this behavior:julia> t(x) = (println(x); true)\nt (generic function with 1 method)\n\njulia> f(x) = (println(x); false)\nf (generic function with 1 method)\n\njulia> t(1) && t(2)\n1\n2\ntrue\n\njulia> t(1) && f(2)\n1\n2\nfalse\n\njulia> f(1) && t(2)\n1\nfalse\n\njulia> f(1) && f(2)\n1\nfalse\n\njulia> t(1) || t(2)\n1\ntrue\n\njulia> t(1) || f(2)\n1\ntrue\n\njulia> f(1) || t(2)\n1\n2\ntrue\n\njulia> f(1) || f(2)\n1\n2\nfalseYou can easily experiment in the same way with the associativity and precedence of various combinations of && and || operators.This behavior is frequently used in Julia to form an alternative to very short if statements. Instead of if <cond> <statement> end, one can write <cond> && <statement> (which could be read as: <cond> and then <statement>). Similarly, instead of if ! <cond> <statement> end, one can write <cond> || <statement> (which could be read as: <cond> or else <statement>).For example, a recursive factorial routine could be defined like this:julia> function fact(n::Int)\n           n >= 0 || error(\"n must be non-negative\")\n           n == 0 && return 1\n           n * fact(n-1)\n       end\nfact (generic function with 1 method)\n\njulia> fact(5)\n120\n\njulia> fact(0)\n1\n\njulia> fact(-1)\nERROR: n must be non-negative\nStacktrace:\n [1] error at ./error.jl:33 [inlined]\n [2] fact(::Int64) at ./none:2\n [3] top-level scopeBoolean operations without short-circuit evaluation can be done with the bitwise boolean operators introduced in Mathematical Operations and Elementary Functions: & and |. These are normal functions, which happen to support infix operator syntax, but always evaluate their arguments:julia> f(1) & t(2)\n1\n2\nfalse\n\njulia> t(1) | t(2)\n1\n2\ntrueJust like condition expressions used in if, elseif or the ternary operator, the operands of && or || must be boolean values (true or false). Using a non-boolean value anywhere except for the last entry in a conditional chain is an error:julia> 1 && true\nERROR: TypeError: non-boolean (Int64) used in boolean contextOn the other hand, any type of expression can be used at the end of a conditional chain. It will be evaluated and returned depending on the preceding conditionals:julia> true && (x = (1, 2, 3))\n(1, 2, 3)\n\njulia> false && (x = (1, 2, 3))\nfalse"
},

{
    "location": "manual/control-flow.html#man-loops-1",
    "page": "Control Flow",
    "title": "Repeated Evaluation: Loops",
    "category": "section",
    "text": "There are two constructs for repeated evaluation of expressions: the while loop and the for loop. Here is an example of a while loop:julia> i = 1;\n\njulia> while i <= 5\n           println(i)\n           global i += 1\n       end\n1\n2\n3\n4\n5The while loop evaluates the condition expression (i <= 5 in this case), and as long it remains true, keeps also evaluating the body of the while loop. If the condition expression is false when the while loop is first reached, the body is never evaluated.The for loop makes common repeated evaluation idioms easier to write. Since counting up and down like the above while loop does is so common, it can be expressed more concisely with a for loop:julia> for i = 1:5\n           println(i)\n       end\n1\n2\n3\n4\n5Here the 1:5 is a range object, representing the sequence of numbers 1, 2, 3, 4, 5. The for loop iterates through these values, assigning each one in turn to the variable i. One rather important distinction between the previous while loop form and the for loop form is the scope during which the variable is visible. If the variable i has not been introduced in another scope, in the for loop form, it is visible only inside of the for loop, and not outside/afterwards. You\'ll either need a new interactive session instance or a different variable name to test this:julia> for j = 1:5\n           println(j)\n       end\n1\n2\n3\n4\n5\n\njulia> j\nERROR: UndefVarError: j not definedSee Scope of Variables for a detailed explanation of variable scope and how it works in Julia.In general, the for loop construct can iterate over any container. In these cases, the alternative (but fully equivalent) keyword in or ∈ is typically used instead of =, since it makes the code read more clearly:julia> for i in [1,4,0]\n           println(i)\n       end\n1\n4\n0\n\njulia> for s ∈ [\"foo\",\"bar\",\"baz\"]\n           println(s)\n       end\nfoo\nbar\nbazVarious types of iterable containers will be introduced and discussed in later sections of the manual (see, e.g., Multi-dimensional Arrays).It is sometimes convenient to terminate the repetition of a while before the test condition is falsified or stop iterating in a for loop before the end of the iterable object is reached. This can be accomplished with the break keyword:julia> i = 1;\n\njulia> while true\n           println(i)\n           if i >= 5\n               break\n           end\n           global i += 1\n       end\n1\n2\n3\n4\n5\n\njulia> for j = 1:1000\n           println(j)\n           if j >= 5\n               break\n           end\n       end\n1\n2\n3\n4\n5Without the break keyword, the above while loop would never terminate on its own, and the for loop would iterate up to 1000. These loops are both exited early by using break.In other circumstances, it is handy to be able to stop an iteration and move on to the next one immediately. The continue keyword accomplishes this:julia> for i = 1:10\n           if i % 3 != 0\n               continue\n           end\n           println(i)\n       end\n3\n6\n9This is a somewhat contrived example since we could produce the same behavior more clearly by negating the condition and placing the println call inside the if block. In realistic usage there is more code to be evaluated after the continue, and often there are multiple points from which one calls continue.Multiple nested for loops can be combined into a single outer loop, forming the cartesian product of its iterables:julia> for i = 1:2, j = 3:4\n           println((i, j))\n       end\n(1, 3)\n(1, 4)\n(2, 3)\n(2, 4)With this syntax, iterables may still refer to outer loop variables; e.g. for i = 1:n, j = 1:i is valid. However a break statement inside such a loop exits the entire nest of loops, not just the inner one. Both variables (i and j) are set to their current iteration values each time the inner loop runs. Therefore, assignments to i will not be visible to subsequent iterations:julia> for i = 1:2, j = 3:4\n           println((i, j))\n           i = 0\n       end\n(1, 3)\n(1, 4)\n(2, 3)\n(2, 4)If this example were rewritten to use a for keyword for each variable, then the output would be different: the second and fourth values would contain 0."
},

{
    "location": "manual/control-flow.html#Exception-Handling-1",
    "page": "Control Flow",
    "title": "Exception Handling",
    "category": "section",
    "text": "When an unexpected condition occurs, a function may be unable to return a reasonable value to its caller. In such cases, it may be best for the exceptional condition to either terminate the program while printing a diagnostic error message, or if the programmer has provided code to handle such exceptional circumstances then allow that code to take the appropriate action."
},

{
    "location": "manual/control-flow.html#Built-in-Exceptions-1",
    "page": "Control Flow",
    "title": "Built-in Exceptions",
    "category": "section",
    "text": "Exceptions are thrown when an unexpected condition has occurred. The built-in Exceptions listed below all interrupt the normal flow of control.Exception\nArgumentError\nBoundsError\nCompositeException\nDivideError\nDomainError\nEOFError\nErrorException\nInexactError\nInitError\nInterruptException\nInvalidStateException\nKeyError\nLoadError\nOutOfMemoryError\nReadOnlyMemoryError\nRemoteException\nMethodError\nOverflowError\nMeta.ParseError\nSystemError\nTypeError\nUndefRefError\nUndefVarError\nStringIndexErrorFor example, the sqrt function throws a DomainError if applied to a negative real value:julia> sqrt(-1)\nERROR: DomainError with -1.0:\nsqrt will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\nStacktrace:\n[...]You may define your own exceptions in the following way:julia> struct MyCustomException <: Exception end"
},

{
    "location": "manual/control-flow.html#The-[throw](@ref)-function-1",
    "page": "Control Flow",
    "title": "The throw function",
    "category": "section",
    "text": "Exceptions can be created explicitly with throw. For example, a function defined only for nonnegative numbers could be written to throw a DomainError if the argument is negative:julia> f(x) = x>=0 ? exp(-x) : throw(DomainError(x, \"argument must be nonnegative\"))\nf (generic function with 1 method)\n\njulia> f(1)\n0.36787944117144233\n\njulia> f(-1)\nERROR: DomainError with -1:\nargument must be nonnegative\nStacktrace:\n [1] f(::Int64) at ./none:1Note that DomainError without parentheses is not an exception, but a type of exception. It needs to be called to obtain an Exception object:julia> typeof(DomainError(nothing)) <: Exception\ntrue\n\njulia> typeof(DomainError) <: Exception\nfalseAdditionally, some exception types take one or more arguments that are used for error reporting:julia> throw(UndefVarError(:x))\nERROR: UndefVarError: x not definedThis mechanism can be implemented easily by custom exception types following the way UndefVarError is written:julia> struct MyUndefVarError <: Exception\n           var::Symbol\n       end\n\njulia> Base.showerror(io::IO, e::MyUndefVarError) = print(io, e.var, \" not defined\")note: Note\nWhen writing an error message, it is preferred to make the first word lowercase. For example, size(A) == size(B) || throw(DimensionMismatch(\"size of A not equal to size of B\"))is preferred oversize(A) == size(B) || throw(DimensionMismatch(\"Size of A not equal to size of B\")).However, sometimes it makes sense to keep the uppercase first letter, for instance if an argument to a function is a capital letter: size(A,1) == size(B,2) || throw(DimensionMismatch(\"A has first dimension...\"))."
},

{
    "location": "manual/control-flow.html#Errors-1",
    "page": "Control Flow",
    "title": "Errors",
    "category": "section",
    "text": "The error function is used to produce an ErrorException that interrupts the normal flow of control.Suppose we want to stop execution immediately if the square root of a negative number is taken. To do this, we can define a fussy version of the sqrt function that raises an error if its argument is negative:julia> fussy_sqrt(x) = x >= 0 ? sqrt(x) : error(\"negative x not allowed\")\nfussy_sqrt (generic function with 1 method)\n\njulia> fussy_sqrt(2)\n1.4142135623730951\n\njulia> fussy_sqrt(-1)\nERROR: negative x not allowed\nStacktrace:\n [1] error at ./error.jl:33 [inlined]\n [2] fussy_sqrt(::Int64) at ./none:1\n [3] top-level scopeIf fussy_sqrt is called with a negative value from another function, instead of trying to continue execution of the calling function, it returns immediately, displaying the error message in the interactive session:julia> function verbose_fussy_sqrt(x)\n           println(\"before fussy_sqrt\")\n           r = fussy_sqrt(x)\n           println(\"after fussy_sqrt\")\n           return r\n       end\nverbose_fussy_sqrt (generic function with 1 method)\n\njulia> verbose_fussy_sqrt(2)\nbefore fussy_sqrt\nafter fussy_sqrt\n1.4142135623730951\n\njulia> verbose_fussy_sqrt(-1)\nbefore fussy_sqrt\nERROR: negative x not allowed\nStacktrace:\n [1] error at ./error.jl:33 [inlined]\n [2] fussy_sqrt at ./none:1 [inlined]\n [3] verbose_fussy_sqrt(::Int64) at ./none:3\n [4] top-level scope"
},

{
    "location": "manual/control-flow.html#The-try/catch-statement-1",
    "page": "Control Flow",
    "title": "The try/catch statement",
    "category": "section",
    "text": "The try/catch statement allows for Exceptions to be tested for. For example, a customized square root function can be written to automatically call either the real or complex square root method on demand using Exceptions :julia> f(x) = try\n           sqrt(x)\n       catch\n           sqrt(complex(x, 0))\n       end\nf (generic function with 1 method)\n\njulia> f(1)\n1.0\n\njulia> f(-1)\n0.0 + 1.0imIt is important to note that in real code computing this function, one would compare x to zero instead of catching an exception. The exception is much slower than simply comparing and branching.try/catch statements also allow the Exception to be saved in a variable. The following contrived example calculates the square root of the second element of x if x is indexable, otherwise assumes x is a real number and returns its square root:julia> sqrt_second(x) = try\n           sqrt(x[2])\n       catch y\n           if isa(y, DomainError)\n               sqrt(complex(x[2], 0))\n           elseif isa(y, BoundsError)\n               sqrt(x)\n           end\n       end\nsqrt_second (generic function with 1 method)\n\njulia> sqrt_second([1 4])\n2.0\n\njulia> sqrt_second([1 -4])\n0.0 + 2.0im\n\njulia> sqrt_second(9)\n3.0\n\njulia> sqrt_second(-9)\nERROR: DomainError with -9.0:\nsqrt will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\nStacktrace:\n[...]Note that the symbol following catch will always be interpreted as a name for the exception, so care is needed when writing try/catch expressions on a single line. The following code will not work to return the value of x in case of an error:try bad() catch x endInstead, use a semicolon or insert a line break after catch:try bad() catch; x end\n\ntry bad()\ncatch\n    x\nendThe power of the try/catch construct lies in the ability to unwind a deeply nested computation immediately to a much higher level in the stack of calling functions. There are situations where no error has occurred, but the ability to unwind the stack and pass a value to a higher level is desirable. Julia provides the rethrow, backtrace, catch_backtrace and Base.catch_stack functions for more advanced error handling."
},

{
    "location": "manual/control-flow.html#finally-Clauses-1",
    "page": "Control Flow",
    "title": "finally Clauses",
    "category": "section",
    "text": "In code that performs state changes or uses resources like files, there is typically clean-up work (such as closing files) that needs to be done when the code is finished. Exceptions potentially complicate this task, since they can cause a block of code to exit before reaching its normal end. The finally keyword provides a way to run some code when a given block of code exits, regardless of how it exits.For example, here is how we can guarantee that an opened file is closed:f = open(\"file\")\ntry\n    # operate on file f\nfinally\n    close(f)\nendWhen control leaves the try block (for example due to a return, or just finishing normally), close(f) will be executed. If the try block exits due to an exception, the exception will continue propagating. A catch block may be combined with try and finally as well. In this case the finally block will run after catch has handled the error."
},

{
    "location": "manual/control-flow.html#man-tasks-1",
    "page": "Control Flow",
    "title": "Tasks (aka Coroutines)",
    "category": "section",
    "text": "Tasks are a control flow feature that allows computations to be suspended and resumed in a flexible manner. This feature is sometimes called by other names, such as symmetric coroutines, lightweight threads, cooperative multitasking, or one-shot continuations.When a piece of computing work (in practice, executing a particular function) is designated as a Task, it becomes possible to interrupt it by switching to another Task. The original Task can later be resumed, at which point it will pick up right where it left off. At first, this may seem similar to a function call. However there are two key differences. First, switching tasks does not use any space, so any number of task switches can occur without consuming the call stack. Second, switching among tasks can occur in any order, unlike function calls, where the called function must finish executing before control returns to the calling function.This kind of control flow can make it much easier to solve certain problems. In some problems, the various pieces of required work are not naturally related by function calls; there is no obvious \"caller\" or \"callee\" among the jobs that need to be done. An example is the producer-consumer problem, where one complex procedure is generating values and another complex procedure is consuming them. The consumer cannot simply call a producer function to get a value, because the producer may have more values to generate and so might not yet be ready to return. With tasks, the producer and consumer can both run as long as they need to, passing values back and forth as necessary.Julia provides a Channel mechanism for solving this problem. A Channel is a waitable first-in first-out queue which can have multiple tasks reading from and writing to it.Let\'s define a producer task, which produces values via the put! call. To consume values, we need to schedule the producer to run in a new task. A special Channel constructor which accepts a 1-arg function as an argument can be used to run a task bound to a channel. We can then take! values repeatedly from the channel object:julia> function producer(c::Channel)\n           put!(c, \"start\")\n           for n=1:4\n               put!(c, 2n)\n           end\n           put!(c, \"stop\")\n       end;\n\njulia> chnl = Channel(producer);\n\njulia> take!(chnl)\n\"start\"\n\njulia> take!(chnl)\n2\n\njulia> take!(chnl)\n4\n\njulia> take!(chnl)\n6\n\njulia> take!(chnl)\n8\n\njulia> take!(chnl)\n\"stop\"One way to think of this behavior is that producer was able to return multiple times. Between calls to put!, the producer\'s execution is suspended and the consumer has control.The returned Channel can be used as an iterable object in a for loop, in which case the loop variable takes on all the produced values. The loop is terminated when the channel is closed.julia> for x in Channel(producer)\n           println(x)\n       end\nstart\n2\n4\n6\n8\nstopNote that we did not have to explicitly close the channel in the producer. This is because the act of binding a Channel to a Task associates the open lifetime of a channel with that of the bound task. The channel object is closed automatically when the task terminates. Multiple channels can be bound to a task, and vice-versa.While the Task constructor expects a 0-argument function, the Channel method which creates a channel bound task expects a function that accepts a single argument of type Channel. A common pattern is for the producer to be parameterized, in which case a partial function application is needed to create a 0 or 1 argument anonymous function.For Task objects this can be done either directly or by use of a convenience macro:function mytask(myarg)\n    ...\nend\n\ntaskHdl = Task(() -> mytask(7))\n# or, equivalently\ntaskHdl = @task mytask(7)To orchestrate more advanced work distribution patterns, bind and schedule can be used in conjunction with Task and Channel constructors to explicitly link a set of channels with a set of producer/consumer tasks.Note that currently Julia tasks are not scheduled to run on separate CPU cores. True kernel threads are discussed under the topic of Parallel Computing."
},

{
    "location": "manual/control-flow.html#Core-task-operations-1",
    "page": "Control Flow",
    "title": "Core task operations",
    "category": "section",
    "text": "Let us explore the low level construct yieldto to understand how task switching works. yieldto(task,value) suspends the current task, switches to the specified task, and causes that task\'s last yieldto call to return the specified value. Notice that yieldto is the only operation required to use task-style control flow; instead of calling and returning we are always just switching to a different task. This is why this feature is also called \"symmetric coroutines\"; each task is switched to and from using the same mechanism.yieldto is powerful, but most uses of tasks do not invoke it directly. Consider why this might be. If you switch away from the current task, you will probably want to switch back to it at some point, but knowing when to switch back, and knowing which task has the responsibility of switching back, can require considerable coordination. For example, put! and take! are blocking operations, which, when used in the context of channels maintain state to remember who the consumers are. Not needing to manually keep track of the consuming task is what makes put! easier to use than the low-level yieldto.In addition to yieldto, a few other basic functions are needed to use tasks effectively.current_task gets a reference to the currently-running task.\nistaskdone queries whether a task has exited.\nistaskstarted queries whether a task has run yet.\ntask_local_storage manipulates a key-value store specific to the current task."
},

{
    "location": "manual/control-flow.html#Tasks-and-events-1",
    "page": "Control Flow",
    "title": "Tasks and events",
    "category": "section",
    "text": "Most task switches occur as a result of waiting for events such as I/O requests, and are performed by a scheduler included in Julia Base. The scheduler maintains a queue of runnable tasks, and executes an event loop that restarts tasks based on external events such as message arrival.The basic function for waiting for an event is wait. Several objects implement wait; for example, given a Process object, wait will wait for it to exit. wait is often implicit; for example, a wait can happen inside a call to read to wait for data to be available.In all of these cases, wait ultimately operates on a Condition object, which is in charge of queueing and restarting tasks. When a task calls wait on a Condition, the task is marked as non-runnable, added to the condition\'s queue, and switches to the scheduler. The scheduler will then pick another task to run, or block waiting for external events. If all goes well, eventually an event handler will call notify on the condition, which causes tasks waiting for that condition to become runnable again.A task created explicitly by calling Task is initially not known to the scheduler. This allows you to manage tasks manually using yieldto if you wish. However, when such a task waits for an event, it still gets restarted automatically when the event happens, as you would expect. It is also possible to make the scheduler run a task whenever it can, without necessarily waiting for any events. This is done by calling schedule, or using the @async macro (see Parallel Computing for more details)."
},

{
    "location": "manual/control-flow.html#Task-states-1",
    "page": "Control Flow",
    "title": "Task states",
    "category": "section",
    "text": "Tasks have a state field that describes their execution status. A Task state is one of the following symbols:Symbol Meaning\n:runnable Currently running, or available to be switched to\n:waiting Blocked waiting for a specific event\n:queued In the scheduler\'s run queue about to be restarted\n:done Successfully finished executing\n:failed Finished with an uncaught exception"
},

{
    "location": "manual/variables-and-scoping.html#",
    "page": "Scope of Variables",
    "title": "Scope of Variables",
    "category": "page",
    "text": ""
},

{
    "location": "manual/variables-and-scoping.html#scope-of-variables-1",
    "page": "Scope of Variables",
    "title": "Scope of Variables",
    "category": "section",
    "text": "The scope of a variable is the region of code within which a variable is visible. Variable scoping helps avoid variable naming conflicts. The concept is intuitive: two functions can both have arguments called x without the two x\'s referring to the same thing. Similarly, there are many other cases where different blocks of code can use the same name without referring to the same thing. The rules for when the same variable name does or doesn\'t refer to the same thing are called scope rules; this section spells them out in detail.Certain constructs in the language introduce scope blocks, which are regions of code that are eligible to be the scope of some set of variables. The scope of a variable cannot be an arbitrary set of source lines; instead, it will always line up with one of these blocks. There are two main types of scopes in Julia, global scope and local scope. The latter can be nested. The constructs introducing scope blocks are:"
},

{
    "location": "manual/variables-and-scoping.html#man-scope-table-1",
    "page": "Scope of Variables",
    "title": "Scope constructs",
    "category": "section",
    "text": "Construct Scope type Scope blocks it may be nested in\nmodule, baremodule global global\ninteractive prompt (REPL) global global\n(mutable) struct, macro local global\nfor, while, try-catch-finally, let local global or local\nfunctions (either syntax, anonymous & do-blocks) local global or local\ncomprehensions, broadcast-fusing local global or localNotably missing from this table are begin blocks and if blocks which do not introduce new scopes. Both types of scopes follow somewhat different rules which will be explained below.Julia uses lexical scoping, meaning that a function\'s scope does not inherit from its caller\'s scope, but from the scope in which the function was defined. For example, in the following code the x inside foo refers to the x in the global scope of its module Bar:julia> module Bar\n           x = 1\n           foo() = x\n       end;and not a x in the scope where foo is used:julia> import .Bar\n\njulia> x = -1;\n\njulia> Bar.foo()\n1Thus lexical scope means that the scope of variables can be inferred from the source code alone."
},

{
    "location": "manual/variables-and-scoping.html#Global-Scope-1",
    "page": "Scope of Variables",
    "title": "Global Scope",
    "category": "section",
    "text": "Each module introduces a new global scope, separate from the global scope of all other modules; there is no all-encompassing global scope. Modules can introduce variables of other modules into their scope through the using or import statements or through qualified access using the dot-notation, i.e. each module is a so-called namespace. Note that variable bindings can only be changed within their global scope and not from an outside module.julia> module A\n           a = 1 # a global in A\'s scope\n       end;\n\njulia> module B\n           module C\n               c = 2\n           end\n           b = C.c    # can access the namespace of a nested global scope\n                      # through a qualified access\n           import ..A # makes module A available\n           d = A.a\n       end;\n\njulia> module D\n           b = a # errors as D\'s global scope is separate from A\'s\n       end;\nERROR: UndefVarError: a not defined\n\njulia> module E\n           import ..A # make module A available\n           A.a = 2    # throws below error\n       end;\nERROR: cannot assign variables in other modulesNote that the interactive prompt (aka REPL) is in the global scope of the module Main."
},

{
    "location": "manual/variables-and-scoping.html#Local-Scope-1",
    "page": "Scope of Variables",
    "title": "Local Scope",
    "category": "section",
    "text": "A new local scope is introduced by most code blocks (see above table for a complete list). A local scope inherits all the variables from a parent local scope, both for reading and writing. Unlike global scopes, local scopes are not namespaces, thus variables in an inner scope cannot be retrieved from the parent scope through some sort of qualified access.The following rules and examples pertain to local scopes. A newly introduced variable in a local scope cannot be referenced by a parent scope. For example, here the z is not introduced into the top-level scope:julia> for i = 1:10\n           z = i\n       end\n\njulia> z\nERROR: UndefVarError: z not definednote: Note\nIn this and all following examples it is assumed that their top-level is a global scope with a clean workspace, for instance a newly started REPL.Inner local scopes can, however, update variables in their parent scopes:julia> for i = 1:1\n           z = i\n           for j = 1:1\n               z = 0\n           end\n           println(z)\n       end\n0Inside a local scope a variable can be forced to be a new local variable using the local keyword:julia> for i = 1:1\n           x = i + 1\n           for j = 1:1\n               local x = 0\n           end\n           println(x)\n       end\n2Inside a local scope a global variable can be assigned to by using the keyword global:julia> for i = 1:10\n           global z\n           z = i\n       end\n\njulia> z\n10The location of both the local and global keywords within the scope block is irrelevant. The following is equivalent to the last example (although stylistically worse):julia> for i = 1:10\n           z = i\n           global z\n       end\n\njulia> z\n10The local and global keywords can also be applied to destructuring assignments, e.g. local x, y = 1, 2. In this case the keyword affects all listed variables.In a local scope, all variables are inherited from its parent global scope block unless:an assignment would result in a modified global variable, or\na variable is specifically marked with the keyword local.Thus global variables are only inherited for reading, not for writing:julia> x, y = 1, 2;\n\njulia> function foo()\n           x = 2        # assignment introduces a new local\n           return x + y # y refers to the global\n       end;\n\njulia> foo()\n4\n\njulia> x\n1An explicit global is needed to assign to a global variable:sidebar: Avoiding globals\nAvoiding changing the value of global variables is considered by many to be a programming best-practice. Changing the value of a global variable can cause \"action at a distance\", making the behavior of a program harder to reason about. This is why the scope blocks that introduce local scope require the global keyword to declare the intent to modify a global variable.julia> x = 1;\n\njulia> function foobar()\n           global x = 2\n       end;\n\njulia> foobar();\n\njulia> x\n2Note that nested functions can modify their parent scope\'s local variables:julia> x, y = 1, 2;\n\njulia> function baz()\n           x = 2 # introduces a new local\n           function bar()\n               x = 10       # modifies the parent\'s x\n               return x + y # y is global\n           end\n           return bar() + x # 12 + 10 (x is modified in call of bar())\n       end;\n\njulia> baz()\n22\n\njulia> x, y # verify that global x and y are unchanged\n(1, 2)The reason to allow modifying local variables of parent scopes in nested functions is to allow constructing closures which have private state, for instance the state variable in the following example:julia> let state = 0\n           global counter() = (state += 1)\n       end;\n\njulia> counter()\n1\n\njulia> counter()\n2See also the closures in the examples in the next two sections. A variable, such as x in the first example and state in the second, that is inherited from the enclosing scope by the inner function is sometimes called a captured variable. Captured variables can present performance challenges discussed in performance tips.The distinction between inheriting global scope and nesting local scope can lead to some slight differences between functions defined in local versus global scopes for variable assignments. Consider the modification of the last example by moving bar to the global scope:julia> x, y = 1, 2;\n\njulia> function bar()\n           x = 10 # local, no longer a closure variable\n           return x + y\n       end;\n\njulia> function quz()\n           x = 2 # local\n           return bar() + x # 12 + 2 (x is not modified)\n       end;\n\njulia> quz()\n14\n\njulia> x, y # verify that global x and y are unchanged\n(1, 2)Note that the above nesting rules do not pertain to type and macro definitions as they can only appear at the global scope. There are special scoping rules concerning the evaluation of default and keyword function arguments which are described in the Function section.An assignment introducing a variable used inside a function, type or macro definition need not come before its inner usage:julia> f = y -> y + a;\n\njulia> f(3)\nERROR: UndefVarError: a not defined\nStacktrace:\n[...]\n\njulia> a = 1\n1\n\njulia> f(3)\n4This behavior may seem slightly odd for a normal variable, but allows for named functions – which are just normal variables holding function objects – to be used before they are defined. This allows functions to be defined in whatever order is intuitive and convenient, rather than forcing bottom up ordering or requiring forward declarations, as long as they are defined by the time they are actually called. As an example, here is an inefficient, mutually recursive way to test if positive integers are even or odd:julia> even(n) = (n == 0) ? true : odd(n - 1);\n\njulia> odd(n) = (n == 0) ? false : even(n - 1);\n\njulia> even(3)\nfalse\n\njulia> odd(3)\ntrueJulia provides built-in, efficient functions to test for oddness and evenness called iseven and isodd so the above definitions should only be considered to be examples of scope, not efficient design."
},

{
    "location": "manual/variables-and-scoping.html#Let-Blocks-1",
    "page": "Scope of Variables",
    "title": "Let Blocks",
    "category": "section",
    "text": "Unlike assignments to local variables, let statements allocate new variable bindings each time they run. An assignment modifies an existing value location, and let creates new locations. This difference is usually not important, and is only detectable in the case of variables that outlive their scope via closures. The let syntax accepts a comma-separated series of assignments and variable names:julia> x, y, z = -1, -1, -1;\n\njulia> let x = 1, z\n           println(\"x: $x, y: $y\") # x is local variable, y the global\n           println(\"z: $z\") # errors as z has not been assigned yet but is local\n       end\nx: 1, y: -1\nERROR: UndefVarError: z not definedThe assignments are evaluated in order, with each right-hand side evaluated in the scope before the new variable on the left-hand side has been introduced. Therefore it makes sense to write something like let x = x since the two x variables are distinct and have separate storage. Here is an example where the behavior of let is needed:julia> Fs = Vector{Any}(undef, 2); i = 1;\n\njulia> while i <= 2\n           Fs[i] = ()->i\n           global i += 1\n       end\n\njulia> Fs[1]()\n3\n\njulia> Fs[2]()\n3Here we create and store two closures that return variable i. However, it is always the same variable i, so the two closures behave identically. We can use let to create a new binding for i:julia> Fs = Vector{Any}(undef, 2); i = 1;\n\njulia> while i <= 2\n           let i = i\n               Fs[i] = ()->i\n           end\n           global i += 1\n       end\n\njulia> Fs[1]()\n1\n\njulia> Fs[2]()\n2Since the begin construct does not introduce a new scope, it can be useful to use a zero-argument let to just introduce a new scope block without creating any new bindings:julia> let\n           local x = 1\n           let\n               local x = 2\n           end\n           x\n       end\n1Since let introduces a new scope block, the inner local x is a different variable than the outer local x."
},

{
    "location": "manual/variables-and-scoping.html#For-Loops-and-Comprehensions-1",
    "page": "Scope of Variables",
    "title": "For Loops and Comprehensions",
    "category": "section",
    "text": "for loops, while loops, and Comprehensions have the following behavior: any new variables introduced in their body scopes are freshly allocated for each loop iteration, as if the loop body were surrounded by a let block:julia> Fs = Vector{Any}(undef, 2);\n\njulia> for j = 1:2\n           Fs[j] = ()->j\n       end\n\njulia> Fs[1]()\n1\n\njulia> Fs[2]()\n2A for loop or comprehension iteration variable is always a new variable:julia> function f()\n           i = 0\n           for i = 1:3\n           end\n           return i\n       end;\n\njulia> f()\n0However, it is occasionally useful to reuse an existing local variable as the iteration variable. This can be done conveniently by adding the keyword outer:julia> function f()\n           i = 0\n           for outer i = 1:3\n           end\n           return i\n       end;\n\njulia> f()\n3"
},

{
    "location": "manual/variables-and-scoping.html#Constants-1",
    "page": "Scope of Variables",
    "title": "Constants",
    "category": "section",
    "text": "A common use of variables is giving names to specific, unchanging values. Such variables are only assigned once. This intent can be conveyed to the compiler using the const keyword:julia> const e  = 2.71828182845904523536;\n\njulia> const pi = 3.14159265358979323846;Multiple variables can be declared in a single const statement:julia> const a, b = 1, 2\n(1, 2)The const declaration should only be used in global scope on globals. It is difficult for the compiler to optimize code involving global variables, since their values (or even their types) might change at almost any time. If a global variable will not change, adding a const declaration solves this performance problem.Local constants are quite different. The compiler is able to determine automatically when a local variable is constant, so local constant declarations are not necessary, and in fact are currently not supported.Special top-level assignments, such as those performed by the function and struct keywords, are constant by default.Note that const only affects the variable binding; the variable may be bound to a mutable object (such as an array), and that object may still be modified. Additionally when one tries to assign a value to a variable that is declared constant the following scenarios are possible:if a new value has a different type than the type of the constant then an error is thrown:julia> const x = 1.0\n1.0\n\njulia> x = 1\nERROR: invalid redefinition of constant xif a new value has the same type as the constant then a warning is printed:julia> const y = 1.0\n1.0\n\njulia> y = 2.0\nWARNING: redefining constant y\n2.0if an assignment would not result in the change of variable value no message is given:julia> const z = 100\n100\n\njulia> z = 100\n100The last rule applies for immutable objects even if the variable binding would change, e.g.:julia> const s1 = \"1\"\n\"1\"\n\njulia> s2 = \"1\"\n\"1\"\n\njulia> pointer.([s1, s2], 1)\n2-element Array{Ptr{UInt8},1}:\n Ptr{UInt8} @0x00000000132c9638\n Ptr{UInt8} @0x0000000013dd3d18\n\njulia> s1 = s2\n\"1\"\n\njulia> pointer.([s1, s2], 1)\n2-element Array{Ptr{UInt8},1}:\n Ptr{UInt8} @0x0000000013dd3d18\n Ptr{UInt8} @0x0000000013dd3d18However, for mutable objects the warning is printed as expected:julia> const a = [1]\n1-element Array{Int64,1}:\n 1\n\njulia> a = [1]\nWARNING: redefining constant a\n1-element Array{Int64,1}:\n 1Note that although sometimes possible, changing the value of a const variable is strongly discouraged, and is intended only for convenience during interactive use. Changing constants can cause various problems or unexpected behaviors. For instance, if a method references a constant and is already compiled before the constant is changed then it might keep using the old value:julia> const x = 1\n1\n\njulia> f() = x\nf (generic function with 1 method)\n\njulia> f()\n1\n\njulia> x = 2\nWARNING: redefining constant x\n2\n\njulia> f()\n1"
},

{
    "location": "manual/types.html#",
    "page": "Types",
    "title": "Types",
    "category": "page",
    "text": ""
},

{
    "location": "manual/types.html#man-types-1",
    "page": "Types",
    "title": "Types",
    "category": "section",
    "text": "Type systems have traditionally fallen into two quite different camps: static type systems, where every program expression must have a type computable before the execution of the program, and dynamic type systems, where nothing is known about types until run time, when the actual values manipulated by the program are available. Object orientation allows some flexibility in statically typed languages by letting code be written without the precise types of values being known at compile time. The ability to write code that can operate on different types is called polymorphism. All code in classic dynamically typed languages is polymorphic: only by explicitly checking types, or when objects fail to support operations at run-time, are the types of any values ever restricted.Julia\'s type system is dynamic, but gains some of the advantages of static type systems by making it possible to indicate that certain values are of specific types. This can be of great assistance in generating efficient code, but even more significantly, it allows method dispatch on the types of function arguments to be deeply integrated with the language. Method dispatch is explored in detail in Methods, but is rooted in the type system presented here.The default behavior in Julia when types are omitted is to allow values to be of any type. Thus, one can write many useful Julia functions without ever explicitly using types. When additional expressiveness is needed, however, it is easy to gradually introduce explicit type annotations into previously \"untyped\" code. Adding annotations serves three primary purposes: to take advantage of Julia\'s powerful multiple-dispatch mechanism,  to improve human readability, and to catch programmer errors.Describing Julia in the lingo of type systems, it is: dynamic, nominative and parametric. Generic types can be parameterized, and the hierarchical relationships between types are explicitly declared, rather than implied by compatible structure. One particularly distinctive feature of Julia\'s type system is that concrete types may not subtype each other: all concrete types are final and may only have abstract types as their supertypes. While this might at first seem unduly restrictive, it has many beneficial consequences with surprisingly few drawbacks. It turns out that being able to inherit behavior is much more important than being able to inherit structure, and inheriting both causes significant difficulties in traditional object-oriented languages. Other high-level aspects of Julia\'s type system that should be mentioned up front are:There is no division between object and non-object values: all values in Julia are true objects having a type that belongs to a single, fully connected type graph, all nodes of which are equally first-class as types.\nThere is no meaningful concept of a \"compile-time type\": the only type a value has is its actual type when the program is running. This is called a \"run-time type\" in object-oriented languages where the combination of static compilation with polymorphism makes this distinction significant.\nOnly values, not variables, have types – variables are simply names bound to values.\nBoth abstract and concrete types can be parameterized by other types. They can also be parameterized by symbols, by values of any type for which isbits returns true (essentially, things like numbers and bools that are stored like C types or structs with no pointers to other objects), and also by tuples thereof. Type parameters may be omitted when they do not need to be referenced or restricted.Julia\'s type system is designed to be powerful and expressive, yet clear, intuitive and unobtrusive. Many Julia programmers may never feel the need to write code that explicitly uses types. Some kinds of programming, however, become clearer, simpler, faster and more robust with declared types."
},

{
    "location": "manual/types.html#Type-Declarations-1",
    "page": "Types",
    "title": "Type Declarations",
    "category": "section",
    "text": "The :: operator can be used to attach type annotations to expressions and variables in programs. There are two primary reasons to do this:As an assertion to help confirm that your program works the way you expect,\nTo provide extra type information to the compiler, which can then improve performance in some casesWhen appended to an expression computing a value, the :: operator is read as \"is an instance of\". It can be used anywhere to assert that the value of the expression on the left is an instance of the type on the right. When the type on the right is concrete, the value on the left must have that type as its implementation – recall that all concrete types are final, so no implementation is a subtype of any other. When the type is abstract, it suffices for the value to be implemented by a concrete type that is a subtype of the abstract type. If the type assertion is not true, an exception is thrown, otherwise, the left-hand value is returned:julia> (1+2)::AbstractFloat\nERROR: TypeError: in typeassert, expected AbstractFloat, got Int64\n\njulia> (1+2)::Int\n3This allows a type assertion to be attached to any expression in-place.When appended to a variable on the left-hand side of an assignment, or as part of a local declaration, the :: operator means something a bit different: it declares the variable to always have the specified type, like a type declaration in a statically-typed language such as C. Every value assigned to the variable will be converted to the declared type using convert:julia> function foo()\n           x::Int8 = 100\n           x\n       end\nfoo (generic function with 1 method)\n\njulia> foo()\n100\n\njulia> typeof(ans)\nInt8This feature is useful for avoiding performance \"gotchas\" that could occur if one of the assignments to a variable changed its type unexpectedly.This \"declaration\" behavior only occurs in specific contexts:local x::Int8  # in a local declaration\nx::Int8 = 10   # as the left-hand side of an assignmentand applies to the whole current scope, even before the declaration. Currently, type declarations cannot be used in global scope, e.g. in the REPL, since Julia does not yet have constant-type globals.Declarations can also be attached to function definitions:function sinc(x)::Float64\n    if x == 0\n        return 1\n    end\n    return sin(pi*x)/(pi*x)\nendReturning from this function behaves just like an assignment to a variable with a declared type: the value is always converted to Float64."
},

{
    "location": "manual/types.html#Abstract-Types-1",
    "page": "Types",
    "title": "Abstract Types",
    "category": "section",
    "text": "Abstract types cannot be instantiated, and serve only as nodes in the type graph, thereby describing sets of related concrete types: those concrete types which are their descendants. We begin with abstract types even though they have no instantiation because they are the backbone of the type system: they form the conceptual hierarchy which makes Julia\'s type system more than just a collection of object implementations.Recall that in Integers and Floating-Point Numbers, we introduced a variety of concrete types of numeric values: Int8, UInt8, Int16, UInt16, Int32, UInt32, Int64, UInt64, Int128, UInt128, Float16, Float32, and Float64. Although they have different representation sizes, Int8, Int16, Int32, Int64 and Int128 all have in common that they are signed integer types. Likewise UInt8, UInt16, UInt32, UInt64 and UInt128 are all unsigned integer types, while Float16, Float32 and Float64 are distinct in being floating-point types rather than integers. It is common for a piece of code to make sense, for example, only if its arguments are some kind of integer, but not really depend on what particular kind of integer. For example, the greatest common denominator algorithm works for all kinds of integers, but will not work for floating-point numbers. Abstract types allow the construction of a hierarchy of types, providing a context into which concrete types can fit. This allows you, for example, to easily program to any type that is an integer, without restricting an algorithm to a specific type of integer.Abstract types are declared using the abstract type keyword. The general syntaxes for declaring an abstract type are:abstract type «name» end\nabstract type «name» <: «supertype» endThe abstract type keyword introduces a new abstract type, whose name is given by «name». This name can be optionally followed by <: and an already-existing type, indicating that the newly declared abstract type is a subtype of this \"parent\" type.When no supertype is given, the default supertype is Any – a predefined abstract type that all objects are instances of and all types are subtypes of. In type theory, Any is commonly called \"top\" because it is at the apex of the type graph. Julia also has a predefined abstract \"bottom\" type, at the nadir of the type graph, which is written as Union{}. It is the exact opposite of Any: no object is an instance of Union{} and all types are supertypes of Union{}.Let\'s consider some of the abstract types that make up Julia\'s numerical hierarchy:abstract type Number end\nabstract type Real     <: Number end\nabstract type AbstractFloat <: Real end\nabstract type Integer  <: Real end\nabstract type Signed   <: Integer end\nabstract type Unsigned <: Integer endThe Number type is a direct child type of Any, and Real is its child. In turn, Real has two children (it has more, but only two are shown here; we\'ll get to the others later): Integer and AbstractFloat, separating the world into representations of integers and representations of real numbers. Representations of real numbers include, of course, floating-point types, but also include other types, such as rationals. Hence, AbstractFloat is a proper subtype of Real, including only floating-point representations of real numbers. Integers are further subdivided into Signed and Unsigned varieties.The <: operator in general means \"is a subtype of\", and, used in declarations like this, declares the right-hand type to be an immediate supertype of the newly declared type. It can also be used in expressions as a subtype operator which returns true when its left operand is a subtype of its right operand:julia> Integer <: Number\ntrue\n\njulia> Integer <: AbstractFloat\nfalseAn important use of abstract types is to provide default implementations for concrete types. To give a simple example, consider:function myplus(x,y)\n    x+y\nendThe first thing to note is that the above argument declarations are equivalent to x::Any and y::Any. When this function is invoked, say as myplus(2,5), the dispatcher chooses the most specific method named myplus that matches the given arguments. (See Methods for more information on multiple dispatch.)Assuming no method more specific than the above is found, Julia next internally defines and compiles a method called myplus specifically for two Int arguments based on the generic function given above, i.e., it implicitly defines and compiles:function myplus(x::Int,y::Int)\n    x+y\nendand finally, it invokes this specific method.Thus, abstract types allow programmers to write generic functions that can later be used as the default method by many combinations of concrete types. Thanks to multiple dispatch, the programmer has full control over whether the default or more specific method is used.An important point to note is that there is no loss in performance if the programmer relies on a function whose arguments are abstract types, because it is recompiled for each tuple of argument concrete types with which it is invoked. (There may be a performance issue, however, in the case of function arguments that are containers of abstract types; see Performance Tips.)"
},

{
    "location": "manual/types.html#Primitive-Types-1",
    "page": "Types",
    "title": "Primitive Types",
    "category": "section",
    "text": "A primitive type is a concrete type whose data consists of plain old bits. Classic examples of primitive types are integers and floating-point values. Unlike most languages, Julia lets you declare your own primitive types, rather than providing only a fixed set of built-in ones. In fact, the standard primitive types are all defined in the language itself:primitive type Float16 <: AbstractFloat 16 end\nprimitive type Float32 <: AbstractFloat 32 end\nprimitive type Float64 <: AbstractFloat 64 end\n\nprimitive type Bool <: Integer 8 end\nprimitive type Char <: AbstractChar 32 end\n\nprimitive type Int8    <: Signed   8 end\nprimitive type UInt8   <: Unsigned 8 end\nprimitive type Int16   <: Signed   16 end\nprimitive type UInt16  <: Unsigned 16 end\nprimitive type Int32   <: Signed   32 end\nprimitive type UInt32  <: Unsigned 32 end\nprimitive type Int64   <: Signed   64 end\nprimitive type UInt64  <: Unsigned 64 end\nprimitive type Int128  <: Signed   128 end\nprimitive type UInt128 <: Unsigned 128 endThe general syntaxes for declaring a primitive type are:primitive type «name» «bits» end\nprimitive type «name» <: «supertype» «bits» endThe number of bits indicates how much storage the type requires and the name gives the new type a name. A primitive type can optionally be declared to be a subtype of some supertype. If a supertype is omitted, then the type defaults to having Any as its immediate supertype. The declaration of Bool above therefore means that a boolean value takes eight bits to store, and has Integer as its immediate supertype. Currently, only sizes that are multiples of 8 bits are supported. Therefore, boolean values, although they really need just a single bit, cannot be declared to be any smaller than eight bits.The types Bool, Int8 and UInt8 all have identical representations: they are eight-bit chunks of memory. Since Julia\'s type system is nominative, however, they are not interchangeable despite having identical structure. A fundamental difference between them is that they have different supertypes: Bool\'s direct supertype is Integer, Int8\'s is Signed, and UInt8\'s is Unsigned. All other differences between Bool, Int8, and UInt8 are matters of behavior – the way functions are defined to act when given objects of these types as arguments. This is why a nominative type system is necessary: if structure determined type, which in turn dictates behavior, then it would be impossible to make Bool behave any differently than Int8 or UInt8."
},

{
    "location": "manual/types.html#Composite-Types-1",
    "page": "Types",
    "title": "Composite Types",
    "category": "section",
    "text": "Composite types are called records, structs, or objects in various languages. A composite type is a collection of named fields, an instance of which can be treated as a single value. In many languages, composite types are the only kind of user-definable type, and they are by far the most commonly used user-defined type in Julia as well.In mainstream object oriented languages, such as C++, Java, Python and Ruby, composite types also have named functions associated with them, and the combination is called an \"object\". In purer object-oriented languages, such as Ruby or Smalltalk, all values are objects whether they are composites or not. In less pure object oriented languages, including C++ and Java, some values, such as integers and floating-point values, are not objects, while instances of user-defined composite types are true objects with associated methods. In Julia, all values are objects, but functions are not bundled with the objects they operate on. This is necessary since Julia chooses which method of a function to use by multiple dispatch, meaning that the types of all of a function\'s arguments are considered when selecting a method, rather than just the first one (see Methods for more information on methods and dispatch). Thus, it would be inappropriate for functions to \"belong\" to only their first argument. Organizing methods into function objects rather than having named bags of methods \"inside\" each object ends up being a highly beneficial aspect of the language design.Composite types are introduced with the struct keyword followed by a block of field names, optionally annotated with types using the :: operator:julia> struct Foo\n           bar\n           baz::Int\n           qux::Float64\n       endFields with no type annotation default to Any, and can accordingly hold any type of value.New objects of type Foo are created by applying the Foo type object like a function to values for its fields:julia> foo = Foo(\"Hello, world.\", 23, 1.5)\nFoo(\"Hello, world.\", 23, 1.5)\n\njulia> typeof(foo)\nFooWhen a type is applied like a function it is called a constructor. Two constructors are generated automatically (these are called default constructors). One accepts any arguments and calls convert to convert them to the types of the fields, and the other accepts arguments that match the field types exactly. The reason both of these are generated is that this makes it easier to add new definitions without inadvertently replacing a default constructor.Since the bar field is unconstrained in type, any value will do. However, the value for baz must be convertible to Int:julia> Foo((), 23.5, 1)\nERROR: InexactError: Int64(23.5)\nStacktrace:\n[...]You may find a list of field names using the fieldnames function.julia> fieldnames(Foo)\n(:bar, :baz, :qux)You can access the field values of a composite object using the traditional foo.bar notation:julia> foo.bar\n\"Hello, world.\"\n\njulia> foo.baz\n23\n\njulia> foo.qux\n1.5Composite objects declared with struct are immutable; they cannot be modified after construction. This may seem odd at first, but it has several advantages:It can be more efficient. Some structs can be packed efficiently into arrays, and in some cases the compiler is able to avoid allocating immutable objects entirely.\nIt is not possible to violate the invariants provided by the type\'s constructors.\nCode using immutable objects can be easier to reason about.An immutable object might contain mutable objects, such as arrays, as fields. Those contained objects will remain mutable; only the fields of the immutable object itself cannot be changed to point to different objects.Where required, mutable composite objects can be declared with the keyword mutable struct, to be discussed in the next section.Immutable composite types with no fields are singletons; there can be only one instance of such types:julia> struct NoFields\n       end\n\njulia> NoFields() === NoFields()\ntrueThe === function confirms that the \"two\" constructed instances of NoFields are actually one and the same. Singleton types are described in further detail below.There is much more to say about how instances of composite types are created, but that discussion depends on both Parametric Types and on Methods, and is sufficiently important to be addressed in its own section: Constructors."
},

{
    "location": "manual/types.html#Mutable-Composite-Types-1",
    "page": "Types",
    "title": "Mutable Composite Types",
    "category": "section",
    "text": "If a composite type is declared with mutable struct instead of struct, then instances of it can be modified:julia> mutable struct Bar\n           baz\n           qux::Float64\n       end\n\njulia> bar = Bar(\"Hello\", 1.5);\n\njulia> bar.qux = 2.0\n2.0\n\njulia> bar.baz = 1//2\n1//2In order to support mutation, such objects are generally allocated on the heap, and have stable memory addresses. A mutable object is like a little container that might hold different values over time, and so can only be reliably identified with its address. In contrast, an instance of an immutable type is associated with specific field values –- the field values alone tell you everything about the object. In deciding whether to make a type mutable, ask whether two instances with the same field values would be considered identical, or if they might need to change independently over time. If they would be considered identical, the type should probably be immutable.To recap, two essential properties define immutability in Julia:It is not permitted to modify the value of an immutable type.\nFor bits types this means that the bit pattern of a value once set will never change and that value is the identity of a bits type.\nFor composite  types, this means that the identity of the values of its fields will never change. When the fields are bits types, that means their bits will never change, for fields whose values are mutable types like arrays, that means the fields will always refer to the same mutable value even though that mutable value\'s content may itself be modified.\nAn object with an immutable type may be copied freely by the compiler since its immutability makes it impossible to programmatically distinguish between the original object and a copy.\nIn particular, this means that small enough immutable values like integers and floats are typically passed to functions in registers (or stack allocated).\nMutable values, on the other hand are heap-allocated and passed to functions as pointers to heap-allocated values except in cases where the compiler is sure that there\'s no way to tell that this is not what is happening."
},

{
    "location": "manual/types.html#Declared-Types-1",
    "page": "Types",
    "title": "Declared Types",
    "category": "section",
    "text": "The three kinds of types (abstract, primitive, composite) discussed in the previous sections are actually all closely related. They share the same key properties:They are explicitly declared.\nThey have names.\nThey have explicitly declared supertypes.\nThey may have parameters.Because of these shared properties, these types are internally represented as instances of the same concept, DataType, which is the type of any of these types:julia> typeof(Real)\nDataType\n\njulia> typeof(Int)\nDataTypeA DataType may be abstract or concrete. If it is concrete, it has a specified size, storage layout, and (optionally) field names. Thus a primitive type is a DataType with nonzero size, but no field names. A composite type is a DataType that has field names or is empty (zero size).Every concrete value in the system is an instance of some DataType."
},

{
    "location": "manual/types.html#Type-Unions-1",
    "page": "Types",
    "title": "Type Unions",
    "category": "section",
    "text": "A type union is a special abstract type which includes as objects all instances of any of its argument types, constructed using the special Union keyword:julia> IntOrString = Union{Int,AbstractString}\nUnion{Int64, AbstractString}\n\njulia> 1 :: IntOrString\n1\n\njulia> \"Hello!\" :: IntOrString\n\"Hello!\"\n\njulia> 1.0 :: IntOrString\nERROR: TypeError: in typeassert, expected Union{Int64, AbstractString}, got Float64The compilers for many languages have an internal union construct for reasoning about types; Julia simply exposes it to the programmer. The Julia compiler is able to generate efficient code in the presence of Union types with a small number of types [1], by generating specialized code in separate branches for each possible type.A particularly useful case of a Union type is Union{T, Nothing}, where T can be any type and Nothing is the singleton type whose only instance is the object nothing. This pattern is the Julia equivalent of Nullable, Option or Maybe types in other languages. Declaring a function argument or a field as Union{T, Nothing} allows setting it either to a value of type T, or to nothing to indicate that there is no value. See this FAQ entry for more information."
},

{
    "location": "manual/types.html#Parametric-Types-1",
    "page": "Types",
    "title": "Parametric Types",
    "category": "section",
    "text": "An important and powerful feature of Julia\'s type system is that it is parametric: types can take parameters, so that type declarations actually introduce a whole family of new types – one for each possible combination of parameter values. There are many languages that support some version of generic programming, wherein data structures and algorithms to manipulate them may be specified without specifying the exact types involved. For example, some form of generic programming exists in ML, Haskell, Ada, Eiffel, C++, Java, C#, F#, and Scala, just to name a few. Some of these languages support true parametric polymorphism (e.g. ML, Haskell, Scala), while others support ad-hoc, template-based styles of generic programming (e.g. C++, Java). With so many different varieties of generic programming and parametric types in various languages, we won\'t even attempt to compare Julia\'s parametric types to other languages, but will instead focus on explaining Julia\'s system in its own right. We will note, however, that because Julia is a dynamically typed language and doesn\'t need to make all type decisions at compile time, many traditional difficulties encountered in static parametric type systems can be relatively easily handled.All declared types (the DataType variety) can be parameterized, with the same syntax in each case. We will discuss them in the following order: first, parametric composite types, then parametric abstract types, and finally parametric primitive types."
},

{
    "location": "manual/types.html#Parametric-Composite-Types-1",
    "page": "Types",
    "title": "Parametric Composite Types",
    "category": "section",
    "text": "Type parameters are introduced immediately after the type name, surrounded by curly braces:julia> struct Point{T}\n           x::T\n           y::T\n       endThis declaration defines a new parametric type, Point{T}, holding two \"coordinates\" of type T. What, one may ask, is T? Well, that\'s precisely the point of parametric types: it can be any type at all (or a value of any bits type, actually, although here it\'s clearly used as a type). Point{Float64} is a concrete type equivalent to the type defined by replacing T in the definition of Point with Float64. Thus, this single declaration actually declares an unlimited number of types: Point{Float64}, Point{AbstractString}, Point{Int64}, etc. Each of these is now a usable concrete type:julia> Point{Float64}\nPoint{Float64}\n\njulia> Point{AbstractString}\nPoint{AbstractString}The type Point{Float64} is a point whose coordinates are 64-bit floating-point values, while the type Point{AbstractString} is a \"point\" whose \"coordinates\" are string objects (see Strings).Point itself is also a valid type object, containing all instances Point{Float64}, Point{AbstractString}, etc. as subtypes:julia> Point{Float64} <: Point\ntrue\n\njulia> Point{AbstractString} <: Point\ntrueOther types, of course, are not subtypes of it:julia> Float64 <: Point\nfalse\n\njulia> AbstractString <: Point\nfalseConcrete Point types with different values of T are never subtypes of each other:julia> Point{Float64} <: Point{Int64}\nfalse\n\njulia> Point{Float64} <: Point{Real}\nfalsewarning: Warning\nThis last point is very important: even though Float64 <: Real we DO NOT have Point{Float64} <: Point{Real}.In other words, in the parlance of type theory, Julia\'s type parameters are invariant, rather than being covariant (or even contravariant). This is for practical reasons: while any instance of Point{Float64} may conceptually be like an instance of Point{Real} as well, the two types have different representations in memory:An instance of Point{Float64} can be represented compactly and efficiently as an immediate pair of 64-bit values;\nAn instance of Point{Real} must be able to hold any pair of instances of Real. Since objects that are instances of Real can be of arbitrary size and structure, in practice an instance of Point{Real} must be represented as a pair of pointers to individually allocated Real objects.The efficiency gained by being able to store Point{Float64} objects with immediate values is magnified enormously in the case of arrays: an Array{Float64} can be stored as a contiguous memory block of 64-bit floating-point values, whereas an Array{Real} must be an array of pointers to individually allocated Real objects – which may well be boxed 64-bit floating-point values, but also might be arbitrarily large, complex objects, which are declared to be implementations of the Real abstract type.Since Point{Float64} is not a subtype of Point{Real}, the following method can\'t be applied to arguments of type Point{Float64}:function norm(p::Point{Real})\n    sqrt(p.x^2 + p.y^2)\nendA correct way to define a method that accepts all arguments of type Point{T} where T is a subtype of Real is:function norm(p::Point{<:Real})\n    sqrt(p.x^2 + p.y^2)\nend(Equivalently, one could define function norm(p::Point{T} where T<:Real) or function norm(p::Point{T}) where T<:Real; see UnionAll Types.)More examples will be discussed later in Methods.How does one construct a Point object? It is possible to define custom constructors for composite types, which will be discussed in detail in Constructors, but in the absence of any special constructor declarations, there are two default ways of creating new composite objects, one in which the type parameters are explicitly given and the other in which they are implied by the arguments to the object constructor.Since the type Point{Float64} is a concrete type equivalent to Point declared with Float64 in place of T, it can be applied as a constructor accordingly:julia> Point{Float64}(1.0, 2.0)\nPoint{Float64}(1.0, 2.0)\n\njulia> typeof(ans)\nPoint{Float64}For the default constructor, exactly one argument must be supplied for each field:julia> Point{Float64}(1.0)\nERROR: MethodError: no method matching Point{Float64}(::Float64)\n[...]\n\njulia> Point{Float64}(1.0,2.0,3.0)\nERROR: MethodError: no method matching Point{Float64}(::Float64, ::Float64, ::Float64)\n[...]Only one default constructor is generated for parametric types, since overriding it is not possible. This constructor accepts any arguments and converts them to the field types.In many cases, it is redundant to provide the type of Point object one wants to construct, since the types of arguments to the constructor call already implicitly provide type information. For that reason, you can also apply Point itself as a constructor, provided that the implied value of the parameter type T is unambiguous:julia> Point(1.0,2.0)\nPoint{Float64}(1.0, 2.0)\n\njulia> typeof(ans)\nPoint{Float64}\n\njulia> Point(1,2)\nPoint{Int64}(1, 2)\n\njulia> typeof(ans)\nPoint{Int64}In the case of Point, the type of T is unambiguously implied if and only if the two arguments to Point have the same type. When this isn\'t the case, the constructor will fail with a MethodError:julia> Point(1,2.5)\nERROR: MethodError: no method matching Point(::Int64, ::Float64)\nClosest candidates are:\n  Point(::T, !Matched::T) where T at none:2Constructor methods to appropriately handle such mixed cases can be defined, but that will not be discussed until later on in Constructors."
},

{
    "location": "manual/types.html#Parametric-Abstract-Types-1",
    "page": "Types",
    "title": "Parametric Abstract Types",
    "category": "section",
    "text": "Parametric abstract type declarations declare a collection of abstract types, in much the same way:julia> abstract type Pointy{T} endWith this declaration, Pointy{T} is a distinct abstract type for each type or integer value of T. As with parametric composite types, each such instance is a subtype of Pointy:julia> Pointy{Int64} <: Pointy\ntrue\n\njulia> Pointy{1} <: Pointy\ntrueParametric abstract types are invariant, much as parametric composite types are:julia> Pointy{Float64} <: Pointy{Real}\nfalse\n\njulia> Pointy{Real} <: Pointy{Float64}\nfalseThe notation Pointy{<:Real} can be used to express the Julia analogue of a covariant type, while Pointy{>:Int} the analogue of a contravariant type, but technically these represent sets of types (see UnionAll Types).julia> Pointy{Float64} <: Pointy{<:Real}\ntrue\n\njulia> Pointy{Real} <: Pointy{>:Int}\ntrueMuch as plain old abstract types serve to create a useful hierarchy of types over concrete types, parametric abstract types serve the same purpose with respect to parametric composite types. We could, for example, have declared Point{T} to be a subtype of Pointy{T} as follows:julia> struct Point{T} <: Pointy{T}\n           x::T\n           y::T\n       endGiven such a declaration, for each choice of T, we have Point{T} as a subtype of Pointy{T}:julia> Point{Float64} <: Pointy{Float64}\ntrue\n\njulia> Point{Real} <: Pointy{Real}\ntrue\n\njulia> Point{AbstractString} <: Pointy{AbstractString}\ntrueThis relationship is also invariant:julia> Point{Float64} <: Pointy{Real}\nfalse\n\njulia> Point{Float64} <: Pointy{<:Real}\ntrueWhat purpose do parametric abstract types like Pointy serve? Consider if we create a point-like implementation that only requires a single coordinate because the point is on the diagonal line x = y:julia> struct DiagPoint{T} <: Pointy{T}\n           x::T\n       endNow both Point{Float64} and DiagPoint{Float64} are implementations of the Pointy{Float64} abstraction, and similarly for every other possible choice of type T. This allows programming to a common interface shared by all Pointy objects, implemented for both Point and DiagPoint. This cannot be fully demonstrated, however, until we have introduced methods and dispatch in the next section, Methods.There are situations where it may not make sense for type parameters to range freely over all possible types. In such situations, one can constrain the range of T like so:julia> abstract type Pointy{T<:Real} endWith such a declaration, it is acceptable to use any type that is a subtype of Real in place of T, but not types that are not subtypes of Real:julia> Pointy{Float64}\nPointy{Float64}\n\njulia> Pointy{Real}\nPointy{Real}\n\njulia> Pointy{AbstractString}\nERROR: TypeError: in Pointy, in T, expected T<:Real, got Type{AbstractString}\n\njulia> Pointy{1}\nERROR: TypeError: in Pointy, in T, expected T<:Real, got Int64Type parameters for parametric composite types can be restricted in the same manner:struct Point{T<:Real} <: Pointy{T}\n    x::T\n    y::T\nendTo give a real-world example of how all this parametric type machinery can be useful, here is the actual definition of Julia\'s Rational immutable type (except that we omit the constructor here for simplicity), representing an exact ratio of integers:struct Rational{T<:Integer} <: Real\n    num::T\n    den::T\nendIt only makes sense to take ratios of integer values, so the parameter type T is restricted to being a subtype of Integer, and a ratio of integers represents a value on the real number line, so any Rational is an instance of the Real abstraction."
},

{
    "location": "manual/types.html#Tuple-Types-1",
    "page": "Types",
    "title": "Tuple Types",
    "category": "section",
    "text": "Tuples are an abstraction of the arguments of a function – without the function itself. The salient aspects of a function\'s arguments are their order and their types. Therefore a tuple type is similar to a parameterized immutable type where each parameter is the type of one field. For example, a 2-element tuple type resembles the following immutable type:struct Tuple2{A,B}\n    a::A\n    b::B\nendHowever, there are three key differences:Tuple types may have any number of parameters.\nTuple types are covariant in their parameters: Tuple{Int} is a subtype of Tuple{Any}. Therefore Tuple{Any} is considered an abstract type, and tuple types are only concrete if their parameters are.\nTuples do not have field names; fields are only accessed by index.Tuple values are written with parentheses and commas. When a tuple is constructed, an appropriate tuple type is generated on demand:julia> typeof((1,\"foo\",2.5))\nTuple{Int64,String,Float64}Note the implications of covariance:julia> Tuple{Int,AbstractString} <: Tuple{Real,Any}\ntrue\n\njulia> Tuple{Int,AbstractString} <: Tuple{Real,Real}\nfalse\n\njulia> Tuple{Int,AbstractString} <: Tuple{Real,}\nfalseIntuitively, this corresponds to the type of a function\'s arguments being a subtype of the function\'s signature (when the signature matches)."
},

{
    "location": "manual/types.html#Vararg-Tuple-Types-1",
    "page": "Types",
    "title": "Vararg Tuple Types",
    "category": "section",
    "text": "The last parameter of a tuple type can be the special type Vararg, which denotes any number of trailing elements:julia> mytupletype = Tuple{AbstractString,Vararg{Int}}\nTuple{AbstractString,Vararg{Int64,N} where N}\n\njulia> isa((\"1\",), mytupletype)\ntrue\n\njulia> isa((\"1\",1), mytupletype)\ntrue\n\njulia> isa((\"1\",1,2), mytupletype)\ntrue\n\njulia> isa((\"1\",1,2,3.0), mytupletype)\nfalseNotice that Vararg{T} corresponds to zero or more elements of type T. Vararg tuple types are used to represent the arguments accepted by varargs methods (see Varargs Functions).The type Vararg{T,N} corresponds to exactly N elements of type T.  NTuple{N,T} is a convenient alias for Tuple{Vararg{T,N}}, i.e. a tuple type containing exactly N elements of type T."
},

{
    "location": "manual/types.html#Named-Tuple-Types-1",
    "page": "Types",
    "title": "Named Tuple Types",
    "category": "section",
    "text": "Named tuples are instances of the NamedTuple type, which has two parameters: a tuple of symbols giving the field names, and a tuple type giving the field types.julia> typeof((a=1,b=\"hello\"))\nNamedTuple{(:a, :b),Tuple{Int64,String}}A NamedTuple type can be used as a constructor, accepting a single tuple argument. The constructed NamedTuple type can be either a concrete type, with both parameters specified, or a type that specifies only field names:julia> NamedTuple{(:a, :b),Tuple{Float32, String}}((1,\"\"))\n(a = 1.0f0, b = \"\")\n\njulia> NamedTuple{(:a, :b)}((1,\"\"))\n(a = 1, b = \"\")If field types are specified, the arguments are converted. Otherwise the types of the arguments are used directly."
},

{
    "location": "manual/types.html#man-singleton-types-1",
    "page": "Types",
    "title": "Singleton Types",
    "category": "section",
    "text": "There is a special kind of abstract parametric type that must be mentioned here: singleton types. For each type, T, the \"singleton type\" Type{T} is an abstract type whose only instance is the object T. Since the definition is a little difficult to parse, let\'s look at some examples:julia> isa(Float64, Type{Float64})\ntrue\n\njulia> isa(Real, Type{Float64})\nfalse\n\njulia> isa(Real, Type{Real})\ntrue\n\njulia> isa(Float64, Type{Real})\nfalseIn other words, isa(A,Type{B}) is true if and only if A and B are the same object and that object is a type. Without the parameter, Type is simply an abstract type which has all type objects as its instances, including, of course, singleton types:julia> isa(Type{Float64}, Type)\ntrue\n\njulia> isa(Float64, Type)\ntrue\n\njulia> isa(Real, Type)\ntrueAny object that is not a type is not an instance of Type:julia> isa(1, Type)\nfalse\n\njulia> isa(\"foo\", Type)\nfalseUntil we discuss Parametric Methods and conversions, it is difficult to explain the utility of the singleton type construct, but in short, it allows one to specialize function behavior on specific type values. This is useful for writing methods (especially parametric ones) whose behavior depends on a type that is given as an explicit argument rather than implied by the type of one of its arguments.A few popular languages have singleton types, including Haskell, Scala and Ruby. In general usage, the term \"singleton type\" refers to a type whose only instance is a single value. This meaning applies to Julia\'s singleton types, but with that caveat that only type objects have singleton types."
},

{
    "location": "manual/types.html#Parametric-Primitive-Types-1",
    "page": "Types",
    "title": "Parametric Primitive Types",
    "category": "section",
    "text": "Primitive types can also be declared parametrically. For example, pointers are represented as primitive types which would be declared in Julia like this:# 32-bit system:\nprimitive type Ptr{T} 32 end\n\n# 64-bit system:\nprimitive type Ptr{T} 64 endThe slightly odd feature of these declarations as compared to typical parametric composite types, is that the type parameter T is not used in the definition of the type itself – it is just an abstract tag, essentially defining an entire family of types with identical structure, differentiated only by their type parameter. Thus, Ptr{Float64} and Ptr{Int64} are distinct types, even though they have identical representations. And of course, all specific pointer types are subtypes of the umbrella Ptr type:julia> Ptr{Float64} <: Ptr\ntrue\n\njulia> Ptr{Int64} <: Ptr\ntrue"
},

{
    "location": "manual/types.html#UnionAll-Types-1",
    "page": "Types",
    "title": "UnionAll Types",
    "category": "section",
    "text": "We have said that a parametric type like Ptr acts as a supertype of all its instances (Ptr{Int64} etc.). How does this work? Ptr itself cannot be a normal data type, since without knowing the type of the referenced data the type clearly cannot be used for memory operations. The answer is that Ptr (or other parametric types like Array) is a different kind of type called a UnionAll type. Such a type expresses the iterated union of types for all values of some parameter.UnionAll types are usually written using the keyword where. For example Ptr could be more accurately written as Ptr{T} where T, meaning all values whose type is Ptr{T} for some value of T. In this context, the parameter T is also often called a \"type variable\" since it is like a variable that ranges over types. Each where introduces a single type variable, so these expressions are nested for types with multiple parameters, for example Array{T,N} where N where T.The type application syntax A{B,C} requires A to be a UnionAll type, and first substitutes B for the outermost type variable in A. The result is expected to be another UnionAll type, into which C is then substituted. So A{B,C} is equivalent to A{B}{C}. This explains why it is possible to partially instantiate a type, as in Array{Float64}: the first parameter value has been fixed, but the second still ranges over all possible values. Using explicit where syntax, any subset of parameters can be fixed. For example, the type of all 1-dimensional arrays can be written as Array{T,1} where T.Type variables can be restricted with subtype relations. Array{T} where T<:Integer refers to all arrays whose element type is some kind of Integer. The syntax Array{<:Integer} is a convenient shorthand for Array{T} where T<:Integer. Type variables can have both lower and upper bounds. Array{T} where Int<:T<:Number refers to all arrays of Numbers that are able to contain Ints (since T must be at least as big as Int). The syntax where T>:Int also works to specify only the lower bound of a type variable, and Array{>:Int} is equivalent to Array{T} where T>:Int.Since where expressions nest, type variable bounds can refer to outer type variables. For example Tuple{T,Array{S}} where S<:AbstractArray{T} where T<:Real refers to 2-tuples whose first element is some Real, and whose second element is an Array of any kind of array whose element type contains the type of the first tuple element.The where keyword itself can be nested inside a more complex declaration. For example, consider the two types created by the following declarations:julia> const T1 = Array{Array{T,1} where T, 1}\nArray{Array{T,1} where T,1}\n\njulia> const T2 = Array{Array{T,1}, 1} where T\nArray{Array{T,1},1} where TType T1 defines a 1-dimensional array of 1-dimensional arrays; each of the inner arrays consists of objects of the same type, but this type may vary from one inner array to the next. On the other hand, type T2 defines a 1-dimensional array of 1-dimensional arrays all of whose inner arrays must have the same type.  Note that T2 is an abstract type, e.g., Array{Array{Int,1},1} <: T2, whereas T1 is a concrete type. As a consequence, T1 can be constructed with a zero-argument constructor a=T1() but T2 cannot.There is a convenient syntax for naming such types, similar to the short form of function definition syntax:Vector{T} = Array{T,1}This is equivalent to const Vector = Array{T,1} where T. Writing Vector{Float64} is equivalent to writing Array{Float64,1}, and the umbrella type Vector has as instances all Array objects where the second parameter – the number of array dimensions – is 1, regardless of what the element type is. In languages where parametric types must always be specified in full, this is not especially helpful, but in Julia, this allows one to write just Vector for the abstract type including all one-dimensional dense arrays of any element type."
},

{
    "location": "manual/types.html#Type-Aliases-1",
    "page": "Types",
    "title": "Type Aliases",
    "category": "section",
    "text": "Sometimes it is convenient to introduce a new name for an already expressible type. This can be done with a simple assignment statement. For example, UInt is aliased to either UInt32 or UInt64 as is appropriate for the size of pointers on the system:# 32-bit system:\njulia> UInt\nUInt32\n\n# 64-bit system:\njulia> UInt\nUInt64This is accomplished via the following code in base/boot.jl:if Int === Int64\n    const UInt = UInt64\nelse\n    const UInt = UInt32\nendOf course, this depends on what Int is aliased to – but that is predefined to be the correct type – either Int32 or Int64.(Note that unlike Int, Float does not exist as a type alias for a specific sized AbstractFloat. Unlike with integer registers, where the size of Int reflects the size of a native pointer on that machine, the floating point register sizes are specified by the IEEE-754 standard.)"
},

{
    "location": "manual/types.html#Operations-on-Types-1",
    "page": "Types",
    "title": "Operations on Types",
    "category": "section",
    "text": "Since types in Julia are themselves objects, ordinary functions can operate on them. Some functions that are particularly useful for working with or exploring types have already been introduced, such as the <: operator, which indicates whether its left hand operand is a subtype of its right hand operand.The isa function tests if an object is of a given type and returns true or false:julia> isa(1, Int)\ntrue\n\njulia> isa(1, AbstractFloat)\nfalseThe typeof function, already used throughout the manual in examples, returns the type of its argument. Since, as noted above, types are objects, they also have types, and we can ask what their types are:julia> typeof(Rational{Int})\nDataType\n\njulia> typeof(Union{Real,String})\nUnionWhat if we repeat the process? What is the type of a type of a type? As it happens, types are all composite values and thus all have a type of DataType:julia> typeof(DataType)\nDataType\n\njulia> typeof(Union)\nDataTypeDataType is its own type.Another operation that applies to some types is supertype, which reveals a type\'s supertype. Only declared types (DataType) have unambiguous supertypes:julia> supertype(Float64)\nAbstractFloat\n\njulia> supertype(Number)\nAny\n\njulia> supertype(AbstractString)\nAny\n\njulia> supertype(Any)\nAnyIf you apply supertype to other type objects (or non-type objects), a MethodError is raised:julia> supertype(Union{Float64,Int64})\nERROR: MethodError: no method matching supertype(::Type{Union{Float64, Int64}})\nClosest candidates are:\n  supertype(!Matched::DataType) at operators.jl:42\n  supertype(!Matched::UnionAll) at operators.jl:47"
},

{
    "location": "manual/types.html#man-custom-pretty-printing-1",
    "page": "Types",
    "title": "Custom pretty-printing",
    "category": "section",
    "text": "Often, one wants to customize how instances of a type are displayed.  This is accomplished by overloading the show function.  For example, suppose we define a type to represent complex numbers in polar form:julia> struct Polar{T<:Real} <: Number\n           r::T\n           Θ::T\n       end\n\njulia> Polar(r::Real,Θ::Real) = Polar(promote(r,Θ)...)\nPolarHere, we\'ve added a custom constructor function so that it can take arguments of different Real types and promote them to a common type (see Constructors and Conversion and Promotion). (Of course, we would have to define lots of other methods, too, to make it act like a Number, e.g. +, *, one, zero, promotion rules and so on.) By default, instances of this type display rather simply, with information about the type name and the field values, as e.g. Polar{Float64}(3.0,4.0).If we want it to display instead as 3.0 * exp(4.0im), we would define the following method to print the object to a given output object io (representing a file, terminal, buffer, etcetera; see Networking and Streams):julia> Base.show(io::IO, z::Polar) = print(io, z.r, \" * exp(\", z.Θ, \"im)\")More fine-grained control over display of Polar objects is possible. In particular, sometimes one wants both a verbose multi-line printing format, used for displaying a single object in the REPL and other interactive environments, and also a more compact single-line format used for print or for displaying the object as part of another object (e.g. in an array). Although by default the show(io, z) function is called in both cases, you can define a different multi-line format for displaying an object by overloading a three-argument form of show that takes the text/plain MIME type as its second argument (see Multimedia I/O), for example:julia> Base.show(io::IO, ::MIME\"text/plain\", z::Polar{T}) where{T} =\n           print(io, \"Polar{$T} complex number:\\n   \", z)(Note that print(..., z) here will call the 2-argument show(io, z) method.) This results in:julia> Polar(3, 4.0)\nPolar{Float64} complex number:\n   3.0 * exp(4.0im)\n\njulia> [Polar(3, 4.0), Polar(4.0,5.3)]\n2-element Array{Polar{Float64},1}:\n 3.0 * exp(4.0im)\n 4.0 * exp(5.3im)where the single-line show(io, z) form is still used for an array of Polar values.   Technically, the REPL calls display(z) to display the result of executing a line, which defaults to show(stdout, MIME(\"text/plain\"), z), which in turn defaults to show(stdout, z), but you should not define new display methods unless you are defining a new multimedia display handler (see Multimedia I/O).Moreover, you can also define show methods for other MIME types in order to enable richer display (HTML, images, etcetera) of objects in environments that support this (e.g. IJulia).   For example, we can define formatted HTML display of Polar objects, with superscripts and italics, via:julia> Base.show(io::IO, ::MIME\"text/html\", z::Polar{T}) where {T} =\n           println(io, \"<code>Polar{$T}</code> complex number: \",\n                   z.r, \" <i>e</i><sup>\", z.Θ, \" <i>i</i></sup>\")A Polar object will then display automatically using HTML in an environment that supports HTML display, but you can call show manually to get HTML output if you want:julia> show(stdout, \"text/html\", Polar(3.0,4.0))\n<code>Polar{Float64}</code> complex number: 3.0 <i>e</i><sup>4.0 <i>i</i></sup><p>An HTML renderer would display this as: <code>Polar{Float64}</code> complex number: 3.0 <i>e</i><sup>4.0 <i>i</i></sup></p>As a rule of thumb, the single-line show method should print a valid Julia expression for creating the shown object.  When this show method contains infix operators, such as the multiplication operator (*) in our single-line show method for Polar above, it may not parse correctly when printed as part of another object.  To see this, consider the expression object (see Program representation) which takes the square of a specific instance of our Polar type:julia> a = Polar(3, 4.0)\nPolar{Float64} complex number:\n   3.0 * exp(4.0im)\n\njulia> print(:($a^2))\n3.0 * exp(4.0im) ^ 2Because the operator ^ has higher precedence than * (see Operator Precedence and Associativity), this output does not faithfully represent the expression a ^ 2 which should be equal to (3.0 * exp(4.0im)) ^ 2.  To solve this issue, we must make a custom method for Base.show_unquoted(io::IO, z::Polar, indent::Int, precedence::Int), which is called internally by the expression object when printing:julia> function Base.show_unquoted(io::IO, z::Polar, ::Int, precedence::Int)\n           if Base.operator_precedence(:*) <= precedence\n               print(io, \"(\")\n               show(io, z)\n               print(io, \")\")\n           else\n               show(io, z)\n           end\n       end\n\njulia> :($a^2)\n:((3.0 * exp(4.0im)) ^ 2)The method defined above adds parentheses around the call to show when the precedence of the calling operator is higher than or equal to the precedence of multiplication.  This check allows expressions which parse correctly without the parentheses (such as :($a + 2) and :($a == 2)) to omit them when printing:julia> :($a + 2)\n:(3.0 * exp(4.0im) + 2)\n\njulia> :($a == 2)\n:(3.0 * exp(4.0im) == 2)In some cases, it is useful to adjust the behavior of show methods depending on the context. This can be achieved via the IOContext type, which allows passing contextual properties together with a wrapped IO stream. For example, we can build a shorter representation in our show method when the :compact property is set to true, falling back to the long representation if the property is false or absent:julia> function Base.show(io::IO, z::Polar)\n           if get(io, :compact, false)\n               print(io, z.r, \"ℯ\", z.Θ, \"im\")\n           else\n               print(io, z.r, \" * exp(\", z.Θ, \"im)\")\n           end\n       endThis new compact representation will be used when the passed IO stream is an IOContext object with the :compact property set. In particular, this is the case when printing arrays with multiple columns (where horizontal space is limited):julia> show(IOContext(stdout, :compact=>true), Polar(3, 4.0))\n3.0ℯ4.0im\n\njulia> [Polar(3, 4.0) Polar(4.0,5.3)]\n1×2 Array{Polar{Float64},2}:\n 3.0ℯ4.0im  4.0ℯ5.3imSee the IOContext documentation for a list of common properties which can be used to adjust printing."
},

{
    "location": "manual/types.html#\"Value-types\"-1",
    "page": "Types",
    "title": "\"Value types\"",
    "category": "section",
    "text": "In Julia, you can\'t dispatch on a value such as true or false. However, you can dispatch on parametric types, and Julia allows you to include \"plain bits\" values (Types, Symbols, Integers, floating-point numbers, tuples, etc.) as type parameters.  A common example is the dimensionality parameter in Array{T,N}, where T is a type (e.g., Float64) but N is just an Int.You can create your own custom types that take values as parameters, and use them to control dispatch of custom types. By way of illustration of this idea, let\'s introduce a parametric type, Val{x}, and a constructor Val(x) = Val{x}(), which serves as a customary way to exploit this technique for cases where you don\'t need a more elaborate hierarchy.Val is defined as:julia> struct Val{x}\n       end\n\njulia> Val(x) = Val{x}()\nValThere is no more to the implementation of Val than this.  Some functions in Julia\'s standard library accept Val instances as arguments, and you can also use it to write your own functions.  For example:julia> firstlast(::Val{true}) = \"First\"\nfirstlast (generic function with 1 method)\n\njulia> firstlast(::Val{false}) = \"Last\"\nfirstlast (generic function with 2 methods)\n\njulia> firstlast(Val(true))\n\"First\"\n\njulia> firstlast(Val(false))\n\"Last\"For consistency across Julia, the call site should always pass a Valinstance rather than using a type, i.e., use foo(Val(:bar)) rather than foo(Val{:bar}).It\'s worth noting that it\'s extremely easy to mis-use parametric \"value\" types, including Val; in unfavorable cases, you can easily end up making the performance of your code much worse.  In particular, you would never want to write actual code as illustrated above.  For more information about the proper (and improper) uses of Val, please read the more extensive discussion in the performance tips.[1]: \"Small\" is defined by the MAX_UNION_SPLITTING constant, which is currently set to 4."
},

{
    "location": "manual/methods.html#",
    "page": "Methods",
    "title": "Methods",
    "category": "page",
    "text": ""
},

{
    "location": "manual/methods.html#Methods-1",
    "page": "Methods",
    "title": "Methods",
    "category": "section",
    "text": "Recall from Functions that a function is an object that maps a tuple of arguments to a return value, or throws an exception if no appropriate value can be returned. It is common for the same conceptual function or operation to be implemented quite differently for different types of arguments: adding two integers is very different from adding two floating-point numbers, both of which are distinct from adding an integer to a floating-point number. Despite their implementation differences, these operations all fall under the general concept of \"addition\". Accordingly, in Julia, these behaviors all belong to a single object: the + function.To facilitate using many different implementations of the same concept smoothly, functions need not be defined all at once, but can rather be defined piecewise by providing specific behaviors for certain combinations of argument types and counts. A definition of one possible behavior for a function is called a method. Thus far, we have presented only examples of functions defined with a single method, applicable to all types of arguments. However, the signatures of method definitions can be annotated to indicate the types of arguments in addition to their number, and more than a single method definition may be provided. When a function is applied to a particular tuple of arguments, the most specific method applicable to those arguments is applied. Thus, the overall behavior of a function is a patchwork of the behaviors of its various method definitions. If the patchwork is well designed, even though the implementations of the methods may be quite different, the outward behavior of the function will appear seamless and consistent.The choice of which method to execute when a function is applied is called dispatch. Julia allows the dispatch process to choose which of a function\'s methods to call based on the number of arguments given, and on the types of all of the function\'s arguments. This is different than traditional object-oriented languages, where dispatch occurs based only on the first argument, which often has a special argument syntax, and is sometimes implied rather than explicitly written as an argument. [1] Using all of a function\'s arguments to choose which method should be invoked, rather than just the first, is known as multiple dispatch. Multiple dispatch is particularly useful for mathematical code, where it makes little sense to artificially deem the operations to \"belong\" to one argument more than any of the others: does the addition operation in x + y belong to x any more than it does to y? The implementation of a mathematical operator generally depends on the types of all of its arguments. Even beyond mathematical operations, however, multiple dispatch ends up being a powerful and convenient paradigm for structuring and organizing programs.[1]: In C++ or Java, for example, in a method call like obj.meth(arg1,arg2), the object obj \"receives\" the method call and is implicitly passed to the method via the this keyword, rather than as an explicit method argument. When the current this object is the receiver of a method call, it can be omitted altogether, writing just meth(arg1,arg2), with this implied as the receiving object."
},

{
    "location": "manual/methods.html#Defining-Methods-1",
    "page": "Methods",
    "title": "Defining Methods",
    "category": "section",
    "text": "Until now, we have, in our examples, defined only functions with a single method having unconstrained argument types. Such functions behave just like they would in traditional dynamically typed languages. Nevertheless, we have used multiple dispatch and methods almost continually without being aware of it: all of Julia\'s standard functions and operators, like the aforementioned + function, have many methods defining their behavior over various possible combinations of argument type and count.When defining a function, one can optionally constrain the types of parameters it is applicable to, using the :: type-assertion operator, introduced in the section on Composite Types:julia> f(x::Float64, y::Float64) = 2x + y\nf (generic function with 1 method)This function definition applies only to calls where x and y are both values of type Float64:julia> f(2.0, 3.0)\n7.0Applying it to any other types of arguments will result in a MethodError:julia> f(2.0, 3)\nERROR: MethodError: no method matching f(::Float64, ::Int64)\nClosest candidates are:\n  f(::Float64, !Matched::Float64) at none:1\n\njulia> f(Float32(2.0), 3.0)\nERROR: MethodError: no method matching f(::Float32, ::Float64)\nClosest candidates are:\n  f(!Matched::Float64, ::Float64) at none:1\n\njulia> f(2.0, \"3.0\")\nERROR: MethodError: no method matching f(::Float64, ::String)\nClosest candidates are:\n  f(::Float64, !Matched::Float64) at none:1\n\njulia> f(\"2.0\", \"3.0\")\nERROR: MethodError: no method matching f(::String, ::String)As you can see, the arguments must be precisely of type Float64. Other numeric types, such as integers or 32-bit floating-point values, are not automatically converted to 64-bit floating-point, nor are strings parsed as numbers. Because Float64 is a concrete type and concrete types cannot be subclassed in Julia, such a definition can only be applied to arguments that are exactly of type Float64. It may often be useful, however, to write more general methods where the declared parameter types are abstract:julia> f(x::Number, y::Number) = 2x - y\nf (generic function with 2 methods)\n\njulia> f(2.0, 3)\n1.0This method definition applies to any pair of arguments that are instances of Number. They need not be of the same type, so long as they are each numeric values. The problem of handling disparate numeric types is delegated to the arithmetic operations in the expression 2x - y.To define a function with multiple methods, one simply defines the function multiple times, with different numbers and types of arguments. The first method definition for a function creates the function object, and subsequent method definitions add new methods to the existing function object. The most specific method definition matching the number and types of the arguments will be executed when the function is applied. Thus, the two method definitions above, taken together, define the behavior for f over all pairs of instances of the abstract type Number – but with a different behavior specific to pairs of Float64 values. If one of the arguments is a 64-bit float but the other one is not, then the f(Float64,Float64) method cannot be called and the more general f(Number,Number) method must be used:julia> f(2.0, 3.0)\n7.0\n\njulia> f(2, 3.0)\n1.0\n\njulia> f(2.0, 3)\n1.0\n\njulia> f(2, 3)\n1The 2x + y definition is only used in the first case, while the 2x - y definition is used in the others. No automatic casting or conversion of function arguments is ever performed: all conversion in Julia is non-magical and completely explicit. Conversion and Promotion, however, shows how clever application of sufficiently advanced technology can be indistinguishable from magic. [Clarke61]For non-numeric values, and for fewer or more than two arguments, the function f remains undefined, and applying it will still result in a MethodError:julia> f(\"foo\", 3)\nERROR: MethodError: no method matching f(::String, ::Int64)\nClosest candidates are:\n  f(!Matched::Number, ::Number) at none:1\n\njulia> f()\nERROR: MethodError: no method matching f()\nClosest candidates are:\n  f(!Matched::Float64, !Matched::Float64) at none:1\n  f(!Matched::Number, !Matched::Number) at none:1You can easily see which methods exist for a function by entering the function object itself in an interactive session:julia> f\nf (generic function with 2 methods)This output tells us that f is a function object with two methods. To find out what the signatures of those methods are, use the methods function:julia> methods(f)\n# 2 methods for generic function \"f\":\n[1] f(x::Float64, y::Float64) in Main at none:1\n[2] f(x::Number, y::Number) in Main at none:1which shows that f has two methods, one taking two Float64 arguments and one taking arguments of type Number. It also indicates the file and line number where the methods were defined: because these methods were defined at the REPL, we get the apparent line number none:1.In the absence of a type declaration with ::, the type of a method parameter is Any by default, meaning that it is unconstrained since all values in Julia are instances of the abstract type Any. Thus, we can define a catch-all method for f like so:julia> f(x,y) = println(\"Whoa there, Nelly.\")\nf (generic function with 3 methods)\n\njulia> f(\"foo\", 1)\nWhoa there, Nelly.This catch-all is less specific than any other possible method definition for a pair of parameter values, so it will only be called on pairs of arguments to which no other method definition applies.Although it seems a simple concept, multiple dispatch on the types of values is perhaps the single most powerful and central feature of the Julia language. Core operations typically have dozens of methods:julia> methods(+)\n# 180 methods for generic function \"+\":\n[1] +(x::Bool, z::Complex{Bool}) in Base at complex.jl:227\n[2] +(x::Bool, y::Bool) in Base at bool.jl:89\n[3] +(x::Bool) in Base at bool.jl:86\n[4] +(x::Bool, y::T) where T<:AbstractFloat in Base at bool.jl:96\n[5] +(x::Bool, z::Complex) in Base at complex.jl:234\n[6] +(a::Float16, b::Float16) in Base at float.jl:373\n[7] +(x::Float32, y::Float32) in Base at float.jl:375\n[8] +(x::Float64, y::Float64) in Base at float.jl:376\n[9] +(z::Complex{Bool}, x::Bool) in Base at complex.jl:228\n[10] +(z::Complex{Bool}, x::Real) in Base at complex.jl:242\n[11] +(x::Char, y::Integer) in Base at char.jl:40\n[12] +(c::BigInt, x::BigFloat) in Base.MPFR at mpfr.jl:307\n[13] +(a::BigInt, b::BigInt, c::BigInt, d::BigInt, e::BigInt) in Base.GMP at gmp.jl:392\n[14] +(a::BigInt, b::BigInt, c::BigInt, d::BigInt) in Base.GMP at gmp.jl:391\n[15] +(a::BigInt, b::BigInt, c::BigInt) in Base.GMP at gmp.jl:390\n[16] +(x::BigInt, y::BigInt) in Base.GMP at gmp.jl:361\n[17] +(x::BigInt, c::Union{UInt16, UInt32, UInt64, UInt8}) in Base.GMP at gmp.jl:398\n...\n[180] +(a, b, c, xs...) in Base at operators.jl:424Multiple dispatch together with the flexible parametric type system give Julia its ability to abstractly express high-level algorithms decoupled from implementation details, yet generate efficient, specialized code to handle each case at run time."
},

{
    "location": "manual/methods.html#man-ambiguities-1",
    "page": "Methods",
    "title": "Method Ambiguities",
    "category": "section",
    "text": "It is possible to define a set of function methods such that there is no unique most specific method applicable to some combinations of arguments:julia> g(x::Float64, y) = 2x + y\ng (generic function with 1 method)\n\njulia> g(x, y::Float64) = x + 2y\ng (generic function with 2 methods)\n\njulia> g(2.0, 3)\n7.0\n\njulia> g(2, 3.0)\n8.0\n\njulia> g(2.0, 3.0)\nERROR: MethodError: g(::Float64, ::Float64) is ambiguous. Candidates:\n  g(x, y::Float64) in Main at none:1\n  g(x::Float64, y) in Main at none:1\nPossible fix, define\n  g(::Float64, ::Float64)Here the call g(2.0, 3.0) could be handled by either the g(Float64, Any) or the g(Any, Float64) method, and neither is more specific than the other. In such cases, Julia raises a MethodError rather than arbitrarily picking a method. You can avoid method ambiguities by specifying an appropriate method for the intersection case:julia> g(x::Float64, y::Float64) = 2x + 2y\ng (generic function with 3 methods)\n\njulia> g(2.0, 3)\n7.0\n\njulia> g(2, 3.0)\n8.0\n\njulia> g(2.0, 3.0)\n10.0It is recommended that the disambiguating method be defined first, since otherwise the ambiguity exists, if transiently, until the more specific method is defined.In more complex cases, resolving method ambiguities involves a certain element of design; this topic is explored further below."
},

{
    "location": "manual/methods.html#Parametric-Methods-1",
    "page": "Methods",
    "title": "Parametric Methods",
    "category": "section",
    "text": "Method definitions can optionally have type parameters qualifying the signature:julia> same_type(x::T, y::T) where {T} = true\nsame_type (generic function with 1 method)\n\njulia> same_type(x,y) = false\nsame_type (generic function with 2 methods)The first method applies whenever both arguments are of the same concrete type, regardless of what type that is, while the second method acts as a catch-all, covering all other cases. Thus, overall, this defines a boolean function that checks whether its two arguments are of the same type:julia> same_type(1, 2)\ntrue\n\njulia> same_type(1, 2.0)\nfalse\n\njulia> same_type(1.0, 2.0)\ntrue\n\njulia> same_type(\"foo\", 2.0)\nfalse\n\njulia> same_type(\"foo\", \"bar\")\ntrue\n\njulia> same_type(Int32(1), Int64(2))\nfalseSuch definitions correspond to methods whose type signatures are UnionAll types (see UnionAll Types).This kind of definition of function behavior by dispatch is quite common – idiomatic, even – in Julia. Method type parameters are not restricted to being used as the types of arguments: they can be used anywhere a value would be in the signature of the function or body of the function. Here\'s an example where the method type parameter T is used as the type parameter to the parametric type Vector{T} in the method signature:julia> myappend(v::Vector{T}, x::T) where {T} = [v..., x]\nmyappend (generic function with 1 method)\n\njulia> myappend([1,2,3],4)\n4-element Array{Int64,1}:\n 1\n 2\n 3\n 4\n\njulia> myappend([1,2,3],2.5)\nERROR: MethodError: no method matching myappend(::Array{Int64,1}, ::Float64)\nClosest candidates are:\n  myappend(::Array{T,1}, !Matched::T) where T at none:1\n\njulia> myappend([1.0,2.0,3.0],4.0)\n4-element Array{Float64,1}:\n 1.0\n 2.0\n 3.0\n 4.0\n\njulia> myappend([1.0,2.0,3.0],4)\nERROR: MethodError: no method matching myappend(::Array{Float64,1}, ::Int64)\nClosest candidates are:\n  myappend(::Array{T,1}, !Matched::T) where T at none:1As you can see, the type of the appended element must match the element type of the vector it is appended to, or else a MethodError is raised. In the following example, the method type parameter T is used as the return value:julia> mytypeof(x::T) where {T} = T\nmytypeof (generic function with 1 method)\n\njulia> mytypeof(1)\nInt64\n\njulia> mytypeof(1.0)\nFloat64Just as you can put subtype constraints on type parameters in type declarations (see Parametric Types), you can also constrain type parameters of methods:julia> same_type_numeric(x::T, y::T) where {T<:Number} = true\nsame_type_numeric (generic function with 1 method)\n\njulia> same_type_numeric(x::Number, y::Number) = false\nsame_type_numeric (generic function with 2 methods)\n\njulia> same_type_numeric(1, 2)\ntrue\n\njulia> same_type_numeric(1, 2.0)\nfalse\n\njulia> same_type_numeric(1.0, 2.0)\ntrue\n\njulia> same_type_numeric(\"foo\", 2.0)\nERROR: MethodError: no method matching same_type_numeric(::String, ::Float64)\nClosest candidates are:\n  same_type_numeric(!Matched::T<:Number, ::T<:Number) where T<:Number at none:1\n  same_type_numeric(!Matched::Number, ::Number) at none:1\n\njulia> same_type_numeric(\"foo\", \"bar\")\nERROR: MethodError: no method matching same_type_numeric(::String, ::String)\n\njulia> same_type_numeric(Int32(1), Int64(2))\nfalseThe same_type_numeric function behaves much like the same_type function defined above, but is only defined for pairs of numbers.Parametric methods allow the same syntax as where expressions used to write types (see UnionAll Types). If there is only a single parameter, the enclosing curly braces (in where {T}) can be omitted, but are often preferred for clarity. Multiple parameters can be separated with commas, e.g. where {T, S<:Real}, or written using nested where, e.g. where S<:Real where T."
},

{
    "location": "manual/methods.html#Redefining-Methods-1",
    "page": "Methods",
    "title": "Redefining Methods",
    "category": "section",
    "text": "When redefining a method or adding new methods, it is important to realize that these changes don\'t take effect immediately. This is key to Julia\'s ability to statically infer and compile code to run fast, without the usual JIT tricks and overhead. Indeed, any new method definition won\'t be visible to the current runtime environment, including Tasks and Threads (and any previously defined @generated functions). Let\'s start with an example to see what this means:julia> function tryeval()\n           @eval newfun() = 1\n           newfun()\n       end\ntryeval (generic function with 1 method)\n\njulia> tryeval()\nERROR: MethodError: no method matching newfun()\nThe applicable method may be too new: running in world age xxxx1, while current world is xxxx2.\nClosest candidates are:\n  newfun() at none:1 (method too new to be called from this world context.)\n in tryeval() at none:1\n ...\n\njulia> newfun()\n1In this example, observe that the new definition for newfun has been created, but can\'t be immediately called. The new global is immediately visible to the tryeval function, so you could write return newfun (without parentheses). But neither you, nor any of your callers, nor the functions they call, or etc. can call this new method definition!But there\'s an exception: future calls to newfun from the REPL work as expected, being able to both see and call the new definition of newfun.However, future calls to tryeval will continue to see the definition of newfun as it was at the previous statement at the REPL, and thus before that call to tryeval.You may want to try this for yourself to see how it works.The implementation of this behavior is a \"world age counter\". This monotonically increasing value tracks each method definition operation. This allows describing \"the set of method definitions visible to a given runtime environment\" as a single number, or \"world age\". It also allows comparing the methods available in two worlds just by comparing their ordinal value. In the example above, we see that the \"current world\" (in which the method newfun exists), is one greater than the task-local \"runtime world\" that was fixed when the execution of tryeval started.Sometimes it is necessary to get around this (for example, if you are implementing the above REPL). Fortunately, there is an easy solution: call the function using Base.invokelatest:julia> function tryeval2()\n           @eval newfun2() = 2\n           Base.invokelatest(newfun2)\n       end\ntryeval2 (generic function with 1 method)\n\njulia> tryeval2()\n2Finally, let\'s take a look at some more complex examples where this rule comes into play. Define a function f(x), which initially has one method:julia> f(x) = \"original definition\"\nf (generic function with 1 method)Start some other operations that use f(x):julia> g(x) = f(x)\ng (generic function with 1 method)\n\njulia> t = @async f(wait()); yield();Now we add some new methods to f(x):julia> f(x::Int) = \"definition for Int\"\nf (generic function with 2 methods)\n\njulia> f(x::Type{Int}) = \"definition for Type{Int}\"\nf (generic function with 3 methods)Compare how these results differ:julia> f(1)\n\"definition for Int\"\n\njulia> g(1)\n\"definition for Int\"\n\njulia> fetch(schedule(t, 1))\n\"original definition\"\n\njulia> t = @async f(wait()); yield();\n\njulia> fetch(schedule(t, 1))\n\"definition for Int\""
},

{
    "location": "manual/methods.html#Design-Patterns-with-Parametric-Methods-1",
    "page": "Methods",
    "title": "Design Patterns with Parametric Methods",
    "category": "section",
    "text": "While complex dispatch logic is not required for performance or usability, sometimes it can be the best way to express some algorithm. Here are a few common design patterns that come up sometimes when using dispatch in this way."
},

{
    "location": "manual/methods.html#Extracting-the-type-parameter-from-a-super-type-1",
    "page": "Methods",
    "title": "Extracting the type parameter from a super-type",
    "category": "section",
    "text": "Here is the correct code template for returning the element-type T of any arbitrary subtype of AbstractArray:abstract type AbstractArray{T, N} end\neltype(::Type{<:AbstractArray{T}}) where {T} = Tusing so-called triangular dispatch.  Note that if T is a UnionAll type, as e.g. eltype(Array{T} where T <: Integer), then Any is returned (as does the the version of eltype in Base).Another way, which used to be the only correct way before the advent of triangular dispatch in Julia v0.6, is:abstract type AbstractArray{T, N} end\neltype(::Type{AbstractArray}) = Any\neltype(::Type{AbstractArray{T}}) where {T} = T\neltype(::Type{AbstractArray{T, N}}) where {T, N} = T\neltype(::Type{A}) where {A<:AbstractArray} = eltype(supertype(A))Another possibility is the following, which could useful to adapt to cases where the parameter T would need to be matched more narrowly:eltype(::Type{AbstractArray{T, N} where {T<:S, N<:M}}) where {M, S} = Any\neltype(::Type{AbstractArray{T, N} where {T<:S}}) where {N, S} = Any\neltype(::Type{AbstractArray{T, N} where {N<:M}}) where {M, T} = T\neltype(::Type{AbstractArray{T, N}}) where {T, N} = T\neltype(::Type{A}) where {A <: AbstractArray} = eltype(supertype(A))One common mistake is to try and get the element-type by using introspection:eltype_wrong(::Type{A}) where {A<:AbstractArray} = A.parameters[1]However, it is not hard to construct cases where this will fail:struct BitVector <: AbstractArray{Bool, 1}; endHere we have created a type BitVector which has no parameters, but where the element-type is still fully specified, with T equal to Bool!"
},

{
    "location": "manual/methods.html#Building-a-similar-type-with-a-different-type-parameter-1",
    "page": "Methods",
    "title": "Building a similar type with a different type parameter",
    "category": "section",
    "text": "When building generic code, there is often a need for constructing a similar object with some change made to the layout of the type, also necessitating a change of the type parameters. For instance, you might have some sort of abstract array with an arbitrary element type and want to write your computation on it with a specific element type. We must implement a method for each AbstractArray{T} subtype that describes how to compute this type transform. There is no general transform of one subtype into another subtype with a different parameter. (Quick review: do you see why this is?)The subtypes of AbstractArray typically implement two methods to achieve this: A method to convert the input array to a subtype of a specific AbstractArray{T, N} abstract type; and a method to make a new uninitialized array with a specific element type. Sample implementations of these can be found in Julia Base. Here is a basic example usage of them, guaranteeing that input and output are of the same type:input = convert(AbstractArray{Eltype}, input)\noutput = similar(input, Eltype)As an extension of this, in cases where the algorithm needs a copy of the input array, convert is insufficient as the return value may alias the original input. Combining similar (to make the output array) and copyto! (to fill it with the input data) is a generic way to express the requirement for a mutable copy of the input argument:copy_with_eltype(input, Eltype) = copyto!(similar(input, Eltype), input)"
},

{
    "location": "manual/methods.html#Iterated-dispatch-1",
    "page": "Methods",
    "title": "Iterated dispatch",
    "category": "section",
    "text": "In order to dispatch a multi-level parametric argument list, often it is best to separate each level of dispatch into distinct functions. This may sound similar in approach to single-dispatch, but as we shall see below, it is still more flexible.For example, trying to dispatch on the element-type of an array will often run into ambiguous situations. Instead, commonly code will dispatch first on the container type, then recurse down to a more specific method based on eltype. In most cases, the algorithms lend themselves conveniently to this hierarchical approach, while in other cases, this rigor must be resolved manually. This dispatching branching can be observed, for example, in the logic to sum two matrices:# First dispatch selects the map algorithm for element-wise summation.\n+(a::Matrix, b::Matrix) = map(+, a, b)\n# Then dispatch handles each element and selects the appropriate\n# common element type for the computation.\n+(a, b) = +(promote(a, b)...)\n# Once the elements have the same type, they can be added.\n# For example, via primitive operations exposed by the processor.\n+(a::Float64, b::Float64) = Core.add(a, b)"
},

{
    "location": "manual/methods.html#Trait-based-dispatch-1",
    "page": "Methods",
    "title": "Trait-based dispatch",
    "category": "section",
    "text": "A natural extension to the iterated dispatch above is to add a layer to method selection that allows to dispatch on sets of types which are independent from the sets defined by the type hierarchy. We could construct such a set by writing out a Union of the types in question, but then this set would not be extensible as Union-types cannot be altered after creation. However, such an extensible set can be programmed with a design pattern often referred to as a \"Holy-trait\".This pattern is implemented by defining a generic function which computes a different singleton value (or type) for each trait-set to which the function arguments may belong to.  If this function is pure there is no impact on performance compared to normal dispatch.The example in the previous section glossed over the implementation details of map and promote, which both operate in terms of these traits. When iterating over a matrix, such as in the implementation of map, one important question is what order to use to traverse the data. When AbstractArray subtypes implement the Base.IndexStyle trait, other functions such as map can dispatch on this information to pick the best algorithm (see Abstract Array Interface). This means that each subtype does not need to implement a custom version of map, since the generic definitions + trait classes will enable the system to select the fastest version. Here a toy implementation of map illustrating the trait-based dispatch:map(f, a::AbstractArray, b::AbstractArray) = map(Base.IndexStyle(a, b), f, a, b)\n# generic implementation:\nmap(::Base.IndexCartesian, f, a::AbstractArray, b::AbstractArray) = ...\n# linear-indexing implementation (faster)\nmap(::Base.IndexLinear, f, a::AbstractArray, b::AbstractArray) = ...This trait-based approach is also present in the promote mechanism employed by the scalar +. It uses promote_type, which returns the optimal common type to compute the operation given the two types of the operands. This makes it possible to reduce the problem of implementing every function for every pair of possible type arguments, to the much smaller problem of implementing a conversion operation from each type to a common type, plus a table of preferred pair-wise promotion rules."
},

{
    "location": "manual/methods.html#Output-type-computation-1",
    "page": "Methods",
    "title": "Output-type computation",
    "category": "section",
    "text": "The discussion of trait-based promotion provides a transition into our next design pattern: computing the output element type for a matrix operation.For implementing primitive operations, such as addition, we use the promote_type function to compute the desired output type. (As before, we saw this at work in the promote call in the call to +).For more complex functions on matrices, it may be necessary to compute the expected return type for a more complex sequence of operations. This is often performed by the following steps:Write a small function op that expresses the set of operations performed by the kernel of the algorithm.\nCompute the element type R of the result matrix as promote_op(op, argument_types...), where argument_types is computed from eltype applied to each input array.\nBuild the output matrix as similar(R, dims), where dims are the desired dimensions of the output array.For a more specific example, a generic square-matrix multiply pseudo-code might look like:function matmul(a::AbstractMatrix, b::AbstractMatrix)\n    op = (ai, bi) -> ai * bi + ai * bi\n\n    ## this is insufficient because it assumes `one(eltype(a))` is constructable:\n    # R = typeof(op(one(eltype(a)), one(eltype(b))))\n\n    ## this fails because it assumes `a[1]` exists and is representative of all elements of the array\n    # R = typeof(op(a[1], b[1]))\n\n    ## this is incorrect because it assumes that `+` calls `promote_type`\n    ## but this is not true for some types, such as Bool:\n    # R = promote_type(ai, bi)\n\n    # this is wrong, since depending on the return value\n    # of type-inference is very brittle (as well as not being optimizable):\n    # R = Base.return_types(op, (eltype(a), eltype(b)))\n\n    ## but, finally, this works:\n    R = promote_op(op, eltype(a), eltype(b))\n    ## although sometimes it may give a larger type than desired\n    ## it will always give a correct type\n\n    output = similar(b, R, (size(a, 1), size(b, 2)))\n    if size(a, 2) > 0\n        for j in 1:size(b, 2)\n            for i in 1:size(b, 1)\n                ## here we don\'t use `ab = zero(R)`,\n                ## since `R` might be `Any` and `zero(Any)` is not defined\n                ## we also must declare `ab::R` to make the type of `ab` constant in the loop,\n                ## since it is possible that typeof(a * b) != typeof(a * b + a * b) == R\n                ab::R = a[i, 1] * b[1, j]\n                for k in 2:size(a, 2)\n                    ab += a[i, k] * b[k, j]\n                end\n                output[i, j] = ab\n            end\n        end\n    end\n    return output\nend"
},

{
    "location": "manual/methods.html#Separate-convert-and-kernel-logic-1",
    "page": "Methods",
    "title": "Separate convert and kernel logic",
    "category": "section",
    "text": "One way to significantly cut down on compile-times and testing complexity is to isolate the logic for converting to the desired type and the computation. This lets the compiler specialize and inline the conversion logic independent from the rest of the body of the larger kernel.This is a common pattern seen when converting from a larger class of types to the one specific argument type that is actually supported by the algorithm:complexfunction(arg::Int) = ...\ncomplexfunction(arg::Any) = complexfunction(convert(Int, arg))\n\nmatmul(a::T, b::T) = ...\nmatmul(a, b) = matmul(promote(a, b)...)"
},

{
    "location": "manual/methods.html#Parametrically-constrained-Varargs-methods-1",
    "page": "Methods",
    "title": "Parametrically-constrained Varargs methods",
    "category": "section",
    "text": "Function parameters can also be used to constrain the number of arguments that may be supplied to a \"varargs\" function (Varargs Functions).  The notation Vararg{T,N} is used to indicate such a constraint.  For example:julia> bar(a,b,x::Vararg{Any,2}) = (a,b,x)\nbar (generic function with 1 method)\n\njulia> bar(1,2,3)\nERROR: MethodError: no method matching bar(::Int64, ::Int64, ::Int64)\nClosest candidates are:\n  bar(::Any, ::Any, ::Any, !Matched::Any) at none:1\n\njulia> bar(1,2,3,4)\n(1, 2, (3, 4))\n\njulia> bar(1,2,3,4,5)\nERROR: MethodError: no method matching bar(::Int64, ::Int64, ::Int64, ::Int64, ::Int64)\nClosest candidates are:\n  bar(::Any, ::Any, ::Any, ::Any) at none:1More usefully, it is possible to constrain varargs methods by a parameter. For example:function getindex(A::AbstractArray{T,N}, indices::Vararg{Number,N}) where {T,N}would be called only when the number of indices matches the dimensionality of the array.When only the type of supplied arguments needs to be constrained Vararg{T} can be equivalently written as T.... For instance f(x::Int...) = x is a shorthand for f(x::Vararg{Int}) = x."
},

{
    "location": "manual/methods.html#Note-on-Optional-and-keyword-Arguments-1",
    "page": "Methods",
    "title": "Note on Optional and keyword Arguments",
    "category": "section",
    "text": "As mentioned briefly in Functions, optional arguments are implemented as syntax for multiple method definitions. For example, this definition:f(a=1,b=2) = a+2btranslates to the following three methods:f(a,b) = a+2b\nf(a) = f(a,2)\nf() = f(1,2)This means that calling f() is equivalent to calling f(1,2). In this case the result is 5, because f(1,2) invokes the first method of f above. However, this need not always be the case. If you define a fourth method that is more specialized for integers:f(a::Int,b::Int) = a-2bthen the result of both f() and f(1,2) is -3. In other words, optional arguments are tied to a function, not to any specific method of that function. It depends on the types of the optional arguments which method is invoked. When optional arguments are defined in terms of a global variable, the type of the optional argument may even change at run-time.Keyword arguments behave quite differently from ordinary positional arguments. In particular, they do not participate in method dispatch. Methods are dispatched based only on positional arguments, with keyword arguments processed after the matching method is identified."
},

{
    "location": "manual/methods.html#Function-like-objects-1",
    "page": "Methods",
    "title": "Function-like objects",
    "category": "section",
    "text": "Methods are associated with types, so it is possible to make any arbitrary Julia object \"callable\" by adding methods to its type. (Such \"callable\" objects are sometimes called \"functors.\")For example, you can define a type that stores the coefficients of a polynomial, but behaves like a function evaluating the polynomial:julia> struct Polynomial{R}\n           coeffs::Vector{R}\n       end\n\njulia> function (p::Polynomial)(x)\n           v = p.coeffs[end]\n           for i = (length(p.coeffs)-1):-1:1\n               v = v*x + p.coeffs[i]\n           end\n           return v\n       end\n\njulia> (p::Polynomial)() = p(5)Notice that the function is specified by type instead of by name. As with normal functions there is a terse syntax form. In the function body, p will refer to the object that was called. A Polynomial can be used as follows:julia> p = Polynomial([1,10,100])\nPolynomial{Int64}([1, 10, 100])\n\njulia> p(3)\n931\n\njulia> p()\n2551This mechanism is also the key to how type constructors and closures (inner functions that refer to their surrounding environment) work in Julia."
},

{
    "location": "manual/methods.html#Empty-generic-functions-1",
    "page": "Methods",
    "title": "Empty generic functions",
    "category": "section",
    "text": "Occasionally it is useful to introduce a generic function without yet adding methods. This can be used to separate interface definitions from implementations. It might also be done for the purpose of documentation or code readability. The syntax for this is an empty function block without a tuple of arguments:function emptyfunc\nend"
},

{
    "location": "manual/methods.html#man-method-design-ambiguities-1",
    "page": "Methods",
    "title": "Method design and the avoidance of ambiguities",
    "category": "section",
    "text": "Julia\'s method polymorphism is one of its most powerful features, yet exploiting this power can pose design challenges.  In particular, in more complex method hierarchies it is not uncommon for ambiguities to arise.Above, it was pointed out that one can resolve ambiguities likef(x, y::Int) = 1\nf(x::Int, y) = 2by defining a methodf(x::Int, y::Int) = 3This is often the right strategy; however, there are circumstances where following this advice blindly can be counterproductive. In particular, the more methods a generic function has, the more possibilities there are for ambiguities. When your method hierarchies get more complicated than this simple example, it can be worth your while to think carefully about alternative strategies.Below we discuss particular challenges and some alternative ways to resolve such issues."
},

{
    "location": "manual/methods.html#Tuple-and-NTuple-arguments-1",
    "page": "Methods",
    "title": "Tuple and NTuple arguments",
    "category": "section",
    "text": "Tuple (and NTuple) arguments present special challenges. For example,f(x::NTuple{N,Int}) where {N} = 1\nf(x::NTuple{N,Float64}) where {N} = 2are ambiguous because of the possibility that N == 0: there are no elements to determine whether the Int or Float64 variant should be called. To resolve the ambiguity, one approach is define a method for the empty tuple:f(x::Tuple{}) = 3Alternatively, for all methods but one you can insist that there is at least one element in the tuple:f(x::NTuple{N,Int}) where {N} = 1           # this is the fallback\nf(x::Tuple{Float64, Vararg{Float64}}) = 2   # this requires at least one Float64"
},

{
    "location": "manual/methods.html#man-methods-orthogonalize-1",
    "page": "Methods",
    "title": "Orthogonalize your design",
    "category": "section",
    "text": "When you might be tempted to dispatch on two or more arguments, consider whether a \"wrapper\" function might make for a simpler design. For example, instead of writing multiple variants:f(x::A, y::A) = ...\nf(x::A, y::B) = ...\nf(x::B, y::A) = ...\nf(x::B, y::B) = ...you might consider definingf(x::A, y::A) = ...\nf(x, y) = f(g(x), g(y))where g converts the argument to type A. This is a very specific example of the more general principle of orthogonal design, in which separate concepts are assigned to separate methods. Here, g will most likely need a fallback definitiong(x::A) = xA related strategy exploits promote to bring x and y to a common type:f(x::T, y::T) where {T} = ...\nf(x, y) = f(promote(x, y)...)One risk with this design is the possibility that if there is no suitable promotion method converting x and y to the same type, the second method will recurse on itself infinitely and trigger a stack overflow. The non-exported function Base.promote_noncircular can be used as an alternative; when promotion fails it will still throw an error, but one that fails faster with a more specific error message."
},

{
    "location": "manual/methods.html#Dispatch-on-one-argument-at-a-time-1",
    "page": "Methods",
    "title": "Dispatch on one argument at a time",
    "category": "section",
    "text": "If you need to dispatch on multiple arguments, and there are many fallbacks with too many combinations to make it practical to define all possible variants, then consider introducing a \"name cascade\" where (for example) you dispatch on the first argument and then call an internal method:f(x::A, y) = _fA(x, y)\nf(x::B, y) = _fB(x, y)Then the internal methods _fA and _fB can dispatch on y without concern about ambiguities with each other with respect to x.Be aware that this strategy has at least one major disadvantage: in many cases, it is not possible for users to further customize the behavior of f by defining further specializations of your exported function f. Instead, they have to define specializations for your internal methods _fA and _fB, and this blurs the lines between exported and internal methods."
},

{
    "location": "manual/methods.html#Abstract-containers-and-element-types-1",
    "page": "Methods",
    "title": "Abstract containers and element types",
    "category": "section",
    "text": "Where possible, try to avoid defining methods that dispatch on specific element types of abstract containers. For example,-(A::AbstractArray{T}, b::Date) where {T<:Date}generates ambiguities for anyone who defines a method-(A::MyArrayType{T}, b::T) where {T}The best approach is to avoid defining either of these methods: instead, rely on a generic method -(A::AbstractArray, b) and make sure this method is implemented with generic calls (like similar and -) that do the right thing for each container type and element type separately. This is just a more complex variant of the advice to orthogonalize your methods.When this approach is not possible, it may be worth starting a discussion with other developers about resolving the ambiguity; just because one method was defined first does not necessarily mean that it can\'t be modified or eliminated.  As a last resort, one developer can define the \"band-aid\" method-(A::MyArrayType{T}, b::Date) where {T<:Date} = ...that resolves the ambiguity by brute force."
},

{
    "location": "manual/methods.html#Complex-method-\"cascades\"-with-default-arguments-1",
    "page": "Methods",
    "title": "Complex method \"cascades\" with default arguments",
    "category": "section",
    "text": "If you are defining a method \"cascade\" that supplies defaults, be careful about dropping any arguments that correspond to potential defaults. For example, suppose you\'re writing a digital filtering algorithm and you have a method that handles the edges of the signal by applying padding:function myfilter(A, kernel, ::Replicate)\n    Apadded = replicate_edges(A, size(kernel))\n    myfilter(Apadded, kernel)  # now perform the \"real\" computation\nendThis will run afoul of a method that supplies default padding:myfilter(A, kernel) = myfilter(A, kernel, Replicate()) # replicate the edge by defaultTogether, these two methods generate an infinite recursion with A constantly growing bigger.The better design would be to define your call hierarchy like this:struct NoPad end  # indicate that no padding is desired, or that it\'s already applied\n\nmyfilter(A, kernel) = myfilter(A, kernel, Replicate())  # default boundary conditions\n\nfunction myfilter(A, kernel, ::Replicate)\n    Apadded = replicate_edges(A, size(kernel))\n    myfilter(Apadded, kernel, NoPad())  # indicate the new boundary conditions\nend\n\n# other padding methods go here\n\nfunction myfilter(A, kernel, ::NoPad)\n    # Here\'s the \"real\" implementation of the core computation\nendNoPad is supplied in the same argument position as any other kind of padding, so it keeps the dispatch hierarchy well organized and with reduced likelihood of ambiguities. Moreover, it extends the \"public\" myfilter interface: a user who wants to control the padding explicitly can call the NoPad variant directly.[Clarke61]: Arthur C. Clarke, Profiles of the Future (1961): Clarke\'s Third Law."
},

{
    "location": "manual/constructors.html#",
    "page": "Constructors",
    "title": "Constructors",
    "category": "page",
    "text": ""
},

{
    "location": "manual/constructors.html#man-constructors-1",
    "page": "Constructors",
    "title": "Constructors",
    "category": "section",
    "text": "Constructors [1] are functions that create new objects – specifically, instances of Composite Types. In Julia, type objects also serve as constructor functions: they create new instances of themselves when applied to an argument tuple as a function. This much was already mentioned briefly when composite types were introduced. For example:julia> struct Foo\n           bar\n           baz\n       end\n\njulia> foo = Foo(1, 2)\nFoo(1, 2)\n\njulia> foo.bar\n1\n\njulia> foo.baz\n2For many types, forming new objects by binding their field values together is all that is ever needed to create instances. However, in some cases more functionality is required when creating composite objects. Sometimes invariants must be enforced, either by checking arguments or by transforming them. Recursive data structures, especially those that may be self-referential, often cannot be constructed cleanly without first being created in an incomplete state and then altered programmatically to be made whole, as a separate step from object creation. Sometimes, it\'s just convenient to be able to construct objects with fewer or different types of parameters than they have fields. Julia\'s system for object construction addresses all of these cases and more.[1]: Nomenclature: while the term \"constructor\" generally refers to the entire function which constructs objects of a type, it is common to abuse terminology slightly and refer to specific constructor methods as \"constructors\". In such situations, it is generally clear from the context that the term is used to mean \"constructor method\" rather than \"constructor function\", especially as it is often used in the sense of singling out a particular method of the constructor from all of the others."
},

{
    "location": "manual/constructors.html#Outer-Constructor-Methods-1",
    "page": "Constructors",
    "title": "Outer Constructor Methods",
    "category": "section",
    "text": "A constructor is just like any other function in Julia in that its overall behavior is defined by the combined behavior of its methods. Accordingly, you can add functionality to a constructor by simply defining new methods. For example, let\'s say you want to add a constructor method for Foo objects that takes only one argument and uses the given value for both the bar and baz fields. This is simple:julia> Foo(x) = Foo(x,x)\nFoo\n\njulia> Foo(1)\nFoo(1, 1)You could also add a zero-argument Foo constructor method that supplies default values for both of the bar and baz fields:julia> Foo() = Foo(0)\nFoo\n\njulia> Foo()\nFoo(0, 0)Here the zero-argument constructor method calls the single-argument constructor method, which in turn calls the automatically provided two-argument constructor method. For reasons that will become clear very shortly, additional constructor methods declared as normal methods like this are called outer constructor methods. Outer constructor methods can only ever create a new instance by calling another constructor method, such as the automatically provided default ones."
},

{
    "location": "manual/constructors.html#Inner-Constructor-Methods-1",
    "page": "Constructors",
    "title": "Inner Constructor Methods",
    "category": "section",
    "text": "While outer constructor methods succeed in addressing the problem of providing additional convenience methods for constructing objects, they fail to address the other two use cases mentioned in the introduction of this chapter: enforcing invariants, and allowing construction of self-referential objects. For these problems, one needs inner constructor methods. An inner constructor method is like an outer constructor method, except for two differences:It is declared inside the block of a type declaration, rather than outside of it like normal methods.\nIt has access to a special locally existent function called new that creates objects of the block\'s type.For example, suppose one wants to declare a type that holds a pair of real numbers, subject to the constraint that the first number is not greater than the second one. One could declare it like this:julia> struct OrderedPair\n           x::Real\n           y::Real\n           OrderedPair(x,y) = x > y ? error(\"out of order\") : new(x,y)\n       endNow OrderedPair objects can only be constructed such that x <= y:julia> OrderedPair(1, 2)\nOrderedPair(1, 2)\n\njulia> OrderedPair(2,1)\nERROR: out of order\nStacktrace:\n [1] error at ./error.jl:33 [inlined]\n [2] OrderedPair(::Int64, ::Int64) at ./none:4\n [3] top-level scopeIf the type were declared mutable, you could reach in and directly change the field values to violate this invariant. Of course, messing around with an object\'s internals uninvited is bad practice. You (or someone else) can also provide additional outer constructor methods at any later point, but once a type is declared, there is no way to add more inner constructor methods. Since outer constructor methods can only create objects by calling other constructor methods, ultimately, some inner constructor must be called to create an object. This guarantees that all objects of the declared type must come into existence by a call to one of the inner constructor methods provided with the type, thereby giving some degree of enforcement of a type\'s invariants.If any inner constructor method is defined, no default constructor method is provided: it is presumed that you have supplied yourself with all the inner constructors you need. The default constructor is equivalent to writing your own inner constructor method that takes all of the object\'s fields as parameters (constrained to be of the correct type, if the corresponding field has a type), and passes them to new, returning the resulting object:julia> struct Foo\n           bar\n           baz\n           Foo(bar,baz) = new(bar,baz)\n       end\nThis declaration has the same effect as the earlier definition of the Foo type without an explicit inner constructor method. The following two types are equivalent – one with a default constructor, the other with an explicit constructor:julia> struct T1\n           x::Int64\n       end\n\njulia> struct T2\n           x::Int64\n           T2(x) = new(x)\n       end\n\njulia> T1(1)\nT1(1)\n\njulia> T2(1)\nT2(1)\n\njulia> T1(1.0)\nT1(1)\n\njulia> T2(1.0)\nT2(1)It is good practice to provide as few inner constructor methods as possible: only those taking all arguments explicitly and enforcing essential error checking and transformation. Additional convenience constructor methods, supplying default values or auxiliary transformations, should be provided as outer constructors that call the inner constructors to do the heavy lifting. This separation is typically quite natural."
},

{
    "location": "manual/constructors.html#Incomplete-Initialization-1",
    "page": "Constructors",
    "title": "Incomplete Initialization",
    "category": "section",
    "text": "The final problem which has still not been addressed is construction of self-referential objects, or more generally, recursive data structures. Since the fundamental difficulty may not be immediately obvious, let us briefly explain it. Consider the following recursive type declaration:julia> mutable struct SelfReferential\n           obj::SelfReferential\n       end\nThis type may appear innocuous enough, until one considers how to construct an instance of it. If a is an instance of SelfReferential, then a second instance can be created by the call:julia> b = SelfReferential(a)But how does one construct the first instance when no instance exists to provide as a valid value for its obj field? The only solution is to allow creating an incompletely initialized instance of SelfReferential with an unassigned obj field, and using that incomplete instance as a valid value for the obj field of another instance, such as, for example, itself.To allow for the creation of incompletely initialized objects, Julia allows the new function to be called with fewer than the number of fields that the type has, returning an object with the unspecified fields uninitialized. The inner constructor method can then use the incomplete object, finishing its initialization before returning it. Here, for example, is another attempt at defining the SelfReferential type, this time using a zero-argument inner constructor returning instances having obj fields pointing to themselves:julia> mutable struct SelfReferential\n           obj::SelfReferential\n           SelfReferential() = (x = new(); x.obj = x)\n       end\nWe can verify that this constructor works and constructs objects that are, in fact, self-referential:julia> x = SelfReferential();\n\njulia> x === x\ntrue\n\njulia> x === x.obj\ntrue\n\njulia> x === x.obj.obj\ntrueAlthough it is generally a good idea to return a fully initialized object from an inner constructor, it is possible to return incompletely initialized objects:julia> mutable struct Incomplete\n           data\n           Incomplete() = new()\n       end\n\njulia> z = Incomplete();While you are allowed to create objects with uninitialized fields, any access to an uninitialized reference is an immediate error:julia> z.data\nERROR: UndefRefError: access to undefined referenceThis avoids the need to continually check for null values. However, not all object fields are references. Julia considers some types to be \"plain data\", meaning all of their data is self-contained and does not reference other objects. The plain data types consist of primitive types (e.g. Int) and immutable structs of other plain data types. The initial contents of a plain data type is undefined:julia> struct HasPlain\n           n::Int\n           HasPlain() = new()\n       end\n\njulia> HasPlain()\nHasPlain(438103441441)Arrays of plain data types exhibit the same behavior.You can pass incomplete objects to other functions from inner constructors to delegate their completion:julia> mutable struct Lazy\n           data\n           Lazy(v) = complete_me(new(), v)\n       endAs with incomplete objects returned from constructors, if complete_me or any of its callees try to access the data field of the Lazy object before it has been initialized, an error will be thrown immediately."
},

{
    "location": "manual/constructors.html#Parametric-Constructors-1",
    "page": "Constructors",
    "title": "Parametric Constructors",
    "category": "section",
    "text": "Parametric types add a few wrinkles to the constructor story. Recall from Parametric Types that, by default, instances of parametric composite types can be constructed either with explicitly given type parameters or with type parameters implied by the types of the arguments given to the constructor. Here are some examples:julia> struct Point{T<:Real}\n           x::T\n           y::T\n       end\n\njulia> Point(1,2) ## implicit T ##\nPoint{Int64}(1, 2)\n\njulia> Point(1.0,2.5) ## implicit T ##\nPoint{Float64}(1.0, 2.5)\n\njulia> Point(1,2.5) ## implicit T ##\nERROR: MethodError: no method matching Point(::Int64, ::Float64)\nClosest candidates are:\n  Point(::T<:Real, ::T<:Real) where T<:Real at none:2\n\njulia> Point{Int64}(1, 2) ## explicit T ##\nPoint{Int64}(1, 2)\n\njulia> Point{Int64}(1.0,2.5) ## explicit T ##\nERROR: InexactError: Int64(2.5)\nStacktrace:\n[...]\n\njulia> Point{Float64}(1.0, 2.5) ## explicit T ##\nPoint{Float64}(1.0, 2.5)\n\njulia> Point{Float64}(1,2) ## explicit T ##\nPoint{Float64}(1.0, 2.0)As you can see, for constructor calls with explicit type parameters, the arguments are converted to the implied field types: Point{Int64}(1,2) works, but Point{Int64}(1.0,2.5) raises an InexactError when converting 2.5 to Int64. When the type is implied by the arguments to the constructor call, as in Point(1,2), then the types of the arguments must agree – otherwise the T cannot be determined – but any pair of real arguments with matching type may be given to the generic Point constructor.What\'s really going on here is that Point, Point{Float64} and Point{Int64} are all different constructor functions. In fact, Point{T} is a distinct constructor function for each type T. Without any explicitly provided inner constructors, the declaration of the composite type Point{T<:Real} automatically provides an inner constructor, Point{T}, for each possible type T<:Real, that behaves just like non-parametric default inner constructors do. It also provides a single general outer Point constructor that takes pairs of real arguments, which must be of the same type. This automatic provision of constructors is equivalent to the following explicit declaration:julia> struct Point{T<:Real}\n           x::T\n           y::T\n           Point{T}(x,y) where {T<:Real} = new(x,y)\n       end\n\njulia> Point(x::T, y::T) where {T<:Real} = Point{T}(x,y);Notice that each definition looks like the form of constructor call that it handles. The call Point{Int64}(1,2) will invoke the definition Point{T}(x,y) inside the struct block. The outer constructor declaration, on the other hand, defines a method for the general Point constructor which only applies to pairs of values of the same real type. This declaration makes constructor calls without explicit type parameters, like Point(1,2) and Point(1.0,2.5), work. Since the method declaration restricts the arguments to being of the same type, calls like Point(1,2.5), with arguments of different types, result in \"no method\" errors.Suppose we wanted to make the constructor call Point(1,2.5) work by \"promoting\" the integer value 1 to the floating-point value 1.0. The simplest way to achieve this is to define the following additional outer constructor method:julia> Point(x::Int64, y::Float64) = Point(convert(Float64,x),y);This method uses the convert function to explicitly convert x to Float64 and then delegates construction to the general constructor for the case where both arguments are Float64. With this method definition what was previously a MethodError now successfully creates a point of type Point{Float64}:julia> Point(1,2.5)\nPoint{Float64}(1.0, 2.5)\n\njulia> typeof(ans)\nPoint{Float64}However, other similar calls still don\'t work:julia> Point(1.5,2)\nERROR: MethodError: no method matching Point(::Float64, ::Int64)\nClosest candidates are:\n  Point(::T<:Real, !Matched::T<:Real) where T<:Real at none:1For a more general way to make all such calls work sensibly, see Conversion and Promotion. At the risk of spoiling the suspense, we can reveal here that all it takes is the following outer method definition to make all calls to the general Point constructor work as one would expect:julia> Point(x::Real, y::Real) = Point(promote(x,y)...);The promote function converts all its arguments to a common type – in this case Float64. With this method definition, the Point constructor promotes its arguments the same way that numeric operators like + do, and works for all kinds of real numbers:julia> Point(1.5,2)\nPoint{Float64}(1.5, 2.0)\n\njulia> Point(1,1//2)\nPoint{Rational{Int64}}(1//1, 1//2)\n\njulia> Point(1.0,1//2)\nPoint{Float64}(1.0, 0.5)Thus, while the implicit type parameter constructors provided by default in Julia are fairly strict, it is possible to make them behave in a more relaxed but sensible manner quite easily. Moreover, since constructors can leverage all of the power of the type system, methods, and multiple dispatch, defining sophisticated behavior is typically quite simple."
},

{
    "location": "manual/constructors.html#Case-Study:-Rational-1",
    "page": "Constructors",
    "title": "Case Study: Rational",
    "category": "section",
    "text": "Perhaps the best way to tie all these pieces together is to present a real world example of a parametric composite type and its constructor methods. To that end, we implement our own rational number type OurRational, similar to Julia\'s built-in Rational type, defined in rational.jl:julia> struct OurRational{T<:Integer} <: Real\n           num::T\n           den::T\n           function OurRational{T}(num::T, den::T) where T<:Integer\n               if num == 0 && den == 0\n                    error(\"invalid rational: 0//0\")\n               end\n               g = gcd(den, num)\n               num = div(num, g)\n               den = div(den, g)\n               new(num, den)\n           end\n       end\n\njulia> OurRational(n::T, d::T) where {T<:Integer} = OurRational{T}(n,d)\nOurRational\n\njulia> OurRational(n::Integer, d::Integer) = OurRational(promote(n,d)...)\nOurRational\n\njulia> OurRational(n::Integer) = OurRational(n,one(n))\nOurRational\n\njulia> ⊘(n::Integer, d::Integer) = OurRational(n,d)\n⊘ (generic function with 1 method)\n\njulia> ⊘(x::OurRational, y::Integer) = x.num ⊘ (x.den*y)\n⊘ (generic function with 2 methods)\n\njulia> ⊘(x::Integer, y::OurRational) = (x*y.den) ⊘ y.num\n⊘ (generic function with 3 methods)\n\njulia> ⊘(x::Complex, y::Real) = complex(real(x) ⊘ y, imag(x) ⊘ y)\n⊘ (generic function with 4 methods)\n\njulia> ⊘(x::Real, y::Complex) = (x*y\') ⊘ real(y*y\')\n⊘ (generic function with 5 methods)\n\njulia> function ⊘(x::Complex, y::Complex)\n           xy = x*y\'\n           yy = real(y*y\')\n           complex(real(xy) ⊘ yy, imag(xy) ⊘ yy)\n       end\n⊘ (generic function with 6 methods)The first line – struct OurRational{T<:Integer} <: Real – declares that OurRational takes one type parameter of an integer type, and is itself a real type. The field declarations num::T and den::T indicate that the data held in a OurRational{T} object are a pair of integers of type T, one representing the rational value\'s numerator and the other representing its denominator.Now things get interesting. OurRational has a single inner constructor method which checks that both of num and den aren\'t zero and ensures that every rational is constructed in \"lowest terms\" with a non-negative denominator. This is accomplished by dividing the given numerator and denominator values by their greatest common divisor, computed using the gcd function. Since gcd returns the greatest common divisor of its arguments with sign matching the first argument (den here), after this division the new value of den is guaranteed to be non-negative. Because this is the only inner constructor for OurRational, we can be certain that OurRational objects are always constructed in this normalized form.OurRational also provides several outer constructor methods for convenience. The first is the \"standard\" general constructor that infers the type parameter T from the type of the numerator and denominator when they have the same type. The second applies when the given numerator and denominator values have different types: it promotes them to a common type and then delegates construction to the outer constructor for arguments of matching type. The third outer constructor turns integer values into rationals by supplying a value of 1 as the denominator.Following the outer constructor definitions, we defined a number of methods for the ⊘ operator, which provides a syntax for writing rationals (e.g. 1 ⊘ 2). Julia\'s Rational type uses the // operator for this purpose. Before these definitions, ⊘ is a completely undefined operator with only syntax and no meaning. Afterwards, it behaves just as described in Rational Numbers – its entire behavior is defined in these few lines. The first and most basic definition just makes a ⊘ b construct a OurRational by applying the OurRational constructor to a and b when they are integers. When one of the operands of ⊘ is already a rational number, we construct a new rational for the resulting ratio slightly differently; this behavior is actually identical to division of a rational with an integer. Finally, applying ⊘ to complex integral values creates an instance of Complex{OurRational} – a complex number whose real and imaginary parts are rationals:julia> z = (1 + 2im) ⊘ (1 - 2im);\n\njulia> typeof(z)\nComplex{OurRational{Int64}}\n\njulia> typeof(z) <: Complex{OurRational}\nfalseThus, although the ⊘ operator usually returns an instance of OurRational, if either of its arguments are complex integers, it will return an instance of Complex{OurRational} instead. The interested reader should consider perusing the rest of rational.jl: it is short, self-contained, and implements an entire basic Julia type."
},

{
    "location": "manual/constructors.html#Outer-only-constructors-1",
    "page": "Constructors",
    "title": "Outer-only constructors",
    "category": "section",
    "text": "As we have seen, a typical parametric type has inner constructors that are called when type parameters are known; e.g. they apply to Point{Int} but not to Point. Optionally, outer constructors that determine type parameters automatically can be added, for example constructing a Point{Int} from the call Point(1,2). Outer constructors call inner constructors to actually make instances. However, in some cases one would rather not provide inner constructors, so that specific type parameters cannot be requested manually.For example, say we define a type that stores a vector along with an accurate representation of its sum:julia> struct SummedArray{T<:Number,S<:Number}\n           data::Vector{T}\n           sum::S\n       end\n\njulia> SummedArray(Int32[1; 2; 3], Int32(6))\nSummedArray{Int32,Int32}(Int32[1, 2, 3], 6)The problem is that we want S to be a larger type than T, so that we can sum many elements with less information loss. For example, when T is Int32, we would like S to be Int64. Therefore we want to avoid an interface that allows the user to construct instances of the type SummedArray{Int32,Int32}. One way to do this is to provide a constructor only for SummedArray, but inside the struct definition block to suppress generation of default constructors:julia> struct SummedArray{T<:Number,S<:Number}\n           data::Vector{T}\n           sum::S\n           function SummedArray(a::Vector{T}) where T\n               S = widen(T)\n               new{T,S}(a, sum(S, a))\n           end\n       end\n\njulia> SummedArray(Int32[1; 2; 3], Int32(6))\nERROR: MethodError: no method matching SummedArray(::Array{Int32,1}, ::Int32)\nClosest candidates are:\n  SummedArray(::Array{T,1}) where T at none:5This constructor will be invoked by the syntax SummedArray(a). The syntax new{T,S} allows specifying parameters for the type to be constructed, i.e. this call will return a SummedArray{T,S}. new{T,S} can be used in any constructor definition, but for convenience the parameters to new{} are automatically derived from the type being constructed when possible."
},

{
    "location": "manual/conversion-and-promotion.html#",
    "page": "Conversion and Promotion",
    "title": "Conversion and Promotion",
    "category": "page",
    "text": ""
},

{
    "location": "manual/conversion-and-promotion.html#conversion-and-promotion-1",
    "page": "Conversion and Promotion",
    "title": "Conversion and Promotion",
    "category": "section",
    "text": "Julia has a system for promoting arguments of mathematical operators to a common type, which has been mentioned in various other sections, including Integers and Floating-Point Numbers, Mathematical Operations and Elementary Functions, Types, and Methods. In this section, we explain how this promotion system works, as well as how to extend it to new types and apply it to functions besides built-in mathematical operators. Traditionally, programming languages fall into two camps with respect to promotion of arithmetic arguments:Automatic promotion for built-in arithmetic types and operators. In most languages, built-in numeric types, when used as operands to arithmetic operators with infix syntax, such as +, -, *, and /, are automatically promoted to a common type to produce the expected results. C, Java, Perl, and Python, to name a few, all correctly compute the sum 1 + 1.5 as the floating-point value 2.5, even though one of the operands to + is an integer. These systems are convenient and designed carefully enough that they are generally all-but-invisible to the programmer: hardly anyone consciously thinks of this promotion taking place when writing such an expression, but compilers and interpreters must perform conversion before addition since integers and floating-point values cannot be added as-is. Complex rules for such automatic conversions are thus inevitably part of specifications and implementations for such languages.\nNo automatic promotion. This camp includes Ada and ML – very \"strict\" statically typed languages. In these languages, every conversion must be explicitly specified by the programmer. Thus, the example expression 1 + 1.5 would be a compilation error in both Ada and ML. Instead one must write real(1) + 1.5, explicitly converting the integer 1 to a floating-point value before performing addition. Explicit conversion everywhere is so inconvenient, however, that even Ada has some degree of automatic conversion: integer literals are promoted to the expected integer type automatically, and floating-point literals are similarly promoted to appropriate floating-point types.In a sense, Julia falls into the \"no automatic promotion\" category: mathematical operators are just functions with special syntax, and the arguments of functions are never automatically converted. However, one may observe that applying mathematical operations to a wide variety of mixed argument types is just an extreme case of polymorphic multiple dispatch – something which Julia\'s dispatch and type systems are particularly well-suited to handle. \"Automatic\" promotion of mathematical operands simply emerges as a special application: Julia comes with pre-defined catch-all dispatch rules for mathematical operators, invoked when no specific implementation exists for some combination of operand types. These catch-all rules first promote all operands to a common type using user-definable promotion rules, and then invoke a specialized implementation of the operator in question for the resulting values, now of the same type. User-defined types can easily participate in this promotion system by defining methods for conversion to and from other types, and providing a handful of promotion rules defining what types they should promote to when mixed with other types."
},

{
    "location": "manual/conversion-and-promotion.html#Conversion-1",
    "page": "Conversion and Promotion",
    "title": "Conversion",
    "category": "section",
    "text": "The standard way to obtain a value of a certain type T is to call the type\'s constructor, T(x). However, there are cases where it\'s convenient to convert a value from one type to another without the programmer asking for it explicitly. One example is assigning a value into an array: if A is a Vector{Float64}, the expression A[1] = 2 should work by automatically converting the 2 from Int to Float64, and storing the result in the array. This is done via the convert function.The convert function generally takes two arguments: the first is a type object and the second is a value to convert to that type. The returned value is the value converted to an instance of given type. The simplest way to understand this function is to see it in action:julia> x = 12\n12\n\njulia> typeof(x)\nInt64\n\njulia> convert(UInt8, x)\n0x0c\n\njulia> typeof(ans)\nUInt8\n\njulia> convert(AbstractFloat, x)\n12.0\n\njulia> typeof(ans)\nFloat64\n\njulia> a = Any[1 2 3; 4 5 6]\n2×3 Array{Any,2}:\n 1  2  3\n 4  5  6\n\njulia> convert(Array{Float64}, a)\n2×3 Array{Float64,2}:\n 1.0  2.0  3.0\n 4.0  5.0  6.0Conversion isn\'t always possible, in which case a no method error is thrown indicating that convert doesn\'t know how to perform the requested conversion:julia> convert(AbstractFloat, \"foo\")\nERROR: MethodError: Cannot `convert` an object of type String to an object of type AbstractFloat\n[...]Some languages consider parsing strings as numbers or formatting numbers as strings to be conversions (many dynamic languages will even perform conversion for you automatically), however Julia does not: even though some strings can be parsed as numbers, most strings are not valid representations of numbers, and only a very limited subset of them are. Therefore in Julia the dedicated parse function must be used to perform this operation, making it more explicit."
},

{
    "location": "manual/conversion-and-promotion.html#When-is-convert-called?-1",
    "page": "Conversion and Promotion",
    "title": "When is convert called?",
    "category": "section",
    "text": "The following language constructs call convert:Assigning to an array converts to the array\'s element type.\nAssigning to a field of an object converts to the declared type of the field.\nConstructing an object with new converts to the object\'s declared field types.\nAssigning to a variable with a declared type (e.g. local x::T) converts to that type.\nA function with a declared return type converts its return value to that type.\nPassing a value to ccall converts it to the corresponding argument type."
},

{
    "location": "manual/conversion-and-promotion.html#Conversion-vs.-Construction-1",
    "page": "Conversion and Promotion",
    "title": "Conversion vs. Construction",
    "category": "section",
    "text": "Note that the behavior of convert(T, x) appears to be nearly identical to T(x). Indeed, it usually is. However, there is a key semantic difference: since convert can be called implicitly, its methods are restricted to cases that are considered \"safe\" or \"unsurprising\". convert will only convert between types that represent the same basic kind of thing (e.g. different representations of numbers, or different string encodings). It is also usually lossless; converting a value to a different type and back again should result in the exact same value.There are four general kinds of cases where constructors differ from convert:"
},

{
    "location": "manual/conversion-and-promotion.html#Constructors-for-types-unrelated-to-their-arguments-1",
    "page": "Conversion and Promotion",
    "title": "Constructors for types unrelated to their arguments",
    "category": "section",
    "text": "Some constructors don\'t implement the concept of \"conversion\". For example, Timer(2) creates a 2-second timer, which is not really a \"conversion\" from an integer to a timer."
},

{
    "location": "manual/conversion-and-promotion.html#Mutable-collections-1",
    "page": "Conversion and Promotion",
    "title": "Mutable collections",
    "category": "section",
    "text": "convert(T, x) is expected to return the original x if x is already of type T. In contrast, if T is a mutable collection type then T(x) should always make a new collection (copying elements from x)."
},

{
    "location": "manual/conversion-and-promotion.html#Wrapper-types-1",
    "page": "Conversion and Promotion",
    "title": "Wrapper types",
    "category": "section",
    "text": "For some types which \"wrap\" other values, the constructor may wrap its argument inside a new object even if it is already of the requested type. For example Some(x) wraps x to indicate that a value is present (in a context where the result might be a Some or nothing). However, x itself might be the object Some(y), in which case the result is Some(Some(y)), with two levels of wrapping. convert(Some, x), on the other hand, would just return x since it is already a Some."
},

{
    "location": "manual/conversion-and-promotion.html#Constructors-that-don\'t-return-instances-of-their-own-type-1",
    "page": "Conversion and Promotion",
    "title": "Constructors that don\'t return instances of their own type",
    "category": "section",
    "text": "In very rare cases it might make sense for the constructor T(x) to return an object not of type T. This could happen if a wrapper type is its own inverse (e.g. Flip(Flip(x)) === x), or to support an old calling syntax for backwards compatibility when a library is restructured. But convert(T, x) should always return a value of type T."
},

{
    "location": "manual/conversion-and-promotion.html#Defining-New-Conversions-1",
    "page": "Conversion and Promotion",
    "title": "Defining New Conversions",
    "category": "section",
    "text": "When defining a new type, initially all ways of creating it should be defined as constructors. If it becomes clear that implicit conversion would be useful, and that some constructors meet the above \"safety\" criteria, then convert methods can be added. These methods are typically quite simple, as they only need to call the appropriate constructor. Such a definition might look like this:convert(::Type{MyType}, x) = MyType(x)The type of the first argument of this method is a singleton type, Type{MyType}, the only instance of which is MyType. Thus, this method is only invoked when the first argument is the type value MyType. Notice the syntax used for the first argument: the argument name is omitted prior to the :: symbol, and only the type is given. This is the syntax in Julia for a function argument whose type is specified but whose value does not need to be referenced by name. In this example, since the type is a singleton, we already know its value without referring to an argument name.All instances of some abstract types are by default considered \"sufficiently similar\" that a universal convert definition is provided in Julia Base. For example, this definition states that it\'s valid to convert any Number type to any other by calling a 1-argument constructor:convert(::Type{T}, x::Number) where {T<:Number} = T(x)This means that new Number types only need to define constructors, since this definition will handle convert for them. An identity conversion is also provided to handle the case where the argument is already of the requested type:convert(::Type{T}, x::T) where {T<:Number} = xSimilar definitions exist for AbstractString, AbstractArray, and AbstractDict."
},

{
    "location": "manual/conversion-and-promotion.html#Promotion-1",
    "page": "Conversion and Promotion",
    "title": "Promotion",
    "category": "section",
    "text": "Promotion refers to converting values of mixed types to a single common type. Although it is not strictly necessary, it is generally implied that the common type to which the values are converted can faithfully represent all of the original values. In this sense, the term \"promotion\" is appropriate since the values are converted to a \"greater\" type – i.e. one which can represent all of the input values in a single common type. It is important, however, not to confuse this with object-oriented (structural) super-typing, or Julia\'s notion of abstract super-types: promotion has nothing to do with the type hierarchy, and everything to do with converting between alternate representations. For instance, although every Int32 value can also be represented as a Float64 value, Int32 is not a subtype of Float64.Promotion to a common \"greater\" type is performed in Julia by the promote function, which takes any number of arguments, and returns a tuple of the same number of values, converted to a common type, or throws an exception if promotion is not possible. The most common use case for promotion is to convert numeric arguments to a common type:julia> promote(1, 2.5)\n(1.0, 2.5)\n\njulia> promote(1, 2.5, 3)\n(1.0, 2.5, 3.0)\n\njulia> promote(2, 3//4)\n(2//1, 3//4)\n\njulia> promote(1, 2.5, 3, 3//4)\n(1.0, 2.5, 3.0, 0.75)\n\njulia> promote(1.5, im)\n(1.5 + 0.0im, 0.0 + 1.0im)\n\njulia> promote(1 + 2im, 3//4)\n(1//1 + 2//1*im, 3//4 + 0//1*im)Floating-point values are promoted to the largest of the floating-point argument types. Integer values are promoted to the larger of either the native machine word size or the largest integer argument type. Mixtures of integers and floating-point values are promoted to a floating-point type big enough to hold all the values. Integers mixed with rationals are promoted to rationals. Rationals mixed with floats are promoted to floats. Complex values mixed with real values are promoted to the appropriate kind of complex value.That is really all there is to using promotions. The rest is just a matter of clever application, the most typical \"clever\" application being the definition of catch-all methods for numeric operations like the arithmetic operators +, -, * and /. Here are some of the catch-all method definitions given in promotion.jl:+(x::Number, y::Number) = +(promote(x,y)...)\n-(x::Number, y::Number) = -(promote(x,y)...)\n*(x::Number, y::Number) = *(promote(x,y)...)\n/(x::Number, y::Number) = /(promote(x,y)...)These method definitions say that in the absence of more specific rules for adding, subtracting, multiplying and dividing pairs of numeric values, promote the values to a common type and then try again. That\'s all there is to it: nowhere else does one ever need to worry about promotion to a common numeric type for arithmetic operations – it just happens automatically. There are definitions of catch-all promotion methods for a number of other arithmetic and mathematical functions in promotion.jl, but beyond that, there are hardly any calls to promote required in Julia Base. The most common usages of promote occur in outer constructors methods, provided for convenience, to allow constructor calls with mixed types to delegate to an inner type with fields promoted to an appropriate common type. For example, recall that rational.jl provides the following outer constructor method:Rational(n::Integer, d::Integer) = Rational(promote(n,d)...)This allows calls like the following to work:julia> Rational(Int8(15),Int32(-5))\n-3//1\n\njulia> typeof(ans)\nRational{Int32}For most user-defined types, it is better practice to require programmers to supply the expected types to constructor functions explicitly, but sometimes, especially for numeric problems, it can be convenient to do promotion automatically."
},

{
    "location": "manual/conversion-and-promotion.html#Defining-Promotion-Rules-1",
    "page": "Conversion and Promotion",
    "title": "Defining Promotion Rules",
    "category": "section",
    "text": "Although one could, in principle, define methods for the promote function directly, this would require many redundant definitions for all possible permutations of argument types. Instead, the behavior of promote is defined in terms of an auxiliary function called promote_rule, which one can provide methods for. The promote_rule function takes a pair of type objects and returns another type object, such that instances of the argument types will be promoted to the returned type. Thus, by defining the rule:promote_rule(::Type{Float64}, ::Type{Float32}) = Float64one declares that when 64-bit and 32-bit floating-point values are promoted together, they should be promoted to 64-bit floating-point. The promotion type does not need to be one of the argument types, however; the following promotion rules both occur in Julia Base:promote_rule(::Type{BigInt}, ::Type{Float64}) = BigFloat\npromote_rule(::Type{BigInt}, ::Type{Int8}) = BigIntIn the latter case, the result type is BigInt since BigInt is the only type large enough to hold integers for arbitrary-precision integer arithmetic. Also note that one does not need to define both promote_rule(::Type{A}, ::Type{B}) and promote_rule(::Type{B}, ::Type{A}) – the symmetry is implied by the way promote_rule is used in the promotion process.The promote_rule function is used as a building block to define a second function called promote_type, which, given any number of type objects, returns the common type to which those values, as arguments to promote should be promoted. Thus, if one wants to know, in absence of actual values, what type a collection of values of certain types would promote to, one can use promote_type:julia> promote_type(Int8, Int64)\nInt64Internally, promote_type is used inside of promote to determine what type argument values should be converted to for promotion. It can, however, be useful in its own right. The curious reader can read the code in promotion.jl, which defines the complete promotion mechanism in about 35 lines."
},

{
    "location": "manual/conversion-and-promotion.html#Case-Study:-Rational-Promotions-1",
    "page": "Conversion and Promotion",
    "title": "Case Study: Rational Promotions",
    "category": "section",
    "text": "Finally, we finish off our ongoing case study of Julia\'s rational number type, which makes relatively sophisticated use of the promotion mechanism with the following promotion rules:promote_rule(::Type{Rational{T}}, ::Type{S}) where {T<:Integer,S<:Integer} = Rational{promote_type(T,S)}\npromote_rule(::Type{Rational{T}}, ::Type{Rational{S}}) where {T<:Integer,S<:Integer} = Rational{promote_type(T,S)}\npromote_rule(::Type{Rational{T}}, ::Type{S}) where {T<:Integer,S<:AbstractFloat} = promote_type(T,S)The first rule says that promoting a rational number with any other integer type promotes to a rational type whose numerator/denominator type is the result of promotion of its numerator/denominator type with the other integer type. The second rule applies the same logic to two different types of rational numbers, resulting in a rational of the promotion of their respective numerator/denominator types. The third and final rule dictates that promoting a rational with a float results in the same type as promoting the numerator/denominator type with the float.This small handful of promotion rules, together with the type\'s constructors and the default convert method for numbers, are sufficient to make rational numbers interoperate completely naturally with all of Julia\'s other numeric types – integers, floating-point numbers, and complex numbers. By providing appropriate conversion methods and promotion rules in the same manner, any user-defined numeric type can interoperate just as naturally with Julia\'s predefined numerics."
},

{
    "location": "manual/interfaces.html#",
    "page": "Interfaces",
    "title": "Interfaces",
    "category": "page",
    "text": ""
},

{
    "location": "manual/interfaces.html#Interfaces-1",
    "page": "Interfaces",
    "title": "Interfaces",
    "category": "section",
    "text": "A lot of the power and extensibility in Julia comes from a collection of informal interfaces.  By extending a few specific methods to work for a custom type, objects of that type not only receive those functionalities, but they are also able to be used in other methods that are written to generically build upon those behaviors."
},

{
    "location": "manual/interfaces.html#man-interface-iteration-1",
    "page": "Interfaces",
    "title": "Iteration",
    "category": "section",
    "text": "Required methods  Brief description\niterate(iter)  Returns either a tuple of the first item and initial state or nothing if empty\niterate(iter, state)  Returns either a tuple of the next item and next state or nothing if no items remain\nImportant optional methods Default definition Brief description\nIteratorSize(IterType) HasLength() One of HasLength(), HasShape{N}(), IsInfinite(), or SizeUnknown() as appropriate\nIteratorEltype(IterType) HasEltype() Either EltypeUnknown() or HasEltype() as appropriate\neltype(IterType) Any The type of the first entry of the tuple returned by iterate()\nlength(iter) (undefined) The number of items, if known\nsize(iter, [dim]) (undefined) The number of items in each dimension, if knownValue returned by IteratorSize(IterType) Required Methods\nHasLength() length(iter)\nHasShape{N}() length(iter)  and size(iter, [dim])\nIsInfinite() (none)\nSizeUnknown() (none)Value returned by IteratorEltype(IterType) Required Methods\nHasEltype() eltype(IterType)\nEltypeUnknown() (none)Sequential iteration is implemented by the iterate function. Instead of mutating objects as they are iterated over, Julia iterators may keep track of the iteration state externally from the object. The return value from iterate is always either a tuple of a value and a state, or nothing if no elements remain. The state object will be passed back to the iterate function on the next iteration and is generally considered an implementation detail private to the iterable object.Any object that defines this function is iterable and can be used in the many functions that rely upon iteration. It can also be used directly in a for loop since the syntax:for i in iter   # or  \"for i = iter\"\n    # body\nendis translated into:next = iterate(iter)\nwhile next !== nothing\n    (i, state) = next\n    # body\n    next = iterate(iter, state)\nendA simple example is an iterable sequence of square numbers with a defined length:julia> struct Squares\n           count::Int\n       end\n\njulia> Base.iterate(S::Squares, state=1) = state > S.count ? nothing : (state*state, state+1)With only iterate definition, the Squares type is already pretty powerful. We can iterate over all the elements:julia> for i in Squares(7)\n           println(i)\n       end\n1\n4\n9\n16\n25\n36\n49We can use many of the builtin methods that work with iterables, like in, or mean and std from the Statistics standard library module:julia> 25 in Squares(10)\ntrue\n\njulia> using Statistics\n\njulia> mean(Squares(100))\n3383.5\n\njulia> std(Squares(100))\n3024.355854282583There are a few more methods we can extend to give Julia more information about this iterable collection.  We know that the elements in a Squares sequence will always be Int. By extending the eltype method, we can give that information to Julia and help it make more specialized code in the more complicated methods. We also know the number of elements in our sequence, so we can extend length, too:julia> Base.eltype(::Type{Squares}) = Int # Note that this is defined for the type\n\njulia> Base.length(S::Squares) = S.countNow, when we ask Julia to collect all the elements into an array it can preallocate a Vector{Int} of the right size instead of blindly push!ing each element into a Vector{Any}:julia> collect(Squares(4))\n4-element Array{Int64,1}:\n  1\n  4\n  9\n 16While we can rely upon generic implementations, we can also extend specific methods where we know there is a simpler algorithm. For example, there\'s a formula to compute the sum of squares, so we can override the generic iterative version with a more performant solution:julia> Base.sum(S::Squares) = (n = S.count; return n*(n+1)*(2n+1)÷6)\n\njulia> sum(Squares(1803))\n1955361914This is a very common pattern throughout Julia Base: a small set of required methods define an informal interface that enable many fancier behaviors. In some cases, types will want to additionally specialize those extra behaviors when they know a more efficient algorithm can be used in their specific case.It is also often useful to allow iteration over a collection in reverse order by iterating over Iterators.reverse(iterator).  To actually support reverse-order iteration, however, an iterator type T needs to implement iterate for Iterators.Reverse{T}. (Given r::Iterators.Reverse{T}, the underling iterator of type T is r.itr.) In our Squares example, we would implement Iterators.Reverse{Squares} methods:julia> Base.iterate(rS::Iterators.Reverse{Squares}, state=rS.itr.count) = state < 1 ? nothing : (state*state, state-1)\n\njulia> collect(Iterators.reverse(Squares(4)))\n4-element Array{Int64,1}:\n 16\n  9\n  4\n  1"
},

{
    "location": "manual/interfaces.html#Indexing-1",
    "page": "Interfaces",
    "title": "Indexing",
    "category": "section",
    "text": "Methods to implement Brief description\ngetindex(X, i) X[i], indexed element access\nsetindex!(X, v, i) X[i] = v, indexed assignment\nfirstindex(X) The first index\nlastindex(X) The last index, used in X[end]For the Squares iterable above, we can easily compute the ith element of the sequence by squaring it.  We can expose this as an indexing expression S[i]. To opt into this behavior, Squares simply needs to define getindex:julia> function Base.getindex(S::Squares, i::Int)\n           1 <= i <= S.count || throw(BoundsError(S, i))\n           return i*i\n       end\n\njulia> Squares(100)[23]\n529Additionally, to support the syntax S[end], we must define lastindex to specify the last valid index. It is recommended to also define firstindex to specify the first valid index:julia> Base.firstindex(S::Squares) = 1\n\njulia> Base.lastindex(S::Squares) = length(S)\n\njulia> Squares(23)[end]\n529Note, though, that the above only defines getindex with one integer index. Indexing with anything other than an Int will throw a MethodError saying that there was no matching method. In order to support indexing with ranges or vectors of Ints, separate methods must be written:julia> Base.getindex(S::Squares, i::Number) = S[convert(Int, i)]\n\njulia> Base.getindex(S::Squares, I) = [S[i] for i in I]\n\njulia> Squares(10)[[3,4.,5]]\n3-element Array{Int64,1}:\n  9\n 16\n 25While this is starting to support more of the indexing operations supported by some of the builtin types, there\'s still quite a number of behaviors missing. This Squares sequence is starting to look more and more like a vector as we\'ve added behaviors to it. Instead of defining all these behaviors ourselves, we can officially define it as a subtype of an AbstractArray."
},

{
    "location": "manual/interfaces.html#man-interface-array-1",
    "page": "Interfaces",
    "title": "Abstract Arrays",
    "category": "section",
    "text": "Methods to implement  Brief description\nsize(A)  Returns a tuple containing the dimensions of A\ngetindex(A, i::Int)  (if IndexLinear) Linear scalar indexing\ngetindex(A, I::Vararg{Int, N})  (if IndexCartesian, where N = ndims(A)) N-dimensional scalar indexing\nsetindex!(A, v, i::Int)  (if IndexLinear) Scalar indexed assignment\nsetindex!(A, v, I::Vararg{Int, N})  (if IndexCartesian, where N = ndims(A)) N-dimensional scalar indexed assignment\nOptional methods Default definition Brief description\nIndexStyle(::Type) IndexCartesian() Returns either IndexLinear() or IndexCartesian(). See the description below.\ngetindex(A, I...) defined in terms of scalar getindex Multidimensional and nonscalar indexing\nsetindex!(A, I...) defined in terms of scalar setindex! Multidimensional and nonscalar indexed assignment\niterate defined in terms of scalar getindex Iteration\nlength(A) prod(size(A)) Number of elements\nsimilar(A) similar(A, eltype(A), size(A)) Return a mutable array with the same shape and element type\nsimilar(A, ::Type{S}) similar(A, S, size(A)) Return a mutable array with the same shape and the specified element type\nsimilar(A, dims::Dims) similar(A, eltype(A), dims) Return a mutable array with the same element type and size dims\nsimilar(A, ::Type{S}, dims::Dims) Array{S}(undef, dims) Return a mutable array with the specified element type and size\nNon-traditional indices Default definition Brief description\naxes(A) map(OneTo, size(A)) Return the AbstractUnitRange of valid indices\nsimilar(A, ::Type{S}, inds) similar(A, S, Base.to_shape(inds)) Return a mutable array with the specified indices inds (see below)\nsimilar(T::Union{Type,Function}, inds) T(Base.to_shape(inds)) Return an array similar to T with the specified indices inds (see below)If a type is defined as a subtype of AbstractArray, it inherits a very large set of rich behaviors including iteration and multidimensional indexing built on top of single-element access.  See the arrays manual page and the Julia Base section for more supported methods.A key part in defining an AbstractArray subtype is IndexStyle. Since indexing is such an important part of an array and often occurs in hot loops, it\'s important to make both indexing and indexed assignment as efficient as possible.  Array data structures are typically defined in one of two ways: either it most efficiently accesses its elements using just one index (linear indexing) or it intrinsically accesses the elements with indices specified for every dimension.  These two modalities are identified by Julia as IndexLinear() and IndexCartesian().  Converting a linear index to multiple indexing subscripts is typically very expensive, so this provides a traits-based mechanism to enable efficient generic code for all array types.This distinction determines which scalar indexing methods the type must define. IndexLinear() arrays are simple: just define getindex(A::ArrayType, i::Int).  When the array is subsequently indexed with a multidimensional set of indices, the fallback getindex(A::AbstractArray, I...)() efficiently converts the indices into one linear index and then calls the above method. IndexCartesian() arrays, on the other hand, require methods to be defined for each supported dimensionality with ndims(A) Int indices. For example, SparseMatrixCSC from the SparseArrays standard library module, only supports two dimensions, so it just defines getindex(A::SparseMatrixCSC, i::Int, j::Int). The same holds for setindex!.Returning to the sequence of squares from above, we could instead define it as a subtype of an AbstractArray{Int, 1}:julia> struct SquaresVector <: AbstractArray{Int, 1}\n           count::Int\n       end\n\njulia> Base.size(S::SquaresVector) = (S.count,)\n\njulia> Base.IndexStyle(::Type{<:SquaresVector}) = IndexLinear()\n\njulia> Base.getindex(S::SquaresVector, i::Int) = i*iNote that it\'s very important to specify the two parameters of the AbstractArray; the first defines the eltype, and the second defines the ndims. That supertype and those three methods are all it takes for SquaresVector to be an iterable, indexable, and completely functional array:julia> s = SquaresVector(4)\n4-element SquaresVector:\n  1\n  4\n  9\n 16\n\njulia> s[s .> 8]\n2-element Array{Int64,1}:\n  9\n 16\n\njulia> s + s\n4-element Array{Int64,1}:\n  2\n  8\n 18\n 32\n\njulia> sin.(s)\n4-element Array{Float64,1}:\n  0.8414709848078965\n -0.7568024953079282\n  0.4121184852417566\n -0.2879033166650653As a more complicated example, let\'s define our own toy N-dimensional sparse-like array type built on top of Dict:julia> struct SparseArray{T,N} <: AbstractArray{T,N}\n           data::Dict{NTuple{N,Int}, T}\n           dims::NTuple{N,Int}\n       end\n\njulia> SparseArray(::Type{T}, dims::Int...) where {T} = SparseArray(T, dims);\n\njulia> SparseArray(::Type{T}, dims::NTuple{N,Int}) where {T,N} = SparseArray{T,N}(Dict{NTuple{N,Int}, T}(), dims);\n\njulia> Base.size(A::SparseArray) = A.dims\n\njulia> Base.similar(A::SparseArray, ::Type{T}, dims::Dims) where {T} = SparseArray(T, dims)\n\njulia> Base.getindex(A::SparseArray{T,N}, I::Vararg{Int,N}) where {T,N} = get(A.data, I, zero(T))\n\njulia> Base.setindex!(A::SparseArray{T,N}, v, I::Vararg{Int,N}) where {T,N} = (A.data[I] = v)Notice that this is an IndexCartesian array, so we must manually define getindex and setindex! at the dimensionality of the array. Unlike the SquaresVector, we are able to define setindex!, and so we can mutate the array:julia> A = SparseArray(Float64, 3, 3)\n3×3 SparseArray{Float64,2}:\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n\njulia> fill!(A, 2)\n3×3 SparseArray{Float64,2}:\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n\njulia> A[:] = 1:length(A); A\n3×3 SparseArray{Float64,2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0\n 3.0  6.0  9.0The result of indexing an AbstractArray can itself be an array (for instance when indexing by an AbstractRange). The AbstractArray fallback methods use similar to allocate an Array of the appropriate size and element type, which is filled in using the basic indexing method described above. However, when implementing an array wrapper you often want the result to be wrapped as well:julia> A[1:2,:]\n2×3 SparseArray{Float64,2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0In this example it is accomplished by defining Base.similar{T}(A::SparseArray, ::Type{T}, dims::Dims) to create the appropriate wrapped array. (Note that while similar supports 1- and 2-argument forms, in most case you only need to specialize the 3-argument form.) For this to work it\'s important that SparseArray is mutable (supports setindex!). Defining similar, getindex and setindex! for SparseArray also makes it possible to copy the array:julia> copy(A)\n3×3 SparseArray{Float64,2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0\n 3.0  6.0  9.0In addition to all the iterable and indexable methods from above, these types can also interact with each other and use most of the methods defined in Julia Base for AbstractArrays:julia> A[SquaresVector(3)]\n3-element SparseArray{Float64,1}:\n 1.0\n 4.0\n 9.0\n\njulia> sum(A)\n45.0If you are defining an array type that allows non-traditional indexing (indices that start at something other than 1), you should specialize axes. You should also specialize similar so that the dims argument (ordinarily a Dims size-tuple) can accept AbstractUnitRange objects, perhaps range-types Ind of your own design. For more information, see Arrays with custom indices."
},

{
    "location": "manual/interfaces.html#man-interface-strided-arrays-1",
    "page": "Interfaces",
    "title": "Strided Arrays",
    "category": "section",
    "text": "Methods to implement  Brief description\nstrides(A)  Return the distance in memory (in number of elements) between adjacent elements in each dimension as a tuple. If A is an AbstractArray{T,0}, this should return an empty tuple.\nBase.unsafe_convert(::Type{Ptr{T}}, A)  Return the native address of an array.\nOptional methods Default definition Brief description\nstride(A, i::Int) strides(A)[i] Return the distance in memory (in number of elements) between adjacent elements in dimension k.A strided array is a subtype of AbstractArray whose entries are stored in memory with fixed strides. Provided the element type of the array is compatible with BLAS, a strided array can utilize BLAS and LAPACK routines for more efficient linear algebra routines.  A typical example of a user-defined strided array is one that wraps a standard Array with additional structure.Warning: do not implement these methods if the underlying storage is not actually strided, as it may lead to incorrect results or segmentation faults.Here are some examples to demonstrate which type of arrays are strided and which are not:1:5   # not strided (there is no storage associated with this array.)\nVector(1:5)  # is strided with strides (1,)\nA = [1 5; 2 6; 3 7; 4 8]  # is strided with strides (1,4)\nV = view(A, 1:2, :)   # is strided with strides (1,4)\nV = view(A, 1:2:3, 1:2)   # is strided with strides (2,4)\nV = view(A, [1,2,4], :)   # is not strided, as the spacing between rows is not fixed."
},

{
    "location": "manual/interfaces.html#man-interfaces-broadcasting-1",
    "page": "Interfaces",
    "title": "Customizing broadcasting",
    "category": "section",
    "text": "Methods to implement Brief description\nBase.BroadcastStyle(::Type{SrcType}) = SrcStyle() Broadcasting behavior of SrcType\nBase.similar(bc::Broadcasted{DestStyle}, ::Type{ElType}) Allocation of output container\nOptional methods \nBase.BroadcastStyle(::Style1, ::Style2) = Style12() Precedence rules for mixing styles\nBase.axes(x) Declaration of the indices of x, as per axes(x).\nBase.broadcastable(x) Convert x to an object that has axes and supports indexing\nBypassing default machinery \nBase.copy(bc::Broadcasted{DestStyle}) Custom implementation of broadcast\nBase.copyto!(dest, bc::Broadcasted{DestStyle}) Custom implementation of broadcast!, specializing on DestStyle\nBase.copyto!(dest::DestType, bc::Broadcasted{Nothing}) Custom implementation of broadcast!, specializing on DestType\nBase.Broadcast.broadcasted(f, args...) Override the default lazy behavior within a fused expression\nBase.Broadcast.instantiate(bc::Broadcasted{DestStyle}) Override the computation of the lazy broadcast\'s axesBroadcasting is triggered by an explicit call to broadcast or broadcast!, or implicitly by \"dot\" operations like A .+ b or f.(x, y). Any object that has axes and supports indexing can participate as an argument in broadcasting, and by default the result is stored in an Array. This basic framework is extensible in three major ways:Ensuring that all arguments support broadcast\nSelecting an appropriate output array for the given set of arguments\nSelecting an efficient implementation for the given set of argumentsNot all types support axes and indexing, but many are convenient to allow in broadcast. The Base.broadcastable function is called on each argument to broadcast, allowing it to return something different that supports axes and indexing. By default, this is the identity function for all AbstractArrays and Numbers — they already support axes and indexing. For a handful of other types (including but not limited to types themselves, functions, special singletons like missing and nothing, and dates), Base.broadcastable returns the argument wrapped in a Ref to act as a 0-dimensional \"scalar\" for the purposes of broadcasting. Custom types can similarly specialize Base.broadcastable to define their shape, but they should follow the convention that collect(Base.broadcastable(x)) == collect(x). A notable exception is AbstractString; strings are special-cased to behave as scalars for the purposes of broadcast even though they are iterable collections of their characters (see Strings for more).The next two steps (selecting the output array and implementation) are dependent upon determining a single answer for a given set of arguments. Broadcast must take all the varied types of its arguments and collapse them down to just one output array and one implementation. Broadcast calls this single answer a \"style.\" Every broadcastable object each has its own preferred style, and a promotion-like system is used to combine these styles into a single answer — the \"destination style\"."
},

{
    "location": "manual/interfaces.html#Broadcast-Styles-1",
    "page": "Interfaces",
    "title": "Broadcast Styles",
    "category": "section",
    "text": "Base.BroadcastStyle is the abstract type from which all broadcast styles are derived. When used as a function it has two possible forms, unary (single-argument) and binary. The unary variant states that you intend to implement specific broadcasting behavior and/or output type, and do not wish to rely on the default fallback Broadcast.DefaultArrayStyle.To override these defaults, you can define a custom BroadcastStyle for your object:struct MyStyle <: Broadcast.BroadcastStyle end\nBase.BroadcastStyle(::Type{<:MyType}) = MyStyle()In some cases it might be convenient not to have to define MyStyle, in which case you can leverage one of the general broadcast wrappers:Base.BroadcastStyle(::Type{<:MyType}) = Broadcast.Style{MyType}() can be used for arbitrary types.\nBase.BroadcastStyle(::Type{<:MyType}) = Broadcast.ArrayStyle{MyType}() is preferred if MyType is an AbstractArray.\nFor AbstractArrays that only support a certain dimensionality, create a subtype of Broadcast.AbstractArrayStyle{N} (see below).When your broadcast operation involves several arguments, individual argument styles get combined to determine a single DestStyle that controls the type of the output container. For more details, see below."
},

{
    "location": "manual/interfaces.html#Selecting-an-appropriate-output-array-1",
    "page": "Interfaces",
    "title": "Selecting an appropriate output array",
    "category": "section",
    "text": "The broadcast style is computed for every broadcasting operation to allow for dispatch and specialization. The actual allocation of the result array is handled by similar, using the Broadcasted object as its first argument.Base.similar(bc::Broadcasted{DestStyle}, ::Type{ElType})The fallback definition issimilar(bc::Broadcasted{DefaultArrayStyle{N}}, ::Type{ElType}) where {N,ElType} =\n    similar(Array{ElType}, axes(bc))However, if needed you can specialize on any or all of these arguments. The final argument bc is a lazy representation of a (potentially fused) broadcast operation, a Broadcasted object.  For these purposes, the most important fields of the wrapper are f and args, describing the function and argument list, respectively.  Note that the argument list can — and often does — include other nested Broadcasted wrappers.For a complete example, let\'s say you have created a type, ArrayAndChar, that stores an array and a single character:struct ArrayAndChar{T,N} <: AbstractArray{T,N}\n    data::Array{T,N}\n    char::Char\nend\nBase.size(A::ArrayAndChar) = size(A.data)\nBase.getindex(A::ArrayAndChar{T,N}, inds::Vararg{Int,N}) where {T,N} = A.data[inds...]\nBase.setindex!(A::ArrayAndChar{T,N}, val, inds::Vararg{Int,N}) where {T,N} = A.data[inds...] = val\nBase.showarg(io::IO, A::ArrayAndChar, toplevel) = print(io, typeof(A), \" with char \'\", A.char, \"\'\")You might want broadcasting to preserve the char \"metadata.\" First we defineBase.BroadcastStyle(::Type{<:ArrayAndChar}) = Broadcast.ArrayStyle{ArrayAndChar}()This means we must also define a corresponding similar method:function Base.similar(bc::Broadcast.Broadcasted{Broadcast.ArrayStyle{ArrayAndChar}}, ::Type{ElType}) where ElType\n    # Scan the inputs for the ArrayAndChar:\n    A = find_aac(bc)\n    # Use the char field of A to create the output\n    ArrayAndChar(similar(Array{ElType}, axes(bc)), A.char)\nend\n\n\"`A = find_aac(As)` returns the first ArrayAndChar among the arguments.\"\nfind_aac(bc::Base.Broadcast.Broadcasted) = find_aac(bc.args)\nfind_aac(args::Tuple) = find_aac(find_aac(args[1]), Base.tail(args))\nfind_aac(x) = x\nfind_aac(a::ArrayAndChar, rest) = a\nfind_aac(::Any, rest) = find_aac(rest)From these definitions, one obtains the following behavior:julia> a = ArrayAndChar([1 2; 3 4], \'x\')\n2×2 ArrayAndChar{Int64,2} with char \'x\':\n 1  2\n 3  4\n\njulia> a .+ 1\n2×2 ArrayAndChar{Int64,2} with char \'x\':\n 2  3\n 4  5\n\njulia> a .+ [5,10]\n2×2 ArrayAndChar{Int64,2} with char \'x\':\n  6   7\n 13  14"
},

{
    "location": "manual/interfaces.html#extending-in-place-broadcast-1",
    "page": "Interfaces",
    "title": "Extending broadcast with custom implementations",
    "category": "section",
    "text": "In general, a broadcast operation is represented by a lazy Broadcasted container that holds onto the function to be applied alongside its arguments. Those arguments may themselves be more nested Broadcasted containers, forming a large expression tree to be evaluated. A nested tree of Broadcasted containers is directly constructed by the implicit dot syntax; 5 .+ 2.*x is transiently represented by Broadcasted(+, 5, Broadcasted(*, 2, x)), for example. This is invisible to users as it is immediately realized through a call to copy, but it is this container that provides the basis for broadcast\'s extensibility for authors of custom types. The built-in broadcast machinery will then determine the result type and size based upon the arguments, allocate it, and then finally copy the realization of the Broadcasted object into it with a default copyto!(::AbstractArray, ::Broadcasted) method. The built-in fallback broadcast and broadcast! methods similarly construct a transient Broadcasted representation of the operation so they can follow the same codepath. This allows custom array implementations to provide their own copyto! specialization to customize and optimize broadcasting. This is again determined by the computed broadcast style. This is such an important part of the operation that it is stored as the first type parameter of the Broadcasted type, allowing for dispatch and specialization.For some types, the machinery to \"fuse\" operations across nested levels of broadcasting is not available or could be done more efficiently incrementally. In such cases, you may need or want to evaluate x .* (x .+ 1) as if it had been written broadcast(*, x, broadcast(+, x, 1)), where the inner operation is evaluated before tackling the outer operation. This sort of eager operation is directly supported by a bit of indirection; instead of directly constructing Broadcasted objects, Julia lowers the fused expression x .* (x .+ 1) to Broadcast.broadcasted(*, x, Broadcast.broadcasted(+, x, 1)). Now, by default, broadcasted just calls the Broadcasted constructor to create the lazy representation of the fused expression tree, but you can choose to override it for a particular combination of function and arguments.As an example, the builtin AbstractRange objects use this machinery to optimize pieces of broadcasted expressions that can be eagerly evaluated purely in terms of the start, step, and length (or stop) instead of computing every single element. Just like all the other machinery, broadcasted also computes and exposes the combined broadcast style of its arguments, so instead of specializing on broadcasted(f, args...), you can specialize on broadcasted(::DestStyle, f, args...) for any combination of style, function, and arguments.For example, the following definition supports the negation of ranges:broadcasted(::DefaultArrayStyle{1}, ::typeof(-), r::OrdinalRange) = range(-first(r), step=-step(r), length=length(r))"
},

{
    "location": "manual/interfaces.html#extending-in-place-broadcast-2",
    "page": "Interfaces",
    "title": "Extending in-place broadcasting",
    "category": "section",
    "text": "In-place broadcasting can be supported by defining the appropriate copyto!(dest, bc::Broadcasted) method. Because you might want to specialize either on dest or the specific subtype of bc, to avoid ambiguities between packages we recommend the following convention.If you wish to specialize on a particular style DestStyle, define a method forcopyto!(dest, bc::Broadcasted{DestStyle})Optionally, with this form you can also specialize on the type of dest.If instead you want to specialize on the destination type DestType without specializing on DestStyle, then you should define a method with the following signature:copyto!(dest::DestType, bc::Broadcasted{Nothing})This leverages a fallback implementation of copyto! that converts the wrapper into a Broadcasted{Nothing}. Consequently, specializing on DestType has lower precedence than methods that specialize on DestStyle.Similarly, you can completely override out-of-place broadcasting with a copy(::Broadcasted) method."
},

{
    "location": "manual/interfaces.html#Working-with-Broadcasted-objects-1",
    "page": "Interfaces",
    "title": "Working with Broadcasted objects",
    "category": "section",
    "text": "In order to implement such a copy or copyto!, method, of course, you must work with the Broadcasted wrapper to compute each element. There are two main ways of doing so:Broadcast.flatten recomputes the potentially nested operation into a single function and flat list of arguments. You are responsible for implementing the broadcasting shape rules yourself, but this may be helpful in limited situations.\nIterating over the CartesianIndices of the axes(::Broadcasted) and using indexing with the resulting CartesianIndex object to compute the result."
},

{
    "location": "manual/interfaces.html#writing-binary-broadcasting-rules-1",
    "page": "Interfaces",
    "title": "Writing binary broadcasting rules",
    "category": "section",
    "text": "The precedence rules are defined by binary BroadcastStyle calls:Base.BroadcastStyle(::Style1, ::Style2) = Style12()where Style12 is the BroadcastStyle you want to choose for outputs involving arguments of Style1 and Style2. For example,Base.BroadcastStyle(::Broadcast.Style{Tuple}, ::Broadcast.AbstractArrayStyle{0}) = Broadcast.Style{Tuple}()indicates that Tuple \"wins\" over zero-dimensional arrays (the output container will be a tuple). It is worth noting that you do not need to (and should not) define both argument orders of this call; defining one is sufficient no matter what order the user supplies the arguments in.For AbstractArray types, defining a BroadcastStyle supersedes the fallback choice, Broadcast.DefaultArrayStyle. DefaultArrayStyle and the abstract supertype, AbstractArrayStyle, store the dimensionality as a type parameter to support specialized array types that have fixed dimensionality requirements.DefaultArrayStyle \"loses\" to any other AbstractArrayStyle that has been defined because of the following methods:BroadcastStyle(a::AbstractArrayStyle{Any}, ::DefaultArrayStyle) = a\nBroadcastStyle(a::AbstractArrayStyle{N}, ::DefaultArrayStyle{N}) where N = a\nBroadcastStyle(a::AbstractArrayStyle{M}, ::DefaultArrayStyle{N}) where {M,N} =\n    typeof(a)(_max(Val(M),Val(N)))You do not need to write binary BroadcastStyle rules unless you want to establish precedence for two or more non-DefaultArrayStyle types.If your array type does have fixed dimensionality requirements, then you should subtype AbstractArrayStyle. For example, the sparse array code has the following definitions:struct SparseVecStyle <: Broadcast.AbstractArrayStyle{1} end\nstruct SparseMatStyle <: Broadcast.AbstractArrayStyle{2} end\nBase.BroadcastStyle(::Type{<:SparseVector}) = SparseVecStyle()\nBase.BroadcastStyle(::Type{<:SparseMatrixCSC}) = SparseMatStyle()Whenever you subtype AbstractArrayStyle, you also need to define rules for combining dimensionalities, by creating a constructor for your style that takes a Val(N) argument. For example:SparseVecStyle(::Val{0}) = SparseVecStyle()\nSparseVecStyle(::Val{1}) = SparseVecStyle()\nSparseVecStyle(::Val{2}) = SparseMatStyle()\nSparseVecStyle(::Val{N}) where N = Broadcast.DefaultArrayStyle{N}()These rules indicate that the combination of a SparseVecStyle with 0- or 1-dimensional arrays yields another SparseVecStyle, that its combination with a 2-dimensional array yields a SparseMatStyle, and anything of higher dimensionality falls back to the dense arbitrary-dimensional framework. These rules allow broadcasting to keep the sparse representation for operations that result in one or two dimensional outputs, but produce an Array for any other dimensionality."
},

{
    "location": "manual/modules.html#",
    "page": "Modules",
    "title": "Modules",
    "category": "page",
    "text": ""
},

{
    "location": "manual/modules.html#modules-1",
    "page": "Modules",
    "title": "Modules",
    "category": "section",
    "text": "Modules in Julia are separate variable workspaces, i.e. they introduce a new global scope. They are delimited syntactically, inside module Name ... end. Modules allow you to create top-level definitions (aka global variables) without worrying about name conflicts when your code is used together with somebody else\'s. Within a module, you can control which names from other modules are visible (via importing), and specify which of your names are intended to be public (via exporting).The following example demonstrates the major features of modules. It is not meant to be run, but is shown for illustrative purposes:module MyModule\nusing Lib\n\nusing BigLib: thing1, thing2\n\nimport Base.show\n\nexport MyType, foo\n\nstruct MyType\n    x\nend\n\nbar(x) = 2x\nfoo(a::MyType) = bar(a.x) + 1\n\nshow(io::IO, a::MyType) = print(io, \"MyType $(a.x)\")\nendNote that the style is not to indent the body of the module, since that would typically lead to whole files being indented.This module defines a type MyType, and two functions. Function foo and type MyType are exported, and so will be available for importing into other modules.  Function bar is private to MyModule.The statement using Lib means that a module called Lib will be available for resolving names as needed. When a global variable is encountered that has no definition in the current module, the system will search for it among variables exported by Lib and import it if it is found there. This means that all uses of that global within the current module will resolve to the definition of that variable in Lib.The statement using BigLib: thing1, thing2 brings just the identifiers thing1 and thing2 into scope from module BigLib. If these names refer to functions, adding methods to them will not be allowed (you may only \"use\" them, not extend them).The import keyword supports the same syntax as using, but only operates on a single name at a time. It does not add modules to be searched the way using does. import also differs from using in that functions imported using import can be extended with new methods.In MyModule above we wanted to add a method to the standard show function, so we had to write import Base.show. Functions whose names are only visible via using cannot be extended.Once a variable is made visible via using or import, a module may not create its own variable with the same name. Imported variables are read-only; assigning to a global variable always affects a variable owned by the current module, or else raises an error."
},

{
    "location": "manual/modules.html#Summary-of-module-usage-1",
    "page": "Modules",
    "title": "Summary of module usage",
    "category": "section",
    "text": "To load a module, two main keywords can be used: using and import. To understand their differences, consider the following example:module MyModule\n\nexport x, y\n\nx() = \"x\"\ny() = \"y\"\np() = \"p\"\n\nendIn this module we export the x and y functions (with the keyword export), and also have the non-exported function p. There are several different ways to load the Module and its inner functions into the current workspace:Import Command What is brought into scope Available for method extension\nusing MyModule All exported names (x and y), MyModule.x, MyModule.y and MyModule.p MyModule.x, MyModule.y and MyModule.p\nusing MyModule: x, p x and p \nimport MyModule MyModule.x, MyModule.y and MyModule.p MyModule.x, MyModule.y and MyModule.p\nimport MyModule.x, MyModule.p x and p x and p\nimport MyModule: x, p x and p x and p"
},

{
    "location": "manual/modules.html#Modules-and-files-1",
    "page": "Modules",
    "title": "Modules and files",
    "category": "section",
    "text": "Files and file names are mostly unrelated to modules; modules are associated only with module expressions. One can have multiple files per module, and multiple modules per file:module Foo\n\ninclude(\"file1.jl\")\ninclude(\"file2.jl\")\n\nendIncluding the same code in different modules provides mixin-like behavior. One could use this to run the same code with different base definitions, for example testing code by running it with \"safe\" versions of some operators:module Normal\ninclude(\"mycode.jl\")\nend\n\nmodule Testing\ninclude(\"safe_operators.jl\")\ninclude(\"mycode.jl\")\nend"
},

{
    "location": "manual/modules.html#Standard-modules-1",
    "page": "Modules",
    "title": "Standard modules",
    "category": "section",
    "text": "There are three important standard modules: Main, Core, and Base.Main is the top-level module, and Julia starts with Main set as the current module.  Variables defined at the prompt go in Main, and varinfo() lists variables in Main.Core contains all identifiers considered \"built in\" to the language, i.e. part of the core language and not libraries. Every module implicitly specifies using Core, since you can\'t do anything without those definitions.Base is a module that contains basic functionality (the contents of base/). All modules implicitly contain using Base, since this is needed in the vast majority of cases."
},

{
    "location": "manual/modules.html#Default-top-level-definitions-and-bare-modules-1",
    "page": "Modules",
    "title": "Default top-level definitions and bare modules",
    "category": "section",
    "text": "In addition to using Base, modules also automatically contain definitions of the eval and include functions, which evaluate expressions/files within the global scope of that module.If these default definitions are not wanted, modules can be defined using the keyword baremodule instead (note: Core is still imported, as per above). In terms of baremodule, a standard module looks like this:baremodule Mod\n\nusing Base\n\neval(x) = Core.eval(Mod, x)\ninclude(p) = Base.include(Mod, p)\n\n...\n\nend"
},

{
    "location": "manual/modules.html#Relative-and-absolute-module-paths-1",
    "page": "Modules",
    "title": "Relative and absolute module paths",
    "category": "section",
    "text": "Given the statement using Foo, the system consults an internal table of top-level modules to look for one named Foo. If the module does not exist, the system attempts to require(:Foo), which typically results in loading code from an installed package.However, some modules contain submodules, which means you sometimes need to access a non-top-level module. There are two ways to do this. The first is to use an absolute path, for example using Base.Sort. The second is to use a relative path, which makes it easier to import submodules of the current module or any of its enclosing modules:module Parent\n\nmodule Utils\n...\nend\n\nusing .Utils\n\n...\nendHere module Parent contains a submodule Utils, and code in Parent wants the contents of Utils to be visible. This is done by starting the using path with a period. Adding more leading periods moves up additional levels in the module hierarchy. For example using ..Utils would look for Utils in Parent\'s enclosing module rather than in Parent itself.Note that relative-import qualifiers are only valid in using and import statements."
},

{
    "location": "manual/modules.html#Module-file-paths-1",
    "page": "Modules",
    "title": "Module file paths",
    "category": "section",
    "text": "The global variable LOAD_PATH contains the directories Julia searches for modules when calling require. It can be extended using push!:push!(LOAD_PATH, \"/Path/To/My/Module/\")Putting this statement in the file ~/.julia/config/startup.jl will extend LOAD_PATH on every Julia startup. Alternatively, the module load path can be extended by defining the environment variable JULIA_LOAD_PATH."
},

{
    "location": "manual/modules.html#Namespace-miscellanea-1",
    "page": "Modules",
    "title": "Namespace miscellanea",
    "category": "section",
    "text": "If a name is qualified (e.g. Base.sin), then it can be accessed even if it is not exported. This is often useful when debugging. It can also have methods added to it by using the qualified name as the function name. However, due to syntactic ambiguities that arise, if you wish to add methods to a function in a different module whose name contains only symbols, such as an operator, Base.+ for example, you must use Base.:+ to refer to it. If the operator is more than one character in length you must surround it in brackets, such as: Base.:(==).Macro names are written with @ in import and export statements, e.g. import Mod.@mac. Macros in other modules can be invoked as Mod.@mac or @Mod.mac.The syntax M.x = y does not work to assign a global in another module; global assignment is always module-local.A variable name can be \"reserved\" without assigning to it by declaring it as global x. This prevents name conflicts for globals initialized after load time."
},

{
    "location": "manual/modules.html#Module-initialization-and-precompilation-1",
    "page": "Modules",
    "title": "Module initialization and precompilation",
    "category": "section",
    "text": "Large modules can take several seconds to load because executing all of the statements in a module often involves compiling a large amount of code. Julia creates precompiled caches of the module to reduce this time.The incremental precompiled module file are created and used automatically when using import or using to load a module.  This will cause it to be automatically compiled the first time it is imported. Alternatively, you can manually call Base.compilecache(modulename). The resulting cache files will be stored in DEPOT_PATH[1]/compiled/. Subsequently, the module is automatically recompiled upon using or import whenever any of its dependencies change; dependencies are modules it imports, the Julia build, files it includes, or explicit dependencies declared by include_dependency(path) in the module file(s).For file dependencies, a change is determined by examining whether the modification time (mtime) of each file loaded by include or added explicitly by include_dependency is unchanged, or equal to the modification time truncated to the nearest second (to accommodate systems that can\'t copy mtime with sub-second accuracy). It also takes into account whether the path to the file chosen by the search logic in require matches the path that had created the precompile file. It also takes into account the set of dependencies already loaded into the current process and won\'t recompile those modules, even if their files change or disappear, in order to avoid creating incompatibilities between the running system and the precompile cache.If you know that a module is not safe to precompile your module (for example, for one of the reasons described below), you should put __precompile__(false) in the module file (typically placed at the top). This will cause Base.compilecache to throw an error, and will cause using / import to load it directly into the current process and skip the precompile and caching. This also thereby prevents the module from being imported by any other precompiled module.You may need to be aware of certain behaviors inherent in the creation of incremental shared libraries which may require care when writing your module. For example, external state is not preserved. To accommodate this, explicitly separate any initialization steps that must occur at runtime from steps that can occur at compile time. For this purpose, Julia allows you to define an __init__() function in your module that executes any initialization steps that must occur at runtime. This function will not be called during compilation (--output-*). Effectively, you can assume it will be run exactly once in the lifetime of the code. You may, of course, call it manually if necessary, but the default is to assume this function deals with computing state for the local machine, which does not need to be – or even should not be – captured in the compiled image. It will be called after the module is loaded into a process, including if it is being loaded into an incremental compile (--output-incremental=yes), but not if it is being loaded into a full-compilation process.In particular, if you define a function __init__() in a module, then Julia will call __init__() immediately after the module is loaded (e.g., by import, using, or require) at runtime for the first time (i.e., __init__ is only called once, and only after all statements in the module have been executed). Because it is called after the module is fully imported, any submodules or other imported modules have their __init__ functions called before the __init__ of the enclosing module.Two typical uses of __init__ are calling runtime initialization functions of external C libraries and initializing global constants that involve pointers returned by external libraries.  For example, suppose that we are calling a C library libfoo that requires us to call a foo_init() initialization function at runtime. Suppose that we also want to define a global constant foo_data_ptr that holds the return value of a void *foo_data() function defined by libfoo – this constant must be initialized at runtime (not at compile time) because the pointer address will change from run to run.  You could accomplish this by defining the following __init__ function in your module:const foo_data_ptr = Ref{Ptr{Cvoid}}(0)\nfunction __init__()\n    ccall((:foo_init, :libfoo), Cvoid, ())\n    foo_data_ptr[] = ccall((:foo_data, :libfoo), Ptr{Cvoid}, ())\n    nothing\nendNotice that it is perfectly possible to define a global inside a function like __init__; this is one of the advantages of using a dynamic language. But by making it a constant at global scope, we can ensure that the type is known to the compiler and allow it to generate better optimized code. Obviously, any other globals in your module that depends on foo_data_ptr would also have to be initialized in __init__.Constants involving most Julia objects that are not produced by ccall do not need to be placed in __init__: their definitions can be precompiled and loaded from the cached module image. This includes complicated heap-allocated objects like arrays. However, any routine that returns a raw pointer value must be called at runtime for precompilation to work (Ptr objects will turn into null pointers unless they are hidden inside an isbits object). This includes the return values of the Julia functions cfunction and pointer.Dictionary and set types, or in general anything that depends on the output of a hash(key) method, are a trickier case.  In the common case where the keys are numbers, strings, symbols, ranges, Expr, or compositions of these types (via arrays, tuples, sets, pairs, etc.) they are safe to precompile.  However, for a few other key types, such as Function or DataType and generic user-defined types where you haven\'t defined a hash method, the fallback hash method depends on the memory address of the object (via its objectid) and hence may change from run to run. If you have one of these key types, or if you aren\'t sure, to be safe you can initialize this dictionary from within your __init__ function. Alternatively, you can use the IdDict dictionary type, which is specially handled by precompilation so that it is safe to initialize at compile-time.When using precompilation, it is important to keep a clear sense of the distinction between the compilation phase and the execution phase. In this mode, it will often be much more clearly apparent that Julia is a compiler which allows execution of arbitrary Julia code, not a standalone interpreter that also generates compiled code.Other known potential failure scenarios include:Global counters (for example, for attempting to uniquely identify objects) Consider the following code snippet:\nmutable struct UniquedById\n    myid::Int\n    let counter = 0\n        UniquedById() = new(counter += 1)\n    end\nend\nwhile the intent of this code was to give every instance a unique id, the counter value is recorded at the end of compilation. All subsequent usages of this incrementally compiled module will start from that same counter value.\nNote that objectid (which works by hashing the memory pointer) has similar issues (see notes on Dict usage below).\nOne alternative is to use a macro to capture @__MODULE__ and store it alone with the current counter value, however, it may be better to redesign the code to not depend on this global state.\nAssociative collections (such as Dict and Set) need to be re-hashed in __init__. (In the future, a mechanism may be provided to register an initializer function.)\nDepending on compile-time side-effects persisting through load-time. Example include: modifying arrays or other variables in other Julia modules; maintaining handles to open files or devices; storing pointers to other system resources (including memory);\nCreating accidental \"copies\" of global state from another module, by referencing it directly instead of via its lookup path. For example, (in global scope):\n#mystdout = Base.stdout #= will not work correctly, since this will copy Base.stdout into this module =#\n# instead use accessor functions:\ngetstdout() = Base.stdout #= best option =#\n# or move the assignment into the runtime:\n__init__() = global mystdout = Base.stdout #= also works =#Several additional restrictions are placed on the operations that can be done while precompiling code to help the user avoid other wrong-behavior situations:Calling eval to cause a side-effect in another module. This will also cause a warning to be emitted when the incremental precompile flag is set.\nglobal const statements from local scope after __init__() has been started (see issue #12010 for plans to add an error for this)\nReplacing a module is a runtime error while doing an incremental precompile.A few other points to be aware of:No code reload / cache invalidation is performed after changes are made to the source files themselves, (including by [Pkg.update], and no cleanup is done after [Pkg.rm]\nThe memory sharing behavior of a reshaped array is disregarded by precompilation (each view gets its own copy)\nExpecting the filesystem to be unchanged between compile-time and runtime e.g. @__FILE__/source_path() to find resources at runtime, or the BinDeps @checked_lib macro. Sometimes this is unavoidable. However, when possible, it can be good practice to copy resources into the module at compile-time so they won\'t need to be found at runtime.\nWeakRef objects and finalizers are not currently handled properly by the serializer (this will be fixed in an upcoming release).\nIt is usually best to avoid capturing references to instances of internal metadata objects such as Method, MethodInstance, MethodTable, TypeMapLevel, TypeMapEntry and fields of those objects, as this can confuse the serializer and may not lead to the outcome you desire. It is not necessarily an error to do this, but you simply need to be prepared that the system will try to copy some of these and to create a single unique instance of others.It is sometimes helpful during module development to turn off incremental precompilation. The command line flag --compiled-modules={yes|no} enables you to toggle module precompilation on and off. When Julia is started with --compiled-modules=no the serialized modules in the compile cache are ignored when loading modules and module dependencies. Base.compilecache can still be called manually. The state of this command line flag is passed to Pkg.build to disable automatic precompilation triggering when installing, updating, and explicitly building packages."
},

{
    "location": "manual/documentation.html#",
    "page": "Documentation",
    "title": "Documentation",
    "category": "page",
    "text": ""
},

{
    "location": "manual/documentation.html#Documentation-1",
    "page": "Documentation",
    "title": "Documentation",
    "category": "section",
    "text": "Julia enables package developers and users to document functions, types and other objects easily via a built-in documentation system since Julia 0.4.The basic syntax is simple: any string appearing at the top-level right before an object (function, macro, type or instance) will be interpreted as documenting it (these are called docstrings). Note that no blank lines or comments may intervene between a docstring and the documented object. Here is a basic example:\"Tell whether there are too foo items in the array.\"\nfoo(xs::Array) = ...Documentation is interpreted as Markdown, so you can use indentation and code fences to delimit code examples from text. Technically, any object can be associated with any other as metadata; Markdown happens to be the default, but one can construct other string macros and pass them to the @doc macro just as well.note: Note\nMarkdown support is implemented in the Markdown standard library and for a full list of supported syntax see the documentation.Here is a more complex example, still using Markdown:\"\"\"\n    bar(x[, y])\n\nCompute the Bar index between `x` and `y`. If `y` is missing, compute\nthe Bar index between all pairs of columns of `x`.\n\n# Examples\n```julia-repl\njulia> bar([1, 2], [1, 2])\n1\n```\n\"\"\"\nfunction bar(x, y) ...As in the example above, we recommend following some simple conventions when writing documentation:Always show the signature of a function at the top of the documentation, with a four-space indent so that it is printed as Julia code.\nThis can be identical to the signature present in the Julia code (like mean(x::AbstractArray)), or a simplified form. Optional arguments should be represented with their default values (i.e. f(x, y=1)) when possible, following the actual Julia syntax. Optional arguments which do not have a default value should be put in brackets (i.e. f(x[, y]) and f(x[, y[, z]])). An alternative solution is to use several lines: one without optional arguments, the other(s) with them. This solution can also be used to document several related methods of a given function. When a function accepts many keyword arguments, only include a <keyword arguments> placeholder in the signature (i.e. f(x; <keyword arguments>)), and give the complete list under an # Arguments section (see point 4 below).\nInclude a single one-line sentence describing what the function does or what the object represents after the simplified signature block. If needed, provide more details in a second paragraph, after a blank line.\nThe one-line sentence should use the imperative form (\"Do this\", \"Return that\") instead of the third person (do not write \"Returns the length...\") when documenting functions. It should end with a period. If the meaning of a function cannot be summarized easily, splitting it into separate composable parts could be beneficial (this should not be taken as an absolute requirement for every single case though).\nDo not repeat yourself.\nSince the function name is given by the signature, there is no need to start the documentation with \"The function bar...\": go straight to the point. Similarly, if the signature specifies the types of the arguments, mentioning them in the description is redundant.\nOnly provide an argument list when really necessary.\nFor simple functions, it is often clearer to mention the role of the arguments directly in the description of the function\'s purpose. An argument list would only repeat information already provided elsewhere. However, providing an argument list can be a good idea for complex functions with many arguments (in particular keyword arguments). In that case, insert it after the general description of the function, under an # Arguments header, with one - bullet for each argument. The list should mention the types and default values (if any) of the arguments:\n\"\"\"\n...\n# Arguments\n- `n::Integer`: the number of elements to compute.\n- `dim::Integer=1`: the dimensions along which to perform the computation.\n...\n\"\"\"\nProvide hints to related functions.\nSometimes there are functions of related functionality. To increase discoverability please provide a short list of these in a See also: paragraph.\nSee also: [`bar!`](@ref), [`baz`](@ref), [`baaz`](@ref)\nInclude any code examples in an # Examples section.\nExamples should, whenever possible, be written as doctests. A doctest is a fenced code block (see Code blocks) starting with ```jldoctest and contains any number of julia> prompts together with inputs and expected outputs that mimic the Julia REPL.\nnote: Note\nDoctests are enabled by Documenter.jl. For more detailed documentation see Documenter\'s manual.\nFor example in the following docstring a variable a is defined and the expected result, as printed in a Julia REPL, appears afterwards:\n\"\"\"\nSome nice documentation here.\n\n# Examples\n```jldoctest\njulia> a = [1 2; 3 4]\n2×2 Array{Int64,2}:\n 1  2\n 3  4\n```\n\"\"\"\nwarning: Warning\nCalling rand and other RNG-related functions should be avoided in doctests since they will not produce consistent outputs during different Julia sessions. If you would like to show some random number generation related functionality, one option is to explicitly construct and seed your own MersenneTwister (or other pseudorandom number generator) and pass it to the functions you are doctesting.Operating system word size (Int32 or Int64) as well as path separator differences (/ or \\) will also affect the reproducibility of some doctests.Note that whitespace in your doctest is significant! The doctest will fail if you misalign the output of pretty-printing an array, for example.\nYou can then run make -C doc doctest=true to run all the doctests in the Julia Manual and API documentation, which will ensure that your example works.\nTo indicate that the output result is truncated, you may write [...] at the line where checking should stop. This is useful to hide a stacktrace (which contains non-permanent references to lines of julia code) when the doctest shows that an exception is thrown, for example:\n```jldoctest\njulia> div(1, 0)\nERROR: DivideError: integer division error\n[...]\n```\nExamples that are untestable should be written within fenced code blocks starting with ```julia so that they are highlighted correctly in the generated documentation.\ntip: Tip\nWherever possible examples should be self-contained and runnable so that readers are able to try them out without having to include any dependencies.\nUse backticks to identify code and equations.\nJulia identifiers and code excerpts should always appear between backticks ` to enable highlighting. Equations in the LaTeX syntax can be inserted between double backticks ``. Use Unicode characters rather than their LaTeX escape sequence, i.e. ``α = 1`` rather than ``\\\\alpha = 1``.\nPlace the starting and ending \"\"\" characters on lines by themselves.\nThat is, write:\n\"\"\"\n...\n\n...\n\"\"\"\nf(x, y) = ...\nrather than:\n\"\"\"...\n\n...\"\"\"\nf(x, y) = ...\nThis makes it more clear where docstrings start and end.\nRespect the line length limit used in the surrounding code.\nDocstrings are edited using the same tools as code. Therefore, the same conventions should apply. It is advised to add line breaks after 92 characters.\nProvide information allowing custom types to implement the function in an # Implementation section. These implementation details intended for developers rather than users, explaining e.g. which functions should be overridden and which functions automatically use appropriate fallbacks, are better kept separate from the main description of the function\'s behavior."
},

{
    "location": "manual/documentation.html#Accessing-Documentation-1",
    "page": "Documentation",
    "title": "Accessing Documentation",
    "category": "section",
    "text": "Documentation can be accessed at the REPL or in IJulia by typing ? followed by the name of a function or macro, and pressing Enter. For example,?cos\n?@time\n?r\"\"will bring up docs for the relevant function, macro or string macro respectively. In Juno using Ctrl-J, Ctrl-D will bring up documentation for the object under the cursor."
},

{
    "location": "manual/documentation.html#Functions-and-Methods-1",
    "page": "Documentation",
    "title": "Functions & Methods",
    "category": "section",
    "text": "Functions in Julia may have multiple implementations, known as methods. While it\'s good practice for generic functions to have a single purpose, Julia allows methods to be documented individually if necessary. In general, only the most generic method should be documented, or even the function itself (i.e. the object created without any methods by function bar end). Specific methods should only be documented if their behaviour differs from the more generic ones. In any case, they should not repeat the information provided elsewhere. For example:\"\"\"\n    *(x, y, z...)\n\nMultiplication operator. `x * y * z *...` calls this function with multiple\narguments, i.e. `*(x, y, z...)`.\n\"\"\"\nfunction *(x, y, z...)\n    # ... [implementation sold separately] ...\nend\n\n\"\"\"\n    *(x::AbstractString, y::AbstractString, z::AbstractString...)\n\nWhen applied to strings, concatenates them.\n\"\"\"\nfunction *(x::AbstractString, y::AbstractString, z::AbstractString...)\n    # ... [insert secret sauce here] ...\nend\n\nhelp?> *\nsearch: * .*\n\n  *(x, y, z...)\n\n  Multiplication operator. x * y * z *... calls this function with multiple\n  arguments, i.e. *(x,y,z...).\n\n  *(x::AbstractString, y::AbstractString, z::AbstractString...)\n\n  When applied to strings, concatenates them.When retrieving documentation for a generic function, the metadata for each method is concatenated with the catdoc function, which can of course be overridden for custom types."
},

{
    "location": "manual/documentation.html#Advanced-Usage-1",
    "page": "Documentation",
    "title": "Advanced Usage",
    "category": "section",
    "text": "The @doc macro associates its first argument with its second in a per-module dictionary called META. By default, documentation is expected to be written in Markdown, and the doc\"\" string macro simply creates an object representing the Markdown content. In the future it is likely to do more advanced things such as allowing for relative image or link paths.To make it easier to write documentation, the parser treats the macro name @doc specially: if a call to @doc has one argument, but another expression appears after a single line break, then that additional expression is added as an argument to the macro. Therefore the following syntax is parsed as a 2-argument call to @doc:@doc raw\"\"\"\n...\n\"\"\"\nf(x) = xThis makes it easy to use an arbitrary object (here a raw string) as a docstring.When used for retrieving documentation, the @doc macro (or equally, the doc function) will search all META dictionaries for metadata relevant to the given object and return it. The returned object (some Markdown content, for example) will by default display itself intelligently. This design also makes it easy to use the doc system in a programmatic way; for example, to re-use documentation between different versions of a function:@doc \"...\" foo!\n@doc (@doc foo!) fooOr for use with Julia\'s metaprogramming functionality:for (f, op) in ((:add, :+), (:subtract, :-), (:multiply, :*), (:divide, :/))\n    @eval begin\n        $f(a,b) = $op(a,b)\n    end\nend\n@doc \"`add(a,b)` adds `a` and `b` together\" add\n@doc \"`subtract(a,b)` subtracts `b` from `a`\" subtractDocumentation written in non-toplevel blocks, such as begin, if, for, and let, is added to the documentation system as blocks are evaluated. For example:if condition()\n    \"...\"\n    f(x) = x\nendwill add documentation to f(x) when condition() is true. Note that even if f(x) goes out of scope at the end of the block, its documentation will remain."
},

{
    "location": "manual/documentation.html#Dynamic-documentation-1",
    "page": "Documentation",
    "title": "Dynamic documentation",
    "category": "section",
    "text": "Sometimes the appropriate documentation for an instance of a type depends on the field values of that instance, rather than just on the type itself. In these cases, you can add a method to Docs.getdoc for your custom type that returns the documentation on a per-instance basis. For instance,struct MyType\n    value::String\nend\n\nDocs.getdoc(t::MyType) = \"Documentation for MyType with value $(t.value)\"\n\nx = MyType(\"x\")\ny = MyType(\"y\")?x will display \"Documentation for MyType with value x\" while ?y will display \"Documentation for MyType with value y\"."
},

{
    "location": "manual/documentation.html#Syntax-Guide-1",
    "page": "Documentation",
    "title": "Syntax Guide",
    "category": "section",
    "text": "A comprehensive overview of all documentable Julia syntax.In the following examples \"...\" is used to illustrate an arbitrary docstring.doc\"\" should only be used when the docstring contains $ or \\ characters that should not be parsed by Julia such as LaTeX syntax or Julia source code examples containing interpolation."
},

{
    "location": "manual/documentation.html#Functions-and-Methods-2",
    "page": "Documentation",
    "title": "Functions and Methods",
    "category": "section",
    "text": "\"...\"\nfunction f end\n\n\"...\"\nfAdds docstring \"...\" to the function f. The first version is the preferred syntax, however both are equivalent.\"...\"\nf(x) = x\n\n\"...\"\nfunction f(x)\n    x\nend\n\n\"...\"\nf(x)Adds docstring \"...\" to the method f(::Any).\"...\"\nf(x, y = 1) = x + yAdds docstring \"...\" to two Methods, namely f(::Any) and f(::Any, ::Any)."
},

{
    "location": "manual/documentation.html#Macros-1",
    "page": "Documentation",
    "title": "Macros",
    "category": "section",
    "text": "\"...\"\nmacro m(x) endAdds docstring \"...\" to the @m(::Any) macro definition.\"...\"\n:(@m)Adds docstring \"...\" to the macro named @m."
},

{
    "location": "manual/documentation.html#Types-1",
    "page": "Documentation",
    "title": "Types",
    "category": "section",
    "text": "\"...\"\nabstract type T1 end\n\n\"...\"\nmutable struct T2\n    ...\nend\n\n\"...\"\nstruct T3\n    ...\nendAdds the docstring \"...\" to types T1, T2, and T3.\"...\"\nstruct T\n    \"x\"\n    x\n    \"y\"\n    y\nendAdds docstring \"...\" to type T, \"x\" to field T.x and \"y\" to field T.y. Also applicable to mutable struct types."
},

{
    "location": "manual/documentation.html#Modules-1",
    "page": "Documentation",
    "title": "Modules",
    "category": "section",
    "text": "\"...\"\nmodule M end\n\nmodule M\n\n\"...\"\nM\n\nendAdds docstring \"...\" to the ModuleM. Adding the docstring above the Module is the preferred syntax, however both are equivalent.\"...\"\nbaremodule M\n# ...\nend\n\nbaremodule M\n\nimport Base: @doc\n\n\"...\"\nf(x) = x\n\nendDocumenting a baremodule by placing a docstring above the expression automatically imports @doc into the module. These imports must be done manually when the module expression is not documented. Empty baremodules cannot be documented."
},

{
    "location": "manual/documentation.html#Global-Variables-1",
    "page": "Documentation",
    "title": "Global Variables",
    "category": "section",
    "text": "\"...\"\nconst a = 1\n\n\"...\"\nb = 2\n\n\"...\"\nglobal c = 3Adds docstring \"...\" to the Bindings a, b, and c.Bindings are used to store a reference to a particular Symbol in a Module without storing the referenced value itself.note: Note\nWhen a const definition is only used to define an alias of another definition, such as is the case with the function div and its alias ÷ in Base, do not document the alias and instead document the actual function.If the alias is documented and not the real definition then the docsystem (? mode) will not return the docstring attached to the alias when the real definition is searched for.For example you should write\"...\"\nf(x) = x + 1\nconst alias = frather thanf(x) = x + 1\n\"...\"\nconst alias = f\"...\"\nsymAdds docstring \"...\" to the value associated with sym. Users should prefer documenting sym at its definition."
},

{
    "location": "manual/documentation.html#Multiple-Objects-1",
    "page": "Documentation",
    "title": "Multiple Objects",
    "category": "section",
    "text": "\"...\"\na, bAdds docstring \"...\" to a and b each of which should be a documentable expression. This syntax is equivalent to\"...\"\na\n\n\"...\"\nbAny number of expressions many be documented together in this way. This syntax can be useful when two functions are related, such as non-mutating and mutating versions f and f!."
},

{
    "location": "manual/documentation.html#Core.@__doc__",
    "page": "Documentation",
    "title": "Core.@__doc__",
    "category": "macro",
    "text": "@__doc__(ex)\n\nLow-level macro used to mark expressions returned by a macro that should be documented. If more than one expression is marked then the same docstring is applied to each expression.\n\nmacro example(f)\n    quote\n        $(f)() = 0\n        @__doc__ $(f)(x) = 1\n        $(f)(x, y) = 2\n    end |> esc\nend\n\n@__doc__ has no effect when a macro that uses it is not documented.\n\n\n\n\n\n"
},

{
    "location": "manual/documentation.html#Macro-generated-code-1",
    "page": "Documentation",
    "title": "Macro-generated code",
    "category": "section",
    "text": "\"...\"\n@m expressionAdds docstring \"...\" to expression generated by expanding @m expression. This allows for expressions decorated with @inline, @noinline, @generated, or any other macro to be documented in the same way as undecorated expressions.Macro authors should take note that only macros that generate a single expression will automatically support docstrings. If a macro returns a block containing multiple subexpressions then the subexpression that should be documented must be marked using the @__doc__ macro.The @enum macro makes use of @__doc__ to allow for documenting Enums. Examining its definition should serve as an example of how to use @__doc__ correctly.Core.@__doc__"
},

{
    "location": "manual/metaprogramming.html#",
    "page": "Metaprogramming",
    "title": "Metaprogramming",
    "category": "page",
    "text": ""
},

{
    "location": "manual/metaprogramming.html#Metaprogramming-1",
    "page": "Metaprogramming",
    "title": "Metaprogramming",
    "category": "section",
    "text": "The strongest legacy of Lisp in the Julia language is its metaprogramming support. Like Lisp, Julia represents its own code as a data structure of the language itself. Since code is represented by objects that can be created and manipulated from within the language, it is possible for a program to transform and generate its own code. This allows sophisticated code generation without extra build steps, and also allows true Lisp-style macros operating at the level of abstract syntax trees. In contrast, preprocessor \"macro\" systems, like that of C and C++, perform textual manipulation and substitution before any actual parsing or interpretation occurs. Because all data types and code in Julia are represented by Julia data structures, powerful reflection capabilities are available to explore the internals of a program and its types just like any other data."
},

{
    "location": "manual/metaprogramming.html#Program-representation-1",
    "page": "Metaprogramming",
    "title": "Program representation",
    "category": "section",
    "text": "Every Julia program starts life as a string:julia> prog = \"1 + 1\"\n\"1 + 1\"What happens next?The next step is to parse each string into an object called an expression, represented by the Julia type Expr:julia> ex1 = Meta.parse(prog)\n:(1 + 1)\n\njulia> typeof(ex1)\nExprExpr objects contain two parts:a Symbol identifying the kind of expression. A symbol is an interned string identifier (more discussion below).julia> ex1.head\n:callthe expression arguments, which may be symbols, other expressions, or literal values:julia> ex1.args\n3-element Array{Any,1}:\n  :+\n 1\n 1Expressions may also be constructed directly in prefix notation:julia> ex2 = Expr(:call, :+, 1, 1)\n:(1 + 1)The two expressions constructed above – by parsing and by direct construction – are equivalent:julia> ex1 == ex2\ntrueThe key point here is that Julia code is internally represented as a data structure that is accessible from the language itself.The dump function provides indented and annotated display of Expr objects:julia> dump(ex2)\nExpr\n  head: Symbol call\n  args: Array{Any}((3,))\n    1: Symbol +\n    2: Int64 1\n    3: Int64 1Expr objects may also be nested:julia> ex3 = Meta.parse(\"(4 + 4) / 2\")\n:((4 + 4) / 2)Another way to view expressions is with Meta.show_sexpr, which displays the S-expression form of a given Expr, which may look very familiar to users of Lisp. Here\'s an example illustrating the display on a nested Expr:julia> Meta.show_sexpr(ex3)\n(:call, :/, (:call, :+, 4, 4), 2)"
},

{
    "location": "manual/metaprogramming.html#Symbols-1",
    "page": "Metaprogramming",
    "title": "Symbols",
    "category": "section",
    "text": "The : character has two syntactic purposes in Julia. The first form creates a Symbol, an interned string used as one building-block of expressions:julia> :foo\n:foo\n\njulia> typeof(ans)\nSymbolThe Symbol constructor takes any number of arguments and creates a new symbol by concatenating their string representations together:julia> :foo == Symbol(\"foo\")\ntrue\n\njulia> Symbol(\"func\",10)\n:func10\n\njulia> Symbol(:var,\'_\',\"sym\")\n:var_symIn the context of an expression, symbols are used to indicate access to variables; when an expression is evaluated, a symbol is replaced with the value bound to that symbol in the appropriate scope.Sometimes extra parentheses around the argument to : are needed to avoid ambiguity in parsing.:julia> :(:)\n:(:)\n\njulia> :(::)\n:(::)"
},

{
    "location": "manual/metaprogramming.html#Expressions-and-evaluation-1",
    "page": "Metaprogramming",
    "title": "Expressions and evaluation",
    "category": "section",
    "text": ""
},

{
    "location": "manual/metaprogramming.html#Quoting-1",
    "page": "Metaprogramming",
    "title": "Quoting",
    "category": "section",
    "text": "The second syntactic purpose of the : character is to create expression objects without using the explicit Expr constructor. This is referred to as quoting. The : character, followed by paired parentheses around a single statement of Julia code, produces an Expr object based on the enclosed code. Here is example of the short form used to quote an arithmetic expression:julia> ex = :(a+b*c+1)\n:(a + b * c + 1)\n\njulia> typeof(ex)\nExpr(to view the structure of this expression, try ex.head and ex.args, or use dump as above or Meta.@dump)Note that equivalent expressions may be constructed using Meta.parse or the direct Expr form:julia>      :(a + b*c + 1)       ==\n       Meta.parse(\"a + b*c + 1\") ==\n       Expr(:call, :+, :a, Expr(:call, :*, :b, :c), 1)\ntrueExpressions provided by the parser generally only have symbols, other expressions, and literal values as their args, whereas expressions constructed by Julia code can have arbitrary run-time values without literal forms as args. In this specific example, + and a are symbols, *(b,c) is a subexpression, and 1 is a literal 64-bit signed integer.There is a second syntactic form of quoting for multiple expressions: blocks of code enclosed in quote ... end.julia> ex = quote\n           x = 1\n           y = 2\n           x + y\n       end\nquote\n    #= none:2 =#\n    x = 1\n    #= none:3 =#\n    y = 2\n    #= none:4 =#\n    x + y\nend\n\njulia> typeof(ex)\nExpr"
},

{
    "location": "manual/metaprogramming.html#Interpolation-1",
    "page": "Metaprogramming",
    "title": "Interpolation",
    "category": "section",
    "text": "Direct construction of Expr objects with value arguments is powerful, but Expr constructors can be tedious compared to \"normal\" Julia syntax. As an alternative, Julia allows interpolation of literals or expressions into quoted expressions. Interpolation is indicated by a prefix $.In this example, the value of variable a is interpolated:julia> a = 1;\n\njulia> ex = :($a + b)\n:(1 + b)Interpolating into an unquoted expression is not supported and will cause a compile-time error:julia> $a + b\nERROR: syntax: \"$\" expression outside quoteIn this example, the tuple (1,2,3) is interpolated as an expression into a conditional test:julia> ex = :(a in $:((1,2,3)) )\n:(a in (1, 2, 3))The use of $ for expression interpolation is intentionally reminiscent of string interpolation and command interpolation. Expression interpolation allows convenient, readable programmatic construction of complex Julia expressions."
},

{
    "location": "manual/metaprogramming.html#Splatting-interpolation-1",
    "page": "Metaprogramming",
    "title": "Splatting interpolation",
    "category": "section",
    "text": "Notice that the $ interpolation syntax allows inserting only a single expression into an enclosing expression. Occasionally, you have an array of expressions and need them all to become arguments of the surrounding expression. This can be done with the syntax $(xs...). For example, the following code generates a function call where the number of arguments is determined programmatically:julia> args = [:x, :y, :z];\n\njulia> :(f(1, $(args...)))\n:(f(1, x, y, z))"
},

{
    "location": "manual/metaprogramming.html#Nested-quote-1",
    "page": "Metaprogramming",
    "title": "Nested quote",
    "category": "section",
    "text": "Naturally, it is possible for quote expressions to contain other quote expressions. Understanding how interpolation works in these cases can be a bit tricky. Consider this example:julia> x = :(1 + 2);\n\njulia> e = quote quote $x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :x))\nend))\nendNotice that the result contains Expr(:$, :x), which means that x has not been evaluated yet. In other words, the $ expression \"belongs to\" the inner quote expression, and so its argument is only evaluated when the inner quote expression is:julia> eval(e)\nquote\n    #= none:1 =#\n    1 + 2\nendHowever, the outer quote expression is able to interpolate values inside the $ in the inner quote. This is done with multiple $s:julia> e = quote quote $$x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :(1 + 2)))\nend))\nendNotice that :(1 + 2) now appears in the result instead of the symbol :x. Evaluating this expression yields an interpolated 3:julia> eval(e)\nquote\n    #= none:1 =#\n    3\nendThe intuition behind this behavior is that x is evaluated once for each $: one $ works similarly to eval(:x), giving x\'s value, while two $s do the equivalent of eval(eval(:x))."
},

{
    "location": "manual/metaprogramming.html#QuoteNode-1",
    "page": "Metaprogramming",
    "title": "QuoteNode",
    "category": "section",
    "text": "The usual representation of a quote form in an AST is an Expr with head :quote:julia> dump(Meta.parse(\":(1+2)\"))\nExpr\n  head: Symbol quote\n  args: Array{Any}((1,))\n    1: Expr\n      head: Symbol call\n      args: Array{Any}((3,))\n        1: Symbol +\n        2: Int64 1\n        3: Int64 2As we have seen, such expressions support interpolation with $. However, in some situations it is necessary to quote code without performing interpolation. This kind of quoting does not yet have syntax, but is represented internally as an object of type QuoteNode. The parser yields QuoteNodes for simple quoted items like symbols:julia> dump(Meta.parse(\":x\"))\nQuoteNode\n  value: Symbol xQuoteNode can also be used for certain advanced metaprogramming tasks."
},

{
    "location": "manual/metaprogramming.html#[eval](@ref)-and-effects-1",
    "page": "Metaprogramming",
    "title": "eval and effects",
    "category": "section",
    "text": "Given an expression object, one can cause Julia to evaluate (execute) it at global scope using eval:julia> :(1 + 2)\n:(1 + 2)\n\njulia> eval(ans)\n3\n\njulia> ex = :(a + b)\n:(a + b)\n\njulia> eval(ex)\nERROR: UndefVarError: b not defined\n[...]\n\njulia> a = 1; b = 2;\n\njulia> eval(ex)\n3Every module has its own eval function that evaluates expressions in its global scope. Expressions passed to eval are not limited to returning values – they can also have side-effects that alter the state of the enclosing module\'s environment:julia> ex = :(x = 1)\n:(x = 1)\n\njulia> x\nERROR: UndefVarError: x not defined\n\njulia> eval(ex)\n1\n\njulia> x\n1Here, the evaluation of an expression object causes a value to be assigned to the global variable x.Since expressions are just Expr objects which can be constructed programmatically and then evaluated, it is possible to dynamically generate arbitrary code which can then be run using eval. Here is a simple example:julia> a = 1;\n\njulia> ex = Expr(:call, :+, a, :b)\n:(1 + b)\n\njulia> a = 0; b = 2;\n\njulia> eval(ex)\n3The value of a is used to construct the expression ex which applies the + function to the value 1 and the variable b. Note the important distinction between the way a and b are used:The value of the variable a at expression construction time is used as an immediate value in the expression. Thus, the value of a when the expression is evaluated no longer matters: the value in the expression is already 1, independent of whatever the value of a might be.\nOn the other hand, the symbol :b is used in the expression construction, so the value of the variable b at that time is irrelevant – :b is just a symbol and the variable b need not even be defined. At expression evaluation time, however, the value of the symbol :b is resolved by looking up the value of the variable b."
},

{
    "location": "manual/metaprogramming.html#Functions-on-Expressions-1",
    "page": "Metaprogramming",
    "title": "Functions on Expressions",
    "category": "section",
    "text": "As hinted above, one extremely useful feature of Julia is the capability to generate and manipulate Julia code within Julia itself. We have already seen one example of a function returning Expr objects: the parse function, which takes a string of Julia code and returns the corresponding Expr. A function can also take one or more Expr objects as arguments, and return another Expr. Here is a simple, motivating example:julia> function math_expr(op, op1, op2)\n           expr = Expr(:call, op, op1, op2)\n           return expr\n       end\nmath_expr (generic function with 1 method)\n\njulia>  ex = math_expr(:+, 1, Expr(:call, :*, 4, 5))\n:(1 + 4 * 5)\n\njulia> eval(ex)\n21As another example, here is a function that doubles any numeric argument, but leaves expressions alone:julia> function make_expr2(op, opr1, opr2)\n           opr1f, opr2f = map(x -> isa(x, Number) ? 2*x : x, (opr1, opr2))\n           retexpr = Expr(:call, op, opr1f, opr2f)\n           return retexpr\n       end\nmake_expr2 (generic function with 1 method)\n\njulia> make_expr2(:+, 1, 2)\n:(2 + 4)\n\njulia> ex = make_expr2(:+, 1, Expr(:call, :*, 5, 8))\n:(2 + 5 * 8)\n\njulia> eval(ex)\n42"
},

{
    "location": "manual/metaprogramming.html#man-macros-1",
    "page": "Metaprogramming",
    "title": "Macros",
    "category": "section",
    "text": "Macros provide a method to include generated code in the final body of a program. A macro maps a tuple of arguments to a returned expression, and the resulting expression is compiled directly rather than requiring a runtime eval call. Macro arguments may include expressions, literal values, and symbols."
},

{
    "location": "manual/metaprogramming.html#Basics-1",
    "page": "Metaprogramming",
    "title": "Basics",
    "category": "section",
    "text": "Here is an extraordinarily simple macro:julia> macro sayhello()\n           return :( println(\"Hello, world!\") )\n       end\n@sayhello (macro with 1 method)Macros have a dedicated character in Julia\'s syntax: the @ (at-sign), followed by the unique name declared in a macro NAME ... end block. In this example, the compiler will replace all instances of @sayhello with::( println(\"Hello, world!\") )When @sayhello is entered in the REPL, the expression executes immediately, thus we only see the evaluation result:julia> @sayhello()\nHello, world!Now, consider a slightly more complex macro:julia> macro sayhello(name)\n           return :( println(\"Hello, \", $name) )\n       end\n@sayhello (macro with 1 method)This macro takes one argument: name. When @sayhello is encountered, the quoted expression is expanded to interpolate the value of the argument into the final expression:julia> @sayhello(\"human\")\nHello, humanWe can view the quoted return expression using the function macroexpand (important note: this is an extremely useful tool for debugging macros):julia> ex = macroexpand(Main, :(@sayhello(\"human\")) )\n:((Main.println)(\"Hello, \", \"human\"))\n\njulia> typeof(ex)\nExprWe can see that the \"human\" literal has been interpolated into the expression.There also exists a macro @macroexpand that is perhaps a bit more convenient than the macroexpand function:julia> @macroexpand @sayhello \"human\"\n:((println)(\"Hello, \", \"human\"))"
},

{
    "location": "manual/metaprogramming.html#Hold-up:-why-macros?-1",
    "page": "Metaprogramming",
    "title": "Hold up: why macros?",
    "category": "section",
    "text": "We have already seen a function f(::Expr...) -> Expr in a previous section. In fact, macroexpand is also such a function. So, why do macros exist?Macros are necessary because they execute when code is parsed, therefore, macros allow the programmer to generate and include fragments of customized code before the full program is run. To illustrate the difference, consider the following example:julia> macro twostep(arg)\n           println(\"I execute at parse time. The argument is: \", arg)\n           return :(println(\"I execute at runtime. The argument is: \", $arg))\n       end\n@twostep (macro with 1 method)\n\njulia> ex = macroexpand(Main, :(@twostep :(1, 2, 3)) );\nI execute at parse time. The argument is: $(Expr(:quote, :((1, 2, 3))))The first call to println is executed when macroexpand is called. The resulting expression contains only the second println:julia> typeof(ex)\nExpr\n\njulia> ex\n:((println)(\"I execute at runtime. The argument is: \", $(Expr(:copyast, :($(QuoteNode(:((1, 2, 3)))))))))\n\njulia> eval(ex)\nI execute at runtime. The argument is: (1, 2, 3)"
},

{
    "location": "manual/metaprogramming.html#Macro-invocation-1",
    "page": "Metaprogramming",
    "title": "Macro invocation",
    "category": "section",
    "text": "Macros are invoked with the following general syntax:@name expr1 expr2 ...\n@name(expr1, expr2, ...)Note the distinguishing @ before the macro name and the lack of commas between the argument expressions in the first form, and the lack of whitespace after @name in the second form. The two styles should not be mixed. For example, the following syntax is different from the examples above; it passes the tuple (expr1, expr2, ...) as one argument to the macro:@name (expr1, expr2, ...)An alternative way to invoke a macro over an array literal (or comprehension) is to juxtapose both without using parentheses. In this case, the array will be the only expression fed to the macro. The following syntax is equivalent (and different from @name [a b] * v):@name[a b] * v\n@name([a b]) * vIt is important to emphasize that macros receive their arguments as expressions, literals, or symbols. One way to explore macro arguments is to call the show function within the macro body:julia> macro showarg(x)\n           show(x)\n           # ... remainder of macro, returning an expression\n       end\n@showarg (macro with 1 method)\n\njulia> @showarg(a)\n:a\n\njulia> @showarg(1+1)\n:(1 + 1)\n\njulia> @showarg(println(\"Yo!\"))\n:(println(\"Yo!\"))In addition to the given argument list, every macro is passed extra arguments named __source__ and __module__.The argument __source__ provides information (in the form of a LineNumberNode object) about the parser location of the @ sign from the macro invocation. This allows macros to include better error diagnostic information, and is commonly used by logging, string-parser macros, and docs, for example, as well as to implement the @__LINE__, @__FILE__, and @__DIR__ macros.The location information can be accessed by referencing __source__.line and __source__.file:julia> macro __LOCATION__(); return QuoteNode(__source__); end\n@__LOCATION__ (macro with 1 method)\n\njulia> dump(\n            @__LOCATION__(\n       ))\nLineNumberNode\n  line: Int64 2\n  file: Symbol noneThe argument __module__ provides information (in the form of a Module object) about the expansion context of the macro invocation. This allows macros to look up contextual information, such as existing bindings, or to insert the value as an extra argument to a runtime function call doing self-reflection in the current module."
},

{
    "location": "manual/metaprogramming.html#Building-an-advanced-macro-1",
    "page": "Metaprogramming",
    "title": "Building an advanced macro",
    "category": "section",
    "text": "Here is a simplified definition of Julia\'s @assert macro:julia> macro assert(ex)\n           return :( $ex ? nothing : throw(AssertionError($(string(ex)))) )\n       end\n@assert (macro with 1 method)This macro can be used like this:julia> @assert 1 == 1.0\n\njulia> @assert 1 == 0\nERROR: AssertionError: 1 == 0In place of the written syntax, the macro call is expanded at parse time to its returned result. This is equivalent to writing:1 == 1.0 ? nothing : throw(AssertionError(\"1 == 1.0\"))\n1 == 0 ? nothing : throw(AssertionError(\"1 == 0\"))That is, in the first call, the expression :(1 == 1.0) is spliced into the test condition slot, while the value of string(:(1 == 1.0)) is spliced into the assertion message slot. The entire expression, thus constructed, is placed into the syntax tree where the @assert macro call occurs. Then at execution time, if the test expression evaluates to true, then nothing is returned, whereas if the test is false, an error is raised indicating the asserted expression that was false. Notice that it would not be possible to write this as a function, since only the value of the condition is available and it would be impossible to display the expression that computed it in the error message.The actual definition of @assert in Julia Base is more complicated. It allows the user to optionally specify their own error message, instead of just printing the failed expression. Just like in functions with a variable number of arguments, this is specified with an ellipses following the last argument:julia> macro assert(ex, msgs...)\n           msg_body = isempty(msgs) ? ex : msgs[1]\n           msg = string(msg_body)\n           return :($ex ? nothing : throw(AssertionError($msg)))\n       end\n@assert (macro with 1 method)Now @assert has two modes of operation, depending upon the number of arguments it receives! If there\'s only one argument, the tuple of expressions captured by msgs will be empty and it will behave the same as the simpler definition above. But now if the user specifies a second argument, it is printed in the message body instead of the failing expression. You can inspect the result of a macro expansion with the aptly named @macroexpand macro:julia> @macroexpand @assert a == b\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        (Main.throw)((Main.AssertionError)(\"a == b\"))\n    end)\n\njulia> @macroexpand @assert a==b \"a should equal b!\"\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        (Main.throw)((Main.AssertionError)(\"a should equal b!\"))\n    end)There is yet another case that the actual @assert macro handles: what if, in addition to printing \"a should equal b,\" we wanted to print their values? One might naively try to use string interpolation in the custom message, e.g., @assert a==b \"a ($a) should equal b ($b)!\", but this won\'t work as expected with the above macro. Can you see why? Recall from string interpolation that an interpolated string is rewritten to a call to string. Compare:julia> typeof(:(\"a should equal b\"))\nString\n\njulia> typeof(:(\"a ($a) should equal b ($b)!\"))\nExpr\n\njulia> dump(:(\"a ($a) should equal b ($b)!\"))\nExpr\n  head: Symbol string\n  args: Array{Any}((5,))\n    1: String \"a (\"\n    2: Symbol a\n    3: String \") should equal b (\"\n    4: Symbol b\n    5: String \")!\"So now instead of getting a plain string in msg_body, the macro is receiving a full expression that will need to be evaluated in order to display as expected. This can be spliced directly into the returned expression as an argument to the string call; see error.jl for the complete implementation.The @assert macro makes great use of splicing into quoted expressions to simplify the manipulation of expressions inside the macro body."
},

{
    "location": "manual/metaprogramming.html#Hygiene-1",
    "page": "Metaprogramming",
    "title": "Hygiene",
    "category": "section",
    "text": "An issue that arises in more complex macros is that of hygiene. In short, macros must ensure that the variables they introduce in their returned expressions do not accidentally clash with existing variables in the surrounding code they expand into. Conversely, the expressions that are passed into a macro as arguments are often expected to evaluate in the context of the surrounding code, interacting with and modifying the existing variables. Another concern arises from the fact that a macro may be called in a different module from where it was defined. In this case we need to ensure that all global variables are resolved to the correct module. Julia already has a major advantage over languages with textual macro expansion (like C) in that it only needs to consider the returned expression. All the other variables (such as msg in @assert above) follow the normal scoping block behavior.To demonstrate these issues, let us consider writing a @time macro that takes an expression as its argument, records the time, evaluates the expression, records the time again, prints the difference between the before and after times, and then has the value of the expression as its final value. The macro might look like this:macro time(ex)\n    return quote\n        local t0 = time()\n        local val = $ex\n        local t1 = time()\n        println(\"elapsed time: \", t1-t0, \" seconds\")\n        val\n    end\nendHere, we want t0, t1, and val to be private temporary variables, and we want time to refer to the time function in Julia Base, not to any time variable the user might have (the same applies to println). Imagine the problems that could occur if the user expression ex also contained assignments to a variable called t0, or defined its own time variable. We might get errors, or mysteriously incorrect behavior.Julia\'s macro expander solves these problems in the following way. First, variables within a macro result are classified as either local or global. A variable is considered local if it is assigned to (and not declared global), declared local, or used as a function argument name. Otherwise, it is considered global. Local variables are then renamed to be unique (using the gensym function, which generates new symbols), and global variables are resolved within the macro definition environment. Therefore both of the above concerns are handled; the macro\'s locals will not conflict with any user variables, and time and println will refer to the Julia Base definitions.One problem remains however. Consider the following use of this macro:module MyModule\nimport Base.@time\n\ntime() = ... # compute something\n\n@time time()\nendHere the user expression ex is a call to time, but not the same time function that the macro uses. It clearly refers to MyModule.time. Therefore we must arrange for the code in ex to be resolved in the macro call environment. This is done by \"escaping\" the expression with esc:macro time(ex)\n    ...\n    local val = $(esc(ex))\n    ...\nendAn expression wrapped in this manner is left alone by the macro expander and simply pasted into the output verbatim. Therefore it will be resolved in the macro call environment.This escaping mechanism can be used to \"violate\" hygiene when necessary, in order to introduce or manipulate user variables. For example, the following macro sets x to zero in the call environment:julia> macro zerox()\n           return esc(:(x = 0))\n       end\n@zerox (macro with 1 method)\n\njulia> function foo()\n           x = 1\n           @zerox\n           return x # is zero\n       end\nfoo (generic function with 1 method)\n\njulia> foo()\n0This kind of manipulation of variables should be used judiciously, but is occasionally quite handy.Getting the hygiene rules correct can be a formidable challenge. Before using a macro, you might want to consider whether a function closure would be sufficient. Another useful strategy is to defer as much work as possible to runtime. For example, many macros simply wrap their arguments in a QuoteNode or other similar Expr. Some examples of this include @task body which simply returns schedule(Task(() -> $body)), and @eval expr, which simply returns eval(QuoteNode(expr)).To demonstrate, we might rewrite the @time example above as:macro time(expr)\n    return :(timeit(() -> $(esc(expr))))\nend\nfunction timeit(f)\n    t0 = time()\n    val = f()\n    t1 = time()\n    println(\"elapsed time: \", t1-t0, \" seconds\")\n    return val\nendHowever, we don\'t do this for a good reason: wrapping the expr in a new scope block (the anonymous function) also slightly changes the meaning of the expression (the scope of any variables in it), while we want @time to be usable with minimum impact on the wrapped code."
},

{
    "location": "manual/metaprogramming.html#Macros-and-dispatch-1",
    "page": "Metaprogramming",
    "title": "Macros and dispatch",
    "category": "section",
    "text": "Macros, just like Julia functions, are generic. This means they can also have multiple method definitions, thanks to multiple dispatch:julia> macro m end\n@m (macro with 0 methods)\n\njulia> macro m(args...)\n           println(\"$(length(args)) arguments\")\n       end\n@m (macro with 1 method)\n\njulia> macro m(x,y)\n           println(\"Two arguments\")\n       end\n@m (macro with 2 methods)\n\njulia> @m \"asd\"\n1 arguments\n\njulia> @m 1 2\nTwo argumentsHowever one should keep in mind, that macro dispatch is based on the types of AST that are handed to the macro, not the types that the AST evaluates to at runtime:julia> macro m(::Int)\n           println(\"An Integer\")\n       end\n@m (macro with 3 methods)\n\njulia> @m 2\nAn Integer\n\njulia> x = 2\n2\n\njulia> @m x\n1 arguments"
},

{
    "location": "manual/metaprogramming.html#Code-Generation-1",
    "page": "Metaprogramming",
    "title": "Code Generation",
    "category": "section",
    "text": "When a significant amount of repetitive boilerplate code is required, it is common to generate it programmatically to avoid redundancy. In most languages, this requires an extra build step, and a separate program to generate the repetitive code. In Julia, expression interpolation and eval allow such code generation to take place in the normal course of program execution. For example, consider the following custom typestruct MyNumber\n    x::Float64\nend\n# output\nfor which we want to add a number of methods to. We can do this programmatically in the following loop:for op = (:sin, :cos, :tan, :log, :exp)\n    eval(quote\n        Base.$op(a::MyNumber) = MyNumber($op(a.x))\n    end)\nend\n# output\nand we can now use those functions with our custom type:julia> x = MyNumber(π)\nMyNumber(3.141592653589793)\n\njulia> sin(x)\nMyNumber(1.2246467991473532e-16)\n\njulia> cos(x)\nMyNumber(-1.0)In this manner, Julia acts as its own preprocessor, and allows code generation from inside the language. The above code could be written slightly more tersely using the : prefix quoting form:for op = (:sin, :cos, :tan, :log, :exp)\n    eval(:(Base.$op(a::MyNumber) = MyNumber($op(a.x))))\nendThis sort of in-language code generation, however, using the eval(quote(...)) pattern, is common enough that Julia comes with a macro to abbreviate this pattern:for op = (:sin, :cos, :tan, :log, :exp)\n    @eval Base.$op(a::MyNumber) = MyNumber($op(a.x))\nendThe @eval macro rewrites this call to be precisely equivalent to the above longer versions. For longer blocks of generated code, the expression argument given to @eval can be a block:@eval begin\n    # multiple lines\nend"
},

{
    "location": "manual/metaprogramming.html#Non-Standard-String-Literals-1",
    "page": "Metaprogramming",
    "title": "Non-Standard String Literals",
    "category": "section",
    "text": "Recall from Strings that string literals prefixed by an identifier are called non-standard string literals, and can have different semantics than un-prefixed string literals. For example:r\"^\\s*(?:#|$)\" produces a regular expression object rather than a string\nb\"DATA\\xff\\u2200\" is a byte array literal for [68,65,84,65,255,226,136,128].Perhaps surprisingly, these behaviors are not hard-coded into the Julia parser or compiler. Instead, they are custom behaviors provided by a general mechanism that anyone can use: prefixed string literals are parsed as calls to specially-named macros. For example, the regular expression macro is just the following:macro r_str(p)\n    Regex(p)\nendThat\'s all. This macro says that the literal contents of the string literal r\"^\\s*(?:#|$)\" should be passed to the @r_str macro and the result of that expansion should be placed in the syntax tree where the string literal occurs. In other words, the expression r\"^\\s*(?:#|$)\" is equivalent to placing the following object directly into the syntax tree:Regex(\"^\\\\s*(?:#|\\$)\")Not only is the string literal form shorter and far more convenient, but it is also more efficient: since the regular expression is compiled and the Regex object is actually created when the code is compiled, the compilation occurs only once, rather than every time the code is executed. Consider if the regular expression occurs in a loop:for line = lines\n    m = match(r\"^\\s*(?:#|$)\", line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nendSince the regular expression r\"^\\s*(?:#|$)\" is compiled and inserted into the syntax tree when this code is parsed, the expression is only compiled once instead of each time the loop is executed. In order to accomplish this without macros, one would have to write this loop like this:re = Regex(\"^\\\\s*(?:#|\\$)\")\nfor line = lines\n    m = match(re, line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nendMoreover, if the compiler could not determine that the regex object was constant over all loops, certain optimizations might not be possible, making this version still less efficient than the more convenient literal form above. Of course, there are still situations where the non-literal form is more convenient: if one needs to interpolate a variable into the regular expression, one must take this more verbose approach; in cases where the regular expression pattern itself is dynamic, potentially changing upon each loop iteration, a new regular expression object must be constructed on each iteration. In the vast majority of use cases, however, regular expressions are not constructed based on run-time data. In this majority of cases, the ability to write regular expressions as compile-time values is invaluable.Like non-standard string literals, non-standard command literals exist using a prefixed variant of the command literal syntax. The command literal custom`literal` is parsed as @custom_cmd \"literal\". Julia itself does not contain any non-standard command literals, but packages can make use of this syntax. Aside from the different syntax and the _cmd suffix instead of the _str suffix, non-standard command literals behave exactly like non-standard string literals.In the event that two modules provide non-standard string or command literals with the same name, it is possible to qualify the string or command literal with a module name. For instance, if both Foo and Bar provide non-standard string literal @x_str, then one can write Foo.x\"literal\" or Bar.x\"literal\" to disambiguate between the two.The mechanism for user-defined string literals is deeply, profoundly powerful. Not only are Julia\'s non-standard literals implemented using it, but also the command literal syntax (`echo \"Hello, $person\"`) is implemented with the following innocuous-looking macro:macro cmd(str)\n    :(cmd_gen($(shell_parse(str)[1])))\nendOf course, a large amount of complexity is hidden in the functions used in this macro definition, but they are just functions, written entirely in Julia. You can read their source and see precisely what they do – and all they do is construct expression objects to be inserted into your program\'s syntax tree."
},

{
    "location": "manual/metaprogramming.html#Generated-functions-1",
    "page": "Metaprogramming",
    "title": "Generated functions",
    "category": "section",
    "text": "A very special macro is @generated, which allows you to define so-called generated functions. These have the capability to generate specialized code depending on the types of their arguments with more flexibility and/or less code than what can be achieved with multiple dispatch. While macros work with expressions at parse time and cannot access the types of their inputs, a generated function gets expanded at a time when the types of the arguments are known, but the function is not yet compiled.Instead of performing some calculation or action, a generated function declaration returns a quoted expression which then forms the body for the method corresponding to the types of the arguments. When a generated function is called, the expression it returns is compiled and then run. To make this efficient, the result is usually cached. And to make this inferable, only a limited subset of the language is usable. Thus, generated functions provide a flexible way to move work from run time to compile time, at the expense of greater restrictions on allowed constructs.When defining generated functions, there are four main differences to ordinary functions:You annotate the function declaration with the @generated macro. This adds some information to the AST that lets the compiler know that this is a generated function.\nIn the body of the generated function you only have access to the types of the arguments – not their values – and any function that was defined before the definition of the generated function.\nInstead of calculating something or performing some action, you return a quoted expression which, when evaluated, does what you want.\nGenerated functions must not mutate or observe any non-constant global state (including, for example, IO, locks, non-local dictionaries, or using hasmethod). This means they can only read global constants, and cannot have any side effects. In other words, they must be completely pure. Due to an implementation limitation, this also means that they currently cannot define a closure or generator.It\'s easiest to illustrate this with an example. We can declare a generated function foo asjulia> @generated function foo(x)\n           Core.println(x)\n           return :(x * x)\n       end\nfoo (generic function with 1 method)Note that the body returns a quoted expression, namely :(x * x), rather than just the value of x * x.From the caller\'s perspective, this is identical to a regular function; in fact, you don\'t have to know whether you\'re calling a regular or generated function. Let\'s see how foo behaves:julia> x = foo(2); # note: output is from println() statement in the body\nInt64\n\njulia> x           # now we print x\n4\n\njulia> y = foo(\"bar\");\nString\n\njulia> y\n\"barbar\"So, we see that in the body of the generated function, x is the type of the passed argument, and the value returned by the generated function, is the result of evaluating the quoted expression we returned from the definition, now with the value of x.What happens if we evaluate foo again with a type that we have already used?julia> foo(4)\n16Note that there is no printout of Int64. We can see that the body of the generated function was only executed once here, for the specific set of argument types, and the result was cached. After that, for this example, the expression returned from the generated function on the first invocation was re-used as the method body. However, the actual caching behavior is an implementation-defined performance optimization, so it is invalid to depend too closely on this behavior.The number of times a generated function is generated might be only once, but it might also be more often, or appear to not happen at all. As a consequence, you should never write a generated function with side effects - when, and how often, the side effects occur is undefined. (This is true for macros too - and just like for macros, the use of eval in a generated function is a sign that you\'re doing something the wrong way.) However, unlike macros, the runtime system cannot correctly handle a call to eval, so it is disallowed.It is also important to see how @generated functions interact with method redefinition. Following the principle that a correct @generated function must not observe any mutable state or cause any mutation of global state, we see the following behavior. Observe that the generated function cannot call any method that was not defined prior to the definition of the generated function itself.Initially f(x) has one definitionjulia> f(x) = \"original definition\";Define other operations that use f(x):julia> g(x) = f(x);\n\njulia> @generated gen1(x) = f(x);\n\njulia> @generated gen2(x) = :(f(x));We now add some new definitions for f(x):julia> f(x::Int) = \"definition for Int\";\n\njulia> f(x::Type{Int}) = \"definition for Type{Int}\";and compare how these results differ:julia> f(1)\n\"definition for Int\"\n\njulia> g(1)\n\"definition for Int\"\n\njulia> gen1(1)\n\"original definition\"\n\njulia> gen2(1)\n\"definition for Int\"Each method of a generated function has its own view of defined functions:julia> @generated gen1(x::Real) = f(x);\n\njulia> gen1(1)\n\"definition for Type{Int}\"The example generated function foo above did not do anything a normal function foo(x) = x * x could not do (except printing the type on the first invocation, and incurring higher overhead). However, the power of a generated function lies in its ability to compute different quoted expressions depending on the types passed to it:julia> @generated function bar(x)\n           if x <: Integer\n               return :(x ^ 2)\n           else\n               return :(x)\n           end\n       end\nbar (generic function with 1 method)\n\njulia> bar(4)\n16\n\njulia> bar(\"baz\")\n\"baz\"(although of course this contrived example would be more easily implemented using multiple dispatch...)Abusing this will corrupt the runtime system and cause undefined behavior:julia> @generated function baz(x)\n           if rand() < .9\n               return :(x^2)\n           else\n               return :(\"boo!\")\n           end\n       end\nbaz (generic function with 1 method)Since the body of the generated function is non-deterministic, its behavior, and the behavior of all subsequent code is undefined.Don\'t copy these examples!These examples are hopefully helpful to illustrate how generated functions work, both in the definition end and at the call site; however, don\'t copy them, for the following reasons:the foo function has side-effects (the call to Core.println), and it is undefined exactly when, how often or how many times these side-effects will occur\nthe bar function solves a problem that is better solved with multiple dispatch - defining bar(x) = x and bar(x::Integer) = x ^ 2 will do the same thing, but it is both simpler and faster.\nthe baz function is pathologicalNote that the set of operations that should not be attempted in a generated function is unbounded, and the runtime system can currently only detect a subset of the invalid operations. There are many other operations that will simply corrupt the runtime system without notification, usually in subtle ways not obviously connected to the bad definition. Because the function generator is run during inference, it must respect all of the limitations of that code.Some operations that should not be attempted include:Caching of native pointers.\nInteracting with the contents or methods of Core.Compiler in any way.\nObserving any mutable state.\nInference on the generated function may be run at any time, including while your code is attempting to observe or mutate this state.\nTaking any locks: C code you call out to may use locks internally, (for example, it is not problematic to call malloc, even though most implementations require locks internally) but don\'t attempt to hold or acquire any while executing Julia code.\nCalling any function that is defined after the body of the generated function. This condition is relaxed for incrementally-loaded precompiled modules to allow calling any function in the module.Alright, now that we have a better understanding of how generated functions work, let\'s use them to build some more advanced (and valid) functionality..."
},

{
    "location": "manual/metaprogramming.html#An-advanced-example-1",
    "page": "Metaprogramming",
    "title": "An advanced example",
    "category": "section",
    "text": "Julia\'s base library has a an internal sub2ind function to calculate a linear index into an n-dimensional array, based on a set of n multilinear indices - in other words, to calculate the index i that can be used to index into an array A using A[i], instead of A[x,y,z,...]. One possible implementation is the following:julia> function sub2ind_loop(dims::NTuple{N}, I::Integer...) where N\n           ind = I[N] - 1\n           for i = N-1:-1:1\n               ind = I[i]-1 + dims[i]*ind\n           end\n           return ind + 1\n       end\nsub2ind_loop (generic function with 1 method)\n\njulia> sub2ind_loop((3, 5), 1, 2)\n4The same thing can be done using recursion:julia> sub2ind_rec(dims::Tuple{}) = 1;\n\njulia> sub2ind_rec(dims::Tuple{}, i1::Integer, I::Integer...) =\n           i1 == 1 ? sub2ind_rec(dims, I...) : throw(BoundsError());\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer) = i1;\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer, I::Integer...) =\n           i1 + dims[1] * (sub2ind_rec(Base.tail(dims), I...) - 1);\n\njulia> sub2ind_rec((3, 5), 1, 2)\n4Both these implementations, although different, do essentially the same thing: a runtime loop over the dimensions of the array, collecting the offset in each dimension into the final index.However, all the information we need for the loop is embedded in the type information of the arguments. Thus, we can utilize generated functions to move the iteration to compile-time; in compiler parlance, we use generated functions to manually unroll the loop. The body becomes almost identical, but instead of calculating the linear index, we build up an expression that calculates the index:julia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end\nsub2ind_gen (generic function with 1 method)\n\njulia> sub2ind_gen((3, 5), 1, 2)\n4What code will this generate?An easy way to find out is to extract the body into another (regular) function:julia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           return sub2ind_gen_impl(dims, I...)\n       end\nsub2ind_gen (generic function with 1 method)\n\njulia> function sub2ind_gen_impl(dims::Type{T}, I...) where T <: NTuple{N,Any} where N\n           length(I) == N || return :(error(\"partial indexing is unsupported\"))\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end\nsub2ind_gen_impl (generic function with 1 method)We can now execute sub2ind_gen_impl and examine the expression it returns:julia> sub2ind_gen_impl(Tuple{Int,Int}, Int, Int)\n:(((I[1] - 1) + dims[1] * (I[2] - 1)) + 1)So, the method body that will be used here doesn\'t include a loop at all - just indexing into the two tuples, multiplication and addition/subtraction. All the looping is performed compile-time, and we avoid looping during execution entirely. Thus, we only loop once per type, in this case once per N (except in edge cases where the function is generated more than once - see disclaimer above)."
},

{
    "location": "manual/metaprogramming.html#Optionally-generated-functions-1",
    "page": "Metaprogramming",
    "title": "Optionally-generated functions",
    "category": "section",
    "text": "Generated functions can achieve high efficiency at run time, but come with a compile time cost: a new function body must be generated for every combination of concrete argument types. Typically, Julia is able to compile \"generic\" versions of functions that will work for any arguments, but with generated functions this is impossible. This means that programs making heavy use of generated functions might be impossible to statically compile.To solve this problem, the language provides syntax for writing normal, non-generated alternative implementations of generated functions. Applied to the sub2ind example above, it would look like this:function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n    if N != length(I)\n        throw(ArgumentError(\"Number of dimensions must match number of indices.\"))\n    end\n    if @generated\n        ex = :(I[$N] - 1)\n        for i = (N - 1):-1:1\n            ex = :(I[$i] - 1 + dims[$i] * $ex)\n        end\n        return :($ex + 1)\n    else\n        ind = I[N] - 1\n        for i = (N - 1):-1:1\n            ind = I[i] - 1 + dims[i]*ind\n        end\n        return ind + 1\n    end\nendInternally, this code creates two implementations of the function: a generated one where the first block in if @generated is used, and a normal one where the else block is used. Inside the then part of the if @generated block, code has the same semantics as other generated functions: argument names refer to types, and the code should return an expression. Multiple if @generated blocks may occur, in which case the generated implementation uses all of the then blocks and the alternate implementation uses all of the else blocks.Notice that we added an error check to the top of the function. This code will be common to both versions, and is run-time code in both versions (it will be quoted and returned as an expression from the generated version). That means that the values and types of local variables are not available at code generation time –- the code-generation code can only see the types of arguments.In this style of definition, the code generation feature is essentially an optional optimization. The compiler will use it if convenient, but otherwise may choose to use the normal implementation instead. This style is preferred, since it allows the compiler to make more decisions and compile programs in more ways, and since normal code is more readable than code-generating code. However, which implementation is used depends on compiler implementation details, so it is essential for the two implementations to behave identically."
},

{
    "location": "manual/arrays.html#",
    "page": "Multi-dimensional Arrays",
    "title": "Multi-dimensional Arrays",
    "category": "page",
    "text": ""
},

{
    "location": "manual/arrays.html#man-multi-dim-arrays-1",
    "page": "Multi-dimensional Arrays",
    "title": "Multi-dimensional Arrays",
    "category": "section",
    "text": "Julia, like most technical computing languages, provides a first-class array implementation. Most technical computing languages pay a lot of attention to their array implementation at the expense of other containers. Julia does not treat arrays in any special way. The array library is implemented almost completely in Julia itself, and derives its performance from the compiler, just like any other code written in Julia. As such, it\'s also possible to define custom array types by inheriting from AbstractArray. See the manual section on the AbstractArray interface for more details on implementing a custom array type.An array is a collection of objects stored in a multi-dimensional grid. In the most general case, an array may contain objects of type Any. For most computational purposes, arrays should contain objects of a more specific type, such as Float64 or Int32.In general, unlike many other technical computing languages, Julia does not expect programs to be written in a vectorized style for performance. Julia\'s compiler uses type inference and generates optimized code for scalar array indexing, allowing programs to be written in a style that is convenient and readable, without sacrificing performance, and using less memory at times.In Julia, all arguments to functions are passed by sharing (i.e. by pointers). Some technical computing languages pass arrays by value, and while this prevents accidental modification by callees of a value in the caller, it makes avoiding unwanted copying of arrays difficult. By convention, a function name ending with a ! indicates that it will mutate or destroy the value of one or more of its arguments (compare, for example, sort and sort!). Callees must make explicit copies to ensure that they don\'t modify inputs that they don\'t intend to change. Many non- mutating functions are implemented by calling a function of the same name with an added ! at the end on an explicit copy of the input, and returning that copy."
},

{
    "location": "manual/arrays.html#Basic-Functions-1",
    "page": "Multi-dimensional Arrays",
    "title": "Basic Functions",
    "category": "section",
    "text": "Function Description\neltype(A) the type of the elements contained in A\nlength(A) the number of elements in A\nndims(A) the number of dimensions of A\nsize(A) a tuple containing the dimensions of A\nsize(A,n) the size of A along dimension n\naxes(A) a tuple containing the valid indices of A\naxes(A,n) a range expressing the valid indices along dimension n\neachindex(A) an efficient iterator for visiting each position in A\nstride(A,k) the stride (linear index distance between adjacent elements) along dimension k\nstrides(A) a tuple of the strides in each dimension"
},

{
    "location": "manual/arrays.html#Construction-and-Initialization-1",
    "page": "Multi-dimensional Arrays",
    "title": "Construction and Initialization",
    "category": "section",
    "text": "Many functions for constructing and initializing arrays are provided. In the following list of such functions, calls with a dims... argument can either take a single tuple of dimension sizes or a series of dimension sizes passed as a variable number of arguments. Most of these functions also accept a first input T, which is the element type of the array. If the type T is omitted it will default to Float64.Function Description\nArray{T}(undef, dims...) an uninitialized dense Array\nzeros(T, dims...) an Array of all zeros\nones(T, dims...) an Array of all ones\ntrues(dims...) a BitArray with all values true\nfalses(dims...) a BitArray with all values false\nreshape(A, dims...) an array containing the same data as A, but with different dimensions\ncopy(A) copy A\ndeepcopy(A) copy A, recursively copying its elements\nsimilar(A, T, dims...) an uninitialized array of the same type as A (dense, sparse, etc.), but with the specified element type and dimensions. The second and third arguments are both optional, defaulting to the element type and dimensions of A if omitted.\nreinterpret(T, A) an array with the same binary data as A, but with element type T\nrand(T, dims...) an Array with random, iid [1] and uniformly distributed values in the half-open interval 0 1)\nrandn(T, dims...) an Array with random, iid and standard normally distributed values\nMatrix{T}(I, m, n) m-by-n identity matrix\nrange(start, stop=stop, length=n) range of n linearly spaced elements from start to stop\nfill!(A, x) fill the array A with the value x\nfill(x, dims...) an Array filled with the value x[1]: iid, independently and identically distributed.The syntax [A, B, C, ...] constructs a 1-d array (i.e., a vector) of its arguments. If all arguments have a common promotion type then they get converted to that type using convert.To see the various ways we can pass dimensions to these constructors, consider the following examples:julia> zeros(Int8, 2, 3)\n2×3 Array{Int8,2}:\n 0  0  0\n 0  0  0\n\njulia> zeros(Int8, (2, 3))\n2×3 Array{Int8,2}:\n 0  0  0\n 0  0  0\n\njulia> zeros((2, 3))\n2×3 Array{Float64,2}:\n 0.0  0.0  0.0\n 0.0  0.0  0.0Here, (2, 3) is a Tuple."
},

{
    "location": "manual/arrays.html#Concatenation-1",
    "page": "Multi-dimensional Arrays",
    "title": "Concatenation",
    "category": "section",
    "text": "Arrays can be constructed and also concatenated using the following functions:Function Description\ncat(A...; dims=k) concatenate input arrays along dimension(s) k\nvcat(A...) shorthand for cat(A...; dims=1)\nhcat(A...) shorthand for cat(A...; dims=2)Scalar values passed to these functions are treated as 1-element arrays. For example,julia> vcat([1, 2], 3)\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> hcat([1 2], 3)\n1×3 Array{Int64,2}:\n 1  2  3The concatenation functions are used so often that they have special syntax:Expression Calls\n[A; B; C; ...] vcat\n[A B C ...] hcat\n[A B; C D; ...] hvcathvcat concatenates in both dimension 1 (with semicolons) and dimension 2 (with spaces). Consider these examples of this syntax:julia> [[1; 2]; [3, 4]]\n4-element Array{Int64,1}:\n 1\n 2\n 3\n 4\n\njulia> [[1 2] [3 4]]\n1×4 Array{Int64,2}:\n 1  2  3  4\n\njulia> [[1 2]; [3 4]]\n2×2 Array{Int64,2}:\n 1  2\n 3  4"
},

{
    "location": "manual/arrays.html#Typed-array-initializers-1",
    "page": "Multi-dimensional Arrays",
    "title": "Typed array initializers",
    "category": "section",
    "text": "An array with a specific element type can be constructed using the syntax T[A, B, C, ...]. This will construct a 1-d array with element type T, initialized to contain elements A, B, C, etc. For example, Any[x, y, z] constructs a heterogeneous array that can contain any values.Concatenation syntax can similarly be prefixed with a type to specify the element type of the result.julia> [[1 2] [3 4]]\n1×4 Array{Int64,2}:\n 1  2  3  4\n\njulia> Int8[[1 2] [3 4]]\n1×4 Array{Int8,2}:\n 1  2  3  4"
},

{
    "location": "manual/arrays.html#Comprehensions-1",
    "page": "Multi-dimensional Arrays",
    "title": "Comprehensions",
    "category": "section",
    "text": "Comprehensions provide a general and powerful way to construct arrays. Comprehension syntax is similar to set construction notation in mathematics:A = [ F(x,y,...) for x=rx, y=ry, ... ]The meaning of this form is that F(x,y,...) is evaluated with the variables x, y, etc. taking on each value in their given list of values. Values can be specified as any iterable object, but will commonly be ranges like 1:n or 2:(n-1), or explicit arrays of values like [1.2, 3.4, 5.7]. The result is an N-d dense array with dimensions that are the concatenation of the dimensions of the variable ranges rx, ry, etc. and each F(x,y,...) evaluation returns a scalar.The following example computes a weighted average of the current element and its left and right neighbor along a 1-d grid. :julia> x = rand(8)\n8-element Array{Float64,1}:\n 0.843025\n 0.869052\n 0.365105\n 0.699456\n 0.977653\n 0.994953\n 0.41084\n 0.809411\n\njulia> [ 0.25*x[i-1] + 0.5*x[i] + 0.25*x[i+1] for i=2:length(x)-1 ]\n6-element Array{Float64,1}:\n 0.736559\n 0.57468\n 0.685417\n 0.912429\n 0.8446\n 0.656511The resulting array type depends on the types of the computed elements. In order to control the type explicitly, a type can be prepended to the comprehension. For example, we could have requested the result in single precision by writing:Float32[ 0.25*x[i-1] + 0.5*x[i] + 0.25*x[i+1] for i=2:length(x)-1 ]"
},

{
    "location": "manual/arrays.html#Generator-Expressions-1",
    "page": "Multi-dimensional Arrays",
    "title": "Generator Expressions",
    "category": "section",
    "text": "Comprehensions can also be written without the enclosing square brackets, producing an object known as a generator. This object can be iterated to produce values on demand, instead of allocating an array and storing them in advance (see Iteration). For example, the following expression sums a series without allocating memory:julia> sum(1/n^2 for n=1:1000)\n1.6439345666815615When writing a generator expression with multiple dimensions inside an argument list, parentheses are needed to separate the generator from subsequent arguments:julia> map(tuple, 1/(i+j) for i=1:2, j=1:2, [1:4;])\nERROR: syntax: invalid iteration specificationAll comma-separated expressions after for are interpreted as ranges. Adding parentheses lets us add a third argument to map:julia> map(tuple, (1/(i+j) for i=1:2, j=1:2), [1 3; 2 4])\n2×2 Array{Tuple{Float64,Int64},2}:\n (0.5, 1)       (0.333333, 3)\n (0.333333, 2)  (0.25, 4)Generators are implemented via inner functions. Just like inner functions used elsewhere in the language, variables from the enclosing scope can be \"captured\" in the inner function.  For example, sum(p[i] - q[i] for i=1:n) captures the three variables p, q and n from the enclosing scope. Captured variables can present performance challenges; see performance tips.Ranges in generators and comprehensions can depend on previous ranges by writing multiple for keywords:julia> [(i,j) for i=1:3 for j=1:i]\n6-element Array{Tuple{Int64,Int64},1}:\n (1, 1)\n (2, 1)\n (2, 2)\n (3, 1)\n (3, 2)\n (3, 3)In such cases, the result is always 1-d.Generated values can be filtered using the if keyword:julia> [(i,j) for i=1:3 for j=1:i if i+j == 4]\n2-element Array{Tuple{Int64,Int64},1}:\n (2, 2)\n (3, 1)"
},

{
    "location": "manual/arrays.html#man-array-indexing-1",
    "page": "Multi-dimensional Arrays",
    "title": "Indexing",
    "category": "section",
    "text": "The general syntax for indexing into an n-dimensional array A is:X = A[I_1, I_2, ..., I_n]where each I_k may be a scalar integer, an array of integers, or any other supported index. This includes Colon (:) to select all indices within the entire dimension, ranges of the form a:c or a:b:c to select contiguous or strided subsections, and arrays of booleans to select elements at their true indices.If all the indices are scalars, then the result X is a single element from the array A. Otherwise, X is an array with the same number of dimensions as the sum of the dimensionalities of all the indices.If all indices I_k are vectors, for example, then the shape of X would be (length(I_1), length(I_2), ..., length(I_n)), with location i_1, i_2, ..., i_n of X containing the value A[I_1[i_1], I_2[i_2], ..., I_n[i_n]].Example:julia> A = reshape(collect(1:16), (2, 2, 2, 2))\n2×2×2×2 Array{Int64,4}:\n[:, :, 1, 1] =\n 1  3\n 2  4\n\n[:, :, 2, 1] =\n 5  7\n 6  8\n\n[:, :, 1, 2] =\n  9  11\n 10  12\n\n[:, :, 2, 2] =\n 13  15\n 14  16\n\njulia> A[1, 2, 1, 1] # all scalar indices\n3\n\njulia> A[[1, 2], [1], [1, 2], [1]] # all vector indices\n2×1×2×1 Array{Int64,4}:\n[:, :, 1, 1] =\n 1\n 2\n\n[:, :, 2, 1] =\n 5\n 6\n\njulia> A[[1, 2], [1], [1, 2], 1] # a mix of index types\n2×1×2 Array{Int64,3}:\n[:, :, 1] =\n 1\n 2\n\n[:, :, 2] =\n 5\n 6Note how the size of the resulting array is different in the last two cases.If I_1 is changed to a two-dimensional matrix, then X becomes an n+1-dimensional array of shape (size(I_1, 1), size(I_1, 2), length(I_2), ..., length(I_n)). The matrix adds a dimension.Example:julia> A = reshape(collect(1:16), (2, 2, 2, 2));\n\njulia> A[[1 2; 1 2]]\n2×2 Array{Int64,2}:\n 1  2\n 1  2\n\njulia> A[[1 2; 1 2], 1, 2, 1]\n2×2 Array{Int64,2}:\n 5  6\n 5  6The location i_1, i_2, i_3, ..., i_{n+1} contains the value at A[I_1[i_1, i_2], I_2[i_3], ..., I_n[i_{n+1}]]. All dimensions indexed with scalars are dropped. For example, if J is an array of indices, then the result of A[2, J, 3] is an array with size size(J). Its jth element is populated by A[2, J[j], 3].As a special part of this syntax, the end keyword may be used to represent the last index of each dimension within the indexing brackets, as determined by the size of the innermost array being indexed. Indexing syntax without the end keyword is equivalent to a call to getindex:X = getindex(A, I_1, I_2, ..., I_n)Example:julia> x = reshape(1:16, 4, 4)\n4×4 reshape(::UnitRange{Int64}, 4, 4) with eltype Int64:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> x[2:3, 2:end-1]\n2×2 Array{Int64,2}:\n 6  10\n 7  11\n\njulia> x[1, [2 3; 4 1]]\n2×2 Array{Int64,2}:\n  5  9\n 13  1"
},

{
    "location": "manual/arrays.html#Assignment-1",
    "page": "Multi-dimensional Arrays",
    "title": "Assignment",
    "category": "section",
    "text": "The general syntax for assigning values in an n-dimensional array A is:A[I_1, I_2, ..., I_n] = Xwhere each I_k may be a scalar integer, an array of integers, or any other supported index. This includes Colon (:) to select all indices within the entire dimension, ranges of the form a:c or a:b:c to select contiguous or strided subsections, and arrays of booleans to select elements at their true indices.If all indices I_k are integers, then the value in location I_1, I_2, ..., I_n of A is overwritten with the value of X, converting to the eltype of A if necessary.If any index I_k selects more than one location, then the right hand side X must be an array with the same shape as the result of indexing A[I_1, I_2, ..., I_n] or a vector with the same number of elements. The value in location I_1[i_1], I_2[i_2], ..., I_n[i_n] of A is overwritten with the value X[I_1, I_2, ..., I_n], converting if necessary. The element-wise assignment operator .= may be used to broadcast X across the selected locations:A[I_1, I_2, ..., I_n] .= XJust as in Indexing, the end keyword may be used to represent the last index of each dimension within the indexing brackets, as determined by the size of the array being assigned into. Indexed assignment syntax without the end keyword is equivalent to a call to setindex!:setindex!(A, X, I_1, I_2, ..., I_n)Example:julia> x = collect(reshape(1:9, 3, 3))\n3×3 Array{Int64,2}:\n 1  4  7\n 2  5  8\n 3  6  9\n\njulia> x[3, 3] = -9;\n\njulia> x[1:2, 1:2] = [-1 -4; -2 -5];\n\njulia> x\n3×3 Array{Int64,2}:\n -1  -4   7\n -2  -5   8\n  3   6  -9"
},

{
    "location": "manual/arrays.html#man-supported-index-types-1",
    "page": "Multi-dimensional Arrays",
    "title": "Supported index types",
    "category": "section",
    "text": "In the expression A[I_1, I_2, ..., I_n], each I_k may be a scalar index, an array of scalar indices, or an object that represents an array of scalar indices and can be converted to such by to_indices:A scalar index. By default this includes:\nNon-boolean integers\nCartesianIndex{N}s, which behave like an N-tuple of integers spanning multiple dimensions (see below for more details)\nAn array of scalar indices. This includes:\nVectors and multidimensional arrays of integers\nEmpty arrays like [], which select no elements\nRanges like a:c or a:b:c, which select contiguous or strided subsections from a to c (inclusive)\nAny custom array of scalar indices that is a subtype of AbstractArray\nArrays of CartesianIndex{N} (see below for more details)\nAn object that represents an array of scalar indices and can be converted to such by to_indices. By default this includes:\nColon() (:), which represents all indices within an entire dimension or across the entire array\nArrays of booleans, which select elements at their true indices (see below for more details)Some examples:julia> A = reshape(collect(1:2:18), (3, 3))\n3×3 Array{Int64,2}:\n 1   7  13\n 3   9  15\n 5  11  17\n\njulia> A[4]\n7\n\njulia> A[[2, 5, 8]]\n3-element Array{Int64,1}:\n  3\n  9\n 15\n\njulia> A[[1 4; 3 8]]\n2×2 Array{Int64,2}:\n 1   7\n 5  15\n\njulia> A[[]]\n0-element Array{Int64,1}\n\njulia> A[1:2:5]\n3-element Array{Int64,1}:\n 1\n 5\n 9\n\njulia> A[2, :]\n3-element Array{Int64,1}:\n  3\n  9\n 15\n\njulia> A[:, 3]\n3-element Array{Int64,1}:\n 13\n 15\n 17"
},

{
    "location": "manual/arrays.html#Cartesian-indices-1",
    "page": "Multi-dimensional Arrays",
    "title": "Cartesian indices",
    "category": "section",
    "text": "The special CartesianIndex{N} object represents a scalar index that behaves like an N-tuple of integers spanning multiple dimensions.  For example:julia> A = reshape(1:32, 4, 4, 2);\n\njulia> A[3, 2, 1]\n7\n\njulia> A[CartesianIndex(3, 2, 1)] == A[3, 2, 1] == 7\ntrueConsidered alone, this may seem relatively trivial; CartesianIndex simply gathers multiple integers together into one object that represents a single multidimensional index. When combined with other indexing forms and iterators that yield CartesianIndexes, however, this can produce very elegant and efficient code. See Iteration below, and for some more advanced examples, see this blog post on multidimensional algorithms and iteration.Arrays of CartesianIndex{N} are also supported. They represent a collection of scalar indices that each span N dimensions, enabling a form of indexing that is sometimes referred to as pointwise indexing. For example, it enables accessing the diagonal elements from the first \"page\" of A from above:julia> page = A[:,:,1]\n4×4 Array{Int64,2}:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> page[[CartesianIndex(1,1),\n             CartesianIndex(2,2),\n             CartesianIndex(3,3),\n             CartesianIndex(4,4)]]\n4-element Array{Int64,1}:\n  1\n  6\n 11\n 16This can be expressed much more simply with dot broadcasting and by combining it with a normal integer index (instead of extracting the first page from A as a separate step). It can even be combined with a : to extract both diagonals from the two pages at the same time:julia> A[CartesianIndex.(axes(A, 1), axes(A, 2)), 1]\n4-element Array{Int64,1}:\n  1\n  6\n 11\n 16\n\njulia> A[CartesianIndex.(axes(A, 1), axes(A, 2)), :]\n4×2 Array{Int64,2}:\n  1  17\n  6  22\n 11  27\n 16  32warning: Warning\nCartesianIndex and arrays of CartesianIndex are not compatible with the end keyword to represent the last index of a dimension. Do not use end in indexing expressions that may contain either CartesianIndex or arrays thereof."
},

{
    "location": "manual/arrays.html#Logical-indexing-1",
    "page": "Multi-dimensional Arrays",
    "title": "Logical indexing",
    "category": "section",
    "text": "Often referred to as logical indexing or indexing with a logical mask, indexing by a boolean array selects elements at the indices where its values are true. Indexing by a boolean vector B is effectively the same as indexing by the vector of integers that is returned by findall(B). Similarly, indexing by a N-dimensional boolean array is effectively the same as indexing by the vector of CartesianIndex{N}s where its values are true. A logical index must be a vector of the same length as the dimension it indexes into, or it must be the only index provided and match the size and dimensionality of the array it indexes into. It is generally more efficient to use boolean arrays as indices directly instead of first calling findall.julia> x = reshape(1:16, 4, 4)\n4×4 reshape(::UnitRange{Int64}, 4, 4) with eltype Int64:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> x[[false, true, true, false], :]\n2×4 Array{Int64,2}:\n 2  6  10  14\n 3  7  11  15\n\njulia> mask = map(ispow2, x)\n4×4 Array{Bool,2}:\n  true  false  false  false\n  true  false  false  false\n false  false  false  false\n  true   true  false   true\n\njulia> x[mask]\n5-element Array{Int64,1}:\n  1\n  2\n  4\n  8\n 16"
},

{
    "location": "manual/arrays.html#Number-of-indices-1",
    "page": "Multi-dimensional Arrays",
    "title": "Number of indices",
    "category": "section",
    "text": ""
},

{
    "location": "manual/arrays.html#Cartesian-indexing-1",
    "page": "Multi-dimensional Arrays",
    "title": "Cartesian indexing",
    "category": "section",
    "text": "The ordinary way to index into an N-dimensional array is to use exactly N indices; each index selects the position(s) in its particular dimension. For example, in the three-dimensional array A = rand(4, 3, 2), A[2, 3, 1] will select the number in the second row of the third column in the first \"page\" of the array. This is often referred to as cartesian indexing."
},

{
    "location": "manual/arrays.html#Linear-indexing-1",
    "page": "Multi-dimensional Arrays",
    "title": "Linear indexing",
    "category": "section",
    "text": "When exactly one index i is provided, that index no longer represents a location in a particular dimension of the array. Instead, it selects the ith element using the column-major iteration order that linearly spans the entire array. This is known as linear indexing. It essentially treats the array as though it had been reshaped into a one-dimensional vector with vec.julia> A = [2 6; 4 7; 3 1]\n3×2 Array{Int64,2}:\n 2  6\n 4  7\n 3  1\n\njulia> A[5]\n7\n\njulia> vec(A)[5]\n7A linear index into the array A can be converted to a CartesianIndex for cartesian indexing with CartesianIndices(A)[i] (see CartesianIndices), and a set of N cartesian indices can be converted to a linear index with LinearIndices(A)[i_1, i_2, ..., i_N] (see LinearIndices).julia> CartesianIndices(A)[5]\nCartesianIndex(2, 2)\n\njulia> LinearIndices(A)[2, 2]\n5It\'s important to note that there\'s a very large assymmetry in the performance of these conversions. Converting a linear index to a set of cartesian indices requires dividing and taking the remainder, whereas going the other way is just multiplies and adds. In modern processors, integer division can be 10-50 times slower than multiplication. While some arrays — like Array itself — are implemented using a linear chunk of memory and directly use a linear index in their implementations, other arrays — like Diagonal — need the full set of cartesian indices to do their lookup (see IndexStyle to introspect which is which). As such, when iterating over an entire array, it\'s much better to iterate over eachindex(A) instead of 1:length(A). Not only will the former be much faster in cases where A is IndexCartesian, but it will also support OffsetArrays, too."
},

{
    "location": "manual/arrays.html#Omitted-and-extra-indices-1",
    "page": "Multi-dimensional Arrays",
    "title": "Omitted and extra indices",
    "category": "section",
    "text": "In addition to linear indexing, an N-dimensional array may be indexed with fewer or more than N indices in certain situations.Indices may be omitted if the trailing dimensions that are not indexed into are all length one. In other words, trailing indices can be omitted only if there is only one possible value that those omitted indices could be for an in-bounds indexing expression. For example, a four-dimensional array with size (3, 4, 2, 1) may be indexed with only three indices as the dimension that gets skipped (the fourth dimension) has length one. Note that linear indexing takes precedence over this rule.julia> A = reshape(1:24, 3, 4, 2, 1)\n3×4×2×1 reshape(::UnitRange{Int64}, 3, 4, 2, 1) with eltype Int64:\n[:, :, 1, 1] =\n 1  4  7  10\n 2  5  8  11\n 3  6  9  12\n\n[:, :, 2, 1] =\n 13  16  19  22\n 14  17  20  23\n 15  18  21  24\n\njulia> A[1, 3, 2] # Omits the fourth dimension (length 1)\n19\n\njulia> A[1, 3] # Attempts to omit dimensions 3 & 4 (lengths 2 and 1)\nERROR: BoundsError: attempt to access 3×4×2×1 reshape(::UnitRange{Int64}, 3, 4, 2, 1) with eltype Int64 at index [1, 3]\n\njulia> A[19] # Linear indexing\n19When omitting all indices with A[], this semantic provides a simple idiom to retrieve the only element in an array and simultaneously ensure that there was only one element.Similarly, more than N indices may be provided if all the indices beyond the dimensionality of the array are 1 (or more generally are the first and only element of axes(A, d) where d is that particular dimension number). This allows vectors to be indexed like one-column matrices, for example:julia> A = [8,6,7]\n3-element Array{Int64,1}:\n 8\n 6\n 7\n\njulia> A[2,1]\n6"
},

{
    "location": "manual/arrays.html#Iteration-1",
    "page": "Multi-dimensional Arrays",
    "title": "Iteration",
    "category": "section",
    "text": "The recommended ways to iterate over a whole array arefor a in A\n    # Do something with the element a\nend\n\nfor i in eachindex(A)\n    # Do something with i and/or A[i]\nendThe first construct is used when you need the value, but not index, of each element. In the second construct, i will be an Int if A is an array type with fast linear indexing; otherwise, it will be a CartesianIndex:julia> A = rand(4,3);\n\njulia> B = view(A, 1:3, 2:3);\n\njulia> for i in eachindex(B)\n           @show i\n       end\ni = CartesianIndex(1, 1)\ni = CartesianIndex(2, 1)\ni = CartesianIndex(3, 1)\ni = CartesianIndex(1, 2)\ni = CartesianIndex(2, 2)\ni = CartesianIndex(3, 2)In contrast with for i = 1:length(A), iterating with eachindex provides an efficient way to iterate over any array type."
},

{
    "location": "manual/arrays.html#Array-traits-1",
    "page": "Multi-dimensional Arrays",
    "title": "Array traits",
    "category": "section",
    "text": "If you write a custom AbstractArray type, you can specify that it has fast linear indexing usingBase.IndexStyle(::Type{<:MyArray}) = IndexLinear()This setting will cause eachindex iteration over a MyArray to use integers. If you don\'t specify this trait, the default value IndexCartesian() is used."
},

{
    "location": "manual/arrays.html#Array-and-Vectorized-Operators-and-Functions-1",
    "page": "Multi-dimensional Arrays",
    "title": "Array and Vectorized Operators and Functions",
    "category": "section",
    "text": "The following operators are supported for arrays:Unary arithmetic – -, +\nBinary arithmetic – -, +, *, /, \\, ^\nComparison – ==, !=, ≈ (isapprox), ≉To enable convenient vectorization of mathematical and other operations, Julia provides the dot syntax f.(args...), e.g. sin.(x) or min.(x,y), for elementwise operations over arrays or mixtures of arrays and scalars (a Broadcasting operation); these have the additional advantage of \"fusing\" into a single loop when combined with other dot calls, e.g. sin.(cos.(x)).Also, every binary operator supports a dot version that can be applied to arrays (and combinations of arrays and scalars) in such fused broadcasting operations, e.g. z .== sin.(x .* y).Note that comparisons such as == operate on whole arrays, giving a single boolean answer. Use dot operators like .== for elementwise comparisons. (For comparison operations like <, only the elementwise .< version is applicable to arrays.)Also notice the difference between max.(a,b), which broadcasts max elementwise over a and b, and maximum(a), which finds the largest value within a. The same relationship holds for min.(a,b) and minimum(a)."
},

{
    "location": "manual/arrays.html#Broadcasting-1",
    "page": "Multi-dimensional Arrays",
    "title": "Broadcasting",
    "category": "section",
    "text": "It is sometimes useful to perform element-by-element binary operations on arrays of different sizes, such as adding a vector to each column of a matrix. An inefficient way to do this would be to replicate the vector to the size of the matrix:julia> a = rand(2,1); A = rand(2,3);\n\njulia> repeat(a,1,3)+A\n2×3 Array{Float64,2}:\n 1.20813  1.82068  1.25387\n 1.56851  1.86401  1.67846This is wasteful when dimensions get large, so Julia provides broadcast, which expands singleton dimensions in array arguments to match the corresponding dimension in the other array without using extra memory, and applies the given function elementwise:julia> broadcast(+, a, A)\n2×3 Array{Float64,2}:\n 1.20813  1.82068  1.25387\n 1.56851  1.86401  1.67846\n\njulia> b = rand(1,2)\n1×2 Array{Float64,2}:\n 0.867535  0.00457906\n\njulia> broadcast(+, a, b)\n2×2 Array{Float64,2}:\n 1.71056  0.847604\n 1.73659  0.873631Dotted operators such as .+ and .* are equivalent to broadcast calls (except that they fuse, as described below). There is also a broadcast! function to specify an explicit destination (which can also be accessed in a fusing fashion by .= assignment). In fact, f.(args...) is equivalent to broadcast(f, args...), providing a convenient syntax to broadcast any function (dot syntax). Nested \"dot calls\" f.(...) (including calls to .+ etcetera) automatically fuse into a single broadcast call.Additionally, broadcast is not limited to arrays (see the function documentation), it also handles tuples and treats any argument that is not an array, tuple or Ref (except for Ptr) as a \"scalar\".julia> convert.(Float32, [1, 2])\n2-element Array{Float32,1}:\n 1.0\n 2.0\n\njulia> ceil.((UInt8,), [1.2 3.4; 5.6 6.7])\n2×2 Array{UInt8,2}:\n 0x02  0x04\n 0x06  0x07\n\njulia> string.(1:3, \". \", [\"First\", \"Second\", \"Third\"])\n3-element Array{String,1}:\n \"1. First\"\n \"2. Second\"\n \"3. Third\""
},

{
    "location": "manual/arrays.html#Implementation-1",
    "page": "Multi-dimensional Arrays",
    "title": "Implementation",
    "category": "section",
    "text": "The base array type in Julia is the abstract type AbstractArray{T,N}. It is parameterized by the number of dimensions N and the element type T. AbstractVector and AbstractMatrix are aliases for the 1-d and 2-d cases. Operations on AbstractArray objects are defined using higher level operators and functions, in a way that is independent of the underlying storage. These operations generally work correctly as a fallback for any specific array implementation.The AbstractArray type includes anything vaguely array-like, and implementations of it might be quite different from conventional arrays. For example, elements might be computed on request rather than stored. However, any concrete AbstractArray{T,N} type should generally implement at least size(A) (returning an Int tuple), getindex(A,i) and getindex(A,i1,...,iN); mutable arrays should also implement setindex!. It is recommended that these operations have nearly constant time complexity, or technically Õ(1) complexity, as otherwise some array functions may be unexpectedly slow. Concrete types should also typically provide a similar(A,T=eltype(A),dims=size(A)) method, which is used to allocate a similar array for copy and other out-of-place operations. No matter how an AbstractArray{T,N} is represented internally, T is the type of object returned by integer indexing (A[1, ..., 1], when A is not empty) and N should be the length of the tuple returned by size. For more details on defining custom AbstractArray implementations, see the array interface guide in the interfaces chapter.DenseArray is an abstract subtype of AbstractArray intended to include all arrays where elements are stored contiguously in column-major order (see additional notes in Performance Tips). The Array type is a specific instance of DenseArray;  Vector and Matrix are aliases for the 1-d and 2-d cases. Very few operations are implemented specifically for Array beyond those that are required for all AbstractArrays; much of the array library is implemented in a generic manner that allows all custom arrays to behave similarly.SubArray is a specialization of AbstractArray that performs indexing by sharing memory with the original array rather than by copying it. A SubArray is created with the view function, which is called the same way as getindex (with an array and a series of index arguments). The result of view looks the same as the result of getindex, except the data is left in place. view stores the input index vectors in a SubArray object, which can later be used to index the original array indirectly.  By putting the @views macro in front of an expression or block of code, any array[...] slice in that expression will be converted to create a SubArray view instead.BitArrays are space-efficient \"packed\" boolean arrays, which store one bit per boolean value. They can be used similarly to Array{Bool} arrays (which store one byte per boolean value), and can be converted to/from the latter via Array(bitarray) and BitArray(array), respectively.A \"strided\" array is stored in memory with elements laid out in regular offsets such that an instance with a supported isbits element type can be passed to external C and Fortran functions that expect this memory layout. Strided arrays must define a strides(A) method that returns a tuple of \"strides\" for each dimension; a provided stride(A,k) method accesses the kth element within this tuple. Increasing the index of dimension k by 1 should increase the index i of getindex(A,i) by stride(A,k). If a pointer conversion method Base.unsafe_convert(Ptr{T}, A) is provided, the memory layout must correspond in the same way to these strides. DenseArray is a very specific example of a strided array where the elements are arranged contiguously, thus it provides its subtypes with the appropriate definition of strides. More concrete examples can be found within the interface guide for strided arrays. StridedVector and StridedMatrix are convenient aliases for many of the builtin array types that are considered strided arrays, allowing them to dispatch to select specialized implementations that call highly tuned and optimized BLAS and LAPACK functions using just the pointer and strides.The following example computes the QR decomposition of a small section of a larger array, without creating any temporaries, and by calling the appropriate LAPACK function with the right leading dimension size and stride parameters.julia> a = rand(10, 10)\n10×10 Array{Float64,2}:\n 0.517515  0.0348206  0.749042   0.0979679  …  0.75984     0.950481   0.579513\n 0.901092  0.873479   0.134533   0.0697848     0.0586695   0.193254   0.726898\n 0.976808  0.0901881  0.208332   0.920358      0.288535    0.705941   0.337137\n 0.657127  0.0317896  0.772837   0.534457      0.0966037   0.700694   0.675999\n 0.471777  0.144969   0.0718405  0.0827916     0.527233    0.173132   0.694304\n 0.160872  0.455168   0.489254   0.827851   …  0.62226     0.0995456  0.946522\n 0.291857  0.769492   0.68043    0.629461      0.727558    0.910796   0.834837\n 0.775774  0.700731   0.700177   0.0126213     0.00822304  0.327502   0.955181\n 0.9715    0.64354    0.848441   0.241474      0.591611    0.792573   0.194357\n 0.646596  0.575456   0.0995212  0.038517      0.709233    0.477657   0.0507231\n\njulia> b = view(a, 2:2:8,2:2:4)\n4×2 view(::Array{Float64,2}, 2:2:8, 2:2:4) with eltype Float64:\n 0.873479   0.0697848\n 0.0317896  0.534457\n 0.455168   0.827851\n 0.700731   0.0126213\n\njulia> (q, r) = qr(b);\n\njulia> q\n4×4 LinearAlgebra.QRCompactWYQ{Float64,Array{Float64,2}}:\n -0.722358    0.227524  -0.247784    -0.604181\n -0.0262896  -0.575919  -0.804227     0.144377\n -0.376419   -0.75072    0.540177    -0.0541979\n -0.579497    0.230151  -0.00552346   0.781782\n\njulia> r\n2×2 Array{Float64,2}:\n -1.20921  -0.383393\n  0.0      -0.910506"
},

{
    "location": "manual/missing.html#",
    "page": "Missing Values",
    "title": "Missing Values",
    "category": "page",
    "text": ""
},

{
    "location": "manual/missing.html#missing-1",
    "page": "Missing Values",
    "title": "Missing Values",
    "category": "section",
    "text": "Julia provides support for representing missing values in the statistical sense, that is for situations where no value is available for a variable in an observation, but a valid value theoretically exists. Missing values are represented via the missing object, which is the singleton instance of the type Missing. missing is equivalent to NULL in SQL and NA in R, and behaves like them in most situations."
},

{
    "location": "manual/missing.html#Propagation-of-Missing-Values-1",
    "page": "Missing Values",
    "title": "Propagation of Missing Values",
    "category": "section",
    "text": "The behavior of missing values follows one basic rule: missing values propagate automatically when passed to standard operators and functions, in particular mathematical functions. Uncertainty about the value of one of the operands induces uncertainty about the result. In practice, this means an operation involving a missing value generally returns missingjulia> missing + 1\nmissing\n\njulia> \"a\" * missing\nmissing\n\njulia> abs(missing)\nmissingAs missing is a normal Julia object, this propagation rule only works for functions which have opted in to implement this behavior. This can be achieved either via a specific method defined for arguments of type Missing, or simply by accepting arguments of this type, and passing them to functions which propagate them (like standard operators). Packages should consider whether it makes sense to propagate missing values when defining new functions, and define methods appropriately if that is the case. Passing a missing value to a function for which no method accepting arguments of type Missing is defined throws a MethodError, just like for any other type."
},

{
    "location": "manual/missing.html#Equality-and-Comparison-Operators-1",
    "page": "Missing Values",
    "title": "Equality and Comparison Operators",
    "category": "section",
    "text": "Standard equality and comparison operators follow the propagation rule presented above: if any of the operands is missing, the result is missing. Here are a few examplesjulia> missing == 1\nmissing\n\njulia> missing == missing\nmissing\n\njulia> missing < 1\nmissing\n\njulia> 2 >= missing\nmissingIn particular, note that missing == missing returns missing, so == cannot be used to test whether a value is missing. To test whether x is missing, use ismissing(x).Special comparison operators isequal and === are exceptions to the propagation rule: they always return a Bool value, even in the presence of missing values, considering missing as equal to missing and as different from any other value. They can therefore be used to test whether a value is missingjulia> missing === 1\nfalse\n\njulia> isequal(missing, 1)\nfalse\n\njulia> missing === missing\ntrue\n\njulia> isequal(missing, missing)\ntrueThe isless operator is another exception: missing is considered as greater than any other value. This operator is used by sort, which therefore places missing values after all other values.julia> isless(1, missing)\ntrue\n\njulia> isless(missing, Inf)\nfalse\n\njulia> isless(missing, missing)\nfalse"
},

{
    "location": "manual/missing.html#Logical-operators-1",
    "page": "Missing Values",
    "title": "Logical operators",
    "category": "section",
    "text": "Logical (or boolean) operators |, & and xor are another special case, as they only propagate missing values when it is logically required. For these operators, whether or not the result is uncertain depends on the particular operation, following the well-established rules of three-valued logic which are also implemented by NULL in SQL and NA in R. This abstract definition actually corresponds to a relatively natural behavior which is best explained via concrete examples.Let us illustrate this principle with the logical \"or\" operator |. Following the rules of boolean logic, if one of the operands is true, the value of the other operand does not have an influence on the result, which will always be truejulia> true | true\ntrue\n\njulia> true | false\ntrue\n\njulia> false | true\ntrueBased on this observation, we can conclude that if one of the operands is true and the other missing, we know that the result is true in spite of the uncertainty about the actual value of one of the operands. If we had been able to observe the actual value of the second operand, it could only be true or false, and in both cases the result would be true. Therefore, in this particular case, missingness does not propagatejulia> true | missing\ntrue\n\njulia> missing | true\ntrueOn the contrary, if one of the operands is false, the result could be either true or false depending on the value of the other operand. Therefore, if that operand is missing, the result has to be missing toojulia> false | true\ntrue\n\njulia> true | false\ntrue\n\njulia> false | false\nfalse\n\njulia> false | missing\nmissing\n\njulia> missing | false\nmissingThe behavior of the logical \"and\" operator & is similar to that of the | operator, with the difference that missingness does not propagate when one of the operands is false. For example, when that is the case of the first operandjulia> false & false\nfalse\n\njulia> false & true\nfalse\n\njulia> false & missing\nfalseOn the other hand, missingness propagates when one of the operands is true, for example the first onejulia> true & true\ntrue\n\njulia> true & false\nfalse\n\njulia> true & missing\nmissingFinally, the \"exclusive or\" logical operator xor always propagates missing values, since both operands always have an effect on the result. Also note that the negation operator ! returns missing when the operand is missing just like other unary operators."
},

{
    "location": "manual/missing.html#Control-Flow-and-Short-Circuiting-Operators-1",
    "page": "Missing Values",
    "title": "Control Flow and Short-Circuiting Operators",
    "category": "section",
    "text": "Control flow operators including if, while and the ternary operator x ? y : z do not allow for missing values. This is because of the uncertainty about whether the actual value would be true or false if we could observe it, which implies that we do not know how the program should behave. A TypeError is thrown as soon as a missing value is encountered in this contextjulia> if missing\n           println(\"here\")\n       end\nERROR: TypeError: non-boolean (Missing) used in boolean contextFor the same reason, contrary to logical operators presented above, the short-circuiting boolean operators && and || do not allow for missing values in situations where the value of the operand determines whether the next operand is evaluated or not. For examplejulia> missing || false\nERROR: TypeError: non-boolean (Missing) used in boolean context\n\njulia> missing && false\nERROR: TypeError: non-boolean (Missing) used in boolean context\n\njulia> true && missing && false\nERROR: TypeError: non-boolean (Missing) used in boolean contextOn the other hand, no error is thrown when the result can be determined without the missing values. This is the case when the code short-circuits before evaluating the missing operand, and when the missing operand is the last onejulia> true && missing\nmissing\n\njulia> false && missing\nfalse"
},

{
    "location": "manual/missing.html#Arrays-With-Missing-Values-1",
    "page": "Missing Values",
    "title": "Arrays With Missing Values",
    "category": "section",
    "text": "Arrays containing missing values can be created like other arraysjulia> [1, missing]\n2-element Array{Union{Missing, Int64},1}:\n 1\n  missingAs this example shows, the element type of such arrays is Union{Missing, T}, with T the type of the non-missing values. This simply reflects the fact that array entries can be either of type T (here, Int64) or of type Missing. This kind of array uses an efficient memory storage equivalent to an Array{T} holding the actual values combined with an Array{UInt8} indicating the type of the entry (i.e. whether it is Missing or T).Arrays allowing for missing values can be constructed with the standard syntax. Use Array{Union{Missing, T}}(missing, dims) to create arrays filled with missing values:julia> Array{Union{Missing, String}}(missing, 2, 3)\n2×3 Array{Union{Missing, String},2}:\n missing  missing  missing\n missing  missing  missingAn array allowing for missing values but which does not contain any such value can be converted back to an array which does not allow for missing values using convert. If the array contains missing values, a MethodError is thrown during conversionjulia> x = Union{Missing, String}[\"a\", \"b\"]\n2-element Array{Union{Missing, String},1}:\n \"a\"\n \"b\"\n\njulia> convert(Array{String}, x)\n2-element Array{String,1}:\n \"a\"\n \"b\"\n\njulia> y = Union{Missing, String}[missing, \"b\"]\n2-element Array{Union{Missing, String},1}:\n missing\n \"b\"\n\njulia> convert(Array{String}, y)\nERROR: MethodError: Cannot `convert` an object of type Missing to an object of type String"
},

{
    "location": "manual/missing.html#Skipping-Missing-Values-1",
    "page": "Missing Values",
    "title": "Skipping Missing Values",
    "category": "section",
    "text": "Since missing values propagate with standard mathematical operators, reduction functions return missing when called on arrays which contain missing valuesjulia> sum([1, missing])\nmissingIn this situation, use the skipmissing function to skip missing valuesjulia> sum(skipmissing([1, missing]))\n1This convenience function returns an iterator which filters out missing values efficiently. It can therefore be used with any function which supports iteratorsjulia> maximum(skipmissing([3, missing, 2, 1]))\n3\n\njulia> mean(skipmissing([3, missing, 2, 1]))\n2.0\n\njulia> mapreduce(sqrt, +, skipmissing([3, missing, 2, 1]))\n4.146264369941973Use collect to extract non-missing values and store them in an arrayjulia> collect(skipmissing([3, missing, 2, 1]))\n3-element Array{Int64,1}:\n 3\n 2\n 1"
},

{
    "location": "manual/missing.html#Logical-Operations-on-Arrays-1",
    "page": "Missing Values",
    "title": "Logical Operations on Arrays",
    "category": "section",
    "text": "The three-valued logic described above for logical operators is also used by logical functions applied to arrays. Thus, array equality tests using the == operator return missing whenever the result cannot be determined without knowing the actual value of the missing entry. In practice, this means that missing is returned if all non-missing values of the compared arrays are equal, but one or both arrays contain missing values (possibly at different positions)julia> [1, missing] == [2, missing]\nfalse\n\njulia> [1, missing] == [1, missing]\nmissing\n\njulia> [1, 2, missing] == [1, missing, 2]\nmissingAs for single values, use isequal to treat missing values as equal to other missing values but different from non-missing valuesjulia> isequal([1, missing], [1, missing])\ntrue\n\njulia> isequal([1, 2, missing], [1, missing, 2])\nfalseFunctions any and all also follow the rules of three-valued logic, returning missing when the result cannot be determinedjulia> all([true, missing])\nmissing\n\njulia> all([false, missing])\nfalse\n\njulia> any([true, missing])\ntrue\n\njulia> any([false, missing])\nmissing"
},

{
    "location": "manual/networking-and-streams.html#",
    "page": "Networking and Streams",
    "title": "Networking and Streams",
    "category": "page",
    "text": ""
},

{
    "location": "manual/networking-and-streams.html#Networking-and-Streams-1",
    "page": "Networking and Streams",
    "title": "Networking and Streams",
    "category": "section",
    "text": "Julia provides a rich interface to deal with streaming I/O objects such as terminals, pipes and TCP sockets. This interface, though asynchronous at the system level, is presented in a synchronous manner to the programmer and it is usually unnecessary to think about the underlying asynchronous operation. This is achieved by making heavy use of Julia cooperative threading (coroutine) functionality."
},

{
    "location": "manual/networking-and-streams.html#Basic-Stream-I/O-1",
    "page": "Networking and Streams",
    "title": "Basic Stream I/O",
    "category": "section",
    "text": "All Julia streams expose at least a read and a write method, taking the stream as their first argument, e.g.:julia> write(stdout, \"Hello World\");  # suppress return value 11 with ;\nHello World\njulia> read(stdin, Char)\n\n\'\\n\': ASCII/Unicode U+000a (category Cc: Other, control)Note that write returns 11, the number of bytes (in \"Hello World\") written to stdout, but this return value is suppressed with the ;.Here Enter was pressed again so that Julia would read the newline. Now, as you can see from this example, write takes the data to write as its second argument, while read takes the type of the data to be read as the second argument.For example, to read a simple byte array, we could do:julia> x = zeros(UInt8, 4)\n4-element Array{UInt8,1}:\n 0x00\n 0x00\n 0x00\n 0x00\n\njulia> read!(stdin, x)\nabcd\n4-element Array{UInt8,1}:\n 0x61\n 0x62\n 0x63\n 0x64However, since this is slightly cumbersome, there are several convenience methods provided. For example, we could have written the above as:julia> read(stdin, 4)\nabcd\n4-element Array{UInt8,1}:\n 0x61\n 0x62\n 0x63\n 0x64or if we had wanted to read the entire line instead:julia> readline(stdin)\nabcd\n\"abcd\"Note that depending on your terminal settings, your TTY may be line buffered and might thus require an additional enter before the data is sent to Julia.To read every line from stdin you can use eachline:for line in eachline(stdin)\n    print(\"Found $line\")\nendor read if you wanted to read by character instead:while !eof(stdin)\n    x = read(stdin, Char)\n    println(\"Found: $x\")\nend"
},

{
    "location": "manual/networking-and-streams.html#Text-I/O-1",
    "page": "Networking and Streams",
    "title": "Text I/O",
    "category": "section",
    "text": "Note that the write method mentioned above operates on binary streams. In particular, values do not get converted to any canonical text representation but are written out as is:julia> write(stdout, 0x61);  # suppress return value 1 with ;\naNote that a is written to stdout by the write function and that the returned value is 1 (since 0x61 is one byte).For text I/O, use the print or show methods, depending on your needs (see the documentation for these two methods for a detailed discussion of the difference between them):julia> print(stdout, 0x61)\n97See Custom pretty-printing for more information on how to implement display methods for custom types."
},

{
    "location": "manual/networking-and-streams.html#IO-Output-Contextual-Properties-1",
    "page": "Networking and Streams",
    "title": "IO Output Contextual Properties",
    "category": "section",
    "text": "Sometimes IO output can benefit from the ability to pass contextual information into show methods. The IOContext object provides this framework for associating arbitrary metadata with an IO object. For example, :compact => true adds a hinting parameter to the IO object that the invoked show method should print a shorter output (if applicable). See the IOContext documentation for a list of common properties."
},

{
    "location": "manual/networking-and-streams.html#Working-with-Files-1",
    "page": "Networking and Streams",
    "title": "Working with Files",
    "category": "section",
    "text": "Like many other environments, Julia has an open function, which takes a filename and returns an IOStream object that you can use to read and write things from the file. For example, if we have a file, hello.txt, whose contents are Hello, World!:julia> f = open(\"hello.txt\")\nIOStream(<file hello.txt>)\n\njulia> readlines(f)\n1-element Array{String,1}:\n \"Hello, World!\"If you want to write to a file, you can open it with the write (\"w\") flag:julia> f = open(\"hello.txt\",\"w\")\nIOStream(<file hello.txt>)\n\njulia> write(f,\"Hello again.\")\n12If you examine the contents of hello.txt at this point, you will notice that it is empty; nothing has actually been written to disk yet. This is because the IOStream must be closed before the write is actually flushed to disk:julia> close(f)Examining hello.txt again will show its contents have been changed.Opening a file, doing something to its contents, and closing it again is a very common pattern. To make this easier, there exists another invocation of open which takes a function as its first argument and filename as its second, opens the file, calls the function with the file as an argument, and then closes it again. For example, given a function:function read_and_capitalize(f::IOStream)\n    return uppercase(read(f, String))\nendYou can call:julia> open(read_and_capitalize, \"hello.txt\")\n\"HELLO AGAIN.\"to open hello.txt, call read_and_capitalize on it, close hello.txt and return the capitalized contents.To avoid even having to define a named function, you can use the do syntax, which creates an anonymous function on the fly:julia> open(\"hello.txt\") do f\n           uppercase(read(f, String))\n       end\n\"HELLO AGAIN.\""
},

{
    "location": "manual/networking-and-streams.html#A-simple-TCP-example-1",
    "page": "Networking and Streams",
    "title": "A simple TCP example",
    "category": "section",
    "text": "Let\'s jump right in with a simple example involving TCP sockets. This functionality is in a standard library package called Sockets. Let\'s first create a simple server:julia> using Sockets\n\njulia> @async begin\n           server = listen(2000)\n           while true\n               sock = accept(server)\n               println(\"Hello World\\n\")\n           end\n       end\nTask (runnable) @0x00007fd31dc11ae0To those familiar with the Unix socket API, the method names will feel familiar, though their usage is somewhat simpler than the raw Unix socket API. The first call to listen will create a server waiting for incoming connections on the specified port (2000) in this case. The same function may also be used to create various other kinds of servers:julia> listen(2000) # Listens on localhost:2000 (IPv4)\nSockets.TCPServer(active)\n\njulia> listen(ip\"127.0.0.1\",2000) # Equivalent to the first\nSockets.TCPServer(active)\n\njulia> listen(ip\"::1\",2000) # Listens on localhost:2000 (IPv6)\nSockets.TCPServer(active)\n\njulia> listen(IPv4(0),2001) # Listens on port 2001 on all IPv4 interfaces\nSockets.TCPServer(active)\n\njulia> listen(IPv6(0),2001) # Listens on port 2001 on all IPv6 interfaces\nSockets.TCPServer(active)\n\njulia> listen(\"testsocket\") # Listens on a UNIX domain socket\nSockets.PipeServer(active)\n\njulia> listen(\"\\\\\\\\.\\\\pipe\\\\testsocket\") # Listens on a Windows named pipe\nSockets.PipeServer(active)Note that the return type of the last invocation is different. This is because this server does not listen on TCP, but rather on a named pipe (Windows) or UNIX domain socket. Also note that Windows named pipe format has to be a specific pattern such that the name prefix (\\\\.\\pipe\\) uniquely identifies the file type. The difference between TCP and named pipes or UNIX domain sockets is subtle and has to do with the accept and connect methods. The accept method retrieves a connection to the client that is connecting on the server we just created, while the connect function connects to a server using the specified method. The connect function takes the same arguments as listen, so, assuming the environment (i.e. host, cwd, etc.) is the same you should be able to pass the same arguments to connect as you did to listen to establish the connection. So let\'s try that out (after having created the server above):julia> connect(2000)\nTCPSocket(open, 0 bytes waiting)\n\njulia> Hello WorldAs expected we saw \"Hello World\" printed. So, let\'s actually analyze what happened behind the scenes. When we called connect, we connect to the server we had just created. Meanwhile, the accept function returns a server-side connection to the newly created socket and prints \"Hello World\" to indicate that the connection was successful.A great strength of Julia is that since the API is exposed synchronously even though the I/O is actually happening asynchronously, we didn\'t have to worry about callbacks or even making sure that the server gets to run. When we called connect the current task waited for the connection to be established and only continued executing after that was done. In this pause, the server task resumed execution (because a connection request was now available), accepted the connection, printed the message and waited for the next client. Reading and writing works in the same way. To see this, consider the following simple echo server:julia> @async begin\n           server = listen(2001)\n           while true\n               sock = accept(server)\n               @async while isopen(sock)\n                   write(sock, readline(sock, keep=true))\n               end\n           end\n       end\nTask (runnable) @0x00007fd31dc12e60\n\njulia> clientside = connect(2001)\nTCPSocket(RawFD(28) open, 0 bytes waiting)\n\njulia> @async while isopen(clientside)\n           write(stdout, readline(clientside, keep=true))\n       end\nTask (runnable) @0x00007fd31dc11870\n\njulia> println(clientside,\"Hello World from the Echo Server\")\nHello World from the Echo ServerAs with other streams, use close to disconnect the socket:julia> close(clientside)"
},

{
    "location": "manual/networking-and-streams.html#Resolving-IP-Addresses-1",
    "page": "Networking and Streams",
    "title": "Resolving IP Addresses",
    "category": "section",
    "text": "One of the connect methods that does not follow the listen methods is connect(host::String,port), which will attempt to connect to the host given by the host parameter on the port given by the port parameter. It allows you to do things like:julia> connect(\"google.com\", 80)\nTCPSocket(RawFD(30) open, 0 bytes waiting)At the base of this functionality is getaddrinfo, which will do the appropriate address resolution:julia> getaddrinfo(\"google.com\")\nip\"74.125.226.225\""
},

{
    "location": "manual/parallel-computing.html#",
    "page": "Parallel Computing",
    "title": "Parallel Computing",
    "category": "page",
    "text": ""
},

{
    "location": "manual/parallel-computing.html#Parallel-Computing-1",
    "page": "Parallel Computing",
    "title": "Parallel Computing",
    "category": "section",
    "text": "For newcomers to multi-threading and parallel computing it can be useful to first appreciate the different levels of parallelism offered by Julia. We can divide them in three main categories :Julia Coroutines (Green Threading)\nMulti-Threading\nMulti-Core or Distributed ProcessingWe will first consider Julia Tasks (aka Coroutines) and other modules that rely on the Julia runtime library, that allow us to suspend and resume computations with full control of inter-Tasks communication without having to manually interface with the operating system\'s scheduler. Julia also supports communication between Tasks through operations like wait and fetch. Communication and data synchronization is managed through Channels, which are the conduits that provide inter-Tasks communication.Julia also supports experimental multi-threading, where execution is forked and an anonymous function is run across all threads. Known as the fork-join approach, parallel threads execute independently, and must ultimately be joined in Julia\'s main thread to allow serial execution to continue. Multi-threading is supported using the Base.Threads module that is still considered experimental, as Julia is not yet fully thread-safe. In particular segfaults seem to occur during I/O operations and task switching. As an up-to-date reference, keep an eye on the issue tracker. Multi-Threading should only be used if you take into consideration global variables, locks and atomics, all of which are explained later.In the end we will present Julia\'s approach to distributed and parallel computing. With scientific computing in mind, Julia natively implements interfaces to distribute a process across multiple cores or machines. Also we will mention useful external packages for distributed programming like MPI.jl and DistributedArrays.jl."
},

{
    "location": "manual/parallel-computing.html#Coroutines-1",
    "page": "Parallel Computing",
    "title": "Coroutines",
    "category": "section",
    "text": "Julia\'s parallel programming platform uses Tasks (aka Coroutines) to switch among multiple computations. To express an order of execution between lightweight threads communication primitives are necessary. Julia offers Channel(func::Function, ctype=Any, csize=0, taskref=nothing) that creates a new task from func, binds it to a new channel of type ctype and size csize and schedule the task. Channels can serve as a way to communicate between tasks, as Channel{T}(sz::Int) creates a buffered channel of type T and size sz. Whenever code performs a communication operation like fetch or wait, the current task is suspended and a scheduler picks another task to run. A task is restarted when the event it is waiting for completes.For many problems, it is not necessary to think about tasks directly. However, they can be used to wait for multiple events at the same time, which provides for dynamic scheduling. In dynamic scheduling, a program decides what to compute or where to compute it based on when other jobs finish. This is needed for unpredictable or unbalanced workloads, where we want to assign more work to processes only when they finish their current tasks."
},

{
    "location": "manual/parallel-computing.html#Channels-1",
    "page": "Parallel Computing",
    "title": "Channels",
    "category": "section",
    "text": "The section on Tasks in Control Flow discussed the execution of multiple functions in a co-operative manner. Channels can be quite useful to pass data between running tasks, particularly those involving I/O operations.Examples of operations involving I/O include reading/writing to files, accessing web services, executing external programs, etc. In all these cases, overall execution time can be improved if other tasks can be run while a file is being read, or while waiting for an external service/program to complete.A channel can be visualized as a pipe, i.e., it has a write end and a read end :Multiple writers in different tasks can write to the same channel concurrently via put! calls.\nMultiple readers in different tasks can read data concurrently via take! calls.\nAs an example:\n# Given Channels c1 and c2,\nc1 = Channel(32)\nc2 = Channel(32)\n\n# and a function `foo` which reads items from c1, processes the item read\n# and writes a result to c2,\nfunction foo()\n    while true\n        data = take!(c1)\n        [...]               # process data\n        put!(c2, result)    # write out result\n    end\nend\n\n# we can schedule `n` instances of `foo` to be active concurrently.\nfor _ in 1:n\n    @async foo()\nend\nChannels are created via the Channel{T}(sz) constructor. The channel will only hold objectsof type T. If the type is not specified, the channel can hold objects of any type. sz refers   to the maximum number of elements that can be held in the channel at any time. For example, Channel(32)   creates a channel that can hold a maximum of 32 objects of any type. A Channel{MyType}(64) can   hold up to 64 objects of MyType at any time.If a Channel is empty, readers (on a take! call) will block until data is available.\nIf a Channel is full, writers (on a put! call) will block until space becomes available.\nisready tests for the presence of any object in the channel, while wait waits for an object to become available.\nA Channel is in an open state initially. This means that it can be read from and written to freely via take! and put! calls. close closes a Channel. On a closed Channel, put! will fail. For example:julia> c = Channel(2);\n\njulia> put!(c, 1) # `put!` on an open channel succeeds\n1\n\njulia> close(c);\n\njulia> put!(c, 2) # `put!` on a closed channel throws an exception.\nERROR: InvalidStateException(\"Channel is closed.\",:closed)\nStacktrace:\n[...]take! and fetch (which retrieves but does not remove the value) on a closed channel successfully return any existing values until it is emptied. Continuing the above example:julia> fetch(c) # Any number of `fetch` calls succeed.\n1\n\njulia> fetch(c)\n1\n\njulia> take!(c) # The first `take!` removes the value.\n1\n\njulia> take!(c) # No more data available on a closed channel.\nERROR: InvalidStateException(\"Channel is closed.\",:closed)\nStacktrace:\n[...]A Channel can be used as an iterable object in a for loop, in which case the loop runs as long as the Channel has data or is open. The loop variable takes on all values added to the Channel. The for loop is terminated once the Channel is closed and emptied.For example, the following would cause the for loop to wait for more data:julia> c = Channel{Int}(10);\n\njulia> foreach(i->put!(c, i), 1:3) # add a few entries\n\njulia> data = [i for i in c]while this will return after reading all data:julia> c = Channel{Int}(10);\n\njulia> foreach(i->put!(c, i), 1:3); # add a few entries\n\njulia> close(c);                    # `for` loops can exit\n\njulia> data = [i for i in c]\n3-element Array{Int64,1}:\n 1\n 2\n 3Consider a simple example using channels for inter-task communication. We start 4 tasks to process data from a single jobs channel. Jobs, identified by an id (job_id), are written to the channel. Each task in this simulation reads a job_id, waits for a random amount of time and writes back a tuple of job_id and the simulated time to the results channel. Finally all the results are printed out.julia> const jobs = Channel{Int}(32);\n\njulia> const results = Channel{Tuple}(32);\n\njulia> function do_work()\n           for job_id in jobs\n               exec_time = rand()\n               sleep(exec_time)                # simulates elapsed time doing actual work\n                                               # typically performed externally.\n               put!(results, (job_id, exec_time))\n           end\n       end;\n\njulia> function make_jobs(n)\n           for i in 1:n\n               put!(jobs, i)\n           end\n       end;\n\njulia> n = 12;\n\njulia> @async make_jobs(n); # feed the jobs channel with \"n\" jobs\n\njulia> for i in 1:4 # start 4 tasks to process requests in parallel\n           @async do_work()\n       end\n\njulia> @elapsed while n > 0 # print out results\n           job_id, exec_time = take!(results)\n           println(\"$job_id finished in $(round(exec_time; digits=2)) seconds\")\n           global n = n - 1\n       end\n4 finished in 0.22 seconds\n3 finished in 0.45 seconds\n1 finished in 0.5 seconds\n7 finished in 0.14 seconds\n2 finished in 0.78 seconds\n5 finished in 0.9 seconds\n9 finished in 0.36 seconds\n6 finished in 0.87 seconds\n8 finished in 0.79 seconds\n10 finished in 0.64 seconds\n12 finished in 0.5 seconds\n11 finished in 0.97 seconds\n0.029772311The current version of Julia multiplexes all tasks onto a single OS thread. Thus, while tasks involving I/O operations benefit from parallel execution, compute bound tasks are effectively executed sequentially on a single OS thread. Future versions of Julia may support scheduling of tasks on multiple threads, in which case compute bound tasks will see benefits of parallel execution too."
},

{
    "location": "manual/parallel-computing.html#Multi-Threading-(Experimental)-1",
    "page": "Parallel Computing",
    "title": "Multi-Threading (Experimental)",
    "category": "section",
    "text": "In addition to tasks Julia forwards natively supports multi-threading. Note that this section is experimental and the interfaces may change in the future."
},

{
    "location": "manual/parallel-computing.html#Setup-1",
    "page": "Parallel Computing",
    "title": "Setup",
    "category": "section",
    "text": "By default, Julia starts up with a single thread of execution. This can be verified by using the command Threads.nthreads():julia> Threads.nthreads()\n1The number of threads Julia starts up with is controlled by an environment variable called JULIA_NUM_THREADS. Now, let\'s start up Julia with 4 threads:export JULIA_NUM_THREADS=4(The above command works on bourne shells on Linux and OSX. Note that if you\'re using a C shell on these platforms, you should use the keyword set instead of export. If you\'re on Windows, start up the command line in the location of julia.exe and use set instead of export.)Let\'s verify there are 4 threads at our disposal.julia> Threads.nthreads()\n4But we are currently on the master thread. To check, we use the function Threads.threadidjulia> Threads.threadid()\n1"
},

{
    "location": "manual/parallel-computing.html#The-@threads-Macro-1",
    "page": "Parallel Computing",
    "title": "The @threads Macro",
    "category": "section",
    "text": "Let\'s work a simple example using our native threads. Let us create an array of zeros:julia> a = zeros(10)\n10-element Array{Float64,1}:\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0Let us operate on this array simultaneously using 4 threads. We\'ll have each thread write its thread ID into each location.Julia supports parallel loops using the Threads.@threads macro. This macro is affixed in front of a for loop to indicate to Julia that the loop is a multi-threaded region:julia> Threads.@threads for i = 1:10\n           a[i] = Threads.threadid()\n       endThe iteration space is split amongst the threads, after which each thread writes its thread ID to its assigned locations:julia> a\n10-element Array{Float64,1}:\n 1.0\n 1.0\n 1.0\n 2.0\n 2.0\n 2.0\n 3.0\n 3.0\n 4.0\n 4.0Note that Threads.@threads does not have an optional reduction parameter like @distributed."
},

{
    "location": "manual/parallel-computing.html#Atomic-Operations-1",
    "page": "Parallel Computing",
    "title": "Atomic Operations",
    "category": "section",
    "text": "Julia supports accessing and modifying values atomically, that is, in a thread-safe way to avoid race conditions. A value (which must be of a primitive type) can be wrapped as Threads.Atomic to indicate it must be accessed in this way. Here we can see an example:julia> i = Threads.Atomic{Int}(0);\n\njulia> ids = zeros(4);\n\njulia> old_is = zeros(4);\n\njulia> Threads.@threads for id in 1:4\n           old_is[id] = Threads.atomic_add!(i, id)\n           ids[id] = id\n       end\n\njulia> old_is\n4-element Array{Float64,1}:\n 0.0\n 1.0\n 7.0\n 3.0\n\njulia> ids\n4-element Array{Float64,1}:\n 1.0\n 2.0\n 3.0\n 4.0Had we tried to do the addition without the atomic tag, we might have gotten the wrong answer due to a race condition. An example of what would happen if we didn\'t avoid the race:julia> using Base.Threads\n\njulia> nthreads()\n4\n\njulia> acc = Ref(0)\nBase.RefValue{Int64}(0)\n\njulia> @threads for i in 1:1000\n          acc[] += 1\n       end\n\njulia> acc[]\n926\n\njulia> acc = Atomic{Int64}(0)\nAtomic{Int64}(0)\n\njulia> @threads for i in 1:1000\n          atomic_add!(acc, 1)\n       end\n\njulia> acc[]\n1000note: Note\nNot all primitive types can be wrapped in an Atomic tag. Supported types are Int8, Int16, Int32, Int64, Int128, UInt8, UInt16, UInt32, UInt64, UInt128, Float16, Float32, and Float64. Additionally, Int128 and UInt128 are not supported on AAarch32 and ppc64le."
},

{
    "location": "manual/parallel-computing.html#Side-effects-and-mutable-function-arguments-1",
    "page": "Parallel Computing",
    "title": "Side effects and mutable function arguments",
    "category": "section",
    "text": "When using multi-threading we have to be careful when using functions that are not pure as we might get a wrong answer. For instance functions that have their name ending with ! by convention modify their arguments and thus are not pure. However, there are functions that have side effects and their name does not end with !. For instance findfirst(regex, str) mutates its regex argument or rand() changes Base.GLOBAL_RNG :julia> using Base.Threads\n\njulia> nthreads()\n4\n\njulia> function f()\n           s = repeat([\"123\", \"213\", \"231\"], outer=1000)\n           x = similar(s, Int)\n           rx = r\"1\"\n           @threads for i in 1:3000\n               x[i] = findfirst(rx, s[i]).start\n           end\n           count(v -> v == 1, x)\n       end\nf (generic function with 1 method)\n\njulia> f() # the correct result is 1000\n1017\n\njulia> function g()\n           a = zeros(1000)\n           @threads for i in 1:1000\n               a[i] = rand()\n           end\n           length(unique(a))\n       end\ng (generic function with 1 method)\n\njulia> Random.seed!(1); g() # the result for a single thread is 1000\n781In such cases one should redesign the code to avoid the possibility of a race condition or use synchronization primitives.For example in order to fix findfirst example above one needs to have a separate copy of rx variable for each thread:julia> function f_fix()\n             s = repeat([\"123\", \"213\", \"231\"], outer=1000)\n             x = similar(s, Int)\n             rx = [Regex(\"1\") for i in 1:nthreads()]\n             @threads for i in 1:3000\n                 x[i] = findfirst(rx[threadid()], s[i]).start\n             end\n             count(v -> v == 1, x)\n         end\nf_fix (generic function with 1 method)\n\njulia> f_fix()\n1000We now use Regex(\"1\") instead of r\"1\" to make sure that Julia creates separate instances of Regex object for each entry of rx vector.The case of rand is a bit more complex as we have to ensure that each thread uses non-overlapping pseudorandom number sequences. This can be simply ensured by using Future.randjump function:julia> using Random; import Future\n\njulia> function g_fix(r)\n           a = zeros(1000)\n           @threads for i in 1:1000\n               a[i] = rand(r[threadid()])\n           end\n           length(unique(a))\n       end\ng_fix (generic function with 1 method)\n\njulia>  r = let m = MersenneTwister(1)\n                [m; accumulate(Future.randjump, fill(big(10)^20, nthreads()-1), init=m)]\n            end;\n\njulia> g_fix(r)\n1000We pass the r vector to g_fix as generating several RGNs is an expensive operation so we do not want to repeat it every time we run the function."
},

{
    "location": "manual/parallel-computing.html#@threadcall-(Experimental)-1",
    "page": "Parallel Computing",
    "title": "@threadcall (Experimental)",
    "category": "section",
    "text": "All I/O tasks, timers, REPL commands, etc are multiplexed onto a single OS thread via an event loop. A patched version of libuv (http://docs.libuv.org/en/v1.x/) provides this functionality. Yield points provide for co-operatively scheduling multiple tasks onto the same OS thread. I/O tasks and timers yield implicitly while waiting for the event to occur. Calling yield explicitly allows for other tasks to be scheduled.Thus, a task executing a ccall effectively prevents the Julia scheduler from executing any other tasks till the call returns. This is true for all calls into external libraries. Exceptions are calls into custom C code that call back into Julia (which may then yield) or C code that calls jl_yield() (C equivalent of yield).Note that while Julia code runs on a single thread (by default), libraries used by Julia may launch their own internal threads. For example, the BLAS library may start as many threads as there are cores on a machine.The @threadcall macro addresses scenarios where we do not want a ccall to block the main Julia event loop. It schedules a C function for execution in a separate thread. A threadpool with a default size of 4 is used for this. The size of the threadpool is controlled via environment variable UV_THREADPOOL_SIZE. While waiting for a free thread, and during function execution once a thread is available, the requesting task (on the main Julia event loop) yields to other tasks. Note that @threadcall does not return till the execution is complete. From a user point of view, it is therefore a blocking call like other Julia APIs.It is very important that the called function does not call back into Julia, as it will segfault.@threadcall may be removed/changed in future versions of Julia."
},

{
    "location": "manual/parallel-computing.html#Multi-Core-or-Distributed-Processing-1",
    "page": "Parallel Computing",
    "title": "Multi-Core or Distributed Processing",
    "category": "section",
    "text": "An implementation of distributed memory parallel computing is provided by module Distributed as part of the standard library shipped with Julia.Most modern computers possess more than one CPU, and several computers can be combined together in a cluster. Harnessing the power of these multiple CPUs allows many computations to be completed more quickly. There are two major factors that influence performance: the speed of the CPUs themselves, and the speed of their access to memory. In a cluster, it\'s fairly obvious that a given CPU will have fastest access to the RAM within the same computer (node). Perhaps more surprisingly, similar issues are relevant on a typical multicore laptop, due to differences in the speed of main memory and the cache. Consequently, a good multiprocessing environment should allow control over the \"ownership\" of a chunk of memory by a particular CPU. Julia provides a multiprocessing environment based on message passing to allow programs to run on multiple processes in separate memory domains at once.Julia\'s implementation of message passing is different from other environments such as MPI [1]. Communication in Julia is generally \"one-sided\", meaning that the programmer needs to explicitly manage only one process in a two-process operation. Furthermore, these operations typically do not look like \"message send\" and \"message receive\" but rather resemble higher-level operations like calls to user functions.Distributed programming in Julia is built on two primitives: remote references and remote calls. A remote reference is an object that can be used from any process to refer to an object stored on a particular process. A remote call is a request by one process to call a certain function on certain arguments on another (possibly the same) process.Remote references come in two flavors: Future and RemoteChannel.A remote call returns a Future to its result. Remote calls return immediately; the process that made the call proceeds to its next operation while the remote call happens somewhere else. You can wait for a remote call to finish by calling wait on the returned Future, and you can obtain the full value of the result using fetch.On the other hand, RemoteChannel s are rewritable. For example, multiple processes can co-ordinate their processing by referencing the same remote Channel.Each process has an associated identifier. The process providing the interactive Julia prompt always has an id equal to 1. The processes used by default for parallel operations are referred to as \"workers\". When there is only one process, process 1 is considered a worker. Otherwise, workers are considered to be all processes other than process 1.Let\'s try this out. Starting with julia -p n provides n worker processes on the local machine. Generally it makes sense for n to equal the number of CPU threads (logical cores) on the machine. Note that the -p argument implicitly loads module Distributed.$ ./julia -p 2\n\njulia> r = remotecall(rand, 2, 2, 2)\nFuture(2, 1, 4, nothing)\n\njulia> s = @spawnat 2 1 .+ fetch(r)\nFuture(2, 1, 5, nothing)\n\njulia> fetch(s)\n2×2 Array{Float64,2}:\n 1.18526  1.50912\n 1.16296  1.60607The first argument to remotecall is the function to call. Most parallel programming in Julia does not reference specific processes or the number of processes available, but remotecall is considered a low-level interface providing finer control. The second argument to remotecall is the id of the process that will do the work, and the remaining arguments will be passed to the function being called.As you can see, in the first line we asked process 2 to construct a 2-by-2 random matrix, and in the second line we asked it to add 1 to it. The result of both calculations is available in the two futures, r and s. The @spawnat macro evaluates the expression in the second argument on the process specified by the first argument.Occasionally you might want a remotely-computed value immediately. This typically happens when you read from a remote object to obtain data needed by the next local operation. The function remotecall_fetch exists for this purpose. It is equivalent to fetch(remotecall(...)) but is more efficient.julia> remotecall_fetch(getindex, 2, r, 1, 1)\n0.18526337335308085Remember that getindex(r,1,1) is equivalent to r[1,1], so this call fetches the first element of the future r.The syntax of remotecall is not especially convenient. The macro @spawn makes things easier. It operates on an expression rather than a function, and picks where to do the operation for you:julia> r = @spawn rand(2,2)\nFuture(2, 1, 4, nothing)\n\njulia> s = @spawn 1 .+ fetch(r)\nFuture(3, 1, 5, nothing)\n\njulia> fetch(s)\n2×2 Array{Float64,2}:\n 1.38854  1.9098\n 1.20939  1.57158Note that we used 1 .+ fetch(r) instead of 1 .+ r. This is because we do not know where the code will run, so in general a fetch might be required to move r to the process doing the addition. In this case, @spawn is smart enough to perform the computation on the process that owns r, so the fetch will be a no-op (no work is done).(It is worth noting that @spawn is not built-in but defined in Julia as a macro. It is possible to define your own such constructs.)An important thing to remember is that, once fetched, a Future will cache its value locally. Further fetch calls do not entail a network hop. Once all referencing Futures have fetched, the remote stored value is deleted.@async is similar to @spawn, but only runs tasks on the local process. We use it to create a \"feeder\" task for each process. Each task picks the next index that needs to be computed, then waits for its process to finish, then repeats until we run out of indices. Note that the feeder tasks do not begin to execute until the main task reaches the end of the @sync block, at which point it surrenders control and waits for all the local tasks to complete before returning from the function. As for v0.7 and beyond, the feeder tasks are able to share state via nextidx because they all run on the same process. Even if Tasks are scheduled cooperatively, locking may still be required in some contexts, as in asynchronous I/O. This means context switches only occur at well-defined points: in this case, when remotecall_fetch is called. This is the current state of implementation and it may change for future Julia versions, as it is intended to make it possible to run up to N Tasks on M Process, aka M:N Threading. Then a lock acquiring\\releasing model for nextidx will be needed, as it is not safe to let multiple processes read-write a resource at the same time."
},

{
    "location": "manual/parallel-computing.html#Code-Availability-and-Loading-Packages-1",
    "page": "Parallel Computing",
    "title": "Code Availability and Loading Packages",
    "category": "section",
    "text": "Your code must be available on any process that runs it. For example, type the following into the Julia prompt:julia> function rand2(dims...)\n           return 2*rand(dims...)\n       end\n\njulia> rand2(2,2)\n2×2 Array{Float64,2}:\n 0.153756  0.368514\n 1.15119   0.918912\n\njulia> fetch(@spawn rand2(2,2))\nERROR: RemoteException(2, CapturedException(UndefVarError(Symbol(\"#rand2\"))\nStacktrace:\n[...]Process 1 knew about the function rand2, but process 2 did not.Most commonly you\'ll be loading code from files or packages, and you have a considerable amount of flexibility in controlling which processes load code. Consider a file, DummyModule.jl, containing the following code:module DummyModule\n\nexport MyType, f\n\nmutable struct MyType\n    a::Int\nend\n\nf(x) = x^2+1\n\nprintln(\"loaded\")\n\nendIn order to refer to MyType across all processes, DummyModule.jl needs to be loaded on every process.  Calling include(\"DummyModule.jl\") loads it only on a single process.  To load it on every process, use the @everywhere macro (starting Julia with julia -p 2):julia> @everywhere include(\"DummyModule.jl\")\nloaded\n      From worker 3:    loaded\n      From worker 2:    loadedAs usual, this does not bring DummyModule into scope on any of the process, which requires using or import.  Moreover, when DummyModule is brought into scope on one process, it is not on any other:julia> using .DummyModule\n\njulia> MyType(7)\nMyType(7)\n\njulia> fetch(@spawnat 2 MyType(7))\nERROR: On worker 2:\nUndefVarError: MyType not defined\n⋮\n\njulia> fetch(@spawnat 2 DummyModule.MyType(7))\nMyType(7)However, it\'s still possible, for instance, to send a MyType to a process which has loaded DummyModule even if it\'s not in scope:julia> put!(RemoteChannel(2), MyType(7))\nRemoteChannel{Channel{Any}}(2, 1, 13)A file can also be preloaded on multiple processes at startup with the -L flag, and a driver script can be used to drive the computation:julia -p <n> -L file1.jl -L file2.jl driver.jlThe Julia process running the driver script in the example above has an id equal to 1, just like a process providing an interactive prompt.Finally, if DummyModule.jl is not a standalone file but a package, then using DummyModule will load DummyModule.jl on all processes, but only bring it into scope on the process where using was called."
},

{
    "location": "manual/parallel-computing.html#Starting-and-managing-worker-processes-1",
    "page": "Parallel Computing",
    "title": "Starting and managing worker processes",
    "category": "section",
    "text": "The base Julia installation has in-built support for two types of clusters:A local cluster specified with the -p option as shown above.\nA cluster spanning machines using the --machine-file option. This uses a passwordless ssh login to start Julia worker processes (from the same path as the current host) on the specified machines.Functions addprocs, rmprocs, workers, and others are available as a programmatic means of adding, removing and querying the processes in a cluster.julia> using Distributed\n\njulia> addprocs(2)\n2-element Array{Int64,1}:\n 2\n 3Module Distributed must be explicitly loaded on the master process before invoking addprocs. It is automatically made available on the worker processes.Note that workers do not run a ~/.julia/config/startup.jl startup script, nor do they synchronize their global state (such as global variables, new method definitions, and loaded modules) with any of the other running processes.Other types of clusters can be supported by writing your own custom ClusterManager, as described below in the ClusterManagers section."
},

{
    "location": "manual/parallel-computing.html#Data-Movement-1",
    "page": "Parallel Computing",
    "title": "Data Movement",
    "category": "section",
    "text": "Sending messages and moving data constitute most of the overhead in a distributed program. Reducing the number of messages and the amount of data sent is critical to achieving performance and scalability. To this end, it is important to understand the data movement performed by Julia\'s various distributed programming constructs.fetch can be considered an explicit data movement operation, since it directly asks that an object be moved to the local machine. @spawn (and a few related constructs) also moves data, but this is not as obvious, hence it can be called an implicit data movement operation. Consider these two approaches to constructing and squaring a random matrix:Method 1:julia> A = rand(1000,1000);\n\njulia> Bref = @spawn A^2;\n\n[...]\n\njulia> fetch(Bref);Method 2:julia> Bref = @spawn rand(1000,1000)^2;\n\n[...]\n\njulia> fetch(Bref);The difference seems trivial, but in fact is quite significant due to the behavior of @spawn. In the first method, a random matrix is constructed locally, then sent to another process where it is squared. In the second method, a random matrix is both constructed and squared on another process. Therefore the second method sends much less data than the first.In this toy example, the two methods are easy to distinguish and choose from. However, in a real program designing data movement might require more thought and likely some measurement. For example, if the first process needs matrix A then the first method might be better. Or, if computing A is expensive and only the current process has it, then moving it to another process might be unavoidable. Or, if the current process has very little to do between the @spawn and fetch(Bref), it might be better to eliminate the parallelism altogether. Or imagine rand(1000,1000) is replaced with a more expensive operation. Then it might make sense to add another @spawn statement just for this step."
},

{
    "location": "manual/parallel-computing.html#Global-variables-1",
    "page": "Parallel Computing",
    "title": "Global variables",
    "category": "section",
    "text": "Expressions executed remotely via @spawn, or closures specified for remote execution using remotecall may refer to global variables. Global bindings under module Main are treated a little differently compared to global bindings in other modules. Consider the following code snippet:A = rand(10,10)\nremotecall_fetch(()->sum(A), 2)In this case sum MUST be defined in the remote process. Note that A is a global variable defined in the local workspace. Worker 2 does not have a variable called A under Main. The act of shipping the closure ()->sum(A) to worker 2 results in Main.A being defined on 2. Main.A continues to exist on worker 2 even after the call remotecall_fetch returns. Remote calls with embedded global references (under Main module only) manage globals as follows:New global bindings are created on destination workers if they are referenced as part of a remote call.\nGlobal constants are declared as constants on remote nodes too.\nGlobals are re-sent to a destination worker only in the context of a remote call, and then only if its value has changed. Also, the cluster does not synchronize global bindings across nodes. For example:\nA = rand(10,10)\nremotecall_fetch(()->sum(A), 2) # worker 2\nA = rand(10,10)\nremotecall_fetch(()->sum(A), 3) # worker 3\nA = nothing\nExecuting the above snippet results in Main.A on worker 2 having a different value from Main.A on worker 3, while the value of Main.A on node 1 is set to nothing.As you may have realized, while memory associated with globals may be collected when they are reassigned on the master, no such action is taken on the workers as the bindings continue to be valid. clear! can be used to manually reassign specific globals on remote nodes to nothing once they are no longer required. This will release any memory associated with them as part of a regular garbage collection cycle.Thus programs should be careful referencing globals in remote calls. In fact, it is preferable to avoid them altogether if possible. If you must reference globals, consider using let blocks to localize global variables.For example:julia> A = rand(10,10);\n\njulia> remotecall_fetch(()->A, 2);\n\njulia> B = rand(10,10);\n\njulia> let B = B\n           remotecall_fetch(()->B, 2)\n       end;\n\njulia> @fetchfrom 2 InteractiveUtils.varinfo()\nname           size summary\n––––––––– ––––––––– ––––––––––––––––––––––\nA         800 bytes 10×10 Array{Float64,2}\nBase                Module\nCore                Module\nMain                ModuleAs can be seen, global variable A is defined on worker 2, but B is captured as a local variable and hence a binding for B does not exist on worker 2."
},

{
    "location": "manual/parallel-computing.html#Parallel-Map-and-Loops-1",
    "page": "Parallel Computing",
    "title": "Parallel Map and Loops",
    "category": "section",
    "text": "Fortunately, many useful parallel computations do not require data movement. A common example is a Monte Carlo simulation, where multiple processes can handle independent simulation trials simultaneously. We can use @spawn to flip coins on two processes. First, write the following function in count_heads.jl:function count_heads(n)\n    c::Int = 0\n    for i = 1:n\n        c += rand(Bool)\n    end\n    c\nendThe function count_heads simply adds together n random bits. Here is how we can perform some trials on two machines, and add together the results:julia> @everywhere include_string(Main, $(read(\"count_heads.jl\", String)), \"count_heads.jl\")\n\njulia> a = @spawn count_heads(100000000)\nFuture(2, 1, 6, nothing)\n\njulia> b = @spawn count_heads(100000000)\nFuture(3, 1, 7, nothing)\n\njulia> fetch(a)+fetch(b)\n100001564This example demonstrates a powerful and often-used parallel programming pattern. Many iterations run independently over several processes, and then their results are combined using some function. The combination process is called a reduction, since it is generally tensor-rank-reducing: a vector of numbers is reduced to a single number, or a matrix is reduced to a single row or column, etc. In code, this typically looks like the pattern x = f(x,v[i]), where x is the accumulator, f is the reduction function, and the v[i] are the elements being reduced. It is desirable for f to be associative, so that it does not matter what order the operations are performed in.Notice that our use of this pattern with count_heads can be generalized. We used two explicit @spawn statements, which limits the parallelism to two processes. To run on any number of processes, we can use a parallel for loop, running in distributed memory, which can be written in Julia using @distributed like this:nheads = @distributed (+) for i = 1:200000000\n    Int(rand(Bool))\nendThis construct implements the pattern of assigning iterations to multiple processes, and combining them with a specified reduction (in this case (+)). The result of each iteration is taken as the value of the last expression inside the loop. The whole parallel loop expression itself evaluates to the final answer.Note that although parallel for loops look like serial for loops, their behavior is dramatically different. In particular, the iterations do not happen in a specified order, and writes to variables or arrays will not be globally visible since iterations run on different processes. Any variables used inside the parallel loop will be copied and broadcast to each process.For example, the following code will not work as intended:a = zeros(100000)\n@distributed for i = 1:100000\n    a[i] = i\nendThis code will not initialize all of a, since each process will have a separate copy of it. Parallel for loops like these must be avoided. Fortunately, Shared Arrays can be used to get around this limitation:using SharedArrays\n\na = SharedArray{Float64}(10)\n@distributed for i = 1:10\n    a[i] = i\nendUsing \"outside\" variables in parallel loops is perfectly reasonable if the variables are read-only:a = randn(1000)\n@distributed (+) for i = 1:100000\n    f(a[rand(1:end)])\nendHere each iteration applies f to a randomly-chosen sample from a vector a shared by all processes.As you could see, the reduction operator can be omitted if it is not needed. In that case, the loop executes asynchronously, i.e. it spawns independent tasks on all available workers and returns an array of Future immediately without waiting for completion. The caller can wait for the Future completions at a later point by calling fetch on them, or wait for completion at the end of the loop by prefixing it with @sync, like @sync @distributed for.In some cases no reduction operator is needed, and we merely wish to apply a function to all integers in some range (or, more generally, to all elements in some collection). This is another useful operation called parallel map, implemented in Julia as the pmap function. For example, we could compute the singular values of several large random matrices in parallel as follows:julia> M = Matrix{Float64}[rand(1000,1000) for i = 1:10];\n\njulia> pmap(svdvals, M);Julia\'s pmap is designed for the case where each function call does a large amount of work. In contrast, @distributed for can handle situations where each iteration is tiny, perhaps merely summing two numbers. Only worker processes are used by both pmap and @distributed for for the parallel computation. In case of @distributed for, the final reduction is done on the calling process."
},

{
    "location": "manual/parallel-computing.html#Remote-References-and-AbstractChannels-1",
    "page": "Parallel Computing",
    "title": "Remote References and AbstractChannels",
    "category": "section",
    "text": "Remote references always refer to an implementation of an AbstractChannel.A concrete implementation of an AbstractChannel (like Channel), is required to implement put!, take!, fetch, isready and wait. The remote object referred to by a Future is stored in a Channel{Any}(1), i.e., a Channel of size 1 capable of holding objects of Any type.RemoteChannel, which is rewritable, can point to any type and size of channels, or any other implementation of an AbstractChannel.The constructor RemoteChannel(f::Function, pid)() allows us to construct references to channels holding more than one value of a specific type. f is a function executed on pid and it must return an AbstractChannel.For example, RemoteChannel(()->Channel{Int}(10), pid), will return a reference to a channel of type Int and size 10. The channel exists on worker pid.Methods put!, take!, fetch, isready and wait on a RemoteChannel are proxied onto the backing store on the remote process.RemoteChannel can thus be used to refer to user implemented AbstractChannel objects. A simple example of this is provided in dictchannel.jl in the Examples repository, which uses a dictionary as its remote store."
},

{
    "location": "manual/parallel-computing.html#Channels-and-RemoteChannels-1",
    "page": "Parallel Computing",
    "title": "Channels and RemoteChannels",
    "category": "section",
    "text": "A Channel is local to a process. Worker 2 cannot directly refer to a Channel on worker 3 and vice-versa. A RemoteChannel, however, can put and take values across workers.\nA RemoteChannel can be thought of as a handle to a Channel.\nThe process id, pid, associated with a RemoteChannel identifies the process where the backing store, i.e., the backing Channel exists.\nAny process with a reference to a RemoteChannel can put and take items from the channel. Data is automatically sent to (or retrieved from) the process a RemoteChannel is associated with.\nSerializing  a Channel also serializes any data present in the channel. Deserializing it therefore effectively makes a copy of the original object.\nOn the other hand, serializing a RemoteChannel only involves the serialization of an identifier that identifies the location and instance of Channel referred to by the handle. A deserialized RemoteChannel object (on any worker), therefore also points to the same backing store as the original.The channels example from above can be modified for interprocess communication, as shown below.We start 4 workers to process a single jobs remote channel. Jobs, identified by an id (job_id), are written to the channel. Each remotely executing task in this simulation reads a job_id, waits for a random amount of time and writes back a tuple of job_id, time taken and its own pid to the results channel. Finally all the results are printed out on the master process.julia> addprocs(4); # add worker processes\n\njulia> const jobs = RemoteChannel(()->Channel{Int}(32));\n\njulia> const results = RemoteChannel(()->Channel{Tuple}(32));\n\njulia> @everywhere function do_work(jobs, results) # define work function everywhere\n           while true\n               job_id = take!(jobs)\n               exec_time = rand()\n               sleep(exec_time) # simulates elapsed time doing actual work\n               put!(results, (job_id, exec_time, myid()))\n           end\n       end\n\njulia> function make_jobs(n)\n           for i in 1:n\n               put!(jobs, i)\n           end\n       end;\n\njulia> n = 12;\n\njulia> @async make_jobs(n); # feed the jobs channel with \"n\" jobs\n\njulia> for p in workers() # start tasks on the workers to process requests in parallel\n           remote_do(do_work, p, jobs, results)\n       end\n\njulia> @elapsed while n > 0 # print out results\n           job_id, exec_time, where = take!(results)\n           println(\"$job_id finished in $(round(exec_time; digits=2)) seconds on worker $where\")\n           global n = n - 1\n       end\n1 finished in 0.18 seconds on worker 4\n2 finished in 0.26 seconds on worker 5\n6 finished in 0.12 seconds on worker 4\n7 finished in 0.18 seconds on worker 4\n5 finished in 0.35 seconds on worker 5\n4 finished in 0.68 seconds on worker 2\n3 finished in 0.73 seconds on worker 3\n11 finished in 0.01 seconds on worker 3\n12 finished in 0.02 seconds on worker 3\n9 finished in 0.26 seconds on worker 5\n8 finished in 0.57 seconds on worker 4\n10 finished in 0.58 seconds on worker 2\n0.055971741"
},

{
    "location": "manual/parallel-computing.html#Remote-References-and-Distributed-Garbage-Collection-1",
    "page": "Parallel Computing",
    "title": "Remote References and Distributed Garbage Collection",
    "category": "section",
    "text": "Objects referred to by remote references can be freed only when all held references in the cluster are deleted.The node where the value is stored keeps track of which of the workers have a reference to it. Every time a RemoteChannel or a (unfetched) Future is serialized to a worker, the node pointed to by the reference is notified. And every time a RemoteChannel or a (unfetched) Future is garbage collected locally, the node owning the value is again notified. This is implemented in an internal cluster aware serializer. Remote references are only valid in the context of a running cluster. Serializing and deserializing references to and from regular IO objects is not supported.The notifications are done via sending of \"tracking\" messages–an \"add reference\" message when a reference is serialized to a different process and a \"delete reference\" message when a reference is locally garbage collected.Since Futures are write-once and cached locally, the act of fetching a Future also updates reference tracking information on the node owning the value.The node which owns the value frees it once all references to it are cleared.With Futures, serializing an already fetched Future to a different node also sends the value since the original remote store may have collected the value by this time.It is important to note that when an object is locally garbage collected depends on the size of the object and the current memory pressure in the system.In case of remote references, the size of the local reference object is quite small, while the value stored on the remote node may be quite large. Since the local object may not be collected immediately, it is a good practice to explicitly call finalize on local instances of a RemoteChannel, or on unfetched Futures. Since calling fetch on a Future also removes its reference from the remote store, this is not required on fetched Futures. Explicitly calling finalize results in an immediate message sent to the remote node to go ahead and remove its reference to the value.Once finalized, a reference becomes invalid and cannot be used in any further calls."
},

{
    "location": "manual/parallel-computing.html#man-shared-arrays-1",
    "page": "Parallel Computing",
    "title": "Shared Arrays",
    "category": "section",
    "text": "Shared Arrays use system shared memory to map the same array across many processes. While there are some similarities to a DArray, the behavior of a SharedArray is quite different. In a DArray, each process has local access to just a chunk of the data, and no two processes share the same chunk; in contrast, in a SharedArray each \"participating\" process has access to the entire array.  A SharedArray is a good choice when you want to have a large amount of data jointly accessible to two or more processes on the same machine.Shared Array support is available via module SharedArrays which must be explicitly loaded on all participating workers.SharedArray indexing (assignment and accessing values) works just as with regular arrays, and is efficient because the underlying memory is available to the local process. Therefore, most algorithms work naturally on SharedArrays, albeit in single-process mode. In cases where an algorithm insists on an Array input, the underlying array can be retrieved from a SharedArray by calling sdata. For other AbstractArray types, sdata just returns the object itself, so it\'s safe to use sdata on any Array-type object.The constructor for a shared array is of the form:SharedArray{T,N}(dims::NTuple; init=false, pids=Int[])which creates an N-dimensional shared array of a bits type T and size dims across the processes specified by pids. Unlike distributed arrays, a shared array is accessible only from those participating workers specified by the pids named argument (and the creating process too, if it is on the same host).If an init function, of signature initfn(S::SharedArray), is specified, it is called on all the participating workers. You can specify that each worker runs the init function on a distinct portion of the array, thereby parallelizing initialization.Here\'s a brief example:julia> using Distributed\n\njulia> addprocs(3)\n3-element Array{Int64,1}:\n 2\n 3\n 4\n\njulia> @everywhere using SharedArrays\n\njulia> S = SharedArray{Int,2}((3,4), init = S -> S[localindices(S)] = myid())\n3×4 SharedArray{Int64,2}:\n 2  2  3  4\n 2  3  3  4\n 2  3  4  4\n\njulia> S[3,2] = 7\n7\n\njulia> S\n3×4 SharedArray{Int64,2}:\n 2  2  3  4\n 2  3  3  4\n 2  7  4  4SharedArrays.localindices provides disjoint one-dimensional ranges of indices, and is sometimes convenient for splitting up tasks among processes. You can, of course, divide the work any way you wish:julia> S = SharedArray{Int,2}((3,4), init = S -> S[indexpids(S):length(procs(S)):length(S)] = myid())\n3×4 SharedArray{Int64,2}:\n 2  2  2  2\n 3  3  3  3\n 4  4  4  4Since all processes have access to the underlying data, you do have to be careful not to set up conflicts. For example:@sync begin\n    for p in procs(S)\n        @async begin\n            remotecall_wait(fill!, p, S, p)\n        end\n    end\nendwould result in undefined behavior. Because each process fills the entire array with its own pid, whichever process is the last to execute (for any particular element of S) will have its pid retained.As a more extended and complex example, consider running the following \"kernel\" in parallel:q[i,j,t+1] = q[i,j,t] + u[i,j,t]In this case, if we try to split up the work using a one-dimensional index, we are likely to run into trouble: if q[i,j,t] is near the end of the block assigned to one worker and q[i,j,t+1] is near the beginning of the block assigned to another, it\'s very likely that q[i,j,t] will not be ready at the time it\'s needed for computing q[i,j,t+1]. In such cases, one is better off chunking the array manually. Let\'s split along the second dimension. Define a function that returns the (irange, jrange) indices assigned to this worker:julia> @everywhere function myrange(q::SharedArray)\n           idx = indexpids(q)\n           if idx == 0 # This worker is not assigned a piece\n               return 1:0, 1:0\n           end\n           nchunks = length(procs(q))\n           splits = [round(Int, s) for s in range(0, stop=size(q,2), length=nchunks+1)]\n           1:size(q,1), splits[idx]+1:splits[idx+1]\n       endNext, define the kernel:julia> @everywhere function advection_chunk!(q, u, irange, jrange, trange)\n           @show (irange, jrange, trange)  # display so we can see what\'s happening\n           for t in trange, j in jrange, i in irange\n               q[i,j,t+1] = q[i,j,t] + u[i,j,t]\n           end\n           q\n       endWe also define a convenience wrapper for a SharedArray implementationjulia> @everywhere advection_shared_chunk!(q, u) =\n           advection_chunk!(q, u, myrange(q)..., 1:size(q,3)-1)Now let\'s compare three different versions, one that runs in a single process:julia> advection_serial!(q, u) = advection_chunk!(q, u, 1:size(q,1), 1:size(q,2), 1:size(q,3)-1);one that uses @distributed:julia> function advection_parallel!(q, u)\n           for t = 1:size(q,3)-1\n               @sync @distributed for j = 1:size(q,2)\n                   for i = 1:size(q,1)\n                       q[i,j,t+1]= q[i,j,t] + u[i,j,t]\n                   end\n               end\n           end\n           q\n       end;and one that delegates in chunks:julia> function advection_shared!(q, u)\n           @sync begin\n               for p in procs(q)\n                   @async remotecall_wait(advection_shared_chunk!, p, q, u)\n               end\n           end\n           q\n       end;If we create SharedArrays and time these functions, we get the following results (with julia -p 4):julia> q = SharedArray{Float64,3}((500,500,500));\n\njulia> u = SharedArray{Float64,3}((500,500,500));Run the functions once to JIT-compile and @time them on the second run:julia> @time advection_serial!(q, u);\n(irange,jrange,trange) = (1:500,1:500,1:499)\n 830.220 milliseconds (216 allocations: 13820 bytes)\n\njulia> @time advection_parallel!(q, u);\n   2.495 seconds      (3999 k allocations: 289 MB, 2.09% gc time)\n\njulia> @time advection_shared!(q,u);\n        From worker 2:       (irange,jrange,trange) = (1:500,1:125,1:499)\n        From worker 4:       (irange,jrange,trange) = (1:500,251:375,1:499)\n        From worker 3:       (irange,jrange,trange) = (1:500,126:250,1:499)\n        From worker 5:       (irange,jrange,trange) = (1:500,376:500,1:499)\n 238.119 milliseconds (2264 allocations: 169 KB)The biggest advantage of advection_shared! is that it minimizes traffic among the workers, allowing each to compute for an extended time on the assigned piece."
},

{
    "location": "manual/parallel-computing.html#Shared-Arrays-and-Distributed-Garbage-Collection-1",
    "page": "Parallel Computing",
    "title": "Shared Arrays and Distributed Garbage Collection",
    "category": "section",
    "text": "Like remote references, shared arrays are also dependent on garbage collection on the creating node to release references from all participating workers. Code which creates many short lived shared array objects would benefit from explicitly finalizing these objects as soon as possible. This results in both memory and file handles mapping the shared segment being released sooner."
},

{
    "location": "manual/parallel-computing.html#ClusterManagers-1",
    "page": "Parallel Computing",
    "title": "ClusterManagers",
    "category": "section",
    "text": "The launching, management and networking of Julia processes into a logical cluster is done via cluster managers. A ClusterManager is responsible forlaunching worker processes in a cluster environment\nmanaging events during the lifetime of each worker\noptionally, providing data transportA Julia cluster has the following characteristics:The initial Julia process, also called the master, is special and has an id of 1.\nOnly the master process can add or remove worker processes.\nAll processes can directly communicate with each other.Connections between workers (using the in-built TCP/IP transport) is established in the following manner:addprocs is called on the master process with a ClusterManager object.\naddprocs calls the appropriate launch method which spawns required number of worker processes on appropriate machines.\nEach worker starts listening on a free port and writes out its host and port information to stdout.\nThe cluster manager captures the stdout of each worker and makes it available to the master process.\nThe master process parses this information and sets up TCP/IP connections to each worker.\nEvery worker is also notified of other workers in the cluster.\nEach worker connects to all workers whose id is less than the worker\'s own id.\nIn this way a mesh network is established, wherein every worker is directly connected with every other worker.While the default transport layer uses plain TCPSocket, it is possible for a Julia cluster to provide its own transport.Julia provides two in-built cluster managers:LocalManager, used when addprocs() or addprocs(np::Integer) are called\nSSHManager, used when addprocs(hostnames::Array) is called with a list of hostnamesLocalManager is used to launch additional workers on the same host, thereby leveraging multi-core and multi-processor hardware.Thus, a minimal cluster manager would need to:be a subtype of the abstract ClusterManager\nimplement launch, a method responsible for launching new workers\nimplement manage, which is called at various events during a worker\'s lifetime (for example, sending an interrupt signal)addprocs(manager::FooManager) requires FooManager to implement:function launch(manager::FooManager, params::Dict, launched::Array, c::Condition)\n    [...]\nend\n\nfunction manage(manager::FooManager, id::Integer, config::WorkerConfig, op::Symbol)\n    [...]\nendAs an example let us see how the LocalManager, the manager responsible for starting workers on the same host, is implemented:struct LocalManager <: ClusterManager\n    np::Integer\nend\n\nfunction launch(manager::LocalManager, params::Dict, launched::Array, c::Condition)\n    [...]\nend\n\nfunction manage(manager::LocalManager, id::Integer, config::WorkerConfig, op::Symbol)\n    [...]\nendThe launch method takes the following arguments:manager::ClusterManager: the cluster manager that addprocs is called with\nparams::Dict: all the keyword arguments passed to addprocs\nlaunched::Array: the array to append one or more WorkerConfig objects to\nc::Condition: the condition variable to be notified as and when workers are launchedThe launch method is called asynchronously in a separate task. The termination of this task signals that all requested workers have been launched. Hence the launch function MUST exit as soon as all the requested workers have been launched.Newly launched workers are connected to each other and the master process in an all-to-all manner. Specifying the command line argument --worker[=<cookie>] results in the launched processes initializing themselves as workers and connections being set up via TCP/IP sockets.All workers in a cluster share the same cookie as the master. When the cookie is unspecified, i.e, with the --worker option, the worker tries to read it from its standard input.  LocalManager and SSHManager both pass the cookie to newly launched workers via their  standard inputs.By default a worker will listen on a free port at the address returned by a call to getipaddr(). A specific address to listen on may be specified by optional argument --bind-to bind_addr[:port]. This is useful for multi-homed hosts.As an example of a non-TCP/IP transport, an implementation may choose to use MPI, in which case --worker must NOT be specified. Instead, newly launched workers should call init_worker(cookie) before using any of the parallel constructs.For every worker launched, the launch method must add a WorkerConfig object (with appropriate fields initialized) to launchedmutable struct WorkerConfig\n    # Common fields relevant to all cluster managers\n    io::Union{IO, Nothing}\n    host::Union{AbstractString, Nothing}\n    port::Union{Integer, Nothing}\n\n    # Used when launching additional workers at a host\n    count::Union{Int, Symbol, Nothing}\n    exename::Union{AbstractString, Cmd, Nothing}\n    exeflags::Union{Cmd, Nothing}\n\n    # External cluster managers can use this to store information at a per-worker level\n    # Can be a dict if multiple fields need to be stored.\n    userdata::Any\n\n    # SSHManager / SSH tunnel connections to workers\n    tunnel::Union{Bool, Nothing}\n    bind_addr::Union{AbstractString, Nothing}\n    sshflags::Union{Cmd, Nothing}\n    max_parallel::Union{Integer, Nothing}\n\n    # Used by Local/SSH managers\n    connect_at::Any\n\n    [...]\nendMost of the fields in WorkerConfig are used by the inbuilt managers. Custom cluster managers would typically specify only io or host / port:If io is specified, it is used to read host/port information. A Julia worker prints out its bind address and port at startup. This allows Julia workers to listen on any free port available instead of requiring worker ports to be configured manually.\nIf io is not specified, host and port are used to connect.\ncount, exename and exeflags are relevant for launching additional workers from a worker. For example, a cluster manager may launch a single worker per node, and use that to launch additional workers.\ncount with an integer value n will launch a total of n workers.\ncount with a value of :auto will launch as many workers as the number of CPU threads (logical cores) on that machine.\nexename is the name of the julia executable including the full path.\nexeflags should be set to the required command line arguments for new workers.\ntunnel, bind_addr, sshflags and max_parallel are used when a ssh tunnel is required to connect to the workers from the master process.\nuserdata is provided for custom cluster managers to store their own worker-specific information.manage(manager::FooManager, id::Integer, config::WorkerConfig, op::Symbol) is called at different times during the worker\'s lifetime with appropriate op values:with :register/:deregister when a worker is added / removed from the Julia worker pool.\nwith :interrupt when interrupt(workers) is called. The ClusterManager should signal the appropriate worker with an interrupt signal.\nwith :finalize for cleanup purposes."
},

{
    "location": "manual/parallel-computing.html#Cluster-Managers-with-Custom-Transports-1",
    "page": "Parallel Computing",
    "title": "Cluster Managers with Custom Transports",
    "category": "section",
    "text": "Replacing the default TCP/IP all-to-all socket connections with a custom transport layer is a little more involved. Each Julia process has as many communication tasks as the workers it is connected to. For example, consider a Julia cluster of 32 processes in an all-to-all mesh network:Each Julia process thus has 31 communication tasks.\nEach task handles all incoming messages from a single remote worker in a message-processing loop.\nThe message-processing loop waits on an IO object (for example, a TCPSocket in the default implementation), reads an entire message, processes it and waits for the next one.\nSending messages to a process is done directly from any Julia task–not just communication tasks–again, via the appropriate IO object.Replacing the default transport requires the new implementation to set up connections to remote workers and to provide appropriate IO objects that the message-processing loops can wait on. The manager-specific callbacks to be implemented are:connect(manager::FooManager, pid::Integer, config::WorkerConfig)\nkill(manager::FooManager, pid::Int, config::WorkerConfig)The default implementation (which uses TCP/IP sockets) is implemented as connect(manager::ClusterManager, pid::Integer, config::WorkerConfig).connect should return a pair of IO objects, one for reading data sent from worker pid, and the other to write data that needs to be sent to worker pid. Custom cluster managers can use an in-memory BufferStream as the plumbing to proxy data between the custom, possibly non-IO transport and Julia\'s in-built parallel infrastructure.A BufferStream is an in-memory IOBuffer which behaves like an IO–it is a stream which can be handled asynchronously.The folder clustermanager/0mq in the Examples repository contains an example of using ZeroMQ to connect Julia workers in a star topology with a 0MQ broker in the middle. Note: The Julia processes are still all logically connected to each other–any worker can message any other worker directly without any awareness of 0MQ being used as the transport layer.When using custom transports:Julia workers must NOT be started with --worker. Starting with --worker will result in the newly launched workers defaulting to the TCP/IP socket transport implementation.\nFor every incoming logical connection with a worker, Base.process_messages(rd::IO, wr::IO)() must be called. This launches a new task that handles reading and writing of messages from/to the worker represented by the IO objects.\ninit_worker(cookie, manager::FooManager) must be called as part of worker process initialization.\nField connect_at::Any in WorkerConfig can be set by the cluster manager when launch is called. The value of this field is passed in in all connect callbacks. Typically, it carries information on how to connect to a worker. For example, the TCP/IP socket transport uses this field to specify the (host, port) tuple at which to connect to a worker.kill(manager, pid, config) is called to remove a worker from the cluster. On the master process, the corresponding IO objects must be closed by the implementation to ensure proper cleanup. The default implementation simply executes an exit() call on the specified remote worker.The Examples folder clustermanager/simple is an example that shows a simple implementation using UNIX domain sockets for cluster setup."
},

{
    "location": "manual/parallel-computing.html#Network-Requirements-for-LocalManager-and-SSHManager-1",
    "page": "Parallel Computing",
    "title": "Network Requirements for LocalManager and SSHManager",
    "category": "section",
    "text": "Julia clusters are designed to be executed on already secured environments on infrastructure such as local laptops, departmental clusters, or even the cloud. This section covers network security requirements for the inbuilt LocalManager and SSHManager:The master process does not listen on any port. It only connects out to the workers.\nEach worker binds to only one of the local interfaces and listens on an ephemeral port number assigned by the OS.\nLocalManager, used by addprocs(N), by default binds only to the loopback interface. This means that workers started later on remote hosts (or by anyone with malicious intentions) are unable to connect to the cluster. An addprocs(4) followed by an addprocs([\"remote_host\"]) will fail. Some users may need to create a cluster comprising their local system and a few remote systems. This can be done by explicitly requesting LocalManager to bind to an external network interface via the restrict keyword argument: addprocs(4; restrict=false).\nSSHManager, used by addprocs(list_of_remote_hosts), launches workers on remote hosts via SSH. By default SSH is only used to launch Julia workers. Subsequent master-worker and worker-worker connections use plain, unencrypted TCP/IP sockets. The remote hosts must have passwordless login enabled. Additional SSH flags or credentials may be specified via keyword argument sshflags.\naddprocs(list_of_remote_hosts; tunnel=true, sshflags=<ssh keys and other flags>) is useful when we wish to use SSH connections for master-worker too. A typical scenario for this is a local laptop running the Julia REPL (i.e., the master) with the rest of the cluster on the cloud, say on Amazon EC2. In this case only port 22 needs to be opened at the remote cluster coupled with SSH client authenticated via public key infrastructure (PKI). Authentication credentials can be supplied via sshflags, for example sshflags=`-i <keyfile>`.\nIn an all-to-all topology (the default), all workers connect to each other via plain TCP sockets. The security policy on the cluster nodes must thus ensure free connectivity between workers for the ephemeral port range (varies by OS).\nSecuring and encrypting all worker-worker traffic (via SSH) or encrypting individual messages can be done via a custom ClusterManager."
},

{
    "location": "manual/parallel-computing.html#man-cluster-cookie-1",
    "page": "Parallel Computing",
    "title": "Cluster Cookie",
    "category": "section",
    "text": "All processes in a cluster share the same cookie which, by default, is a randomly generated string on the master process:cluster_cookie() returns the cookie, while cluster_cookie(cookie)() sets it and returns the new cookie.\nAll connections are authenticated on both sides to ensure that only workers started by the master are allowed to connect to each other.\nThe cookie may be passed to the workers at startup via argument --worker=<cookie>. If argument --worker is specified without the cookie, the worker tries to read the cookie from its standard input (stdin). The stdin is closed immediately after the cookie is retrieved.\nClusterManagers can retrieve the cookie on the master by calling cluster_cookie(). Cluster managers not using the default TCP/IP transport (and hence not specifying --worker) must call init_worker(cookie, manager) with the same cookie as on the master.Note that environments requiring higher levels of security can implement this via a custom ClusterManager. For example, cookies can be pre-shared and hence not specified as a startup argument."
},

{
    "location": "manual/parallel-computing.html#Specifying-Network-Topology-(Experimental)-1",
    "page": "Parallel Computing",
    "title": "Specifying Network Topology (Experimental)",
    "category": "section",
    "text": "The keyword argument topology passed to addprocs is used to specify how the workers must be connected to each other::all_to_all, the default: all workers are connected to each other.\n:master_worker: only the driver process, i.e. pid 1, has connections to the workers.\n:custom: the launch method of the cluster manager specifies the connection topology via the fields ident and connect_idents in WorkerConfig. A worker with a cluster-manager-provided identity ident will connect to all workers specified in connect_idents.Keyword argument lazy=true|false only affects topology option :all_to_all. If true, the cluster starts off with the master connected to all workers. Specific worker-worker connections are established at the first remote invocation between two workers. This helps in reducing initial resources allocated for intra-cluster communication. Connections are setup depending on the runtime requirements of a parallel program. Default value for lazy is true.Currently, sending a message between unconnected workers results in an error. This behaviour, as with the functionality and interface, should be considered experimental in nature and may change in future releases."
},

{
    "location": "manual/parallel-computing.html#Noteworthy-external-packages-1",
    "page": "Parallel Computing",
    "title": "Noteworthy external packages",
    "category": "section",
    "text": "Outside of Julia parallelism there are plenty of external packages that should be mentioned. For example MPI.jl is a Julia wrapper for the MPI protocol, or DistributedArrays.jl, as presented in Shared Arrays. A mention must be made of Julia\'s GPU programming ecosystem, which includes:Low-level (C kernel) based operations OpenCL.jl and CUDAdrv.jl which are respectively an OpenCL interface and a CUDA wrapper.\nLow-level (Julia Kernel) interfaces like CUDAnative.jl which is a Julia native CUDA implementation.\nHigh-level vendor-specific abstractions like CuArrays.jl and CLArrays.jl\nHigh-level libraries like ArrayFire.jl and GPUArrays.jlIn the following example we will use both DistributedArrays.jl and CuArrays.jl to distribute an array across multiple processes by first casting it through distribute() and CuArray().Remember when importing DistributedArrays.jl to import it across all processes using @everywhere$ ./julia -p 4\n\njulia> addprocs()\n\njulia> @everywhere using DistributedArrays\n\njulia> using CuArrays\n\njulia> B = ones(10_000) ./ 2;\n\njulia> A = ones(10_000) .* π;\n\njulia> C = 2 .* A ./ B;\n\njulia> all(C .≈ 4*π)\ntrue\n\njulia> typeof(C)\nArray{Float64,1}\n\njulia> dB = distribute(B);\n\njulia> dA = distribute(A);\n\njulia> dC = 2 .* dA ./ dB;\n\njulia> all(dC .≈ 4*π)\ntrue\n\njulia> typeof(dC)\nDistributedArrays.DArray{Float64,1,Array{Float64,1}}\n\njulia> cuB = CuArray(B);\n\njulia> cuA = CuArray(A);\n\njulia> cuC = 2 .* cuA ./ cuB;\n\njulia> all(cuC .≈ 4*π);\ntrue\n\njulia> typeof(cuC)\nCuArray{Float64,1}Keep in mind that some Julia features are not currently supported by CUDAnative.jl [2] , especially some functions like sin will need to be replaced with CUDAnative.sin(cc: @maleadt).In the following example we will use both DistributedArrays.jl and CuArrays.jl to distribute an array across multiple processes and call a generic function on it.function power_method(M, v)\n    for i in 1:100\n        v = M*v\n        v /= norm(v)\n    end\n\n    return v, norm(M*v) / norm(v)  # or  (M*v) ./ v\nendpower_method repeatedly creates a new vector and normalizes it. We have not specified any type signature in function declaration, let\'s see if it works with the aforementioned datatypes:julia> M = [2. 1; 1 1];\n\njulia> v = rand(2)\n2-element Array{Float64,1}:\n0.40395\n0.445877\n\njulia> power_method(M,v)\n([0.850651, 0.525731], 2.618033988749895)\n\njulia> cuM = CuArray(M);\n\njulia> cuv = CuArray(v);\n\njulia> curesult = power_method(cuM, cuv);\n\njulia> typeof(curesult)\nCuArray{Float64,1}\n\njulia> dM = distribute(M);\n\njulia> dv = distribute(v);\n\njulia> dC = power_method(dM, dv);\n\njulia> typeof(dC)\nTuple{DistributedArrays.DArray{Float64,1,Array{Float64,1}},Float64}To end this short exposure to external packages, we can consider MPI.jl, a Julia wrapper of the MPI protocol. As it would take too long to consider every inner function, it would be better to simply appreciate the approach used to implement the protocol.Consider this toy script which simply calls each subprocess, instantiate its rank and when the master process is reached, performs the ranks\' sumimport MPI\n\nMPI.Init()\n\ncomm = MPI.COMM_WORLD\nMPI.Barrier(comm)\n\nroot = 0\nr = MPI.Comm_rank(comm)\n\nsr = MPI.Reduce(r, MPI.SUM, root, comm)\n\nif(MPI.Comm_rank(comm) == root)\n   @printf(\"sum of ranks: %s\\n\", sr)\nend\n\nMPI.Finalize()mpirun -np 4 ./julia example.jl[1]: In this context, MPI refers to the MPI-1 standard. Beginning with MPI-2, the MPI standards committee introduced a new set of communication mechanisms, collectively referred to as Remote Memory Access (RMA). The motivation for adding rma to the MPI standard was to facilitate one-sided communication patterns. For additional information on the latest MPI standard, see https://mpi-forum.org/docs.[2]: Julia GPU man pages"
},

{
    "location": "manual/running-external-programs.html#",
    "page": "Running External Programs",
    "title": "Running External Programs",
    "category": "page",
    "text": ""
},

{
    "location": "manual/running-external-programs.html#Running-External-Programs-1",
    "page": "Running External Programs",
    "title": "Running External Programs",
    "category": "section",
    "text": "Julia borrows backtick notation for commands from the shell, Perl, and Ruby. However, in Julia, writingjulia> `echo hello`\n`echo hello`differs in several aspects from the behavior in various shells, Perl, or Ruby:Instead of immediately running the command, backticks create a Cmd object to represent the command. You can use this object to connect the command to others via pipes, run it, and read or write to it.\nWhen the command is run, Julia does not capture its output unless you specifically arrange for it to. Instead, the output of the command by default goes to stdout as it would using libc\'s system call.\nThe command is never run with a shell. Instead, Julia parses the command syntax directly, appropriately interpolating variables and splitting on words as the shell would, respecting shell quoting syntax. The command is run as julia\'s immediate child process, using fork and exec calls.Here\'s a simple example of running an external program:julia> mycommand = `echo hello`\n`echo hello`\n\njulia> typeof(mycommand)\nCmd\n\njulia> run(mycommand);\nhelloThe hello is the output of the echo command, sent to stdout. The run method itself returns nothing, and throws an ErrorException if the external command fails to run successfully.If you want to read the output of the external command, read can be used instead:julia> a = read(`echo hello`, String)\n\"hello\\n\"\n\njulia> chomp(a) == \"hello\"\ntrueMore generally, you can use open to read from or write to an external command.julia> open(`less`, \"w\", stdout) do io\n           for i = 1:3\n               println(io, i)\n           end\n       end\n1\n2\n3The program name and the individual arguments in a command can be accessed and iterated over as if the command were an array of strings:julia> collect(`echo \"foo bar\"`)\n2-element Array{String,1}:\n \"echo\"\n \"foo bar\"\n\njulia> `echo \"foo bar\"`[2]\n\"foo bar\""
},

{
    "location": "manual/running-external-programs.html#command-interpolation-1",
    "page": "Running External Programs",
    "title": "Interpolation",
    "category": "section",
    "text": "Suppose you want to do something a bit more complicated and use the name of a file in the variable file as an argument to a command. You can use $ for interpolation much as you would in a string literal (see Strings):julia> file = \"/etc/passwd\"\n\"/etc/passwd\"\n\njulia> `sort $file`\n`sort /etc/passwd`A common pitfall when running external programs via a shell is that if a file name contains characters that are special to the shell, they may cause undesirable behavior. Suppose, for example, rather than /etc/passwd, we wanted to sort the contents of the file /Volumes/External HD/data.csv. Let\'s try it:julia> file = \"/Volumes/External HD/data.csv\"\n\"/Volumes/External HD/data.csv\"\n\njulia> `sort $file`\n`sort \'/Volumes/External HD/data.csv\'`How did the file name get quoted? Julia knows that file is meant to be interpolated as a single argument, so it quotes the word for you. Actually, that is not quite accurate: the value of file is never interpreted by a shell, so there\'s no need for actual quoting; the quotes are inserted only for presentation to the user. This will even work if you interpolate a value as part of a shell word:julia> path = \"/Volumes/External HD\"\n\"/Volumes/External HD\"\n\njulia> name = \"data\"\n\"data\"\n\njulia> ext = \"csv\"\n\"csv\"\n\njulia> `sort $path/$name.$ext`\n`sort \'/Volumes/External HD/data.csv\'`As you can see, the space in the path variable is appropriately escaped. But what if you want to interpolate multiple words? In that case, just use an array (or any other iterable container):julia> files = [\"/etc/passwd\",\"/Volumes/External HD/data.csv\"]\n2-element Array{String,1}:\n \"/etc/passwd\"\n \"/Volumes/External HD/data.csv\"\n\njulia> `grep foo $files`\n`grep foo /etc/passwd \'/Volumes/External HD/data.csv\'`If you interpolate an array as part of a shell word, Julia emulates the shell\'s {a,b,c} argument generation:julia> names = [\"foo\",\"bar\",\"baz\"]\n3-element Array{String,1}:\n \"foo\"\n \"bar\"\n \"baz\"\n\njulia> `grep xylophone $names.txt`\n`grep xylophone foo.txt bar.txt baz.txt`Moreover, if you interpolate multiple arrays into the same word, the shell\'s Cartesian product generation behavior is emulated:julia> names = [\"foo\",\"bar\",\"baz\"]\n3-element Array{String,1}:\n \"foo\"\n \"bar\"\n \"baz\"\n\njulia> exts = [\"aux\",\"log\"]\n2-element Array{String,1}:\n \"aux\"\n \"log\"\n\njulia> `rm -f $names.$exts`\n`rm -f foo.aux foo.log bar.aux bar.log baz.aux baz.log`Since you can interpolate literal arrays, you can use this generative functionality without needing to create temporary array objects first:julia> `rm -rf $[\"foo\",\"bar\",\"baz\",\"qux\"].$[\"aux\",\"log\",\"pdf\"]`\n`rm -rf foo.aux foo.log foo.pdf bar.aux bar.log bar.pdf baz.aux baz.log baz.pdf qux.aux qux.log qux.pdf`"
},

{
    "location": "manual/running-external-programs.html#Quoting-1",
    "page": "Running External Programs",
    "title": "Quoting",
    "category": "section",
    "text": "Inevitably, one wants to write commands that aren\'t quite so simple, and it becomes necessary to use quotes. Here\'s a simple example of a Perl one-liner at a shell prompt:sh$ perl -le \'$|=1; for (0..3) { print }\'\n0\n1\n2\n3The Perl expression needs to be in single quotes for two reasons: so that spaces don\'t break the expression into multiple shell words, and so that uses of Perl variables like $| (yes, that\'s the name of a variable in Perl), don\'t cause interpolation. In other instances, you may want to use double quotes so that interpolation does occur:sh$ first=\"A\"\nsh$ second=\"B\"\nsh$ perl -le \'$|=1; print for @ARGV\' \"1: $first\" \"2: $second\"\n1: A\n2: BIn general, the Julia backtick syntax is carefully designed so that you can just cut-and-paste shell commands as is into backticks and they will work: the escaping, quoting, and interpolation behaviors are the same as the shell\'s. The only difference is that the interpolation is integrated and aware of Julia\'s notion of what is a single string value, and what is a container for multiple values. Let\'s try the above two examples in Julia:julia> A = `perl -le \'$|=1; for (0..3) { print }\'`\n`perl -le \'$|=1; for (0..3) { print }\'`\n\njulia> run(A);\n0\n1\n2\n3\n\njulia> first = \"A\"; second = \"B\";\n\njulia> B = `perl -le \'print for @ARGV\' \"1: $first\" \"2: $second\"`\n`perl -le \'print for @ARGV\' \'1: A\' \'2: B\'`\n\njulia> run(B);\n1: A\n2: BThe results are identical, and Julia\'s interpolation behavior mimics the shell\'s with some improvements due to the fact that Julia supports first-class iterable objects while most shells use strings split on spaces for this, which introduces ambiguities. When trying to port shell commands to Julia, try cut and pasting first. Since Julia shows commands to you before running them, you can easily and safely just examine its interpretation without doing any damage."
},

{
    "location": "manual/running-external-programs.html#Pipelines-1",
    "page": "Running External Programs",
    "title": "Pipelines",
    "category": "section",
    "text": "Shell metacharacters, such as |, &, and >, need to be quoted (or escaped) inside of Julia\'s backticks:julia> run(`echo hello \'|\' sort`);\nhello | sort\n\njulia> run(`echo hello \\| sort`);\nhello | sortThis expression invokes the echo command with three words as arguments: hello, |, and sort. The result is that a single line is printed: hello | sort. How, then, does one construct a pipeline? Instead of using \'|\' inside of backticks, one uses pipeline:julia> run(pipeline(`echo hello`, `sort`));\nhelloThis pipes the output of the echo command to the sort command. Of course, this isn\'t terribly interesting since there\'s only one line to sort, but we can certainly do much more interesting things:julia> run(pipeline(`cut -d: -f3 /etc/passwd`, `sort -n`, `tail -n5`))\n210\n211\n212\n213\n214This prints the highest five user IDs on a UNIX system. The cut, sort and tail commands are all spawned as immediate children of the current julia process, with no intervening shell process. Julia itself does the work to setup pipes and connect file descriptors that is normally done by the shell. Since Julia does this itself, it retains better control and can do some things that shells cannot.Julia can run multiple commands in parallel:julia> run(`echo hello` & `echo world`);\nworld\nhelloThe order of the output here is non-deterministic because the two echo processes are started nearly simultaneously, and race to make the first write to the stdout descriptor they share with each other and the julia parent process. Julia lets you pipe the output from both of these processes to another program:julia> run(pipeline(`echo world` & `echo hello`, `sort`));\nhello\nworldIn terms of UNIX plumbing, what\'s happening here is that a single UNIX pipe object is created and written to by both echo processes, and the other end of the pipe is read from by the sort command.IO redirection can be accomplished by passing keyword arguments stdin, stdout, and stderr to the pipeline function:pipeline(`do_work`, stdout=pipeline(`sort`, \"out.txt\"), stderr=\"errs.txt\")"
},

{
    "location": "manual/running-external-programs.html#Avoiding-Deadlock-in-Pipelines-1",
    "page": "Running External Programs",
    "title": "Avoiding Deadlock in Pipelines",
    "category": "section",
    "text": "When reading and writing to both ends of a pipeline from a single process, it is important to avoid forcing the kernel to buffer all of the data.For example, when reading all of the output from a command, call read(out, String), not wait(process), since the former will actively consume all of the data written by the process, whereas the latter will attempt to store the data in the kernel\'s buffers while waiting for a reader to be connected.Another common solution is to separate the reader and writer of the pipeline into separate Tasks:writer = @async write(process, \"data\")\nreader = @async do_compute(read(process, String))\nwait(process)\nfetch(reader)"
},

{
    "location": "manual/running-external-programs.html#Complex-Example-1",
    "page": "Running External Programs",
    "title": "Complex Example",
    "category": "section",
    "text": "The combination of a high-level programming language, a first-class command abstraction, and automatic setup of pipes between processes is a powerful one. To give some sense of the complex pipelines that can be created easily, here are some more sophisticated examples, with apologies for the excessive use of Perl one-liners:julia> prefixer(prefix, sleep) = `perl -nle \'$|=1; print \"\'$prefix\' \", $_; sleep \'$sleep\';\'`;\n\njulia> run(pipeline(`perl -le \'$|=1; for(0..5){ print; sleep 1 }\'`, prefixer(\"A\",2) & prefixer(\"B\",2)));\nB 0\nA 1\nB 2\nA 3\nB 4\nA 5This is a classic example of a single producer feeding two concurrent consumers: one perl process generates lines with the numbers 0 through 5 on them, while two parallel processes consume that output, one prefixing lines with the letter \"A\", the other with the letter \"B\". Which consumer gets the first line is non-deterministic, but once that race has been won, the lines are consumed alternately by one process and then the other. (Setting $|=1 in Perl causes each print statement to flush the stdout handle, which is necessary for this example to work. Otherwise all the output is buffered and printed to the pipe at once, to be read by just one consumer process.)Here is an even more complex multi-stage producer-consumer example:julia> run(pipeline(`perl -le \'$|=1; for(0..5){ print; sleep 1 }\'`,\n           prefixer(\"X\",3) & prefixer(\"Y\",3) & prefixer(\"Z\",3),\n           prefixer(\"A\",2) & prefixer(\"B\",2)));\nA X 0\nB Y 1\nA Z 2\nB X 3\nA Y 4\nB Z 5This example is similar to the previous one, except there are two stages of consumers, and the stages have different latency so they use a different number of parallel workers, to maintain saturated throughput.We strongly encourage you to try all these examples to see how they work."
},

{
    "location": "manual/calling-c-and-fortran-code.html#",
    "page": "Calling C and Fortran Code",
    "title": "Calling C and Fortran Code",
    "category": "page",
    "text": ""
},

{
    "location": "manual/calling-c-and-fortran-code.html#Calling-C-and-Fortran-Code-1",
    "page": "Calling C and Fortran Code",
    "title": "Calling C and Fortran Code",
    "category": "section",
    "text": "Though most code can be written in Julia, there are many high-quality, mature libraries for numerical computing already written in C and Fortran. To allow easy use of this existing code, Julia makes it simple and efficient to call C and Fortran functions. Julia has a \"no boilerplate\" philosophy: functions can be called directly from Julia without any \"glue\" code, code generation, or compilation – even from the interactive prompt. This is accomplished just by making an appropriate call with ccall syntax, which looks like an ordinary function call.The code to be called must be available as a shared library. Most C and Fortran libraries ship compiled as shared libraries already, but if you are compiling the code yourself using GCC (or Clang), you will need to use the -shared and -fPIC options. The machine instructions generated by Julia\'s JIT are the same as a native C call would be, so the resulting overhead is the same as calling a library function from C code. (Non-library function calls in both C and Julia can be inlined and thus may have even less overhead than calls to shared library functions. When both libraries and executables are generated by LLVM, it is possible to perform whole-program optimizations that can even optimize across this boundary, but Julia does not yet support that. In the future, however, it may do so, yielding even greater performance gains.)Shared libraries and functions are referenced by a tuple of the form (:function, \"library\") or (\"function\", \"library\") where function is the C-exported function name. library refers to the shared library name: shared libraries available in the (platform-specific) load path will be resolved by name, and if necessary a direct path may be specified.A function name may be used alone in place of the tuple (just :function or \"function\"). In this case the name is resolved within the current process. This form can be used to call C library functions, functions in the Julia runtime, or functions in an application linked to Julia.By default, Fortran compilers generate mangled names (for example, converting function names to lowercase or uppercase, often appending an underscore), and so to call a Fortran function via ccall you must pass the mangled identifier corresponding to the rule followed by your Fortran compiler.  Also, when calling a Fortran function, all inputs must be passed as pointers to allocated values on the heap or stack. This applies not only to arrays and other mutable objects which are normally heap-allocated, but also to scalar values such as integers and floats which are normally stack-allocated and commonly passed in registers when using C or Julia calling conventions.Finally, you can use ccall to actually generate a call to the library function. Arguments to ccall are as follows:A (:function, \"library\") pair, which must be written as a literal constant,\nOR\na :function name symbol or \"function\" name string, which is resolved in the current process,\nOR\na function pointer (for example, from dlsym).\nReturn type (see below for mapping the declared C type to Julia)\nThis argument will be evaluated at compile-time, when the containing method is defined.\nA tuple of input types. The input types must be written as a literal tuple, not a tuple-valued variable or expression.\nThis argument will be evaluated at compile-time, when the containing method is defined.\nThe following arguments, if any, are the actual argument values passed to the function.As a complete but simple example, the following calls the clock function from the standard C library:julia> t = ccall((:clock, \"libc\"), Int32, ())\n2292761\n\njulia> t\n2292761\n\njulia> typeof(ans)\nInt32clock takes no arguments and returns an Int32. One common gotcha is that a 1-tuple must be written with a trailing comma. For example, to call the getenv function to get a pointer to the value of an environment variable, one makes a call like this:julia> path = ccall((:getenv, \"libc\"), Cstring, (Cstring,), \"SHELL\")\nCstring(@0x00007fff5fbffc45)\n\njulia> unsafe_string(path)\n\"/bin/bash\"Note that the argument type tuple must be written as (Cstring,), rather than (Cstring). This is because (Cstring) is just the expression Cstring surrounded by parentheses, rather than a 1-tuple containing Cstring:julia> (Cstring)\nCstring\n\njulia> (Cstring,)\n(Cstring,)In practice, especially when providing reusable functionality, one generally wraps ccall uses in Julia functions that set up arguments and then check for errors in whatever manner the C or Fortran function indicates them, propagating to the Julia caller as exceptions. This is especially important since C and Fortran APIs are notoriously inconsistent about how they indicate error conditions. For example, the getenv C library function is wrapped in the following Julia function, which is a simplified version of the actual definition from env.jl:function getenv(var::AbstractString)\n    val = ccall((:getenv, \"libc\"),\n                Cstring, (Cstring,), var)\n    if val == C_NULL\n        error(\"getenv: undefined variable: \", var)\n    end\n    unsafe_string(val)\nendThe C getenv function indicates an error by returning NULL, but other standard C functions indicate errors in various different ways, including by returning -1, 0, 1 and other special values. This wrapper throws an exception clearly indicating the problem if the caller tries to get a non-existent environment variable:julia> getenv(\"SHELL\")\n\"/bin/bash\"\n\njulia> getenv(\"FOOBAR\")\ngetenv: undefined variable: FOOBARHere is a slightly more complex example that discovers the local machine\'s hostname:function gethostname()\n    hostname = Vector{UInt8}(undef, 128)\n    ccall((:gethostname, \"libc\"), Int32,\n          (Ptr{UInt8}, Csize_t),\n          hostname, sizeof(hostname))\n    hostname[end] = 0; # ensure null-termination\n    return unsafe_string(pointer(hostname))\nendThis example first allocates an array of bytes, then calls the C library function gethostname to fill the array in with the hostname, takes a pointer to the hostname buffer, and converts the pointer to a Julia string, assuming that it is a NUL-terminated C string. It is common for C libraries to use this pattern of requiring the caller to allocate memory to be passed to the callee and filled in. Allocation of memory from Julia like this is generally accomplished by creating an uninitialized array and passing a pointer to its data to the C function. This is why we don\'t use the Cstring type here: as the array is uninitialized, it could contain NUL bytes. Converting to a Cstring as part of the ccall checks for contained NUL bytes and could therefore throw a conversion error."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Creating-C-Compatible-Julia-Function-Pointers-1",
    "page": "Calling C and Fortran Code",
    "title": "Creating C-Compatible Julia Function Pointers",
    "category": "section",
    "text": "It is possible to pass Julia functions to native C functions that accept function pointer arguments. For example, to match C prototypes of the form:typedef returntype (*functiontype)(argumenttype, ...)The macro @cfunction generates the C-compatible function pointer for a call to a Julia function. Arguments to @cfunction are as follows:A Julia Function\nReturn type\nA literal tuple of input typesLike ccall, all of these arguments will be evaluated at compile-time, when the containing method is defined.Currently, only the platform-default C calling convention is supported. This means that @cfunction-generated pointers cannot be used in calls where WINAPI expects stdcall function on 32-bit windows, but can be used on WIN64 (where stdcall is unified with the C calling convention).A classic example is the standard C library qsort function, declared as:void qsort(void *base, size_t nmemb, size_t size,\n           int (*compare)(const void*, const void*));The base argument is a pointer to an array of length nmemb, with elements of size bytes each. compare is a callback function which takes pointers to two elements a and b and returns an integer less/greater than zero if a should appear before/after b (or zero if any order is permitted). Now, suppose that we have a 1d array A of values in Julia that we want to sort using the qsort function (rather than Julia\'s built-in sort function). Before we worry about calling qsort and passing arguments, we need to write a comparison function that works for some arbitrary objects (which define <):julia> function mycompare(a, b)::Cint\n           return (a < b) ? -1 : ((a > b) ? +1 : 0)\n       end\nmycompare (generic function with 1 method)Notice that we have to be careful about the return type: qsort expects a function returning a C int, so we annotate the return type of the function to be sure it returns a Cint.In order to pass this function to C, we obtain its address using the macro @cfunction:julia> mycompare_c = @cfunction(mycompare, Cint, (Ref{Cdouble}, Ref{Cdouble}));@cfunction requires three arguments: the Julia function (mycompare), the return type (Cint), and a literal tuple of the input argument types, in this case to sort an array of Cdouble (Float64) elements.The final call to qsort looks like this:julia> A = [1.3, -2.7, 4.4, 3.1]\n4-element Array{Float64,1}:\n  1.3\n -2.7\n  4.4\n  3.1\n\njulia> ccall(:qsort, Cvoid, (Ptr{Cdouble}, Csize_t, Csize_t, Ptr{Cvoid}),\n             A, length(A), sizeof(eltype(A)), mycompare_c)\n\njulia> A\n4-element Array{Float64,1}:\n -2.7\n  1.3\n  3.1\n  4.4As can be seen, A is changed to the sorted array [-2.7, 1.3, 3.1, 4.4]. Note that Julia knows how to convert an array into a Ptr{Cdouble}, how to compute the size of a type in bytes (identical to C\'s sizeof operator), and so on. For fun, try inserting a println(\"mycompare($a, $b)\") line into mycompare, which will allow you to see the comparisons that qsort is performing (and to verify that it is really calling the Julia function that you passed to it)."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Mapping-C-Types-to-Julia-1",
    "page": "Calling C and Fortran Code",
    "title": "Mapping C Types to Julia",
    "category": "section",
    "text": "It is critical to exactly match the declared C type with its declaration in Julia. Inconsistencies can cause code that works correctly on one system to fail or produce indeterminate results on a different system.Note that no C header files are used anywhere in the process of calling C functions: you are responsible for making sure that your Julia types and call signatures accurately reflect those in the C header file. (The Clang package can be used to auto-generate Julia code from a C header file.)"
},

{
    "location": "manual/calling-c-and-fortran-code.html#Auto-conversion:-1",
    "page": "Calling C and Fortran Code",
    "title": "Auto-conversion:",
    "category": "section",
    "text": "Julia automatically inserts calls to the Base.cconvert function to convert each argument to the specified type. For example, the following call:ccall((:foo, \"libfoo\"), Cvoid, (Int32, Float64), x, y)will behave as if the following were written:ccall((:foo, \"libfoo\"), Cvoid, (Int32, Float64),\n      Base.unsafe_convert(Int32, Base.cconvert(Int32, x)),\n      Base.unsafe_convert(Float64, Base.cconvert(Float64, y)))Base.cconvert normally just calls convert, but can be defined to return an arbitrary new object more appropriate for passing to C. This should be used to perform all allocations of memory that will be accessed by the C code. For example, this is used to convert an Array of objects (e.g. strings) to an array of pointers.Base.unsafe_convert handles conversion to Ptr types. It is considered unsafe because converting an object to a native pointer can hide the object from the garbage collector, causing it to be freed prematurely."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Type-Correspondences:-1",
    "page": "Calling C and Fortran Code",
    "title": "Type Correspondences:",
    "category": "section",
    "text": "First, a review of some relevant Julia type terminology:Syntax / Keyword Example Description\nmutable struct BitSet \"Leaf Type\" :: A group of related data that includes a type-tag, is managed by the Julia GC, and is defined by object-identity. The type parameters of a leaf type must be fully defined (no TypeVars are allowed) in order for the instance to be constructed.\nabstract type Any, AbstractArray{T, N}, Complex{T} \"Super Type\" :: A super-type (not a leaf-type) that cannot be instantiated, but can be used to describe a group of types.\nT{A} Vector{Int} \"Type Parameter\" :: A specialization of a type (typically used for dispatch or storage optimization).\n  \"TypeVar\" :: The T in the type parameter declaration is referred to as a TypeVar (short for type variable).\nprimitive type Int, Float64 \"Primitive Type\" :: A type with no fields, but a size. It is stored and defined by-value.\nstruct Pair{Int, Int} \"Struct\" :: A type with all fields defined to be constant. It is defined by-value, and may be stored with a type-tag.\n ComplexF64 (isbits) \"Is-Bits\"   :: A primitive type, or a struct type where all fields are other isbits types. It is defined by-value, and is stored without a type-tag.\nstruct ...; end nothing \"Singleton\" :: a Leaf Type or Struct with no fields.\n(...) or tuple(...) (1, 2, 3) \"Tuple\" :: an immutable data-structure similar to an anonymous struct type, or a constant array. Represented as either an array or a struct."
},

{
    "location": "manual/calling-c-and-fortran-code.html#man-bits-types-1",
    "page": "Calling C and Fortran Code",
    "title": "Bits Types",
    "category": "section",
    "text": "There are several special types to be aware of, as no other type can be defined to behave the same:Float32\nExactly corresponds to the float type in C (or REAL*4 in Fortran).\nFloat64\nExactly corresponds to the double type in C (or REAL*8 in Fortran).\nComplexF32\nExactly corresponds to the complex float type in C (or COMPLEX*8 in Fortran).\nComplexF64\nExactly corresponds to the complex double type in C (or COMPLEX*16 in Fortran).\nSigned\nExactly corresponds to the signed type annotation in C (or any INTEGER type in Fortran). Any Julia type that is not a subtype of Signed is assumed to be unsigned.Ref{T}\nBehaves like a Ptr{T} that can manage its memory via the Julia GC.Array{T,N}\nWhen an array is passed to C as a Ptr{T} argument, it is not reinterpret-cast: Julia requires that the element type of the array matches T, and the address of the first element is passed.\nTherefore, if an Array contains data in the wrong format, it will have to be explicitly converted using a call such as trunc(Int32, a).\nTo pass an array A as a pointer of a different type without converting the data beforehand (for example, to pass a Float64 array to a function that operates on uninterpreted bytes), you can declare the argument as Ptr{Cvoid}.\nIf an array of eltype Ptr{T} is passed as a Ptr{Ptr{T}} argument, Base.cconvert will attempt to first make a null-terminated copy of the array with each element replaced by its Base.cconvert version. This allows, for example, passing an argv pointer array of type Vector{String} to an argument of type Ptr{Ptr{Cchar}}.On all systems we currently support, basic C/C++ value types may be translated to Julia types as follows. Every C type also has a corresponding Julia type with the same name, prefixed by C. This can help for writing portable code (and remembering that an int in C is not the same as an Int in Julia).System Independent:C name Fortran name Standard Julia Alias Julia Base Type\nunsigned char CHARACTER Cuchar UInt8\nbool (only in C++)  Cuchar UInt8\nshort INTEGER*2, LOGICAL*2 Cshort Int16\nunsigned short  Cushort UInt16\nint, BOOL (C, typical) INTEGER*4, LOGICAL*4 Cint Int32\nunsigned int  Cuint UInt32\nlong long INTEGER*8, LOGICAL*8 Clonglong Int64\nunsigned long long  Culonglong UInt64\nintmax_t  Cintmax_t Int64\nuintmax_t  Cuintmax_t UInt64\nfloat REAL*4i Cfloat Float32\ndouble REAL*8 Cdouble Float64\ncomplex float COMPLEX*8 ComplexF32 Complex{Float32}\ncomplex double COMPLEX*16 ComplexF64 Complex{Float64}\nptrdiff_t  Cptrdiff_t Int\nssize_t  Cssize_t Int\nsize_t  Csize_t UInt\nvoid   Cvoid\nvoid and [[noreturn]] or _Noreturn   Union{}\nvoid*   Ptr{Cvoid}\nT* (where T represents an appropriately defined type)   Ref{T}\nchar* (or char[], e.g. a string) CHARACTER*N  Cstring if NUL-terminated, or Ptr{UInt8} if not\nchar** (or *char[])   Ptr{Ptr{UInt8}}\njl_value_t* (any Julia Type)   Any\njl_value_t** (a reference to a Julia Type)   Ref{Any}\nva_arg   Not supported\n... (variadic function specification)   T... (where T is one of the above types, variadic functions of different argument types are not supported)The Cstring type is essentially a synonym for Ptr{UInt8}, except the conversion to Cstring throws an error if the Julia string contains any embedded NUL characters (which would cause the string to be silently truncated if the C routine treats NUL as the terminator).  If you are passing a char* to a C routine that does not assume NUL termination (e.g. because you pass an explicit string length), or if you know for certain that your Julia string does not contain NUL and want to skip the check, you can use Ptr{UInt8} as the argument type. Cstring can also be used as the ccall return type, but in that case it obviously does not introduce any extra checks and is only meant to improve readability of the call.System-dependent:C name Standard Julia Alias Julia Base Type\nchar Cchar Int8 (x86, x86_64), UInt8 (powerpc, arm)\nlong Clong Int (UNIX), Int32 (Windows)\nunsigned long Culong UInt (UNIX), UInt32 (Windows)\nwchar_t Cwchar_t Int32 (UNIX), UInt16 (Windows)note: Note\nWhen calling Fortran, all inputs must be passed by pointers to heap- or stack-allocated values, so all type correspondences above should contain an additional Ptr{..} or Ref{..} wrapper around their type specification.warning: Warning\nFor string arguments (char*) the Julia type should be Cstring (if NUL- terminated data is expected) or either Ptr{Cchar} or Ptr{UInt8} otherwise (these two pointer types have the same effect), as described above, not String. Similarly, for array arguments (T[] or T*), the Julia type should again be Ptr{T}, not Vector{T}.warning: Warning\nJulia\'s Char type is 32 bits, which is not the same as the wide character type (wchar_t or wint_t) on all platforms.warning: Warning\nA return type of Union{} means the function will not return i.e. C++11 [[noreturn]] or C11 _Noreturn (e.g. jl_throw or longjmp). Do not use this for functions that return no value (void) but do return, use Cvoid instead.note: Note\nFor wchar_t* arguments, the Julia type should be Cwstring (if the C routine expects a NUL-terminated string) or Ptr{Cwchar_t} otherwise. Note also that UTF-8 string data in Julia is internally NUL-terminated, so it can be passed to C functions expecting NUL-terminated data without making a copy (but using the Cwstring type will cause an error to be thrown if the string itself contains NUL characters).note: Note\nC functions that take an argument of the type char** can be called by using a Ptr{Ptr{UInt8}} type within Julia. For example, C functions of the form:int main(int argc, char **argv);can be called via the following Julia code:argv = [ \"a.out\", \"arg1\", \"arg2\" ]\nccall(:main, Int32, (Int32, Ptr{Ptr{UInt8}}), length(argv), argv)note: Note\nFor Fortran functions taking variable length strings of type character(len=*) the string lengths are provided as hidden arguments. Type and position of these arguments in the list are compiler specific, where compiler vendors usually default to using Csize_t as type and append the hidden arguments at the end of the argument list. While this behaviour is fixed for some compilers (GNU), others optionally permit placing hidden arguments directly after the character argument (Intel,PGI). For example, Fortran subroutines of the formsubroutine test(str1, str2)\ncharacter(len=*) :: str1,str2can be called via the following Julia code, where the lengths are appendedstr1 = \"foo\"\nstr2 = \"bar\"\nccall(:test, Void, (Ptr{UInt8}, Ptr{UInt8}, Csize_t, Csize_t),\n                    str1, str2, sizeof(str1), sizeof(str2))warning: Warning\nFortran compilers may also add other hidden arguments for pointers, assumed-shape (:) and assumed-size (*) arrays. Such behaviour can be avoided by using ISO_C_BINDING and including bind(c) in the definition of the subroutine, which is strongly recommended for interoperable code. In this case there will be no hidden arguments, at the cost of some language features (e.g. only character(len=1) will be permitted to pass strings).note: Note\nA C function declared to return Cvoid will return the value nothing in Julia."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Struct-Type-correspondences-1",
    "page": "Calling C and Fortran Code",
    "title": "Struct Type correspondences",
    "category": "section",
    "text": "Composite types, aka struct in C or TYPE in Fortran90 (or STRUCTURE / RECORD in some variants of F77), can be mirrored in Julia by creating a struct definition with the same field layout.When used recursively, isbits types are stored inline. All other types are stored as a pointer to the data. When mirroring a struct used by-value inside another struct in C, it is imperative that you do not attempt to manually copy the fields over, as this will not preserve the correct field alignment. Instead, declare an isbits struct type and use that instead. Unnamed structs are not possible in the translation to Julia.Packed structs and union declarations are not supported by Julia.You can get a near approximation of a union if you know, a priori, the field that will have the greatest size (potentially including padding). When translating your fields to Julia, declare the Julia field to be only of that type.Arrays of parameters can be expressed with NTuple:in C:struct B {\n    int A[3];\n};\nb_a_2 = B.A[2];in Julia:struct B\n    A::NTuple{3, Cint}\nend\nb_a_2 = B.A[3]  # note the difference in indexing (1-based in Julia, 0-based in C)Arrays of unknown size (C99-compliant variable length structs specified by [] or [0]) are not directly supported. Often the best way to deal with these is to deal with the byte offsets directly. For example, if a C library declared a proper string type and returned a pointer to it:struct String {\n    int strlen;\n    char data[];\n};In Julia, we can access the parts independently to make a copy of that string:str = from_c::Ptr{Cvoid}\nlen = unsafe_load(Ptr{Cint}(str))\nunsafe_string(str + Core.sizeof(Cint), len)"
},

{
    "location": "manual/calling-c-and-fortran-code.html#Type-Parameters-1",
    "page": "Calling C and Fortran Code",
    "title": "Type Parameters",
    "category": "section",
    "text": "The type arguments to ccall and @cfunction are evaluated statically, when the method containing the usage is defined. They therefore must take the form of a literal tuple, not a variable, and cannot reference local variables.This may sound like a strange restriction, but remember that since C is not a dynamic language like Julia, its functions can only accept argument types with a statically-known, fixed signature.However, while the type layout must be known statically to compute the intended C ABI, the static parameters of the function are considered to be part of this static environment. The static parameters of the function may be used as type parameters in the call signature, as long as they don\'t affect the layout of the type. For example, f(x::T) where {T} = ccall(:valid, Ptr{T}, (Ptr{T},), x) is valid, since Ptr is always a word-size primitive type. But, g(x::T) where {T} = ccall(:notvalid, T, (T,), x) is not valid, since the type layout of T is not known statically."
},

{
    "location": "manual/calling-c-and-fortran-code.html#SIMD-Values-1",
    "page": "Calling C and Fortran Code",
    "title": "SIMD Values",
    "category": "section",
    "text": "Note: This feature is currently implemented on 64-bit x86 and AArch64 platforms only.If a C/C++ routine has an argument or return value that is a native SIMD type, the corresponding Julia type is a homogeneous tuple of VecElement that naturally maps to the SIMD type.  Specifically:The tuple must be the same size as the SIMD type. For example, a tuple representing an __m128 on x86 must have a size of 16 bytes.\nThe element type of the tuple must be an instance of VecElement{T} where T is a primitive type that is 1, 2, 4 or 8 bytes.For instance, consider this C routine that uses AVX intrinsics:#include <immintrin.h>\n\n__m256 dist( __m256 a, __m256 b ) {\n    return _mm256_sqrt_ps(_mm256_add_ps(_mm256_mul_ps(a, a),\n                                        _mm256_mul_ps(b, b)));\n}The following Julia code calls dist using ccall:const m256 = NTuple{8, VecElement{Float32}}\n\na = m256(ntuple(i -> VecElement(sin(Float32(i))), 8))\nb = m256(ntuple(i -> VecElement(cos(Float32(i))), 8))\n\nfunction call_dist(a::m256, b::m256)\n    ccall((:dist, \"libdist\"), m256, (m256, m256), a, b)\nend\n\nprintln(call_dist(a,b))The host machine must have the requisite SIMD registers.  For example, the code above will not work on hosts without AVX support."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Memory-Ownership-1",
    "page": "Calling C and Fortran Code",
    "title": "Memory Ownership",
    "category": "section",
    "text": "malloc/freeMemory allocation and deallocation of such objects must be handled by calls to the appropriate cleanup routines in the libraries being used, just like in any C program. Do not try to free an object received from a C library with Libc.free in Julia, as this may result in the free function being called via the wrong libc library and cause Julia to crash. The reverse (passing an object allocated in Julia to be freed by an external library) is equally invalid."
},

{
    "location": "manual/calling-c-and-fortran-code.html#When-to-use-T,-Ptr{T}-and-Ref{T}-1",
    "page": "Calling C and Fortran Code",
    "title": "When to use T, Ptr{T} and Ref{T}",
    "category": "section",
    "text": "In Julia code wrapping calls to external C routines, ordinary (non-pointer) data should be declared to be of type T inside the ccall, as they are passed by value.  For C code accepting pointers, Ref{T} should generally be used for the types of input arguments, allowing the use of pointers to memory managed by either Julia or C through the implicit call to Base.cconvert.  In contrast, pointers returned by the C function called should be declared to be of output type Ptr{T}, reflecting that the memory pointed to is managed by C only. Pointers contained in C structs should be represented as fields of type Ptr{T} within the corresponding Julia struct types designed to mimic the internal structure of corresponding C structs.In Julia code wrapping calls to external Fortran routines, all input arguments should be declared as of type Ref{T}, as Fortran passes all variables by pointers to memory locations. The return type should either be Cvoid for Fortran subroutines, or a T for Fortran functions returning the type T."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Mapping-C-Functions-to-Julia-1",
    "page": "Calling C and Fortran Code",
    "title": "Mapping C Functions to Julia",
    "category": "section",
    "text": ""
},

{
    "location": "manual/calling-c-and-fortran-code.html#ccall-/-@cfunction-argument-translation-guide-1",
    "page": "Calling C and Fortran Code",
    "title": "ccall / @cfunction argument translation guide",
    "category": "section",
    "text": "For translating a C argument list to Julia:T, where T is one of the primitive types: char, int, long, short, float, double, complex, enum or any of their typedef equivalents\nT, where T is an equivalent Julia Bits Type (per the table above)\nif T is an enum, the argument type should be equivalent to Cint or Cuint\nargument value will be copied (passed by value)\nstruct T (including typedef to a struct)\nT, where T is a Julia leaf type\nargument value will be copied (passed by value)\nvoid*\ndepends on how this parameter is used, first translate this to the intended pointer type, then determine the Julia equivalent using the remaining rules in this list\nthis argument may be declared as Ptr{Cvoid}, if it really is just an unknown pointer\njl_value_t*\nAny\nargument value must be a valid Julia object\njl_value_t**\nRef{Any}\nargument value must be a valid Julia object (or C_NULL)\nT*\nRef{T}, where T is the Julia type corresponding to T\nargument value will be copied if it is an isbits type otherwise, the value must be a valid Julia object\nT (*)(...) (e.g. a pointer to a function)\nPtr{Cvoid} (you may need to use @cfunction explicitly to create this pointer)\n... (e.g. a vararg)\nT..., where T is the Julia type\ncurrently unsupported by @cfunction\nva_arg\nnot supported by ccall or @cfunction"
},

{
    "location": "manual/calling-c-and-fortran-code.html#ccall-/-@cfunction-return-type-translation-guide-1",
    "page": "Calling C and Fortran Code",
    "title": "ccall / @cfunction return type translation guide",
    "category": "section",
    "text": "For translating a C return type to Julia:void\nCvoid (this will return the singleton instance nothing::Cvoid)\nT, where T is one of the primitive types: char, int, long, short, float, double, complex, enum or any of their typedef equivalents\nT, where T is an equivalent Julia Bits Type (per the table above)\nif T is an enum, the argument type should be equivalent to Cint or Cuint\nargument value will be copied (returned by-value)\nstruct T (including typedef to a struct)\nT, where T is a Julia Leaf Type\nargument value will be copied (returned by-value)\nvoid*\ndepends on how this parameter is used, first translate this to the intended pointer type, then determine the Julia equivalent using the remaining rules in this list\nthis argument may be declared as Ptr{Cvoid}, if it really is just an unknown pointer\njl_value_t*\nAny\nargument value must be a valid Julia object\njl_value_t**\nPtr{Any} (Ref{Any} is invalid as a return type)\nargument value must be a valid Julia object (or C_NULL)\nT*\nIf the memory is already owned by Julia, or is an isbits type, and is known to be non-null:\nRef{T}, where T is the Julia type corresponding to T\na return type of Ref{Any} is invalid, it should either be Any (corresponding to jl_value_t*) or Ptr{Any} (corresponding to jl_value_t**)\nC MUST NOT modify the memory returned via Ref{T} if T is an isbits type\nIf the memory is owned by C:\nPtr{T}, where T is the Julia type corresponding to T\nT (*)(...) (e.g. a pointer to a function)\nPtr{Cvoid} (you may need to use @cfunction explicitly to create this pointer)"
},

{
    "location": "manual/calling-c-and-fortran-code.html#Passing-Pointers-for-Modifying-Inputs-1",
    "page": "Calling C and Fortran Code",
    "title": "Passing Pointers for Modifying Inputs",
    "category": "section",
    "text": "Because C doesn\'t support multiple return values, often C functions will take pointers to data that the function will modify. To accomplish this within a ccall, you need to first encapsulate the value inside a Ref{T} of the appropriate type. When you pass this Ref object as an argument, Julia will automatically pass a C pointer to the encapsulated data:width = Ref{Cint}(0)\nrange = Ref{Cfloat}(0)\nccall(:foo, Cvoid, (Ref{Cint}, Ref{Cfloat}), width, range)Upon return, the contents of width and range can be retrieved (if they were changed by foo) by width[] and range[]; that is, they act like zero-dimensional arrays."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Special-Reference-Syntax-for-ccall-(deprecated):-1",
    "page": "Calling C and Fortran Code",
    "title": "Special Reference Syntax for ccall (deprecated):",
    "category": "section",
    "text": "The & syntax is deprecated, use the Ref{T} argument type instead.A prefix & is used on an argument to ccall to indicate that a pointer to a scalar argument should be passed instead of the scalar value itself (required for all Fortran function arguments, as noted above). The following example computes a dot product using a BLAS function.function compute_dot(DX::Vector{Float64}, DY::Vector{Float64})\n    @assert length(DX) == length(DY)\n    n = length(DX)\n    incx = incy = 1\n    product = ccall((:ddot_, \"libLAPACK\"),\n                    Float64,\n                    (Ref{Int32}, Ptr{Float64}, Ref{Int32}, Ptr{Float64}, Ref{Int32}),\n                    n, DX, incx, DY, incy)\n    return product\nendThe meaning of prefix & is not quite the same as in C. In particular, any changes to the referenced variables will not be visible in Julia unless the type is mutable (declared via mutable struct). However, even for immutable structs it will not cause any harm for called functions to attempt such modifications (that is, writing through the passed pointers). Moreover, & may be used with any expression, such as &0 or &f(x).When a scalar value is passed with & as an argument of type Ptr{T}, the value will first be converted to type T."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Some-Examples-of-C-Wrappers-1",
    "page": "Calling C and Fortran Code",
    "title": "Some Examples of C Wrappers",
    "category": "section",
    "text": "Here is a simple example of a C wrapper that returns a Ptr type:mutable struct gsl_permutation\nend\n\n# The corresponding C signature is\n#     gsl_permutation * gsl_permutation_alloc (size_t n);\nfunction permutation_alloc(n::Integer)\n    output_ptr = ccall(\n        (:gsl_permutation_alloc, :libgsl), # name of C function and library\n        Ptr{gsl_permutation},              # output type\n        (Csize_t,),                        # tuple of input types\n        n                                  # name of Julia variable to pass in\n    )\n    if output_ptr == C_NULL # Could not allocate memory\n        throw(OutOfMemoryError())\n    end\n    return output_ptr\nendThe GNU Scientific Library (here assumed to be accessible through :libgsl) defines an opaque pointer, gsl_permutation *, as the return type of the C function gsl_permutation_alloc. As user code never has to look inside the gsl_permutation struct, the corresponding Julia wrapper simply needs a new type declaration, gsl_permutation, that has no internal fields and whose sole purpose is to be placed in the type parameter of a Ptr type.  The return type of the ccall is declared as Ptr{gsl_permutation}, since the memory allocated and pointed to by output_ptr is controlled by C (and not Julia).The input n is passed by value, and so the function\'s input signature is simply declared as (Csize_t,) without any Ref or Ptr necessary. (If the wrapper was calling a Fortran function instead, the corresponding function input signature should instead be (Ref{Csize_t},), since Fortran variables are passed by pointers.) Furthermore, n can be any type that is convertible to a Csize_t integer; the ccall implicitly calls Base.cconvert(Csize_t, n).Here is a second example wrapping the corresponding destructor:# The corresponding C signature is\n#     void gsl_permutation_free (gsl_permutation * p);\nfunction permutation_free(p::Ref{gsl_permutation})\n    ccall(\n        (:gsl_permutation_free, :libgsl), # name of C function and library\n        Cvoid,                             # output type\n        (Ref{gsl_permutation},),          # tuple of input types\n        p                                 # name of Julia variable to pass in\n    )\nendHere, the input p is declared to be of type Ref{gsl_permutation}, meaning that the memory that p points to may be managed by Julia or by C. A pointer to memory allocated by C should be of type Ptr{gsl_permutation}, but it is convertible using Base.cconvert and therefore can be used in the same (covariant) context of the input argument to a ccall. A pointer to memory allocated by Julia must be of type Ref{gsl_permutation}, to ensure that the memory address pointed to is valid and that Julia\'s garbage collector manages the chunk of memory pointed to correctly. Therefore, the Ref{gsl_permutation} declaration allows pointers managed by C or Julia to be used.If the C wrapper never expects the user to pass pointers to memory managed by Julia, then using p::Ptr{gsl_permutation} for the method signature of the wrapper and similarly in the ccall is also acceptable.Here is a third example passing Julia arrays:# The corresponding C signature is\n#    int gsl_sf_bessel_Jn_array (int nmin, int nmax, double x,\n#                                double result_array[])\nfunction sf_bessel_Jn_array(nmin::Integer, nmax::Integer, x::Real)\n    if nmax < nmin\n        throw(DomainError())\n    end\n    result_array = Vector{Cdouble}(undef, nmax - nmin + 1)\n    errorcode = ccall(\n        (:gsl_sf_bessel_Jn_array, :libgsl), # name of C function and library\n        Cint,                               # output type\n        (Cint, Cint, Cdouble, Ref{Cdouble}),# tuple of input types\n        nmin, nmax, x, result_array         # names of Julia variables to pass in\n    )\n    if errorcode != 0\n        error(\"GSL error code $errorcode\")\n    end\n    return result_array\nendThe C function wrapped returns an integer error code; the results of the actual evaluation of the Bessel J function populate the Julia array result_array. This variable can only be used with corresponding input type declaration Ref{Cdouble}, since its memory is allocated and managed by Julia, not C. The implicit call to Base.cconvert(Ref{Cdouble}, result_array) unpacks the Julia pointer to a Julia array data structure into a form understandable by C.Note that for this code to work correctly, result_array must be declared to be of type Ref{Cdouble} and not Ptr{Cdouble}. The memory is managed by Julia and the Ref signature alerts Julia\'s garbage collector to keep managing the memory for result_array while the ccall executes. If Ptr{Cdouble} were used instead, the ccall may still work, but Julia\'s garbage collector would not be aware that the memory declared for result_array is being used by the external C function. As a result, the code may produce a memory leak if result_array never gets freed by the garbage collector, or if the garbage collector prematurely frees result_array, the C function may end up throwing an invalid memory access exception."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Garbage-Collection-Safety-1",
    "page": "Calling C and Fortran Code",
    "title": "Garbage Collection Safety",
    "category": "section",
    "text": "When passing data to a ccall, it is best to avoid using the pointer function. Instead define a convert method and pass the variables directly to the ccall. ccall automatically arranges that all of its arguments will be preserved from garbage collection until the call returns. If a C API will store a reference to memory allocated by Julia, after the ccall returns, you must arrange that the object remains visible to the garbage collector. The suggested way to handle this is to make a global variable of type Array{Ref,1} to hold these values, until the C library notifies you that it is finished with them.Whenever you have created a pointer to Julia data, you must ensure the original data exists until you are done with using the pointer. Many methods in Julia such as unsafe_load and String make copies of data instead of taking ownership of the buffer, so that it is safe to free (or alter) the original data without affecting Julia. A notable exception is unsafe_wrap which, for performance reasons, shares (or can be told to take ownership of) the underlying buffer.The garbage collector does not guarantee any order of finalization. That is, if a contained a reference to b and both a and b are due for garbage collection, there is no guarantee that b would be finalized after a. If proper finalization of a depends on b being valid, it must be handled in other ways."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Non-constant-Function-Specifications-1",
    "page": "Calling C and Fortran Code",
    "title": "Non-constant Function Specifications",
    "category": "section",
    "text": "A (name, library) function specification must be a constant expression. However, it is possible to use computed values as function names by staging through eval as follows:@eval ccall(($(string(\"a\", \"b\")), \"lib\"), ...This expression constructs a name using string, then substitutes this name into a new ccall expression, which is then evaluated. Keep in mind that eval only operates at the top level, so within this expression local variables will not be available (unless their values are substituted with $). For this reason, eval is typically only used to form top-level definitions, for example when wrapping libraries that contain many similar functions. A similar example can be constructed for @cfunction.However, doing this will also be very slow and leak memory, so you should usually avoid this and instead keep reading. The next section discusses how to use indirect calls to efficiently accomplish a similar effect."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Indirect-Calls-1",
    "page": "Calling C and Fortran Code",
    "title": "Indirect Calls",
    "category": "section",
    "text": "The first argument to ccall can also be an expression evaluated at run time. In this case, the expression must evaluate to a Ptr, which will be used as the address of the native function to call. This behavior occurs when the first ccall argument contains references to non-constants, such as local variables, function arguments, or non-constant globals.For example, you might look up the function via dlsym, then cache it in a shared reference for that session. For example:macro dlsym(func, lib)\n    z = Ref{Ptr{Cvoid}}(C_NULL)\n    quote\n        let zlocal = $z[]\n            if zlocal == C_NULL\n                zlocal = dlsym($(esc(lib))::Ptr{Cvoid}, $(esc(func)))::Ptr{Cvoid}\n                $z[] = $zlocal\n            end\n            zlocal\n        end\n    end\nend\n\nmylibvar = Libdl.dlopen(\"mylib\")\nccall(@dlsym(\"myfunc\", mylibvar), Cvoid, ())"
},

{
    "location": "manual/calling-c-and-fortran-code.html#Closure-cfunctions-1",
    "page": "Calling C and Fortran Code",
    "title": "Closure cfunctions",
    "category": "section",
    "text": "The first argument to @cfunction can be marked with a $, in which case the return value will instead be a struct CFunction which closes over the argument. You must ensure that this return object is kept alive until all uses of it are done. The contents and code at the cfunction pointer will be erased via a finalizer when this reference is dropped and atexit. This is not usually needed, since this functionality is not present in C, but can be useful for dealing with ill-designed APIs which don\'t provide a separate closure environment parameter.function qsort(a::Vector{T}, cmp) where T\n    isbits(T) || throw(ArgumentError(\"this method can only qsort isbits arrays\"))\n    callback = @cfunction $cmp Cint (Ref{T}, Ref{T})\n    # Here, `callback` isa Base.CFunction, which will be converted to Ptr{Cvoid}\n    # (and protected against finalization) by the ccall\n    ccall(:qsort, Cvoid, (Ptr{T}, Csize_t, Csize_t, Ptr{Cvoid}),\n        a, length(a), Base.elsize(a), callback)\n    # We could instead use:\n    #    GC.@preserve callback begin\n    #        use(Base.unsafe_convert(Ptr{Cvoid}, callback))\n    #    end\n    # if we needed to use it outside of a `ccall`\n    return a\nend"
},

{
    "location": "manual/calling-c-and-fortran-code.html#Closing-a-Library-1",
    "page": "Calling C and Fortran Code",
    "title": "Closing a Library",
    "category": "section",
    "text": "It is sometimes useful to close (unload) a library so that it can be reloaded. For instance, when developing C code for use with Julia, one may need to compile, call the C code from Julia, then close the library, make an edit, recompile, and load in the new changes. One can either restart Julia or use the Libdl functions to manage the library explicitly, such as:lib = Libdl.dlopen(\"./my_lib.so\") # Open the library explicitly.\nsym = Libdl.dlsym(lib, :my_fcn)   # Get a symbol for the function to call.\nccall(sym, ...) # Use the pointer `sym` instead of the (symbol, library) tuple (remaining arguments are the same).\nLibdl.dlclose(lib) # Close the library explicitly.Note that when using ccall with the tuple input (e.g., ccall((:my_fcn, \"./my_lib.so\"), ...)), the library is opened implicitly and it may not be explicitly closed."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Calling-Convention-1",
    "page": "Calling C and Fortran Code",
    "title": "Calling Convention",
    "category": "section",
    "text": "The second argument to ccall can optionally be a calling convention specifier (immediately preceding return type). Without any specifier, the platform-default C calling convention is used. Other supported conventions are: stdcall, cdecl, fastcall, and thiscall (no-op on 64-bit Windows). For example (from base/libc.jl) we see the same gethostnameccall as above, but with the correct signature for Windows:hn = Vector{UInt8}(undef, 256)\nerr = ccall(:gethostname, stdcall, Int32, (Ptr{UInt8}, UInt32), hn, length(hn))For more information, please see the LLVM Language Reference.There is one additional special calling convention llvmcall, which allows inserting calls to LLVM intrinsics directly. This can be especially useful when targeting unusual platforms such as GPGPUs. For example, for CUDA, we need to be able to read the thread index:ccall(\"llvm.nvvm.read.ptx.sreg.tid.x\", llvmcall, Int32, ())As with any ccall, it is essential to get the argument signature exactly correct. Also, note that there is no compatibility layer that ensures the intrinsic makes sense and works on the current target, unlike the equivalent Julia functions exposed by Core.Intrinsics."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Accessing-Global-Variables-1",
    "page": "Calling C and Fortran Code",
    "title": "Accessing Global Variables",
    "category": "section",
    "text": "Global variables exported by native libraries can be accessed by name using the cglobal function. The arguments to cglobal are a symbol specification identical to that used by ccall, and a type describing the value stored in the variable:julia> cglobal((:errno, :libc), Int32)\nPtr{Int32} @0x00007f418d0816b8The result is a pointer giving the address of the value. The value can be manipulated through this pointer using unsafe_load and unsafe_store!."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Accessing-Data-through-a-Pointer-1",
    "page": "Calling C and Fortran Code",
    "title": "Accessing Data through a Pointer",
    "category": "section",
    "text": "The following methods are described as \"unsafe\" because a bad pointer or type declaration can cause Julia to terminate abruptly.Given a Ptr{T}, the contents of type T can generally be copied from the referenced memory into a Julia object using unsafe_load(ptr, [index]). The index argument is optional (default is 1), and follows the Julia-convention of 1-based indexing. This function is intentionally similar to the behavior of getindex and setindex! (e.g. [] access syntax).The return value will be a new object initialized to contain a copy of the contents of the referenced memory. The referenced memory can safely be freed or released.If T is Any, then the memory is assumed to contain a reference to a Julia object (a jl_value_t*), the result will be a reference to this object, and the object will not be copied. You must be careful in this case to ensure that the object was always visible to the garbage collector (pointers do not count, but the new reference does) to ensure the memory is not prematurely freed. Note that if the object was not originally allocated by Julia, the new object will never be finalized by Julia\'s garbage collector.  If the Ptr itself is actually a jl_value_t*, it can be converted back to a Julia object reference by unsafe_pointer_to_objref(ptr). (Julia values v can be converted to jl_value_t* pointers, as Ptr{Cvoid}, by calling pointer_from_objref(v).)The reverse operation (writing data to a Ptr{T}), can be performed using unsafe_store!(ptr, value, [index]). Currently, this is only supported for primitive types or other pointer-free (isbits) immutable struct types.Any operation that throws an error is probably currently unimplemented and should be posted as a bug so that it can be resolved.If the pointer of interest is a plain-data array (primitive type or immutable struct), the function unsafe_wrap(Array, ptr,dims, own = false) may be more useful. The final parameter should be true if Julia should \"take ownership\" of the underlying buffer and call free(ptr) when the returned Array object is finalized.  If the own parameter is omitted or false, the caller must ensure the buffer remains in existence until all access is complete.Arithmetic on the Ptr type in Julia (e.g. using +) does not behave the same as C\'s pointer arithmetic. Adding an integer to a Ptr in Julia always moves the pointer by some number of bytes, not elements. This way, the address values obtained from pointer arithmetic do not depend on the element types of pointers."
},

{
    "location": "manual/calling-c-and-fortran-code.html#Thread-safety-1",
    "page": "Calling C and Fortran Code",
    "title": "Thread-safety",
    "category": "section",
    "text": "Some C libraries execute their callbacks from a different thread, and since Julia isn\'t thread-safe you\'ll need to take some extra precautions. In particular, you\'ll need to set up a two-layered system: the C callback should only schedule (via Julia\'s event loop) the execution of your \"real\" callback. To do this, create an AsyncCondition object and wait on it:cond = Base.AsyncCondition()\nwait(cond)The callback you pass to C should only execute a ccall to :uv_async_send, passing cond.handle as the argument, taking care to avoid any allocations or other interactions with the Julia runtime.Note that events may be coalesced, so multiple calls to uv_async_send may result in a single wakeup notification to the condition."
},

{
    "location": "manual/calling-c-and-fortran-code.html#More-About-Callbacks-1",
    "page": "Calling C and Fortran Code",
    "title": "More About Callbacks",
    "category": "section",
    "text": "For more details on how to pass callbacks to C libraries, see this blog post."
},

{
    "location": "manual/calling-c-and-fortran-code.html#C-1",
    "page": "Calling C and Fortran Code",
    "title": "C++",
    "category": "section",
    "text": "For direct C++ interfacing, see the Cxx package. For tools to create C++ bindings, see the CxxWrap package."
},

{
    "location": "manual/handling-operating-system-variation.html#",
    "page": "Handling Operating System Variation",
    "title": "Handling Operating System Variation",
    "category": "page",
    "text": ""
},

{
    "location": "manual/handling-operating-system-variation.html#Handling-Operating-System-Variation-1",
    "page": "Handling Operating System Variation",
    "title": "Handling Operating System Variation",
    "category": "section",
    "text": "When writing cross-platform applications or libraries, it is often necessary to allow for differences between operating systems. The variable Sys.KERNEL can be used to handle such cases. There are several functions in the Sys module intended to make this easier, such as isunix, islinux, isapple, isbsd, isfreebsd, and iswindows. These may be used as follows:if Sys.iswindows()\n    windows_specific_thing(a)\nendNote that islinux, isapple, and isfreebsd are mutually exclusive subsets of isunix. Additionally, there is a macro @static which makes it possible to use these functions to conditionally hide invalid code, as demonstrated in the following examples.Simple blocks:ccall((@static Sys.iswindows() ? :_fopen : :fopen), ...)Complex blocks:@static if Sys.islinux()\n    linux_specific_thing(a)\nelse\n    generic_thing(a)\nendWhen chaining conditionals (including if/elseif/end), the @static must be repeated for each level (parentheses optional, but recommended for readability):@static Sys.iswindows() ? :a : (@static Sys.isapple() ? :b : :c)"
},

{
    "location": "manual/environment-variables.html#",
    "page": "Environment Variables",
    "title": "Environment Variables",
    "category": "page",
    "text": ""
},

{
    "location": "manual/environment-variables.html#Environment-Variables-1",
    "page": "Environment Variables",
    "title": "Environment Variables",
    "category": "section",
    "text": "Julia can be configured with a number of environment variables, set either in the usual way for each operating system, or in a portable way from within Julia. Supposing that you want to set the environment variable JULIA_EDITOR to vim, you can type ENV[\"JULIA_EDITOR\"] = \"vim\" (for instance, in the REPL) to make this change on a case by case basis, or add the same to the user configuration file ~/.julia/config/startup.jl in the user\'s home directory to have a permanent effect. The current value of the same environment variable can be determined by evaluating ENV[\"JULIA_EDITOR\"].The environment variables that Julia uses generally start with JULIA. If InteractiveUtils.versioninfo is called with the keyword verbose=true, then the output will list defined environment variables relevant for Julia, including those for which JULIA appears in the name.note: Note\nSome variables, such as JULIA_NUM_THREADS and JULIA_PROJECT, need to be set before Julia starts, therefore adding these to ~/.julia/config/startup.jl is too late in the startup process. In Bash, environment variables can either be set manually by running, e.g., export JULIA_NUM_THREADS=4 before starting Julia, or by adding the same command to -/.bashrc or ~/.bash_profile to set the variable each time Bash is started."
},

{
    "location": "manual/environment-variables.html#File-locations-1",
    "page": "Environment Variables",
    "title": "File locations",
    "category": "section",
    "text": ""
},

{
    "location": "manual/environment-variables.html#JULIA_BINDIR-1",
    "page": "Environment Variables",
    "title": "JULIA_BINDIR",
    "category": "section",
    "text": "The absolute path of the directory containing the Julia executable, which sets the global variable Sys.BINDIR. If $JULIA_BINDIR is not set, then Julia determines the value Sys.BINDIR at run-time.The executable itself is one of$JULIA_BINDIR/julia\n$JULIA_BINDIR/julia-debugby default.The global variable Base.DATAROOTDIR determines a relative path from Sys.BINDIR to the data directory associated with Julia. Then the path$JULIA_BINDIR/$DATAROOTDIR/julia/basedetermines the directory in which Julia initially searches for source files (via Base.find_source_file()).Likewise, the global variable Base.SYSCONFDIR determines a relative path to the configuration file directory. Then Julia searches for a startup.jl file at$JULIA_BINDIR/$SYSCONFDIR/julia/startup.jl\n$JULIA_BINDIR/../etc/julia/startup.jlby default (via Base.load_julia_startup()).For example, a Linux installation with a Julia executable located at /bin/julia, a DATAROOTDIR of ../share, and a SYSCONFDIR of ../etc will have JULIA_BINDIR set to /bin, a source-file search path of/share/julia/baseand a global configuration search path of/etc/julia/startup.jl"
},

{
    "location": "manual/environment-variables.html#JULIA_PROJECT-1",
    "page": "Environment Variables",
    "title": "JULIA_PROJECT",
    "category": "section",
    "text": "A directory path that points to the current Julia project. Setting this environment variable has the same effect as specifying the --project start-up option, but --project has higher precedence.  If the variable is set to @. then Julia tries to find a project directory that contains Project.toml or JuliaProject.toml file from the current directory and its parents.  See also the chapter on Code Loading.note: Note\nJULIA_PROJECT must be defined before starting julia; defining it in startup.jl is too late in the startup process."
},

{
    "location": "manual/environment-variables.html#JULIA_LOAD_PATH-1",
    "page": "Environment Variables",
    "title": "JULIA_LOAD_PATH",
    "category": "section",
    "text": "A separated list of absolute paths that are to be appended to the variable LOAD_PATH. (In Unix-like systems, : is the path separator; in Windows systems, ; is the path separator.) The LOAD_PATH variable is where Base.require and Base.load_in_path() look for code; it defaults to the absolute path $JULIA_HOME/../share/julia/stdlib/v$(VERSION.major).$(VERSION.minor) so that, e.g., version 0.7 of Julia on a Linux system with a Julia executable at /bin/julia will have a default LOAD_PATH of /share/julia/stdlib/v0.7."
},

{
    "location": "manual/environment-variables.html#JULIA_HISTORY-1",
    "page": "Environment Variables",
    "title": "JULIA_HISTORY",
    "category": "section",
    "text": "The absolute path REPL.find_hist_file() of the REPL\'s history file. If $JULIA_HISTORY is not set, then REPL.find_hist_file() defaults to$HOME/.julia/logs/repl_history.jl"
},

{
    "location": "manual/environment-variables.html#JULIA_PKGRESOLVE_ACCURACY-1",
    "page": "Environment Variables",
    "title": "JULIA_PKGRESOLVE_ACCURACY",
    "category": "section",
    "text": "A positive Int that determines how much time the max-sum subroutine MaxSum.maxsum() of the package dependency resolver will devote to attempting satisfying constraints before giving up: this value is by default 1, and larger values correspond to larger amounts of time.Suppose the value of $JULIA_PKGRESOLVE_ACCURACY is n. Thenthe number of pre-decimation iterations is 20*n,\nthe number of iterations between decimation steps is 10*n, and\nat decimation steps, at most one in every 20*n packages is decimated."
},

{
    "location": "manual/environment-variables.html#External-applications-1",
    "page": "Environment Variables",
    "title": "External applications",
    "category": "section",
    "text": ""
},

{
    "location": "manual/environment-variables.html#JULIA_SHELL-1",
    "page": "Environment Variables",
    "title": "JULIA_SHELL",
    "category": "section",
    "text": "The absolute path of the shell with which Julia should execute external commands (via Base.repl_cmd()). Defaults to the environment variable $SHELL, and falls back to /bin/sh if $SHELL is unset.note: Note\nOn Windows, this environment variable is ignored, and external commands are executed directly."
},

{
    "location": "manual/environment-variables.html#JULIA_EDITOR-1",
    "page": "Environment Variables",
    "title": "JULIA_EDITOR",
    "category": "section",
    "text": "The editor returned by InteractiveUtils.editor() and used in, e.g., InteractiveUtils.edit, referring to the command of the preferred editor, for instance vim.$JULIA_EDITOR takes precedence over $VISUAL, which in turn takes precedence over $EDITOR. If none of these environment variables is set, then the editor is taken to be open on Windows and OS X, or /etc/alternatives/editor if it exists, or emacs otherwise."
},

{
    "location": "manual/environment-variables.html#Parallelization-1",
    "page": "Environment Variables",
    "title": "Parallelization",
    "category": "section",
    "text": ""
},

{
    "location": "manual/environment-variables.html#JULIA_CPU_THREADS-1",
    "page": "Environment Variables",
    "title": "JULIA_CPU_THREADS",
    "category": "section",
    "text": "Overrides the global variable Base.Sys.CPU_THREADS, the number of logical CPU cores available."
},

{
    "location": "manual/environment-variables.html#JULIA_WORKER_TIMEOUT-1",
    "page": "Environment Variables",
    "title": "JULIA_WORKER_TIMEOUT",
    "category": "section",
    "text": "A Float64 that sets the value of Distributed.worker_timeout() (default: 60.0). This function gives the number of seconds a worker process will wait for a master process to establish a connection before dying."
},

{
    "location": "manual/environment-variables.html#JULIA_NUM_THREADS-1",
    "page": "Environment Variables",
    "title": "JULIA_NUM_THREADS",
    "category": "section",
    "text": "An unsigned 64-bit integer (uint64_t) that sets the maximum number of threads available to Julia. If $JULIA_NUM_THREADS exceeds the number of available physical CPU cores, then the number of threads is set to the number of cores. If $JULIA_NUM_THREADS is not positive or is not set, or if the number of CPU cores cannot be determined through system calls, then the number of threads is set to 1.note: Note\nJULIA_NUM_THREADS must be defined before starting julia; defining it in startup.jl is too late in the startup process."
},

{
    "location": "manual/environment-variables.html#JULIA_THREAD_SLEEP_THRESHOLD-1",
    "page": "Environment Variables",
    "title": "JULIA_THREAD_SLEEP_THRESHOLD",
    "category": "section",
    "text": "If set to a string that starts with the case-insensitive substring \"infinite\", then spinning threads never sleep. Otherwise, $JULIA_THREAD_SLEEP_THRESHOLD is interpreted as an unsigned 64-bit integer (uint64_t) and gives, in nanoseconds, the amount of time after which spinning threads should sleep."
},

{
    "location": "manual/environment-variables.html#JULIA_EXCLUSIVE-1",
    "page": "Environment Variables",
    "title": "JULIA_EXCLUSIVE",
    "category": "section",
    "text": "If set to anything besides 0, then Julia\'s thread policy is consistent with running on a dedicated machine: the master thread is on proc 0, and threads are affinitized. Otherwise, Julia lets the operating system handle thread policy."
},

{
    "location": "manual/environment-variables.html#REPL-formatting-1",
    "page": "Environment Variables",
    "title": "REPL formatting",
    "category": "section",
    "text": "Environment variables that determine how REPL output should be formatted at the terminal. Generally, these variables should be set to ANSI terminal escape sequences. Julia provides a high-level interface with much of the same functionality; see the section on The Julia REPL."
},

{
    "location": "manual/environment-variables.html#JULIA_ERROR_COLOR-1",
    "page": "Environment Variables",
    "title": "JULIA_ERROR_COLOR",
    "category": "section",
    "text": "The formatting Base.error_color() (default: light red, \"\\033[91m\") that errors should have at the terminal."
},

{
    "location": "manual/environment-variables.html#JULIA_WARN_COLOR-1",
    "page": "Environment Variables",
    "title": "JULIA_WARN_COLOR",
    "category": "section",
    "text": "The formatting Base.warn_color() (default: yellow, \"\\033[93m\") that warnings should have at the terminal."
},

{
    "location": "manual/environment-variables.html#JULIA_INFO_COLOR-1",
    "page": "Environment Variables",
    "title": "JULIA_INFO_COLOR",
    "category": "section",
    "text": "The formatting Base.info_color() (default: cyan, \"\\033[36m\") that info should have at the terminal."
},

{
    "location": "manual/environment-variables.html#JULIA_INPUT_COLOR-1",
    "page": "Environment Variables",
    "title": "JULIA_INPUT_COLOR",
    "category": "section",
    "text": "The formatting Base.input_color() (default: normal, \"\\033[0m\") that input should have at the terminal."
},

{
    "location": "manual/environment-variables.html#JULIA_ANSWER_COLOR-1",
    "page": "Environment Variables",
    "title": "JULIA_ANSWER_COLOR",
    "category": "section",
    "text": "The formatting Base.answer_color() (default: normal, \"\\033[0m\") that output should have at the terminal."
},

{
    "location": "manual/environment-variables.html#JULIA_STACKFRAME_LINEINFO_COLOR-1",
    "page": "Environment Variables",
    "title": "JULIA_STACKFRAME_LINEINFO_COLOR",
    "category": "section",
    "text": "The formatting Base.stackframe_lineinfo_color() (default: bold, \"\\033[1m\") that line info should have during a stack trace at the terminal."
},

{
    "location": "manual/environment-variables.html#JULIA_STACKFRAME_FUNCTION_COLOR-1",
    "page": "Environment Variables",
    "title": "JULIA_STACKFRAME_FUNCTION_COLOR",
    "category": "section",
    "text": "The formatting Base.stackframe_function_color() (default: bold, \"\\033[1m\") that function calls should have during a stack trace at the terminal."
},

{
    "location": "manual/environment-variables.html#Debugging-and-profiling-1",
    "page": "Environment Variables",
    "title": "Debugging and profiling",
    "category": "section",
    "text": ""
},

{
    "location": "manual/environment-variables.html#JULIA_GC_ALLOC_POOL,-JULIA_GC_ALLOC_OTHER,-JULIA_GC_ALLOC_PRINT-1",
    "page": "Environment Variables",
    "title": "JULIA_GC_ALLOC_POOL, JULIA_GC_ALLOC_OTHER, JULIA_GC_ALLOC_PRINT",
    "category": "section",
    "text": "If set, these environment variables take strings that optionally start with the character \'r\', followed by a string interpolation of a colon-separated list of three signed 64-bit integers (int64_t). This triple of integers a:b:c represents the arithmetic sequence a, a + b, a + 2*b, ... c.If it\'s the nth time that jl_gc_pool_alloc() has been called, and n   belongs to the arithmetic sequence represented by $JULIA_GC_ALLOC_POOL,   then garbage collection is forced.\nIf it\'s the nth time that maybe_collect() has been called, and n belongs   to the arithmetic sequence represented by $JULIA_GC_ALLOC_OTHER, then garbage   collection is forced.\nIf it\'s the nth time that jl_gc_collect() has been called, and n belongs   to the arithmetic sequence represented by $JULIA_GC_ALLOC_PRINT, then counts   for the number of calls to jl_gc_pool_alloc() and maybe_collect() are   printed.If the value of the environment variable begins with the character \'r\', then the interval between garbage collection events is randomized.note: Note\nThese environment variables only have an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration)."
},

{
    "location": "manual/environment-variables.html#JULIA_GC_NO_GENERATIONAL-1",
    "page": "Environment Variables",
    "title": "JULIA_GC_NO_GENERATIONAL",
    "category": "section",
    "text": "If set to anything besides 0, then the Julia garbage collector never performs \"quick sweeps\" of memory.note: Note\nThis environment variable only has an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration)."
},

{
    "location": "manual/environment-variables.html#JULIA_GC_WAIT_FOR_DEBUGGER-1",
    "page": "Environment Variables",
    "title": "JULIA_GC_WAIT_FOR_DEBUGGER",
    "category": "section",
    "text": "If set to anything besides 0, then the Julia garbage collector will wait for a debugger to attach instead of aborting whenever there\'s a critical error.note: Note\nThis environment variable only has an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration)."
},

{
    "location": "manual/environment-variables.html#ENABLE_JITPROFILING-1",
    "page": "Environment Variables",
    "title": "ENABLE_JITPROFILING",
    "category": "section",
    "text": "If set to anything besides 0, then the compiler will create and register an event listener for just-in-time (JIT) profiling.note: Note\nThis environment variable only has an effect if Julia was compiled with JIT profiling support, using eitherIntel\'s VTune™ Amplifier (USE_INTEL_JITEVENTS set to 1 in the build configuration), or\nOProfile (USE_OPROFILE_JITEVENTS set to 1 in the build configuration)."
},

{
    "location": "manual/environment-variables.html#JULIA_LLVM_ARGS-1",
    "page": "Environment Variables",
    "title": "JULIA_LLVM_ARGS",
    "category": "section",
    "text": "Arguments to be passed to the LLVM backend."
},

{
    "location": "manual/environment-variables.html#JULIA_DEBUG_LOADING-1",
    "page": "Environment Variables",
    "title": "JULIA_DEBUG_LOADING",
    "category": "section",
    "text": "If set, then Julia prints detailed information about the cache in the loading process of Base.require."
},

{
    "location": "manual/embedding.html#",
    "page": "Embedding Julia",
    "title": "Embedding Julia",
    "category": "page",
    "text": ""
},

{
    "location": "manual/embedding.html#Embedding-Julia-1",
    "page": "Embedding Julia",
    "title": "Embedding Julia",
    "category": "section",
    "text": "As we have seen in Calling C and Fortran Code, Julia has a simple and efficient way to call functions written in C. But there are situations where the opposite is needed: calling Julia function from C code. This can be used to integrate Julia code into a larger C/C++ project, without the need to rewrite everything in C/C++. Julia has a C API to make this possible. As almost all programming languages have some way to call C functions, the Julia C API can also be used to build further language bridges (e.g. calling Julia from Python or C#)."
},

{
    "location": "manual/embedding.html#High-Level-Embedding-1",
    "page": "Embedding Julia",
    "title": "High-Level Embedding",
    "category": "section",
    "text": "Note: This section covers embedding Julia code in C on Unix-like operating systems. For doing this on Windows, please see the section following this.We start with a simple C program that initializes Julia and calls some Julia code:#include <julia.h>\nJULIA_DEFINE_FAST_TLS() // only define this once, in an executable (not in a shared library) if you want fast code.\n\nint main(int argc, char *argv[])\n{\n    /* required: setup the Julia context */\n    jl_init();\n\n    /* run Julia commands */\n    jl_eval_string(\"print(sqrt(2.0))\");\n\n    /* strongly recommended: notify Julia that the\n         program is about to terminate. this allows\n         Julia time to cleanup pending write requests\n         and run all finalizers\n    */\n    jl_atexit_hook(0);\n    return 0;\n}In order to build this program you have to put the path to the Julia header into the include path and link against libjulia. For instance, when Julia is installed to $JULIA_DIR, one can compile the above test program test.c with gcc using:gcc -o test -fPIC -I$JULIA_DIR/include/julia -L$JULIA_DIR/lib test.c -ljulia $JULIA_DIR/lib/julia/libstdc++.so.6Then if the environment variable JULIA_BINDIR is set to $JULIA_DIR/bin, the output test program can be executed.Alternatively, look at the embedding.c program in the Julia source tree in the test/embedding/ folder. The file ui/repl.c program is another simple example of how to set jl_options options while linking against libjulia.The first thing that has to be done before calling any other Julia C function is to initialize Julia. This is done by calling jl_init, which tries to automatically determine Julia\'s install location. If you need to specify a custom location, or specify which system image to load, use jl_init_with_image instead.The second statement in the test program evaluates a Julia statement using a call to jl_eval_string.Before the program terminates, it is strongly recommended to call jl_atexit_hook.  The above example program calls this before returning from main.note: Note\nCurrently, dynamically linking with the libjulia shared library requires passing the RTLD_GLOBAL option. In Python, this looks like:>>> julia=CDLL(\'./libjulia.dylib\',RTLD_GLOBAL)\n>>> julia.jl_init.argtypes = []\n>>> julia.jl_init()\n250593296note: Note\nIf the julia program needs to access symbols from the main executable, it may be necessary to add -Wl,--export-dynamic linker flag at compile time on Linux in addition to the ones generated by julia-config.jl described below. This is not necessary when compiling a shared library."
},

{
    "location": "manual/embedding.html#Using-julia-config-to-automatically-determine-build-parameters-1",
    "page": "Embedding Julia",
    "title": "Using julia-config to automatically determine build parameters",
    "category": "section",
    "text": "The script julia-config.jl was created to aid in determining what build parameters are required by a program that uses embedded Julia.  This script uses the build parameters and system configuration of the particular Julia distribution it is invoked by to export the necessary compiler flags for an embedding program to interact with that distribution.  This script is located in the Julia shared data directory."
},

{
    "location": "manual/embedding.html#Example-1",
    "page": "Embedding Julia",
    "title": "Example",
    "category": "section",
    "text": "#include <julia.h>\n\nint main(int argc, char *argv[])\n{\n    jl_init();\n    (void)jl_eval_string(\"println(sqrt(2.0))\");\n    jl_atexit_hook(0);\n    return 0;\n}"
},

{
    "location": "manual/embedding.html#On-the-command-line-1",
    "page": "Embedding Julia",
    "title": "On the command line",
    "category": "section",
    "text": "A simple use of this script is from the command line.  Assuming that julia-config.jl is located in /usr/local/julia/share/julia, it can be invoked on the command line directly and takes any combination of 3 flags:/usr/local/julia/share/julia/julia-config.jl\nUsage: julia-config [--cflags|--ldflags|--ldlibs]If the above example source is saved in the file embed_example.c, then the following command will compile it into a running program on Linux and Windows (MSYS2 environment), or if on OS/X, then substitute clang for gcc.:/usr/local/julia/share/julia/julia-config.jl --cflags --ldflags --ldlibs | xargs gcc embed_example.c"
},

{
    "location": "manual/embedding.html#Use-in-Makefiles-1",
    "page": "Embedding Julia",
    "title": "Use in Makefiles",
    "category": "section",
    "text": "But in general, embedding projects will be more complicated than the above, and so the following allows general makefile support as well – assuming GNU make because of the use of the shell macro expansions.  Additionally, though many times julia-config.jl may be found in the directory /usr/local, this is not necessarily the case, but Julia can be used to locate julia-config.jl too, and the makefile can be used to take advantage of that.  The above example is extended to use a Makefile:JL_SHARE = $(shell julia -e \'print(joinpath(Sys.BINDIR, Base.DATAROOTDIR, \"julia\"))\')\nCFLAGS   += $(shell $(JL_SHARE)/julia-config.jl --cflags)\nCXXFLAGS += $(shell $(JL_SHARE)/julia-config.jl --cflags)\nLDFLAGS  += $(shell $(JL_SHARE)/julia-config.jl --ldflags)\nLDLIBS   += $(shell $(JL_SHARE)/julia-config.jl --ldlibs)\n\nall: embed_exampleNow the build command is simply make."
},

{
    "location": "manual/embedding.html#High-Level-Embedding-on-Windows-with-Visual-Studio-1",
    "page": "Embedding Julia",
    "title": "High-Level Embedding on Windows with Visual Studio",
    "category": "section",
    "text": "If the JULIA_DIR environment variable hasn\'t been setup, add it using the System panel before starting Visual Studio. The bin folder under JULIA_DIR should be on the system PATH.We start by opening Visual Studio and creating a new Console Application project. To the \'stdafx.h\' header file, add the following lines at the end:#define JULIA_ENABLE_THREADING\n#include <julia.h>Then, replace the main() function in the project with this code:int main(int argc, char *argv[])\n{\n    /* required: setup the Julia context */\n    jl_init();\n\n    /* run Julia commands */\n    jl_eval_string(\"print(sqrt(2.0))\");\n\n    /* strongly recommended: notify Julia that the\n         program is about to terminate. this allows\n         Julia time to cleanup pending write requests\n         and run all finalizers\n    */\n    jl_atexit_hook(0);\n    return 0;\n}The next step is to set up the project to find the Julia include files and the libraries. It\'s important to know whether the Julia installation is 32- or 64-bits. Remove any platform configuration that doesn\'t correspond to the Julia installation before proceeding.Using the project Properties dialog, go to C/C++ | General and add $(JULIA_DIR)\\include\\julia\\ to the Additional Include Directories property. Then, go to the Linker | General section and add $(JULIA_DIR)\\lib to the Additional Library Directories property. Finally, under Linker | Input, add libjulia.dll.a;libopenlibm.dll.a; to the list of libraries.At this point, the project should build and run."
},

{
    "location": "manual/embedding.html#Converting-Types-1",
    "page": "Embedding Julia",
    "title": "Converting Types",
    "category": "section",
    "text": "Real applications will not just need to execute expressions, but also return their values to the host program. jl_eval_string returns a jl_value_t*, which is a pointer to a heap-allocated Julia object. Storing simple data types like Float64 in this way is called boxing, and extracting the stored primitive data is called unboxing. Our improved sample program that calculates the square root of 2 in Julia and reads back the result in C looks as follows:jl_value_t *ret = jl_eval_string(\"sqrt(2.0)\");\n\nif (jl_typeis(ret, jl_float64_type)) {\n    double ret_unboxed = jl_unbox_float64(ret);\n    printf(\"sqrt(2.0) in C: %e \\n\", ret_unboxed);\n}\nelse {\n    printf(\"ERROR: unexpected return type from sqrt(::Float64)\\n\");\n}In order to check whether ret is of a specific Julia type, we can use the jl_isa, jl_typeis, or jl_is_... functions. By typing typeof(sqrt(2.0)) into the Julia shell we can see that the return type is Float64 (double in C). To convert the boxed Julia value into a C double the jl_unbox_float64 function is used in the above code snippet.Corresponding jl_box_... functions are used to convert the other way:jl_value_t *a = jl_box_float64(3.0);\njl_value_t *b = jl_box_float32(3.0f);\njl_value_t *c = jl_box_int32(3);As we will see next, boxing is required to call Julia functions with specific arguments."
},

{
    "location": "manual/embedding.html#Calling-Julia-Functions-1",
    "page": "Embedding Julia",
    "title": "Calling Julia Functions",
    "category": "section",
    "text": "While jl_eval_string allows C to obtain the result of a Julia expression, it does not allow passing arguments computed in C to Julia. For this you will need to invoke Julia functions directly, using jl_call:jl_function_t *func = jl_get_function(jl_base_module, \"sqrt\");\njl_value_t *argument = jl_box_float64(2.0);\njl_value_t *ret = jl_call1(func, argument);In the first step, a handle to the Julia function sqrt is retrieved by calling jl_get_function. The first argument passed to jl_get_function is a pointer to the Base module in which sqrt is defined. Then, the double value is boxed using jl_box_float64. Finally, in the last step, the function is called using jl_call1. jl_call0, jl_call2, and jl_call3 functions also exist, to conveniently handle different numbers of arguments. To pass more arguments, use jl_call:jl_value_t *jl_call(jl_function_t *f, jl_value_t **args, int32_t nargs)Its second argument args is an array of jl_value_t* arguments and nargs is the number of arguments."
},

{
    "location": "manual/embedding.html#Memory-Management-1",
    "page": "Embedding Julia",
    "title": "Memory Management",
    "category": "section",
    "text": "As we have seen, Julia objects are represented in C as pointers. This raises the question of who is responsible for freeing these objects.Typically, Julia objects are freed by a garbage collector (GC), but the GC does not automatically know that we are holding a reference to a Julia value from C. This means the GC can free objects out from under you, rendering pointers invalid.The GC can only run when Julia objects are allocated. Calls like jl_box_float64 perform allocation, and allocation might also happen at any point in running Julia code. However, it is generally safe to use pointers in between jl_... calls. But in order to make sure that values can survive jl_... calls, we have to tell Julia that we hold a reference to a Julia value. This can be done using the JL_GC_PUSH macros:jl_value_t *ret = jl_eval_string(\"sqrt(2.0)\");\nJL_GC_PUSH1(&ret);\n// Do something with ret\nJL_GC_POP();The JL_GC_POP call releases the references established by the previous JL_GC_PUSH. Note that JL_GC_PUSH  is working on the stack, so it must be exactly paired with a JL_GC_POP before the stack frame is destroyed.Several Julia values can be pushed at once using the JL_GC_PUSH2 , JL_GC_PUSH3 , and JL_GC_PUSH4 macros. To push an array of Julia values one can use the  JL_GC_PUSHARGS macro, which can be used as follows:jl_value_t **args;\nJL_GC_PUSHARGS(args, 2); // args can now hold 2 `jl_value_t*` objects\nargs[0] = some_value;\nargs[1] = some_other_value;\n// Do something with args (e.g. call jl_... functions)\nJL_GC_POP();The garbage collector also operates under the assumption that it is aware of every old-generation object pointing to a young-generation one. Any time a pointer is updated breaking that assumption, it must be signaled to the collector with the jl_gc_wb (write barrier) function like so:jl_value_t *parent = some_old_value, *child = some_young_value;\n((some_specific_type*)parent)->field = child;\njl_gc_wb(parent, child);It is in general impossible to predict which values will be old at runtime, so the write barrier must be inserted after all explicit stores. One notable exception is if the parent object was just allocated and garbage collection was not run since then. Remember that most jl_... functions can sometimes invoke garbage collection.The write barrier is also necessary for arrays of pointers when updating their data directly. For example:jl_array_t *some_array = ...; // e.g. a Vector{Any}\nvoid **data = (void**)jl_array_data(some_array);\njl_value_t *some_value = ...;\ndata[0] = some_value;\njl_gc_wb(some_array, some_value);"
},

{
    "location": "manual/embedding.html#Manipulating-the-Garbage-Collector-1",
    "page": "Embedding Julia",
    "title": "Manipulating the Garbage Collector",
    "category": "section",
    "text": "There are some functions to control the GC. In normal use cases, these should not be necessary.Function Description\njl_gc_collect() Force a GC run\njl_gc_enable(0) Disable the GC, return previous state as int\njl_gc_enable(1) Enable the GC,  return previous state as int\njl_gc_is_enabled() Return current state as int"
},

{
    "location": "manual/embedding.html#Working-with-Arrays-1",
    "page": "Embedding Julia",
    "title": "Working with Arrays",
    "category": "section",
    "text": "Julia and C can share array data without copying. The next example will show how this works.Julia arrays are represented in C by the datatype jl_array_t*. Basically, jl_array_t is a struct that contains:Information about the datatype\nA pointer to the data block\nInformation about the sizes of the arrayTo keep things simple, we start with a 1D array. Creating an array containing Float64 elements of length 10 is done by:jl_value_t* array_type = jl_apply_array_type((jl_value_t*)jl_float64_type, 1);\njl_array_t* x          = jl_alloc_array_1d(array_type, 10);Alternatively, if you have already allocated the array you can generate a thin wrapper around its data:double *existingArray = (double*)malloc(sizeof(double)*10);\njl_array_t *x = jl_ptr_to_array_1d(array_type, existingArray, 10, 0);The last argument is a boolean indicating whether Julia should take ownership of the data. If this argument is non-zero, the GC will call free on the data pointer when the array is no longer referenced.In order to access the data of x, we can use jl_array_data:double *xData = (double*)jl_array_data(x);Now we can fill the array:for(size_t i=0; i<jl_array_len(x); i++)\n    xData[i] = i;Now let us call a Julia function that performs an in-place operation on x:jl_function_t *func = jl_get_function(jl_base_module, \"reverse!\");\njl_call1(func, (jl_value_t*)x);By printing the array, one can verify that the elements of x are now reversed."
},

{
    "location": "manual/embedding.html#Accessing-Returned-Arrays-1",
    "page": "Embedding Julia",
    "title": "Accessing Returned Arrays",
    "category": "section",
    "text": "If a Julia function returns an array, the return value of jl_eval_string and jl_call can be cast to a jl_array_t*:jl_function_t *func  = jl_get_function(jl_base_module, \"reverse\");\njl_array_t *y = (jl_array_t*)jl_call1(func, (jl_value_t*)x);Now the content of y can be accessed as before using jl_array_data. As always, be sure to keep a reference to the array while it is in use."
},

{
    "location": "manual/embedding.html#Multidimensional-Arrays-1",
    "page": "Embedding Julia",
    "title": "Multidimensional Arrays",
    "category": "section",
    "text": "Julia\'s multidimensional arrays are stored in memory in column-major order. Here is some code that creates a 2D array and accesses its properties:// Create 2D array of float64 type\njl_value_t *array_type = jl_apply_array_type(jl_float64_type, 2);\njl_array_t *x  = jl_alloc_array_2d(array_type, 10, 5);\n\n// Get array pointer\ndouble *p = (double*)jl_array_data(x);\n// Get number of dimensions\nint ndims = jl_array_ndims(x);\n// Get the size of the i-th dim\nsize_t size0 = jl_array_dim(x,0);\nsize_t size1 = jl_array_dim(x,1);\n\n// Fill array with data\nfor(size_t i=0; i<size1; i++)\n    for(size_t j=0; j<size0; j++)\n        p[j + size0*i] = i + j;Notice that while Julia arrays use 1-based indexing, the C API uses 0-based indexing (for example in calling jl_array_dim) in order to read as idiomatic C code."
},

{
    "location": "manual/embedding.html#Exceptions-1",
    "page": "Embedding Julia",
    "title": "Exceptions",
    "category": "section",
    "text": "Julia code can throw exceptions. For example, consider:jl_eval_string(\"this_function_does_not_exist()\");This call will appear to do nothing. However, it is possible to check whether an exception was thrown:if (jl_exception_occurred())\n    printf(\"%s \\n\", jl_typeof_str(jl_exception_occurred()));If you are using the Julia C API from a language that supports exceptions (e.g. Python, C#, C++), it makes sense to wrap each call into libjulia with a function that checks whether an exception was thrown, and then rethrows the exception in the host language."
},

{
    "location": "manual/embedding.html#Throwing-Julia-Exceptions-1",
    "page": "Embedding Julia",
    "title": "Throwing Julia Exceptions",
    "category": "section",
    "text": "When writing Julia callable functions, it might be necessary to validate arguments and throw exceptions to indicate errors. A typical type check looks like:if (!jl_typeis(val, jl_float64_type)) {\n    jl_type_error(function_name, (jl_value_t*)jl_float64_type, val);\n}General exceptions can be raised using the functions:void jl_error(const char *str);\nvoid jl_errorf(const char *fmt, ...);jl_error takes a C string, and jl_errorf is called like printf:jl_errorf(\"argument x = %d is too large\", x);where in this example x is assumed to be an integer."
},

{
    "location": "manual/code-loading.html#",
    "page": "Code Loading",
    "title": "Code Loading",
    "category": "page",
    "text": ""
},

{
    "location": "manual/code-loading.html#Code-Loading-1",
    "page": "Code Loading",
    "title": "Code Loading",
    "category": "section",
    "text": "note: Note\nThis chapter covers the technical details of package loading. To install packages, use Pkg, Julia\'s built-in package manager, to add packages to your active environment. To use packages already in your active environment, write import X or using X, as described in the Modules documentation."
},

{
    "location": "manual/code-loading.html#Definitions-1",
    "page": "Code Loading",
    "title": "Definitions",
    "category": "section",
    "text": "Julia has two mechanisms for loading code:Code inclusion: e.g. include(\"source.jl\"). Inclusion allows you to split a single program across multiple source files. The expression include(\"source.jl\") causes the contents of the file source.jl to be evaluated in the global scope of the module where the include call occurs. If include(\"source.jl\") is called multiple times, source.jl is evaluated multiple times. The included path, source.jl, is interpreted relative to the file where the include call occurs. This makes it simple to relocate a subtree of source files. In the REPL, included paths are interpreted relative to the current working directory, pwd().\nPackage loading: e.g. import X or using X. The import mechanism allows you to load a package—i.e. an independent, reusable collection of Julia code, wrapped in a module—and makes the resulting module available by the name X inside of the importing module. If the same X package is imported multiple times in the same Julia session, it is only loaded the first time—on subsequent imports, the importing module gets a reference to the same module. Note though, that import X can load different packages in different contexts: X can refer to one package named X in the main project but potentially to different packages also named X in each dependency. More on this below.Code inclusion is quite straightforward and simple: it evaluates the given source file in the context of the caller. Package loading is built on top of code inclusion and serves a different purpose. The rest of this chapter focuses on the behavior and mechanics of package loading.A package is a source tree with a standard layout providing functionality that can be reused by other Julia projects. A package is loaded by import X or  using X statements. These statements also make the module named X—which results from loading the package code—available within the module where the import statement occurs. The meaning of X in import X is context-dependent: which X package is loaded depends on what code the statement occurs in. Thus, handling of import X happens in two stages: first, it determines what package is defined to be X in this context; second, it determines where that particular X package is found.These questions are answered by searching through the project environments listed in LOAD_PATH for project files (Project.toml or JuliaProject.toml), manifest files (Manifest.toml or JuliaManifest.toml), or folders of source files."
},

{
    "location": "manual/code-loading.html#Federation-of-packages-1",
    "page": "Code Loading",
    "title": "Federation of packages",
    "category": "section",
    "text": "Most of the time, a package is uniquely identifiable simply from its name. However, sometimes a project might encounter a situation where it needs to use two different packages that share the same name. While you might be able fix this by renaming one of the packages, being forced to do so can be highly disruptive in a large, shared code base. Instead, Julia\'s code loading mechanism allows the same package name to refer to different packages in different components of an application.Julia supports federated package management, which means that multiple independent parties can maintain both public and private packages and registries of packages, and that projects can depend on a mix of public and private packages from different registries. Packages from various registries are installed and managed using a common set of tools and workflows. The Pkg package manager that ships with Julia lets you install and manage your projects\' dependencies. It assists in creating and manipulating project files (which describe what other projects that your project depends on), and manifest files (which snapshot exact versions of your project\'s complete dependency graph).One consequence of federation is that there cannot be a central authority for package naming. Different entities may use the same name to refer to unrelated packages. This possibility is unavoidable since these entities do not coordinate and may not even know about each other. Because of the lack of a central naming authority, a single project may end up depending on different packages that have the same name. Julia\'s package loading mechanism does not require package names to be globally unique, even within the dependency graph of a single project. Instead, packages are identified by universally unique identifiers (UUIDs), which get assigned when each package is created. Usually you won\'t have to work directly with these somewhat cumbersome 128-bit identifiers since Pkg will take care of generating and tracking them for you. However, these UUIDs provide the definitive answer to the question of \"what package does X refer to?\"Since the decentralized naming problem is somewhat abstract, it may help to walk through a concrete scenario to understand the issue. Suppose you\'re developing an application called App, which uses two packages: Pub and  Priv. Priv is a private package that you created, whereas Pub is a public package that you use but don\'t control. When you created Priv, there was no public package by the name Priv. Subsequently, however, an unrelated package also named Priv has been published and become popular. In fact, the Pub package has started to use it. Therefore, when you next upgrade Pub to get the latest bug fixes and features, App will end up depending on two different packages named Priv—through no action of yours other than upgrading. App has a direct dependency on your private Priv package, and an indirect dependency, through Pub, on the new public Priv package. Since these two Priv packages are different but are both required for App to continue working correctly, the expression import Priv must refer to different Priv packages depending on whether it occurs in App\'s code or in Pub\'s code. To handle this, Julia\'s package loading mechanism distinguishes the two Priv packages by their UUID and picks the correct one based on its context (the module that called import). How this distinction works is determined by environments, as explained in the following sections."
},

{
    "location": "manual/code-loading.html#Environments-1",
    "page": "Code Loading",
    "title": "Environments",
    "category": "section",
    "text": "An environment determines what import X and using X mean in various code contexts and what files these statements cause to be loaded. Julia understands two kinds of environments:A project environment is a directory with a project file and an optional manifest file, and forms an explicit environement. The project file determines what the names and identities of the direct dependencies of a project are. The manifest file, if present, gives a complete dependency graph, including all direct and indirect dependencies, exact versions of each dependency, and sufficient information to locate and load the correct version.\nA package directory is a directory containing the source trees of a set of packages as subdirectories, and forms an implicit environment. If X is a subdirectory of a package directory and X/src/X.jl exists, then the package X is available in the package directory environment and X/src/X.jl is the source file by which it is loaded.These can be intermixed to create a stacked environment: an ordered set of project environments and package directories, overlaid to make a single composite environment. The precedence and visibility rules then combine to determine which packages are available and where they get loaded from. Julia\'s load path forms a stacked environment, for example.These environment each serve a different purpose:Project environments provide reproducibility. By checking a project environment into version control—e.g. a git repository—along with the rest of the project\'s source code, you can reproduce the exact state of the project and all of its dependencies. The manifest file, in particular, captures the exact version of every dependency, identified by a cryptographic hash of its source tree, which makes it possible for Pkg to retrieve the correct versions and be sure that you are running the exact code that was recorded for all dependencies.\nPackage directories provide convenience when a full carefully-tracked project environment is unnecessary. They are useful when you want to put a set of packages somewhere and be able to directly use them, without needing to create a project environment for them.\nStacked environments allow for adding tools to the primary environment. You can push an environment of development tools onto the end of the stack to make them available from the REPL and scripts, but not from inside packages.At a high-level, each environment conceptually defines three maps: roots, graph and paths. When resolving the meaning of import X, the roots and graph maps are used to determine the identity of X, while the paths map is used to locate the source code of X. The specific roles of the three maps are:roots: name::Symbol ⟶ uuid::UUID\nAn environment\'s roots map assigns package names to UUIDs for all the top-level dependencies that the environment makes available to the main project (i.e. the ones that can be loaded in Main). When Julia encounters import X in the main project, it looks up the identity of X as roots[:X].\ngraph: context::UUID ⟶ name::Symbol ⟶ uuid::UUID\nAn environment\'s graph is a multilevel map which assigns, for each context UUID, a map from names to UUIDs, similar to the roots map but specific to that context. When Julia sees import X in the code of the package whose UUID is context, it looks up the identity of X as graph[context][:X]. In particular, this means that import X can refer to different packages depending on context.\npaths: uuid::UUID × name::Symbol ⟶ path::String\nThe paths map assigns to each package UUID-name pair, the location of that package\'s entry-point source file. After the identity of X in import X has been resolved to a UUID via roots or graph (depending on whether it is loaded from the main project or a dependency), Julia determines what file to load to acquire X by looking up paths[uuid,:X] in the environment. Including this file should define a module named X. Once this package is loaded, any subsequent import resolving to the same uuid will create a new binding to the already-loaded package module.Each kind of environment defines these three maps differently, as detailed in the following sections.note: Note\nFor ease of understanding, the examples throughout this chapter show full data structures for roots, graph and paths. However, Julia\'s package loading code does not explicitly create these. Instead, it lazily computes only as much of each structure as it needs to load a given package."
},

{
    "location": "manual/code-loading.html#Project-environments-1",
    "page": "Code Loading",
    "title": "Project environments",
    "category": "section",
    "text": "A project environment is determined by a directory containing a project file called Project.toml, and optionally a manifest file called Manifest.toml. These files may also be called JuliaProject.toml and JuliaManifest.toml, in which case Project.toml and Manifest.toml are ignored. This allows for coexistence with other tools that might consider files called Project.toml and Manifest.toml significant. For pure Julia projects, however, the names Project.toml and Manifest.toml are preferred.The roots, graph and paths maps of a project environment are defined as follows:The roots map of the environment is determined by the contents of the project file, specifically, its top-level name and uuid entries and its [deps] section (all optional). Consider the following example project file for the hypothetical application, App, as described earlier:name = \"App\"\nuuid = \"8f986787-14fe-4607-ba5d-fbff2944afa9\"\n\n[deps]\nPriv = \"ba13f791-ae1d-465a-978b-69c3ad90f72b\"\nPub  = \"c07ecb7d-0dc9-4db7-8803-fadaaeaf08e1\"This project file implies the following roots map, if it was represented by a Julia dictionary:roots = Dict(\n    :App  => UUID(\"8f986787-14fe-4607-ba5d-fbff2944afa9\"),\n    :Priv => UUID(\"ba13f791-ae1d-465a-978b-69c3ad90f72b\"),\n    :Pub  => UUID(\"c07ecb7d-0dc9-4db7-8803-fadaaeaf08e1\"),\n)Given this roots map, in App\'s code the statement import Priv will cause Julia to look up roots[:Priv], which yields ba13f791-ae1d-465a-978b-69c3ad90f72b, the UUID of the Priv package that is to be loaded in that context. This UUID identifies which Priv package to load and use when the main application evaluates import Priv.The dependency graph of a project environment is determined by the contents of the manifest file, if present. If there is no manifest file, graph is empty. A manifest file contains a stanza for each of a project\'s direct or indirect dependencies. For each dependency, the file lists the package\'s UUID and a source tree hash or an explicit path to the source code. Consider the following example manifest file for App:[[Priv]] # the private one\ndeps = [\"Pub\", \"Zebra\"]\nuuid = \"ba13f791-ae1d-465a-978b-69c3ad90f72b\"\npath = \"deps/Priv\"\n\n[[Priv]] # the public one\nuuid = \"2d15fe94-a1f7-436c-a4d8-07a9a496e01c\"\ngit-tree-sha1 = \"1bf63d3be994fe83456a03b874b409cfd59a6373\"\nversion = \"0.1.5\"\n\n[[Pub]]\nuuid = \"c07ecb7d-0dc9-4db7-8803-fadaaeaf08e1\"\ngit-tree-sha1 = \"9ebd50e2b0dd1e110e842df3b433cb5869b0dd38\"\nversion = \"2.1.4\"\n\n  [Pub.deps]\n  Priv = \"2d15fe94-a1f7-436c-a4d8-07a9a496e01c\"\n  Zebra = \"f7a24cb4-21fc-4002-ac70-f0e3a0dd3f62\"\n\n[[Zebra]]\nuuid = \"f7a24cb4-21fc-4002-ac70-f0e3a0dd3f62\"\ngit-tree-sha1 = \"e808e36a5d7173974b90a15a353b564f3494092f\"\nversion = \"3.4.2\"This manifest file describes a possible complete dependency graph for the App project:There are two different packages named Priv that the application uses. It uses a private package, which is a root dependency, and a public one, which is an indirect dependency through Pub. These are differentiated by their distinct UUIDs, and they have different deps:\nThe private Priv depends on the Pub and Zebra packages.\nThe public Priv has no dependencies.\nThe application also depends on the Pub package, which in turn depends on the public Priv and the same Zebra package that the private Priv package depends on.This dependency graph represented as a dictionary, looks like this:graph = Dict(\n    # Priv – the private one:\n    UUID(\"ba13f791-ae1d-465a-978b-69c3ad90f72b\") => Dict(\n        :Pub   => UUID(\"c07ecb7d-0dc9-4db7-8803-fadaaeaf08e1\"),\n        :Zebra => UUID(\"f7a24cb4-21fc-4002-ac70-f0e3a0dd3f62\"),\n    ),\n    # Priv – the public one:\n    UUID(\"2d15fe94-a1f7-436c-a4d8-07a9a496e01c\") => Dict(),\n    # Pub:\n    UUID(\"c07ecb7d-0dc9-4db7-8803-fadaaeaf08e1\") => Dict(\n        :Priv  => UUID(\"2d15fe94-a1f7-436c-a4d8-07a9a496e01c\"),\n        :Zebra => UUID(\"f7a24cb4-21fc-4002-ac70-f0e3a0dd3f62\"),\n    ),\n    # Zebra:\n    UUID(\"f7a24cb4-21fc-4002-ac70-f0e3a0dd3f62\") => Dict(),\n)Given this dependency graph, when Julia sees import Priv in the Pub package—which has UUID c07ecb7d-0dc9-4db7-8803-fadaaeaf08e1—it looks up:graph[UUID(\"c07ecb7d-0dc9-4db7-8803-fadaaeaf08e1\")][:Priv]and gets 2d15fe94-a1f7-436c-a4d8-07a9a496e01c, which indicates that in the context of the Pub package, import Priv refers to the public Priv package, rather than the private one which the app depends on directly. This is how the name Priv can refer to different packages in the main project than it does in one of its package\'s dependencies, which allows for duplicate names in the package ecosystem.What happens if import Zebra is evaluated in the main App code base? Since Zebra does not appear in the project file, the import will fail even though Zebra does appear in the manifest file. Moreover, if import Zebra occurs in the public Priv package—the one with UUID 2d15fe94-a1f7-436c-a4d8-07a9a496e01c—then that would also fail since that Priv package has no declared dependencies in the manifest file and therefore cannot load any packages. The Zebra package can only be loaded by packages for which it appear as an explicit dependency in the manifest file: the  Pub package and one of the Priv packages.The paths map of a project environment is extracted from the manifest file. The path of a package uuid named X is determined by these rules (in order):If the project file in the directory matches uuid and name X, then either:It has a toplevel path entry, then uuid will be mapped to that path, interpreted relative to the directory containing the project file.\nOtherwise, uuid is mapped to  src/X.jl relative to the directory containing the project file.If the above is not the case and the project file has a corresponding manifest file and the manifest contains a stanza matching uuid then:If it has a path entry, use that path (relative to the directory containing the manifest file).\nIf it has a git-tree-sha1 entry, compute a deterministic hash function of uuid and git-tree-sha1—call it slug—and look for a directory named packages/X/$slug in each directory in the Julia DEPOT_PATH global array. Use the first such directory that exists.If any of these result in success, the path to the source code entry point will be either that result, the relative path from that result plus src/X.jl; otherwise, there is no path mapping for uuid. When loading X, if no source code path is found, the lookup will fail, and the user may be prompted to install the appropriate package version or to take other corrective action (e.g. declaring X as a dependency).In the example manifest file above, to find the path of the first Priv package—the one with UUID ba13f791-ae1d-465a-978b-69c3ad90f72b—Julia looks for its stanza in the manifest file, sees that it has a path entry, looks at deps/Priv relative to the App project directory—let\'s suppose the App code lives in /home/me/projects/App—sees that /home/me/projects/App/deps/Priv exists and therefore loads Priv from there.If, on the other hand, Julia was loading the other Priv package—the one with UUID 2d15fe94-a1f7-436c-a4d8-07a9a496e01c—it finds its stanza in the manifest, see that it does not have a path entry, but that it does have a git-tree-sha1 entry. It then computes the slug for this UUID/SHA-1 pair, which is HDkrT (the exact details of this computation aren\'t important, but it is consistent and deterministic). This means that the path to this Priv package will be packages/Priv/HDkrT/src/Priv.jl in one of the package depots. Suppose the contents of DEPOT_PATH is [\"/home/me/.julia\", \"/usr/local/julia\"], then Julia will look at the following paths to see if they exist:/home/me/.julia/packages/Priv/HDkrT\n/usr/local/julia/packages/Priv/HDkrTJulia uses the first of these that exists to try to load the public Priv package from the file packages/Priv/HDKrT/src/Priv.jl in the depot where it was found.Here is a representation of a possible paths map for our example App project environment, as provided in the Manifest given above for the dependency graph, after searching the local file system:paths = Dict(\n    # Priv – the private one:\n    (UUID(\"ba13f791-ae1d-465a-978b-69c3ad90f72b\"), :Priv) =>\n        # relative entry-point inside `App` repo:\n        \"/home/me/projects/App/deps/Priv/src/Priv.jl\",\n    # Priv – the public one:\n    (UUID(\"2d15fe94-a1f7-436c-a4d8-07a9a496e01c\"), :Priv) =>\n        # package installed in the system depot:\n        \"/usr/local/julia/packages/Priv/HDkr/src/Priv.jl\",\n    # Pub:\n    (UUID(\"c07ecb7d-0dc9-4db7-8803-fadaaeaf08e1\"), :Pub) =>\n        # package installed in the user depot:\n        \"/home/me/.julia/packages/Pub/oKpw/src/Pub.jl\",\n    # Zebra:\n    (UUID(\"f7a24cb4-21fc-4002-ac70-f0e3a0dd3f62\"), :Zebra) =>\n        # package installed in the system depot:\n        \"/usr/local/julia/packages/Zebra/me9k/src/Zebra.jl\",\n)This example map includes three different kinds of package locations (the first and third are part of the default load path):The private Priv package is \"vendored\" inside the App repository.\nThe public Priv and Zebra packages are in the system depot, where packages installed and managed by the system administrator live. These are available to all users on the system.\nThe Pub package is in the user depot, where packages installed by the user live. These are only available to the user who installed them."
},

{
    "location": "manual/code-loading.html#Package-directories-1",
    "page": "Code Loading",
    "title": "Package directories",
    "category": "section",
    "text": "Package directories provide a simpler kind of environment without the ability to handle name collisions. In a package directory, the set of top-level packages is the set of subdirectories that \"look like\" packages. A package X is exists in a package directory if the directory contains one of the following \"entry point\" files:X.jl\nX/src/X.jl\nX.jl/src/X.jlWhich dependencies a package in a package directory can import depends on whether the package contains a project file:If it has a project file, it can only import those packages which are identified in the [deps] section of the project file.\nIf it does not have a project file, it can import any top-level package—i.e. the same packages that can be loaded in Main or the REPL.The roots map is determined by examining the contents of the package directory to generate a list of all packages that exist. Additionally, a UUID will be assigned to each entry as follows: For a given package found inside the folder X...If X/Project.toml exists and has a uuid entry, then uuid is that value.\nIf X/Project.toml exists and but does not have a top-level UUID entry, uuid is a dummy UUID generated by hashing the canonical (real) path to X/Project.toml.\nOtherwise (if Project.toml does not exist), then uuid is the all-zero nil UUID.The dependency graph of a project directory is determined by the presence and contents of project files in the subdirectory of each package. The rules are:If a package subdirectory has no project file, then it is omitted from graph and import statements in its code are treated as top-level, the same as the main project and REPL.\nIf a package subdirectory has a project file, then the graph entry for its UUID is the [deps] map of the project file, which is considered to be empty if the section is absent.As an example, suppose a package directory has the following structure and content:Aardvark/\n    src/Aardvark.jl:\n        import Bobcat\n        import Cobra\n\nBobcat/\n    Project.toml:\n        [deps]\n        Cobra = \"4725e24d-f727-424b-bca0-c4307a3456fa\"\n        Dingo = \"7a7925be-828c-4418-bbeb-bac8dfc843bc\"\n\n    src/Bobcat.jl:\n        import Cobra\n        import Dingo\n\nCobra/\n    Project.toml:\n        uuid = \"4725e24d-f727-424b-bca0-c4307a3456fa\"\n        [deps]\n        Dingo = \"7a7925be-828c-4418-bbeb-bac8dfc843bc\"\n\n    src/Cobra.jl:\n        import Dingo\n\nDingo/\n    Project.toml:\n        uuid = \"7a7925be-828c-4418-bbeb-bac8dfc843bc\"\n\n    src/Dingo.jl:\n        # no importsHere is a corresponding roots structure, represented as a dictionary:roots = Dict(\n    :Aardvark => UUID(\"00000000-0000-0000-0000-000000000000\"), # no project file, nil UUID\n    :Bobcat   => UUID(\"85ad11c7-31f6-5d08-84db-0a4914d4cadf\"), # dummy UUID based on path\n    :Cobra    => UUID(\"4725e24d-f727-424b-bca0-c4307a3456fa\"), # UUID from project file\n    :Dingo    => UUID(\"7a7925be-828c-4418-bbeb-bac8dfc843bc\"), # UUID from project file\n)Here is the corresponding graph structure, represented as a dictionary:graph = Dict(\n    # Bobcat:\n    UUID(\"85ad11c7-31f6-5d08-84db-0a4914d4cadf\") => Dict(\n        :Cobra => UUID(\"4725e24d-f727-424b-bca0-c4307a3456fa\"),\n        :Dingo => UUID(\"7a7925be-828c-4418-bbeb-bac8dfc843bc\"),\n    ),\n    # Cobra:\n    UUID(\"4725e24d-f727-424b-bca0-c4307a3456fa\") => Dict(\n        :Dingo => UUID(\"7a7925be-828c-4418-bbeb-bac8dfc843bc\"),\n    ),\n    # Dingo:\n    UUID(\"7a7925be-828c-4418-bbeb-bac8dfc843bc\") => Dict(),\n)A few general rules to note:A package without a project file can depend on any top-level dependency, and since every package in a package directory is available at the top-level, it can import all packages in the environment.\nA package with a project file cannot depend on one without a project file since packages with project files can only load packages in graph and packages without project files do not appear in graph.\nA package with a project file but no explicit UUID can only be depended on by packages without project files since dummy UUIDs assigned to these packages are strictly internal.Observe the following specific instances of these rules in our example:Aardvark can import on any of Bobcat, Cobra or Dingo; it does import Bobcat and Cobra.\nBobcat can and does import both Cobra and Dingo, which both have project files with UUIDs and are declared as dependencies in Bobcat\'s [deps] section.\nBobcat cannot depend on Aardvark since Aardvark does not have a project file.\nCobra can and does import Dingo, which has a project file and UUID, and is declared as a dependency in Cobra\'s  [deps] section.\nCobra cannot depend on Aardvark or Bobcat since neither have real UUIDs.\nDingo cannot import anything because it has a project file without a [deps] section.The paths map in a package directory is simple: it maps subdirectory names to their corresponding entry-point paths. In other words, if the path to our example project directory is /home/me/animals then the paths map could be represented by this dictionary:paths = Dict(\n    (UUID(\"00000000-0000-0000-0000-000000000000\"), :Aardvark) =>\n        \"/home/me/AnimalPackages/Aardvark/src/Aardvark.jl\",\n    (UUID(\"85ad11c7-31f6-5d08-84db-0a4914d4cadf\"), :Bobcat) =>\n        \"/home/me/AnimalPackages/Bobcat/src/Bobcat.jl\",\n    (UUID(\"4725e24d-f727-424b-bca0-c4307a3456fa\"), :Cobra) =>\n        \"/home/me/AnimalPackages/Cobra/src/Cobra.jl\",\n    (UUID(\"7a7925be-828c-4418-bbeb-bac8dfc843bc\"), :Dingo) =>\n        \"/home/me/AnimalPackages/Dingo/src/Dingo.jl\",\n)Since all packages in a package directory environment are, by definition, subdirectories with the expected entry-point files, their paths map entries always have this form."
},

{
    "location": "manual/code-loading.html#Environment-stacks-1",
    "page": "Code Loading",
    "title": "Environment stacks",
    "category": "section",
    "text": "The third and final kind of environment is one that combines other environments by overlaying several of them, making the packages in each available in a single composite environment. These composite environments are called environment stacks. The Julia LOAD_PATH global defines an environment stack—the environment in which the Julia process operates. If you want your Julia process to have access only to the packages in one project or package directory, make it the only entry in LOAD_PATH. It is often quite useful, however, to have access to some of your favorite tools—standard libraries, profilers, debuggers, personal utilities, etc.—even if they are not dependencies of the project you\'re working on. By adding an environment containing these tools to the load path, you immediately have access to them in top-level code without needing to add them to your project.The mechanism for combining the roots, graph and paths data structures of the components of an environment stack is simple: they are merged as dictionaries, favoring earlier entries over later ones in the case of key collisions. In other words, if we have stack = [env₁, env₂, …] then we have:roots = reduce(merge, reverse([roots₁, roots₂, …]))\ngraph = reduce(merge, reverse([graph₁, graph₂, …]))\npaths = reduce(merge, reverse([paths₁, paths₂, …]))The subscripted rootsᵢ, graphᵢ and pathsᵢ variables correspond to the subscripted environments, envᵢ, contained in stack. The reverse is present because merge favors the last argument rather than first when there are collisions between keys in its argument dictionaries. There are a couple of noteworthy features of this design:The primary environment—i.e. the first environment in a stack—is faithfully embedded in a stacked environment. The full dependency graph of the first environment in a stack is guaranteed to be included intact in the stacked environment including the same versions of all dependencies.\nPackages in non-primary environments can end up using incompatible versions of their dependencies even if their own environments are entirely compatible. This can happen when one of their dependencies is shadowed by a version in an earlier environment in the stack (either by graph or path, or both).Since the primary environment is typically the environment of a project you\'re working on, while environments later in the stack contain additional tools, this is the right trade-off: it\'s better to break your development tools but keep the project working. When such incompatibilities occur, you\'ll typically want to upgrade your dev tools to versions that are compatible with the main project."
},

{
    "location": "manual/code-loading.html#Conclusion-1",
    "page": "Code Loading",
    "title": "Conclusion",
    "category": "section",
    "text": "Federated package management and precise software reproducibility are difficult but worthy goals in a package system. In combination, these goals lead to a more complex package loading mechanism than most dynamic languages have, but it also yields scalability and reproducibility that is more commonly associated with static languages. Typically, Julia users should be able to use the built-in package manager to manage their projects without needing a precise understanding of these interactions. A call to Pkg.add(\"X\") will add to the appropriate project and manifest files, selected via Pkg.activate(\"Y\"), so that a future call to import X will load X without further thought."
},

{
    "location": "manual/profile.html#",
    "page": "Profiling",
    "title": "Profiling",
    "category": "page",
    "text": ""
},

{
    "location": "manual/profile.html#Profiling-1",
    "page": "Profiling",
    "title": "Profiling",
    "category": "section",
    "text": "The Profile module provides tools to help developers improve the performance of their code. When used, it takes measurements on running code, and produces output that helps you understand how much time is spent on individual line(s). The most common usage is to identify \"bottlenecks\" as targets for optimization.Profile implements what is known as a \"sampling\" or statistical profiler.  It works by periodically taking a backtrace during the execution of any task. Each backtrace captures the currently-running function and line number, plus the complete chain of function calls that led to this line, and hence is a \"snapshot\" of the current state of execution.If much of your run time is spent executing a particular line of code, this line will show up frequently in the set of all backtraces. In other words, the \"cost\" of a given line–or really, the cost of the sequence of function calls up to and including this line–is proportional to how often it appears in the set of all backtraces.A sampling profiler does not provide complete line-by-line coverage, because the backtraces occur at intervals (by default, 1 ms on Unix systems and 10 ms on Windows, although the actual scheduling is subject to operating system load). Moreover, as discussed further below, because samples are collected at a sparse subset of all execution points, the data collected by a sampling profiler is subject to statistical noise.Despite these limitations, sampling profilers have substantial strengths:You do not have to make any modifications to your code to take timing measurements (in contrast to the alternative instrumenting profiler).\nIt can profile into Julia\'s core code and even (optionally) into C and Fortran libraries.\nBy running \"infrequently\" there is very little performance overhead; while profiling, your code can run at nearly native speed.For these reasons, it\'s recommended that you try using the built-in sampling profiler before considering any alternatives."
},

{
    "location": "manual/profile.html#Basic-usage-1",
    "page": "Profiling",
    "title": "Basic usage",
    "category": "section",
    "text": "Let\'s work with a simple test case:julia> function myfunc()\n           A = rand(200, 200, 400)\n           maximum(A)\n       endIt\'s a good idea to first run the code you intend to profile at least once (unless you want to profile Julia\'s JIT-compiler):julia> myfunc() # run once to force compilationNow we\'re ready to profile this function:julia> using Profile\n\njulia> @profile myfunc()To see the profiling results, there is a graphical browser available, but here we\'ll use the text-based display that comes with the standard library:julia> Profile.print()\n80 ./event.jl:73; (::Base.REPL.##1#2{Base.REPL.REPLBackend})()\n 80 ./REPL.jl:97; macro expansion\n  80 ./REPL.jl:66; eval_user_input(::Any, ::Base.REPL.REPLBackend)\n   80 ./boot.jl:235; eval(::Module, ::Any)\n    80 ./<missing>:?; anonymous\n     80 ./profile.jl:23; macro expansion\n      52 ./REPL[1]:2; myfunc()\n       38 ./random.jl:431; rand!(::MersenneTwister, ::Array{Float64,3}, ::Int64, ::Type{B...\n        38 ./dSFMT.jl:84; dsfmt_fill_array_close_open!(::Base.dSFMT.DSFMT_state, ::Ptr{F...\n       14 ./random.jl:278; rand\n        14 ./random.jl:277; rand\n         14 ./random.jl:366; rand\n          14 ./random.jl:369; rand\n      28 ./REPL[1]:3; myfunc()\n       28 ./reduce.jl:270; _mapreduce(::Base.#identity, ::Base.#scalarmax, ::IndexLinear,...\n        3  ./reduce.jl:426; mapreduce_impl(::Base.#identity, ::Base.#scalarmax, ::Array{F...\n        25 ./reduce.jl:428; mapreduce_impl(::Base.#identity, ::Base.#scalarmax, ::Array{F...Each line of this display represents a particular spot (line number) in the code. Indentation is used to indicate the nested sequence of function calls, with more-indented lines being deeper in the sequence of calls. In each line, the first \"field\" is the number of backtraces (samples) taken at this line or in any functions executed by this line. The second field is the file name and line number and the third field is the function name. Note that the specific line numbers may change as Julia\'s code changes; if you want to follow along, it\'s best to run this example yourself.In this example, we can see that the top level function called is in the file event.jl. This is the function that runs the REPL when you launch Julia. If you examine line 97 of REPL.jl, you\'ll see this is where the function eval_user_input() is called. This is the function that evaluates what you type at the REPL, and since we\'re working interactively these functions were invoked when we entered @profile myfunc(). The next line reflects actions taken in the @profile macro.The first line shows that 80 backtraces were taken at line 73 of event.jl, but it\'s not that this line was \"expensive\" on its own: the third line reveals that all 80 of these backtraces were actually triggered inside its call to eval_user_input, and so on. To find out which operations are actually taking the time, we need to look deeper in the call chain.The first \"important\" line in this output is this one:52 ./REPL[1]:2; myfunc()REPL refers to the fact that we defined myfunc in the REPL, rather than putting it in a file; if we had used a file, this would show the file name. The [1] shows that the function myfunc was the first expression evaluated in this REPL session. Line 2 of myfunc() contains the call to rand, and there were 52 (out of 80) backtraces that occurred at this line. Below that, you can see a call to dsfmt_fill_array_close_open! inside dSFMT.jl.A little further down, you see:28 ./REPL[1]:3; myfunc()Line 3 of myfunc contains the call to maximum, and there were 28 (out of 80) backtraces taken here. Below that, you can see the specific places in base/reduce.jl that carry out the time-consuming operations in the maximum function for this type of input data.Overall, we can tentatively conclude that generating the random numbers is approximately twice as expensive as finding the maximum element. We could increase our confidence in this result by collecting more samples:julia> @profile (for i = 1:100; myfunc(); end)\n\njulia> Profile.print()\n[....]\n 3821 ./REPL[1]:2; myfunc()\n  3511 ./random.jl:431; rand!(::MersenneTwister, ::Array{Float64,3}, ::Int64, ::Type...\n   3511 ./dSFMT.jl:84; dsfmt_fill_array_close_open!(::Base.dSFMT.DSFMT_state, ::Ptr...\n  310  ./random.jl:278; rand\n   [....]\n 2893 ./REPL[1]:3; myfunc()\n  2893 ./reduce.jl:270; _mapreduce(::Base.#identity, ::Base.#scalarmax, ::IndexLinea...\n   [....]In general, if you have N samples collected at a line, you can expect an uncertainty on the order of sqrt(N) (barring other sources of noise, like how busy the computer is with other tasks). The major exception to this rule is garbage collection, which runs infrequently but tends to be quite expensive. (Since Julia\'s garbage collector is written in C, such events can be detected using the C=true output mode described below, or by using ProfileView.jl.)This illustrates the default \"tree\" dump; an alternative is the \"flat\" dump, which accumulates counts independent of their nesting:julia> Profile.print(format=:flat)\n Count File          Line Function\n  6714 ./<missing>     -1 anonymous\n  6714 ./REPL.jl       66 eval_user_input(::Any, ::Base.REPL.REPLBackend)\n  6714 ./REPL.jl       97 macro expansion\n  3821 ./REPL[1]        2 myfunc()\n  2893 ./REPL[1]        3 myfunc()\n  6714 ./REPL[7]        1 macro expansion\n  6714 ./boot.jl      235 eval(::Module, ::Any)\n  3511 ./dSFMT.jl      84 dsfmt_fill_array_close_open!(::Base.dSFMT.DSFMT_s...\n  6714 ./event.jl      73 (::Base.REPL.##1#2{Base.REPL.REPLBackend})()\n  6714 ./profile.jl    23 macro expansion\n  3511 ./random.jl    431 rand!(::MersenneTwister, ::Array{Float64,3}, ::In...\n   310 ./random.jl    277 rand\n   310 ./random.jl    278 rand\n   310 ./random.jl    366 rand\n   310 ./random.jl    369 rand\n  2893 ./reduce.jl    270 _mapreduce(::Base.#identity, ::Base.#scalarmax, :...\n     5 ./reduce.jl    420 mapreduce_impl(::Base.#identity, ::Base.#scalarma...\n   253 ./reduce.jl    426 mapreduce_impl(::Base.#identity, ::Base.#scalarma...\n  2592 ./reduce.jl    428 mapreduce_impl(::Base.#identity, ::Base.#scalarma...\n    43 ./reduce.jl    429 mapreduce_impl(::Base.#identity, ::Base.#scalarma...If your code has recursion, one potentially-confusing point is that a line in a \"child\" function can accumulate more counts than there are total backtraces. Consider the following function definitions:dumbsum(n::Integer) = n == 1 ? 1 : 1 + dumbsum(n-1)\ndumbsum3() = dumbsum(3)If you were to profile dumbsum3, and a backtrace was taken while it was executing dumbsum(1), the backtrace would look like this:dumbsum3\n    dumbsum(3)\n        dumbsum(2)\n            dumbsum(1)Consequently, this child function gets 3 counts, even though the parent only gets one. The \"tree\" representation makes this much clearer, and for this reason (among others) is probably the most useful way to view the results."
},

{
    "location": "manual/profile.html#Accumulation-and-clearing-1",
    "page": "Profiling",
    "title": "Accumulation and clearing",
    "category": "section",
    "text": "Results from @profile accumulate in a buffer; if you run multiple pieces of code under @profile, then Profile.print() will show you the combined results. This can be very useful, but sometimes you want to start fresh; you can do so with Profile.clear()."
},

{
    "location": "manual/profile.html#Options-for-controlling-the-display-of-profile-results-1",
    "page": "Profiling",
    "title": "Options for controlling the display of profile results",
    "category": "section",
    "text": "Profile.print has more options than we\'ve described so far. Let\'s see the full declaration:function print(io::IO = stdout, data = fetch(); kwargs...)Let\'s first discuss the two positional arguments, and later the keyword arguments:io – Allows you to save the results to a buffer, e.g. a file, but the default is to print to stdout (the console).\ndata – Contains the data you want to analyze; by default that is obtained from Profile.fetch(), which pulls out the backtraces from a pre-allocated buffer. For example, if you want to profile the profiler, you could say:\ndata = copy(Profile.fetch())\nProfile.clear()\n@profile Profile.print(stdout, data) # Prints the previous results\nProfile.print()                      # Prints results from Profile.print()The keyword arguments can be any combination of:format – Introduced above, determines whether backtraces are printed  with (default, :tree) or without (:flat) indentation indicating tree  structure.\nC – If true, backtraces from C and Fortran code are shown (normally they are excluded). Try running the introductory example with Profile.print(C = true). This can be extremely helpful in deciding whether it\'s Julia code or C code that is causing a bottleneck; setting C = true also improves the interpretability of the nesting, at the cost of longer profile dumps.\ncombine – Some lines of code contain multiple operations; for example, s += A[i] contains both an array reference (A[i]) and a sum operation. These correspond to different lines in the generated machine code, and hence there may be two or more different addresses captured during backtraces on this line. combine = true lumps them together, and is probably what you typically want, but you can generate an output separately for each unique instruction pointer with combine = false.\nmaxdepth – Limits frames at a depth higher than maxdepth in the :tree format.\nsortedby – Controls the order in :flat format. :filefuncline (default) sorts by the source line, whereas :count sorts in order of number of collected samples.\nnoisefloor – Limits frames that are below the heuristic noise floor of the sample (only applies to format :tree). A suggested value to try for this is 2.0 (the default is 0). This parameter hides samples for which n <= noisefloor * √N, where n is the number of samples on this line, and N is the number of samples for the callee.\nmincount – Limits frames with less than mincount occurrences.File/function names are sometimes truncated (with ...), and indentation is truncated with a +n at the beginning, where n is the number of extra spaces that would have been inserted, had there been room. If you want a complete profile of deeply-nested code, often a good idea is to save to a file using a wide displaysize in an IOContext:open(\"/tmp/prof.txt\", \"w\") do s\n    Profile.print(IOContext(s, :displaysize => (24, 500)))\nend"
},

{
    "location": "manual/profile.html#Configuration-1",
    "page": "Profiling",
    "title": "Configuration",
    "category": "section",
    "text": "@profile just accumulates backtraces, and the analysis happens when you call Profile.print(). For a long-running computation, it\'s entirely possible that the pre-allocated buffer for storing backtraces will be filled. If that happens, the backtraces stop but your computation continues. As a consequence, you may miss some important profiling data (you will get a warning when that happens).You can obtain and configure the relevant parameters this way:Profile.init() # returns the current settings\nProfile.init(n = 10^7, delay = 0.01)n is the total number of instruction pointers you can store, with a default value of 10^6. If your typical backtrace is 20 instruction pointers, then you can collect 50000 backtraces, which suggests a statistical uncertainty of less than 1%. This may be good enough for most applications.Consequently, you are more likely to need to modify delay, expressed in seconds, which sets the amount of time that Julia gets between snapshots to perform the requested computations. A very long-running job might not need frequent backtraces. The default setting is delay = 0.001. Of course, you can decrease the delay as well as increase it; however, the overhead of profiling grows once the delay becomes similar to the amount of time needed to take a backtrace (~30 microseconds on the author\'s laptop)."
},

{
    "location": "manual/profile.html#Memory-allocation-analysis-1",
    "page": "Profiling",
    "title": "Memory allocation analysis",
    "category": "section",
    "text": "One of the most common techniques to improve performance is to reduce memory allocation. The total amount of allocation can be measured with @time and @allocated, and specific lines triggering allocation can often be inferred from profiling via the cost of garbage collection that these lines incur. However, sometimes it is more efficient to directly measure the amount of memory allocated by each line of code.To measure allocation line-by-line, start Julia with the --track-allocation=<setting> command-line option, for which you can choose none (the default, do not measure allocation), user (measure memory allocation everywhere except Julia\'s core code), or all (measure memory allocation at each line of Julia code). Allocation gets measured for each line of compiled code. When you quit Julia, the cumulative results are written to text files with .mem appended after the file name, residing in the same directory as the source file. Each line lists the total number of bytes allocated. The Coverage package contains some elementary analysis tools, for example to sort the lines in order of number of bytes allocated.In interpreting the results, there are a few important details. Under the user setting, the first line of any function directly called from the REPL will exhibit allocation due to events that happen in the REPL code itself. More significantly, JIT-compilation also adds to allocation counts, because much of Julia\'s compiler is written in Julia (and compilation usually requires memory allocation). The recommended procedure is to force compilation by executing all the commands you want to analyze, then call Profile.clear_malloc_data() to reset all allocation counters.  Finally, execute the desired commands and quit Julia to trigger the generation of the .mem files."
},

{
    "location": "manual/profile.html#External-Profiling-1",
    "page": "Profiling",
    "title": "External Profiling",
    "category": "section",
    "text": "Currently Julia supports Intel VTune, OProfile and perf as external profiling tools.Depending on the tool you choose, compile with USE_INTEL_JITEVENTS, USE_OPROFILE_JITEVENTS and USE_PERF_JITEVENTS set to 1 in Make.user. Multiple flags are supported.Before running Julia set the environment variable ENABLE_JITPROFILING to 1.Now you have a multitude of ways to employ those tools! For example with OProfile you can try a simple recording :>ENABLE_JITPROFILING=1 sudo operf -Vdebug ./julia test/fastmath.jl\n>opreport -l `which ./julia`Or similary with with perf :$ ENABLE_JITPROFILING=1 perf record -o /tmp/perf.data --call-graph dwarf ./julia /test/fastmath.jl\n$ perf report --call-graph -GThere are many more interesting things that you can measure about your program, to get a comprehensive list please read the Linux perf examples page.Remember that perf saves for each execution a perf.data file that, even for small programs, can get quite large. Also the perf LLVM module saves temporarily debug objects in ~/.debug/jit, remember to clean that folder frequently."
},

{
    "location": "manual/stacktraces.html#",
    "page": "Stack Traces",
    "title": "Stack Traces",
    "category": "page",
    "text": ""
},

{
    "location": "manual/stacktraces.html#Stack-Traces-1",
    "page": "Stack Traces",
    "title": "Stack Traces",
    "category": "section",
    "text": "The StackTraces module provides simple stack traces that are both human readable and easy to use programmatically."
},

{
    "location": "manual/stacktraces.html#Viewing-a-stack-trace-1",
    "page": "Stack Traces",
    "title": "Viewing a stack trace",
    "category": "section",
    "text": "The primary function used to obtain a stack trace is stacktrace:6-element Array{Base.StackTraces.StackFrame,1}:\n top-level scope\n eval at boot.jl:317 [inlined]\n eval(::Module, ::Expr) at REPL.jl:5\n eval_user_input(::Any, ::REPL.REPLBackend) at REPL.jl:85\n macro expansion at REPL.jl:116 [inlined]\n (::getfield(REPL, Symbol(\"##28#29\")){REPL.REPLBackend})() at event.jl:92Calling stacktrace() returns a vector of StackTraces.StackFrame s. For ease of use, the alias StackTraces.StackTrace can be used in place of Vector{StackFrame}. (Examples with [...] indicate that output may vary depending on how the code is run.)julia> example() = stacktrace()\nexample (generic function with 1 method)\n\njulia> example()\n7-element Array{Base.StackTraces.StackFrame,1}:\n example() at REPL[1]:1\n top-level scope\n eval at boot.jl:317 [inlined]\n[...]\n\njulia> @noinline child() = stacktrace()\nchild (generic function with 1 method)\n\njulia> @noinline parent() = child()\nparent (generic function with 1 method)\n\njulia> grandparent() = parent()\ngrandparent (generic function with 1 method)\n\njulia> grandparent()\n9-element Array{Base.StackTraces.StackFrame,1}:\n child() at REPL[3]:1\n parent() at REPL[4]:1\n grandparent() at REPL[5]:1\n[...]Note that when calling stacktrace() you\'ll typically see a frame with eval at boot.jl. When calling stacktrace() from the REPL you\'ll also have a few extra frames in the stack from REPL.jl, usually looking something like this:julia> example() = stacktrace()\nexample (generic function with 1 method)\n\njulia> example()\n7-element Array{Base.StackTraces.StackFrame,1}:\n example() at REPL[1]:1\n top-level scope\n eval at boot.jl:317 [inlined]\n eval(::Module, ::Expr) at REPL.jl:5\n eval_user_input(::Any, ::REPL.REPLBackend) at REPL.jl:85\n macro expansion at REPL.jl:116 [inlined]\n (::getfield(REPL, Symbol(\"##28#29\")){REPL.REPLBackend})() at event.jl:92"
},

{
    "location": "manual/stacktraces.html#Extracting-useful-information-1",
    "page": "Stack Traces",
    "title": "Extracting useful information",
    "category": "section",
    "text": "Each StackTraces.StackFrame contains the function name, file name, line number, lambda info, a flag indicating whether the frame has been inlined, a flag indicating whether it is a C function (by default C functions do not appear in the stack trace), and an integer representation of the pointer returned by backtrace:julia> frame = stacktrace()[3]\neval(::Module, ::Expr) at REPL.jl:5\n\njulia> frame.func\n:eval\n\njulia> frame.file\nSymbol(\"~/julia/usr/share/julia/stdlib/v0.7/REPL/src/REPL.jl\")\n\njulia> frame.line\n5\n\njulia> top_frame.linfo\nMethodInstance for eval(::Module, ::Expr)\n\njulia> top_frame.inlined\nfalse\n\njulia> top_frame.from_c\nfalsejulia> top_frame.pointer\n0x00007f92d6293171This makes stack trace information available programmatically for logging, error handling, and more."
},

{
    "location": "manual/stacktraces.html#Error-handling-1",
    "page": "Stack Traces",
    "title": "Error handling",
    "category": "section",
    "text": "While having easy access to information about the current state of the callstack can be helpful in many places, the most obvious application is in error handling and debugging.julia> @noinline bad_function() = undeclared_variable\nbad_function (generic function with 1 method)\n\njulia> @noinline example() = try\n           bad_function()\n       catch\n           stacktrace()\n       end\nexample (generic function with 1 method)\n\njulia> example()\n7-element Array{Base.StackTraces.StackFrame,1}:\n example() at REPL[2]:4\n top-level scope\n eval at boot.jl:317 [inlined]\n[...]You may notice that in the example above the first stack frame points points at line 4, where stacktrace is called, rather than line 2, where bad_function is called, and bad_function\'s frame is missing entirely. This is understandable, given that stacktrace is called from the context of the catch. While in this example it\'s fairly easy to find the actual source of the error, in complex cases tracking down the source of the error becomes nontrivial.This can be remedied by passing the result of catch_backtrace to stacktrace. Instead of returning callstack information for the current context, catch_backtrace returns stack information for the context of the most recent exception:julia> @noinline bad_function() = undeclared_variable\nbad_function (generic function with 1 method)\n\njulia> @noinline example() = try\n           bad_function()\n       catch\n           stacktrace(catch_backtrace())\n       end\nexample (generic function with 1 method)\n\njulia> example()\n8-element Array{Base.StackTraces.StackFrame,1}:\n bad_function() at REPL[1]:1\n example() at REPL[2]:2\n[...]Notice that the stack trace now indicates the appropriate line number and the missing frame.julia> @noinline child() = error(\"Whoops!\")\nchild (generic function with 1 method)\n\njulia> @noinline parent() = child()\nparent (generic function with 1 method)\n\njulia> @noinline function grandparent()\n           try\n               parent()\n           catch err\n               println(\"ERROR: \", err.msg)\n               stacktrace(catch_backtrace())\n           end\n       end\ngrandparent (generic function with 1 method)\n\njulia> grandparent()\nERROR: Whoops!\n10-element Array{Base.StackTraces.StackFrame,1}:\n error at error.jl:33 [inlined]\n child() at REPL[1]:1\n parent() at REPL[2]:1\n grandparent() at REPL[3]:3\n[...]"
},

{
    "location": "manual/stacktraces.html#Exception-stacks-and-catch_stack-1",
    "page": "Stack Traces",
    "title": "Exception stacks and catch_stack",
    "category": "section",
    "text": "compat: Julia 1.1\nException stacks requires at least Julia 1.1.While handling an exception further exceptions may be thrown. It can be useful to inspect all these exceptions to identify the root cause of a problem. The julia runtime supports this by pushing each exception onto an internal exception stack as it occurs. When the code exits a catch normally, any exceptions which were pushed onto the stack in the associated try are considered to be successfully handled and are removed from the stack.The stack of current exceptions can be accessed using the experimental Base.catch_stack function. For example,julia> try\n           error(\"(A) The root cause\")\n       catch\n           try\n               error(\"(B) An exception while handling the exception\")\n           catch\n               for (exc, bt) in Base.catch_stack()\n                   showerror(stdout, exc, bt)\n                   println()\n               end\n           end\n       end\n(A) The root cause\nStacktrace:\n [1] error(::String) at error.jl:33\n [2] top-level scope at REPL[7]:2\n [3] eval(::Module, ::Any) at boot.jl:319\n [4] eval_user_input(::Any, ::REPL.REPLBackend) at REPL.jl:85\n [5] macro expansion at REPL.jl:117 [inlined]\n [6] (::getfield(REPL, Symbol(\"##26#27\")){REPL.REPLBackend})() at task.jl:259\n(B) An exception while handling the exception\nStacktrace:\n [1] error(::String) at error.jl:33\n [2] top-level scope at REPL[7]:5\n [3] eval(::Module, ::Any) at boot.jl:319\n [4] eval_user_input(::Any, ::REPL.REPLBackend) at REPL.jl:85\n [5] macro expansion at REPL.jl:117 [inlined]\n [6] (::getfield(REPL, Symbol(\"##26#27\")){REPL.REPLBackend})() at task.jl:259In this example the root cause exception (A) is first on the stack, with a further exception (B) following it. After exiting both catch blocks normally (i.e., without throwing a further exception) all exceptions are removed from the stack and are no longer accessible.The exception stack is stored on the Task where the exceptions occurred. When a task fails with uncaught exceptions, catch_stack(task) may be used to inspect the exception stack for that task."
},

{
    "location": "manual/stacktraces.html#Comparison-with-[backtrace](@ref)-1",
    "page": "Stack Traces",
    "title": "Comparison with backtrace",
    "category": "section",
    "text": "A call to backtrace returns a vector of Union{Ptr{Nothing}, Base.InterpreterIP}, which may then be passed into stacktrace for translation:julia> trace = backtrace()\n18-element Array{Union{Ptr{Nothing}, Base.InterpreterIP},1}:\n Ptr{Nothing} @0x00007fd8734c6209\n Ptr{Nothing} @0x00007fd87362b342\n Ptr{Nothing} @0x00007fd87362c136\n Ptr{Nothing} @0x00007fd87362c986\n Ptr{Nothing} @0x00007fd87362d089\n Base.InterpreterIP(CodeInfo(:(begin\n      Core.SSAValue(0) = backtrace()\n      trace = Core.SSAValue(0)\n      return Core.SSAValue(0)\n  end)), 0x0000000000000000)\n Ptr{Nothing} @0x00007fd87362e4cf\n[...]\n\njulia> stacktrace(trace)\n6-element Array{Base.StackTraces.StackFrame,1}:\n top-level scope\n eval at boot.jl:317 [inlined]\n eval(::Module, ::Expr) at REPL.jl:5\n eval_user_input(::Any, ::REPL.REPLBackend) at REPL.jl:85\n macro expansion at REPL.jl:116 [inlined]\n (::getfield(REPL, Symbol(\"##28#29\")){REPL.REPLBackend})() at event.jl:92Notice that the vector returned by backtrace had 18 elements, while the vector returned by stacktrace only has 6. This is because, by default, stacktrace removes any lower-level C functions from the stack. If you want to include stack frames from C calls, you can do it like this:julia> stacktrace(trace, true)\n21-element Array{Base.StackTraces.StackFrame,1}:\n jl_apply_generic at gf.c:2167\n do_call at interpreter.c:324\n eval_value at interpreter.c:416\n eval_body at interpreter.c:559\n jl_interpret_toplevel_thunk_callback at interpreter.c:798\n top-level scope\n jl_interpret_toplevel_thunk at interpreter.c:807\n jl_toplevel_eval_flex at toplevel.c:856\n jl_toplevel_eval_in at builtins.c:624\n eval at boot.jl:317 [inlined]\n eval(::Module, ::Expr) at REPL.jl:5\n jl_apply_generic at gf.c:2167\n eval_user_input(::Any, ::REPL.REPLBackend) at REPL.jl:85\n jl_apply_generic at gf.c:2167\n macro expansion at REPL.jl:116 [inlined]\n (::getfield(REPL, Symbol(\"##28#29\")){REPL.REPLBackend})() at event.jl:92\n jl_fptr_trampoline at gf.c:1838\n jl_apply_generic at gf.c:2167\n jl_apply at julia.h:1540 [inlined]\n start_task at task.c:268\n ip:0xffffffffffffffffIndividual pointers returned by backtrace can be translated into StackTraces.StackFrame s by passing them into StackTraces.lookup:julia> pointer = backtrace()[1];\n\njulia> frame = StackTraces.lookup(pointer)\n1-element Array{Base.StackTraces.StackFrame,1}:\n jl_apply_generic at gf.c:2167\n\njulia> println(\"The top frame is from $(frame[1].func)!\")\nThe top frame is from jl_apply_generic!"
},

{
    "location": "manual/performance-tips.html#",
    "page": "Performance Tips",
    "title": "Performance Tips",
    "category": "page",
    "text": ""
},

{
    "location": "manual/performance-tips.html#man-performance-tips-1",
    "page": "Performance Tips",
    "title": "Performance Tips",
    "category": "section",
    "text": "In the following sections, we briefly go through a few techniques that can help make your Julia code run as fast as possible."
},

{
    "location": "manual/performance-tips.html#Avoid-global-variables-1",
    "page": "Performance Tips",
    "title": "Avoid global variables",
    "category": "section",
    "text": "A global variable might have its value, and therefore its type, change at any point. This makes it difficult for the compiler to optimize code using global variables. Variables should be local, or passed as arguments to functions, whenever possible.Any code that is performance critical or being benchmarked should be inside a function.We find that global names are frequently constants, and declaring them as such greatly improves performance:const DEFAULT_VAL = 0Uses of non-constant globals can be optimized by annotating their types at the point of use:global x = rand(1000)\n\nfunction loop_over_global()\n    s = 0.0\n    for i in x::Vector{Float64}\n        s += i\n    end\n    return s\nendPassing arguments to functions is better style. It leads to more reusable code and clarifies what the inputs and outputs are.note: Note\nAll code in the REPL is evaluated in global scope, so a variable defined and assigned at toplevel will be a global variable. Variables defined in at top level scope inside modules are also global.In the following REPL session:julia> x = 1.0is equivalent to:julia> global x = 1.0so all the performance issues discussed previously apply."
},

{
    "location": "manual/performance-tips.html#Measure-performance-with-[@time](@ref)-and-pay-attention-to-memory-allocation-1",
    "page": "Performance Tips",
    "title": "Measure performance with @time and pay attention to memory allocation",
    "category": "section",
    "text": "A useful tool for measuring performance is the @time macro. We here repeat the example with the global variable above, but this time with the type annotation removed:julia> x = rand(1000);\n\njulia> function sum_global()\n           s = 0.0\n           for i in x\n               s += i\n           end\n           return s\n       end;\n\njulia> @time sum_global()\n  0.017705 seconds (15.28 k allocations: 694.484 KiB)\n496.84883432553846\n\njulia> @time sum_global()\n  0.000140 seconds (3.49 k allocations: 70.313 KiB)\n496.84883432553846On the first call (@time sum_global()) the function gets compiled. (If you\'ve not yet used @time in this session, it will also compile functions needed for timing.)  You should not take the results of this run seriously. For the second run, note that in addition to reporting the time, it also indicated that a significant amount of memory was allocated. We are here just computing a sum over all elements in a vector of 64-bit floats so there should be no need to allocate memory (at least not on the heap which is what @time reports).Unexpected memory allocation is almost always a sign of some problem with your code, usually a problem with type-stability or creating many small temporary arrays. Consequently, in addition to the allocation itself, it\'s very likely that the code generated for your function is far from optimal. Take such indications seriously and follow the advice below.If we instead pass x as an argument to the function it no longer allocates memory (the allocation reported below is due to running the @time macro in global scope) and is significantly faster after the first call:julia> x = rand(1000);\n\njulia> function sum_arg(x)\n           s = 0.0\n           for i in x\n               s += i\n           end\n           return s\n       end;\n\njulia> @time sum_arg(x)\n  0.007701 seconds (821 allocations: 43.059 KiB)\n496.84883432553846\n\njulia> @time sum_arg(x)\n  0.000006 seconds (5 allocations: 176 bytes)\n496.84883432553846The 5 allocations seen are from running the @time macro itself in global scope. If we instead run the timing in a function, we can see that indeed no allocations are performed:julia> time_sum(x) = @time sum_arg(x);\n\njulia> time_sum(x)\n  0.000001 seconds\n496.84883432553846In some situations, your function may need to allocate memory as part of its operation, and this can complicate the simple picture above. In such cases, consider using one of the tools below to diagnose problems, or write a version of your function that separates allocation from its algorithmic aspects (see Pre-allocating outputs).note: Note\nFor more serious benchmarking, consider the BenchmarkTools.jl package which among other things evaluates the function multiple times in order to reduce noise."
},

{
    "location": "manual/performance-tips.html#tools-1",
    "page": "Performance Tips",
    "title": "Tools",
    "category": "section",
    "text": "Julia and its package ecosystem includes tools that may help you diagnose problems and improve the performance of your code:Profiling allows you to measure the performance of your running code and identify lines that serve as bottlenecks. For complex projects, the ProfileView package can help you visualize your profiling results.\nThe Traceur package can help you find common performance problems in your code.\nUnexpectedly-large memory allocations–as reported by @time, @allocated, or the profiler (through calls to the garbage-collection routines)–hint that there might be issues with your code. If you don\'t see another reason for the allocations, suspect a type problem.  You can also start Julia with the --track-allocation=user option and examine the resulting *.mem files to see information about where those allocations occur. See Memory allocation analysis.\n@code_warntype generates a representation of your code that can be helpful in finding expressions that result in type uncertainty. See @code_warntype below."
},

{
    "location": "manual/performance-tips.html#Avoid-containers-with-abstract-type-parameters-1",
    "page": "Performance Tips",
    "title": "Avoid containers with abstract type parameters",
    "category": "section",
    "text": "When working with parameterized types, including arrays, it is best to avoid parameterizing with abstract types where possible.Consider the following:julia> a = Real[]\n0-element Array{Real,1}\n\njulia> push!(a, 1); push!(a, 2.0); push!(a, π)\n3-element Array{Real,1}:\n  1\n  2.0\n π = 3.1415926535897...Because a is a an array of abstract type Real, it must be able to hold any Real value. Since Real objects can be of arbitrary size and structure, a must be represented as an array of pointers to individually allocated Real objects. However, if we instead only allow numbers of the same type, e.g. Float64, to be stored in a these can be stored more efficiently:julia> a = Float64[]\n0-element Array{Float64,1}\n\njulia> push!(a, 1); push!(a, 2.0); push!(a,  π)\n3-element Array{Float64,1}:\n 1.0\n 2.0\n 3.141592653589793Assigning numbers into a will now convert them to Float64 and a will be stored as a contiguous block of 64-bit floating-point values that can be manipulated efficiently.See also the discussion under Parametric Types."
},

{
    "location": "manual/performance-tips.html#Type-declarations-1",
    "page": "Performance Tips",
    "title": "Type declarations",
    "category": "section",
    "text": "In many languages with optional type declarations, adding declarations is the principal way to make code run faster. This is not the case in Julia. In Julia, the compiler generally knows the types of all function arguments, local variables, and expressions. However, there are a few specific instances where declarations are helpful."
},

{
    "location": "manual/performance-tips.html#Avoid-fields-with-abstract-type-1",
    "page": "Performance Tips",
    "title": "Avoid fields with abstract type",
    "category": "section",
    "text": "Types can be declared without specifying the types of their fields:julia> struct MyAmbiguousType\n           a\n       endThis allows a to be of any type. This can often be useful, but it does have a downside: for objects of type MyAmbiguousType, the compiler will not be able to generate high-performance code. The reason is that the compiler uses the types of objects, not their values, to determine how to build code. Unfortunately, very little can be inferred about an object of type MyAmbiguousType:julia> b = MyAmbiguousType(\"Hello\")\nMyAmbiguousType(\"Hello\")\n\njulia> c = MyAmbiguousType(17)\nMyAmbiguousType(17)\n\njulia> typeof(b)\nMyAmbiguousType\n\njulia> typeof(c)\nMyAmbiguousTypeThe values of b and c have the same type, yet their underlying representation of data in memory is very different. Even if you stored just numeric values in field a, the fact that the memory representation of a UInt8 differs from a Float64 also means that the CPU needs to handle them using two different kinds of instructions. Since the required information is not available in the type, such decisions have to be made at run-time. This slows performance.You can do better by declaring the type of a. Here, we are focused on the case where a might be any one of several types, in which case the natural solution is to use parameters. For example:julia> mutable struct MyType{T<:AbstractFloat}\n           a::T\n       endThis is a better choice thanjulia> mutable struct MyStillAmbiguousType\n           a::AbstractFloat\n       endbecause the first version specifies the type of a from the type of the wrapper object. For example:julia> m = MyType(3.2)\nMyType{Float64}(3.2)\n\njulia> t = MyStillAmbiguousType(3.2)\nMyStillAmbiguousType(3.2)\n\njulia> typeof(m)\nMyType{Float64}\n\njulia> typeof(t)\nMyStillAmbiguousTypeThe type of field a can be readily determined from the type of m, but not from the type of t. Indeed, in t it\'s possible to change the type of the field a:julia> typeof(t.a)\nFloat64\n\njulia> t.a = 4.5f0\n4.5f0\n\njulia> typeof(t.a)\nFloat32In contrast, once m is constructed, the type of m.a cannot change:julia> m.a = 4.5f0\n4.5f0\n\njulia> typeof(m.a)\nFloat64The fact that the type of m.a is known from m\'s type—coupled with the fact that its type cannot change mid-function—allows the compiler to generate highly-optimized code for objects like m but not for objects like t.Of course, all of this is true only if we construct m with a concrete type. We can break this by explicitly constructing it with an abstract type:julia> m = MyType{AbstractFloat}(3.2)\nMyType{AbstractFloat}(3.2)\n\njulia> typeof(m.a)\nFloat64\n\njulia> m.a = 4.5f0\n4.5f0\n\njulia> typeof(m.a)\nFloat32For all practical purposes, such objects behave identically to those of MyStillAmbiguousType.It\'s quite instructive to compare the sheer amount code generated for a simple functionfunc(m::MyType) = m.a+1usingcode_llvm(func, Tuple{MyType{Float64}})\ncode_llvm(func, Tuple{MyType{AbstractFloat}})For reasons of length the results are not shown here, but you may wish to try this yourself. Because the type is fully-specified in the first case, the compiler doesn\'t need to generate any code to resolve the type at run-time. This results in shorter and faster code."
},

{
    "location": "manual/performance-tips.html#Avoid-fields-with-abstract-containers-1",
    "page": "Performance Tips",
    "title": "Avoid fields with abstract containers",
    "category": "section",
    "text": "The same best practices also work for container types:julia> struct MySimpleContainer{A<:AbstractVector}\n           a::A\n       end\n\njulia> struct MyAmbiguousContainer{T}\n           a::AbstractVector{T}\n       endFor example:julia> c = MySimpleContainer(1:3);\n\njulia> typeof(c)\nMySimpleContainer{UnitRange{Int64}}\n\njulia> c = MySimpleContainer([1:3;]);\n\njulia> typeof(c)\nMySimpleContainer{Array{Int64,1}}\n\njulia> b = MyAmbiguousContainer(1:3);\n\njulia> typeof(b)\nMyAmbiguousContainer{Int64}\n\njulia> b = MyAmbiguousContainer([1:3;]);\n\njulia> typeof(b)\nMyAmbiguousContainer{Int64}For MySimpleContainer, the object is fully-specified by its type and parameters, so the compiler can generate optimized functions. In most instances, this will probably suffice.While the compiler can now do its job perfectly well, there are cases where you might wish that your code could do different things depending on the element type of a. Usually the best way to achieve this is to wrap your specific operation (here, foo) in a separate function:julia> function sumfoo(c::MySimpleContainer)\n           s = 0\n           for x in c.a\n               s += foo(x)\n           end\n           s\n       end\nsumfoo (generic function with 1 method)\n\njulia> foo(x::Integer) = x\nfoo (generic function with 1 method)\n\njulia> foo(x::AbstractFloat) = round(x)\nfoo (generic function with 2 methods)This keeps things simple, while allowing the compiler to generate optimized code in all cases.However, there are cases where you may need to declare different versions of the outer function for different element types or types of the AbstractVector of the field a in MySimpleContainer. You could do it like this:julia> function myfunc(c::MySimpleContainer{<:AbstractArray{<:Integer}})\n           return c.a[1]+1\n       end\nmyfunc (generic function with 1 method)\n\njulia> function myfunc(c::MySimpleContainer{<:AbstractArray{<:AbstractFloat}})\n           return c.a[1]+2\n       end\nmyfunc (generic function with 2 methods)\n\njulia> function myfunc(c::MySimpleContainer{Vector{T}}) where T <: Integer\n           return c.a[1]+3\n       end\nmyfunc (generic function with 3 methods)julia> myfunc(MySimpleContainer(1:3))\n2\n\njulia> myfunc(MySimpleContainer(1.0:3))\n3.0\n\njulia> myfunc(MySimpleContainer([1:3;]))\n4"
},

{
    "location": "manual/performance-tips.html#Annotate-values-taken-from-untyped-locations-1",
    "page": "Performance Tips",
    "title": "Annotate values taken from untyped locations",
    "category": "section",
    "text": "It is often convenient to work with data structures that may contain values of any type (arrays of type Array{Any}). But, if you\'re using one of these structures and happen to know the type of an element, it helps to share this knowledge with the compiler:function foo(a::Array{Any,1})\n    x = a[1]::Int32\n    b = x+1\n    ...\nendHere, we happened to know that the first element of a would be an Int32. Making an annotation like this has the added benefit that it will raise a run-time error if the value is not of the expected type, potentially catching certain bugs earlier.In the case that the type of a[1] is not known precisely, x can be declared via x = convert(Int32, a[1])::Int32. The use of the convert function allows a[1] to be any object convertible to an Int32 (such as UInt8), thus increasing the genericity of the code by loosening the type requirement. Notice that convert itself needs a type annotation in this context in order to achieve type stability. This is because the compiler cannot deduce the type of the return value of a function, even convert, unless the types of all the function\'s arguments are known.Type annotation will not enhance (and can actually hinder) performance if the type is constructed at run-time. This is because the compiler cannot use the annotation to specialize the subsequent code, and the type-check itself takes time. For example, in the code:function nr(a, prec)\n    ctype = prec == 32 ? Float32 : Float64\n    b = Complex{ctype}(a)\n    c = (b + 1.0f0)::Complex{ctype}\n    abs(c)\nendthe annotation of c harms performance. To write performant code involving types constructed at run-time, use the function-barrier technique discussed below, and ensure that the constructed type appears among the argument types of the kernel function so that the kernel operations are properly specialized by the compiler. For example, in the above snippet, as soon as b is constructed, it can be passed to another function k, the kernel. If, for example, function k declares b as an argument of type Complex{T}, where T is a type parameter, then a type annotation appearing in an assignment statement within k of the form:c = (b + 1.0f0)::Complex{T}does not hinder performance (but does not help either) since the compiler can determine the type of c at the time k is compiled."
},

{
    "location": "manual/performance-tips.html#Break-functions-into-multiple-definitions-1",
    "page": "Performance Tips",
    "title": "Break functions into multiple definitions",
    "category": "section",
    "text": "Writing a function as many small definitions allows the compiler to directly call the most applicable code, or even inline it.Here is an example of a \"compound function\" that should really be written as multiple definitions:using LinearAlgebra\n\nfunction mynorm(A)\n    if isa(A, Vector)\n        return sqrt(real(dot(A,A)))\n    elseif isa(A, Matrix)\n        return maximum(svdvals(A))\n    else\n        error(\"mynorm: invalid argument\")\n    end\nendThis can be written more concisely and efficiently as:norm(x::Vector) = sqrt(real(dot(x, x)))\nnorm(A::Matrix) = maximum(svdvals(A))It should however be noted that the compiler is quite efficient at optimizing away the dead branches in code written as the mynorm example."
},

{
    "location": "manual/performance-tips.html#Write-\"type-stable\"-functions-1",
    "page": "Performance Tips",
    "title": "Write \"type-stable\" functions",
    "category": "section",
    "text": "When possible, it helps to ensure that a function always returns a value of the same type. Consider the following definition:pos(x) = x < 0 ? 0 : xAlthough this seems innocent enough, the problem is that 0 is an integer (of type Int) and x might be of any type. Thus, depending on the value of x, this function might return a value of either of two types. This behavior is allowed, and may be desirable in some cases. But it can easily be fixed as follows:pos(x) = x < 0 ? zero(x) : xThere is also a oneunit function, and a more general oftype(x, y) function, which returns y converted to the type of x."
},

{
    "location": "manual/performance-tips.html#Avoid-changing-the-type-of-a-variable-1",
    "page": "Performance Tips",
    "title": "Avoid changing the type of a variable",
    "category": "section",
    "text": "An analogous \"type-stability\" problem exists for variables used repeatedly within a function:function foo()\n    x = 1\n    for i = 1:10\n        x /= rand()\n    end\n    return x\nendLocal variable x starts as an integer, and after one loop iteration becomes a floating-point number (the result of / operator). This makes it more difficult for the compiler to optimize the body of the loop. There are several possible fixes:Initialize x with x = 1.0\nDeclare the type of x: x::Float64 = 1\nUse an explicit conversion: x = oneunit(Float64)\nInitialize with the first loop iteration, to x = 1 / rand(), then loop for i = 2:10"
},

{
    "location": "manual/performance-tips.html#kernel-functions-1",
    "page": "Performance Tips",
    "title": "Separate kernel functions (aka, function barriers)",
    "category": "section",
    "text": "Many functions follow a pattern of performing some set-up work, and then running many iterations to perform a core computation. Where possible, it is a good idea to put these core computations in separate functions. For example, the following contrived function returns an array of a randomly-chosen type:julia> function strange_twos(n)\n           a = Vector{rand(Bool) ? Int64 : Float64}(undef, n)\n           for i = 1:n\n               a[i] = 2\n           end\n           return a\n       end;\n\njulia> strange_twos(3)\n3-element Array{Float64,1}:\n 2.0\n 2.0\n 2.0This should be written as:julia> function fill_twos!(a)\n           for i = eachindex(a)\n               a[i] = 2\n           end\n       end;\n\njulia> function strange_twos(n)\n           a = Vector{rand(Bool) ? Int64 : Float64}(undef, n)\n           fill_twos!(a)\n           return a\n       end;\n\njulia> strange_twos(3)\n3-element Array{Float64,1}:\n 2.0\n 2.0\n 2.0Julia\'s compiler specializes code for argument types at function boundaries, so in the original implementation it does not know the type of a during the loop (since it is chosen randomly). Therefore the second version is generally faster since the inner loop can be recompiled as part of fill_twos! for different types of a.The second form is also often better style and can lead to more code reuse.This pattern is used in several places in Julia Base. For example, see vcat and hcat in abstractarray.jl, or the fill! function, which we could have used instead of writing our own fill_twos!.Functions like strange_twos occur when dealing with data of uncertain type, for example data loaded from an input file that might contain either integers, floats, strings, or something else."
},

{
    "location": "manual/performance-tips.html#Types-with-values-as-parameters-1",
    "page": "Performance Tips",
    "title": "Types with values-as-parameters",
    "category": "section",
    "text": "Let\'s say you want to create an N-dimensional array that has size 3 along each axis. Such arrays can be created like this:julia> A = fill(5.0, (3, 3))\n3×3 Array{Float64,2}:\n 5.0  5.0  5.0\n 5.0  5.0  5.0\n 5.0  5.0  5.0This approach works very well: the compiler can figure out that A is an Array{Float64,2} because it knows the type of the fill value (5.0::Float64) and the dimensionality ((3, 3)::NTuple{2,Int}). This implies that the compiler can generate very efficient code for any future usage of A in the same function.But now let\'s say you want to write a function that creates a 3×3×... array in arbitrary dimensions; you might be tempted to write a functionjulia> function array3(fillval, N)\n           fill(fillval, ntuple(d->3, N))\n       end\narray3 (generic function with 1 method)\n\njulia> array3(5.0, 2)\n3×3 Array{Float64,2}:\n 5.0  5.0  5.0\n 5.0  5.0  5.0\n 5.0  5.0  5.0This works, but (as you can verify for yourself using @code_warntype array3(5.0, 2)) the problem is that the output type cannot be inferred: the argument N is a value of type Int, and type-inference does not (and cannot) predict its value in advance. This means that code using the output of this function has to be conservative, checking the type on each access of A; such code will be very slow.Now, one very good way to solve such problems is by using the function-barrier technique. However, in some cases you might want to eliminate the type-instability altogether. In such cases, one approach is to pass the dimensionality as a parameter, for example through Val{T}() (see \"Value types\"):julia> function array3(fillval, ::Val{N}) where N\n           fill(fillval, ntuple(d->3, Val(N)))\n       end\narray3 (generic function with 1 method)\n\njulia> array3(5.0, Val(2))\n3×3 Array{Float64,2}:\n 5.0  5.0  5.0\n 5.0  5.0  5.0\n 5.0  5.0  5.0Julia has a specialized version of ntuple that accepts a Val{::Int} instance as the second parameter; by passing N as a type-parameter, you make its \"value\" known to the compiler. Consequently, this version of array3 allows the compiler to predict the return type.However, making use of such techniques can be surprisingly subtle. For example, it would be of no help if you called array3 from a function like this:function call_array3(fillval, n)\n    A = array3(fillval, Val(n))\nendHere, you\'ve created the same problem all over again: the compiler can\'t guess what n is, so it doesn\'t know the type of Val(n). Attempting to use Val, but doing so incorrectly, can easily make performance worse in many situations. (Only in situations where you\'re effectively combining Val with the function-barrier trick, to make the kernel function more efficient, should code like the above be used.)An example of correct usage of Val would be:function filter3(A::AbstractArray{T,N}) where {T,N}\n    kernel = array3(1, Val(N))\n    filter(A, kernel)\nendIn this example, N is passed as a parameter, so its \"value\" is known to the compiler. Essentially, Val(T) works only when T is either hard-coded/literal (Val(3)) or already specified in the type-domain."
},

{
    "location": "manual/performance-tips.html#The-dangers-of-abusing-multiple-dispatch-(aka,-more-on-types-with-values-as-parameters)-1",
    "page": "Performance Tips",
    "title": "The dangers of abusing multiple dispatch (aka, more on types with values-as-parameters)",
    "category": "section",
    "text": "Once one learns to appreciate multiple dispatch, there\'s an understandable tendency to go overboard and try to use it for everything. For example, you might imagine using it to store information, e.g.struct Car{Make, Model}\n    year::Int\n    ...more fields...\nendand then dispatch on objects like Car{:Honda,:Accord}(year, args...).This might be worthwhile when either of the following are true:You require CPU-intensive processing on each Car, and it becomes vastly more efficient if you know the Make and Model at compile time and the total number of different Make or Model that will be used is not too large.\nYou have homogenous lists of the same type of Car to process, so that you can store them all in an Array{Car{:Honda,:Accord},N}.When the latter holds, a function processing such a homogenous array can be productively specialized: Julia knows the type of each element in advance (all objects in the container have the same concrete type), so Julia can \"look up\" the correct method calls when the function is being compiled (obviating the need to check at run-time) and thereby emit efficient code for processing the whole list.When these do not hold, then it\'s likely that you\'ll get no benefit; worse, the resulting \"combinatorial explosion of types\" will be counterproductive. If items[i+1] has a different type than item[i], Julia has to look up the type at run-time, search for the appropriate method in method tables, decide (via type intersection) which one matches, determine whether it has been JIT-compiled yet (and do so if not), and then make the call. In essence, you\'re asking the full type- system and JIT-compilation machinery to basically execute the equivalent of a switch statement or dictionary lookup in your own code.Some run-time benchmarks comparing (1) type dispatch, (2) dictionary lookup, and (3) a \"switch\" statement can be found on the mailing list.Perhaps even worse than the run-time impact is the compile-time impact: Julia will compile specialized functions for each different Car{Make, Model}; if you have hundreds or thousands of such types, then every function that accepts such an object as a parameter (from a custom get_year function you might write yourself, to the generic push! function in Julia Base) will have hundreds or thousands of variants compiled for it. Each of these increases the size of the cache of compiled code, the length of internal lists of methods, etc. Excess enthusiasm for values-as-parameters can easily waste enormous resources."
},

{
    "location": "manual/performance-tips.html#Access-arrays-in-memory-order,-along-columns-1",
    "page": "Performance Tips",
    "title": "Access arrays in memory order, along columns",
    "category": "section",
    "text": "Multidimensional arrays in Julia are stored in column-major order. This means that arrays are stacked one column at a time. This can be verified using the vec function or the syntax [:] as shown below (notice that the array is ordered [1 3 2 4], not [1 2 3 4]):julia> x = [1 2; 3 4]\n2×2 Array{Int64,2}:\n 1  2\n 3  4\n\njulia> x[:]\n4-element Array{Int64,1}:\n 1\n 3\n 2\n 4This convention for ordering arrays is common in many languages like Fortran, Matlab, and R (to name a few). The alternative to column-major ordering is row-major ordering, which is the convention adopted by C and Python (numpy) among other languages. Remembering the ordering of arrays can have significant performance effects when looping over arrays. A rule of thumb to keep in mind is that with column-major arrays, the first index changes most rapidly. Essentially this means that looping will be faster if the inner-most loop index is the first to appear in a slice expression.Consider the following contrived example. Imagine we wanted to write a function that accepts a Vector and returns a square Matrix with either the rows or the columns filled with copies of the input vector. Assume that it is not important whether rows or columns are filled with these copies (perhaps the rest of the code can be easily adapted accordingly). We could conceivably do this in at least four ways (in addition to the recommended call to the built-in repeat):function copy_cols(x::Vector{T}) where T\n    inds = axes(x, 1)\n    out = similar(Array{T}, inds, inds)\n    for i = inds\n        out[:, i] = x\n    end\n    return out\nend\n\nfunction copy_rows(x::Vector{T}) where T\n    inds = axes(x, 1)\n    out = similar(Array{T}, inds, inds)\n    for i = inds\n        out[i, :] = x\n    end\n    return out\nend\n\nfunction copy_col_row(x::Vector{T}) where T\n    inds = axes(x, 1)\n    out = similar(Array{T}, inds, inds)\n    for col = inds, row = inds\n        out[row, col] = x[row]\n    end\n    return out\nend\n\nfunction copy_row_col(x::Vector{T}) where T\n    inds = axes(x, 1)\n    out = similar(Array{T}, inds, inds)\n    for row = inds, col = inds\n        out[row, col] = x[col]\n    end\n    return out\nendNow we will time each of these functions using the same random 10000 by 1 input vector:julia> x = randn(10000);\n\njulia> fmt(f) = println(rpad(string(f)*\": \", 14, \' \'), @elapsed f(x))\n\njulia> map(fmt, Any[copy_cols, copy_rows, copy_col_row, copy_row_col]);\ncopy_cols:    0.331706323\ncopy_rows:    1.799009911\ncopy_col_row: 0.415630047\ncopy_row_col: 1.721531501Notice that copy_cols is much faster than copy_rows. This is expected because copy_cols respects the column-based memory layout of the Matrix and fills it one column at a time. Additionally, copy_col_row is much faster than copy_row_col because it follows our rule of thumb that the first element to appear in a slice expression should be coupled with the inner-most loop."
},

{
    "location": "manual/performance-tips.html#Pre-allocating-outputs-1",
    "page": "Performance Tips",
    "title": "Pre-allocating outputs",
    "category": "section",
    "text": "If your function returns an Array or some other complex type, it may have to allocate memory. Unfortunately, oftentimes allocation and its converse, garbage collection, are substantial bottlenecks.Sometimes you can circumvent the need to allocate memory on each function call by preallocating the output. As a trivial example, comparejulia> function xinc(x)\n           return [x, x+1, x+2]\n       end;\n\njulia> function loopinc()\n           y = 0\n           for i = 1:10^7\n               ret = xinc(i)\n               y += ret[2]\n           end\n           return y\n       end;withjulia> function xinc!(ret::AbstractVector{T}, x::T) where T\n           ret[1] = x\n           ret[2] = x+1\n           ret[3] = x+2\n           nothing\n       end;\n\njulia> function loopinc_prealloc()\n           ret = Vector{Int}(undef, 3)\n           y = 0\n           for i = 1:10^7\n               xinc!(ret, i)\n               y += ret[2]\n           end\n           return y\n       end;Timing results:julia> @time loopinc()\n  0.529894 seconds (40.00 M allocations: 1.490 GiB, 12.14% gc time)\n50000015000000\n\njulia> @time loopinc_prealloc()\n  0.030850 seconds (6 allocations: 288 bytes)\n50000015000000Preallocation has other advantages, for example by allowing the caller to control the \"output\" type from an algorithm. In the example above, we could have passed a SubArray rather than an Array, had we so desired.Taken to its extreme, pre-allocation can make your code uglier, so performance measurements and some judgment may be required. However, for \"vectorized\" (element-wise) functions, the convenient syntax x .= f.(y) can be used for in-place operations with fused loops and no temporary arrays (see the dot syntax for vectorizing functions)."
},

{
    "location": "manual/performance-tips.html#More-dots:-Fuse-vectorized-operations-1",
    "page": "Performance Tips",
    "title": "More dots: Fuse vectorized operations",
    "category": "section",
    "text": "Julia has a special dot syntax that converts any scalar function into a \"vectorized\" function call, and any operator into a \"vectorized\" operator, with the special property that nested \"dot calls\" are fusing: they are combined at the syntax level into a single loop, without allocating temporary arrays. If you use .= and similar assignment operators, the result can also be stored in-place in a pre-allocated array (see above).In a linear-algebra context, this means that even though operations like vector + vector and vector * scalar are defined, it can be advantageous to instead use vector .+ vector and vector .* scalar because the resulting loops can be fused with surrounding computations. For example, consider the two functions:julia> f(x) = 3x.^2 + 4x + 7x.^3;\n\njulia> fdot(x) = @. 3x^2 + 4x + 7x^3 # equivalent to 3 .* x.^2 .+ 4 .* x .+ 7 .* x.^3;Both f and fdot compute the same thing. However, fdot (defined with the help of the @. macro) is significantly faster when applied to an array:julia> x = rand(10^6);\n\njulia> @time f(x);\n  0.019049 seconds (16 allocations: 45.777 MiB, 18.59% gc time)\n\njulia> @time fdot(x);\n  0.002790 seconds (6 allocations: 7.630 MiB)\n\njulia> @time f.(x);\n  0.002626 seconds (8 allocations: 7.630 MiB)That is, fdot(x) is ten times faster and allocates 1/6 the memory of f(x), because each * and + operation in f(x) allocates a new temporary array and executes in a separate loop. (Of course, if you just do f.(x) then it is as fast as fdot(x) in this example, but in many contexts it is more convenient to just sprinkle some dots in your expressions rather than defining a separate function for each vectorized operation.)"
},

{
    "location": "manual/performance-tips.html#Consider-using-views-for-slices-1",
    "page": "Performance Tips",
    "title": "Consider using views for slices",
    "category": "section",
    "text": "In Julia, an array \"slice\" expression like array[1:5, :] creates a copy of that data (except on the left-hand side of an assignment, where array[1:5, :] = ... assigns in-place to that portion of array). If you are doing many operations on the slice, this can be good for performance because it is more efficient to work with a smaller contiguous copy than it would be to index into the original array. On the other hand, if you are just doing a few simple operations on the slice, the cost of the allocation and copy operations can be substantial.An alternative is to create a \"view\" of the array, which is an array object (a SubArray) that actually references the data of the original array in-place, without making a copy. (If you write to a view, it modifies the original array\'s data as well.) This can be done for individual slices by calling view, or more simply for a whole expression or block of code by putting @views in front of that expression. For example:julia> fcopy(x) = sum(x[2:end-1]);\n\njulia> @views fview(x) = sum(x[2:end-1]);\n\njulia> x = rand(10^6);\n\njulia> @time fcopy(x);\n  0.003051 seconds (7 allocations: 7.630 MB)\n\njulia> @time fview(x);\n  0.001020 seconds (6 allocations: 224 bytes)Notice both the 3× speedup and the decreased memory allocation of the fview version of the function."
},

{
    "location": "manual/performance-tips.html#Copying-data-is-not-always-bad-1",
    "page": "Performance Tips",
    "title": "Copying data is not always bad",
    "category": "section",
    "text": "Arrays are stored contiguously in memory, lending themselves to CPU vectorization and fewer memory accesses due to caching. These are the same reasons that it is recommended to access arrays in column-major order (see above). Irregular access patterns and non-contiguous views can drastically slow down computations on arrays because of non-sequential memory access.Copying irregularly-accessed data into a contiguous array before operating on it can result in a large speedup, such as in the example below. Here, a matrix and a vector are being accessed at 800,000 of their randomly-shuffled indices before being multiplied. Copying the views into plain arrays speeds up the multiplication even with the cost of the copying operation.julia> using Random\n\njulia> x = randn(1_000_000);\n\njulia> inds = shuffle(1:1_000_000)[1:800000];\n\njulia> A = randn(50, 1_000_000);\n\njulia> xtmp = zeros(800_000);\n\njulia> Atmp = zeros(50, 800_000);\n\njulia> @time sum(view(A, :, inds) * view(x, inds))\n  0.412156 seconds (14 allocations: 960 bytes)\n-4256.759568345458\n\njulia> @time begin\n           copyto!(xtmp, view(x, inds))\n           copyto!(Atmp, view(A, :, inds))\n           sum(Atmp * xtmp)\n       end\n  0.285923 seconds (14 allocations: 960 bytes)\n-4256.759568345134Provided there is enough memory for the copies, the cost of copying the view to an array is far outweighed by the speed boost from doing the matrix multiplication on a contiguous array."
},

{
    "location": "manual/performance-tips.html#Avoid-string-interpolation-for-I/O-1",
    "page": "Performance Tips",
    "title": "Avoid string interpolation for I/O",
    "category": "section",
    "text": "When writing data to a file (or other I/O device), forming extra intermediate strings is a source of overhead. Instead of:println(file, \"$a $b\")use:println(file, a, \" \", b)The first version of the code forms a string, then writes it to the file, while the second version writes values directly to the file. Also notice that in some cases string interpolation can be harder to read. Consider:println(file, \"$(f(a))$(f(b))\")versus:println(file, f(a), f(b))"
},

{
    "location": "manual/performance-tips.html#Optimize-network-I/O-during-parallel-execution-1",
    "page": "Performance Tips",
    "title": "Optimize network I/O during parallel execution",
    "category": "section",
    "text": "When executing a remote function in parallel:using Distributed\n\nresponses = Vector{Any}(undef, nworkers())\n@sync begin\n    for (idx, pid) in enumerate(workers())\n        @async responses[idx] = remotecall_fetch(foo, pid, args...)\n    end\nendis faster than:using Distributed\n\nrefs = Vector{Any}(undef, nworkers())\nfor (idx, pid) in enumerate(workers())\n    refs[idx] = @spawnat pid foo(args...)\nend\nresponses = [fetch(r) for r in refs]The former results in a single network round-trip to every worker, while the latter results in two network calls - first by the @spawnat and the second due to the fetch (or even a wait). The fetch/wait is also being executed serially resulting in an overall poorer performance."
},

{
    "location": "manual/performance-tips.html#Fix-deprecation-warnings-1",
    "page": "Performance Tips",
    "title": "Fix deprecation warnings",
    "category": "section",
    "text": "A deprecated function internally performs a lookup in order to print a relevant warning only once. This extra lookup can cause a significant slowdown, so all uses of deprecated functions should be modified as suggested by the warnings."
},

{
    "location": "manual/performance-tips.html#Tweaks-1",
    "page": "Performance Tips",
    "title": "Tweaks",
    "category": "section",
    "text": "These are some minor points that might help in tight inner loops.Avoid unnecessary arrays. For example, instead of sum([x,y,z]) use x+y+z.\nUse abs2(z) instead of abs(z)^2 for complex z. In general, try to rewrite code to use abs2 instead of abs for complex arguments.\nUse div(x,y) for truncating division of integers instead of trunc(x/y), fld(x,y) instead of floor(x/y), and cld(x,y) instead of ceil(x/y)."
},

{
    "location": "manual/performance-tips.html#man-performance-annotations-1",
    "page": "Performance Tips",
    "title": "Performance Annotations",
    "category": "section",
    "text": "Sometimes you can enable better optimization by promising certain program properties.Use @inbounds to eliminate array bounds checking within expressions. Be certain before doing this. If the subscripts are ever out of bounds, you may suffer crashes or silent corruption.\nUse @fastmath to allow floating point optimizations that are correct for real numbers, but lead to differences for IEEE numbers. Be careful when doing this, as this may change numerical results. This corresponds to the -ffast-math option of clang.\nWrite @simd in front of for loops to promise that the iterations are independent and may be reordered.  Note that in many cases, Julia can automatically vectorize code without the @simd macro; it is only beneficial in cases where such a transformation would otherwise be illegal, including cases like allowing floating-point re-associativity and ignoring dependent memory accesses (@simd ivdep). Again, be very careful when asserting @simd as erroneously annotating a loop with dependent iterations may result in unexpected results. In particular, note that setindex! on some AbstractArray subtypes is inherently dependent upon iteration order. This feature is experimental and could change or disappear in future versions of Julia.The common idiom of using 1:n to index into an AbstractArray is not safe if the Array uses unconventional indexing, and may cause a segmentation fault if bounds checking is turned off. Use LinearIndices(x) or eachindex(x) instead (see also offset-arrays).note: Note\nWhile @simd needs to be placed directly in front of an innermost for loop, both @inbounds and @fastmath can be applied to either single expressions or all the expressions that appear within nested blocks of code, e.g., using @inbounds begin or @inbounds for ....Here is an example with both @inbounds and @simd markup (we here use @noinline to prevent the optimizer from trying to be too clever and defeat our benchmark):@noinline function inner(x, y)\n    s = zero(eltype(x))\n    for i=eachindex(x)\n        @inbounds s += x[i]*y[i]\n    end\n    return s\nend\n\n@noinline function innersimd(x, y)\n    s = zero(eltype(x))\n    @simd for i = eachindex(x)\n        @inbounds s += x[i] * y[i]\n    end\n    return s\nend\n\nfunction timeit(n, reps)\n    x = rand(Float32, n)\n    y = rand(Float32, n)\n    s = zero(Float64)\n    time = @elapsed for j in 1:reps\n        s += inner(x, y)\n    end\n    println(\"GFlop/sec        = \", 2n*reps / time*1E-9)\n    time = @elapsed for j in 1:reps\n        s += innersimd(x, y)\n    end\n    println(\"GFlop/sec (SIMD) = \", 2n*reps / time*1E-9)\nend\n\ntimeit(1000, 1000)On a computer with a 2.4GHz Intel Core i5 processor, this produces:GFlop/sec        = 1.9467069505224963\nGFlop/sec (SIMD) = 17.578554163920018(GFlop/sec measures the performance, and larger numbers are better.)Here is an example with all three kinds of markup. This program first calculates the finite difference of a one-dimensional array, and then evaluates the L2-norm of the result:function init!(u::Vector)\n    n = length(u)\n    dx = 1.0 / (n-1)\n    @fastmath @inbounds @simd for i in 1:n #by asserting that `u` is a `Vector` we can assume it has 1-based indexing\n        u[i] = sin(2pi*dx*i)\n    end\nend\n\nfunction deriv!(u::Vector, du)\n    n = length(u)\n    dx = 1.0 / (n-1)\n    @fastmath @inbounds du[1] = (u[2] - u[1]) / dx\n    @fastmath @inbounds @simd for i in 2:n-1\n        du[i] = (u[i+1] - u[i-1]) / (2*dx)\n    end\n    @fastmath @inbounds du[n] = (u[n] - u[n-1]) / dx\nend\n\nfunction mynorm(u::Vector)\n    n = length(u)\n    T = eltype(u)\n    s = zero(T)\n    @fastmath @inbounds @simd for i in 1:n\n        s += u[i]^2\n    end\n    @fastmath @inbounds return sqrt(s)\nend\n\nfunction main()\n    n = 2000\n    u = Vector{Float64}(undef, n)\n    init!(u)\n    du = similar(u)\n\n    deriv!(u, du)\n    nu = mynorm(du)\n\n    @time for i in 1:10^6\n        deriv!(u, du)\n        nu = mynorm(du)\n    end\n\n    println(nu)\nend\n\nmain()On a computer with a 2.7 GHz Intel Core i7 processor, this produces:$ julia wave.jl;\n  1.207814709 seconds\n4.443986180758249\n\n$ julia --math-mode=ieee wave.jl;\n  4.487083643 seconds\n4.443986180758249Here, the option --math-mode=ieee disables the @fastmath macro, so that we can compare results.In this case, the speedup due to @fastmath is a factor of about 3.7. This is unusually large – in general, the speedup will be smaller. (In this particular example, the working set of the benchmark is small enough to fit into the L1 cache of the processor, so that memory access latency does not play a role, and computing time is dominated by CPU usage. In many real world programs this is not the case.) Also, in this case this optimization does not change the result – in general, the result will be slightly different. In some cases, especially for numerically unstable algorithms, the result can be very different.The annotation @fastmath re-arranges floating point expressions, e.g. changing the order of evaluation, or assuming that certain special cases (inf, nan) cannot occur. In this case (and on this particular computer), the main difference is that the expression 1 / (2*dx) in the function deriv is hoisted out of the loop (i.e. calculated outside the loop), as if one had written idx = 1 / (2*dx). In the loop, the expression ... / (2*dx) then becomes ... * idx, which is much faster to evaluate. Of course, both the actual optimization that is applied by the compiler as well as the resulting speedup depend very much on the hardware. You can examine the change in generated code by using Julia\'s code_native function.Note that @fastmath also assumes that NaNs will not occur during the computation, which can lead to surprising behavior:julia> f(x) = isnan(x);\n\njulia> f(NaN)\ntrue\n\njulia> f_fast(x) = @fastmath isnan(x);\n\njulia> f_fast(NaN)\nfalse"
},

{
    "location": "manual/performance-tips.html#Treat-Subnormal-Numbers-as-Zeros-1",
    "page": "Performance Tips",
    "title": "Treat Subnormal Numbers as Zeros",
    "category": "section",
    "text": "Subnormal numbers, formerly called denormal numbers, are useful in many contexts, but incur a performance penalty on some hardware. A call set_zero_subnormals(true) grants permission for floating-point operations to treat subnormal inputs or outputs as zeros, which may improve performance on some hardware. A call set_zero_subnormals(false) enforces strict IEEE behavior for subnormal numbers.Below is an example where subnormals noticeably impact performance on some hardware:function timestep(b::Vector{T}, a::Vector{T}, Δt::T) where T\n    @assert length(a)==length(b)\n    n = length(b)\n    b[1] = 1                            # Boundary condition\n    for i=2:n-1\n        b[i] = a[i] + (a[i-1] - T(2)*a[i] + a[i+1]) * Δt\n    end\n    b[n] = 0                            # Boundary condition\nend\n\nfunction heatflow(a::Vector{T}, nstep::Integer) where T\n    b = similar(a)\n    for t=1:div(nstep,2)                # Assume nstep is even\n        timestep(b,a,T(0.1))\n        timestep(a,b,T(0.1))\n    end\nend\n\nheatflow(zeros(Float32,10),2)           # Force compilation\nfor trial=1:6\n    a = zeros(Float32,1000)\n    set_zero_subnormals(iseven(trial))  # Odd trials use strict IEEE arithmetic\n    @time heatflow(a,1000)\nendThis gives an output similar to  0.002202 seconds (1 allocation: 4.063 KiB)\n  0.001502 seconds (1 allocation: 4.063 KiB)\n  0.002139 seconds (1 allocation: 4.063 KiB)\n  0.001454 seconds (1 allocation: 4.063 KiB)\n  0.002115 seconds (1 allocation: 4.063 KiB)\n  0.001455 seconds (1 allocation: 4.063 KiB)Note how each even iteration is significantly faster.This example generates many subnormal numbers because the values in a become an exponentially decreasing curve, which slowly flattens out over time.Treating subnormals as zeros should be used with caution, because doing so breaks some identities, such as x-y == 0 implies x == y:julia> x = 3f-38; y = 2f-38;\n\njulia> set_zero_subnormals(true); (x - y, x == y)\n(0.0f0, false)\n\njulia> set_zero_subnormals(false); (x - y, x == y)\n(1.0000001f-38, false)In some applications, an alternative to zeroing subnormal numbers is to inject a tiny bit of noise.  For example, instead of initializing a with zeros, initialize it with:a = rand(Float32,1000) * 1.f-9"
},

{
    "location": "manual/performance-tips.html#man-code-warntype-1",
    "page": "Performance Tips",
    "title": "@code_warntype",
    "category": "section",
    "text": "The macro @code_warntype (or its function variant code_warntype) can sometimes be helpful in diagnosing type-related problems. Here\'s an example:julia> @noinline pos(x) = x < 0 ? 0 : x;\n\njulia> function f(x)\n           y = pos(x)\n           sin(y*x + 1)\n       end;\n\njulia> @code_warntype f(3.2)\nBody::Float64\n2 1 ─ %1  = invoke Main.pos(%%x::Float64)::UNION{FLOAT64, INT64}\n3 │   %2  = isa(%1, Float64)::Bool\n  └──       goto 3 if not %2\n  2 ─ %4  = π (%1, Float64)\n  │   %5  = Base.mul_float(%4, %%x)::Float64\n  └──       goto 6\n  3 ─ %7  = isa(%1, Int64)::Bool\n  └──       goto 5 if not %7\n  4 ─ %9  = π (%1, Int64)\n  │   %10 = Base.sitofp(Float64, %9)::Float64\n  │   %11 = Base.mul_float(%10, %%x)::Float64\n  └──       goto 6\n  5 ─       Base.error(\"fatal error in type inference (type bound)\")\n  └──       unreachable\n  6 ┄ %15 = φ (2 => %5, 4 => %11)::Float64\n  │   %16 = Base.add_float(%15, 1.0)::Float64\n  │   %17 = invoke Main.sin(%16::Float64)::Float64\n  └──       return %17Interpreting the output of @code_warntype, like that of its cousins @code_lowered, @code_typed, @code_llvm, and @code_native, takes a little practice. Your code is being presented in form that has been heavily digested on its way to generating compiled machine code. Most of the expressions are annotated by a type, indicated by the ::T (where T might be Float64, for example). The most important characteristic of @code_warntype is that non-concrete types are displayed in red; in the above example, such output is shown in uppercase.At the top, the inferred return type of the function is shown as Body::Float64. The next lines represent the body of f in Julia\'s SSA IR form. The numbered boxes are labels and represent targets for jumps (via goto) in your code. Looking at the body, you can see that the first thing that happens is that pos is called and the return value has been inferred as the Union type UNION{FLOAT64, INT64} shown in uppercase since it is a non-concrete type. This means that we cannot know the exact return type of pos based on the input types. However, the result of y*xis a Float64 no matter if y is a Float64 or Int64 The net result is that f(x::Float64) will not be type-unstable in its output, even if some of the intermediate computations are type-unstable.How you use this information is up to you. Obviously, it would be far and away best to fix pos to be type-stable: if you did so, all of the variables in f would be concrete, and its performance would be optimal. However, there are circumstances where this kind of ephemeral type instability might not matter too much: for example, if pos is never used in isolation, the fact that f\'s output is type-stable (for Float64 inputs) will shield later code from the propagating effects of type instability. This is particularly relevant in cases where fixing the type instability is difficult or impossible. In such cases, the tips above (e.g., adding type annotations and/or breaking up functions) are your best tools to contain the \"damage\" from type instability. Also, note that even Julia Base has functions that are type unstable. For example, the function findfirst returns the index into an array where a key is found, or nothing if it is not found, a clear type instability. In order to make it easier to find the type instabilities that are likely to be important, Unions containing either missing or nothing are color highlighted in yellow, instead of red.The following examples may help you interpret expressions marked as containing non-leaf types:Function body starting with Body::UNION{T1,T2})\nInterpretation: function with unstable return type\nSuggestion: make the return value type-stable, even if you have to annotate it\ninvoke Main.g(%%x::Int64)::UNION{FLOAT64, INT64}\nInterpretation: call to a type-unstable function g.\nSuggestion: fix the function, or if necessary annotate the return value\ninvoke Base.getindex(%%x::Array{Any,1}, 1::Int64)::ANY\nInterpretation: accessing elements of poorly-typed arrays\nSuggestion: use arrays with better-defined types, or if necessary annotate the type of individual element accesses\nBase.getfield(%%x, :(:data))::ARRAY{FLOAT64,N} WHERE N\nInterpretation: getting a field that is of non-leaf type. In this case, ArrayContainer had a field data::Array{T}. But Array needs the dimension N, too, to be a concrete type.\nSuggestion: use concrete types like Array{T,3} or Array{T,N}, where N is now a parameter of ArrayContainer"
},

{
    "location": "manual/performance-tips.html#man-performance-captured-1",
    "page": "Performance Tips",
    "title": "Performance of captured variable",
    "category": "section",
    "text": "Consider the following example that defines an inner function:function abmult(r::Int)\n    if r < 0\n        r = -r\n    end\n    f = x -> x * r\n    return f\nendFunction abmult returns a function f that multiplies its argument by the absolute value of r. The inner function assigned to f is called a \"closure\". Inner functions are also used by the language for do-blocks and for generator expressions.This style of code presents performance challenges for the language. The parser, when translating it into lower-level instructions, substantially reorganizes the above code by extracting the inner function to a separate code block.  \"Captured\" variables such as r that are shared by inner functions and their enclosing scope are also extracted into a heap-allocated \"box\" accessible to both inner and outer functions because the language specifies that r in the inner scope must be identical to r in the outer scope even after the outer scope (or another inner function) modifies r.The discussion in the preceding paragraph referred to the \"parser\", that is, the phase of compilation that takes place when the module containing abmult is first loaded, as opposed to the later phase when it is first invoked. The parser does not \"know\" that Int is a fixed type, or that the statement r = -r transforms an Int to another Int. The magic of type inference takes place in the later phase of compilation.Thus, the parser does not know that r has a fixed type (Int). nor that r does not change value once the inner function is created (so that the box is unneeded).  Therefore, the parser emits code for box that holds an object with an abstract type such as Any, which requires run-time type dispatch for each occurrence of r.  This can be verified by applying @code_warntype to the above function.  Both the boxing and the run-time type dispatch can cause loss of performance.If captured variables are used in a performance-critical section of the code, then the following tips help ensure that their use is performant. First, if it is known that a captured variable does not change its type, then this can be declared explicitly with a type annotation (on the variable, not the right-hand side):function abmult2(r0::Int)\n    r::Int = r0\n    if r < 0\n        r = -r\n    end\n    f = x -> x * r\n    return f\nendThe type annotation partially recovers lost performance due to capturing because the parser can associate a concrete type to the object in the box. Going further, if the captured variable does not need to be boxed at all (because it will not be reassigned after the closure is created), this can be indicated with let blocks as follows.function abmult3(r::Int)\n    if r < 0\n        r = -r\n    end\n    f = let r = r\n            x -> x * r\n    end\n    return f\nendThe let block creates a new variable r whose scope is only the inner function. The second technique recovers full language performance in the presence of captured variables. Note that this is a rapidly evolving aspect of the compiler, and it is likely that future releases will not require this degree of programmer annotation to attain performance. In the mean time, some user-contributed packages like FastClosures automate the insertion of let statements as in abmult3."
},

{
    "location": "manual/workflow-tips.html#",
    "page": "Workflow Tips",
    "title": "Workflow Tips",
    "category": "page",
    "text": ""
},

{
    "location": "manual/workflow-tips.html#man-workflow-tips-1",
    "page": "Workflow Tips",
    "title": "Workflow Tips",
    "category": "section",
    "text": "Here are some tips for working with Julia efficiently."
},

{
    "location": "manual/workflow-tips.html#REPL-based-workflow-1",
    "page": "Workflow Tips",
    "title": "REPL-based workflow",
    "category": "section",
    "text": "As already elaborated in The Julia REPL, Julia\'s REPL provides rich functionality that facilitates an efficient interactive workflow. Here are some tips that might further enhance your experience at the command line."
},

{
    "location": "manual/workflow-tips.html#A-basic-editor/REPL-workflow-1",
    "page": "Workflow Tips",
    "title": "A basic editor/REPL workflow",
    "category": "section",
    "text": "The most basic Julia workflows involve using a text editor in conjunction with the julia command line. A common pattern includes the following elements:Put code under development in a temporary module. Create a file, say Tmp.jl, and include within it\nmodule Tmp\nexport say_hello\n\nsay_hello() = println(\"Hello!\")\n\n# your other definitions here\n\nend\nPut your test code in another file. Create another file, say tst.jl, which looks like\ninclude(\"Tmp.jl\")\nimport .Tmp\n# using .Tmp # we can use `using` to bring the exported symbols in `Tmp` into our namespace\n\nTmp.say_hello()\n# say_hello()\n\n# your other test code here\nand includes tests for the contents of Tmp. Alternatively, you can wrap the contents of your test file in a module, as\nmodule Tst\n    include(\"Tmp.jl\")\n    import .Tmp\n    #using .Tmp\n\n    Tmp.say_hello()\n    # say_hello()\n\n    # your other test code here\nend\nThe advantage is that your testing code is now contained in a module and does not use the global scope in Main for definitions, which is a bit more tidy.\ninclude the tst.jl file in the Julia REPL with include(\"tst.jl\").\nLather. Rinse. Repeat. Explore ideas at the julia command prompt. Save good ideas in tst.jl. To execute tst.jl after it has been changed, just include it again."
},

{
    "location": "manual/workflow-tips.html#Browser-based-workflow-1",
    "page": "Workflow Tips",
    "title": "Browser-based workflow",
    "category": "section",
    "text": "It is also possible to interact with a Julia REPL in the browser via IJulia. See the package home for details."
},

{
    "location": "manual/style-guide.html#",
    "page": "Style Guide",
    "title": "Style Guide",
    "category": "page",
    "text": ""
},

{
    "location": "manual/style-guide.html#Style-Guide-1",
    "page": "Style Guide",
    "title": "Style Guide",
    "category": "section",
    "text": "The following sections explain a few aspects of idiomatic Julia coding style. None of these rules are absolute; they are only suggestions to help familiarize you with the language and to help you choose among alternative designs."
},

{
    "location": "manual/style-guide.html#Write-functions,-not-just-scripts-1",
    "page": "Style Guide",
    "title": "Write functions, not just scripts",
    "category": "section",
    "text": "Writing code as a series of steps at the top level is a quick way to get started solving a problem, but you should try to divide a program into functions as soon as possible. Functions are more reusable and testable, and clarify what steps are being done and what their inputs and outputs are. Furthermore, code inside functions tends to run much faster than top level code, due to how Julia\'s compiler works.It is also worth emphasizing that functions should take arguments, instead of operating directly on global variables (aside from constants like pi)."
},

{
    "location": "manual/style-guide.html#Avoid-writing-overly-specific-types-1",
    "page": "Style Guide",
    "title": "Avoid writing overly-specific types",
    "category": "section",
    "text": "Code should be as generic as possible. Instead of writing:Complex{Float64}(x)it\'s better to use available generic functions:complex(float(x))The second version will convert x to an appropriate type, instead of always the same type.This style point is especially relevant to function arguments. For example, don\'t declare an argument to be of type Int or Int32 if it really could be any integer, expressed with the abstract type Integer. In fact, in many cases you can omit the argument type altogether, unless it is needed to disambiguate from other method definitions, since a MethodError will be thrown anyway if a type is passed that does not support any of the requisite operations. (This is known as duck typing.)For example, consider the following definitions of a function addone that returns one plus its argument:addone(x::Int) = x + 1                 # works only for Int\naddone(x::Integer) = x + oneunit(x)    # any integer type\naddone(x::Number) = x + oneunit(x)     # any numeric type\naddone(x) = x + oneunit(x)             # any type supporting + and oneunitThe last definition of addone handles any type supporting oneunit (which returns 1 in the same type as x, which avoids unwanted type promotion) and the + function with those arguments. The key thing to realize is that there is no performance penalty to defining only the general addone(x) = x + oneunit(x), because Julia will automatically compile specialized versions as needed. For example, the first time you call addone(12), Julia will automatically compile a specialized addone function for x::Int arguments, with the call to oneunit replaced by its inlined value 1. Therefore, the first three definitions of addone above are completely redundant with the fourth definition."
},

{
    "location": "manual/style-guide.html#Handle-excess-argument-diversity-in-the-caller-1",
    "page": "Style Guide",
    "title": "Handle excess argument diversity in the caller",
    "category": "section",
    "text": "Instead of:function foo(x, y)\n    x = Int(x); y = Int(y)\n    ...\nend\nfoo(x, y)use:function foo(x::Int, y::Int)\n    ...\nend\nfoo(Int(x), Int(y))This is better style because foo does not really accept numbers of all types; it really needs Int s.One issue here is that if a function inherently requires integers, it might be better to force the caller to decide how non-integers should be converted (e.g. floor or ceiling). Another issue is that declaring more specific types leaves more \"space\" for future method definitions."
},

{
    "location": "manual/style-guide.html#Append-!-to-names-of-functions-that-modify-their-arguments-1",
    "page": "Style Guide",
    "title": "Append ! to names of functions that modify their arguments",
    "category": "section",
    "text": "Instead of:function double(a::AbstractArray{<:Number})\n    for i = firstindex(a):lastindex(a)\n        a[i] *= 2\n    end\n    return a\nenduse:function double!(a::AbstractArray{<:Number})\n    for i = firstindex(a):lastindex(a)\n        a[i] *= 2\n    end\n    return a\nendJulia Base uses this convention throughout and contains examples of functions with both copying and modifying forms (e.g., sort and sort!), and others which are just modifying (e.g., push!, pop!, splice!).  It is typical for such functions to also return the modified array for convenience."
},

{
    "location": "manual/style-guide.html#Avoid-strange-type-Unions-1",
    "page": "Style Guide",
    "title": "Avoid strange type Unions",
    "category": "section",
    "text": "Types such as Union{Function,AbstractString} are often a sign that some design could be cleaner."
},

{
    "location": "manual/style-guide.html#Avoid-elaborate-container-types-1",
    "page": "Style Guide",
    "title": "Avoid elaborate container types",
    "category": "section",
    "text": "It is usually not much help to construct arrays like the following:a = Vector{Union{Int,AbstractString,Tuple,Array}}(undef, n)In this case Vector{Any}(undef, n) is better. It is also more helpful to the compiler to annotate specific uses (e.g. a[i]::Int) than to try to pack many alternatives into one type."
},

{
    "location": "manual/style-guide.html#Use-naming-conventions-consistent-with-Julia-base/-1",
    "page": "Style Guide",
    "title": "Use naming conventions consistent with Julia base/",
    "category": "section",
    "text": "modules and type names use capitalization and camel case: module SparseArrays, struct UnitRange.\nfunctions are lowercase (maximum, convert) and, when readable, with multiple words squashed together (isequal, haskey). When necessary, use underscores as word separators. Underscores are also used to indicate a combination of concepts (remotecall_fetch as a more efficient implementation of fetch(remotecall(...))) or as modifiers.\nconciseness is valued, but avoid abbreviation (indexin rather than indxin) as it becomes difficult to remember whether and how particular words are abbreviated.If a function name requires multiple words, consider whether it might represent more than one concept and might be better split into pieces."
},

{
    "location": "manual/style-guide.html#Write-functions-with-argument-ordering-similar-to-Julia-Base-1",
    "page": "Style Guide",
    "title": "Write functions with argument ordering similar to Julia Base",
    "category": "section",
    "text": "As a general rule, the Base library uses the following order of arguments to functions, as applicable:Function argument. Putting a function argument first permits the use of do blocks for passing multiline anonymous functions.\nI/O stream. Specifying the IO object first permits passing the function to functions such as sprint, e.g. sprint(show, x).\nInput being mutated. For example, in fill!(x, v), x is the object being mutated and it appears before the value to be inserted into x.\nType. Passing a type typically means that the output will have the given type. In parse(Int, \"1\"), the type comes before the string to parse. There are many such examples where the type appears first, but it\'s useful to note that in read(io, String), the IO argument appears before the type, which is in keeping with the order outlined here.\nInput not being mutated. In fill!(x, v), v is not being mutated and it comes after x.\nKey. For associative collections, this is the key of the key-value pair(s). For other indexed collections, this is the index.\nValue. For associative collections, this is the value of the key-value pair(s). In cases like fill!(x, v), this is v.\nEverything else. Any other arguments.\nVarargs. This refers to arguments that can be listed indefinitely at the end of a function call. For example, in Matrix{T}(undef, dims), the dimensions can be given as a Tuple, e.g. Matrix{T}(undef, (1,2)), or as Varargs, e.g. Matrix{T}(undef, 1, 2).\nKeyword arguments. In Julia keyword arguments have to come last anyway in function definitions; they\'re listed here for the sake of completeness.The vast majority of functions will not take every kind of argument listed above; the numbers merely denote the precedence that should be used for any applicable arguments to a function.There are of course a few exceptions. For example, in convert, the type should always come first. In setindex!, the value comes before the indices so that the indices can be provided as varargs.When designing APIs, adhering to this general order as much as possible is likely to give users of your functions a more consistent experience."
},

{
    "location": "manual/style-guide.html#Don\'t-overuse-try-catch-1",
    "page": "Style Guide",
    "title": "Don\'t overuse try-catch",
    "category": "section",
    "text": "It is better to avoid errors than to rely on catching them."
},

{
    "location": "manual/style-guide.html#Don\'t-parenthesize-conditions-1",
    "page": "Style Guide",
    "title": "Don\'t parenthesize conditions",
    "category": "section",
    "text": "Julia doesn\'t require parens around conditions in if and while. Write:if a == binstead of:if (a == b)"
},

{
    "location": "manual/style-guide.html#Don\'t-overuse-...-1",
    "page": "Style Guide",
    "title": "Don\'t overuse ...",
    "category": "section",
    "text": "Splicing function arguments can be addictive. Instead of [a..., b...], use simply [a; b], which already concatenates arrays. collect(a) is better than [a...], but since a is already iterable it is often even better to leave it alone, and not convert it to an array."
},

{
    "location": "manual/style-guide.html#Don\'t-use-unnecessary-static-parameters-1",
    "page": "Style Guide",
    "title": "Don\'t use unnecessary static parameters",
    "category": "section",
    "text": "A function signature:foo(x::T) where {T<:Real} = ...should be written as:foo(x::Real) = ...instead, especially if T is not used in the function body. Even if T is used, it can be replaced with typeof(x) if convenient. There is no performance difference. Note that this is not a general caution against static parameters, just against uses where they are not needed.Note also that container types, specifically may need type parameters in function calls. See the FAQ Avoid fields with abstract containers for more information."
},

{
    "location": "manual/style-guide.html#Avoid-confusion-about-whether-something-is-an-instance-or-a-type-1",
    "page": "Style Guide",
    "title": "Avoid confusion about whether something is an instance or a type",
    "category": "section",
    "text": "Sets of definitions like the following are confusing:foo(::Type{MyType}) = ...\nfoo(::MyType) = foo(MyType)Decide whether the concept in question will be written as MyType or MyType(), and stick to it.The preferred style is to use instances by default, and only add methods involving Type{MyType} later if they become necessary to solve some problem.If a type is effectively an enumeration, it should be defined as a single (ideally immutable struct or primitive) type, with the enumeration values being instances of it. Constructors and conversions can check whether values are valid. This design is preferred over making the enumeration an abstract type, with the \"values\" as subtypes."
},

{
    "location": "manual/style-guide.html#Don\'t-overuse-macros-1",
    "page": "Style Guide",
    "title": "Don\'t overuse macros",
    "category": "section",
    "text": "Be aware of when a macro could really be a function instead.Calling eval inside a macro is a particularly dangerous warning sign; it means the macro will only work when called at the top level. If such a macro is written as a function instead, it will naturally have access to the run-time values it needs."
},

{
    "location": "manual/style-guide.html#Don\'t-expose-unsafe-operations-at-the-interface-level-1",
    "page": "Style Guide",
    "title": "Don\'t expose unsafe operations at the interface level",
    "category": "section",
    "text": "If you have a type that uses a native pointer:mutable struct NativeType\n    p::Ptr{UInt8}\n    ...\nenddon\'t write definitions like the following:getindex(x::NativeType, i) = unsafe_load(x.p, i)The problem is that users of this type can write x[i] without realizing that the operation is unsafe, and then be susceptible to memory bugs.Such a function should either check the operation to ensure it is safe, or have unsafe somewhere in its name to alert callers."
},

{
    "location": "manual/style-guide.html#Don\'t-overload-methods-of-base-container-types-1",
    "page": "Style Guide",
    "title": "Don\'t overload methods of base container types",
    "category": "section",
    "text": "It is possible to write definitions like the following:show(io::IO, v::Vector{MyType}) = ...This would provide custom showing of vectors with a specific new element type. While tempting, this should be avoided. The trouble is that users will expect a well-known type like Vector() to behave in a certain way, and overly customizing its behavior can make it harder to work with."
},

{
    "location": "manual/style-guide.html#Avoid-type-piracy-1",
    "page": "Style Guide",
    "title": "Avoid type piracy",
    "category": "section",
    "text": "\"Type piracy\" refers to the practice of extending or redefining methods in Base or other packages on types that you have not defined. In some cases, you can get away with type piracy with little ill effect. In extreme cases, however, you can even crash Julia (e.g. if your method extension or redefinition causes invalid input to be passed to a ccall). Type piracy can complicate reasoning about code, and may introduce incompatibilities that are hard to predict and diagnose.As an example, suppose you wanted to define multiplication on symbols in a module:module A\nimport Base.*\n*(x::Symbol, y::Symbol) = Symbol(x,y)\nendThe problem is that now any other module that uses Base.* will also see this definition. Since Symbol is defined in Base and is used by other modules, this can change the behavior of unrelated code unexpectedly. There are several alternatives here, including using a different function name, or wrapping the Symbols in another type that you define.Sometimes, coupled packages may engage in type piracy to separate features from definitions, especially when the packages were designed by collaborating authors, and when the definitions are reusable. For example, one package might provide some types useful for working with colors; another package could define methods for those types that enable conversions between color spaces. Another example might be a package that acts as a thin wrapper for some C code, which another package might then pirate to implement a higher-level, Julia-friendly API."
},

{
    "location": "manual/style-guide.html#Be-careful-with-type-equality-1",
    "page": "Style Guide",
    "title": "Be careful with type equality",
    "category": "section",
    "text": "You generally want to use isa and <: for testing types, not ==. Checking types for exact equality typically only makes sense when comparing to a known concrete type (e.g. T == Float64), or if you really, really know what you\'re doing."
},

{
    "location": "manual/style-guide.html#Do-not-write-x-f(x)-1",
    "page": "Style Guide",
    "title": "Do not write x->f(x)",
    "category": "section",
    "text": "Since higher-order functions are often called with anonymous functions, it is easy to conclude that this is desirable or even necessary. But any function can be passed directly, without being \"wrapped\" in an anonymous function. Instead of writing map(x->f(x), a), write map(f, a)."
},

{
    "location": "manual/style-guide.html#Avoid-using-floats-for-numeric-literals-in-generic-code-when-possible-1",
    "page": "Style Guide",
    "title": "Avoid using floats for numeric literals in generic code when possible",
    "category": "section",
    "text": "If you write generic code which handles numbers, and which can be expected to run with many different numeric type arguments, try using literals of a numeric type that will affect the arguments as little as possible through promotion.For example,julia> f(x) = 2.0 * x\nf (generic function with 1 method)\n\njulia> f(1//2)\n1.0\n\njulia> f(1/2)\n1.0\n\njulia> f(1)\n2.0whilejulia> g(x) = 2 * x\ng (generic function with 1 method)\n\njulia> g(1//2)\n1//1\n\njulia> g(1/2)\n1.0\n\njulia> g(1)\n2As you can see, the second version, where we used an Int literal, preserved the type of the input argument, while the first didn\'t. This is because e.g. promote_type(Int, Float64) == Float64, and promotion happens with the multiplication. Similarly, Rational literals are less type disruptive than Float64 literals, but more disruptive than Ints:julia> h(x) = 2//1 * x\nh (generic function with 1 method)\n\njulia> h(1//2)\n1//1\n\njulia> h(1/2)\n1.0\n\njulia> h(1)\n2//1Thus, use Int literals when possible, with Rational{Int} for literal non-integer numbers, in order to make it easier to use your code."
},

{
    "location": "manual/faq.html#",
    "page": "Frequently Asked Questions",
    "title": "Frequently Asked Questions",
    "category": "page",
    "text": ""
},

{
    "location": "manual/faq.html#Frequently-Asked-Questions-1",
    "page": "Frequently Asked Questions",
    "title": "Frequently Asked Questions",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#Sessions-and-the-REPL-1",
    "page": "Frequently Asked Questions",
    "title": "Sessions and the REPL",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#How-do-I-delete-an-object-in-memory?-1",
    "page": "Frequently Asked Questions",
    "title": "How do I delete an object in memory?",
    "category": "section",
    "text": "Julia does not have an analog of MATLAB\'s clear function; once a name is defined in a Julia session (technically, in module Main), it is always present.If memory usage is your concern, you can always replace objects with ones that consume less memory.  For example, if A is a gigabyte-sized array that you no longer need, you can free the memory with A = nothing.  The memory will be released the next time the garbage collector runs; you can force this to happen with gc(). Moreover, an attempt to use A will likely result in an error, because most methods are not defined on type Nothing."
},

{
    "location": "manual/faq.html#How-can-I-modify-the-declaration-of-a-type-in-my-session?-1",
    "page": "Frequently Asked Questions",
    "title": "How can I modify the declaration of a type in my session?",
    "category": "section",
    "text": "Perhaps you\'ve defined a type and then realize you need to add a new field.  If you try this at the REPL, you get the error:ERROR: invalid redefinition of constant MyTypeTypes in module Main cannot be redefined.While this can be inconvenient when you are developing new code, there\'s an excellent workaround.  Modules can be replaced by redefining them, and so if you wrap all your new code inside a module you can redefine types and constants.  You can\'t import the type names into Main and then expect to be able to redefine them there, but you can use the module name to resolve the scope.  In other words, while developing you might use a workflow something like this:include(\"mynewcode.jl\")              # this defines a module MyModule\nobj1 = MyModule.ObjConstructor(a, b)\nobj2 = MyModule.somefunction(obj1)\n# Got an error. Change something in \"mynewcode.jl\"\ninclude(\"mynewcode.jl\")              # reload the module\nobj1 = MyModule.ObjConstructor(a, b) # old objects are no longer valid, must reconstruct\nobj2 = MyModule.somefunction(obj1)   # this time it worked!\nobj3 = MyModule.someotherfunction(obj2, c)\n..."
},

{
    "location": "manual/faq.html#man-scripting-1",
    "page": "Frequently Asked Questions",
    "title": "Scripting",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#How-do-I-check-if-the-current-file-is-being-run-as-the-main-script?-1",
    "page": "Frequently Asked Questions",
    "title": "How do I check if the current file is being run as the main script?",
    "category": "section",
    "text": "When a file is run as the main script using julia file.jl one might want to activate extra functionality like command line argument handling. A way to determine that a file is run in this fashion is to check if abspath(PROGRAM_FILE) == @__FILE__ is true."
},

{
    "location": "manual/faq.html#How-do-I-catch-CTRL-C-in-a-script?-1",
    "page": "Frequently Asked Questions",
    "title": "How do I catch CTRL-C in a script?",
    "category": "section",
    "text": "Running a Julia script using julia file.jl does not throw InterruptException when you try to terminate it with CTRL-C (SIGINT).  To run a certain code before terminating a Julia script, which may or may not be caused by CTRL-C, use atexit. Alternatively, you can use julia -e \'include(popfirst!(ARGS))\' file.jl to execute a script while being able to catch InterruptException in the try block."
},

{
    "location": "manual/faq.html#How-do-I-pass-options-to-julia-using-#!/usr/bin/env?-1",
    "page": "Frequently Asked Questions",
    "title": "How do I pass options to julia using #!/usr/bin/env?",
    "category": "section",
    "text": "Passing options to julia in so-called shebang by, e.g., #!/usr/bin/env julia --startup-file=no may not work in some platforms such as Linux.  This is because argument parsing in shebang is platform-dependent and not well-specified.  In a Unix-like environment, a reliable way to pass options to julia in an executable script would be to start the script as a bash script and use exec to replace the process to julia:#!/bin/bash\n#=\nexec julia --color=yes --startup-file=no -e \'include(popfirst!(ARGS))\' \\\n    \"${BASH_SOURCE[0]}\" \"$@\"\n=#\n\n@show ARGS  # put any Julia code hereIn the example above, the code between #= and =# is run as a bash script.  Julia ignores this part since it is a multi-line comment for Julia.  The Julia code after =# is ignored by bash since it stops parsing the file once it reaches to the exec statement."
},

{
    "location": "manual/faq.html#Functions-1",
    "page": "Frequently Asked Questions",
    "title": "Functions",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#I-passed-an-argument-x-to-a-function,-modified-it-inside-that-function,-but-on-the-outside,-the-variable-x-is-still-unchanged.-Why?-1",
    "page": "Frequently Asked Questions",
    "title": "I passed an argument x to a function, modified it inside that function, but on the outside, the variable x is still unchanged. Why?",
    "category": "section",
    "text": "Suppose you call a function like this:julia> x = 10\n10\n\njulia> function change_value!(y)\n           y = 17\n       end\nchange_value! (generic function with 1 method)\n\njulia> change_value!(x)\n17\n\njulia> x # x is unchanged!\n10In Julia, the binding of a variable x cannot be changed by passing x as an argument to a function. When calling change_value!(x) in the above example, y is a newly created variable, bound initially to the value of x, i.e. 10; then y is rebound to the constant 17, while the variable x of the outer scope is left untouched.But here is a thing you should pay attention to: suppose x is bound to an object of type Array (or any other mutable type). From within the function, you cannot \"unbind\" x from this Array, but you can change its content. For example:julia> x = [1,2,3]\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> function change_array!(A)\n           A[1] = 5\n       end\nchange_array! (generic function with 1 method)\n\njulia> change_array!(x)\n5\n\njulia> x\n3-element Array{Int64,1}:\n 5\n 2\n 3Here we created a function change_array!, that assigns 5 to the first element of the passed array (bound to x at the call site, and bound to A within the function). Notice that, after the function call, x is still bound to the same array, but the content of that array changed: the variables A and x were distinct bindings referring to the same mutable Array object."
},

{
    "location": "manual/faq.html#Can-I-use-using-or-import-inside-a-function?-1",
    "page": "Frequently Asked Questions",
    "title": "Can I use using or import inside a function?",
    "category": "section",
    "text": "No, you are not allowed to have a using or import statement inside a function.  If you want to import a module but only use its symbols inside a specific function or set of functions, you have two options:Use import:\nimport Foo\nfunction bar(...)\n    # ... refer to Foo symbols via Foo.baz ...\nend\nThis loads the module Foo and defines a variable Foo that refers to the module, but does not import any of the other symbols from the module into the current namespace.  You refer to the Foo symbols by their qualified names Foo.bar etc.\nWrap your function in a module:\nmodule Bar\nexport bar\nusing Foo\nfunction bar(...)\n    # ... refer to Foo.baz as simply baz ....\nend\nend\nusing Bar\nThis imports all the symbols from Foo, but only inside the module Bar."
},

{
    "location": "manual/faq.html#What-does-the-...-operator-do?-1",
    "page": "Frequently Asked Questions",
    "title": "What does the ... operator do?",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#The-two-uses-of-the-...-operator:-slurping-and-splatting-1",
    "page": "Frequently Asked Questions",
    "title": "The two uses of the ... operator: slurping and splatting",
    "category": "section",
    "text": "Many newcomers to Julia find the use of ... operator confusing. Part of what makes the ... operator confusing is that it means two different things depending on context."
},

{
    "location": "manual/faq.html#...-combines-many-arguments-into-one-argument-in-function-definitions-1",
    "page": "Frequently Asked Questions",
    "title": "... combines many arguments into one argument in function definitions",
    "category": "section",
    "text": "In the context of function definitions, the ... operator is used to combine many different arguments into a single argument. This use of ... for combining many different arguments into a single argument is called slurping:julia> function printargs(args...)\n           println(typeof(args))\n           for (i, arg) in enumerate(args)\n               println(\"Arg #$i = $arg\")\n           end\n       end\nprintargs (generic function with 1 method)\n\njulia> printargs(1, 2, 3)\nTuple{Int64,Int64,Int64}\nArg #1 = 1\nArg #2 = 2\nArg #3 = 3If Julia were a language that made more liberal use of ASCII characters, the slurping operator might have been written as <-... instead of ...."
},

{
    "location": "manual/faq.html#...-splits-one-argument-into-many-different-arguments-in-function-calls-1",
    "page": "Frequently Asked Questions",
    "title": "... splits one argument into many different arguments in function calls",
    "category": "section",
    "text": "In contrast to the use of the ... operator to denote slurping many different arguments into one argument when defining a function, the ... operator is also used to cause a single function argument to be split apart into many different arguments when used in the context of a function call. This use of ... is called splatting:julia> function threeargs(a, b, c)\n           println(\"a = $a::$(typeof(a))\")\n           println(\"b = $b::$(typeof(b))\")\n           println(\"c = $c::$(typeof(c))\")\n       end\nthreeargs (generic function with 1 method)\n\njulia> x = [1, 2, 3]\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> threeargs(x...)\na = 1::Int64\nb = 2::Int64\nc = 3::Int64If Julia were a language that made more liberal use of ASCII characters, the splatting operator might have been written as ...-> instead of ...."
},

{
    "location": "manual/faq.html#What-is-the-return-value-of-an-assignment?-1",
    "page": "Frequently Asked Questions",
    "title": "What is the return value of an assignment?",
    "category": "section",
    "text": "The operator = always returns the right-hand side, therefore:julia> function threeint()\n           x::Int = 3.0\n           x # returns variable x\n       end\nthreeint (generic function with 1 method)\n\njulia> function threefloat()\n           x::Int = 3.0 # returns 3.0\n       end\nthreefloat (generic function with 1 method)\n\njulia> threeint()\n3\n\njulia> threefloat()\n3.0and similarly:julia> function threetup()\n           x, y = [3, 3]\n           x, y # returns a tuple\n       end\nthreetup (generic function with 1 method)\n\njulia> function threearr()\n           x, y = [3, 3] # returns an array\n       end\nthreearr (generic function with 1 method)\n\njulia> threetup()\n(3, 3)\n\njulia> threearr()\n2-element Array{Int64,1}:\n 3\n 3"
},

{
    "location": "manual/faq.html#Types,-type-declarations,-and-constructors-1",
    "page": "Frequently Asked Questions",
    "title": "Types, type declarations, and constructors",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#man-type-stability-1",
    "page": "Frequently Asked Questions",
    "title": "What does \"type-stable\" mean?",
    "category": "section",
    "text": "It means that the type of the output is predictable from the types of the inputs.  In particular, it means that the type of the output cannot vary depending on the values of the inputs. The following code is not type-stable:julia> function unstable(flag::Bool)\n           if flag\n               return 1\n           else\n               return 1.0\n           end\n       end\nunstable (generic function with 1 method)It returns either an Int or a Float64 depending on the value of its argument. Since Julia can\'t predict the return type of this function at compile-time, any computation that uses it will have to guard against both types possibly occurring, making generation of fast machine code difficult."
},

{
    "location": "manual/faq.html#faq-domain-errors-1",
    "page": "Frequently Asked Questions",
    "title": "Why does Julia give a DomainError for certain seemingly-sensible operations?",
    "category": "section",
    "text": "Certain operations make mathematical sense but result in errors:julia> sqrt(-2.0)\nERROR: DomainError with -2.0:\nsqrt will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\nStacktrace:\n[...]This behavior is an inconvenient consequence of the requirement for type-stability.  In the case of sqrt, most users want sqrt(2.0) to give a real number, and would be unhappy if it produced the complex number 1.4142135623730951 + 0.0im.  One could write the sqrt function to switch to a complex-valued output only when passed a negative number (which is what sqrt does in some other languages), but then the result would not be type-stable and the sqrt function would have poor performance.In these and other cases, you can get the result you want by choosing an input type that conveys your willingness to accept an output type in which the result can be represented:julia> sqrt(-2.0+0im)\n0.0 + 1.4142135623730951im"
},

{
    "location": "manual/faq.html#Why-does-Julia-use-native-machine-integer-arithmetic?-1",
    "page": "Frequently Asked Questions",
    "title": "Why does Julia use native machine integer arithmetic?",
    "category": "section",
    "text": "Julia uses machine arithmetic for integer computations. This means that the range of Int values is bounded and wraps around at either end so that adding, subtracting and multiplying integers can overflow or underflow, leading to some results that can be unsettling at first:julia> typemax(Int)\n9223372036854775807\n\njulia> ans+1\n-9223372036854775808\n\njulia> -ans\n-9223372036854775808\n\njulia> 2*ans\n0Clearly, this is far from the way mathematical integers behave, and you might think it less than ideal for a high-level programming language to expose this to the user. For numerical work where efficiency and transparency are at a premium, however, the alternatives are worse.One alternative to consider would be to check each integer operation for overflow and promote results to bigger integer types such as Int128 or BigInt in the case of overflow. Unfortunately, this introduces major overhead on every integer operation (think incrementing a loop counter) – it requires emitting code to perform run-time overflow checks after arithmetic instructions and branches to handle potential overflows. Worse still, this would cause every computation involving integers to be type-unstable. As we mentioned above, type-stability is crucial for effective generation of efficient code. If you can\'t count on the results of integer operations being integers, it\'s impossible to generate fast, simple code the way C and Fortran compilers do.A variation on this approach, which avoids the appearance of type instability is to merge the Int and BigInt types into a single hybrid integer type, that internally changes representation when a result no longer fits into the size of a machine integer. While this superficially avoids type-instability at the level of Julia code, it just sweeps the problem under the rug by foisting all of the same difficulties onto the C code implementing this hybrid integer type. This approach can be made to work and can even be made quite fast in many cases, but has several drawbacks. One problem is that the in-memory representation of integers and arrays of integers no longer match the natural representation used by C, Fortran and other languages with native machine integers. Thus, to interoperate with those languages, we would ultimately need to introduce native integer types anyway. Any unbounded representation of integers cannot have a fixed number of bits, and thus cannot be stored inline in an array with fixed-size slots – large integer values will always require separate heap-allocated storage. And of course, no matter how clever a hybrid integer implementation one uses, there are always performance traps – situations where performance degrades unexpectedly. Complex representation, lack of interoperability with C and Fortran, the inability to represent integer arrays without additional heap storage, and unpredictable performance characteristics make even the cleverest hybrid integer implementations a poor choice for high-performance numerical work.An alternative to using hybrid integers or promoting to BigInts is to use saturating integer arithmetic, where adding to the largest integer value leaves it unchanged and likewise for subtracting from the smallest integer value. This is precisely what Matlab™ does:>> int64(9223372036854775807)\n\nans =\n\n  9223372036854775807\n\n>> int64(9223372036854775807) + 1\n\nans =\n\n  9223372036854775807\n\n>> int64(-9223372036854775808)\n\nans =\n\n -9223372036854775808\n\n>> int64(-9223372036854775808) - 1\n\nans =\n\n -9223372036854775808At first blush, this seems reasonable enough since 9223372036854775807 is much closer to 9223372036854775808 than -9223372036854775808 is and integers are still represented with a fixed size in a natural way that is compatible with C and Fortran. Saturated integer arithmetic, however, is deeply problematic. The first and most obvious issue is that this is not the way machine integer arithmetic works, so implementing saturated operations requires emitting instructions after each machine integer operation to check for underflow or overflow and replace the result with typemin(Int) or typemax(Int) as appropriate. This alone expands each integer operation from a single, fast instruction into half a dozen instructions, probably including branches. Ouch. But it gets worse – saturating integer arithmetic isn\'t associative. Consider this Matlab computation:>> n = int64(2)^62\n4611686018427387904\n\n>> n + (n - 1)\n9223372036854775807\n\n>> (n + n) - 1\n9223372036854775806This makes it hard to write many basic integer algorithms since a lot of common techniques depend on the fact that machine addition with overflow is associative. Consider finding the midpoint between integer values lo and hi in Julia using the expression (lo + hi) >>> 1:julia> n = 2^62\n4611686018427387904\n\njulia> (n + 2n) >>> 1\n6917529027641081856See? No problem. That\'s the correct midpoint between 2^62 and 2^63, despite the fact that n + 2n is -4611686018427387904. Now try it in Matlab:>> (n + 2*n)/2\n\nans =\n\n  4611686018427387904Oops. Adding a >>> operator to Matlab wouldn\'t help, because saturation that occurs when adding n and 2n has already destroyed the information necessary to compute the correct midpoint.Not only is lack of associativity unfortunate for programmers who cannot rely it for techniques like this, but it also defeats almost anything compilers might want to do to optimize integer arithmetic. For example, since Julia integers use normal machine integer arithmetic, LLVM is free to aggressively optimize simple little functions like f(k) = 5k-1. The machine code for this function is just this:julia> code_native(f, Tuple{Int})\n  .text\nFilename: none\n  pushq %rbp\n  movq  %rsp, %rbp\nSource line: 1\n  leaq  -1(%rdi,%rdi,4), %rax\n  popq  %rbp\n  retq\n  nopl  (%rax,%rax)The actual body of the function is a single leaq instruction, which computes the integer multiply and add at once. This is even more beneficial when f gets inlined into another function:julia> function g(k, n)\n           for i = 1:n\n               k = f(k)\n           end\n           return k\n       end\ng (generic function with 1 methods)\n\njulia> code_native(g, Tuple{Int,Int})\n  .text\nFilename: none\n  pushq %rbp\n  movq  %rsp, %rbp\nSource line: 2\n  testq %rsi, %rsi\n  jle L26\n  nopl  (%rax)\nSource line: 3\nL16:\n  leaq  -1(%rdi,%rdi,4), %rdi\nSource line: 2\n  decq  %rsi\n  jne L16\nSource line: 5\nL26:\n  movq  %rdi, %rax\n  popq  %rbp\n  retq\n  nopSince the call to f gets inlined, the loop body ends up being just a single leaq instruction. Next, consider what happens if we make the number of loop iterations fixed:julia> function g(k)\n           for i = 1:10\n               k = f(k)\n           end\n           return k\n       end\ng (generic function with 2 methods)\n\njulia> code_native(g,(Int,))\n  .text\nFilename: none\n  pushq %rbp\n  movq  %rsp, %rbp\nSource line: 3\n  imulq $9765625, %rdi, %rax    # imm = 0x9502F9\n  addq  $-2441406, %rax         # imm = 0xFFDABF42\nSource line: 5\n  popq  %rbp\n  retq\n  nopw  %cs:(%rax,%rax)Because the compiler knows that integer addition and multiplication are associative and that multiplication distributes over addition – neither of which is true of saturating arithmetic – it can optimize the entire loop down to just a multiply and an add. Saturated arithmetic completely defeats this kind of optimization since associativity and distributivity can fail at each loop iteration, causing different outcomes depending on which iteration the failure occurs in. The compiler can unroll the loop, but it cannot algebraically reduce multiple operations into fewer equivalent operations.The most reasonable alternative to having integer arithmetic silently overflow is to do checked arithmetic everywhere, raising errors when adds, subtracts, and multiplies overflow, producing values that are not value-correct. In this blog post, Dan Luu analyzes this and finds that rather than the trivial cost that this approach should in theory have, it ends up having a substantial cost due to compilers (LLVM and GCC) not gracefully optimizing around the added overflow checks. If this improves in the future, we could consider defaulting to checked integer arithmetic in Julia, but for now, we have to live with the possibility of overflow."
},

{
    "location": "manual/faq.html#What-are-the-possible-causes-of-an-UndefVarError-during-remote-execution?-1",
    "page": "Frequently Asked Questions",
    "title": "What are the possible causes of an UndefVarError during remote execution?",
    "category": "section",
    "text": "As the error states, an immediate cause of an UndefVarError on a remote node is that a binding by that name does not exist. Let us explore some of the possible causes.julia> module Foo\n           foo() = remotecall_fetch(x->x, 2, \"Hello\")\n       end\n\njulia> Foo.foo()\nERROR: On worker 2:\nUndefVarError: Foo not defined\nStacktrace:\n[...]The closure x->x carries a reference to Foo, and since Foo is unavailable on node 2, an UndefVarError is thrown.Globals under modules other than Main are not serialized by value to the remote node. Only a reference is sent. Functions which create global bindings (except under Main) may cause an UndefVarError to be thrown later.julia> @everywhere module Foo\n           function foo()\n               global gvar = \"Hello\"\n               remotecall_fetch(()->gvar, 2)\n           end\n       end\n\njulia> Foo.foo()\nERROR: On worker 2:\nUndefVarError: gvar not defined\nStacktrace:\n[...]In the above example, @everywhere module Foo defined Foo on all nodes. However the call to Foo.foo() created a new global binding gvar on the local node, but this was not found on node 2 resulting in an UndefVarError error.Note that this does not apply to globals created under module Main. Globals under module Main are serialized and new bindings created under Main on the remote node.julia> gvar_self = \"Node1\"\n\"Node1\"\n\njulia> remotecall_fetch(()->gvar_self, 2)\n\"Node1\"\n\njulia> remotecall_fetch(varinfo, 2)\nname          size summary\n––––––––– –––––––– –––––––\nBase               Module\nCore               Module\nMain               Module\ngvar_self 13 bytes StringThis does not apply to function or struct declarations. However, anonymous functions bound to global variables are serialized as can be seen below.julia> bar() = 1\nbar (generic function with 1 method)\n\njulia> remotecall_fetch(bar, 2)\nERROR: On worker 2:\nUndefVarError: #bar not defined\n[...]\n\njulia> anon_bar  = ()->1\n(::#21) (generic function with 1 method)\n\njulia> remotecall_fetch(anon_bar, 2)\n1"
},

{
    "location": "manual/faq.html#Why-does-Julia-use-*-for-string-concatenation?-Why-not-or-something-else?-1",
    "page": "Frequently Asked Questions",
    "title": "Why does Julia use * for string concatenation? Why not + or something else?",
    "category": "section",
    "text": "The main argument against + is that string concatenation is not commutative, while + is generally used as a commutative operator. While the Julia community recognizes that other languages use different operators and * may be unfamiliar for some users, it communicates certain algebraic properties.Note that you can also use string(...) to concatenate strings (and other values converted to strings); similarly, repeat can be used instead of ^ to repeat strings. The interpolation syntax is also useful for constructing strings."
},

{
    "location": "manual/faq.html#Packages-and-Modules-1",
    "page": "Frequently Asked Questions",
    "title": "Packages and Modules",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#What-is-the-difference-between-\"using\"-and-\"import\"?-1",
    "page": "Frequently Asked Questions",
    "title": "What is the difference between \"using\" and \"import\"?",
    "category": "section",
    "text": "There is only one difference, and on the surface (syntax-wise) it may seem very minor. The difference between using and import is that with using you need to say function Foo.bar(.. to extend module Foo\'s function bar with a new method, but with import Foo.bar, you only need to say function bar(... and it automatically extends module Foo\'s function bar.The reason this is important enough to have been given separate syntax is that you don\'t want to accidentally extend a function that you didn\'t know existed, because that could easily cause a bug. This is most likely to happen with a method that takes a common type like a string or integer, because both you and the other module could define a method to handle such a common type. If you use import, then you\'ll replace the other module\'s implementation of bar(s::AbstractString) with your new implementation, which could easily do something completely different (and break all/many future usages of the other functions in module Foo that depend on calling bar)."
},

{
    "location": "manual/faq.html#Nothingness-and-missing-values-1",
    "page": "Frequently Asked Questions",
    "title": "Nothingness and missing values",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#faq-nothing-1",
    "page": "Frequently Asked Questions",
    "title": "How does \"null\", \"nothingness\" or \"missingness\" work in Julia?",
    "category": "section",
    "text": "Unlike many languages (for example, C and Java), Julia objects cannot be \"null\" by default. When a reference (variable, object field, or array element) is uninitialized, accessing it will immediately throw an error. This situation can be detected using the isdefined or isassigned functions.Some functions are used only for their side effects, and do not need to return a value. In these cases, the convention is to return the value nothing, which is just a singleton object of type Nothing. This is an ordinary type with no fields; there is nothing special about it except for this convention, and that the REPL does not print anything for it. Some language constructs that would not otherwise have a value also yield nothing, for example if false; end.For situations where a value x of type T exists only sometimes, the Union{T, Nothing} type can be used for function arguments, object fields and array element types as the equivalent of Nullable, Option or Maybe in other languages. If the value itself can be nothing (notably, when T is Any), the Union{Some{T}, Nothing} type is more appropriate since x == nothing then indicates the absence of a value, and x == Some(nothing) indicates the presence of a value equal to nothing. The something function allows unwrapping Some objects and using a default value instead of nothing arguments. Note that the compiler is able to generate efficient code when working with Union{T, Nothing} arguments or fields.To represent missing data in the statistical sense (NA in R or NULL in SQL), use the missing object. See the Missing Values section for more details.The empty tuple (()) is another form of nothingness. But, it should not really be thought of as nothing but rather a tuple of zero values.The empty (or \"bottom\") type, written as Union{} (an empty union type), is a type with no values and no subtypes (except itself). You will generally not need to use this type."
},

{
    "location": "manual/faq.html#Memory-1",
    "page": "Frequently Asked Questions",
    "title": "Memory",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#Why-does-x-y-allocate-memory-when-x-and-y-are-arrays?-1",
    "page": "Frequently Asked Questions",
    "title": "Why does x += y allocate memory when x and y are arrays?",
    "category": "section",
    "text": "In Julia, x += y gets replaced during parsing by x = x + y. For arrays, this has the consequence that, rather than storing the result in the same location in memory as x, it allocates a new array to store the result.While this behavior might surprise some, the choice is deliberate. The main reason is the presence of immutable objects within Julia, which cannot change their value once created.  Indeed, a number is an immutable object; the statements x = 5; x += 1 do not modify the meaning of 5, they modify the value bound to x. For an immutable, the only way to change the value is to reassign it.To amplify a bit further, consider the following function:function power_by_squaring(x, n::Int)\n    ispow2(n) || error(\"This implementation only works for powers of 2\")\n    while n >= 2\n        x *= x\n        n >>= 1\n    end\n    x\nendAfter a call like x = 5; y = power_by_squaring(x, 4), you would get the expected result: x == 5 && y == 625.  However, now suppose that *=, when used with matrices, instead mutated the left hand side.  There would be two problems:For general square matrices, A = A*B cannot be implemented without temporary storage: A[1,1] gets computed and stored on the left hand side before you\'re done using it on the right hand side.\nSuppose you were willing to allocate a temporary for the computation (which would eliminate most of the point of making *= work in-place); if you took advantage of the mutability of x, then this function would behave differently for mutable vs. immutable inputs. In particular, for immutable x, after the call you\'d have (in general) y != x, but for mutable x you\'d have y == x.Because supporting generic programming is deemed more important than potential performance optimizations that can be achieved by other means (e.g., using explicit loops), operators like += and *= work by rebinding new values."
},

{
    "location": "manual/faq.html#faq-async-io-1",
    "page": "Frequently Asked Questions",
    "title": "Asynchronous IO and concurrent synchronous writes",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#Why-do-concurrent-writes-to-the-same-stream-result-in-inter-mixed-output?-1",
    "page": "Frequently Asked Questions",
    "title": "Why do concurrent writes to the same stream result in inter-mixed output?",
    "category": "section",
    "text": "While the streaming I/O API is synchronous, the underlying implementation is fully asynchronous.Consider the printed output from the following:julia> @sync for i in 1:3\n           @async write(stdout, string(i), \" Foo \", \" Bar \")\n       end\n123 Foo  Foo  Foo  Bar  Bar  BarThis is happening because, while the write call is synchronous, the writing of each argument yields to other tasks while waiting for that part of the I/O to complete.print and println \"lock\" the stream during a call. Consequently changing write to println in the above example results in:julia> @sync for i in 1:3\n           @async println(stdout, string(i), \" Foo \", \" Bar \")\n       end\n1 Foo  Bar\n2 Foo  Bar\n3 Foo  BarYou can lock your writes with a ReentrantLock like this:julia> l = ReentrantLock()\nReentrantLock(nothing, Condition(Any[]), 0)\n\njulia> @sync for i in 1:3\n           @async begin\n               lock(l)\n               try\n                   write(stdout, string(i), \" Foo \", \" Bar \")\n               finally\n                   unlock(l)\n               end\n           end\n       end\n1 Foo  Bar 2 Foo  Bar 3 Foo  Bar"
},

{
    "location": "manual/faq.html#Arrays-1",
    "page": "Frequently Asked Questions",
    "title": "Arrays",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#What-are-the-differences-between-zero-dimensional-arrays-and-scalars?-1",
    "page": "Frequently Asked Questions",
    "title": "What are the differences between zero-dimensional arrays and scalars?",
    "category": "section",
    "text": "Zero-dimensional arrays are arrays of the form Array{T,0}. They behave similar to scalars, but there are important differences. They deserve a special mention because they are a special case which makes logical sense given the generic definition of arrays, but might be a bit unintuitive at first. The following line defines a zero-dimensional array:julia> A = zeros()\n0-dimensional Array{Float64,0}:\n0.0In this example, A is a mutable container that contains one element, which can be set by A[] = 1.0 and retrieved with A[]. All zero-dimensional arrays have the same size (size(A) == ()), and length (length(A) == 1). In particular, zero-dimensional arrays are not empty. If you find this unintuitive, here are some ideas that might help to understand Julia\'s definition.Zero-dimensional arrays are the \"point\" to vector\'s \"line\" and matrix\'s \"plane\". Just as a line has no area (but still represents a set of things), a point has no length or any dimensions at all (but still represents a thing).\nWe define prod(()) to be 1, and the total number of elements in an array is the product of the size. The size of a zero-dimensional array is (), and therefore its length is 1.\nZero-dimensional arrays don\'t natively have any dimensions into which you index – they’re just A[]. We can apply the same \"trailing one\" rule for them as for all other array dimensionalities, so you can indeed index them as A[1], A[1,1], etc.It is also important to understand the differences to ordinary scalars. Scalars are not mutable containers (even though they are iterable and define things like length, getindex, e.g. 1[] == 1). In particular, if x = 0.0 is defined as a scalar, it is an error to attempt to change its value via x[] = 1.0. A scalar x can be converted into a zero-dimensional array containing it via fill(x), and conversely, a zero-dimensional array a can be converted to the contained scalar via a[]. Another difference is that a scalar can participate in linear algebra operations such as 2 * rand(2,2), but the analogous operation with a zero-dimensional array fill(2) * rand(2,2) is an error."
},

{
    "location": "manual/faq.html#Julia-Releases-1",
    "page": "Frequently Asked Questions",
    "title": "Julia Releases",
    "category": "section",
    "text": ""
},

{
    "location": "manual/faq.html#Do-I-want-to-use-a-release,-beta,-or-nightly-version-of-Julia?-1",
    "page": "Frequently Asked Questions",
    "title": "Do I want to use a release, beta, or nightly version of Julia?",
    "category": "section",
    "text": "You may prefer the release version of Julia if you are looking for a stable code base. Releases generally occur every 6 months, giving you a stable platform for writing code.You may prefer the beta version of Julia if you don\'t mind being slightly behind the latest bugfixes and changes, but find the slightly faster rate of changes more appealing. Additionally, these binaries are tested before they are published to ensure they are fully functional.You may prefer the nightly version of Julia if you want to take advantage of the latest updates to the language, and don\'t mind if the version available today occasionally doesn\'t actually work.Finally, you may also consider building Julia from source for yourself. This option is mainly for those individuals who are comfortable at the command line, or interested in learning. If this describes you, you may also be interested in reading our guidelines for contributing.Links to each of these download types can be found on the download page at https://julialang.org/downloads/. Note that not all versions of Julia are available for all platforms."
},

{
    "location": "manual/faq.html#When-are-deprecated-functions-removed?-1",
    "page": "Frequently Asked Questions",
    "title": "When are deprecated functions removed?",
    "category": "section",
    "text": "Deprecated functions are removed after the subsequent release. For example, functions marked as deprecated in the 0.1 release will not be available starting with the 0.2 release."
},

{
    "location": "manual/noteworthy-differences.html#",
    "page": "Noteworthy Differences from other Languages",
    "title": "Noteworthy Differences from other Languages",
    "category": "page",
    "text": ""
},

{
    "location": "manual/noteworthy-differences.html#Noteworthy-Differences-from-other-Languages-1",
    "page": "Noteworthy Differences from other Languages",
    "title": "Noteworthy Differences from other Languages",
    "category": "section",
    "text": ""
},

{
    "location": "manual/noteworthy-differences.html#Noteworthy-differences-from-MATLAB-1",
    "page": "Noteworthy Differences from other Languages",
    "title": "Noteworthy differences from MATLAB",
    "category": "section",
    "text": "Although MATLAB users may find Julia\'s syntax familiar, Julia is not a MATLAB clone. There are major syntactic and functional differences. The following are some noteworthy differences that may trip up Julia users accustomed to MATLAB:Julia arrays are indexed with square brackets, A[i,j].\nJulia arrays are not copied when assigned to another variable. After A = B, changing elements of B will modify A as well.\nJulia values are not copied when passed to a function. If a function modifies an array, the changes will be visible in the caller.\nJulia does not automatically grow arrays in an assignment statement. Whereas in MATLAB a(4) = 3.2 can create the array a = [0 0 0 3.2] and a(5) = 7 can grow it into a = [0 0 0 3.2 7], the corresponding Julia statement a[5] = 7 throws an error if the length of a is less than 5 or if this statement is the first use of the identifier a. Julia has push! and append!, which grow Vectors much more efficiently than MATLAB\'s a(end+1) = val.\nThe imaginary unit sqrt(-1) is represented in Julia as im, not i or j as in MATLAB.\nIn Julia, literal numbers without a decimal point (such as 42) create integers instead of floating point numbers. Arbitrarily large integer literals are supported. As a result, some operations such as 2^-1 will throw a domain error as the result is not an integer (see the FAQ entry on domain errors for details).\nIn Julia, multiple values are returned and assigned as tuples, e.g. (a, b) = (1, 2) or a, b = 1, 2. MATLAB\'s nargout, which is often used in MATLAB to do optional work based on the number of returned values, does not exist in Julia. Instead, users can use optional and keyword arguments to achieve similar capabilities.\nJulia has true one-dimensional arrays. Column vectors are of size N, not Nx1. For example, rand(N) makes a 1-dimensional array.\nIn Julia, [x,y,z] will always construct a 3-element array containing x, y and z.\nTo concatenate in the first (\"vertical\") dimension use either vcat(x,y,z) or separate with semicolons ([x; y; z]).\nTo concatenate in the second (\"horizontal\") dimension use either hcat(x,y,z) or separate with spaces ([x y z]).\nTo construct block matrices (concatenating in the first two dimensions), use either hvcat or combine spaces and semicolons ([a b; c d]).\nIn Julia, a:b and a:b:c construct AbstractRange objects. To construct a full vector like in MATLAB, use collect(a:b). Generally, there is no need to call collect though. An AbstractRange object will act like a normal array in most cases but is more efficient because it lazily computes its values. This pattern of creating specialized objects instead of full arrays is used frequently, and is also seen in functions such as range, or with iterators such as enumerate, and zip. The special objects can mostly be used as if they were normal arrays.\nFunctions in Julia return values from their last expression or the return keyword instead of listing the names of variables to return in the function definition (see The return Keyword for details).\nA Julia script may contain any number of functions, and all definitions will be externally visible when the file is loaded. Function definitions can be loaded from files outside the current working directory.\nIn Julia, reductions such as sum, prod, and max are performed over every element of an array when called with a single argument, as in sum(A), even if A has more than one dimension.\nIn Julia, parentheses must be used to call a function with zero arguments, like in rand().\nJulia discourages the use of semicolons to end statements. The results of statements are not automatically printed (except at the interactive prompt), and lines of code do not need to end with semicolons. println or @printf can be used to print specific output.\nIn Julia, if A and B are arrays, logical comparison operations like A == B do not return an array of booleans. Instead, use A .== B, and similarly for the other boolean operators like <, >.\nIn Julia, the operators &, |, and ⊻ (xor) perform the bitwise operations equivalent to and, or, and xor respectively in MATLAB, and have precedence similar to Python\'s bitwise operators (unlike C). They can operate on scalars or element-wise across arrays and can be used to combine logical arrays, but note the difference in order of operations: parentheses may be required (e.g., to select elements of A equal to 1 or 2 use (A .== 1) .| (A .== 2)).\nIn Julia, the elements of a collection can be passed as arguments to a function using the splat operator ..., as in xs=[1,2]; f(xs...).\nJulia\'s svd returns singular values as a vector instead of as a dense diagonal matrix.\nIn Julia, ... is not used to continue lines of code. Instead, incomplete expressions automatically continue onto the next line.\nIn both Julia and MATLAB, the variable ans is set to the value of the last expression issued in an interactive session. In Julia, unlike MATLAB, ans is not set when Julia code is run in non-interactive mode.\nJulia\'s structs do not support dynamically adding fields at runtime, unlike MATLAB\'s classes. Instead, use a Dict.\nIn Julia each module has its own global scope/namespace, whereas in MATLAB there is just one global scope.\nIn MATLAB, an idiomatic way to remove unwanted values is to use logical indexing, like in the expression x(x>3) or in the statement x(x>3) = [] to modify x in-place. In contrast, Julia provides the higher order functions filter and filter!, allowing users to write filter(z->z>3, x) and filter!(z->z>3, x) as alternatives to the corresponding transliterations x[x.>3] and x = x[x.>3]. Using filter! reduces the use of temporary arrays.\nThe analogue of extracting (or \"dereferencing\") all elements of a cell array, e.g. in vertcat(A{:}) in MATLAB, is written using the splat operator in Julia, e.g. as vcat(A...)."
},

{
    "location": "manual/noteworthy-differences.html#Noteworthy-differences-from-R-1",
    "page": "Noteworthy Differences from other Languages",
    "title": "Noteworthy differences from R",
    "category": "section",
    "text": "One of Julia\'s goals is to provide an effective language for data analysis and statistical programming. For users coming to Julia from R, these are some noteworthy differences:Julia\'s single quotes enclose characters, not strings.\nJulia can create substrings by indexing into strings. In R, strings must be converted into character vectors before creating substrings.\nIn Julia, like Python but unlike R, strings can be created with triple quotes \"\"\" ... \"\"\". This syntax is convenient for constructing strings that contain line breaks.\nIn Julia, varargs are specified using the splat operator ..., which always follows the name of a specific variable, unlike R, for which ... can occur in isolation.\nIn Julia, modulus is mod(a, b), not a %% b. % in Julia is the remainder operator.\nIn Julia, not all data structures support logical indexing. Furthermore, logical indexing in Julia is supported only with vectors of length equal to the object being indexed. For example:\nIn R, c(1, 2, 3, 4)[c(TRUE, FALSE)] is equivalent to c(1, 3).\nIn R, c(1, 2, 3, 4)[c(TRUE, FALSE, TRUE, FALSE)] is equivalent to c(1, 3).\nIn Julia, [1, 2, 3, 4][[true, false]] throws a BoundsError.\nIn Julia, [1, 2, 3, 4][[true, false, true, false]] produces [1, 3].\nLike many languages, Julia does not always allow operations on vectors of different lengths, unlike R where the vectors only need to share a common index range.  For example, c(1, 2, 3, 4) + c(1, 2) is valid R but the equivalent [1, 2, 3, 4] + [1, 2] will throw an error in Julia.\nJulia allows an optional trailing comma when that comma does not change the meaning of code. This can cause confusion among R users when indexing into arrays. For example, x[1,] in R would return the first row of a matrix; in Julia, however, the comma is ignored, so x[1,] == x[1], and will return the first element. To extract a row, be sure to use :, as in x[1,:].\nJulia\'s map takes the function first, then its arguments, unlike lapply(<structure>, function, ...) in R. Similarly Julia\'s equivalent of apply(X, MARGIN, FUN, ...) in R is mapslices where the function is the first argument.\nMultivariate apply in R, e.g. mapply(choose, 11:13, 1:3), can be written as broadcast(binomial, 11:13, 1:3) in Julia. Equivalently Julia offers a shorter dot syntax for vectorizing functions binomial.(11:13, 1:3).\nJulia uses end to denote the end of conditional blocks, like if, loop blocks, like while/ for, and functions. In lieu of the one-line if ( cond ) statement, Julia allows statements of the form if cond; statement; end, cond && statement and !cond || statement. Assignment statements in the latter two syntaxes must be explicitly wrapped in parentheses, e.g. cond && (x = value).\nIn Julia, <-, <<- and -> are not assignment operators.\nJulia\'s -> creates an anonymous function.\nJulia constructs vectors using brackets. Julia\'s [1, 2, 3] is the equivalent of R\'s c(1, 2, 3).\nJulia\'s * operator can perform matrix multiplication, unlike in R. If A and B are matrices, then A * B denotes a matrix multiplication in Julia, equivalent to R\'s A %*% B. In R, this same notation would perform an element-wise (Hadamard) product. To get the element-wise multiplication operation, you need to write A .* B in Julia.\nJulia performs matrix transposition using the transpose function and conjugated transposition using the \' operator or the adjoint function. Julia\'s transpose(A) is therefore equivalent to R\'s t(A). Additionally a non-recursive transpose in Julia is provided by the permutedims function.\nJulia does not require parentheses when writing if statements or for/while loops: use for i in [1, 2, 3] instead of for (i in c(1, 2, 3)) and if i == 1 instead of if (i == 1).\nJulia does not treat the numbers 0 and 1 as Booleans. You cannot write if (1) in Julia, because if statements accept only booleans. Instead, you can write if true, if Bool(1), or if 1==1.\nJulia does not provide nrow and ncol. Instead, use size(M, 1) for nrow(M) and size(M, 2) for ncol(M).\nJulia is careful to distinguish scalars, vectors and matrices.  In R, 1 and c(1) are the same. In Julia, they cannot be used interchangeably.\nJulia\'s diag and diagm are not like R\'s.\nJulia cannot assign to the results of function calls on the left hand side of an assignment operation: you cannot write diag(M) = fill(1, n).\nJulia discourages populating the main namespace with functions. Most statistical functionality for Julia is found in packages under the JuliaStats organization. For example:\nFunctions pertaining to probability distributions are provided by the Distributions package.\nThe DataFrames package provides data frames.\nGeneralized linear models are provided by the GLM package.\nJulia provides tuples and real hash tables, but not R-style lists. When returning multiple items, you should typically use a tuple or a named tuple: instead of list(a = 1, b = 2), use (1, 2) or (a=1, b=2).\nJulia encourages users to write their own types, which are easier to use than S3 or S4 objects in R. Julia\'s multiple dispatch system means that table(x::TypeA) and table(x::TypeB) act like R\'s table.TypeA(x) and table.TypeB(x).\nIn Julia, values are not copied when assigned or passed to a function. If a function modifies an array, the changes will be visible in the caller. This is very different from R and allows new functions to operate on large data structures much more efficiently.\nIn Julia, vectors and matrices are concatenated using hcat, vcat and hvcat, not c, rbind and cbind like in R.\nIn Julia, a range like a:b is not shorthand for a vector like in R, but is a specialized AbstractRange object that is used for iteration without high memory overhead. To convert a range into a vector, use collect(a:b).\nJulia\'s max and min are the equivalent of pmax and pmin respectively in R, but both arguments need to have the same dimensions.  While maximum and minimum replace max and min in R, there are important differences.\nJulia\'s sum, prod, maximum, and minimum are different from their counterparts in R. They all accept an optional keyword argument dims, which indicates the dimensions, over which the operation is carried out.  For instance, let A = [1 2; 3 4] in Julia and B <- rbind(c(1,2),c(3,4)) be the same matrix in R.  Then sum(A) gives the same result as sum(B), but sum(A, dims=1) is a row vector containing the sum over each column and sum(A, dims=2) is a column vector containing the sum over each row. This contrasts to the behavior of R, where separate colSums(B) and rowSums(B) functions provide these functionalities. If the dims keyword argument is a vector, then it specifies all the dimensions over which the sum is performed, while retaining the dimensions of the summed array, e.g. sum(A, dims=(1,2)) == hcat(10). It should be noted that there is no error checking regarding the second argument.\nJulia has several functions that can mutate their arguments. For example, it has both sort and sort!.\nIn R, performance requires vectorization. In Julia, almost the opposite is true: the best performing code is often achieved by using devectorized loops.\nJulia is eagerly evaluated and does not support R-style lazy evaluation. For most users, this means that there are very few unquoted expressions or column names.\nJulia does not support the NULL type. The closest equivalent is nothing, but it behaves like a scalar value rather than like a list. Use x === nothing instead of is.null(x).\nIn Julia, missing values are represented by the missing object rather than by NA. Use ismissing(x) (or ismissing.(x) for element-wise operation on vectors) instead of is.na(x). The skipmissing function is generally used instead of na.rm=TRUE (though in some particular cases functions take a skipmissing argument).\nJulia lacks the equivalent of R\'s assign or get.\nIn Julia, return does not require parentheses.\nIn R, an idiomatic way to remove unwanted values is to use logical indexing, like in the expression x[x>3] or in the statement x = x[x>3] to modify x in-place. In contrast, Julia provides the higher order functions filter and filter!, allowing users to write filter(z->z>3, x) and filter!(z->z>3, x) as alternatives to the corresponding transliterations x[x.>3] and x = x[x.>3]. Using filter! reduces the use of temporary arrays."
},

{
    "location": "manual/noteworthy-differences.html#Noteworthy-differences-from-Python-1",
    "page": "Noteworthy Differences from other Languages",
    "title": "Noteworthy differences from Python",
    "category": "section",
    "text": "Julia requires end to end a block. Unlike Python, Julia has no pass keyword.\nIn Julia, indexing of arrays, strings, etc. is 1-based not 0-based.\nJulia\'s slice indexing includes the last element, unlike in Python. a[2:3] in Julia is a[1:3] in Python.\nJulia does not support negative indices. In particular, the last element of a list or array is indexed with end in Julia, not -1 as in Python.\nJulia\'s for, if, while, etc. blocks are terminated by the end keyword. Indentation level is not significant as it is in Python.\nJulia has no line continuation syntax: if, at the end of a line, the input so far is a complete expression, it is considered done; otherwise the input continues. One way to force an expression to continue is to wrap it in parentheses.\nJulia arrays are column major (Fortran ordered) whereas NumPy arrays are row major (C-ordered) by default. To get optimal performance when looping over arrays, the order of the loops should be reversed in Julia relative to NumPy (see relevant section of Performance Tips).\nJulia\'s updating operators (e.g. +=, -=, ...) are not in-place whereas NumPy\'s are. This means A = [1, 1]; B = A; B += [3, 3] doesn\'t change values in A, it rather rebinds the name B to the result of the right-hand side B = B + 3, which is a new array. For in-place operation, use B .+= 3 (see also dot operators), explicit loops, or InplaceOps.jl.\nJulia evaluates default values of function arguments every time the method is invoked, unlike in Python where the default values are evaluated only once when the function is defined. For example, the function f(x=rand()) = x returns a new random number every time it is invoked without argument. On the other hand, the function g(x=[1,2]) = push!(x,3) returns [1,2,3] every time it is called as g().\nIn Julia % is the remainder operator, whereas in Python it is the modulus."
},

{
    "location": "manual/noteworthy-differences.html#Noteworthy-differences-from-C/C-1",
    "page": "Noteworthy Differences from other Languages",
    "title": "Noteworthy differences from C/C++",
    "category": "section",
    "text": "Julia arrays are indexed with square brackets, and can have more than one dimension A[i,j]. This syntax is not just syntactic sugar for a reference to a pointer or address as in C/C++. See the Julia documentation for the syntax for array construction (it has changed between versions).\nIn Julia, indexing of arrays, strings, etc. is 1-based not 0-based.\nJulia arrays are not copied when assigned to another variable. After A = B, changing elements of B will modify A as well. Updating operators like += do not operate in-place, they are equivalent to A = A + B which rebinds the left-hand side to the result of the right-hand side expression.\nJulia arrays are column major (Fortran ordered) whereas C/C++ arrays are row major ordered by default. To get optimal performance when looping over arrays, the order of the loops should be reversed in Julia relative to C/C++ (see relevant section of Performance Tips).\nJulia values are not copied when assigned or passed to a function. If a function modifies an array, the changes will be visible in the caller.\nIn Julia, whitespace is significant, unlike C/C++, so care must be taken when adding/removing whitespace from a Julia program.\nIn Julia, literal numbers without a decimal point (such as 42) create signed integers, of type Int, but literals too large to fit in the machine word size will automatically be promoted to a larger size type, such as Int64 (if Int is Int32), Int128, or the arbitrarily large BigInt type. There are no numeric literal suffixes, such as L, LL, U, UL, ULL to indicate unsigned and/or signed vs. unsigned. Decimal literals are always signed, and hexadecimal literals (which start with 0x like C/C++), are unsigned. Hexadecimal literals also, unlike C/C++/Java and unlike decimal literals in Julia, have a type based on the length of the literal, including leading 0s. For example, 0x0 and 0x00 have type UInt8, 0x000 and 0x0000 have type UInt16, then literals with 5 to 8 hex digits have type UInt32, 9 to 16 hex digits type UInt64 and 17 to 32 hex digits type UInt128. This needs to be taken into account when defining hexadecimal masks, for example ~0xf == 0xf0 is very different from ~0x000f == 0xfff0. 64 bit Float64 and 32 bit Float32 bit literals are expressed as 1.0 and 1.0f0 respectively. Floating point literals are rounded (and not promoted to the BigFloat type) if they can not be exactly represented.  Floating point literals are closer in behavior to C/C++. Octal (prefixed with 0o) and binary (prefixed with 0b) literals are also treated as unsigned.\nString literals can be delimited with either \"  or \"\"\", \"\"\" delimited literals can contain \" characters without quoting it like \"\\\"\". String literals can have values of other variables or expressions interpolated into them, indicated by $variablename or $(expression), which evaluates the variable name or the expression in the context of the function.\n// indicates a Rational number, and not a single-line comment (which is # in Julia)\n#= indicates the start of a multiline comment, and =# ends it.\nFunctions in Julia return values from their last expression(s) or the return keyword.  Multiple values can be returned from functions and assigned as tuples, e.g. (a, b) = myfunction() or a, b = myfunction(), instead of having to pass pointers to values as one would have to do in C/C++ (i.e. a = myfunction(&b).\nJulia does not require the use of semicolons to end statements. The results of expressions are not automatically printed (except at the interactive prompt, i.e. the REPL), and lines of code do not need to end with semicolons. println or @printf can be used to print specific output. In the REPL, ; can be used to suppress output. ; also has a different meaning within [ ], something to watch out for. ; can be used to separate expressions on a single line, but are not strictly necessary in many cases, and are more an aid to readability.\nIn Julia, the operator ⊻ (xor) performs the bitwise XOR operation, i.e. ^ in C/C++.  Also, the bitwise operators do not have the same precedence as C/++, so parenthesis may be required.\nJulia\'s ^ is exponentiation (pow), not bitwise XOR as in C/C++ (use ⊻, or xor, in Julia)\nJulia has two right-shift operators, >> and >>>.  >>> performs an arithmetic shift, >> always performs a logical shift, unlike C/C++, where the meaning of >> depends on the type of the value being shifted.\nJulia\'s -> creates an anonymous function, it does not access a member via a pointer.\nJulia does not require parentheses when writing if statements or for/while loops: use for i in [1, 2, 3] instead of for (int i=1; i <= 3; i++) and if i == 1 instead of if (i == 1).\nJulia does not treat the numbers 0 and 1 as Booleans. You cannot write if (1) in Julia, because if statements accept only booleans. Instead, you can write if true, if Bool(1), or if 1==1.\nJulia uses end to denote the end of conditional blocks, like if, loop blocks, like while/ for, and functions. In lieu of the one-line if ( cond ) statement, Julia allows statements of the form if cond; statement; end, cond && statement and !cond || statement. Assignment statements in the latter two syntaxes must be explicitly wrapped in parentheses, e.g. cond && (x = value), because of the operator precedence.\nJulia has no line continuation syntax: if, at the end of a line, the input so far is a complete expression, it is considered done; otherwise the input continues. One way to force an expression to continue is to wrap it in parentheses.\nJulia macros operate on parsed expressions, rather than the text of the program, which allows them to perform sophisticated transformations of Julia code. Macro names start with the @ character, and have both a function-like syntax, @mymacro(arg1, arg2, arg3), and a statement-like syntax, @mymacro arg1 arg2 arg3. The forms are interchangeable; the function-like form is particularly useful if the macro appears within another expression, and is often clearest. The statement-like form is often used to annotate blocks, as in the distributed for construct: @distributed for i in 1:n; #= body =#; end. Where the end of the macro construct may be unclear, use the function-like form.\nJulia has an enumeration type, expressed using the macro @enum(name, value1, value2, ...) For example: @enum(Fruit, banana=1, apple, pear)\nBy convention, functions that modify their arguments have a ! at the end of the name, for example push!.\nIn C++, by default, you have static dispatch, i.e. you need to annotate a function as virtual, in order to have dynamic dispatch. On the other hand, in Julia every method is \"virtual\" (although it\'s more general than that since methods are dispatched on every argument type, not only this, using the most-specific-declaration rule)."
},

{
    "location": "manual/unicode-input.html#",
    "page": "Unicode Input",
    "title": "Unicode Input",
    "category": "page",
    "text": ""
},

{
    "location": "manual/unicode-input.html#Unicode-Input-1",
    "page": "Unicode Input",
    "title": "Unicode Input",
    "category": "section",
    "text": "The following table lists Unicode characters that can be entered via tab completion of LaTeX-like abbreviations in the Julia REPL (and in various other editing environments).  You can also get information on how to type a symbol by entering it in the REPL help, i.e. by typing ? and then entering the symbol in the REPL (e.g., by copy-paste from somewhere you saw the symbol).warning: Warning\nThis table may appear to contain missing characters in the second column, or even show characters that are inconsistent with the characters as they are rendered in the Julia REPL. In these cases, users are strongly advised to check their choice of fonts in their browser and REPL environment, as there are known issues with glyphs in many fonts.#\n# Generate a table containing all LaTeX and Emoji tab completions available in the REPL.\n#\nimport REPL, Markdown\nconst NBSP = \'\\u00A0\'\n\nfunction tab_completions(symbols...)\n    completions = Dict{String, Vector{String}}()\n    for each in symbols, (k, v) in each\n        completions[v] = push!(get!(completions, v, String[]), k)\n    end\n    return completions\nend\n\nfunction unicode_data()\n    file = normpath(@__DIR__, \"..\", \"..\", \"..\", \"..\", \"..\", \"doc\", \"UnicodeData.txt\")\n    names = Dict{UInt32, String}()\n    open(file) do unidata\n        for line in readlines(unidata)\n            id, name, desc = split(line, \";\")[[1, 2, 11]]\n            codepoint = parse(UInt32, \"0x$id\")\n            names[codepoint] = titlecase(lowercase(\n                name == \"\" ? desc : desc == \"\" ? name : \"$name / $desc\"))\n        end\n    end\n    return names\nend\n\n# Surround combining characters with no-break spaces (i.e \'\\u00A0\'). Follows the same format\n# for how unicode is displayed on the unicode.org website:\n# http://unicode.org/cldr/utility/character.jsp?a=0300\nfunction fix_combining_chars(char)\n    cat = Base.Unicode.category_code(char)\n    return cat == 6 || cat == 8 ? \"$NBSP$char$NBSP\" : \"$char\"\nend\n\n\nfunction table_entries(completions, unicode_dict)\n    entries = [[\n        \"Code point(s)\", \"Character(s)\",\n        \"Tab completion sequence(s)\", \"Unicode name(s)\"\n    ]]\n    for (chars, inputs) in sort!(collect(completions), by = first)\n        code_points, unicode_names, characters = String[], String[], String[]\n        for char in chars\n            push!(code_points, \"U+$(uppercase(string(UInt32(char), base = 16, pad = 5)))\")\n            push!(unicode_names, get(unicode_dict, UInt32(char), \"(No Unicode name)\"))\n            push!(characters, isempty(characters) ? fix_combining_chars(char) : \"$char\")\n        end\n        push!(entries, [\n            join(code_points, \" + \"), join(characters),\n            join(inputs, \", \"), join(unicode_names, \" + \")\n        ])\n    end\n    return Markdown.Table(entries, [:l, :l, :l, :l])\nend\n\ntable_entries(\n    tab_completions(\n        REPL.REPLCompletions.latex_symbols,\n        REPL.REPLCompletions.emoji_symbols\n    ),\n    unicode_data()\n)"
},

{
    "location": "base/base.html#",
    "page": "Essentials",
    "title": "Essentials",
    "category": "page",
    "text": ""
},

{
    "location": "base/base.html#Essentials-1",
    "page": "Essentials",
    "title": "Essentials",
    "category": "section",
    "text": ""
},

{
    "location": "base/base.html#Introduction-1",
    "page": "Essentials",
    "title": "Introduction",
    "category": "section",
    "text": "Julia Base contains a range of functions and macros appropriate for performing scientific and numerical computing, but is also as broad as those of many general purpose programming languages.  Additional functionality is available from a growing collection of available packages. Functions are grouped by topic below.Some general notes:To use module functions, use import Module to import the module, and Module.fn(x) to use the functions.\nAlternatively, using Module will import all exported Module functions into the current namespace.\nBy convention, function names ending with an exclamation point (!) modify their arguments. Some functions have both modifying (e.g., sort!) and non-modifying (sort) versions."
},

{
    "location": "base/base.html#Base.exit",
    "page": "Essentials",
    "title": "Base.exit",
    "category": "function",
    "text": "exit(code=0)\n\nStop the program with an exit code. The default exit code is zero, indicating that the program completed successfully. In an interactive session, exit() can be called with the keyboard shortcut ^D.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.atexit",
    "page": "Essentials",
    "title": "Base.atexit",
    "category": "function",
    "text": "atexit(f)\n\nRegister a zero-argument function f() to be called at process exit. atexit() hooks are called in last in first out (LIFO) order and run before object finalizers.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isinteractive",
    "page": "Essentials",
    "title": "Base.isinteractive",
    "category": "function",
    "text": "isinteractive() -> Bool\n\nDetermine whether Julia is running an interactive session.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.summarysize",
    "page": "Essentials",
    "title": "Base.summarysize",
    "category": "function",
    "text": "Base.summarysize(obj; exclude=Union{...}, chargeall=Union{...}) -> Int\n\nCompute the amount of memory used by all unique objects reachable from the argument.\n\nKeyword Arguments\n\nexclude: specifies the types of objects to exclude from the traversal.\nchargeall: specifies the types of objects to always charge the size of all of their fields, even if those fields would normally be excluded.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.require",
    "page": "Essentials",
    "title": "Base.require",
    "category": "function",
    "text": "require(into::Module, module::Symbol)\n\nThis function is part of the implementation of using / import, if a module is not already defined in Main. It can also be called directly to force reloading a module, regardless of whether it has been loaded before (for example, when interactively developing libraries).\n\nLoads a source file, in the context of the Main module, on every active node, searching standard locations for files. require is considered a top-level operation, so it sets the current include path but does not use it to search for files (see help for include). This function is typically used to load library code, and is implicitly called by using to load packages.\n\nWhen searching for files, require first looks for package code in the global array LOAD_PATH. require is case-sensitive on all platforms, including those with case-insensitive filesystems like macOS and Windows.\n\nFor more details regarding code loading, see the manual.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.compilecache",
    "page": "Essentials",
    "title": "Base.compilecache",
    "category": "function",
    "text": "Base.compilecache(module::PkgId)\n\nCreates a precompiled cache file for a module and all of its dependencies. This can be used to reduce package load times. Cache files are stored in DEPOT_PATH[1]/compiled. See Module initialization and precompilation for important notes.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.__precompile__",
    "page": "Essentials",
    "title": "Base.__precompile__",
    "category": "function",
    "text": "__precompile__(isprecompilable::Bool)\n\nSpecify whether the file calling this function is precompilable, defaulting to true. If a module or file is not safely precompilable, it should call __precompile__(false) in order to throw an error if Julia attempts to precompile it.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.include",
    "page": "Essentials",
    "title": "Base.include",
    "category": "function",
    "text": "Base.include([m::Module,] path::AbstractString)\n\nEvaluate the contents of the input source file in the global scope of module m. Every module (except those defined with baremodule) has its own 1-argument definition of include, which evaluates the file in that module. Returns the result of the last evaluated expression of the input file. During including, a task-local include path is set to the directory containing the file. Nested calls to include will search relative to that path. This function is typically used to load source interactively, or to combine files in packages that are broken into multiple source files.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.MainInclude.include",
    "page": "Essentials",
    "title": "Base.MainInclude.include",
    "category": "function",
    "text": "include(path::AbstractString)\n\nEvaluate the contents of the input source file in the global scope of the containing module. Every module (except those defined with baremodule) has its own 1-argument definition of include, which evaluates the file in that module. Returns the result of the last evaluated expression of the input file. During including, a task-local include path is set to the directory containing the file. Nested calls to include will search relative to that path. This function is typically used to load source interactively, or to combine files in packages that are broken into multiple source files.\n\nUse Base.include to evaluate a file into another module.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.include_string",
    "page": "Essentials",
    "title": "Base.include_string",
    "category": "function",
    "text": "include_string(m::Module, code::AbstractString, filename::AbstractString=\"string\")\n\nLike include, except reads code from the given string rather than from a file.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.include_dependency",
    "page": "Essentials",
    "title": "Base.include_dependency",
    "category": "function",
    "text": "include_dependency(path::AbstractString)\n\nIn a module, declare that the file specified by path (relative or absolute) is a dependency for precompilation; that is, the module will need to be recompiled if this file changes.\n\nThis is only needed if your module depends on a file that is not used via include. It has no effect outside of compilation.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.which-Tuple{Any,Any}",
    "page": "Essentials",
    "title": "Base.which",
    "category": "method",
    "text": "which(f, types)\n\nReturns the method of f (a Method object) that would be called for arguments of the given types.\n\nIf types is an abstract type, then the method that would be called by invoke is returned.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.methods",
    "page": "Essentials",
    "title": "Base.methods",
    "category": "function",
    "text": "methods(f, [types])\n\nReturns the method table for f.\n\nIf types is specified, returns an array of methods whose types match.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@show",
    "page": "Essentials",
    "title": "Base.@show",
    "category": "macro",
    "text": "@show\n\nShow an expression and result, returning the result.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#ans",
    "page": "Essentials",
    "title": "ans",
    "category": "keyword",
    "text": "ans\n\nA variable referring to the last computed value, automatically set at the interactive prompt.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Getting-Around-1",
    "page": "Essentials",
    "title": "Getting Around",
    "category": "section",
    "text": "Base.exit\nBase.atexit\nBase.isinteractive\nBase.summarysize\nBase.require\nBase.compilecache\nBase.__precompile__\nBase.include\nBase.MainInclude.include\nBase.include_string\nBase.include_dependency\nBase.which(::Any, ::Any)\nBase.methods\nBase.@show\nans"
},

{
    "location": "base/base.html#module",
    "page": "Essentials",
    "title": "module",
    "category": "keyword",
    "text": "module\n\nmodule declares a Module, which is a separate global variable workspace. Within a module, you can control which names from other modules are visible (via importing), and specify which of your names are intended to be public (via exporting). Modules allow you to create top-level definitions without worrying about name conflicts when your code is used together with somebody else’s. See the manual section about modules for more details.\n\nExamples\n\nmodule Foo\nimport Base.show\nexport MyType, foo\n\nstruct MyType\n    x\nend\n\nbar(x) = 2x\nfoo(a::MyType) = bar(a.x) + 1\nshow(io::IO, a::MyType) = print(io, \"MyType $(a.x)\")\nend\n\n\n\n\n\n"
},

{
    "location": "base/base.html#export",
    "page": "Essentials",
    "title": "export",
    "category": "keyword",
    "text": "export\n\nexport is used within modules to tell Julia which functions should be made available to the user. For example: export foo makes the name foo available when using the module. See the manual section about modules for details.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#import",
    "page": "Essentials",
    "title": "import",
    "category": "keyword",
    "text": "import\n\nimport Foo will load the module or package Foo. Names from the imported Foo module can be accessed with dot syntax (e.g. Foo.foo to access the name foo). See the manual section about modules for details.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#using",
    "page": "Essentials",
    "title": "using",
    "category": "keyword",
    "text": "using\n\nusing Foo will load the module or package Foo and make its exported names available for direct use. Names can also be used via dot syntax (e.g. Foo.foo to access the name foo), whether they are exported or not. See the manual section about modules for details.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#baremodule",
    "page": "Essentials",
    "title": "baremodule",
    "category": "keyword",
    "text": "baremodule\n\nbaremodule declares a module that does not contain using Base or a definition of eval. It does still import Core.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#function",
    "page": "Essentials",
    "title": "function",
    "category": "keyword",
    "text": "function\n\nFunctions are defined with the function keyword:\n\nfunction add(a, b)\n    return a + b\nend\n\nOr the short form notation:\n\nadd(a, b) = a + b\n\nThe use of the return keyword is exactly the same as in other languages, but is often optional. A function without an explicit return statement will return the last expression in the function body.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#macro",
    "page": "Essentials",
    "title": "macro",
    "category": "keyword",
    "text": "macro\n\nmacro defines a method for inserting generated code into a program. A macro maps a sequence of argument expressions to a returned expression, and the resulting expression is substituted directly into the program at the point where the macro is invoked. Macros are a way to run generated code without calling eval, since the generated code instead simply becomes part of the surrounding program. Macro arguments may include expressions, literal values, and symbols.\n\nExamples\n\njulia> macro sayhello(name)\n           return :( println(\"Hello, \", $name, \"!\") )\n       end\n@sayhello (macro with 1 method)\n\njulia> @sayhello \"Charlie\"\nHello, Charlie!\n\n\n\n\n\n"
},

{
    "location": "base/base.html#return",
    "page": "Essentials",
    "title": "return",
    "category": "keyword",
    "text": "return\n\nreturn x causes the enclosing function to exit early, passing the given value x back to its caller. return by itself with no value is equivalent to return nothing (see nothing).\n\nfunction compare(a, b)\n    a == b && return \"equal to\"\n    a < b ? \"less than\" : \"greater than\"\nend\n\nIn general you can place a return statement anywhere within a function body, including within deeply nested loops or conditionals, but be careful with do blocks. For example:\n\nfunction test1(xs)\n    for x in xs\n        iseven(x) && return 2x\n    end\nend\n\nfunction test2(xs)\n    map(xs) do x\n        iseven(x) && return 2x\n        x\n    end\nend\n\nIn the first example, the return breaks out of test1 as soon as it hits an even number, so test1([5,6,7]) returns 12.\n\nYou might expect the second example to behave the same way, but in fact the return there only breaks out of the inner function (inside the do block) and gives a value back to map. test2([5,6,7]) then returns [5,12,7].\n\nWhen used in a top-level expression (i.e. outside any function), return causes the entire current top-level expression to terminate early.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#do",
    "page": "Essentials",
    "title": "do",
    "category": "keyword",
    "text": "do\n\nCreate an anonymous function and pass it as the first argument to a function call. For example:\n\nmap(1:10) do x\n    2x\nend\n\nis equivalent to map(x->2x, 1:10).\n\nUse multiple arguments like so:\n\nmap(1:10, 11:20) do x, y\n    x + y\nend\n\n\n\n\n\n"
},

{
    "location": "base/base.html#begin",
    "page": "Essentials",
    "title": "begin",
    "category": "keyword",
    "text": "begin\n\nbegin...end denotes a block of code.\n\nbegin\n    println(\"Hello, \")\n    println(\"World!\")\nend\n\nUsually begin will not be necessary, since keywords such as function and let implicitly begin blocks of code. See also ;.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#end",
    "page": "Essentials",
    "title": "end",
    "category": "keyword",
    "text": "end\n\nend marks the conclusion of a block of expressions, for example module, struct, mutable struct, begin, let, for etc. end may also be used when indexing into an array to represent the last index of a dimension.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Array{Int64,2}:\n 1  2\n 3  4\n\njulia> A[end, :]\n2-element Array{Int64,1}:\n 3\n 4\n\n\n\n\n\n"
},

{
    "location": "base/base.html#let",
    "page": "Essentials",
    "title": "let",
    "category": "keyword",
    "text": "let\n\nlet statements allocate new variable bindings each time they run. Whereas an assignment modifies an existing value location, let creates new locations. This difference is only detectable in the case of variables that outlive their scope via closures. The let syntax accepts a comma-separated series of assignments and variable names:\n\nlet var1 = value1, var2, var3 = value3\n    code\nend\n\nThe assignments are evaluated in order, with each right-hand side evaluated in the scope before the new variable on the left-hand side has been introduced. Therefore it makes sense to write something like let x = x, since the two x variables are distinct and have separate storage.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#if",
    "page": "Essentials",
    "title": "if",
    "category": "keyword",
    "text": "if/elseif/else\n\nif/elseif/else performs conditional evaluation, which allows portions of code to be evaluated or not evaluated depending on the value of a boolean expression. Here is the anatomy of the if/elseif/else conditional syntax:\n\nif x < y\n    println(\"x is less than y\")\nelseif x > y\n    println(\"x is greater than y\")\nelse\n    println(\"x is equal to y\")\nend\n\nIf the condition expression x < y is true, then the corresponding block is evaluated; otherwise the condition expression x > y is evaluated, and if it is true, the corresponding block is evaluated; if neither expression is true, the else block is evaluated. The elseif and else blocks are optional, and as many elseif blocks as desired can be used.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#for",
    "page": "Essentials",
    "title": "for",
    "category": "keyword",
    "text": "for\n\nfor loops repeatedly evaluate a block of statements while iterating over a sequence of values.\n\nExamples\n\njulia> for i in [1, 4, 0]\n           println(i)\n       end\n1\n4\n0\n\n\n\n\n\n"
},

{
    "location": "base/base.html#while",
    "page": "Essentials",
    "title": "while",
    "category": "keyword",
    "text": "while\n\nwhile loops repeatedly evaluate a conditional expression, and continue evaluating the body of the while loop as long as the expression remains true. If the condition expression is false when the while loop is first reached, the body is never evaluated.\n\nExamples\n\njulia> i = 1\n1\n\njulia> while i < 5\n           println(i)\n           global i += 1\n       end\n1\n2\n3\n4\n\n\n\n\n\n"
},

{
    "location": "base/base.html#break",
    "page": "Essentials",
    "title": "break",
    "category": "keyword",
    "text": "break\n\nBreak out of a loop immediately.\n\nExamples\n\njulia> i = 0\n0\n\njulia> while true\n           global i += 1\n           i > 5 && break\n           println(i)\n       end\n1\n2\n3\n4\n5\n\n\n\n\n\n"
},

{
    "location": "base/base.html#continue",
    "page": "Essentials",
    "title": "continue",
    "category": "keyword",
    "text": "continue\n\nSkip the rest of the current loop iteration.\n\nExamples\n\njulia> for i = 1:6\n           iseven(i) && continue\n           println(i)\n       end\n1\n3\n5\n\n\n\n\n\n"
},

{
    "location": "base/base.html#try",
    "page": "Essentials",
    "title": "try",
    "category": "keyword",
    "text": "try/catch\n\nA try/catch statement allows intercepting errors (exceptions) thrown by throw so that program execution can continue. For example, the following code attempts to write a file, but warns the user and proceeds instead of terminating execution if the file cannot be written:\n\ntry\n    open(\"/danger\", \"w\") do f\n        println(f, \"Hello\")\n    end\ncatch\n    @warn \"Could not write file.\"\nend\n\nThe syntax catch e (where e is any variable) assigns the thrown exception object to the given variable within the catch block.\n\nThe power of the try/catch construct lies in the ability to unwind a deeply nested computation immediately to a much higher level in the stack of calling functions.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#finally",
    "page": "Essentials",
    "title": "finally",
    "category": "keyword",
    "text": "finally\n\nRun some code when a given block of code exits, regardless of how it exits. For example, here is how we can guarantee that an opened file is closed:\n\nf = open(\"file\")\ntry\n    operate_on_file(f)\nfinally\n    close(f)\nend\n\nWhen control leaves the try block (for example, due to a return, or just finishing normally), close(f) will be executed. If the try block exits due to an exception, the exception will continue propagating. A catch block may be combined with try and finally as well. In this case the finally block will run after catch has handled the error.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#quote",
    "page": "Essentials",
    "title": "quote",
    "category": "keyword",
    "text": "quote\n\nquote creates multiple expression objects in a block without using the explicit Expr constructor. For example:\n\nex = quote\n    x = 1\n    y = 2\n    x + y\nend\n\nUnlike the other means of quoting, :( ... ), this form introduces QuoteNode elements to the expression tree, which must be considered when directly manipulating the tree. For other purposes, :( ... ) and quote .. end blocks are treated identically.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#local",
    "page": "Essentials",
    "title": "local",
    "category": "keyword",
    "text": "local\n\nlocal introduces a new local variable. See the manual section on variable scoping for more information.\n\nExamples\n\njulia> function foo(n)\n           x = 0\n           for i = 1:n\n               local x # introduce a loop-local x\n               x = i\n           end\n           x\n       end\nfoo (generic function with 1 method)\n\njulia> foo(10)\n0\n\n\n\n\n\n"
},

{
    "location": "base/base.html#global",
    "page": "Essentials",
    "title": "global",
    "category": "keyword",
    "text": "global\n\nglobal x makes x in the current scope and its inner scopes refer to the global variable of that name. See the manual section on variable scoping for more information.\n\nExamples\n\njulia> z = 3\n3\n\njulia> function foo()\n           global z = 6 # use the z variable defined outside foo\n       end\nfoo (generic function with 1 method)\n\njulia> foo()\n6\n\njulia> z\n6\n\n\n\n\n\n"
},

{
    "location": "base/base.html#const",
    "page": "Essentials",
    "title": "const",
    "category": "keyword",
    "text": "const\n\nconst is used to declare global variables whose values will not change. In almost all code (and particularly performance sensitive code) global variables should be declared constant in this way.\n\nconst x = 5\n\nMultiple variables can be declared within a single const:\n\nconst y, z = 7, 11\n\nNote that const only applies to one = operation, therefore const x = y = 1 declares x to be constant but not y. On the other hand, const x = const y = 1 declares both x and y constant.\n\nNote that \"constant-ness\" does not extend into mutable containers; only the association between a variable and its value is constant. If x is an array or dictionary (for example) you can still modify, add, or remove elements.\n\nIn some cases changing the value of a const variable gives a warning instead of an error. However, this can produce unpredictable behavior or corrupt the state of your program, and so should be avoided. This feature is intended only for convenience during interactive use.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#struct",
    "page": "Essentials",
    "title": "struct",
    "category": "keyword",
    "text": "struct\n\nThe most commonly used kind of type in Julia is a struct, specified as a name and a set of fields.\n\nstruct Point\n    x\n    y\nend\n\nFields can have type restrictions, which may be parameterized:\n\n    struct Point{X}\n        x::X\n        y::Float64\n    end\n\nA struct can also declare an abstract super type via <: syntax:\n\nstruct Point <: AbstractPoint\n    x\n    y\nend\n\nstructs are immutable by default; an instance of one of these types cannot be modified after construction. Use mutable struct instead to declare a type whose instances can be modified.\n\nSee the manual section on Composite Types for more details, such as how to define constructors.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#mutable struct",
    "page": "Essentials",
    "title": "mutable struct",
    "category": "keyword",
    "text": "mutable struct\n\nmutable struct is similar to struct, but additionally allows the fields of the type to be set after construction. See the manual section on Composite Types for more information.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#abstract type",
    "page": "Essentials",
    "title": "abstract type",
    "category": "keyword",
    "text": "abstract type\n\nabstract type declares a type that cannot be instantiated, and serves only as a node in the type graph, thereby describing sets of related concrete types: those concrete types which are their descendants. Abstract types form the conceptual hierarchy which makes Julia’s type system more than just a collection of object implementations. For example:\n\nabstract type Number end\nabstract type Real <: Number end\n\nNumber has no supertype, whereas Real is an abstract subtype of Number.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#primitive type",
    "page": "Essentials",
    "title": "primitive type",
    "category": "keyword",
    "text": "primitive type\n\nprimitive type declares a concrete type whose data consists only of a series of bits. Classic examples of primitive types are integers and floating-point values. Some example built-in primitive type declarations:\n\nprimitive type Char 32 end\nprimitive type Bool <: Integer 8 end\n\nThe number after the name indicates how many bits of storage the type requires. Currently, only sizes that are multiples of 8 bits are supported. The Bool declaration shows how a primitive type can be optionally declared to be a subtype of some supertype.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#where",
    "page": "Essentials",
    "title": "where",
    "category": "keyword",
    "text": "where\n\nThe where keyword creates a type that is an iterated union of other types, over all values of some variable. For example Vector{T} where T<:Real includes all Vectors where the element type is some kind of Real number.\n\nThe variable bound defaults to Any if it is omitted:\n\nVector{T} where T    # short for `where T<:Any`\n\nVariables can also have lower bounds:\n\nVector{T} where T>:Int\nVector{T} where Int<:T<:Real\n\nThere is also a concise syntax for nested where expressions. For example, this:\n\nPair{T, S} where S<:Array{T} where T<:Number\n\ncan be shortened to:\n\nPair{T, S} where {T<:Number, S<:Array{T}}\n\nThis form is often found on method signatures.\n\nNote that in this form, the variables are listed outermost-first. This matches the order in which variables are substituted when a type is \"applied\" to parameter values using the syntax T{p1, p2, ...}.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#...",
    "page": "Essentials",
    "title": "...",
    "category": "keyword",
    "text": "...\n\nThe \"splat\" operator, ..., represents a sequence of arguments. ... can be used in function definitions, to indicate that the function accepts an arbitrary number of arguments. ... can also be used to apply a function to a sequence of arguments.\n\nExamples\n\njulia> add(xs...) = reduce(+, xs)\nadd (generic function with 1 method)\n\njulia> add(1, 2, 3, 4, 5)\n15\n\njulia> add([1, 2, 3]...)\n6\n\njulia> add(7, 1:100..., 1000:1100...)\n111107\n\n\n\n\n\n"
},

{
    "location": "base/base.html#;",
    "page": "Essentials",
    "title": ";",
    "category": "keyword",
    "text": ";\n\n; has a similar role in Julia as in many C-like languages, and is used to delimit the end of the previous statement. ; is not necessary after new lines, but can be used to separate statements on a single line or to join statements into a single expression. ; is also used to suppress output printing in the REPL and similar interfaces.\n\nExamples\n\njulia> function foo()\n           x = \"Hello, \"; x *= \"World!\"\n           return x\n       end\nfoo (generic function with 1 method)\n\njulia> bar() = (x = \"Hello, Mars!\"; return x)\nbar (generic function with 1 method)\n\njulia> foo();\n\njulia> bar()\n\"Hello, Mars!\"\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Keywords-1",
    "page": "Essentials",
    "title": "Keywords",
    "category": "section",
    "text": "This is the list of reserved keywords in Julia: baremodule, begin, break, catch, const, continue, do, else, elseif, end, export, false, finally, for, function, global, if, import, let, local, macro, module, quote, return, struct, true, try, using, while. Those keywords are not allowed to be used as variable names.The following two-word sequences are reserved: abstract type, mutable struct, primitive type. However, you can create variables with names: abstract, mutable, primitive and type.Finally,where is parsed as an infix operator for writing parametric method and type definitions. Also in and isa are parsed as infix operators. Creation of a variable named where, in or isa is allowed though.module\nexport\nimport\nusing\nbaremodule\nfunction\nmacro\nreturn\ndo\nbegin\nend\nlet\nif\nfor\nwhile\nbreak\ncontinue\ntry\nfinally\nquote\nlocal\nglobal\nconst\nstruct\nmutable struct\nabstract type\nprimitive type\nwhere\n...\n;"
},

{
    "location": "base/base.html#Base",
    "page": "Essentials",
    "title": "Base",
    "category": "keyword",
    "text": "The base library of Julia.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Broadcast",
    "page": "Essentials",
    "title": "Base.Broadcast",
    "category": "module",
    "text": "Base.Broadcast\n\nModule containing the broadcasting implementation.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Docs",
    "page": "Essentials",
    "title": "Base.Docs",
    "category": "module",
    "text": "Docs\n\nThe Docs module provides the @doc macro which can be used to set and retrieve documentation metadata for Julia objects.\n\nPlease see the manual section on documentation for more information.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Iterators",
    "page": "Essentials",
    "title": "Base.Iterators",
    "category": "module",
    "text": "Methods for working with Iterators.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Libc",
    "page": "Essentials",
    "title": "Base.Libc",
    "category": "module",
    "text": "Interface to libc, the C standard library.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Meta",
    "page": "Essentials",
    "title": "Base.Meta",
    "category": "module",
    "text": "Convenience functions for metaprogramming.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.StackTraces",
    "page": "Essentials",
    "title": "Base.StackTraces",
    "category": "module",
    "text": "Tools for collecting and manipulating stack traces. Mainly used for building errors.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys",
    "page": "Essentials",
    "title": "Base.Sys",
    "category": "module",
    "text": "Provide methods for retrieving information about hardware and the operating system.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Threads",
    "page": "Essentials",
    "title": "Base.Threads",
    "category": "module",
    "text": "Experimental multithreading support.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.GC",
    "page": "Essentials",
    "title": "Base.GC",
    "category": "module",
    "text": "Base.GC\n\nModule with garbage collection utilities.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base-Modules-1",
    "page": "Essentials",
    "title": "Base Modules",
    "category": "section",
    "text": "Base.Base\nBase.Broadcast\nBase.Docs\nBase.Iterators\nBase.Libc\nBase.Meta\nBase.StackTraces\nBase.Sys\nBase.Threads\nBase.GC"
},

{
    "location": "base/base.html#Core.:===",
    "page": "Essentials",
    "title": "Core.:===",
    "category": "function",
    "text": "===(x,y) -> Bool\n≡(x,y) -> Bool\n\nDetermine whether x and y are identical, in the sense that no program could distinguish them. First the types of x and y are compared. If those are identical, mutable objects are compared by address in memory and immutable objects (such as numbers) are compared by contents at the bit level. This function is sometimes called \"egal\". It always returns a Bool value.\n\nExamples\n\njulia> a = [1, 2]; b = [1, 2];\n\njulia> a == b\ntrue\n\njulia> a === b\nfalse\n\njulia> a === a\ntrue\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.isa",
    "page": "Essentials",
    "title": "Core.isa",
    "category": "function",
    "text": "isa(x, type) -> Bool\n\nDetermine whether x is of the given type. Can also be used as an infix operator, e.g. x isa type.\n\nExamples\n\njulia> isa(1, Int)\ntrue\n\njulia> isa(1, Matrix)\nfalse\n\njulia> isa(1, Char)\nfalse\n\njulia> isa(1, Number)\ntrue\n\njulia> 1 isa Number\ntrue\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isequal",
    "page": "Essentials",
    "title": "Base.isequal",
    "category": "function",
    "text": "isequal(x, y)\n\nSimilar to ==, except for the treatment of floating point numbers and of missing values. isequal treats all floating-point NaN values as equal to each other, treats -0.0 as unequal to 0.0, and missing as equal to missing. Always returns a Bool value.\n\nImplementation\n\nThe default implementation of isequal calls ==, so a type that does not involve floating-point values generally only needs to define ==.\n\nisequal is the comparison function used by hash tables (Dict). isequal(x,y) must imply that hash(x) == hash(y).\n\nThis typically means that types for which a custom == or isequal method exists must implement a corresponding hash method (and vice versa). Collections typically implement isequal by calling isequal recursively on all contents.\n\nScalar types generally do not need to implement isequal separate from ==, unless they represent floating-point numbers amenable to a more efficient implementation than that provided as a generic fallback (based on isnan, signbit, and ==).\n\nExamples\n\njulia> isequal([1., NaN], [1., NaN])\ntrue\n\njulia> [1., NaN] == [1., NaN]\nfalse\n\njulia> 0.0 == -0.0\ntrue\n\njulia> isequal(0.0, -0.0)\nfalse\n\n\n\n\n\nisequal(x)\n\nCreate a function that compares its argument to x using isequal, i.e. a function equivalent to y -> isequal(y, x).\n\nThe returned function is of type Base.Fix2{typeof(isequal)}, which can be used to implement specialized methods.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isless",
    "page": "Essentials",
    "title": "Base.isless",
    "category": "function",
    "text": "isless(x, y)\n\nTest whether x is less than y, according to a canonical total order. Values that are normally unordered, such as NaN, are ordered in an arbitrary but consistent fashion. missing values are ordered last.\n\nThis is the default comparison used by sort.\n\nImplementation\n\nNon-numeric types with a canonical total order should implement this function. Numeric types only need to implement it if they have special values such as NaN. Types with a canonical partial order should implement <.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.ifelse",
    "page": "Essentials",
    "title": "Core.ifelse",
    "category": "function",
    "text": "ifelse(condition::Bool, x, y)\n\nReturn x if condition is true, otherwise return y. This differs from ? or if in that it is an ordinary function, so all the arguments are evaluated first. In some cases, using ifelse instead of an if statement can eliminate the branch in generated code and provide higher performance in tight loops.\n\nExamples\n\njulia> ifelse(1 > 2, 1, 2)\n2\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.typeassert",
    "page": "Essentials",
    "title": "Core.typeassert",
    "category": "function",
    "text": "typeassert(x, type)\n\nThrow a TypeError unless x isa type. The syntax x::type calls this function.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.typeof",
    "page": "Essentials",
    "title": "Core.typeof",
    "category": "function",
    "text": "typeof(x)\n\nGet the concrete type of x.\n\nExamples\n\njulia> a = 1//2;\n\njulia> typeof(a)\nRational{Int64}\n\njulia> M = [1 2; 3.5 4];\n\njulia> typeof(M)\nArray{Float64,2}\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.tuple",
    "page": "Essentials",
    "title": "Core.tuple",
    "category": "function",
    "text": "tuple(xs...)\n\nConstruct a tuple of the given objects.\n\nExamples\n\njulia> tuple(1, \'a\', pi)\n(1, \'a\', π = 3.1415926535897...)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.ntuple",
    "page": "Essentials",
    "title": "Base.ntuple",
    "category": "function",
    "text": "ntuple(f::Function, n::Integer)\n\nCreate a tuple of length n, computing each element as f(i), where i is the index of the element.\n\nExamples\n\njulia> ntuple(i -> 2*i, 4)\n(2, 4, 6, 8)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.objectid",
    "page": "Essentials",
    "title": "Base.objectid",
    "category": "function",
    "text": "objectid(x)\n\nGet a hash value for x based on object identity. objectid(x)==objectid(y) if x === y.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.hash",
    "page": "Essentials",
    "title": "Base.hash",
    "category": "function",
    "text": "hash(x[, h::UInt])\n\nCompute an integer hash code such that isequal(x,y) implies hash(x)==hash(y). The optional second argument h is a hash code to be mixed with the result.\n\nNew types should implement the 2-argument form, typically by calling the 2-argument hash method recursively in order to mix hashes of the contents with each other (and with h). Typically, any type that implements hash should also implement its own == (hence isequal) to guarantee the property mentioned above. Types supporting subtraction (operator -) should also implement widen, which is required to hash values inside heterogeneous arrays.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.finalizer",
    "page": "Essentials",
    "title": "Base.finalizer",
    "category": "function",
    "text": "finalizer(f, x)\n\nRegister a function f(x) to be called when there are no program-accessible references to x, and return x. The type of x must be a mutable struct, otherwise the behavior of this function is unpredictable.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.finalize",
    "page": "Essentials",
    "title": "Base.finalize",
    "category": "function",
    "text": "finalize(x)\n\nImmediately run finalizers registered for object x.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.copy",
    "page": "Essentials",
    "title": "Base.copy",
    "category": "function",
    "text": "copy(x)\n\nCreate a shallow copy of x: the outer structure is copied, but not all internal values. For example, copying an array produces a new array with identically-same elements as the original.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.deepcopy",
    "page": "Essentials",
    "title": "Base.deepcopy",
    "category": "function",
    "text": "deepcopy(x)\n\nCreate a deep copy of x: everything is copied recursively, resulting in a fully independent object. For example, deep-copying an array produces a new array whose elements are deep copies of the original elements. Calling deepcopy on an object should generally have the same effect as serializing and then deserializing it.\n\nAs a special case, functions can only be actually deep-copied if they are anonymous, otherwise they are just copied. The difference is only relevant in the case of closures, i.e. functions which may contain hidden internal references.\n\nWhile it isn\'t normally necessary, user-defined types can override the default deepcopy behavior by defining a specialized version of the function deepcopy_internal(x::T, dict::IdDict) (which shouldn\'t otherwise be used), where T is the type to be specialized for, and dict keeps track of objects copied so far within the recursion. Within the definition, deepcopy_internal should be used in place of deepcopy, and the dict variable should be updated as appropriate before returning.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.getproperty",
    "page": "Essentials",
    "title": "Base.getproperty",
    "category": "function",
    "text": "getproperty(value, name::Symbol)\n\nThe syntax a.b calls getproperty(a, :b).\n\nExamples\n\njulia> struct MyType\n           x\n       end\n\njulia> function Base.getproperty(obj::MyType, sym::Symbol)\n           if sym === :special\n               return obj.x + 1\n           else # fallback to getfield\n               return getfield(obj, sym)\n           end\n       end\n\njulia> obj = MyType(1);\n\njulia> obj.special\n2\n\njulia> obj.x\n1\n\nSee also propertynames and setproperty!.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.setproperty!",
    "page": "Essentials",
    "title": "Base.setproperty!",
    "category": "function",
    "text": "setproperty!(value, name::Symbol, x)\n\nThe syntax a.b = c calls setproperty!(a, :b, c).\n\nSee also propertynames and getproperty.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.propertynames",
    "page": "Essentials",
    "title": "Base.propertynames",
    "category": "function",
    "text": "propertynames(x, private=false)\n\nGet a tuple or a vector of the properties (x.property) of an object x. This is typically the same as fieldnames(typeof(x)), but types that overload getproperty should generally overload propertynames as well to get the properties of an instance of the type.\n\npropertynames(x) may return only \"public\" property names that are part of the documented interface of x.   If you want it to also return \"private\" fieldnames intended for internal use, pass true for the optional second argument. REPL tab completion on x. shows only the private=false properties.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.getfield",
    "page": "Essentials",
    "title": "Core.getfield",
    "category": "function",
    "text": "getfield(value, name::Symbol)\n\nExtract a named field from a value of composite type. See also getproperty.\n\nExamples\n\njulia> a = 1//2\n1//2\n\njulia> getfield(a, :num)\n1\n\njulia> a.num\n1\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.setfield!",
    "page": "Essentials",
    "title": "Core.setfield!",
    "category": "function",
    "text": "setfield!(value, name::Symbol, x)\n\nAssign x to a named field in value of composite type. The value must be mutable and x must be a subtype of fieldtype(typeof(value), name). See also setproperty!.\n\nExamples\n\njulia> mutable struct MyMutableStruct\n           field::Int\n       end\n\njulia> a = MyMutableStruct(1);\n\njulia> setfield!(a, :field, 2);\n\njulia> getfield(a, :field)\n2\n\njulia> a = 1//2\n1//2\n\njulia> setfield!(a, :num, 3);\nERROR: setfield! immutable struct of type Rational cannot be changed\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.isdefined",
    "page": "Essentials",
    "title": "Core.isdefined",
    "category": "function",
    "text": "isdefined(m::Module, s::Symbol)\nisdefined(object, s::Symbol)\nisdefined(object, index::Int)\n\nTests whether a global variable or object field is defined. The arguments can be a module and a symbol or a composite object and field name (as a symbol) or index.\n\nTo test whether an array element is defined, use isassigned instead.\n\nExamples\n\njulia> isdefined(Base, :sum)\ntrue\n\njulia> isdefined(Base, :NonExistentMethod)\nfalse\n\njulia> a = 1//2;\n\njulia> isdefined(a, 2)\ntrue\n\njulia> isdefined(a, 3)\nfalse\n\njulia> isdefined(a, :num)\ntrue\n\njulia> isdefined(a, :numerator)\nfalse\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@isdefined",
    "page": "Essentials",
    "title": "Base.@isdefined",
    "category": "macro",
    "text": "@isdefined s -> Bool\n\nTests whether variable s is defined in the current scope.\n\nExamples\n\njulia> function f()\n           println(@isdefined x)\n           x = 3\n           println(@isdefined x)\n       end\nf (generic function with 1 method)\n\njulia> f()\nfalse\ntrue\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.convert",
    "page": "Essentials",
    "title": "Base.convert",
    "category": "function",
    "text": "convert(T, x)\n\nConvert x to a value of type T.\n\nIf T is an Integer type, an InexactError will be raised if x is not representable by T, for example if x is not integer-valued, or is outside the range supported by T.\n\nExamples\n\njulia> convert(Int, 3.0)\n3\n\njulia> convert(Int, 3.5)\nERROR: InexactError: Int64(3.5)\nStacktrace:\n[...]\n\nIf T is a AbstractFloat or Rational type, then it will return the closest value to x representable by T.\n\njulia> x = 1/3\n0.3333333333333333\n\njulia> convert(Float32, x)\n0.33333334f0\n\njulia> convert(Rational{Int32}, x)\n1//3\n\njulia> convert(Rational{Int64}, x)\n6004799503160661//18014398509481984\n\nIf T is a collection type and x a collection, the result of convert(T, x) may alias all or part of x.\n\njulia> x = Int[1, 2, 3];\n\njulia> y = convert(Vector{Int}, x);\n\njulia> y === x\ntrue\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.promote",
    "page": "Essentials",
    "title": "Base.promote",
    "category": "function",
    "text": "promote(xs...)\n\nConvert all arguments to a common type, and return them all (as a tuple). If no arguments can be converted, an error is raised.\n\nExamples\n\njulia> promote(Int8(1), Float16(4.5), Float32(4.1))\n(1.0f0, 4.5f0, 4.1f0)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.oftype",
    "page": "Essentials",
    "title": "Base.oftype",
    "category": "function",
    "text": "oftype(x, y)\n\nConvert y to the type of x (convert(typeof(x), y)).\n\nExamples\n\njulia> x = 4;\n\njulia> y = 3.;\n\njulia> oftype(x, y)\n3\n\njulia> oftype(y, x)\n4.0\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.widen",
    "page": "Essentials",
    "title": "Base.widen",
    "category": "function",
    "text": "widen(x)\n\nIf x is a type, return a \"larger\" type, defined so that arithmetic operations + and - are guaranteed not to overflow nor lose precision for any combination of values that type x can hold.\n\nFor fixed-size integer types less than 128 bits, widen will return a type with twice the number of bits.\n\nIf x is a value, it is converted to widen(typeof(x)).\n\nExamples\n\njulia> widen(Int32)\nInt64\n\njulia> widen(1.5f0)\n1.5\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.identity",
    "page": "Essentials",
    "title": "Base.identity",
    "category": "function",
    "text": "identity(x)\n\nThe identity function. Returns its argument.\n\nExamples\n\njulia> identity(\"Well, what did you expect?\")\n\"Well, what did you expect?\"\n\n\n\n\n\n"
},

{
    "location": "base/base.html#All-Objects-1",
    "page": "Essentials",
    "title": "All Objects",
    "category": "section",
    "text": "Core.:(===)\nCore.isa\nBase.isequal\nBase.isless\nBase.ifelse\nCore.typeassert\nCore.typeof\nCore.tuple\nBase.ntuple\nBase.objectid\nBase.hash\nBase.finalizer\nBase.finalize\nBase.copy\nBase.deepcopy\nBase.getproperty\nBase.setproperty!\nBase.propertynames\nCore.getfield\nCore.setfield!\nCore.isdefined\nBase.@isdefined\nBase.convert\nBase.promote\nBase.oftype\nBase.widen\nBase.identity"
},

{
    "location": "base/base.html#Properties-of-Types-1",
    "page": "Essentials",
    "title": "Properties of Types",
    "category": "section",
    "text": ""
},

{
    "location": "base/base.html#Base.supertype",
    "page": "Essentials",
    "title": "Base.supertype",
    "category": "function",
    "text": "supertype(T::DataType)\n\nReturn the supertype of DataType T.\n\nExamples\n\njulia> supertype(Int32)\nSigned\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.:<:",
    "page": "Essentials",
    "title": "Core.:<:",
    "category": "function",
    "text": "<:(T1, T2)\n\nSubtype operator: returns true if and only if all values of type T1 are also of type T2.\n\nExamples\n\njulia> Float64 <: AbstractFloat\ntrue\n\njulia> Vector{Int} <: AbstractArray\ntrue\n\njulia> Matrix{Float64} <: Matrix{AbstractFloat}\nfalse\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.:>:",
    "page": "Essentials",
    "title": "Base.:>:",
    "category": "function",
    "text": ">:(T1, T2)\n\nSupertype operator, equivalent to T2 <: T1.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.typejoin",
    "page": "Essentials",
    "title": "Base.typejoin",
    "category": "function",
    "text": "typejoin(T, S)\n\nReturn the closest common ancestor of T and S, i.e. the narrowest type from which they both inherit.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.typeintersect",
    "page": "Essentials",
    "title": "Base.typeintersect",
    "category": "function",
    "text": "typeintersect(T, S)\n\nCompute a type that contains the intersection of T and S. Usually this will be the smallest such type or one close to it.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.promote_type",
    "page": "Essentials",
    "title": "Base.promote_type",
    "category": "function",
    "text": "promote_type(type1, type2)\n\nPromotion refers to converting values of mixed types to a single common type. promote_type represents the default promotion behavior in Julia when operators (usually mathematical) are given arguments of differing types. promote_type generally tries to return a type which can at least approximate most values of either input type without excessively widening.  Some loss is tolerated; for example, promote_type(Int64, Float64) returns Float64 even though strictly, not all Int64 values can be represented exactly as Float64 values.\n\njulia> promote_type(Int64, Float64)\nFloat64\n\njulia> promote_type(Int32, Int64)\nInt64\n\njulia> promote_type(Float32, BigInt)\nBigFloat\n\njulia> promote_type(Int16, Float16)\nFloat16\n\njulia> promote_type(Int64, Float16)\nFloat16\n\njulia> promote_type(Int8, UInt16)\nUInt16\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.promote_rule",
    "page": "Essentials",
    "title": "Base.promote_rule",
    "category": "function",
    "text": "promote_rule(type1, type2)\n\nSpecifies what type should be used by promote when given values of types type1 and type2. This function should not be called directly, but should have definitions added to it for new types as appropriate.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isdispatchtuple",
    "page": "Essentials",
    "title": "Base.isdispatchtuple",
    "category": "function",
    "text": "isdispatchtuple(T)\n\nDetermine whether type T is a tuple \"leaf type\", meaning it could appear as a type signature in dispatch and has no subtypes (or supertypes) which could appear in a call.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Type-relations-1",
    "page": "Essentials",
    "title": "Type relations",
    "category": "section",
    "text": "Base.supertype\nCore.:(<:)\nBase.:(>:)\nBase.typejoin\nBase.typeintersect\nBase.promote_type\nBase.promote_rule\nBase.isdispatchtuple"
},

{
    "location": "base/base.html#Base.isimmutable",
    "page": "Essentials",
    "title": "Base.isimmutable",
    "category": "function",
    "text": "isimmutable(v) -> Bool\n\nReturn true iff value v is immutable.  See Mutable Composite Types for a discussion of immutability. Note that this function works on values, so if you give it a type, it will tell you that a value of DataType is mutable.\n\nExamples\n\njulia> isimmutable(1)\ntrue\n\njulia> isimmutable([1,2])\nfalse\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isabstracttype",
    "page": "Essentials",
    "title": "Base.isabstracttype",
    "category": "function",
    "text": "Base.isabstracttype(T)\n\nDetermine whether type T was declared as an abstract type (i.e. using the abstract keyword).\n\nExamples\n\njulia> Base.isabstracttype(AbstractArray)\ntrue\n\njulia> Base.isabstracttype(Vector)\nfalse\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isprimitivetype",
    "page": "Essentials",
    "title": "Base.isprimitivetype",
    "category": "function",
    "text": "Base.isprimitivetype(T) -> Bool\n\nDetermine whether type T was declared as a primitive type (i.e. using the primitive keyword).\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isstructtype",
    "page": "Essentials",
    "title": "Base.isstructtype",
    "category": "function",
    "text": "Base.isstructtype(T) -> Bool\n\nDetermine whether type T was declared as a struct type (i.e. using the struct or mutable struct keyword).\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.nameof-Tuple{DataType}",
    "page": "Essentials",
    "title": "Base.nameof",
    "category": "method",
    "text": "nameof(t::DataType) -> Symbol\n\nGet the name of a (potentially UnionAll-wrapped) DataType (without its parent module) as a symbol.\n\nExamples\n\njulia> module Foo\n           struct S{T}\n           end\n       end\nFoo\n\njulia> nameof(Foo.S{T} where T)\n:S\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.fieldnames",
    "page": "Essentials",
    "title": "Base.fieldnames",
    "category": "function",
    "text": "fieldnames(x::DataType)\n\nGet a tuple with the names of the fields of a DataType.\n\nExamples\n\njulia> fieldnames(Rational)\n(:num, :den)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.fieldname",
    "page": "Essentials",
    "title": "Base.fieldname",
    "category": "function",
    "text": "fieldname(x::DataType, i::Integer)\n\nGet the name of field i of a DataType.\n\nExamples\n\njulia> fieldname(Rational, 1)\n:num\n\njulia> fieldname(Rational, 2)\n:den\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Declared-structure-1",
    "page": "Essentials",
    "title": "Declared structure",
    "category": "section",
    "text": "Base.isimmutable\nBase.isabstracttype\nBase.isprimitivetype\nBase.isstructtype\nBase.nameof(::DataType)\nBase.fieldnames\nBase.fieldname"
},

{
    "location": "base/base.html#Base.sizeof-Tuple{Type}",
    "page": "Essentials",
    "title": "Base.sizeof",
    "category": "method",
    "text": "sizeof(T::DataType)\nsizeof(obj)\n\nSize, in bytes, of the canonical binary representation of the given DataType T, if any. Size, in bytes, of object obj if it is not DataType.\n\nExamples\n\njulia> sizeof(Float32)\n4\n\njulia> sizeof(ComplexF64)\n16\n\njulia> sizeof(1.0)\n8\n\njulia> sizeof([1.0:10.0;])\n80\n\nIf DataType T does not have a specific size, an error is thrown.\n\njulia> sizeof(AbstractArray)\nERROR: argument is an abstract type; size is indeterminate\nStacktrace:\n[...]\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isconcretetype",
    "page": "Essentials",
    "title": "Base.isconcretetype",
    "category": "function",
    "text": "isconcretetype(T)\n\nDetermine whether type T is a concrete type, meaning it could have direct instances (values x such that typeof(x) === T).\n\nExamples\n\njulia> isconcretetype(Complex)\nfalse\n\njulia> isconcretetype(Complex{Float32})\ntrue\n\njulia> isconcretetype(Vector{Complex})\ntrue\n\njulia> isconcretetype(Vector{Complex{Float32}})\ntrue\n\njulia> isconcretetype(Union{})\nfalse\n\njulia> isconcretetype(Union{Int,String})\nfalse\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isbits",
    "page": "Essentials",
    "title": "Base.isbits",
    "category": "function",
    "text": "isbits(x)\n\nReturn true if x is an instance of an isbitstype type.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isbitstype",
    "page": "Essentials",
    "title": "Base.isbitstype",
    "category": "function",
    "text": "isbitstype(T)\n\nReturn true if type T is a \"plain data\" type, meaning it is immutable and contains no references to other values, only primitive types and other isbitstype types. Typical examples are numeric types such as UInt8, Float64, and Complex{Float64}. This category of types is significant since they are valid as type parameters, may not track isdefined / isassigned status, and have a defined layout that is compatible with C.\n\nExamples\n\njulia> isbitstype(Complex{Float64})\ntrue\n\njulia> isbitstype(Complex)\nfalse\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.fieldtype",
    "page": "Essentials",
    "title": "Core.fieldtype",
    "category": "function",
    "text": "fieldtype(T, name::Symbol | index::Int)\n\nDetermine the declared type of a field (specified by name or index) in a composite DataType T.\n\nExamples\n\njulia> struct Foo\n           x::Int64\n           y::String\n       end\n\njulia> fieldtype(Foo, :x)\nInt64\n\njulia> fieldtype(Foo, 2)\nString\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.fieldtypes",
    "page": "Essentials",
    "title": "Base.fieldtypes",
    "category": "function",
    "text": "fieldtypes(T::Type)\n\nThe declared types of all fields in a composite DataType T as a tuple.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\nExamples\n\njulia> struct Foo\n           x::Int64\n           y::String\n       end\n\njulia> fieldtypes(Foo)\n(Int64, String)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.fieldcount",
    "page": "Essentials",
    "title": "Base.fieldcount",
    "category": "function",
    "text": "fieldcount(t::Type)\n\nGet the number of fields that an instance of the given type would have. An error is thrown if the type is too abstract to determine this.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.fieldoffset",
    "page": "Essentials",
    "title": "Base.fieldoffset",
    "category": "function",
    "text": "fieldoffset(type, i)\n\nThe byte offset of field i of a type relative to the data start. For example, we could use it in the following manner to summarize information about a struct:\n\njulia> structinfo(T) = [(fieldoffset(T,i), fieldname(T,i), fieldtype(T,i)) for i = 1:fieldcount(T)];\n\njulia> structinfo(Base.Filesystem.StatStruct)\n12-element Array{Tuple{UInt64,Symbol,DataType},1}:\n (0x0000000000000000, :device, UInt64)\n (0x0000000000000008, :inode, UInt64)\n (0x0000000000000010, :mode, UInt64)\n (0x0000000000000018, :nlink, Int64)\n (0x0000000000000020, :uid, UInt64)\n (0x0000000000000028, :gid, UInt64)\n (0x0000000000000030, :rdev, UInt64)\n (0x0000000000000038, :size, Int64)\n (0x0000000000000040, :blksize, Int64)\n (0x0000000000000048, :blocks, Int64)\n (0x0000000000000050, :mtime, Float64)\n (0x0000000000000058, :ctime, Float64)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.datatype_alignment",
    "page": "Essentials",
    "title": "Base.datatype_alignment",
    "category": "function",
    "text": "Base.datatype_alignment(dt::DataType) -> Int\n\nMemory allocation minimum alignment for instances of this type. Can be called on any isconcretetype.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.datatype_haspadding",
    "page": "Essentials",
    "title": "Base.datatype_haspadding",
    "category": "function",
    "text": "Base.datatype_haspadding(dt::DataType) -> Bool\n\nReturn whether the fields of instances of this type are packed in memory, with no intervening padding bytes. Can be called on any isconcretetype.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.datatype_pointerfree",
    "page": "Essentials",
    "title": "Base.datatype_pointerfree",
    "category": "function",
    "text": "Base.datatype_pointerfree(dt::DataType) -> Bool\n\nReturn whether instances of this type can contain references to gc-managed memory. Can be called on any isconcretetype.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Memory-layout-1",
    "page": "Essentials",
    "title": "Memory layout",
    "category": "section",
    "text": "Base.sizeof(::Type)\nBase.isconcretetype\nBase.isbits\nBase.isbitstype\nCore.fieldtype\nBase.fieldtypes\nBase.fieldcount\nBase.fieldoffset\nBase.datatype_alignment\nBase.datatype_haspadding\nBase.datatype_pointerfree"
},

{
    "location": "base/base.html#Base.typemin",
    "page": "Essentials",
    "title": "Base.typemin",
    "category": "function",
    "text": "typemin(T)\n\nThe lowest value representable by the given (real) numeric DataType T.\n\nExamples\n\njulia> typemin(Float16)\n-Inf16\n\njulia> typemin(Float32)\n-Inf32\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.typemax",
    "page": "Essentials",
    "title": "Base.typemax",
    "category": "function",
    "text": "typemax(T)\n\nThe highest value representable by the given (real) numeric DataType.\n\nExamples\n\njulia> typemax(Int8)\n127\n\njulia> typemax(UInt32)\n0xffffffff\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.floatmin",
    "page": "Essentials",
    "title": "Base.floatmin",
    "category": "function",
    "text": "floatmin(T)\n\nThe smallest in absolute value non-subnormal value representable by the given floating-point DataType T.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.floatmax",
    "page": "Essentials",
    "title": "Base.floatmax",
    "category": "function",
    "text": "floatmax(T)\n\nThe highest finite value representable by the given floating-point DataType T.\n\nExamples\n\njulia> floatmax(Float16)\nFloat16(6.55e4)\n\njulia> floatmax(Float32)\n3.4028235f38\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.maxintfloat",
    "page": "Essentials",
    "title": "Base.maxintfloat",
    "category": "function",
    "text": "maxintfloat(T=Float64)\n\nThe largest consecutive integer-valued floating-point number that is exactly represented in the given floating-point type T (which defaults to Float64).\n\nThat is, maxintfloat returns the smallest positive integer-valued floating-point number n such that n+1 is not exactly representable in the type T.\n\nWhen an Integer-type value is needed, use Integer(maxintfloat(T)).\n\n\n\n\n\nmaxintfloat(T, S)\n\nThe largest consecutive integer representable in the given floating-point type T that also does not exceed the maximum integer representable by the integer type S.  Equivalently, it is the minimum of maxintfloat(T) and typemax(S).\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.eps-Tuple{Type{#s36} where #s36<:AbstractFloat}",
    "page": "Essentials",
    "title": "Base.eps",
    "category": "method",
    "text": "eps(::Type{T}) where T<:AbstractFloat\neps()\n\nReturn the machine epsilon of the floating point type T (T = Float64 by default). This is defined as the gap between 1 and the next largest value representable by typeof(one(T)), and is equivalent to eps(one(T)).  (Since eps(T) is a bound on the relative error of T, it is a \"dimensionless\" quantity like one.)\n\nExamples\n\njulia> eps()\n2.220446049250313e-16\n\njulia> eps(Float32)\n1.1920929f-7\n\njulia> 1.0 + eps()\n1.0000000000000002\n\njulia> 1.0 + eps()/2\n1.0\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.eps-Tuple{AbstractFloat}",
    "page": "Essentials",
    "title": "Base.eps",
    "category": "method",
    "text": "eps(x::AbstractFloat)\n\nReturn the unit in last place (ulp) of x. This is the distance between consecutive representable floating point values at x. In most cases, if the distance on either side of x is different, then the larger of the two is taken, that is\n\neps(x) == max(x-prevfloat(x), nextfloat(x)-x)\n\nThe exceptions to this rule are the smallest and largest finite values (e.g. nextfloat(-Inf) and prevfloat(Inf) for Float64), which round to the smaller of the values.\n\nThe rationale for this behavior is that eps bounds the floating point rounding error. Under the default RoundNearest rounding mode, if y is a real number and x is the nearest floating point number to y, then\n\ny-x leq operatornameeps(x)2\n\nExamples\n\njulia> eps(1.0)\n2.220446049250313e-16\n\njulia> eps(prevfloat(2.0))\n2.220446049250313e-16\n\njulia> eps(2.0)\n4.440892098500626e-16\n\njulia> x = prevfloat(Inf)      # largest finite Float64\n1.7976931348623157e308\n\njulia> x + eps(x)/2            # rounds up\nInf\n\njulia> x + prevfloat(eps(x)/2) # rounds down\n1.7976931348623157e308\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.instances",
    "page": "Essentials",
    "title": "Base.instances",
    "category": "function",
    "text": "instances(T::Type)\n\nReturn a collection of all instances of the given type, if applicable. Mostly used for enumerated types (see @enum).\n\nExample\n\njulia> @enum Color red blue green\n\njulia> instances(Color)\n(red::Color = 0, blue::Color = 1, green::Color = 2)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Special-values-1",
    "page": "Essentials",
    "title": "Special values",
    "category": "section",
    "text": "Base.typemin\nBase.typemax\nBase.floatmin\nBase.floatmax\nBase.maxintfloat\nBase.eps(::Type{<:AbstractFloat})\nBase.eps(::AbstractFloat)\nBase.instances"
},

{
    "location": "base/base.html#Core.Any",
    "page": "Essentials",
    "title": "Core.Any",
    "category": "type",
    "text": "Any::DataType\n\nAny is the union of all types. It has the defining property isa(x, Any) == true for any x. Any therefore describes the entire universe of possible values. For example Integer is a subset of Any that includes Int, Int8, and other integer types.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.Union",
    "page": "Essentials",
    "title": "Core.Union",
    "category": "type",
    "text": "Union{Types...}\n\nA type union is an abstract type which includes all instances of any of its argument types. The empty union Union{} is the bottom type of Julia.\n\nExamples\n\njulia> IntOrString = Union{Int,AbstractString}\nUnion{Int64, AbstractString}\n\njulia> 1 :: IntOrString\n1\n\njulia> \"Hello!\" :: IntOrString\n\"Hello!\"\n\njulia> 1.0 :: IntOrString\nERROR: TypeError: in typeassert, expected Union{Int64, AbstractString}, got Float64\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Union{}",
    "page": "Essentials",
    "title": "Union{}",
    "category": "keyword",
    "text": "Union{}\n\nUnion{}, the empty Union of types, is the type that has no values. That is, it has the defining property isa(x, Union{}) == false for any x. Base.Bottom is defined as its alias and the type of Union{} is Core.TypeofBottom.\n\nExamples\n\njulia> isa(nothing, Union{})\nfalse\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.UnionAll",
    "page": "Essentials",
    "title": "Core.UnionAll",
    "category": "type",
    "text": "UnionAll\n\nA union of types over all values of a type parameter. UnionAll is used to describe parametric types where the values of some parameters are not known.\n\nExamples\n\njulia> typeof(Vector)\nUnionAll\n\njulia> typeof(Vector{Int})\nDataType\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.Tuple",
    "page": "Essentials",
    "title": "Core.Tuple",
    "category": "type",
    "text": "Tuple{Types...}\n\nTuples are an abstraction of the arguments of a function – without the function itself. The salient aspects of a function\'s arguments are their order and their types. Therefore a tuple type is similar to a parameterized immutable type where each parameter is the type of one field. Tuple types may have any number of parameters.\n\nTuple types are covariant in their parameters: Tuple{Int} is a subtype of Tuple{Any}. Therefore Tuple{Any} is considered an abstract type, and tuple types are only concrete if their parameters are. Tuples do not have field names; fields are only accessed by index.\n\nSee the manual section on Tuple Types.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.NamedTuple",
    "page": "Essentials",
    "title": "Core.NamedTuple",
    "category": "type",
    "text": "NamedTuple\n\nNamedTuples are, as their name suggests, named Tuples. That is, they\'re a tuple-like collection of values, where each entry has a unique name, represented as a Symbol. Like Tuples, NamedTuples are immutable; neither the names nor the values can be modified in place after construction.\n\nAccessing the value associated with a name in a named tuple can be done using field access syntax, e.g. x.a, or using getindex, e.g. x[:a]. A tuple of the names can be obtained using keys, and a tuple of the values can be obtained using values.\n\nnote: Note\nIteration over NamedTuples produces the values without the names. (See example below.) To iterate over the name-value pairs, use the pairs function.\n\nExamples\n\njulia> x = (a=1, b=2)\n(a = 1, b = 2)\n\njulia> x.a\n1\n\njulia> x[:a]\n1\n\njulia> keys(x)\n(:a, :b)\n\njulia> values(x)\n(1, 2)\n\njulia> collect(x)\n2-element Array{Int64,1}:\n 1\n 2\n\njulia> collect(pairs(x))\n2-element Array{Pair{Symbol,Int64},1}:\n :a => 1\n :b => 2\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Val",
    "page": "Essentials",
    "title": "Base.Val",
    "category": "type",
    "text": "Val(c)\n\nReturn Val{c}(), which contains no run-time data. Types like this can be used to pass the information between functions through the value c, which must be an isbits value. The intent of this construct is to be able to dispatch on constants directly (at compile time) without having to test the value of the constant at run time.\n\nExamples\n\njulia> f(::Val{true}) = \"Good\"\nf (generic function with 1 method)\n\njulia> f(::Val{false}) = \"Bad\"\nf (generic function with 2 methods)\n\njulia> f(Val(true))\n\"Good\"\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.Vararg",
    "page": "Essentials",
    "title": "Core.Vararg",
    "category": "type",
    "text": "Vararg{T,N}\n\nThe last parameter of a tuple type Tuple can be the special type Vararg, which denotes any number of trailing elements. The type Vararg{T,N} corresponds to exactly N elements of type T. Vararg{T} corresponds to zero or more elements of type T. Vararg tuple types are used to represent the arguments accepted by varargs methods (see the section on Varargs Functions in the manual.)\n\nExamples\n\njulia> mytupletype = Tuple{AbstractString,Vararg{Int}}\nTuple{AbstractString,Vararg{Int64,N} where N}\n\njulia> isa((\"1\",), mytupletype)\ntrue\n\njulia> isa((\"1\",1), mytupletype)\ntrue\n\njulia> isa((\"1\",1,2), mytupletype)\ntrue\n\njulia> isa((\"1\",1,2,3.0), mytupletype)\nfalse\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.Nothing",
    "page": "Essentials",
    "title": "Core.Nothing",
    "category": "type",
    "text": "Nothing\n\nA type with no fields that is the type of nothing.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.isnothing",
    "page": "Essentials",
    "title": "Base.isnothing",
    "category": "function",
    "text": "isnothing(x)\n\nReturn true if x === nothing, and return false if not.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Some",
    "page": "Essentials",
    "title": "Base.Some",
    "category": "type",
    "text": "Some{T}\n\nA wrapper type used in Union{Some{T}, Nothing} to distinguish between the absence of a value (nothing) and the presence of a nothing value (i.e. Some(nothing)).\n\nUse something to access the value wrapped by a Some object.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.something",
    "page": "Essentials",
    "title": "Base.something",
    "category": "function",
    "text": "something(x, y...)\n\nReturn the first value in the arguments which is not equal to nothing, if any. Otherwise throw an error. Arguments of type Some are unwrapped.\n\nExamples\n\njulia> something(nothing, 1)\n1\n\njulia> something(Some(1), nothing)\n1\n\njulia> something(missing, nothing)\nmissing\n\njulia> something(nothing, nothing)\nERROR: ArgumentError: No value arguments present\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Enums.@enum",
    "page": "Essentials",
    "title": "Base.Enums.@enum",
    "category": "macro",
    "text": "@enum EnumName[::BaseType] value1[=x] value2[=y]\n\nCreate an Enum{BaseType} subtype with name EnumName and enum member values of value1 and value2 with optional assigned values of x and y, respectively. EnumName can be used just like other types and enum member values as regular values, such as\n\nExamples\n\njulia> @enum Fruit apple=1 orange=2 kiwi=3\n\njulia> f(x::Fruit) = \"I\'m a Fruit with value: $(Int(x))\"\nf (generic function with 1 method)\n\njulia> f(apple)\n\"I\'m a Fruit with value: 1\"\n\njulia> Fruit(1)\napple::Fruit = 1\n\nValues can also be specified inside a begin block, e.g.\n\n@enum EnumName begin\n    value1\n    value2\nend\n\nBaseType, which defaults to Int32, must be a primitive subtype of Integer. Member values can be converted between the enum type and BaseType. read and write perform these conversions automatically.\n\nTo list all the instances of an enum use instances, e.g.\n\njulia> instances(Fruit)\n(apple::Fruit = 1, orange::Fruit = 2, kiwi::Fruit = 3)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Special-Types-1",
    "page": "Essentials",
    "title": "Special Types",
    "category": "section",
    "text": "Core.Any\nCore.Union\nUnion{}\nCore.UnionAll\nCore.Tuple\nCore.NamedTuple\nBase.Val\nCore.Vararg\nCore.Nothing\nBase.isnothing\nBase.Some\nBase.something\nBase.Enums.@enum"
},

{
    "location": "base/base.html#Core.Function",
    "page": "Essentials",
    "title": "Core.Function",
    "category": "type",
    "text": "Function\n\nAbstract type of all functions.\n\njulia> isa(+, Function)\ntrue\n\njulia> typeof(sin)\ntypeof(sin)\n\njulia> ans <: Function\ntrue\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.hasmethod",
    "page": "Essentials",
    "title": "Base.hasmethod",
    "category": "function",
    "text": "hasmethod(f, Tuple type; world = typemax(UInt)) -> Bool\n\nDetermine whether the given generic function has a method matching the given Tuple of argument types with the upper bound of world age given by world.\n\nSee also applicable.\n\nExamples\n\njulia> hasmethod(length, Tuple{Array})\ntrue\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.applicable",
    "page": "Essentials",
    "title": "Core.applicable",
    "category": "function",
    "text": "applicable(f, args...) -> Bool\n\nDetermine whether the given generic function has a method applicable to the given arguments.\n\nSee also hasmethod.\n\nExamples\n\njulia> function f(x, y)\n           x + y\n       end;\n\njulia> applicable(f, 1)\nfalse\n\njulia> applicable(f, 1, 2)\ntrue\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.invoke",
    "page": "Essentials",
    "title": "Core.invoke",
    "category": "function",
    "text": "invoke(f, argtypes::Type, args...; kwargs...)\n\nInvoke a method for the given generic function f matching the specified types argtypes on the specified arguments args and passing the keyword arguments kwargs. The arguments args must conform with the specified types in argtypes, i.e. conversion is not automatically performed. This method allows invoking a method other than the most specific matching method, which is useful when the behavior of a more general definition is explicitly needed (often as part of the implementation of a more specific method of the same function).\n\nExamples\n\njulia> f(x::Real) = x^2;\n\njulia> f(x::Integer) = 1 + invoke(f, Tuple{Real}, x);\n\njulia> f(2)\n5\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.invokelatest",
    "page": "Essentials",
    "title": "Base.invokelatest",
    "category": "function",
    "text": "invokelatest(f, args...; kwargs...)\n\nCalls f(args...; kwargs...), but guarantees that the most recent method of f will be executed.   This is useful in specialized circumstances, e.g. long-running event loops or callback functions that may call obsolete versions of a function f. (The drawback is that invokelatest is somewhat slower than calling f directly, and the type of the result cannot be inferred by the compiler.)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#new",
    "page": "Essentials",
    "title": "new",
    "category": "keyword",
    "text": "new\n\nSpecial function available to inner constructors which created a new object of the type. See the manual section on Inner Constructor Methods for more information.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.:|>",
    "page": "Essentials",
    "title": "Base.:|>",
    "category": "function",
    "text": "|>(x, f)\n\nApplies a function to the preceding argument. This allows for easy function chaining.\n\nExamples\n\njulia> [1:5;] |> x->x.^2 |> sum |> inv\n0.01818181818181818\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.:∘",
    "page": "Essentials",
    "title": "Base.:∘",
    "category": "function",
    "text": "f ∘ g\n\nCompose functions: i.e. (f ∘ g)(args...) means f(g(args...)). The ∘ symbol can be entered in the Julia REPL (and most editors, appropriately configured) by typing \\circ<tab>.\n\nExamples\n\njulia> map(uppercase∘first, [\"apple\", \"banana\", \"carrot\"])\n3-element Array{Char,1}:\n \'A\'\n \'B\'\n \'C\'\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Generic-Functions-1",
    "page": "Essentials",
    "title": "Generic Functions",
    "category": "section",
    "text": "Core.Function\nBase.hasmethod\nCore.applicable\nCore.invoke\nBase.invokelatest\nnew\nBase.:(|>)\nBase.:(∘)"
},

{
    "location": "base/base.html#Core.eval",
    "page": "Essentials",
    "title": "Core.eval",
    "category": "function",
    "text": "Core.eval(m::Module, expr)\n\nEvaluate an expression in the given module and return the result.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.MainInclude.eval",
    "page": "Essentials",
    "title": "Base.MainInclude.eval",
    "category": "function",
    "text": "eval(expr)\n\nEvaluate an expression in the global scope of the containing module. Every Module (except those defined with baremodule) has its own 1-argument definition of eval, which evaluates expressions in that module.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@eval",
    "page": "Essentials",
    "title": "Base.@eval",
    "category": "macro",
    "text": "@eval [mod,] ex\n\nEvaluate an expression with values interpolated into it using eval. If two arguments are provided, the first is the module to evaluate in.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.evalfile",
    "page": "Essentials",
    "title": "Base.evalfile",
    "category": "function",
    "text": "evalfile(path::AbstractString, args::Vector{String}=String[])\n\nLoad the file using Base.include, evaluate all expressions, and return the value of the last one.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.esc",
    "page": "Essentials",
    "title": "Base.esc",
    "category": "function",
    "text": "esc(e)\n\nOnly valid in the context of an Expr returned from a macro. Prevents the macro hygiene pass from turning embedded variables into gensym variables. See the Macros section of the Metaprogramming chapter of the manual for more details and examples.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@inbounds",
    "page": "Essentials",
    "title": "Base.@inbounds",
    "category": "macro",
    "text": "@inbounds(blk)\n\nEliminates array bounds checking within expressions.\n\nIn the example below the in-range check for referencing element i of array A is skipped to improve performance.\n\nfunction sum(A::AbstractArray)\n    r = zero(eltype(A))\n    for i = 1:length(A)\n        @inbounds r += A[i]\n    end\n    return r\nend\n\nwarning: Warning\nUsing @inbounds may return incorrect results/crashes/corruption for out-of-bounds indices. The user is responsible for checking it manually. Only use @inbounds when it is certain from the information locally available that all accesses are in bounds.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@boundscheck",
    "page": "Essentials",
    "title": "Base.@boundscheck",
    "category": "macro",
    "text": "@boundscheck(blk)\n\nAnnotates the expression blk as a bounds checking block, allowing it to be elided by @inbounds.\n\nnote: Note\nThe function in which @boundscheck is written must be inlined into its caller in order for @inbounds to have effect.\n\nExamples\n\njulia> @inline function g(A, i)\n           @boundscheck checkbounds(A, i)\n           return \"accessing ($A)[$i]\"\n       end;\n\njulia> f1() = return g(1:2, -1);\n\njulia> f2() = @inbounds return g(1:2, -1);\n\njulia> f1()\nERROR: BoundsError: attempt to access 2-element UnitRange{Int64} at index [-1]\nStacktrace:\n [1] throw_boundserror(::UnitRange{Int64}, ::Tuple{Int64}) at ./abstractarray.jl:455\n [2] checkbounds at ./abstractarray.jl:420 [inlined]\n [3] g at ./none:2 [inlined]\n [4] f1() at ./none:1\n [5] top-level scope\n\njulia> f2()\n\"accessing (1:2)[-1]\"\n\nwarning: Warning\nThe @boundscheck annotation allows you, as a library writer, to opt-in to allowing other code to remove your bounds checks with @inbounds. As noted there, the caller must verify—using information they can access—that their accesses are valid before using @inbounds. For indexing into your AbstractArray subclasses, for example, this involves checking the indices against its size. Therefore, @boundscheck annotations should only be added to a getindex or setindex! implementation after you are certain its behavior is correct.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@inline",
    "page": "Essentials",
    "title": "Base.@inline",
    "category": "macro",
    "text": "@inline\n\nGive a hint to the compiler that this function is worth inlining.\n\nSmall functions typically do not need the @inline annotation, as the compiler does it automatically. By using @inline on bigger functions, an extra nudge can be given to the compiler to inline it. This is shown in the following example:\n\n@inline function bigfunction(x)\n    #=\n        Function Definition\n    =#\nend\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@noinline",
    "page": "Essentials",
    "title": "Base.@noinline",
    "category": "macro",
    "text": "@noinline\n\nPrevents the compiler from inlining a function.\n\nSmall functions are typically inlined automatically. By using @noinline on small functions, auto-inlining can be prevented. This is shown in the following example:\n\n@noinline function smallfunction(x)\n    #=\n        Function Definition\n    =#\nend\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@nospecialize",
    "page": "Essentials",
    "title": "Base.@nospecialize",
    "category": "macro",
    "text": "@nospecialize\n\nApplied to a function argument name, hints to the compiler that the method should not be specialized for different types of that argument, but instead to use precisely the declared type for each argument. This is only a hint for avoiding excess code generation. Can be applied to an argument within a formal argument list, or in the function body. When applied to an argument, the macro must wrap the entire argument expression. When used in a function body, the macro must occur in statement position and before any code.\n\nWhen used without arguments, it applies to all arguments of the parent scope. In local scope, this means all arguments of the containing function. In global (top-level) scope, this means all methods subsequently defined in the current module.\n\nSpecialization can reset back to the default by using @specialize.\n\nfunction example_function(@nospecialize x)\n    ...\nend\n\nfunction example_function(@nospecialize(x = 1), y)\n    ...\nend\n\nfunction example_function(x, y, z)\n    @nospecialize x y\n    ...\nend\n\n@nospecialize\nf(y) = [x for x in y]\n@specialize\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@specialize",
    "page": "Essentials",
    "title": "Base.@specialize",
    "category": "macro",
    "text": "@specialize\n\nReset the specialization hint for an argument back to the default. For details, see @nospecialize.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.gensym",
    "page": "Essentials",
    "title": "Base.gensym",
    "category": "function",
    "text": "gensym([tag])\n\nGenerates a symbol which will not conflict with other variable names.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@gensym",
    "page": "Essentials",
    "title": "Base.@gensym",
    "category": "macro",
    "text": "@gensym\n\nGenerates a gensym symbol for a variable. For example, @gensym x y is transformed into x = gensym(\"x\"); y = gensym(\"y\").\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@goto",
    "page": "Essentials",
    "title": "Base.@goto",
    "category": "macro",
    "text": "@goto name\n\n@goto name unconditionally jumps to the statement at the location @label name.\n\n@label and @goto cannot create jumps to different top-level statements. Attempts cause an error. To still use @goto, enclose the @label and @goto in a block.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@label",
    "page": "Essentials",
    "title": "Base.@label",
    "category": "macro",
    "text": "@label name\n\nLabels a statement with the symbolic label name. The label marks the end-point of an unconditional jump with @goto name.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.SimdLoop.@simd",
    "page": "Essentials",
    "title": "Base.SimdLoop.@simd",
    "category": "macro",
    "text": "@simd\n\nAnnotate a for loop to allow the compiler to take extra liberties to allow loop re-ordering\n\nwarning: Warning\nThis feature is experimental and could change or disappear in future versions of Julia. Incorrect use of the @simd macro may cause unexpected results.\n\nThe object iterated over in a @simd for loop should be a one-dimensional range. By using @simd, you are asserting several properties of the loop:\n\nIt is safe to execute iterations in arbitrary or overlapping order, with special consideration for reduction variables.\nFloating-point operations on reduction variables can be reordered, possibly causing different results than without @simd.\n\nIn many cases, Julia is able to automatically vectorize inner for loops without the use of @simd. Using @simd gives the compiler a little extra leeway to make it possible in more situations. In either case, your inner loop should have the following properties to allow vectorization:\n\nThe loop must be an innermost loop\nThe loop body must be straight-line code. Therefore, @inbounds is   currently needed for all array accesses. The compiler can sometimes turn   short &&, ||, and ?: expressions into straight-line code if it is safe   to evaluate all operands unconditionally. Consider using the ifelse   function instead of ?: in the loop if it is safe to do so.\nAccesses must have a stride pattern and cannot be \"gathers\" (random-index   reads) or \"scatters\" (random-index writes).\nThe stride should be unit stride.\n\nnote: Note\nThe @simd does not assert by default that the loop is completely free of loop-carried memory dependencies, which is an assumption that can easily be violated in generic code. If you are writing non-generic code, you can use @simd ivdep for ... end to also assert that:\n\nThere exists no loop-carried memory dependencies\nNo iteration ever waits on a previous iteration to make forward progress.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@polly",
    "page": "Essentials",
    "title": "Base.@polly",
    "category": "macro",
    "text": "@polly\n\nTells the compiler to apply the polyhedral optimizer Polly to a function.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@generated",
    "page": "Essentials",
    "title": "Base.@generated",
    "category": "macro",
    "text": "@generated f\n@generated(f)\n\n@generated is used to annotate a function which will be generated. In the body of the generated function, only types of arguments can be read (not the values). The function returns a quoted expression evaluated when the function is called. The @generated macro should not be used on functions mutating the global scope or depending on mutable elements.\n\nSee Metaprogramming for further details.\n\nExample:\n\njulia> @generated function bar(x)\n           if x <: Integer\n               return :(x ^ 2)\n           else\n               return :(x)\n           end\n       end\nbar (generic function with 1 method)\n\njulia> bar(4)\n16\n\njulia> bar(\"baz\")\n\"baz\"\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@pure",
    "page": "Essentials",
    "title": "Base.@pure",
    "category": "macro",
    "text": "@pure ex\n@pure(ex)\n\n@pure gives the compiler a hint for the definition of a pure function, helping for type inference.\n\nA pure function can only depend on immutable information. This also means a @pure function cannot use any global mutable state, including generic functions. Calls to generic functions depend on method tables which are mutable global state. Use with caution, incorrect @pure annotation of a function may introduce hard to identify bugs. Double check for calls to generic functions.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Syntax-1",
    "page": "Essentials",
    "title": "Syntax",
    "category": "section",
    "text": "Core.eval\nBase.MainInclude.eval\nBase.@eval\nBase.evalfile\nBase.esc\nBase.@inbounds\nBase.@boundscheck\nBase.@inline\nBase.@noinline\nBase.@nospecialize\nBase.@specialize\nBase.gensym\nBase.@gensym\nBase.@goto\nBase.@label\nBase.@simd\nBase.@polly\nBase.@generated\nBase.@pure"
},

{
    "location": "base/base.html#Base.Missing",
    "page": "Essentials",
    "title": "Base.Missing",
    "category": "type",
    "text": "Missing\n\nA type with no fields whose singleton instance missing is used to represent missing values.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.missing",
    "page": "Essentials",
    "title": "Base.missing",
    "category": "constant",
    "text": "missing\n\nThe singleton instance of type Missing representing a missing value.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.coalesce",
    "page": "Essentials",
    "title": "Base.coalesce",
    "category": "function",
    "text": "coalesce(x, y...)\n\nReturn the first value in the arguments which is not equal to missing, if any. Otherwise return missing.\n\nExamples\n\njulia> coalesce(missing, 1)\n1\n\njulia> coalesce(1, missing)\n1\n\njulia> coalesce(nothing, 1)  # returns `nothing`\n\njulia> coalesce(missing, missing)\nmissing\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.ismissing",
    "page": "Essentials",
    "title": "Base.ismissing",
    "category": "function",
    "text": "ismissing(x)\n\nIndicate whether x is missing.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.skipmissing",
    "page": "Essentials",
    "title": "Base.skipmissing",
    "category": "function",
    "text": "skipmissing(itr)\n\nReturn an iterator over the elements in itr skipping missing values.\n\nUse collect to obtain an Array containing the non-missing values in itr. Note that even if itr is a multidimensional array, the result will always be a Vector since it is not possible to remove missings while preserving dimensions of the input.\n\nExamples\n\njulia> sum(skipmissing([1, missing, 2]))\n3\n\njulia> collect(skipmissing([1, missing, 2]))\n2-element Array{Int64,1}:\n 1\n 2\n\njulia> collect(skipmissing([1 missing; 2 missing]))\n2-element Array{Int64,1}:\n 1\n 2\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Missing-Values-1",
    "page": "Essentials",
    "title": "Missing Values",
    "category": "section",
    "text": "Base.Missing\nBase.missing\nBase.coalesce\nBase.ismissing\nBase.skipmissing"
},

{
    "location": "base/base.html#Base.run",
    "page": "Essentials",
    "title": "Base.run",
    "category": "function",
    "text": "run(command, args...; wait::Bool = true)\n\nRun a command object, constructed with backticks. Throws an error if anything goes wrong, including the process exiting with a non-zero status (when wait is true).\n\nIf wait is false, the process runs asynchronously. You can later wait for it and check its exit status by calling success on the returned process object.\n\nWhen wait is false, the process\' I/O streams are directed to devnull. When wait is true, I/O streams are shared with the parent process. Use pipeline to control I/O redirection.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.devnull",
    "page": "Essentials",
    "title": "Base.devnull",
    "category": "constant",
    "text": "devnull\n\nUsed in a stream redirect to discard all data written to it. Essentially equivalent to /dev/null on Unix or NUL on Windows. Usage:\n\nrun(pipeline(`cat test.txt`, devnull))\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.success",
    "page": "Essentials",
    "title": "Base.success",
    "category": "function",
    "text": "success(command)\n\nRun a command object, constructed with backticks, and tell whether it was successful (exited with a code of 0). An exception is raised if the process cannot be started.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.process_running",
    "page": "Essentials",
    "title": "Base.process_running",
    "category": "function",
    "text": "process_running(p::Process)\n\nDetermine whether a process is currently running.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.process_exited",
    "page": "Essentials",
    "title": "Base.process_exited",
    "category": "function",
    "text": "process_exited(p::Process)\n\nDetermine whether a process has exited.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.kill-Tuple{Base.Process,Integer}",
    "page": "Essentials",
    "title": "Base.kill",
    "category": "method",
    "text": "kill(p::Process, signum=SIGTERM)\n\nSend a signal to a process. The default is to terminate the process. Returns successfully if the process has already exited, but throws an error if killing the process failed for other reasons (e.g. insufficient permissions).\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.set_process_title",
    "page": "Essentials",
    "title": "Base.Sys.set_process_title",
    "category": "function",
    "text": "Sys.set_process_title(title::AbstractString)\n\nSet the process title. No-op on some operating systems.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.get_process_title",
    "page": "Essentials",
    "title": "Base.Sys.get_process_title",
    "category": "function",
    "text": "Sys.get_process_title()\n\nGet the process title. On some systems, will always return an empty string.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.ignorestatus",
    "page": "Essentials",
    "title": "Base.ignorestatus",
    "category": "function",
    "text": "ignorestatus(command)\n\nMark a command object so that running it will not throw an error if the result code is non-zero.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.detach",
    "page": "Essentials",
    "title": "Base.detach",
    "category": "function",
    "text": "detach(command)\n\nMark a command object so that it will be run in a new process group, allowing it to outlive the julia process, and not have Ctrl-C interrupts passed to it.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Cmd",
    "page": "Essentials",
    "title": "Base.Cmd",
    "category": "type",
    "text": "Cmd(cmd::Cmd; ignorestatus, detach, windows_verbatim, windows_hide, env, dir)\n\nConstruct a new Cmd object, representing an external program and arguments, from cmd, while changing the settings of the optional keyword arguments:\n\nignorestatus::Bool: If true (defaults to false), then the Cmd will not throw an error if the return code is nonzero.\ndetach::Bool: If true (defaults to false), then the Cmd will be run in a new process group, allowing it to outlive the julia process and not have Ctrl-C passed to it.\nwindows_verbatim::Bool: If true (defaults to false), then on Windows the Cmd will send a command-line string to the process with no quoting or escaping of arguments, even arguments containing spaces. (On Windows, arguments are sent to a program as a single \"command-line\" string, and programs are responsible for parsing it into arguments. By default, empty arguments and arguments with spaces or tabs are quoted with double quotes \" in the command line, and \\ or \" are preceded by backslashes. windows_verbatim=true is useful for launching programs that parse their command line in nonstandard ways.) Has no effect on non-Windows systems.\nwindows_hide::Bool: If true (defaults to false), then on Windows no new console window is displayed when the Cmd is executed. This has no effect if a console is already open or on non-Windows systems.\nenv: Set environment variables to use when running the Cmd. env is either a dictionary mapping strings to strings, an array of strings of the form \"var=val\", an array or tuple of \"var\"=>val pairs, or nothing. In order to modify (rather than replace) the existing environment, create env by copy(ENV) and then set env[\"var\"]=val as desired.\ndir::AbstractString: Specify a working directory for the command (instead of the current directory).\n\nFor any keywords that are not specified, the current settings from cmd are used. Normally, to create a Cmd object in the first place, one uses backticks, e.g.\n\nCmd(`echo \"Hello world\"`, ignorestatus=true, detach=false)\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.setenv",
    "page": "Essentials",
    "title": "Base.setenv",
    "category": "function",
    "text": "setenv(command::Cmd, env; dir=\"\")\n\nSet environment variables to use when running the given command. env is either a dictionary mapping strings to strings, an array of strings of the form \"var=val\", or zero or more \"var\"=>val pair arguments. In order to modify (rather than replace) the existing environment, create env by copy(ENV) and then setting env[\"var\"]=val as desired, or use withenv.\n\nThe dir keyword argument can be used to specify a working directory for the command.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.withenv",
    "page": "Essentials",
    "title": "Base.withenv",
    "category": "function",
    "text": "withenv(f::Function, kv::Pair...)\n\nExecute f in an environment that is temporarily modified (not replaced as in setenv) by zero or more \"var\"=>val arguments kv. withenv is generally used via the withenv(kv...) do ... end syntax. A value of nothing can be used to temporarily unset an environment variable (if it is set). When withenv returns, the original environment has been restored.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.pipeline-Tuple{Any,Any,Any,Vararg{Any,N} where N}",
    "page": "Essentials",
    "title": "Base.pipeline",
    "category": "method",
    "text": "pipeline(from, to, ...)\n\nCreate a pipeline from a data source to a destination. The source and destination can be commands, I/O streams, strings, or results of other pipeline calls. At least one argument must be a command. Strings refer to filenames. When called with more than two arguments, they are chained together from left to right. For example, pipeline(a,b,c) is equivalent to pipeline(pipeline(a,b),c). This provides a more concise way to specify multi-stage pipelines.\n\nExamples:\n\nrun(pipeline(`ls`, `grep xyz`))\nrun(pipeline(`ls`, \"out.txt\"))\nrun(pipeline(\"out.txt\", `grep xyz`))\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.pipeline-Tuple{Base.AbstractCmd}",
    "page": "Essentials",
    "title": "Base.pipeline",
    "category": "method",
    "text": "pipeline(command; stdin, stdout, stderr, append=false)\n\nRedirect I/O to or from the given command. Keyword arguments specify which of the command\'s streams should be redirected. append controls whether file output appends to the file. This is a more general version of the 2-argument pipeline function. pipeline(from, to) is equivalent to pipeline(from, stdout=to) when from is a command, and to pipeline(to, stdin=from) when from is another kind of data source.\n\nExamples:\n\nrun(pipeline(`dothings`, stdout=\"out.txt\", stderr=\"errs.txt\"))\nrun(pipeline(`update`, stdout=\"log.txt\", append=true))\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Libc.gethostname",
    "page": "Essentials",
    "title": "Base.Libc.gethostname",
    "category": "function",
    "text": "gethostname() -> AbstractString\n\nGet the local machine\'s host name.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Libc.getpid",
    "page": "Essentials",
    "title": "Base.Libc.getpid",
    "category": "function",
    "text": "getpid(process) -> Int32\n\nGet the child process ID, if it still exists.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\n\n\n\n\ngetpid() -> Int32\n\nGet Julia\'s process ID.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Libc.time-Tuple{}",
    "page": "Essentials",
    "title": "Base.Libc.time",
    "category": "method",
    "text": "time()\n\nGet the system time in seconds since the epoch, with fairly high (typically, microsecond) resolution.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.time_ns",
    "page": "Essentials",
    "title": "Base.time_ns",
    "category": "function",
    "text": "time_ns()\n\nGet the time in nanoseconds. The time corresponding to 0 is undefined, and wraps every 5.8 years.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@time",
    "page": "Essentials",
    "title": "Base.@time",
    "category": "macro",
    "text": "@time\n\nA macro to execute an expression, printing the time it took to execute, the number of allocations, and the total number of bytes its execution caused to be allocated, before returning the value of the expression.\n\nSee also @timev, @timed, @elapsed, and @allocated.\n\njulia> @time rand(10^6);\n  0.001525 seconds (7 allocations: 7.630 MiB)\n\njulia> @time begin\n           sleep(0.3)\n           1+1\n       end\n  0.301395 seconds (8 allocations: 336 bytes)\n2\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@timev",
    "page": "Essentials",
    "title": "Base.@timev",
    "category": "macro",
    "text": "@timev\n\nThis is a verbose version of the @time macro. It first prints the same information as @time, then any non-zero memory allocation counters, and then returns the value of the expression.\n\nSee also @time, @timed, @elapsed, and @allocated.\n\njulia> @timev rand(10^6);\n  0.001006 seconds (7 allocations: 7.630 MiB)\nelapsed time (ns): 1005567\nbytes allocated:   8000256\npool allocs:       6\nmalloc() calls:    1\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@timed",
    "page": "Essentials",
    "title": "Base.@timed",
    "category": "macro",
    "text": "@timed\n\nA macro to execute an expression, and return the value of the expression, elapsed time, total bytes allocated, garbage collection time, and an object with various memory allocation counters.\n\nSee also @time, @timev, @elapsed, and @allocated.\n\njulia> val, t, bytes, gctime, memallocs = @timed rand(10^6);\n\njulia> t\n0.006634834\n\njulia> bytes\n8000256\n\njulia> gctime\n0.0055765\n\njulia> fieldnames(typeof(memallocs))\n(:allocd, :malloc, :realloc, :poolalloc, :bigalloc, :freecall, :total_time, :pause, :full_sweep)\n\njulia> memallocs.total_time\n5576500\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@elapsed",
    "page": "Essentials",
    "title": "Base.@elapsed",
    "category": "macro",
    "text": "@elapsed\n\nA macro to evaluate an expression, discarding the resulting value, instead returning the number of seconds it took to execute as a floating-point number.\n\nSee also @time, @timev, @timed, and @allocated.\n\njulia> @elapsed sleep(0.3)\n0.301391426\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@allocated",
    "page": "Essentials",
    "title": "Base.@allocated",
    "category": "macro",
    "text": "@allocated\n\nA macro to evaluate an expression, discarding the resulting value, instead returning the total number of bytes allocated during evaluation of the expression. Note: the expression is evaluated inside a local function, instead of the current context, in order to eliminate the effects of compilation, however, there still may be some allocations due to JIT compilation. This also makes the results inconsistent with the @time macros, which do not try to adjust for the effects of compilation.\n\nSee also @time, @timev, @timed, and @elapsed.\n\njulia> @allocated rand(10^6)\n8000080\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.EnvDict",
    "page": "Essentials",
    "title": "Base.EnvDict",
    "category": "type",
    "text": "EnvDict() -> EnvDict\n\nA singleton of this type provides a hash table interface to environment variables.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.ENV",
    "page": "Essentials",
    "title": "Base.ENV",
    "category": "constant",
    "text": "ENV\n\nReference to the singleton EnvDict, providing a dictionary interface to system environment variables.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.isunix",
    "page": "Essentials",
    "title": "Base.Sys.isunix",
    "category": "function",
    "text": "Sys.isunix([os])\n\nPredicate for testing if the OS provides a Unix-like interface. See documentation in Handling Operating System Variation.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.isapple",
    "page": "Essentials",
    "title": "Base.Sys.isapple",
    "category": "function",
    "text": "Sys.isapple([os])\n\nPredicate for testing if the OS is a derivative of Apple Macintosh OS X or Darwin. See documentation in Handling Operating System Variation.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.islinux",
    "page": "Essentials",
    "title": "Base.Sys.islinux",
    "category": "function",
    "text": "Sys.islinux([os])\n\nPredicate for testing if the OS is a derivative of Linux. See documentation in Handling Operating System Variation.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.isbsd",
    "page": "Essentials",
    "title": "Base.Sys.isbsd",
    "category": "function",
    "text": "Sys.isbsd([os])\n\nPredicate for testing if the OS is a derivative of BSD. See documentation in Handling Operating System Variation.\n\nnote: Note\nThe Darwin kernel descends from BSD, which means that Sys.isbsd() is true on macOS systems. To exclude macOS from a predicate, use Sys.isbsd() && !Sys.isapple().\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.isfreebsd",
    "page": "Essentials",
    "title": "Base.Sys.isfreebsd",
    "category": "function",
    "text": "Sys.isfreebsd([os])\n\nPredicate for testing if the OS is a derivative of FreeBSD. See documentation in Handling Operating System Variation.\n\nnote: Note\nNot to be confused with Sys.isbsd(), which is true on FreeBSD but also on other BSD-based systems. Sys.isfreebsd() refers only to FreeBSD.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.isopenbsd",
    "page": "Essentials",
    "title": "Base.Sys.isopenbsd",
    "category": "function",
    "text": "Sys.isopenbsd([os])\n\nPredicate for testing if the OS is a derivative of OpenBSD. See documentation in Handling Operating System Variation.\n\nnote: Note\nNot to be confused with Sys.isbsd(), which is true on OpenBSD but also on other BSD-based systems. Sys.isopenbsd() refers only to OpenBSD.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.isnetbsd",
    "page": "Essentials",
    "title": "Base.Sys.isnetbsd",
    "category": "function",
    "text": "Sys.isnetbsd([os])\n\nPredicate for testing if the OS is a derivative of NetBSD. See documentation in Handling Operating System Variation.\n\nnote: Note\nNot to be confused with Sys.isbsd(), which is true on NetBSD but also on other BSD-based systems. Sys.isnetbsd() refers only to NetBSD.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.isdragonfly",
    "page": "Essentials",
    "title": "Base.Sys.isdragonfly",
    "category": "function",
    "text": "Sys.isdragonfly([os])\n\nPredicate for testing if the OS is a derivative of DragonFly BSD. See documentation in Handling Operating System Variation.\n\nnote: Note\nNot to be confused with Sys.isbsd(), which is true on DragonFly but also on other BSD-based systems. Sys.isdragonfly() refers only to DragonFly.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.iswindows",
    "page": "Essentials",
    "title": "Base.Sys.iswindows",
    "category": "function",
    "text": "Sys.iswindows([os])\n\nPredicate for testing if the OS is a derivative of Microsoft Windows NT. See documentation in Handling Operating System Variation.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.Sys.windows_version",
    "page": "Essentials",
    "title": "Base.Sys.windows_version",
    "category": "function",
    "text": "Sys.windows_version()\n\nReturn the version number for the Windows NT Kernel as a VersionNumber, i.e. v\"major.minor.build\", or v\"0.0.0\" if this is not running on Windows.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@static",
    "page": "Essentials",
    "title": "Base.@static",
    "category": "macro",
    "text": "@static\n\nPartially evaluate an expression at parse time.\n\nFor example, @static Sys.iswindows() ? foo : bar will evaluate Sys.iswindows() and insert either foo or bar into the expression. This is useful in cases where a construct would be invalid on other platforms, such as a ccall to a non-existent function. @static if Sys.isapple() foo end and @static foo <&&,||> bar are also valid syntax.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#System-1",
    "page": "Essentials",
    "title": "System",
    "category": "section",
    "text": "Base.run\nBase.devnull\nBase.success\nBase.process_running\nBase.process_exited\nBase.kill(::Base.Process, ::Integer)\nBase.Sys.set_process_title\nBase.Sys.get_process_title\nBase.ignorestatus\nBase.detach\nBase.Cmd\nBase.setenv\nBase.withenv\nBase.pipeline(::Any, ::Any, ::Any, ::Any...)\nBase.pipeline(::Base.AbstractCmd)\nBase.Libc.gethostname\nBase.Libc.getpid\nBase.Libc.time()\nBase.time_ns\nBase.@time\nBase.@timev\nBase.@timed\nBase.@elapsed\nBase.@allocated\nBase.EnvDict\nBase.ENV\nBase.Sys.isunix\nBase.Sys.isapple\nBase.Sys.islinux\nBase.Sys.isbsd\nBase.Sys.isfreebsd\nBase.Sys.isopenbsd\nBase.Sys.isnetbsd\nBase.Sys.isdragonfly\nBase.Sys.iswindows\nBase.Sys.windows_version\nBase.@static"
},

{
    "location": "base/base.html#Base.VersionNumber",
    "page": "Essentials",
    "title": "Base.VersionNumber",
    "category": "type",
    "text": "VersionNumber\n\nVersion number type which follow the specifications of semantic versioning, composed of major, minor and patch numeric values, followed by pre-release and build alpha-numeric annotations. See also @v_str.\n\nExamples\n\njulia> VersionNumber(\"1.2.3\")\nv\"1.2.3\"\n\njulia> VersionNumber(\"2.0.1-rc1\")\nv\"2.0.1-rc1\"\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.@v_str",
    "page": "Essentials",
    "title": "Base.@v_str",
    "category": "macro",
    "text": "@v_str\n\nString macro used to parse a string to a VersionNumber.\n\nExamples\n\njulia> v\"1.2.3\"\nv\"1.2.3\"\n\njulia> v\"2.0.1-rc1\"\nv\"2.0.1-rc1\"\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Versioning-1",
    "page": "Essentials",
    "title": "Versioning",
    "category": "section",
    "text": "Base.VersionNumber\nBase.@v_str"
},

{
    "location": "base/base.html#Base.error",
    "page": "Essentials",
    "title": "Base.error",
    "category": "function",
    "text": "error(message::AbstractString)\n\nRaise an ErrorException with the given message.\n\n\n\n\n\nerror(msg...)\n\nRaise an ErrorException with the given message.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Core.throw",
    "page": "Essentials",
    "title": "Core.throw",
    "category": "function",
    "text": "throw(e)\n\nThrow an object as an exception.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.rethrow",
    "page": "Essentials",
    "title": "Base.rethrow",
    "category": "function",
    "text": "rethrow([e])\n\nThrow an object without changing the current exception backtrace. The default argument is the current exception (if called within a catch block).\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.backtrace",
    "page": "Essentials",
    "title": "Base.backtrace",
    "category": "function",
    "text": "backtrace()\n\nGet a backtrace object for the current program point.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.catch_backtrace",
    "page": "Essentials",
    "title": "Base.catch_backtrace",
    "category": "function",
    "text": "catch_backtrace()\n\nGet the backtrace of the current exception, for use within catch blocks.\n\n\n\n\n\n"
},

{
    "location": "base/base.html#Base.catch_stack",
    "page": "Essentials",
    "title": "Base.catch_stack",
    "category": "function",
    "text": "catch_stack(task=current_task(); [inclue_bt=true])\n\nGet the stack of exceptions currently being handled. For nested catch blocks there may be more than one current exception in which case the most recently thrown exception is last in the stack. The stack is returned as a Vector of (exception,backtrace) pairs, or a Vector of exceptions if include_bt is false.\n\nExplicitly passing task will return the current exception stack on an arbitrary task. This is useful for inspecting tasks which have failed due to uncaught exceptions.\n\ncompat: Julia 1.1\nThis function is experimental in Julia 1.1 and will likely be renamed in a future release (see https://github.com/JuliaLang/julia/pull/29901).\n