/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.treemodel.JResource;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.LineNumbers;
import jadx.gui.ui.codearea.SearchBar;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class CodePanel
extends JPanel {
    private final SearchBar searchBar;
    private final AbstractCodeArea codeArea;
    private final JScrollPane codeScrollPane;

    public CodePanel(ContentPanel contentPanel, AbstractCodeArea codeArea) {
        this.codeArea = codeArea;
        this.searchBar = new SearchBar(codeArea);
        this.codeScrollPane = new JScrollPane((Component)((Object)codeArea));
        this.setLayout(new BorderLayout());
        this.add((Component)this.searchBar, "North");
        this.add((Component)this.codeScrollPane, "Center");
        this.initLineNumbers();
        KeyStroke key = KeyStroke.getKeyStroke(70, UiUtils.ctrlButton());
        UiUtils.addKeyBinding((JComponent)((Object)codeArea), key, "SearchAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodePanel.this.searchBar.toggle();
            }
        });
    }

    public void loadSettings() {
        this.codeArea.loadSettings();
        this.initLineNumbers();
    }

    public void load() {
        this.codeArea.load();
    }

    private void initLineNumbers() {
        if (this.codeArea.getDocument().getLength() <= 100000) {
            LineNumbers numbers = new LineNumbers(this.codeArea);
            numbers.setUseSourceLines(this.isUseSourceLines());
            this.codeScrollPane.setRowHeaderView(numbers);
        }
    }

    private boolean isUseSourceLines() {
        if (this.codeArea.getNode() instanceof JResource) {
            JResource resNode = (JResource)this.codeArea.getNode();
            return !resNode.getLineMapping().isEmpty();
        }
        return false;
    }

    public SearchBar getSearchBar() {
        return this.searchBar;
    }

    public AbstractCodeArea getCodeArea() {
        return this.codeArea;
    }

    public JScrollPane getCodeScrollPane() {
        return this.codeScrollPane;
    }
}

