/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaClass;
import jadx.api.JavaPackage;
import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class JPackage
extends JNode
implements Comparable<JPackage> {
    private static final long serialVersionUID = -4120718634156839804L;
    private static final ImageIcon PACKAGE_ICON = UiUtils.openIcon("package_obj");
    private final String fullName;
    private String name;
    private boolean enabled;
    private final List<JClass> classes;
    private final List<JPackage> innerPackages = new ArrayList<JPackage>(1);

    public JPackage(JavaPackage pkg, JadxWrapper wrapper) {
        this.fullName = pkg.getName();
        this.name = pkg.getName();
        this.setEnabled(wrapper);
        List<JavaClass> javaClasses = pkg.getClasses();
        this.classes = new ArrayList<JClass>(javaClasses.size());
        for (JavaClass javaClass : javaClasses) {
            this.classes.add(new JClass(javaClass));
        }
        this.update();
    }

    public JPackage(String name, JadxWrapper wrapper) {
        this.fullName = name;
        this.name = name;
        this.setEnabled(wrapper);
        this.classes = new ArrayList<JClass>(1);
    }

    private void setEnabled(JadxWrapper wrapper) {
        List<String> excludedPackages = wrapper.getExcludedPackages();
        this.enabled = excludedPackages.isEmpty() || excludedPackages.stream().filter(p -> !p.isEmpty()).noneMatch(p -> this.name.equals(p) || this.name.startsWith(p + '.'));
    }

    public final void update() {
        this.removeAllChildren();
        if (this.isEnabled()) {
            for (JPackage pkg : this.innerPackages) {
                pkg.update();
                this.add(pkg);
            }
            for (JClass cls : this.classes) {
                cls.update();
                this.add(cls);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<JPackage> getInnerPackages() {
        return this.innerPackages;
    }

    public List<JClass> getClasses() {
        return this.classes;
    }

    @Override
    public Icon getIcon() {
        return PACKAGE_ICON;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public int compareTo(@NotNull JPackage o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name.equals(((JPackage)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String makeString() {
        return this.name;
    }

    @Override
    public String makeLongString() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

