/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.extensions.ModeControllerHookAdapter;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.FreeMindFileDialog;
import freemind.modes.ModeController;
import freemind.view.mindmapview.MapView;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ExportHook
extends ModeControllerHookAdapter {
    private MapView view;

    protected File chooseFile(String type, String description, String nameExtension) {
        ModeController controller = this.getController();
        return ExportHook.chooseImageFile(type, description, nameExtension, controller);
    }

    public static File chooseImageFile(String type, String description, String nameExtension, ModeController controller) {
        String overwriteText;
        int overwriteMap;
        int returnVal;
        Container component = controller.getFrame().getContentPane();
        ImageFilter filter = new ImageFilter(type, description);
        FreeMindFileDialog chooser = null;
        chooser = controller.getFileChooser(filter);
        File mmFile = controller.getMap().getFile();
        if (mmFile != null) {
            String proposedName = mmFile.getAbsolutePath().replaceFirst("\\.[^.]*?$", "") + (nameExtension != null ? nameExtension : "") + "." + type;
            chooser.setSelectedFile(new File(proposedName));
        }
        if ((returnVal = chooser.showSaveDialog(component)) != 0) {
            return null;
        }
        File chosenFile = chooser.getSelectedFile();
        String ext = Tools.getExtension(chosenFile.getName());
        if (!Tools.safeEqualsIgnoreCase(ext, type)) {
            chosenFile = new File(chosenFile.getParent(), chosenFile.getName() + "." + type);
        }
        if (chosenFile.exists() && (overwriteMap = JOptionPane.showConfirmDialog(component, overwriteText = MessageFormat.format(controller.getText("file_already_exists"), chosenFile.toString()), overwriteText, 0)) != 0) {
            return null;
        }
        return chosenFile;
    }

    protected String getTranslatableResourceString(String resourceName) {
        String returnValue = this.getResourceString(resourceName);
        if (returnValue != null && returnValue.startsWith("%")) {
            return this.getController().getText(returnValue.substring(1));
        }
        return returnValue;
    }

    public BufferedImage createBufferedImage() {
        this.view = this.getController().getView();
        if (this.view == null) {
            return null;
        }
        this.view.preparePrinting();
        Rectangle innerBounds = this.view.getInnerBounds();
        BufferedImage myImage = (BufferedImage)this.view.createImage(this.view.getWidth(), this.view.getHeight());
        Graphics g = myImage.getGraphics();
        g.clipRect(innerBounds.x, innerBounds.y, innerBounds.width, innerBounds.height);
        this.view.print(g);
        myImage = myImage.getSubimage(innerBounds.x, innerBounds.y, innerBounds.width, innerBounds.height);
        this.view.endPrinting();
        return myImage;
    }

    protected void copyFromResource(String prefix, String fileName, String destinationDirectory) {
        try {
            this.logger.finest("searching for " + prefix + fileName);
            URL resource = this.getResource(prefix + fileName);
            if (resource == null) {
                this.logger.severe("Cannot find resource: " + prefix + fileName);
                return;
            }
            InputStream in = resource.openStream();
            FileOutputStream out = new FileOutputStream(destinationDirectory + "/" + fileName);
            Tools.copyStream(in, out, true);
        }
        catch (Exception e) {
            this.logger.severe("File not found or could not be copied. Was earching for " + prefix + fileName + " and should go to " + destinationDirectory);
            Resources.getInstance().logException(e);
        }
    }

    protected void copyFromFile(String dir, String fileName, String destinationDirectory) {
        try {
            this.logger.finest("searching for " + dir + fileName);
            File resource = new File(dir, fileName);
            if (resource == null) {
                this.logger.severe("Cannot find resource: " + dir + fileName);
                return;
            }
            FileInputStream in = new FileInputStream(resource);
            FileOutputStream out = new FileOutputStream(destinationDirectory + "/" + fileName);
            Tools.copyStream(in, out, true);
        }
        catch (Exception e) {
            this.logger.severe("File not found or could not be copied. Was earching for " + dir + fileName + " and should go to " + destinationDirectory);
            Resources.getInstance().logException(e);
        }
    }

    public static class ImageFilter
    extends FileFilter {
        private String type;
        private final String description;

        public ImageFilter(String type, String description) {
            this.type = type;
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = Tools.getExtension(f.getName());
            return Tools.safeEqualsIgnoreCase(extension, this.type);
        }

        @Override
        public String getDescription() {
            return this.description == null ? this.type : this.description;
        }
    }
}

