/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.Context;
import esmska.data.Config;
import esmska.data.Contact;
import esmska.data.Contacts;
import esmska.data.CountryPrefix;
import esmska.data.Envelope;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Icons;
import esmska.data.Keyring;
import esmska.data.Queue;
import esmska.data.SMS;
import esmska.data.event.AbstractDocumentListener;
import esmska.data.event.ActionEventSupport;
import esmska.gui.Actions;
import esmska.gui.ClipboardPopupMenu;
import esmska.gui.GatewayComboBox;
import esmska.gui.InfoLabel;
import esmska.gui.ThemeManager;
import esmska.utils.L10N;
import esmska.utils.MiscUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.openide.awt.Mnemonics;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.SkinChangeListener;

public class SMSPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(SMSPanel.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private Envelope envelope = new Envelope();
    private UndoManager smsTextUndoManager = new UndoManager();
    private SortedSet<Contact> contacts = Contacts.getInstance().getAll();
    private Config config = Config.getInstance();
    private Keyring keyring = Keyring.getInstance();
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private Action showAddContactDialogAction = new ShowAddContactDialogAction();
    private CompressAction compressAction = null;
    private SendAction sendAction = new SendAction();
    private SMSTextPaneListener smsTextPaneListener = new SMSTextPaneListener();
    private SMSTextPaneDocumentFilter smsTextPaneDocumentFilter;
    private RecipientTextField recipientField;
    private boolean disableContactListeners;
    private ActionEventSupport actionSupport = new ActionEventSupport(this);
    private JButton addContactButton;
    private InfoLabel countryInfoLabel;
    private InfoLabel credentialsInfoLabel;
    private JProgressBar fullProgressBar;
    private GatewayComboBox gatewayComboBox;
    private JLabel gatewayLabel;
    private JPanel infoPanel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private InfoLabel numberInfoLabel;
    private JLabel recipientLabel;
    private JTextField recipientTextField;
    private JButton sendButton;
    private JProgressBar singleProgressBar;
    private JLabel smsCounterLabel;
    private JTextPane smsTextPane;
    private JButton suggestGatewayButton;
    private JLabel textLabel;

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    public SMSPanel() {
        this.initComponents();
        this.compressAction = new CompressAction();
        this.recipientField = (RecipientTextField)this.recipientTextField;
        if (!this.config.getLookAndFeel().equals((Object)ThemeManager.LAF.SUBSTANCE)) {
            ClipboardPopupMenu.register(this.smsTextPane);
            ClipboardPopupMenu.register(this.recipientTextField);
        }
        this.keyring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SMSPanel.this.updateCredentialsInfoLabel();
                SMSPanel.this.revalidate();
            }
        });
        Context.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!StringUtils.equals(evt.getPropertyName(), "everythingLoaded")) {
                    return;
                }
                SMSPanel.this.sendAction.updateStatus();
            }
        });
    }

    private boolean validateForm(boolean transferFocus) {
        if (StringUtils.isEmpty(this.envelope.getText())) {
            if (transferFocus) {
                this.smsTextPane.requestFocusInWindow();
            }
            return false;
        }
        if (this.envelope.getText().length() > this.envelope.getMaxTextLength()) {
            if (transferFocus) {
                this.smsTextPane.requestFocusInWindow();
            }
            return false;
        }
        if (this.envelope.getContacts().size() <= 0) {
            if (transferFocus) {
                this.recipientTextField.requestFocusInWindow();
            }
            return false;
        }
        for (Contact c : this.envelope.getContacts()) {
            if (Contact.isValidNumber(c.getNumber())) continue;
            if (transferFocus) {
                this.recipientTextField.requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private Contact lookupContact(boolean onlyFullMatch) {
        String number = this.recipientField.getNumber();
        String id = this.recipientTextField.getText();
        String gatewayName = this.gatewayComboBox.getSelectedGatewayName();
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        Contact contact = null;
        Contact fullContact = null;
        if (number != null) {
            for (Contact c : this.contacts) {
                if (!ObjectUtils.equals(c.getNumber(), number)) continue;
                if (ObjectUtils.equals(c.getGateway(), gatewayName)) {
                    fullContact = c;
                    break;
                }
                if (onlyFullMatch || contact != null) continue;
                contact = c;
            }
        } else {
            for (Contact c : this.contacts) {
                if (!id.equalsIgnoreCase(c.getName())) continue;
                if (ObjectUtils.equals(c.getGateway(), gatewayName)) {
                    fullContact = c;
                    break;
                }
                if (onlyFullMatch || contact != null) continue;
                contact = c;
            }
        }
        return fullContact != null ? fullContact : contact;
    }

    private void requestSelectContact(Contact contact) {
        if (contact != null) {
            Context.mainFrame.getContactPanel().setSelectedContact(contact);
        } else {
            Context.mainFrame.getContactPanel().clearSelection();
        }
    }

    public void setContacts(Collection<Contact> contacts) {
        boolean multiSendMode;
        Validate.notNull(contacts);
        this.disableContactListeners = true;
        this.stripSignature();
        int count = contacts.size();
        if (count == 1) {
            Contact c = contacts.iterator().next();
            this.recipientField.setContact(c);
            this.gatewayComboBox.setSelectedGateway(c.getGateway());
        }
        boolean bl = multiSendMode = count > 1;
        if (multiSendMode) {
            this.recipientTextField.setText(l10n.getString("Multiple_sending"));
            this.gatewayComboBox.setSelectedGateway(null);
        }
        this.recipientTextField.setEnabled(!multiSendMode);
        this.gatewayComboBox.setEnabled(!multiSendMode);
        HashSet<Contact> set = new HashSet<Contact>();
        set.addAll(contacts);
        if (count < 1) {
            Contact contact = this.recipientField.getContact();
            set.add(new Contact(contact != null ? contact.getName() : null, this.recipientField.getNumber(), this.gatewayComboBox.getSelectedGatewayName()));
        }
        this.envelope.setContacts(set);
        this.updateSignature();
        this.sendAction.updateStatus();
        this.smsTextPaneDocumentFilter.requestUpdate();
        this.updateNumberInfoLabel();
        this.updateSuggestGatewayButton();
        this.updateAddContactButton();
        this.revalidate();
        this.disableContactListeners = false;
    }

    public void setSMS(final SMS sms) {
        this.recipientField.setNumber(sms.getNumber());
        this.smsTextPane.setText(sms.getText());
        this.smsTextUndoManager.discardAllEdits();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SMSPanel.this.gatewayComboBox.setSelectedGateway(sms.getGateway());
                SMSPanel.this.smsTextPane.requestFocusInWindow();
            }
        });
    }

    public String getText() {
        String text = this.smsTextPane.getText();
        return text != null ? text : "";
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getCompressAction() {
        return this.compressAction;
    }

    public Action getSendAction() {
        return this.sendAction;
    }

    private void stripSignature() {
        String signatureName = this.envelope.getSenderName();
        if (StringUtils.isEmpty(signatureName)) {
            return;
        }
        String text = this.smsTextPane.getText();
        if (text.startsWith(signatureName)) {
            this.smsTextPane.setText(StringUtils.removeStart(text, signatureName));
        }
    }

    private void updateSignature() {
        String signatureName = this.envelope.getSenderName();
        if (StringUtils.isEmpty(signatureName)) {
            return;
        }
        String text = this.smsTextPane.getText();
        if (text.startsWith(signatureName)) {
            return;
        }
        this.smsTextPane.setText(signatureName + text);
    }

    private void updateProgressBars() {
        int currentLength = this.envelope.getText().length();
        int smsLength = this.envelope.getSMSLength();
        int maxTextLength = this.envelope.getMaxTextLength();
        this.fullProgressBar.setMaximum(maxTextLength);
        int min = this.envelope.getPenultimateIndexOfCut(this.envelope.getText(), smsLength);
        int max = min + smsLength;
        max = Math.min(max, maxTextLength);
        this.singleProgressBar.setMinimum(min);
        this.singleProgressBar.setMaximum(max);
        this.fullProgressBar.setValue(currentLength);
        this.singleProgressBar.setValue(currentLength);
        this.updateProgressBarToolTip(this.fullProgressBar, "SMSPanel.fullProgressBar");
        this.updateProgressBarToolTip(this.singleProgressBar, "SMSPanel.singleProgressBar");
    }

    private void updateProgressBarToolTip(JProgressBar bar, String resourceId) {
        int used = bar.getValue() - bar.getMinimum();
        if (bar.getMaximum() == Integer.MAX_VALUE) {
            bar.setToolTipText(MessageFormat.format(l10n.getString(resourceId), used, "\u221e", "\u221e"));
        } else {
            int capacity = bar.getMaximum() - bar.getMinimum();
            int remaining = bar.getMaximum() - bar.getValue();
            bar.setToolTipText(MessageFormat.format(l10n.getString(resourceId), used, capacity, remaining));
        }
    }

    private void updateCountryInfoLabel() {
        this.countryInfoLabel.setVisible(false);
        Gateway gateway = this.gatewayComboBox.getSelectedGateway();
        String number = this.recipientField.getNumber();
        if (gateway == null || !Contact.isValidNumber(number)) {
            return;
        }
        boolean supported = Gateways.isNumberSupported(gateway, number);
        if (!supported) {
            String text = MessageFormat.format(l10n.getString("SMSPanel.countryInfoLabel.text"), StringUtils.join((Object[])gateway.getSupportedPrefixes(), ','));
            this.countryInfoLabel.setText(text);
            this.countryInfoLabel.setVisible(true);
        }
    }

    private void updateCredentialsInfoLabel() {
        Gateway gateway = this.gatewayComboBox.getSelectedGateway();
        if (gateway != null && gateway.hasFeature(Gateway.Feature.LOGIN_ONLY) && this.keyring.getKey(gateway.getName()) == null) {
            this.credentialsInfoLabel.setVisible(true);
        } else {
            this.credentialsInfoLabel.setVisible(false);
        }
    }

    private void updateNumberInfoLabel() {
        this.numberInfoLabel.setVisible(false);
        if (this.envelope.getContacts().size() != 1) {
            return;
        }
        Contact contact = this.envelope.getContacts().iterator().next();
        if (StringUtils.isNotEmpty(this.recipientField.getText())) {
            this.numberInfoLabel.setVisible(!Contact.isValidNumber(contact.getNumber()));
        }
    }

    private void updateAddContactButton() {
        RecipientTextField field = (RecipientTextField)this.recipientTextField;
        if (field.getContact() == null && field.getNumber() != null) {
            this.addContactButton.setVisible(true);
        } else {
            this.addContactButton.setVisible(false);
        }
    }

    private void updateSuggestGatewayButton() {
        RecipientTextField field = (RecipientTextField)this.recipientTextField;
        ArrayList<Object> gws = new ArrayList();
        if (field.getContact() == null && field.getNumber() != null) {
            gws = Gateways.getInstance().suggestGateway(field.getNumber()).get1();
        }
        boolean visible = false;
        if (gws.size() > 1) {
            visible = true;
        }
        if (gws.size() == 1 && this.gatewayComboBox.getSelectedGateway() != gws.get(0)) {
            visible = true;
        }
        this.suggestGatewayButton.setVisible(visible);
    }

    private void initComponents() {
        this.gatewayComboBox = new GatewayComboBox();
        this.fullProgressBar = new JProgressBar();
        this.jScrollPane1 = new JScrollPane();
        this.smsTextPane = new JTextPane();
        this.textLabel = new JLabel();
        this.sendButton = new JButton();
        this.smsCounterLabel = new JLabel();
        this.singleProgressBar = new JProgressBar();
        this.gatewayLabel = new JLabel();
        this.recipientTextField = new RecipientTextField();
        this.recipientLabel = new JLabel();
        this.infoPanel = new JPanel();
        this.credentialsInfoLabel = new InfoLabel();
        this.numberInfoLabel = new InfoLabel();
        this.countryInfoLabel = new InfoLabel();
        this.suggestGatewayButton = new JButton();
        this.jLabel1 = new JLabel();
        this.addContactButton = new JButton();
        this.setBorder(BorderFactory.createTitledBorder(l10n.getString("SMSPanel.border.title")));
        this.setMinimumSize(new Dimension(5, 5));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SMSPanel.this.formFocusGained(evt);
            }
        });
        this.gatewayComboBox.addActionListener(new GatewayComboBoxActionListener());
        this.gatewayComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SMSPanel.this.gatewayComboBoxItemStateChanged(evt);
            }
        });
        this.fullProgressBar.setMaximum(1000);
        this.smsTextPane.getDocument().addDocumentListener(this.smsTextPaneListener);
        this.smsTextPaneDocumentFilter = new SMSTextPaneDocumentFilter();
        ((AbstractDocument)((Object)this.smsTextPane.getStyledDocument())).setDocumentFilter(this.smsTextPaneDocumentFilter);
        this.smsTextUndoManager.setLimit(-1);
        this.smsTextPane.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                if (e.getEdit().getPresentationName().contains("style")) {
                    return;
                }
                SMSPanel.this.smsTextUndoManager.addEdit(e.getEdit());
            }
        });
        int menuMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        String command = "undo";
        this.smsTextPane.getInputMap().put(KeyStroke.getKeyStroke(90, menuMask), command);
        this.smsTextPane.getActionMap().put(command, this.undoAction);
        command = "redo";
        this.smsTextPane.getInputMap().put(KeyStroke.getKeyStroke(89, menuMask), command);
        this.smsTextPane.getInputMap().put(KeyStroke.getKeyStroke(90, menuMask | 0x40), command);
        this.smsTextPane.getActionMap().put(command, this.redoAction);
        command = "send";
        this.smsTextPane.getInputMap().put(KeyStroke.getKeyStroke(10, menuMask), command);
        this.smsTextPane.getActionMap().put(command, this.sendAction);
        this.jScrollPane1.setViewportView(this.smsTextPane);
        this.textLabel.setLabelFor(this.smsTextPane);
        Mnemonics.setLocalizedText(this.textLabel, l10n.getString("SMSPanel.textLabel.text"));
        this.textLabel.setToolTipText(l10n.getString("SMSPanel.textLabel.toolTipText"));
        this.sendButton.setAction(this.sendAction);
        this.sendButton.setToolTipText(l10n.getString("SMSPanel.sendButton.toolTipText"));
        Mnemonics.setLocalizedText(this.smsCounterLabel, l10n.getString("SMSPanel.smsCounterLabel.text"));
        this.singleProgressBar.setMaximum(1000);
        this.gatewayLabel.setLabelFor(this.gatewayComboBox);
        Mnemonics.setLocalizedText(this.gatewayLabel, l10n.getString("SMSPanel.gatewayLabel.text"));
        this.gatewayLabel.setToolTipText(this.gatewayComboBox.getToolTipText());
        this.recipientLabel.setLabelFor(this.recipientTextField);
        Mnemonics.setLocalizedText(this.recipientLabel, l10n.getString("SMSPanel.recipientLabel.text"));
        this.recipientLabel.setToolTipText(this.recipientTextField.getToolTipText());
        this.infoPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SMSPanel.this.infoPanelComponentResized(evt);
            }
        });
        Mnemonics.setLocalizedText(this.credentialsInfoLabel, l10n.getString("SMSPanel.credentialsInfoLabel.text"));
        this.credentialsInfoLabel.setText(MessageFormat.format(l10n.getString("SMSPanel.credentialsInfoLabel.text"), "esmska://config-gateways"));
        this.credentialsInfoLabel.setVisible(false);
        Mnemonics.setLocalizedText(this.numberInfoLabel, l10n.getString("SMSPanel.numberInfoLabel.text"));
        this.numberInfoLabel.setVisible(false);
        Mnemonics.setLocalizedText(this.countryInfoLabel, l10n.getString("SMSPanel.countryInfoLabel.text"));
        this.countryInfoLabel.setVisible(false);
        GroupLayout infoPanelLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.credentialsInfoLabel, -1, 368, Short.MAX_VALUE).addComponent(this.numberInfoLabel).addComponent(this.countryInfoLabel, -1, 368, Short.MAX_VALUE));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, infoPanelLayout.createSequentialGroup().addComponent(this.numberInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countryInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.credentialsInfoLabel, -2, -1, -2)));
        this.suggestGatewayButton.setAction(Actions.getSuggestGatewayAction(this.gatewayComboBox, this.recipientTextField));
        this.suggestGatewayButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/search-16.png")));
        this.suggestGatewayButton.setText(null);
        this.suggestGatewayButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.addContactButton.setAction(this.showAddContactDialogAction);
        this.addContactButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/add-16.png")));
        this.addContactButton.setText(null);
        this.addContactButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.recipientLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recipientTextField, -1, 325, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addContactButton)).addGroup(layout.createSequentialGroup().addComponent(this.gatewayLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gatewayComboBox, -1, 325, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.suggestGatewayButton).addGap(0, 0, 0).addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textLabel).addComponent(this.singleProgressBar, -2, 33, -2).addComponent(this.fullProgressBar, -2, 33, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.smsCounterLabel, -1, 341, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sendButton)).addComponent(this.jScrollPane1, -1, 378, Short.MAX_VALUE))))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(74, 74, 74).addComponent(this.infoPanel, -1, -1, Short.MAX_VALUE))).addGap(10, 10, 10)));
        layout.linkSize(0, this.fullProgressBar, this.singleProgressBar);
        layout.linkSize(0, this.gatewayLabel, this.recipientLabel, this.textLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.recipientLabel).addComponent(this.recipientTextField, -2, -1, -2).addComponent(this.addContactButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gatewayLabel).addComponent(this.gatewayComboBox, -2, -1, -2)).addComponent(this.suggestGatewayButton)).addComponent(this.jLabel1, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 65, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sendButton).addComponent(this.smsCounterLabel))).addGroup(layout.createSequentialGroup().addComponent(this.textLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleProgressBar, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fullProgressBar, -2, 10, -2))).addContainerGap()));
        layout.linkSize(1, this.fullProgressBar, this.singleProgressBar);
        layout.linkSize(1, this.addContactButton, this.recipientTextField);
        layout.linkSize(1, this.gatewayComboBox, this.suggestGatewayButton);
    }

    private void formFocusGained(FocusEvent evt) {
        this.smsTextPane.requestFocusInWindow();
    }

    private void gatewayComboBoxItemStateChanged(ItemEvent evt) {
        this.updateCredentialsInfoLabel();
        this.updateCountryInfoLabel();
        this.updateSuggestGatewayButton();
        this.revalidate();
    }

    private void infoPanelComponentResized(ComponentEvent evt) {
        if (MiscUtils.needsResize(this, MiscUtils.Direction.HEIGHT)) {
            this.actionSupport.fireActionPerformed(0, null);
        }
    }

    public class RecipientTextField
    extends JTextField {
        private Contact contact;
        private RecipientDocumentChange recipientDocumentChange = new RecipientDocumentChange();
        private String tooltip = SMSPanel.access$1000().getString("SMSPanel.recipientTextField.tooltip");
        private String tooltipTip = SMSPanel.access$1000().getString("SMSPanel.recipientTextField.tooltip.tip");

        public RecipientTextField() {
            if (StringUtils.isEmpty(SMSPanel.this.config.getCountryPrefix())) {
                this.setToolTipText(this.tooltip + this.tooltipTip + "</html>");
            } else {
                this.setToolTipText(this.tooltip + "</html>");
            }
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    RecipientTextField.this.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    RecipientTextField.this.select(0, 0);
                    RecipientTextField.this.redrawContactName();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    if (evt != null && evt.getKeyCode() == 10) {
                        SMSPanel.this.smsTextPane.requestFocusInWindow();
                        return;
                    }
                }
            });
            this.getDocument().addDocumentListener(new AbstractDocumentListener(){

                @Override
                public void onUpdate(DocumentEvent evt) {
                    if (SMSPanel.this.disableContactListeners) {
                        return;
                    }
                    SwingUtilities.invokeLater(RecipientTextField.this.recipientDocumentChange);
                }
            });
        }

        public void setContact(Contact contact) {
            this.contact = contact;
            if (!this.hasFocus()) {
                super.setText(contact != null ? contact.getName() : null);
            }
        }

        public Contact getContact() {
            return this.contact;
        }

        @Override
        public String getText() {
            if (this.contact != null) {
                return this.contact.getNumber();
            }
            String text = super.getText();
            if (StringUtils.isNotEmpty(text) && !text.startsWith("+")) {
                text = SMSPanel.this.config.getCountryPrefix() + text;
            }
            if (Contact.isValidNumber(text)) {
                return text;
            }
            return super.getText();
        }

        @Override
        public void setText(String text) {
            this.contact = null;
            super.setText(text);
        }

        public void redrawContactName() {
            if (this.contact == null) {
                return;
            }
            boolean old = SMSPanel.this.disableContactListeners;
            SMSPanel.this.disableContactListeners = true;
            super.setText(this.contact.getName());
            SMSPanel.this.disableContactListeners = old;
        }

        public String getNumber() {
            if (this.contact != null) {
                return this.contact.getNumber();
            }
            String text = this.getText();
            if (Contact.isValidNumber(text)) {
                return text;
            }
            return null;
        }

        public void setNumber(String number) {
            if (StringUtils.isEmpty(number)) {
                this.setText("");
            }
            this.setText(CountryPrefix.stripCountryPrefix(number, true));
        }

        private class RecipientDocumentChange
        implements Runnable {
            private RecipientDocumentChange() {
            }

            @Override
            public void run() {
                RecipientTextField.this.contact = null;
                RecipientTextField.this.contact = SMSPanel.this.lookupContact(false);
                SMSPanel.this.requestSelectContact(null);
                SMSPanel.this.requestSelectContact(RecipientTextField.this.contact);
                if (RecipientTextField.this.contact == null && RecipientTextField.this.getNumber() != null) {
                    SMSPanel.this.gatewayComboBox.selectSuggestedGateway(RecipientTextField.this.getNumber());
                }
                HashSet<Contact> set = new HashSet<Contact>();
                set.add(new Contact(RecipientTextField.this.contact != null ? RecipientTextField.this.contact.getName() : null, RecipientTextField.this.getNumber(), SMSPanel.this.gatewayComboBox.getSelectedGatewayName()));
                SMSPanel.this.envelope.setContacts(set);
                SMSPanel.this.sendAction.updateStatus();
                SMSPanel.this.updateCountryInfoLabel();
                SMSPanel.this.updateNumberInfoLabel();
                SMSPanel.this.gatewayComboBox.setFilter(RecipientTextField.this.getNumber());
                SMSPanel.this.updateSuggestGatewayButton();
                SMSPanel.this.updateAddContactButton();
                SMSPanel.this.revalidate();
            }
        }
    }

    private class SMSTextPaneDocumentFilter
    extends DocumentFilter {
        private StyledDocument doc;
        private Style regular;
        private Style highlight;
        private Style lastStyle;
        private Color alternateTextColor;
        private Timer timer;

        public SMSTextPaneDocumentFilter() {
            this.lastStyle = this.regular;
            this.alternateTextColor = Color.BLUE;
            this.timer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SMSTextPaneDocumentFilter.this.colorDocument();
                    SMSTextPaneDocumentFilter.this.updateUI();
                }
            });
            this.timer.setRepeats(false);
            this.doc = SMSPanel.this.smsTextPane.getStyledDocument();
            Style def = StyleContext.getDefaultStyleContext().getStyle("default");
            this.regular = this.doc.addStyle("regular", def);
            this.highlight = this.doc.addStyle("highlight", def);
            this.lafChangedImpl();
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("lookAndFeel".equals(evt.getPropertyName())) {
                        SMSTextPaneDocumentFilter.this.lafChanged();
                    }
                }
            });
            SubstanceLookAndFeel.registerSkinChangeListener(new SkinChangeListener(){

                @Override
                public void skinChanged() {
                    SMSTextPaneDocumentFilter.this.lafChanged();
                }
            });
        }

        private void updateUI() {
            SMSPanel.this.compressAction.updateStatus();
            SMSPanel.this.undoAction.updateStatus();
            SMSPanel.this.redoAction.updateStatus();
            SMSPanel.this.sendAction.updateStatus();
            SMSPanel.this.updateProgressBars();
        }

        private void colorDocument() {
            String msgText = SMSPanel.this.envelope.getText();
            ArrayList<Integer> cutIndexes = SMSPanel.this.envelope.getIndicesOfCuts(msgText, SMSPanel.this.envelope.getSMSLength());
            if (cutIndexes.isEmpty()) {
                cutIndexes.add(msgText.length());
            }
            int from = 0;
            for (int i = 0; i < cutIndexes.size(); ++i) {
                int to = cutIndexes.get(i);
                this.lastStyle = this.getStyle(i + 1);
                this.doc.setCharacterAttributes(from, to - from, this.lastStyle, false);
                from = to;
            }
        }

        private Style getStyle(int smsNum) {
            if (smsNum % 2 == 1) {
                return this.regular;
            }
            return this.highlight;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            String currentText = fb.getDocument().getText(0, fb.getDocument().getLength());
            if (currentText.length() + (text != null ? text.length() : 0) - length > SMSPanel.this.envelope.getMaxTextLength()) {
                Context.mainFrame.getStatusPanel().setStatusMessage(l10n.getString("SMSPanel.Text_is_too_long!"), null, null, false);
                Context.mainFrame.getStatusPanel().hideStatusMessageAfter(5000);
                int maxlength = SMSPanel.this.envelope.getMaxTextLength(currentText) - currentText.length() + length;
                maxlength = Math.max(maxlength, 0);
                if (text != null) {
                    text = text.substring(0, maxlength);
                }
            }
            super.replace(fb, offset, length, text, this.lastStyle);
            this.timer.restart();
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            super.insertString(fb, offset, string, attr);
            this.timer.restart();
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
            this.timer.restart();
        }

        public void requestUpdate() {
            this.timer.restart();
        }

        private void lafChanged() {
            this.lafChangedImpl();
            this.requestUpdate();
        }

        private void lafChangedImpl() {
            StyleConstants.setForeground(this.regular, UIManager.getColor("TextArea.foreground"));
            this.alternateTextColor = ThemeManager.isCurrentSkinDark() ? Color.CYAN : Color.BLUE;
            StyleConstants.setForeground(this.highlight, this.alternateTextColor);
        }
    }

    private class SMSTextPaneListener
    extends AbstractDocumentListener {
        private SMSTextPaneListener() {
        }

        private void countChars(DocumentEvent e) {
            String msgText = SMSPanel.this.envelope.getText();
            if (SMSPanel.this.envelope.getSMSLength() > 0) {
                int smsCount = SMSPanel.this.envelope.getSMSCount(msgText, SMSPanel.this.envelope.getSMSLength());
                SMSPanel.this.smsCounterLabel.setText(MessageFormat.format(l10n.getString("SMSPanel.smsCounterLabel.1"), msgText.length(), smsCount));
            } else {
                SMSPanel.this.smsCounterLabel.setText(MessageFormat.format(l10n.getString("SMSPanel.smsCounterLabel.1"), msgText.length(), "?"));
            }
            if (msgText.length() > SMSPanel.this.envelope.getMaxTextLength()) {
                SMSPanel.this.smsCounterLabel.setForeground(Color.RED);
                SMSPanel.this.smsCounterLabel.setText(MessageFormat.format(l10n.getString("SMSPanel.smsCounterLabel.2"), msgText.length()));
            } else {
                SMSPanel.this.smsCounterLabel.setForeground(UIManager.getColor("Label.foreground"));
            }
        }

        private void updateEnvelope(DocumentEvent e) {
            try {
                SMSPanel.this.envelope.setText(e.getDocument().getText(0, e.getDocument().getLength()));
            }
            catch (BadLocationException ex) {
                logger.log(Level.SEVERE, "Error getting sms text", ex);
            }
        }

        @Override
        public void onUpdate(DocumentEvent e) {
            this.updateEnvelope(e);
            this.countChars(e);
        }
    }

    private class GatewayComboBoxActionListener
    implements ActionListener {
        private GatewayComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SMSPanel.this.disableContactListeners) {
                return;
            }
            SMSPanel.this.stripSignature();
            Contact contact = SMSPanel.this.lookupContact(true);
            if (contact != null) {
                SMSPanel.this.requestSelectContact(contact);
            }
            HashSet<Contact> set = new HashSet<Contact>();
            Contact c = SMSPanel.this.recipientField.getContact();
            set.add(new Contact(c != null ? c.getName() : null, SMSPanel.this.recipientField.getNumber(), SMSPanel.this.gatewayComboBox.getSelectedGatewayName()));
            SMSPanel.this.envelope.setContacts(set);
            DocumentEvent event = new DocumentEvent(){

                @Override
                public DocumentEvent.ElementChange getChange(Element elem) {
                    return null;
                }

                @Override
                public Document getDocument() {
                    return SMSPanel.this.smsTextPane.getDocument();
                }

                @Override
                public int getLength() {
                    return 0;
                }

                @Override
                public int getOffset() {
                    return 0;
                }

                @Override
                public DocumentEvent.EventType getType() {
                    return DocumentEvent.EventType.INSERT;
                }
            };
            SMSPanel.this.smsTextPaneListener.onUpdate(event);
            SMSPanel.this.updateSignature();
            SMSPanel.this.smsTextPaneDocumentFilter.requestUpdate();
        }
    }

    private class ShowAddContactDialogAction
    extends AbstractAction {
        private Contact skeleton;

        public ShowAddContactDialogAction() {
            this.putValue("ShortDescription", l10n.getString("Add_contact"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.skeleton = new Contact(null, SMSPanel.this.recipientTextField.getText(), null);
            Context.mainFrame.getContactPanel().showAddContactDialog(this.skeleton);
        }
    }

    private class CompressAction
    extends AbstractAction {
        private boolean partialSelection = false;

        public CompressAction() {
            this.updateLabels();
            this.putValue("ShortDescription", l10n.getString("SMSPanel.compress"));
            this.putValue("SwingLargeIconKey", Icons.get("compress-32.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            SMSPanel.this.smsTextPane.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    boolean ps;
                    boolean bl = ps = SMSPanel.this.smsTextPane.getSelectedText() != null;
                    if (ps != CompressAction.this.partialSelection) {
                        CompressAction.this.partialSelection = ps;
                        CompressAction.this.updateLabels();
                    }
                }
            });
        }

        private void updateLabels() {
            if (this.partialSelection) {
                L10N.setLocalizedText(this, l10n.getString("CompressText_"));
            } else {
                L10N.setLocalizedText(this, l10n.getString("Compress_"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text;
            logger.fine("Compressing message");
            String string = text = this.partialSelection ? SMSPanel.this.smsTextPane.getSelectedText() : SMSPanel.this.smsTextPane.getText();
            if (StringUtils.isEmpty(text)) {
                return;
            }
            String newText = text.replaceAll("\\s", " ");
            newText = Pattern.compile("(\\s)\\s+", 32).matcher(newText).replaceAll("$1");
            Pattern pattern = Pattern.compile("\\s+(.)", 32);
            Matcher matcher = pattern.matcher(newText);
            while (matcher.find()) {
                newText = matcher.replaceFirst(matcher.group(1).toUpperCase());
                matcher = pattern.matcher(newText);
            }
            if ((newText = newText.replaceAll(" $", "")).equals(text)) {
                return;
            }
            if (this.partialSelection) {
                int selectIndex = SMSPanel.this.smsTextPane.getSelectionStart();
                SMSPanel.this.smsTextPane.replaceSelection(newText);
                SMSPanel.this.smsTextPane.setSelectionStart(selectIndex);
                SMSPanel.this.smsTextPane.setSelectionEnd(selectIndex + newText.length());
            } else {
                SMSPanel.this.smsTextPane.setText(newText);
            }
        }

        public void updateStatus() {
            this.setEnabled(SMSPanel.this.getText().length() > 0);
        }
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            L10N.setLocalizedText(this, l10n.getString("Redo_"));
            this.putValue("SmallIcon", Icons.get("redo-16.png"));
            this.putValue("SwingLargeIconKey", Icons.get("redo-32.png"));
            this.putValue("ShortDescription", l10n.getString("SMSPanel.Redo_change_in_message_text"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SMSPanel.this.smsTextUndoManager.canRedo()) {
                SMSPanel.this.smsTextUndoManager.redo();
                SMSPanel.this.smsTextPaneDocumentFilter.requestUpdate();
            }
        }

        public void updateStatus() {
            this.setEnabled(SMSPanel.this.smsTextUndoManager.canRedo());
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            L10N.setLocalizedText(this, l10n.getString("Undo_"));
            this.putValue("SmallIcon", Icons.get("undo-16.png"));
            this.putValue("SwingLargeIconKey", Icons.get("undo-32.png"));
            this.putValue("ShortDescription", l10n.getString("SMSPanel.Undo_change_in_message_text"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SMSPanel.this.smsTextUndoManager.canUndo()) {
                SMSPanel.this.smsTextUndoManager.undo();
                SMSPanel.this.smsTextPaneDocumentFilter.requestUpdate();
            }
        }

        public void updateStatus() {
            this.setEnabled(SMSPanel.this.smsTextUndoManager.canUndo());
        }
    }

    private class SendAction
    extends AbstractAction {
        public SendAction() {
            L10N.setLocalizedText(this, l10n.getString("Send_"));
            this.putValue("SmallIcon", Icons.get("send-16.png"));
            this.putValue("SwingLargeIconKey", Icons.get("send-22.png"));
            this.putValue("ShortDescription", l10n.getString("Send_message"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SMSPanel.this.validateForm(true)) {
                return;
            }
            logger.fine("Sending new message to queue");
            Queue.getInstance().addAll(SMSPanel.this.envelope.generate());
            SMSPanel.this.smsTextPane.setText(null);
            SMSPanel.this.smsTextUndoManager.discardAllEdits();
            SMSPanel.this.smsTextPane.requestFocusInWindow();
        }

        public void updateStatus() {
            this.setEnabled(SMSPanel.this.validateForm(false) && Context.everythingLoaded());
        }
    }
}

