/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class RestExplainAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestExplainAction.class));
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying a type in explain requests is deprecated.";

    public RestExplainAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_explain/{id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_explain/{id}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_explain", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_explain", this);
    }

    @Override
    public String getName() {
        return "explain_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] sFields;
        ExplainRequest explainRequest;
        if (request.hasParam("type")) {
            deprecationLogger.deprecatedAndMaybeLog("explain_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            explainRequest = new ExplainRequest(request.param("index"), request.param("type"), request.param("id"));
        } else {
            explainRequest = new ExplainRequest(request.param("index"), request.param("id"));
        }
        explainRequest.parent(request.param("parent"));
        explainRequest.routing(request.param("routing"));
        explainRequest.preference(request.param("preference"));
        String queryString = request.param("q");
        request.withContentOrSourceParamParserOrNull(parser -> {
            if (parser != null) {
                explainRequest.query(RestActions.getQueryContent(parser));
            } else if (queryString != null) {
                QueryBuilder query = RestActions.urlParamsToQueryBuilder(request);
                explainRequest.query(query);
            }
        });
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("The parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields");
        }
        String sField = request.param("stored_fields");
        if (sField != null && (sFields = Strings.splitStringByCommaToArray(sField)) != null) {
            explainRequest.storedFields(sFields);
        }
        explainRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> client.explain(explainRequest, new RestStatusToXContentListener<ExplainResponse>((RestChannel)channel));
    }
}

