/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.js.launch.shortcuts;

import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.jsdt.chromium.debug.js.JSDebuggerPlugin;
import org.eclipse.wst.jsdt.chromium.debug.js.util.ChromiumUtil;

public class ChromiumShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        try {
            Object objSelected = ((IStructuredSelection)selection).getFirstElement();
            if (objSelected instanceof IResource) {
                this.launch((IResource)objSelected, mode);
            }
        }
        catch (IOException | CoreException e) {
            JSDebuggerPlugin.logError(e, e.getMessage());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        try {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)editorInput).getFile();
                this.launch((IResource)file, mode);
            }
        }
        catch (IOException | CoreException e) {
            JSDebuggerPlugin.logError(e, e.getMessage());
        }
    }

    private void launch(IResource resource, String mode) throws CoreException, IOException {
        IProject project = resource.getProject();
        String projectName = project.getName();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.wst.jsdt.js.chromium.ChromiumLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance((IContainer)project, projectName);
        workingCopy.setAttribute("attr_app_project", projectName);
        workingCopy.setAttribute("attr_app_project_relative_path", resource.getProjectRelativePath().toOSString());
        workingCopy.setAttribute("attr_chromium_url", resource.getLocation().toOSString());
        workingCopy.setAttribute("attr_base_url", this.getBaseURL(resource));
        workingCopy.setAttribute("debug_port", String.valueOf(ChromiumUtil.getRandomOpenPort()));
        DebugUITools.launch((ILaunchConfiguration)workingCopy, (String)mode);
    }

    private String getBaseURL(IResource r) throws MalformedURLException {
        return r.getParent().getLocation().toFile().toURI().toURL().toString();
    }
}

