/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDefault;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASERule;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESchema;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEUserDefinedTypeImpl;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

public class SybaseASECatalogUserDefinedType
extends SybaseASEUserDefinedTypeImpl
implements ICatalogObject,
IAdaptable {
    public static final int BATCH_LOAD_THRESHHOLD = 10;
    private static final long serialVersionUID = 9187374515403919324L;
    private Boolean typeInfoLoaded = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.isNeedRefresh()) {
            Boolean bl = this.typeInfoLoaded;
            synchronized (bl) {
                if (this.typeInfoLoaded.booleanValue()) {
                    this.typeInfoLoaded = Boolean.FALSE;
                    super.setBoundDefault(null);
                    super.setBoundRule(null);
                }
            }
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASEDefault getBoundDefault() {
        Boolean bl = this.typeInfoLoaded;
        synchronized (bl) {
            if (!this.typeInfoLoaded.booleanValue()) {
                this.loadTypeInfo();
            }
        }
        return super.getBoundDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASERule getBoundRule() {
        Boolean bl = this.typeInfoLoaded;
        synchronized (bl) {
            if (!this.typeInfoLoaded.booleanValue()) {
                this.loadTypeInfo();
            }
        }
        return super.getBoundRule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowNulls() {
        Boolean bl = this.typeInfoLoaded;
        synchronized (bl) {
            if (!this.typeInfoLoaded.booleanValue()) {
                this.loadTypeInfo();
            }
        }
        return super.isAllowNulls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdentity() {
        Boolean bl = this.typeInfoLoaded;
        synchronized (bl) {
            if (!this.typeInfoLoaded.booleanValue()) {
                this.loadTypeInfo();
            }
        }
        return super.isIdentity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredefinedDataType getPredefinedRepresentation() {
        Boolean bl = this.typeInfoLoaded;
        synchronized (bl) {
            if (!this.typeInfoLoaded.booleanValue()) {
                this.loadTypeInfo();
            }
        }
        return super.getPredefinedRepresentation();
    }

    private void loadTypeInfo() {
        block15: {
            if (this.typeInfoLoaded.booleanValue()) {
                return;
            }
            int notLoaded = 0;
            boolean batch = false;
            ArrayList allUDTs = new ArrayList();
            for (Schema s : this.getSchema().getCatalog().getSchemas()) {
                allUDTs.addAll(s.getUserDefinedTypes());
            }
            for (SybaseASECatalogUserDefinedType udt : allUDTs) {
                if (udt.typeInfoLoaded.booleanValue() || ++notLoaded < 10) continue;
                batch = true;
                break;
            }
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    Catalog catalog = this.getSchema().getCatalog();
                    String catalogName = catalog.getName();
                    conn.setCatalog(catalogName);
                    String query = batch ? "SELECT U.name owner_name,T.name udt_name, PHY.name udt_sys_name, T.length udt_length, T.prec udt_precision, T.scale udt_scale, T.allownulls udt_allow_nulls, T.ident udt_is_identity, (select name FROM sysusers where uid=(SELECT uid from sysobjects where id = T.tdefault)) default_owner, object_name(T.tdefault,db_id(?)) udt_default_name, (SELECT RO.name FROM sysusers RO WHERE RO.uid = (SELECT uid from sysobjects where id  = T.domain OR id = T.accessrule)) rule_owner, object_name((case when T.domain<>0 then T.domain else T.accessrule end),db_id(?)) udt_rule_name FROM  systypes T, sysusers U, systypes PHY where T.uid = U.uid AND PHY.usertype =(SELECT min(usertype) FROM systypes WHERE type = T.type )  and T.type = PHY.type and T.name != PHY.name" : "SELECT U.name owner_name,T.name udt_name, PHY.name udt_sys_name, T.length udt_length, T.prec udt_precision, T.scale udt_scale, T.allownulls udt_allow_nulls, T.ident udt_is_identity, (select name FROM sysusers where uid=(SELECT uid from sysobjects where id = T.tdefault)) default_owner, object_name(T.tdefault,db_id(?)) udt_default_name, (SELECT RO.name FROM sysusers RO WHERE RO.uid = (SELECT uid from sysobjects where id  = T.domain OR id = T.accessrule)) rule_owner, object_name((case when T.domain<>0 then T.domain else T.accessrule end),db_id(?)) udt_rule_name FROM  systypes T, sysusers U, systypes PHY where T.name = ? and T.uid = U.uid AND PHY.usertype =(SELECT min(usertype) FROM systypes WHERE type = T.type )  and T.type = PHY.type";
                    stmt = conn.prepareStatement(query);
                    stmt.setString(1, catalogName);
                    stmt.setString(2, catalogName);
                    if (!batch) {
                        stmt.setString(3, this.getName());
                    }
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String udtName = rs.getString(2);
                        String udtSysName = rs.getString(3);
                        int udtLength = rs.getString(4) == null ? 0 : Integer.valueOf(rs.getString(4));
                        int udtPrecision = rs.getString(5) == null ? 0 : Integer.valueOf(rs.getString(5));
                        int udtScale = rs.getString(6) == null ? 0 : Integer.valueOf(rs.getString(6));
                        boolean isAllowNulls = rs.getBoolean(7);
                        boolean isIdentity = rs.getBoolean(8);
                        String defaultOwner = rs.getString(9);
                        String defaultName = rs.getString(10);
                        String ruleOwner = rs.getString(11);
                        String ruleName = rs.getString(12);
                        SybaseASECatalogUserDefinedType udt = (SybaseASECatalogUserDefinedType)ASEUtil.getSQLObject(allUDTs, udtName);
                        if (udt == null || udt.typeInfoLoaded.booleanValue()) continue;
                        boolean deliver = udt.eDeliver();
                        udt.eSetDeliver(false);
                        if (udtSysName != null) {
                            PredefinedDataType type = SybaseASECatalogUtils.getASEPredefinedType(udtLength, udtPrecision, udtScale, 0, udtSysName, RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(udt.getSchema().getDatabase()));
                            udt.setPredefinedRepresentation(type);
                        }
                        if (defaultOwner != null && defaultName != null) {
                            SybaseASESchema defaultSchema = (SybaseASESchema)ASEUtil.getSQLObject((Collection)catalog.getSchemas(), defaultOwner);
                            SybaseASEDefault bindDefault = (SybaseASEDefault)ASEUtil.getSQLObject((Collection)defaultSchema.getDefaults(), defaultName);
                            if (bindDefault == null) {
                                bindDefault = (SybaseASEDefault)ASEUtil.getSQLObject((Collection)defaultSchema.getDefaults(), "\"" + defaultName + "\"");
                            }
                            udt.setBoundDefault(bindDefault);
                        }
                        if (ruleOwner != null && ruleName != null) {
                            SybaseASESchema ruleSchema = (SybaseASESchema)ASEUtil.getSQLObject((Collection)catalog.getSchemas(), ruleOwner);
                            SybaseASERule bindRule = (SybaseASERule)ASEUtil.getSQLObject((Collection)ruleSchema.getRules(), ruleName);
                            if (bindRule == null) {
                                bindRule = (SybaseASERule)ASEUtil.getSQLObject((Collection)ruleSchema.getRules(), "\"" + ruleName + "\"");
                            }
                            udt.setBoundRule(bindRule);
                        }
                        udt.setAllowNulls(isAllowNulls);
                        udt.setIdentity(isIdentity);
                        udt.eSetDeliver(deliver);
                        udt.typeInfoLoaded = Boolean.TRUE;
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    private boolean isNeedRefresh() {
        return this.typeInfoLoaded;
    }
}

