/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.ibm.util.ClientConfiguration;
import org.eclipse.datatools.enablement.ibm.util.IClientStrategy;
import org.eclipse.emf.ecore.EObject;

public class ClientStrategyService {
    private static final String EXTENSION_POINT_ID = "com.ibm.datatools.core.loadStrategy";
    private static final String STRATEGY = "strategy";
    private static final String CLIENT = "clientDefinition";
    private static final String VENDOR = "vendor";
    private static final String DEFAULT_STRATEGY = "defaultStrategy";
    private static ClientStrategyService service;
    private static final int STRATEGY_MAP_SIZE = 16;
    private static final HashMap<String, IClientStrategy> strategies;

    static {
        strategies = new HashMap(16);
    }

    private ClientStrategyService() {
    }

    public static synchronized ClientStrategyService getInstance() {
        if (service == null) {
            service = new ClientStrategyService();
        }
        return service;
    }

    public IClientStrategy getClientStrategy(EObject object, ClientConfiguration configuration) {
        String vendorClientKey;
        IClientStrategy strategy;
        String vendor = "";
        if (!(object instanceof ICatalogObject) || ((ICatalogObject)object).getCatalogDatabase() == null) {
            return null;
        }
        vendor = ((ICatalogObject)object).getCatalogDatabase().getVendor();
        String client = "";
        if (configuration != null) {
            client = configuration.getClientConfiguration();
        }
        if ((strategy = strategies.get(vendorClientKey = this.generateVendorClientKey(vendor, client))) == null && !strategies.containsKey(vendorClientKey)) {
            strategy = this.lookupStrategyInRegistry(vendor, client);
        }
        return strategy;
    }

    private IClientStrategy lookupStrategyInRegistry(String vendor, String client) {
        IExtension[] extensions;
        String vendorClientKey = this.generateVendorClientKey(vendor, client);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(STRATEGY)) {
                    try {
                        String clientDefinitionAttribute = element.getAttribute(CLIENT);
                        String vendorAttribute = element.getAttribute(VENDOR);
                        if (vendorAttribute != null && clientDefinitionAttribute != null && vendorAttribute.equals(vendor) && clientDefinitionAttribute.equals(client)) {
                            IClientStrategy strategy = null;
                            if (element.getAttribute(DEFAULT_STRATEGY) != null) {
                                strategy = (IClientStrategy)element.createExecutableExtension(DEFAULT_STRATEGY);
                                strategies.put(vendorClientKey, strategy);
                            }
                            return strategy;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        strategies.put(vendorClientKey, null);
        return null;
    }

    private String generateVendorClientKey(String vendor, String client) {
        return String.valueOf(vendor) + "::" + client;
    }
}

