/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.docker.launcher.ContainerPropertyVolumesModel;
import org.eclipse.cdt.internal.docker.launcher.DataVolumeModel;
import org.eclipse.cdt.internal.docker.launcher.SWTImagesFactory;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardUtils;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ContainerDataVolumeDialog
extends Dialog {
    private final DataVolumeModel model;
    private final DataBindingContext dbc = new DataBindingContext();
    private final List<String> containerNames;
    private final IDockerConnection connection;

    public ContainerDataVolumeDialog(Shell parentShell, IDockerConnection connection, DataVolumeModel selectedDataVolume) {
        super(parentShell);
        this.connection = connection;
        this.model = new DataVolumeModel(selectedDataVolume);
        this.containerNames = WizardUtils.getContainerNames((IDockerConnection)connection);
    }

    public ContainerDataVolumeDialog(Shell parentShell, IDockerConnection connection) {
        super(parentShell);
        this.connection = connection;
        this.model = new DataVolumeModel();
        this.containerNames = WizardUtils.getContainerNames((IDockerConnection)connection);
    }

    public DataVolumeModel getDataVolume() {
        return this.model;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.title"));
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            button.setEnabled(false);
        }
        return button;
    }

    protected Point getInitialSize() {
        return new Point(450, super.getInitialSize().y);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        int COLUMNS = 3;
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(3).applyTo(container);
        Label containerPathLabel = new Label(container, 0);
        containerPathLabel.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.containerPathLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)containerPathLabel);
        Text containerPathText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)containerPathText);
        IObservableValue containerPathObservable = BeanProperties.value(DataVolumeModel.class, (String)"containerPath").observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)containerPathText), containerPathObservable);
        Label explanationLabel = new Label(container, 0);
        explanationLabel.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.explanationLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)explanationLabel);
        int INDENT = 20;
        Button noMountButton = new Button(container, 16);
        noMountButton.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.noMountButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).span(3, 1).grab(true, false).applyTo((Control)noMountButton);
        this.bindButton(noMountButton, ContainerPropertyVolumesModel.MountType.NONE, new Control[0]);
        Button fileSystemMountButton = new Button(container, 16);
        fileSystemMountButton.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.fileSystemMountButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).span(3, 1).grab(true, false).applyTo((Control)fileSystemMountButton);
        Label hostPathLabel = new Label(container, 0);
        hostPathLabel.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.hostPathLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(40, -1).grab(false, false).applyTo((Control)hostPathLabel);
        Text hostPathText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)hostPathText);
        IObservableValue hostPathObservable = BeanProperties.value(DataVolumeModel.class, (String)"hostPathMount").observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)hostPathText), hostPathObservable);
        Button hostPathDirectoryButton = new Button(container, 0);
        hostPathDirectoryButton.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.directoryButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)hostPathDirectoryButton);
        hostPathDirectoryButton.addSelectionListener(this.onHostDirectoryPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)new Label(container, 0));
        Button readOnlyButton = new Button(container, 32);
        readOnlyButton.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.readOnlyButton"));
        readOnlyButton.setToolTipText(WizardMessages.getString((String)"ContainerDataVolumeDialog.readOnlyButtonTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)readOnlyButton);
        ISWTObservableValue readOnlyButtonObservable = WidgetProperties.selection().observe((Widget)readOnlyButton);
        this.dbc.bindValue((IObservableValue)readOnlyButtonObservable, BeanProperties.value(DataVolumeModel.class, (String)"readOnly").observe((Object)this.model));
        Button hostPathFileButton = new Button(container, 0);
        hostPathFileButton.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.fileButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)hostPathFileButton);
        hostPathFileButton.addSelectionListener(this.onHostFilePath());
        this.bindButton(fileSystemMountButton, ContainerPropertyVolumesModel.MountType.HOST_FILE_SYSTEM, new Control[]{hostPathText, hostPathDirectoryButton, hostPathFileButton, readOnlyButton});
        Button containerMountButton = new Button(container, 16);
        containerMountButton.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.containerMountButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).span(3, 1).grab(true, false).applyTo((Control)containerMountButton);
        Label containerSelectionLabel = new Label(container, 0);
        containerSelectionLabel.setText(WizardMessages.getString((String)"ContainerDataVolumeDialog.containerSelectionLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(40, -1).applyTo((Control)containerSelectionLabel);
        Combo containerSelectionCombo = new Combo(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)containerSelectionCombo);
        new ControlDecoration((Control)containerSelectionCombo, 16512);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)new Label(container, 0));
        this.bindButton(containerMountButton, ContainerPropertyVolumesModel.MountType.CONTAINER, new Control[]{containerSelectionCombo});
        ComboViewer containerSelectionComboViewer = new ComboViewer(containerSelectionCombo);
        containerSelectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        containerSelectionComboViewer.setInput(this.containerNames);
        IObservableValue selectedContainerObservable = BeanProperties.value(DataVolumeModel.class, (String)"containerMount").observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)containerSelectionCombo), selectedContainerObservable);
        new ContentProposalAdapter((Control)containerSelectionCombo, (IControlContentAdapter)new ComboContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                Combo combo = (Combo)control;
                Point selection = combo.getSelection();
                combo.setText(text);
                selection.y = selection.x = text.length();
                combo.setSelection(selection);
            }
        }, this.getContainerNameContentProposalProvider(containerSelectionCombo), null, null);
        Composite errorContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).grab(true, true).applyTo((Control)errorContainer);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo(errorContainer);
        Label errorMessageIcon = new Label(errorContainer, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(20, -1).applyTo((Control)errorMessageIcon);
        Label errorMessageLabel = new Label(errorContainer, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)errorMessageLabel);
        this.setupValidationSupport(errorMessageIcon, errorMessageLabel);
        return container;
    }

    private void setupValidationSupport(Label errorMessageIcon, Label errorMessageLabel) {
        for (Binding binding : this.dbc.getBindings()) {
            binding.getModel().addChangeListener(this.onDataVolumeSettingsChanged(errorMessageIcon, errorMessageLabel));
        }
    }

    private Binding bindButton(final Button button, final ContainerPropertyVolumesModel.MountType mountType, final Control ... controls) {
        return this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)button), BeanProperties.value(DataVolumeModel.class, (String)"mountType").observe((Object)this.model), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value.equals(Boolean.TRUE)) {
                    this.setEnabled(controls, true);
                    return mountType;
                }
                this.setEnabled(controls, false);
                return null;
            }

            private void setEnabled(Control[] controls2, boolean enabled) {
                Control[] controlArray = controls2;
                int n = controls2.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.setEnabled(enabled);
                    ++n2;
                }
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (mountType.equals(value)) {
                    button.setEnabled(true);
                }
                return mountType.equals(value);
            }
        });
    }

    private SelectionListener onHostDirectoryPath() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
            String selectedPath = directoryDialog.open();
            if (selectedPath != null) {
                this.model.setHostPathMount(selectedPath);
            }
        });
    }

    private SelectionListener onHostFilePath() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog fileDialog = new FileDialog(this.getShell());
            String selectedPath = fileDialog.open();
            if (selectedPath != null) {
                this.model.setHostPathMount(selectedPath);
            }
        });
    }

    private IContentProposalProvider getContainerNameContentProposalProvider(Combo containerSelectionCombo) {
        return (contents, position) -> {
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            String[] stringArray = containerSelectionCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String containerName = stringArray[n2];
                if (containerName.contains(contents)) {
                    proposals.add(new ContentProposal(containerName, containerName, containerName, position));
                }
                ++n2;
            }
            return proposals.toArray(new IContentProposal[0]);
        };
    }

    private IChangeListener onDataVolumeSettingsChanged(Label errorMessageIcon, Label errorMessageLabel) {
        return event -> {
            if (Display.getCurrent() == null || this.getShell().isDisposed()) {
                return;
            }
            IStatus status = this.validateInput();
            Display.getCurrent().syncExec(() -> {
                if (status.isOK()) {
                    errorMessageIcon.setVisible(false);
                    errorMessageLabel.setVisible(false);
                    this.setOkButtonEnabled(true);
                } else if (status.matches(2)) {
                    errorMessageIcon.setVisible(true);
                    errorMessageIcon.setImage(SWTImagesFactory.DESC_WARNING.createImage());
                    errorMessageLabel.setVisible(true);
                    errorMessageLabel.setText(status.getMessage());
                    this.setOkButtonEnabled(true);
                } else if (status.matches(4)) {
                    if (status.getMessage() != null && !status.getMessage().isEmpty()) {
                        errorMessageIcon.setVisible(true);
                        errorMessageIcon.setImage(SWTImagesFactory.DESC_ERROR.createImage());
                        errorMessageLabel.setVisible(true);
                        errorMessageLabel.setText(status.getMessage());
                    }
                    this.setOkButtonEnabled(false);
                }
            });
        };
    }

    private IStatus validateInput() {
        String containerPath = this.model.getContainerPath();
        ContainerPropertyVolumesModel.MountType mountType = this.model.getMountType();
        String hostPath = this.model.getHostPathMount();
        if (containerPath == null || containerPath.isEmpty()) {
            return ValidationStatus.error(null);
        }
        if (mountType == null) {
            return ValidationStatus.error(null);
        }
        if (mountType == ContainerPropertyVolumesModel.MountType.HOST_FILE_SYSTEM && (hostPath == null || hostPath.isEmpty())) {
            return ValidationStatus.error(null);
        }
        if (mountType == ContainerPropertyVolumesModel.MountType.HOST_FILE_SYSTEM && !new File(hostPath).exists()) {
            return ValidationStatus.warning((String)"The specified path does not exist on the host.");
        }
        if (mountType == ContainerPropertyVolumesModel.MountType.CONTAINER) {
            IDockerContainer container = WizardUtils.getContainer((IDockerConnection)this.connection, (String)this.model.getContainerMount());
            if (container == null) {
                return ValidationStatus.error(null);
            }
            IDockerContainerInfo selectedContainerInfo = container.info();
            if (selectedContainerInfo != null && selectedContainerInfo.volumes() != null && !selectedContainerInfo.volumes().containsKey(this.model.getContainerPath())) {
                return ValidationStatus.warning((String)WizardMessages.getFormattedString((String)"ContainerDataVolumeDialog.volumeWarning", (String)this.model.getContainerPath()));
            }
        }
        return ValidationStatus.ok();
    }

    private void setOkButtonEnabled(boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }
}

