/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.perspective.SelectDatabaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SelectActiveSchemaHandler
extends AbstractDataSourceHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBPDataSourceContainer dataSourceContainer = DataSourceToolbarUtils.getCurrentDataSource(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
        if (dataSourceContainer == null) {
            log.debug((Object)"No active connection. Action is in disabled state.");
            return null;
        }
        DatabaseListReader databaseListReader = new DatabaseListReader(dataSourceContainer.getDataSource());
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)databaseListReader);
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Schema list", "Error reading schema list", e.getTargetException());
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        DBNDatabaseNode selectedDB = null;
        for (DBNDatabaseNode node : databaseListReader.nodeList) {
            if (node.getObject() != databaseListReader.active) continue;
            selectedDB = node;
        }
        SelectDatabaseDialog dialog = new SelectDatabaseDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), dataSourceContainer, databaseListReader.currentDatabaseInstanceName, databaseListReader.nodeList, selectedDB == null ? null : Collections.singletonList(selectedDB));
        dialog.setModeless(true);
        if (dialog.open() == 1) {
            return null;
        }
        DBNDatabaseNode node = (DBNDatabaseNode)dialog.getSelectedObject();
        if (node != null && node != databaseListReader.active) {
            SelectActiveSchemaHandler.changeDataBaseSelection(dataSourceContainer, databaseListReader.currentDatabaseInstanceName, dialog.getCurrentInstanceName(), node.getNodeName());
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        String schemaName = "<No active connection>";
        DBIcon schemaIcon = DBIcon.TREE_SCHEMA;
        String schemaTooltip = CoreMessages.toolbar_datasource_selector_combo_database_tooltip;
        DBPDataSourceContainer dataSource = DataSourceToolbarUtils.getCurrentDataSource(workbenchWindow);
        if (dataSource != null && dataSource.isConnected()) {
            schemaName = "<no schema>";
            DBSObject[] defObjects = SelectActiveSchemaHandler.getSelectedSchema(dataSource);
            if (defObjects.length > 0) {
                schemaIcon = DBIcon.TREE_SCHEMA;
                schemaName = defObjects.length == 1 ? defObjects[0].getName() : String.valueOf(defObjects[1].getName()) + "@" + defObjects[0].getName();
            }
        }
        element.setText(schemaName);
        element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)schemaIcon));
        element.setTooltip(schemaTooltip);
    }

    public static DBSObject[] getSelectedSchema(DBPDataSourceContainer dataSource) {
        DBSObjectSelector objectSelector2;
        DBSObject firstContainer = null;
        DBSObject secondContainer = null;
        DBSObjectSelector objectSelector = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)dataSource);
        if (objectSelector != null && objectSelector.supportsDefaultChange() && (firstContainer = objectSelector.getDefaultObject()) instanceof DBSObjectContainer && (objectSelector2 = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)firstContainer)) != null && objectSelector2.supportsDefaultChange()) {
            secondContainer = objectSelector2.getDefaultObject();
        }
        if (firstContainer == null && secondContainer == null) {
            return new DBSObject[0];
        }
        if (secondContainer == null) {
            return new DBSObject[]{firstContainer};
        }
        return new DBSObject[]{firstContainer, secondContainer};
    }

    private static void changeDataBaseSelection(DBPDataSourceContainer dsContainer, final @Nullable String curInstanceName, final @Nullable String newInstanceName, final @NotNull String newSchemaName) {
        if (dsContainer != null && dsContainer.isConnected()) {
            final DBPDataSource dataSource = dsContainer.getDataSource();
            new AbstractJob("Change active database"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        DBSObject newChild;
                        DBSObjectContainer oc = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
                        DBSObjectSelector os = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)dataSource);
                        if (os != null) {
                            DBSObjectSelector os2;
                            DBSObject defObject;
                            DBSObject newInstance;
                            if (newInstanceName != null && !CommonUtils.equalObjects((Object)curInstanceName, (Object)newInstanceName) && (newInstance = oc.getChild(monitor, newInstanceName)) != null) {
                                os.setDefaultObject(monitor, newInstance);
                            }
                            if ((defObject = os.getDefaultObject()) instanceof DBSObjectContainer && (os2 = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)defObject)) != null && os2.supportsDefaultChange()) {
                                oc = (DBSObjectContainer)defObject;
                                os = os2;
                            }
                        }
                        if (oc != null && os != null && os.supportsDefaultChange()) {
                            newChild = oc.getChild(monitor, newSchemaName);
                            if (newChild == null) {
                                throw new DBException(MessageFormat.format(CoreMessages.toolbar_datasource_selector_error_database_not_found, newSchemaName));
                            }
                        } else {
                            throw new DBException(CoreMessages.toolbar_datasource_selector_error_database_change_not_supported);
                        }
                        os.setDefaultObject(monitor, newChild);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private static class DatabaseListReader
    implements DBRRunnableWithProgress {
        private final DBPDataSource dataSource;
        private final List<DBNDatabaseNode> nodeList = new ArrayList<DBNDatabaseNode>();
        private DBSObject active;
        private boolean enabled;
        private String currentDatabaseInstanceName;

        DatabaseListReader(DBPDataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            DBSObjectContainer objectContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)this.dataSource);
            DBSObjectSelector objectSelector = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)this.dataSource);
            if (objectContainer == null || objectSelector == null) {
                return;
            }
            try {
                try {
                    monitor.beginTask(CoreMessages.toolbar_datasource_selector_action_read_databases, 1);
                    this.currentDatabaseInstanceName = null;
                    Class childType = objectContainer.getChildType(monitor);
                    if (childType == null || !DBSObjectContainer.class.isAssignableFrom(childType)) {
                        this.enabled = false;
                    } else {
                        this.enabled = true;
                        DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
                        DBSObject defObject = objectSelector.getDefaultObject();
                        if (defObject instanceof DBSObjectContainer && (objectSelector = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)defObject)) != null && objectSelector.supportsDefaultChange()) {
                            this.currentDatabaseInstanceName = defObject.getName();
                            objectContainer = (DBSObjectContainer)defObject;
                            defObject = objectSelector.getDefaultObject();
                        }
                        Collection children = objectContainer.getChildren(monitor);
                        this.active = defObject;
                        if (children != null) {
                            for (DBSObject child : children) {
                                DBNDatabaseNode node;
                                if (DBUtils.getAdapter(DBSObjectContainer.class, (Object)child) == null || (node = navigatorModel.getNodeByObject(monitor, child, false)) == null) continue;
                                this.nodeList.add(node);
                            }
                        }
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public static class MenuContributor
    extends DataSourceMenuContributor {
        @Override
        protected void fillContributionItems(List<IContributionItem> menuItems) {
            final DBPDataSourceContainer dataSourceContainer = DataSourceToolbarUtils.getCurrentDataSource(UIUtils.getActiveWorkbenchWindow());
            if (dataSourceContainer == null) {
                return;
            }
            final DatabaseListReader databaseListReader = new DatabaseListReader(dataSourceContainer.getDataSource());
            try {
                UIUtils.runInProgressService((DBRRunnableWithProgress)databaseListReader);
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Schema list", "Error reading schema list", e.getTargetException());
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            final DBSObject[] defObjects = SelectActiveSchemaHandler.getSelectedSchema(dataSourceContainer);
            for (final DBNDatabaseNode node : databaseListReader.nodeList) {
                menuItems.add((IContributionItem)new ActionContributionItem((IAction)new Action(node.getName(), 2){
                    {
                        super($anonymous0, $anonymous1);
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)dBNDatabaseNode.getNodeIcon()));
                    }

                    public boolean isChecked() {
                        return ArrayUtils.contains((Object[])defObjects, (Object)node.getObject());
                    }

                    public void run() {
                        SelectActiveSchemaHandler.changeDataBaseSelection(dataSourceContainer, databaseListReader.currentDatabaseInstanceName, databaseListReader.currentDatabaseInstanceName, node.getNodeName());
                    }
                }));
            }
        }
    }
}

