/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird;

import java.lang.reflect.InvocationTargetException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTrigger;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTriggerType;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class FireBirdUtils {
    private static final Log log = Log.getLog(FireBirdUtils.class);
    private static Pattern VERSION_PATTERN = Pattern.compile(".+\\-V([0-9]+\\.[0-9]+\\.[0-9]+).+");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProcedureSource(DBRProgressMonitor monitor, GenericProcedure procedure) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)procedure, (String)"Load procedure source code");
                try {
                    DatabaseMetaData fbMetaData = session.getOriginal().getMetaData();
                    String source = (String)fbMetaData.getClass().getMethod("getProcedureSourceCode", String.class).invoke((Object)fbMetaData, procedure.getName());
                    if (CommonUtils.isEmpty((String)source)) {
                        return null;
                    }
                    return FireBirdUtils.getProcedureSourceWithHeader(monitor, procedure, source);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (session == null) return null;
                    session.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't read source code of procedure '" + procedure.getName() + "'", (Throwable)e);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getViewSource(DBRProgressMonitor monitor, GenericTable view) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)view, (String)"Load view source code");
                try {
                    DatabaseMetaData fbMetaData = session.getOriginal().getMetaData();
                    String source = (String)fbMetaData.getClass().getMethod("getViewSourceCode", String.class).invoke((Object)fbMetaData, view.getName());
                    if (CommonUtils.isEmpty((String)source)) {
                        return null;
                    }
                    return FireBirdUtils.getViewSourceWithHeader(monitor, view, source);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (session == null) return null;
                    session.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't read source code of view '" + view.getName() + "'", (Throwable)e);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTriggerSource(DBRProgressMonitor monitor, FireBirdTrigger trigger) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)trigger, (String)"Load trigger source code");
                try {
                    DatabaseMetaData fbMetaData = session.getOriginal().getMetaData();
                    String source = (String)fbMetaData.getClass().getMethod("getTriggerSourceCode", String.class).invoke((Object)fbMetaData, trigger.getName());
                    if (CommonUtils.isEmpty((String)source)) {
                        return null;
                    }
                    return FireBirdUtils.getTriggerSourceWithHeader(monitor, trigger, source);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (session == null) return null;
                    session.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't read source code of trigger '" + trigger.getName() + "'", (Throwable)e);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    public static String getProcedureSourceWithHeader(DBRProgressMonitor monitor, GenericProcedure procedure, String source) throws DBException {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE OR ALTER PROCEDURE ").append(procedure.getName()).append(" ");
        Collection parameters = procedure.getParameters(monitor);
        if (parameters != null && !parameters.isEmpty()) {
            GenericProcedureParameter param;
            ArrayList<GenericProcedureParameter> args = new ArrayList<GenericProcedureParameter>();
            ArrayList<GenericProcedureParameter> results = new ArrayList<GenericProcedureParameter>();
            for (GenericProcedureParameter param2 : parameters) {
                if (param2.getParameterKind() == DBSProcedureParameterKind.OUT || param2.getParameterKind() == DBSProcedureParameterKind.RETURN) {
                    results.add(param2);
                    continue;
                }
                args.add(param2);
            }
            if (!args.isEmpty()) {
                sql.append("(");
                int i = 0;
                while (i < args.size()) {
                    param = (GenericProcedureParameter)args.get(i);
                    if (i > 0) {
                        sql.append(", ");
                    }
                    FireBirdUtils.printParam(sql, param);
                    ++i;
                }
                sql.append(")\n");
            }
            if (!results.isEmpty()) {
                sql.append("RETURNS (\n");
                int i = 0;
                while (i < results.size()) {
                    sql.append('\t');
                    param = (GenericProcedureParameter)results.get(i);
                    FireBirdUtils.printParam(sql, param);
                    if (i < results.size() - 1) {
                        sql.append(",");
                    }
                    sql.append('\n');
                    ++i;
                }
                sql.append(")\n");
            }
        }
        sql.append("AS\n").append(source);
        return sql.toString();
    }

    private static void printParam(StringBuilder sql, GenericProcedureParameter param) {
        sql.append(DBUtils.getQuotedIdentifier((DBSObject)param)).append(" ").append(param.getTypeName());
        if (param.getDataKind() == DBPDataKind.STRING) {
            sql.append("(").append(param.getMaxLength()).append(")");
        }
    }

    public static String getViewSourceWithHeader(DBRProgressMonitor monitor, GenericTable view, String source) throws DBException {
        Version version = FireBirdUtils.getFireBirdServerVersion(view.getDataSource());
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (version.getMajor() > 2 || version.getMajor() == 2 && version.getMinor() >= 5) {
            sql.append("OR ALTER ");
        }
        sql.append("VIEW ").append(view.getName()).append(" ");
        List columns = view.getAttributes(monitor);
        if (columns != null) {
            sql.append("(");
            boolean first = true;
            for (GenericTableColumn column : columns) {
                if (!first) {
                    sql.append(", ");
                }
                first = false;
                sql.append(DBUtils.getQuotedIdentifier((DBSObject)column));
            }
            sql.append(")\n");
        }
        sql.append("AS\n").append(source);
        return sql.toString();
    }

    public static String getTriggerSourceWithHeader(DBRProgressMonitor monitor, FireBirdTrigger trigger, String source) throws DBException {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TRIGGER ").append(trigger.getName()).append(" ");
        FireBirdTriggerType type = trigger.getType();
        if (type.isDbEvent()) {
            sql.append(type.getDisplayName());
        } else if (trigger.getTable() != null) {
            sql.append("FOR ").append(DBUtils.getQuotedIdentifier((DBSObject)trigger.getTable()));
            sql.append(" ").append(type.getDisplayName());
        }
        sql.append("\n").append(source);
        return sql.toString();
    }

    public static String getPlan(JDBCPreparedStatement statement) {
        String plan = "";
        try {
            plan = (String)statement.getOriginal().getClass().getMethod("getExecutionPlan", new Class[0]).invoke((Object)statement.getOriginal(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return plan;
    }

    public static Version getFireBirdServerVersion(DBPDataSource dataSource) {
        String versionInfo = dataSource.getInfo().getDatabaseProductVersion();
        Matcher matcher = VERSION_PATTERN.matcher(versionInfo);
        if (matcher.matches()) {
            return new Version(matcher.group(1));
        }
        return new Version(0, 0, 0);
    }
}

