/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import java.util.List;
import java.util.TreeSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCAttribute;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCTableColumn<TABLE_TYPE extends DBSEntity>
extends JDBCAttribute
implements DBSTableColumn,
DBSEntityAttribute,
DBSAttributeEnumerable,
DBPSaveableObject {
    private final TABLE_TYPE table;
    private boolean persisted;
    private String defaultValue;

    protected JDBCTableColumn(TABLE_TYPE table, boolean persisted) {
        this.table = table;
        this.persisted = persisted;
    }

    protected JDBCTableColumn(TABLE_TYPE table, boolean persisted, String name, String typeName, int valueType, int ordinalPosition, long maxLength, Integer scale, Integer precision, boolean required, boolean autoGenerated, String defaultValue) {
        super(name, typeName, valueType, ordinalPosition, maxLength, scale, precision, required, autoGenerated);
        this.defaultValue = defaultValue;
        this.table = table;
        this.persisted = persisted;
    }

    protected JDBCTableColumn(TABLE_TYPE table, DBSEntityAttribute source, boolean persisted) {
        super(source);
        this.table = table;
        this.persisted = persisted;
        this.defaultValue = source.getDefaultValue();
    }

    public TABLE_TYPE getTable() {
        return this.table;
    }

    @NotNull
    public TABLE_TYPE getParentObject() {
        return this.getTable();
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=10)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, editable=true, order=20, listProvider=ColumnTypeNameListProvider.class)
    public String getTypeName() {
        return super.getTypeName();
    }

    @Override
    public void setTypeName(String typeName) {
        super.setTypeName(typeName);
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource instanceof DBPDataTypeProvider) {
            DBSDataType dataType = ((DBPDataTypeProvider)((Object)dataSource)).getLocalDataType(typeName);
            if (dataType != null) {
                this.updateColumnDataType(dataType);
            } else {
                this.updateColumnDataType(null);
            }
        }
    }

    protected void updateColumnDataType(@Nullable DBSDataType dataType) {
        if (dataType != null) {
            this.valueType = dataType.getTypeID();
        }
    }

    @Override
    @Property(viewable=true, editable=true, order=40)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    @Override
    @Property(viewable=true, editable=true, order=50)
    public boolean isRequired() {
        return super.isRequired();
    }

    @Override
    @Property(viewable=true, editable=true, order=70)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public List<DBDLabelValuePair> getValueEnumeration(@NotNull DBCSession session, @Nullable Object valuePattern, int maxResults) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class ColumnTypeNameListProvider
    implements IPropertyValueListProvider<JDBCTableColumn> {
        @Override
        public boolean allowCustomValue() {
            return true;
        }

        @Override
        public Object[] getPossibleValues(JDBCTableColumn column) {
            TreeSet<String> typeNames = new TreeSet<String>();
            if (column.getDataSource() instanceof DBPDataTypeProvider) {
                for (DBSDataType dBSDataType : ((DBPDataTypeProvider)((Object)column.getDataSource())).getLocalDataTypes()) {
                    if (dBSDataType.getDataKind() == DBPDataKind.UNKNOWN || CommonUtils.isEmpty((String)dBSDataType.getName()) || !Character.isLetter(dBSDataType.getName().charAt(0))) continue;
                    typeNames.add(dBSDataType.getName());
                }
            }
            return typeNames.toArray(new String[typeNames.size()]);
        }
    }
}

