/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.dialogs;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.GenerateSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener;

public abstract class GenerateMultiSQLDialog<T extends DBSObject>
extends GenerateSQLDialog {
    private static final Log log = Log.getLog(GenerateMultiSQLDialog.class);
    private static final String DIALOG_ID = "GenerateMultiSQLDialog";
    protected final Collection<T> selectedObjects;
    private Table objectsTable;

    public GenerateMultiSQLDialog(IWorkbenchPartSite partSite, String title, Collection<T> objects, boolean meta) {
        this(partSite, GenerateMultiSQLDialog.getContextFromObjects(objects, meta), title, objects);
    }

    public GenerateMultiSQLDialog(IWorkbenchPartSite partSite, DBCExecutionContext context, String title, Collection<T> objects) {
        super(partSite, context, title, null);
        this.selectedObjects = objects;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String dialogClassName = ((Object)((Object)this)).getClass().getName();
        int divPos = dialogClassName.lastIndexOf(46);
        dialogClassName = divPos == -1 ? dialogClassName : dialogClassName.substring(divPos + 1);
        return UIUtils.getDialogSettings((String)("GenerateMultiSQLDialog." + dialogClassName));
    }

    protected abstract SQLScriptProgressListener<T> getScriptListener();

    @Override
    protected String[] generateSQLScript() {
        List<T> checkedObjects = this.getCheckedObjects();
        ArrayList<String> lines = new ArrayList<String>();
        for (DBSObject object : checkedObjects) {
            this.generateObjectCommand(lines, object);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public List<T> getCheckedObjects() {
        ArrayList<Object> checkedObjects = new ArrayList<Object>();
        if (this.objectsTable != null) {
            TableItem[] tableItemArray = this.objectsTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    checkedObjects.add((DBSObject)item.getData());
                }
                ++n2;
            }
        } else {
            checkedObjects.addAll(this.selectedObjects);
        }
        return checkedObjects;
    }

    protected void createObjectsSelector(Composite parent) {
        if (this.selectedObjects.size() < 2) {
            return;
        }
        UIUtils.createControlLabel((Composite)parent, (String)"Tables");
        this.objectsTable = new Table(parent, 2080);
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        this.objectsTable.setLayoutData((Object)gd);
        for (DBSObject table : this.selectedObjects) {
            TableItem item = new TableItem(this.objectsTable, 0);
            item.setText(DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.UI));
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_TABLE));
            item.setChecked(true);
            item.setData((Object)table);
        }
        this.objectsTable.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.objectsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean hasChecked = !GenerateMultiSQLDialog.this.getCheckedObjects().isEmpty();
                GenerateMultiSQLDialog.this.getButton(0).setEnabled(hasChecked);
                GenerateMultiSQLDialog.this.getButton(13).setEnabled(hasChecked);
            }
        });
    }

    @Override
    protected void executeSQL() {
        final String jobName = this.getShell().getText();
        final SQLScriptProgressListener<T> scriptListener = this.getScriptListener();
        final List<T> objects = this.getCheckedObjects();
        final LinkedHashMap<DBSObject, ArrayList<String>> objectsSQL = new LinkedHashMap<DBSObject, ArrayList<String>>();
        for (DBSObject object : objects) {
            ArrayList<String> lines = new ArrayList<String>();
            this.generateObjectCommand(lines, object);
            objectsSQL.put(object, lines);
        }
        DataSourceJob job = new DataSourceJob(jobName, this.getExecutionContext()){
            public Exception objectProcessingError;

            /*
             * Unable to fully structure code
             */
            protected IStatus run(DBRProgressMonitor monitor) {
                curJob = this;
                UIUtils.asyncExec((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener org.jkiss.dbeaver.runtime.jobs.DataSourceJob java.util.List ), ()V)((SQLScriptProgressListener)scriptListener, (DataSourceJob)curJob, (List)objects));
                monitor.beginTask(jobName, objects.size());
                try {
                    var3_3 = null;
                    var4_5 = null;
                    try {
                        session = this.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, jobName);
                        try {
                            if (GenerateMultiSQLDialog.this.isRunInSeparateTransaction()) {
                                GenerateMultiSQLDialog.access$1(GenerateMultiSQLDialog.this, session);
                            }
                            i = 0;
                            while (i < objects.size()) {
                                block40: {
                                    if (monitor.isCanceled()) break;
                                    objectNumber = i;
                                    object = (DBSObject)objects.get(i);
                                    monitor.subTask("Process " + DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI));
                                    this.objectProcessingError = null;
                                    UIUtils.asyncExec((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$2(org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener org.jkiss.dbeaver.model.struct.DBSObject int ), ()V)((SQLScriptProgressListener)scriptListener, (DBSObject)object, (int)objectNumber));
                                    try {
                                        try {
                                            lines = (List)objectsSQL.get(object);
                                            for (String line : lines) {
                                                var12_15 = null;
                                                var13_17 = null;
                                                try {
                                                    block38: {
                                                        statement = DBUtils.makeStatement((DBCSession)session, (String)line, (boolean)false);
                                                        try {
                                                            if (!statement.executeStatement()) ** GOTO lbl-1000
                                                            var15_20 = null;
                                                            var16_22 = null;
                                                            try {
                                                                resultSet = statement.openResultSet();
                                                                try {
                                                                    UIUtils.syncExec((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$4(org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener org.jkiss.dbeaver.model.struct.DBSObject org.jkiss.dbeaver.model.exec.DBCStatement org.jkiss.dbeaver.model.exec.DBCResultSet ), ()V)(this, (SQLScriptProgressListener)scriptListener, (DBSObject)object, (DBCStatement)statement, (DBCResultSet)resultSet));
                                                                    ** if (resultSet == null) goto lbl-1000
                                                                }
                                                                catch (Throwable var15_21) {
                                                                    if (resultSet != null) {
                                                                        resultSet.close();
                                                                    }
                                                                    throw var15_21;
                                                                }
lbl-1000:
                                                                // 1 sources

                                                                {
                                                                    resultSet.close();
                                                                }
lbl-1000:
                                                                // 1 sources

                                                                {
                                                                }
                                                            }
                                                            finally {
                                                                if (this.objectProcessingError == null) break block38;
                                                            }
                                                            {
                                                            }
                                                            ** if (statement == null) goto lbl-1000
                                                        }
lbl57:
                                                        // 2 sources

                                                        catch (Throwable var12_16) {
                                                            if (statement != null) {
                                                                statement.close();
                                                            }
                                                            throw var12_16;
                                                        }
lbl-1000:
                                                        // 1 sources

                                                        {
                                                            statement.close();
                                                            ** try [egrp 9[TRYBLOCK] [3 : 351->371)] { 
                                                        }
lbl-1000:
                                                        // 2 sources

                                                        {
                                                            break;
                                                        }
lbl-1000:
                                                        // 1 sources

                                                        {
                                                            UIUtils.syncExec((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$5(org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener org.jkiss.dbeaver.model.struct.DBSObject org.jkiss.dbeaver.model.exec.DBCStatement ), ()V)(this, (SQLScriptProgressListener)scriptListener, (DBSObject)object, (DBCStatement)statement));
                                                        }
                                                    }
                                                    if (statement == null) continue;
                                                    statement.close();
                                                }
                                                catch (Throwable var13_18) {
                                                    if (var12_15 == null) {
                                                        var12_15 = var13_18;
                                                    } else if (var12_15 != var13_18) {
                                                        var12_15.addSuppressed(var13_18);
                                                    }
                                                    throw var12_15;
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            this.objectProcessingError = e;
                                            UIUtils.asyncExec((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$3(org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener org.jkiss.dbeaver.model.struct.DBSObject ), ()V)(this, (SQLScriptProgressListener)scriptListener, (DBSObject)object));
                                            break block40;
                                        }
                                    }
                                    catch (Throwable var18_25) {
                                        UIUtils.asyncExec((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$3(org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener org.jkiss.dbeaver.model.struct.DBSObject ), ()V)(this, (SQLScriptProgressListener)scriptListener, (DBSObject)object));
                                        throw var18_25;
                                    }
                                    UIUtils.asyncExec((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$3(org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener org.jkiss.dbeaver.model.struct.DBSObject ), ()V)(this, (SQLScriptProgressListener)scriptListener, (DBSObject)object));
                                }
                                monitor.worked(1);
                                ++i;
                            }
                            if (GenerateMultiSQLDialog.this.isRunInSeparateTransaction()) {
                                GenerateMultiSQLDialog.access$1(GenerateMultiSQLDialog.this, session);
                            }
                        }
                        finally {
                            if (session != null) {
                                session.close();
                            }
                        }
                    }
                    catch (Throwable var4_6) {
                        if (var3_3 == null) {
                            var3_3 = var4_6;
                        } else if (var3_3 != var4_6) {
                            var3_3.addSuppressed(var4_6);
                        }
                        throw var3_3;
                    }
                }
                finally {
                    monitor.done();
                    UIUtils.asyncExec((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, endScriptProcessing(), ()V)((SQLScriptProgressListener)scriptListener));
                }
                return Status.OK_STATUS;
            }

            private static /* synthetic */ void lambda$0(SQLScriptProgressListener sQLScriptProgressListener, DataSourceJob dataSourceJob, List list) {
                sQLScriptProgressListener.beginScriptProcessing((Job)dataSourceJob, list);
            }

            private static /* synthetic */ void lambda$2(SQLScriptProgressListener sQLScriptProgressListener, DBSObject dBSObject, int n) {
                sQLScriptProgressListener.beginObjectProcessing(dBSObject, n);
            }

            private /* synthetic */ void lambda$4(SQLScriptProgressListener sQLScriptProgressListener, DBSObject dBSObject, DBCStatement dBCStatement, DBCResultSet dBCResultSet) {
                try {
                    sQLScriptProgressListener.processObjectResults(dBSObject, dBCStatement, dBCResultSet);
                }
                catch (DBCException e) {
                    this.objectProcessingError = e;
                }
            }

            private /* synthetic */ void lambda$5(SQLScriptProgressListener sQLScriptProgressListener, DBSObject dBSObject, DBCStatement dBCStatement) {
                try {
                    sQLScriptProgressListener.processObjectResults(dBSObject, dBCStatement, null);
                }
                catch (DBCException e) {
                    this.objectProcessingError = e;
                }
            }

            private /* synthetic */ void lambda$3(SQLScriptProgressListener sQLScriptProgressListener, DBSObject dBSObject) {
                sQLScriptProgressListener.endObjectProcessing(dBSObject, this.objectProcessingError);
            }
        };
        job.setUser(false);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (GenerateMultiSQLDialog.this.needsRefreshOnFinish()) {
                    for (DBSObject object : GenerateMultiSQLDialog.this.selectedObjects) {
                        DBUtils.fireObjectRefresh((DBSObject)object);
                    }
                }
            }
        });
        job.schedule();
    }

    protected boolean isRunInSeparateTransaction() {
        return false;
    }

    protected boolean needsRefreshOnFinish() {
        return false;
    }

    protected abstract void generateObjectCommand(List<String> var1, T var2);

    protected static <T extends DBSObject> DBCExecutionContext getContextFromObjects(@NotNull Collection<T> objects, boolean meta) {
        DBSObject object;
        Iterator<T> iterator = objects.iterator();
        if (iterator.hasNext() && (object = (DBSObject)iterator.next()) != null) {
            return DBUtils.getDefaultContext((DBSObject)object, (boolean)meta);
        }
        return null;
    }

    private void commitChanges(DBCSession session) {
        try {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
            if (txnManager != null && !txnManager.isAutoCommit()) {
                txnManager.commit(session);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error commiting transactions", e);
        }
    }

    static /* synthetic */ void access$1(GenerateMultiSQLDialog generateMultiSQLDialog, DBCSession dBCSession) {
        generateMultiSQLDialog.commitChanges(dBCSession);
    }
}

