/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

class TransformerSettingsDialog
extends BaseDialog {
    private static final Log log = Log.getLog(TransformerSettingsDialog.class);
    private final ResultSetViewer viewer;
    private final DBDAttributeBinding attr;
    private final DBVTransformSettings settings;
    private PropertyTreeViewer propertiesEditor;
    private PropertySourceCustom propertySource;
    private boolean selector;
    private List<? extends DBDAttributeTransformerDescriptor> transformerList;
    private Text infoText;
    private DBDAttributeTransformerDescriptor transformer;

    public TransformerSettingsDialog(ResultSetViewer viewer, DBDAttributeBinding attr, DBVTransformSettings settings, boolean selector) {
        super(viewer.getControl().getShell(), "Transformer settings", null);
        this.viewer = viewer;
        this.attr = attr;
        this.settings = settings;
        this.selector = selector;
    }

    protected Composite createDialogArea(Composite parent) {
        final Composite composite = super.createDialogArea(parent);
        DBPDataSource dataSource = this.viewer.getDataContainer() == null ? null : this.viewer.getDataContainer().getDataSource();
        List properties = Collections.emptyList();
        if (dataSource != null && !CommonUtils.isEmpty((String)this.settings.getCustomTransformer())) {
            this.transformer = dataSource.getContainer().getPlatform().getValueHandlerRegistry().getTransformer(this.settings.getCustomTransformer());
            if (this.transformer != null) {
                properties = this.transformer.getProperties();
            }
        } else {
            this.transformer = null;
        }
        if (this.selector || this.transformer != null) {
            Group placeholder = UIUtils.createControlGroup((Composite)composite, (String)"Transformer", (int)2, (int)768, (int)-1);
            if (!this.selector) {
                UIUtils.createLabelText((Composite)placeholder, (String)"Name", (String)this.transformer.getName(), (int)8);
            } else {
                final Combo transCombo = UIUtils.createLabelCombo((Composite)placeholder, (String)"Name", (int)12);
                transCombo.add("Default");
                transCombo.select(0);
                this.transformerList = DBWorkbench.getPlatform().getValueHandlerRegistry().findTransformers(this.attr.getDataSource(), (DBSTypedObject)this.attr, null);
                if (this.transformerList != null) {
                    for (DBDAttributeTransformerDescriptor dBDAttributeTransformerDescriptor : this.transformerList) {
                        transCombo.add(dBDAttributeTransformerDescriptor.getName());
                        if (dBDAttributeTransformerDescriptor != this.transformer) continue;
                        transCombo.select(transCombo.getItemCount() - 1);
                    }
                }
                transCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int selectionIndex = transCombo.getSelectionIndex();
                        if (selectionIndex == 0) {
                            TransformerSettingsDialog.this.transformer = null;
                            TransformerSettingsDialog.this.infoText.setText("N/A");
                            TransformerSettingsDialog.this.loadTransformerSettings(Collections.emptyList());
                        } else {
                            TransformerSettingsDialog.this.transformer = (DBDAttributeTransformerDescriptor)TransformerSettingsDialog.this.transformerList.get(selectionIndex - 1);
                            TransformerSettingsDialog.this.infoText.setText(CommonUtils.notEmpty((String)TransformerSettingsDialog.this.transformer.getDescription()));
                            TransformerSettingsDialog.this.loadTransformerSettings(TransformerSettingsDialog.this.transformer.getProperties());
                        }
                        composite.layout(true, true);
                    }
                });
            }
            Label infoLabel = UIUtils.createControlLabel((Composite)placeholder, (String)"Info");
            infoLabel.setLayoutData((Object)new GridData(2));
            this.infoText = new Text((Composite)placeholder, 72);
            if (this.transformer != null && this.transformer.getDescription() != null) {
                this.infoText.setText(this.transformer.getDescription());
            }
            GridData gridData = new GridData(768);
            gridData.widthHint = 300;
            this.infoText.setLayoutData((Object)gridData);
        }
        this.propertiesEditor = new PropertyTreeViewer(composite, 2048);
        this.loadTransformerSettings(properties);
        this.propertiesEditor.getControl().setFocus();
        if (!this.selector && CommonUtils.isEmpty((Collection)properties)) {
            UIUtils.asyncExec(this::okPressed);
        }
        return parent;
    }

    private void loadTransformerSettings(Collection<? extends DBPPropertyDescriptor> properties) {
        Map transformOptions = this.settings.getTransformOptions();
        if (transformOptions == null) {
            transformOptions = Collections.emptyMap();
        }
        this.propertySource = new PropertySourceCustom(properties, transformOptions);
        this.propertiesEditor.loadProperties((DBPPropertySource)this.propertySource);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        if (this.selector) {
            this.settings.setCustomTransformer(this.transformer == null ? null : this.transformer.getId());
        }
        if (this.transformer == null) {
            this.settings.setTransformOptions(new LinkedHashMap());
        } else {
            Map properties = this.propertySource.getPropertiesWithDefaults();
            for (Map.Entry prop : properties.entrySet()) {
                if (prop.getValue() == null) continue;
                this.settings.setTransformOption(prop.getKey().toString(), prop.getValue().toString());
            }
        }
        super.okPressed();
    }
}

