"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Initial state to be used when we anticipate that the workspace will contain zero or many projects once bootstrapping
 * has completed. Presents in the UI like the Absent state, but is "sticky" during the initial package activation.
 */
class AbsentGuess extends _state["default"] {
  isAbsentGuess() {
    return true;
  }

  isUndetermined() {
    return true;
  }

  showGitTabLoading() {
    return false;
  }

  showGitTabInit() {
    return true;
  }

  hasDirectory() {
    return false;
  }

}

exports["default"] = AbsentGuess;

_state["default"].register(AbsentGuess);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFic2VudC1ndWVzcy5qcyJdLCJuYW1lcyI6WyJBYnNlbnRHdWVzcyIsIlN0YXRlIiwiaXNBYnNlbnRHdWVzcyIsImlzVW5kZXRlcm1pbmVkIiwic2hvd0dpdFRhYkxvYWRpbmciLCJzaG93R2l0VGFiSW5pdCIsImhhc0RpcmVjdG9yeSIsInJlZ2lzdGVyIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7Ozs7QUFFQTs7OztBQUllLE1BQU1BLFdBQU4sU0FBMEJDLGlCQUExQixDQUFnQztBQUM3Q0MsRUFBQUEsYUFBYSxHQUFHO0FBQ2QsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLGNBQWMsR0FBRztBQUNmLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQixXQUFPLEtBQVA7QUFDRDs7QUFFREMsRUFBQUEsY0FBYyxHQUFHO0FBQ2YsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLFlBQVksR0FBRztBQUNiLFdBQU8sS0FBUDtBQUNEOztBQW5CNEM7Ozs7QUFzQi9DTCxrQkFBTU0sUUFBTixDQUFlUCxXQUFmIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzguMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgU3RhdGUgZnJvbSAnLi9zdGF0ZSc7XG5cbi8qKlxuICogSW5pdGlhbCBzdGF0ZSB0byBiZSB1c2VkIHdoZW4gd2UgYW50aWNpcGF0ZSB0aGF0IHRoZSB3b3Jrc3BhY2Ugd2lsbCBjb250YWluIHplcm8gb3IgbWFueSBwcm9qZWN0cyBvbmNlIGJvb3RzdHJhcHBpbmdcbiAqIGhhcyBjb21wbGV0ZWQuIFByZXNlbnRzIGluIHRoZSBVSSBsaWtlIHRoZSBBYnNlbnQgc3RhdGUsIGJ1dCBpcyBcInN0aWNreVwiIGR1cmluZyB0aGUgaW5pdGlhbCBwYWNrYWdlIGFjdGl2YXRpb24uXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEFic2VudEd1ZXNzIGV4dGVuZHMgU3RhdGUge1xuICBpc0Fic2VudEd1ZXNzKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgaXNVbmRldGVybWluZWQoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBzaG93R2l0VGFiTG9hZGluZygpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cblxuICBzaG93R2l0VGFiSW5pdCgpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGhhc0RpcmVjdG9yeSgpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoQWJzZW50R3Vlc3MpO1xuIl19