/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JsonTypedHandler
extends TypedHandlerDelegate {
    private boolean myWhitespaceAdded;

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            JsonTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(2);
        }
        if (file2 instanceof JsonFile) {
            JsonTypedHandler.processPairedBracesComma(c, editor, file2);
            this.addWhiteSpaceAfterColonIfNeeded(c, editor, file2);
            this.removeRedundantWhitespaceIfAfterColon(c, editor, file2);
        }
        TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
        if (result2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(3);
        }
        return result2;
    }

    private void removeRedundantWhitespaceIfAfterColon(char c, Editor editor, PsiFile file2) {
        if (!this.myWhitespaceAdded || c != ' ' || !JsonEditorOptions.getInstance().AUTO_WHITESPACE_AFTER_COLON) {
            if (c != ':') {
                this.myWhitespaceAdded = false;
            }
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        PsiElement element = file2.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            editor.getDocument().deleteString(offset - 1, offset);
        }
        this.myWhitespaceAdded = false;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (project == null) {
            JsonTypedHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            JsonTypedHandler.$$$reportNull$$$0(7);
        }
        if (file2 instanceof JsonFile) {
            JsonTypedHandler.addPropertyNameQuotesIfNeeded(c, editor, file2);
        }
        TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
        if (result2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(8);
        }
        return result2;
    }

    private void addWhiteSpaceAfterColonIfNeeded(char c, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(10);
        }
        if (c != ':' || !JsonEditorOptions.getInstance().AUTO_WHITESPACE_AFTER_COLON) {
            if (c != ' ') {
                this.myWhitespaceAdded = false;
            }
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.skipWhitespacesBackward((PsiElement)file2.findElementAt(offset)), JsonProperty.class, (boolean)false);
        if (element == null) {
            this.myWhitespaceAdded = false;
            return;
        }
        ASTNode[] children2 = element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.COLON}));
        if (children2.length == 0) {
            this.myWhitespaceAdded = false;
            return;
        }
        ASTNode colon = children2[0];
        ASTNode next = colon.getTreeNext();
        String text = next.getText();
        if (text.length() == 0 || !StringUtil.isEmptyOrSpaces((String)text) || StringUtil.isLineBreak((char)text.charAt(0))) {
            int insOffset = colon.getStartOffset() + 1;
            editor.getDocument().insertString(insOffset, (CharSequence)" ");
            editor.getCaretModel().moveToOffset(insOffset + 1);
            this.myWhitespaceAdded = true;
        } else {
            this.myWhitespaceAdded = false;
        }
    }

    private static void addPropertyNameQuotesIfNeeded(char c, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(12);
        }
        if (c != ':' || !JsonDialectUtil.isStandardJson((PsiElement)file2) || !JsonEditorOptions.getInstance().AUTO_QUOTE_PROP_NAME) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)file2.findElementAt(offset));
        if (!(element instanceof JsonProperty)) {
            return;
        }
        JsonValue nameElement = ((JsonProperty)element).getNameElement();
        if (nameElement instanceof JsonReferenceExpression) {
            ((JsonProperty)element).setName(nameElement.getText());
            PsiDocumentManager.getInstance((Project)file2.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
    }

    public static void processPairedBracesComma(char c, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            JsonTypedHandler.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            JsonTypedHandler.$$$reportNull$$$0(14);
        }
        if (!JsonEditorOptions.getInstance().COMMA_ON_MATCHING_BRACES) {
            return;
        }
        if (c != '[' && c != '{' && c != '\"' && c != '\'') {
            return;
        }
        SmartEnterProcessor.commitDocument((Editor)editor);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if ((c == '[' && parent instanceof JsonArray || c == '{' && parent instanceof JsonObject || (c == '\"' || c == '\'') && parent instanceof JsonStringLiteral) && JsonTypedHandler.shouldAddCommaInParentContainer((JsonValue)parent)) {
            editor.getDocument().insertString(parent.getTextRange().getEndOffset(), (CharSequence)",");
        }
    }

    private static boolean shouldAddCommaInParentContainer(@NotNull JsonValue item) {
        PsiElement nextElement;
        PsiElement parent;
        if (item == null) {
            JsonTypedHandler.$$$reportNull$$$0(15);
        }
        if (((parent = item.getParent()) instanceof JsonArray || parent instanceof JsonProperty) && (nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)(parent instanceof JsonProperty ? parent : item))) instanceof PsiErrorElement) {
            PsiElement forward = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextElement);
            return parent instanceof JsonProperty ? forward instanceof JsonProperty : forward instanceof JsonValue;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/editor/JsonTypedHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/editor/JsonTypedHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addWhiteSpaceAfterColonIfNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyNameQuotesIfNeeded";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processPairedBracesComma";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddCommaInParentContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

