/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorProvider;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PropertyBunch;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyFunctionImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTargetExpressionImpl;
import com.jetbrains.python.psi.impl.stubs.PyClassElementType;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.stubs.PropertyStubStorage;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassImpl
extends PyBaseElementImpl<PyClassStub>
implements PyClass {
    public static final PyClass[] EMPTY_ARRAY = new PyClassImpl[0];
    private volatile List<PyTargetExpression> myInstanceAttributes;
    private volatile Map<String, Property> myLocalPropertyCache;
    private static final Maybe<PyCallable> UNKNOWN_CALL = new Maybe();
    private static final Maybe<PyCallable> NONE = new Maybe<Object>(null);

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(0);
        }
        if (key == null) {
            PyClassImpl.$$$reportNull$$$0(1);
        }
        return new PyClassTypeImpl(this, true);
    }

    public PyClassImpl(@NotNull ASTNode astNode) {
        if (astNode == null) {
            PyClassImpl.$$$reportNull$$$0(2);
        }
        super(astNode);
    }

    public PyClassImpl(@NotNull PyClassStub stub) {
        if (stub == null) {
            PyClassImpl.$$$reportNull$$$0(3);
        }
        this(stub, (IStubElementType)PyElementTypes.CLASS_DECLARATION);
    }

    public PyClassImpl(@NotNull PyClassStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            PyClassImpl.$$$reportNull$$$0(4);
        }
        if (nodeType == null) {
            PyClassImpl.$$$reportNull$$$0(5);
        }
        super(stub, nodeType);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PyClassImpl.$$$reportNull$$$0(6);
        }
        ASTNode nameElement = PyUtil.createNewName(this, name);
        ASTNode node = this.getNameNode();
        if (node != null) {
            this.getNode().replaceChild(node, nameElement);
        }
        return this;
    }

    @Nullable
    public String getName() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameNode();
        return node != null ? node.getText() : null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getPsi() : null;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.CLASS_ICON;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyClass(this);
    }

    @Override
    @NotNull
    public PyStatementList getStatementList() {
        PyStatementList statementList = (PyStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        assert (statementList != null) : "Statement list missing for class " + this.getText();
        PyStatementList pyStatementList = statementList;
        if (pyStatementList == null) {
            PyClassImpl.$$$reportNull$$$0(7);
        }
        return pyStatementList;
    }

    @Override
    public PyArgumentList getSuperClassExpressionList() {
        PyArgumentList argList = (PyArgumentList)PsiTreeUtil.getChildOfType((PsiElement)this, PyArgumentList.class);
        if (argList != null && argList.getFirstChild() != null) {
            return argList;
        }
        return null;
    }

    @Override
    @NotNull
    public PyExpression[] getSuperClassExpressions() {
        PyArgumentList argList = this.getSuperClassExpressionList();
        if (argList != null) {
            PyExpression[] pyExpressionArray = argList.getArguments();
            if (pyExpressionArray == null) {
                PyClassImpl.$$$reportNull$$$0(8);
            }
            return pyExpressionArray;
        }
        if (PyExpression.EMPTY_ARRAY == null) {
            PyClassImpl.$$$reportNull$$$0(9);
        }
        return PyExpression.EMPTY_ARRAY;
    }

    @NotNull
    public static List<PyExpression> getUnfoldedSuperClassExpressions(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyClassImpl.$$$reportNull$$$0(10);
        }
        List list = ((StreamEx)StreamEx.of((Object[])pyClass.getSuperClassExpressions()).filter(expression -> !PyKeywordArgument.class.isInstance(expression))).flatCollection(PyClassImpl::unfoldSuperClassExpression).toList();
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static List<PyExpression> unfoldSuperClassExpression(@NotNull PyExpression expression) {
        if (expression == null) {
            PyClassImpl.$$$reportNull$$$0(12);
        }
        if (PyClassImpl.isSixWithMetaclassCall(expression)) {
            Object[] arguments = ((PyCallExpression)expression).getArguments();
            if (arguments.length > 1) {
                List list = ContainerUtil.newArrayList((Object[])arguments, (int)1, (int)arguments.length);
                if (list == null) {
                    PyClassImpl.$$$reportNull$$$0(13);
                }
                return list;
            }
            List<PyExpression> list = Collections.emptyList();
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (expression instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)expression;
            List<PyExpression> list = Collections.singletonList(subscriptionExpr.getOperand());
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<PyExpression> list = Collections.singletonList(expression);
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    public static boolean isSixWithMetaclassCall(@NotNull PyExpression expression) {
        PyExpression callee;
        if (expression == null) {
            PyClassImpl.$$$reportNull$$$0(17);
        }
        if (expression instanceof PyCallExpression && (callee = ((PyCallExpression)expression).getCallee()) instanceof PyReferenceExpression) {
            QualifiedName sixWithMetaclass = QualifiedName.fromComponents((String[])new String[]{"six", "with_metaclass"});
            QualifiedName djangoWithMetaclass = QualifiedName.fromDottedString((String)"django.utils.six.with_metaclass");
            return ContainerUtil.exists(PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)callee), name -> name.equals((Object)sixWithMetaclass) || name.equals((Object)djangoWithMetaclass));
        }
        return false;
    }

    @Override
    @NotNull
    public final List<PyClass> getAncestorClasses(@Nullable TypeEvalContext context) {
        ArrayList<PyClass> results = new ArrayList<PyClass>();
        TypeEvalContext contextToUse = context != null ? context : TypeEvalContext.codeInsightFallback(this.getProject());
        for (PyClassLikeType type : this.getAncestorTypes(contextToUse)) {
            if (!(type instanceof PyClassType)) continue;
            results.add(((PyClassType)type).getPyClass());
        }
        ArrayList<PyClass> arrayList = results;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Override
    public boolean isSubclass(PyClass parent, @Nullable TypeEvalContext context) {
        if (this == parent) {
            return true;
        }
        for (PyClass superclass : this.getAncestorClasses(context)) {
            if (parent != superclass) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubclass(@NotNull String superClassQName, @Nullable TypeEvalContext context) {
        if (superClassQName == null) {
            PyClassImpl.$$$reportNull$$$0(19);
        }
        if (context == null) {
            context = TypeEvalContext.codeInsightFallback(this.getProject());
        }
        if (superClassQName.equals(this.getQualifiedName())) {
            return true;
        }
        for (PyClassLikeType type : this.getAncestorTypes(context)) {
            if (type == null || !superClassQName.equals(type.getClassQName())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PyDecoratorList getDecoratorList() {
        return (PyDecoratorList)this.getStubOrPsiChild(PyElementTypes.DECORATOR_LIST);
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Override
    @Nullable
    public List<String> getSlots(@Nullable TypeEvalContext context) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        PyClassTypeImpl currentType = new PyClassTypeImpl(this, true);
        TypeEvalContext contextToUse = context != null ? context : TypeEvalContext.codeInsightFallback(this.getProject());
        for (PyClassLikeType type : Iterables.concat(Collections.singletonList(currentType), this.getAncestorTypes(contextToUse))) {
            if (!(type instanceof PyClassType)) {
                return null;
            }
            PyClass cls = ((PyClassType)type).getPyClass();
            if (PyUtil.isObjectClass(cls)) continue;
            if (!cls.isNewStyleClass(contextToUse)) {
                return null;
            }
            List<String> ownSlots = cls.getOwnSlots();
            if (ownSlots == null || ownSlots.contains("__dict__")) {
                return null;
            }
            result.addAll(ownSlots);
        }
        return new ArrayList<String>(result);
    }

    @Override
    @Nullable
    public List<String> getOwnSlots() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            return stub.getSlots();
        }
        PyTargetExpression slots = (PyTargetExpression)ContainerUtil.find(this.getClassAttributes(), target -> "__slots__".equals(target.getName()));
        if (slots != null) {
            PyExpression value = slots.findAssignedValue();
            return value instanceof PyStringLiteralExpression ? Collections.singletonList(((PyStringLiteralExpression)value).getStringValue()) : PyUtil.strListValue(value);
        }
        return null;
    }

    @Override
    @NotNull
    public PyClass[] getSuperClasses(@Nullable TypeEvalContext context) {
        List<PyClassLikeType> superTypes;
        if (context == null) {
            context = TypeEvalContext.codeInsightFallback(this.getProject());
        }
        if ((superTypes = this.getSuperClassTypes(context)).isEmpty()) {
            if (EMPTY_ARRAY == null) {
                PyClassImpl.$$$reportNull$$$0(20);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PyClass> result = new ArrayList<PyClass>();
        for (PyClassLikeType type : superTypes) {
            if (!(type instanceof PyClassType)) continue;
            result.add(((PyClassType)type).getPyClass());
        }
        PyClass[] pyClassArray = result.toArray(PyClass.EMPTY_ARRAY);
        if (pyClassArray == null) {
            PyClassImpl.$$$reportNull$$$0(21);
        }
        return pyClassArray;
    }

    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this){

            @Override
            @NotNull
            public String getPresentableText() {
                PyPsiUtils.assertValid((PsiElement)PyClassImpl.this);
                StringBuilder result = new StringBuilder(StringUtil.notNullize((String)PyClassImpl.this.getName(), (String)"<unnamed>"));
                List superClassesText = PyClassImpl.this.getSuperClassesText();
                if (!superClassesText.isEmpty()) {
                    result.append("(");
                    result.append(StringUtil.join((Collection)superClassesText, expr -> StringUtil.notNullize((String)expr, (String)"<unnamed>"), (String)", "));
                    result.append(")");
                }
                String string = result.toString();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$1", "getPresentableText"));
            }
        };
    }

    private List<String> getSuperClassesText() {
        PyClassStub stub = (PyClassStub)this.getGreenStub();
        if (stub == null) {
            return ContainerUtil.map((Object[])this.getSuperClassExpressions(), PsiElement::getText);
        }
        return stub.getSuperClassesText();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    private static List<PyClassLikeType> mroMerge(@NotNull List<List<PyClassLikeType>> sequences) throws MROException {
        if (sequences == null) {
            PyClassImpl.$$$reportNull$$$0(22);
        }
        result = new LinkedList<PyClassLikeType>();
        block0: while (true) {
            nonBlankSequences = new ArrayList<List<PyClassLikeType>>(sequences.size());
            for (List<PyClassLikeType> item : sequences) {
                if (item.size() <= 0) continue;
                nonBlankSequences.add(item);
            }
            if (nonBlankSequences.isEmpty()) {
                v0 = result;
                if (v0 == null) {
                    PyClassImpl.$$$reportNull$$$0(23);
                }
                return v0;
            }
            found = false;
            head = null;
            for (List seq : nonBlankSequences) {
                head = (PyClassLikeType)seq.get(0);
                if (head == null) {
                    seq.remove(0);
                    found = true;
                    break;
                }
                headInTails = false;
                for (List tailSeq : nonBlankSequences) {
                    if (tailSeq.indexOf(head) <= 0) continue;
                    headInTails = true;
                    break;
                }
                if (!headInTails) {
                    found = true;
                    break;
                }
                head = null;
            }
            if (!found) {
                throw new MROException("Inconsistent class hierarchy");
            }
            result.add(head);
            if (head == null) continue;
            var5_6 = nonBlankSequences.iterator();
            while (true) {
                if (var5_6.hasNext()) ** break;
                continue block0;
                seq = (List)var5_6.next();
                if (!Comparing.equal(seq.get(0), (Object)head)) continue;
                seq.remove(0);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<PyClassLikeType> mroLinearize(@NotNull PyClassLikeType type, boolean addThisType, @NotNull TypeEvalContext context, @NotNull Map<PyClassLikeType, Ref<List<PyClassLikeType>>> cache2) throws MROException {
        Ref<List<PyClassLikeType>> computed;
        if (type == null) {
            PyClassImpl.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(25);
        }
        if (cache2 == null) {
            PyClassImpl.$$$reportNull$$$0(26);
        }
        if ((computed = cache2.get(type)) != null) {
            if (computed.isNull()) {
                throw new MROException("Circular class inheritance");
            }
            List list = (List)computed.get();
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(27);
            }
            return list;
        }
        cache2.put(type, (Ref<List<PyClassLikeType>>)Ref.create());
        List<PyClassLikeType> result = null;
        try {
            List<PyClassLikeType> bases = PyClassImpl.removeNotNullDuplicates(type.getSuperClassTypes(context));
            ArrayList<List<PyClassLikeType>> lines = new ArrayList<List<PyClassLikeType>>();
            for (PyClassLikeType base : bases) {
                List<PyClassLikeType> baseClassMRO;
                if (base == null) continue;
                if (base.isDefinition()) {
                    baseClassMRO = PyClassImpl.mroLinearize(base, true, context, cache2);
                } else {
                    PyClassImpl pyClass;
                    ArrayList<PyClassLikeType> metaclassInstanceMro = new ArrayList<PyClassLikeType>();
                    metaclassInstanceMro.add(base);
                    if (base instanceof PyClassType && (pyClass = PyUtil.as(((PyClassType)base).getPyClass(), PyClassImpl.class)) != null) {
                        ContainerUtil.addIfNotNull(metaclassInstanceMro, (Object)pyClass.getImplicitSuper(context));
                    }
                    baseClassMRO = metaclassInstanceMro;
                }
                if (baseClassMRO.isEmpty()) continue;
                lines.add(new LinkedList<PyClassLikeType>(baseClassMRO));
            }
            if (!bases.isEmpty()) {
                lines.add(bases);
            }
            result = PyClassImpl.mroMerge(lines);
            if (addThisType) {
                result.add(0, type);
            }
            result = Collections.unmodifiableList(result);
        }
        finally {
            cache2.put(type, (Ref<List<PyClassLikeType>>)Ref.create(result));
        }
        List<PyClassLikeType> list = result;
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static <T> List<T> removeNotNullDuplicates(@NotNull List<T> list) {
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(29);
        }
        HashSet<T> distinct = new HashSet<T>();
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : list) {
            boolean isUnique;
            if (elem != null && !(isUnique = distinct.add(elem))) continue;
            result.add(elem);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PyFunction[] getMethods() {
        TokenSet functionDeclarationTokens = PythonDialectsTokenSetProvider.INSTANCE.getFunctionDeclarationTokens();
        PyFunction[] pyFunctionArray = (PyFunction[])this.getClassChildren(functionDeclarationTokens, PyFunction.class, PyFunction.ARRAY_FACTORY);
        if (pyFunctionArray == null) {
            PyClassImpl.$$$reportNull$$$0(31);
        }
        return pyFunctionArray;
    }

    @Override
    @NotNull
    public Map<String, Property> getProperties() {
        this.initLocalProperties();
        HashMap<String, Property> hashMap = new HashMap<String, Property>(this.myLocalPropertyCache);
        if (hashMap == null) {
            PyClassImpl.$$$reportNull$$$0(32);
        }
        return hashMap;
    }

    @Override
    public PyClass[] getNestedClasses() {
        return (PyClass[])this.getClassChildren(TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.CLASS_DECLARATION}), PyClass.class, PyClass.ARRAY_FACTORY);
    }

    @NotNull
    private <T extends StubBasedPsiElement<? extends StubElement<T>>> T[] getClassChildren(final @NotNull TokenSet elementTypes, final @NotNull Class<T> childrenClass, @NotNull ArrayFactory<T> factory) {
        if (elementTypes == null) {
            PyClassImpl.$$$reportNull$$$0(33);
        }
        if (childrenClass == null) {
            PyClassImpl.$$$reportNull$$$0(34);
        }
        if (factory == null) {
            PyClassImpl.$$$reportNull$$$0(35);
        }
        final ArrayList result = new ArrayList();
        this.processClassLevelDeclarations(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (childrenClass.isInstance(element) && elementTypes.contains((IElementType)((StubBasedPsiElement)element).getElementType())) {
                    result.add(childrenClass.cast(element));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/impl/PyClassImpl$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        StubBasedPsiElement[] stubBasedPsiElementArray = (StubBasedPsiElement[])ContainerUtil.toArray(result, factory);
        if (stubBasedPsiElementArray == null) {
            PyClassImpl.$$$reportNull$$$0(36);
        }
        return stubBasedPsiElementArray;
    }

    @Override
    public PyFunction findMethodByName(@Nullable String name, boolean inherited, @Nullable TypeEvalContext context) {
        if (name == null) {
            return null;
        }
        NameFinder<PyFunction> proc = new NameFinder<PyFunction>(name);
        this.visitMethods(proc, inherited, context);
        return proc.getResult();
    }

    @Override
    @NotNull
    public List<PyFunction> multiFindMethodByName(@NotNull String name, boolean inherited, @Nullable TypeEvalContext context) {
        if (name == null) {
            PyClassImpl.$$$reportNull$$$0(37);
        }
        MultiNameFinder<PyFunction> processor = new MultiNameFinder<PyFunction>(name);
        this.visitMethods(processor, inherited, context);
        List list = ((MultiNameFinder)processor).myResult;
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(38);
        }
        return list;
    }

    @Override
    @Nullable
    public PyClass findNestedClass(String name, boolean inherited) {
        if (name == null) {
            return null;
        }
        NameFinder<PyClass> proc = new NameFinder<PyClass>(name);
        this.visitNestedClasses(proc, inherited);
        return proc.getResult();
    }

    @Override
    @Nullable
    public PyFunction findInitOrNew(boolean inherited, @Nullable TypeEvalContext context) {
        NameFinder<PyFunction> proc = this.isNewStyleClass(context) ? new NameFinder<PyFunction>(new String[]{"__init__", "__new__"}){

            @Override
            @Nullable
            protected PyClass getContainingClass(@NotNull PyFunction element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                return element.getContainingClass();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyClassImpl$3", "getContainingClass"));
            }
        } : new NameFinder<PyFunction>("__init__");
        this.visitMethods((Processor<PyFunction>)proc, inherited, true, context);
        return (PyFunction)proc.getResult();
    }

    @Override
    @NotNull
    public List<PyFunction> multiFindInitOrNew(boolean inherited, @Nullable TypeEvalContext context) {
        MultiNameFinder<PyFunction> processor = this.isNewStyleClass(context) ? new MultiNameFinder<PyFunction>("__init__", "__new__") : new MultiNameFinder("__init__");
        this.visitMethods(processor, inherited, true, context);
        List list = ((MultiNameFinder)processor).myResult;
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(39);
        }
        return list;
    }

    @Nullable
    private Property processPropertiesInClass(@Nullable Processor<Property> filter) {
        Property decoratedProperty = this.processDecoratedProperties(filter);
        if (decoratedProperty != null) {
            return decoratedProperty;
        }
        if (this.getStub() != null) {
            return this.processStubProperties(filter);
        }
        for (PyTargetExpression target : this.getClassAttributes()) {
            PropertyImpl property = PropertyImpl.fromTarget(target);
            if (property == null || filter != null && !filter.process((Object)property)) continue;
            return property;
        }
        return null;
    }

    @Nullable
    private Property processDecoratedProperties(@Nullable Processor<Property> filter) {
        MultiMap grouped = new MultiMap();
        for (PyFunction method : this.getMethods()) {
            grouped.putValue((Object)method.getName(), (Object)method);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            Maybe<PyCallable> getter = NONE;
            Maybe<PyCallable> setter = NONE;
            Maybe<PyCallable> deleter = NONE;
            String decoratorName = (String)entry.getKey();
            for (PyFunction method : (Collection)entry.getValue()) {
                PyDecoratorList decoratorList = method.getDecoratorList();
                if (decoratorList != null) {
                    for (PyDecorator deco : decoratorList.getDecorators()) {
                        QualifiedName qname = deco.getQualifiedName();
                        if (qname == null) continue;
                        String decoName = qname.toString();
                        for (PyKnownDecoratorProvider provider : PyUtil.KnownDecoratorProviderHolder.KNOWN_DECORATOR_PROVIDERS) {
                            String knownName = provider.toKnownDecorator(decoName);
                            if (knownName == null) continue;
                            decoName = knownName;
                        }
                        if ("property".equals(decoName) || PyKnownDecoratorUtil.isPropertyDecorator(deco, TypeEvalContext.codeInsightFallback(this.getProject())) || qname.matches(new String[]{decoratorName, "getter"})) {
                            getter = new Maybe<PyFunction>(method);
                            continue;
                        }
                        if (qname.matches(new String[]{decoratorName, "setter"})) {
                            setter = new Maybe<PyFunction>(method);
                            continue;
                        }
                        if (!qname.matches(new String[]{decoratorName, "deleter"})) continue;
                        deleter = new Maybe<PyFunction>(method);
                    }
                }
                if (getter == NONE || setter == NONE || deleter == NONE) continue;
                break;
            }
            if (getter == NONE && setter == NONE && deleter == NONE) continue;
            PropertyImpl prop = new PropertyImpl(decoratorName, getter, setter, deleter, null, null);
            if (filter != null && !filter.process((Object)prop)) continue;
            return prop;
        }
        return null;
    }

    private Maybe<PyCallable> fromPacked(Maybe<String> maybeName) {
        if (maybeName.isDefined()) {
            String value = maybeName.value();
            if (value == null || "None".equals(value)) {
                return NONE;
            }
            PyFunction method = this.findMethodByName(value, true, null);
            if (method != null) {
                return new Maybe<PyCallable>(method);
            }
        }
        return UNKNOWN_CALL;
    }

    @Nullable
    private Property processStubProperties(@Nullable Processor<Property> filter) {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            for (StubElement subStub : stub.getChildrenStubs()) {
                PyTargetExpressionStub targetStub;
                PropertyStubStorage prop;
                if (subStub.getStubType() != PyElementTypes.TARGET_EXPRESSION || (prop = (targetStub = (PyTargetExpressionStub)subStub).getCustomStub(PropertyStubStorage.class)) == null) continue;
                Maybe<PyCallable> getter = this.fromPacked(prop.getGetter());
                Maybe<PyCallable> setter = this.fromPacked(prop.getSetter());
                Maybe<PyCallable> deleter = this.fromPacked(prop.getDeleter());
                String doc = prop.getDoc();
                if (getter == NONE && setter == NONE && deleter == NONE) continue;
                PropertyImpl property = new PropertyImpl(targetStub.getName(), getter, setter, deleter, doc, (PyTargetExpression)targetStub.getPsi());
                if (filter != null && !filter.process((Object)property)) continue;
                return property;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Property findProperty(@NotNull String name, boolean inherited, @Nullable TypeEvalContext context) {
        if (name == null) {
            PyClassImpl.$$$reportNull$$$0(40);
        }
        this.initLocalProperties();
        Property property = this.myLocalPropertyCache.get(name);
        if (property != null) {
            return property;
        }
        if (this.findMethodByName(name, false, null) != null || this.findClassAttribute(name, false, null) != null || ContainerUtil.notNullize(this.getOwnSlots()).contains(name)) {
            return null;
        }
        if (inherited) {
            for (PyClass cls : this.getAncestorClasses(context)) {
                Property ancestorProperty = cls.findProperty(name, false, context);
                if (ancestorProperty == null) continue;
                return ancestorProperty;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Property findPropertyByCallable(PyCallable callable) {
        this.initLocalProperties();
        for (Property property : this.myLocalPropertyCache.values()) {
            if (property.getGetter().valueOrNull() != callable && property.getSetter().valueOrNull() != callable && property.getDeleter().valueOrNull() != callable) continue;
            return property;
        }
        return null;
    }

    private synchronized void initLocalProperties() {
        if (this.myLocalPropertyCache == null) {
            HashMap<String, Property> result = new HashMap<String, Property>();
            this.processProperties((Processor<Property>)((Processor)property -> {
                result.put(property.getName(), (Property)property);
                return false;
            }), false);
            this.myLocalPropertyCache = result;
        }
    }

    @Override
    @Nullable
    public Property scanProperties(@Nullable Processor<Property> filter, boolean inherited) {
        return this.processProperties(filter, inherited);
    }

    @Nullable
    private Property processProperties(@Nullable Processor<Property> filter, boolean inherited) {
        PyPsiUtils.assertValid((PsiElement)this);
        Property local = this.processPropertiesInClass(filter);
        if (local != null) {
            return local;
        }
        if (inherited) {
            for (PyClass cls : this.getAncestorClasses(null)) {
                Property property = ((PyClassImpl)cls).processPropertiesInClass(filter);
                if (property == null) continue;
                return property;
            }
        }
        return null;
    }

    @Override
    public boolean visitMethods(Processor<PyFunction> processor, boolean inherited, @Nullable TypeEvalContext context) {
        return this.visitMethods(processor, inherited, false, context);
    }

    private boolean visitMethods(Processor<PyFunction> processor, boolean inherited, boolean skipClassObj, TypeEvalContext context) {
        Object[] methods = this.getMethods();
        if (!ContainerUtil.process((Object[])methods, processor)) {
            return false;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses(context)) {
                if (skipClassObj && "types.InstanceType".equals(ancestor.getQualifiedName()) || ancestor.visitMethods(processor, false, null)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean visitNestedClasses(Processor<PyClass> processor, boolean inherited) {
        Object[] nestedClasses = this.getNestedClasses();
        if (!ContainerUtil.process((Object[])nestedClasses, processor)) {
            return false;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses(null)) {
                if (((PyClassImpl)ancestor).visitNestedClasses(processor, false)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean visitClassAttributes(Processor<PyTargetExpression> processor, boolean inherited, @Nullable TypeEvalContext context) {
        List<PyTargetExpression> methods = this.getClassAttributes();
        if (!ContainerUtil.process(methods, processor)) {
            return false;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses(context)) {
                if (ancestor.visitClassAttributes(processor, false, context)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public final List<PyTargetExpression> getClassAttributesInherited(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(41);
        }
        MyAttributesCollector attributesCollector = new MyAttributesCollector();
        this.visitClassAttributes(attributesCollector, true, context);
        List<PyTargetExpression> list = attributesCollector.getAttributes();
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(42);
        }
        return list;
    }

    @Override
    public List<PyTargetExpression> getClassAttributes() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            PyTargetExpression[] children = (PyTargetExpression[])stub.getChildrenByType((IElementType)PyElementTypes.TARGET_EXPRESSION, PyTargetExpression.EMPTY_ARRAY);
            return Arrays.asList(children);
        }
        ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
        for (PsiElement psiElement : this.getStatementList().getChildren()) {
            PyExpression target;
            if (psiElement instanceof PyAssignmentStatement) {
                PyExpression[] targets;
                PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)psiElement;
                for (PyExpression target2 : targets = assignmentStatement.getTargets()) {
                    if (!(target2 instanceof PyTargetExpression)) continue;
                    result.add((PyTargetExpression)target2);
                }
                continue;
            }
            if (!(psiElement instanceof PyTypeDeclarationStatement) || !((target = ((PyTypeDeclarationStatement)psiElement).getTarget()) instanceof PyTargetExpression)) continue;
            result.add((PyTargetExpression)target);
        }
        return result;
    }

    @Override
    public PyTargetExpression findClassAttribute(@NotNull String name, boolean inherited, TypeEvalContext context) {
        if (name == null) {
            PyClassImpl.$$$reportNull$$$0(43);
        }
        NameFinder<PyTargetExpression> processor = new NameFinder<PyTargetExpression>(name);
        this.visitClassAttributes(processor, inherited, context);
        return processor.getResult();
    }

    @Override
    public List<PyTargetExpression> getInstanceAttributes() {
        if (this.myInstanceAttributes == null) {
            this.myInstanceAttributes = this.collectInstanceAttributes();
        }
        return this.myInstanceAttributes;
    }

    @Override
    @Nullable
    public PyTargetExpression findInstanceAttribute(String name, boolean inherited) {
        List<PyTargetExpression> instanceAttributes = this.getInstanceAttributes();
        for (PyTargetExpression instanceAttribute : instanceAttributes) {
            if (!name.equals(instanceAttribute.getReferencedName())) continue;
            return instanceAttribute;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses(null)) {
                PyTargetExpression attribute = ancestor.findInstanceAttribute(name, false);
                if (attribute == null) continue;
                return attribute;
            }
        }
        return null;
    }

    private List<PyTargetExpression> collectInstanceAttributes() {
        PyFunction[] methods;
        HashMap<String, PyTargetExpression> result = new HashMap<String, PyTargetExpression>();
        this.collectAttributesInNew(result);
        PyFunctionImpl initMethod = (PyFunctionImpl)this.findMethodByName("__init__", false, null);
        if (initMethod != null) {
            PyClassImpl.collectInstanceAttributes(initMethod, result);
        }
        HashSet<String> namesInInit = new HashSet<String>(result.keySet());
        for (PyFunction method : methods = this.getMethods()) {
            if ("__init__".equals(method.getName())) continue;
            PyClassImpl.collectInstanceAttributes(method, result, namesInInit);
        }
        Collection expressions = result.values();
        return new ArrayList<PyTargetExpression>(expressions);
    }

    private void collectAttributesInNew(@NotNull Map<String, PyTargetExpression> result) {
        PyFunction newMethod;
        if (result == null) {
            PyClassImpl.$$$reportNull$$$0(44);
        }
        if ((newMethod = this.findMethodByName("__new__", false, null)) != null) {
            for (PyTargetExpression target : PyClassImpl.getTargetExpressions(newMethod)) {
                result.put(target.getName(), target);
            }
        }
    }

    public static void collectInstanceAttributes(@NotNull PyFunction method, @NotNull Map<String, PyTargetExpression> result) {
        if (method == null) {
            PyClassImpl.$$$reportNull$$$0(45);
        }
        if (result == null) {
            PyClassImpl.$$$reportNull$$$0(46);
        }
        PyClassImpl.collectInstanceAttributes(method, result, null);
    }

    public static void collectInstanceAttributes(@NotNull PyFunction method, @NotNull Map<String, PyTargetExpression> result, Set<String> existing) {
        PyParameter[] params;
        if (method == null) {
            PyClassImpl.$$$reportNull$$$0(47);
        }
        if (result == null) {
            PyClassImpl.$$$reportNull$$$0(48);
        }
        if ((params = method.getParameterList().getParameters()).length == 0) {
            return;
        }
        for (PyTargetExpression target : PyClassImpl.getTargetExpressions(method)) {
            if (!PyUtil.isInstanceAttribute(target) || existing != null && existing.contains(target.getName())) continue;
            result.put(target.getName(), target);
        }
    }

    @NotNull
    private static List<PyTargetExpression> getTargetExpressions(@NotNull PyFunction function) {
        PyFunctionStub stub;
        if (function == null) {
            PyClassImpl.$$$reportNull$$$0(49);
        }
        if ((stub = (PyFunctionStub)function.getStub()) != null) {
            List<PsiElement> list = Arrays.asList(stub.getChildrenByType((IElementType)PyElementTypes.TARGET_EXPRESSION, PyTargetExpression.EMPTY_ARRAY));
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(50);
            }
            return list;
        }
        PyStatementList statementList = function.getStatementList();
        final ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
        statementList.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyClass(PyClass node) {
            }

            @Override
            public void visitPyAssignmentStatement(PyAssignmentStatement node) {
                for (PyExpression expression : node.getTargets()) {
                    if (!(expression instanceof PyTargetExpression)) continue;
                    result.add((PyTargetExpression)expression);
                }
            }

            @Override
            public void visitPyWithStatement(PyWithStatement node) {
                StreamEx.of((Object[])node.getWithItems()).map(PyWithItem::getTarget).select(PyTargetExpression.class).forEach(result::add);
                super.visitPyWithStatement(node);
            }
        });
        ArrayList<PyTargetExpression> arrayList = result;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    @Override
    public boolean isNewStyleClass(@Nullable TypeEvalContext context) {
        return (Boolean)((ParameterizedCachedValue)new NotNullLazyValue<ParameterizedCachedValue<Boolean, TypeEvalContext>>(){

            @NotNull
            protected ParameterizedCachedValue<Boolean, TypeEvalContext> compute() {
                ParameterizedCachedValue parameterizedCachedValue = CachedValuesManager.getManager((Project)PyClassImpl.this.getProject()).createParameterizedCachedValue(param -> new CachedValueProvider.Result((Object)PyClassImpl.this.calculateNewStyleClass(param), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
                if (parameterizedCachedValue == null) {
                    5.$$$reportNull$$$0(0);
                }
                return parameterizedCachedValue;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$5", "compute"));
            }
        }.getValue()).getValue((Object)context);
    }

    private boolean calculateNewStyleClass(@Nullable TypeEvalContext context) {
        PsiFile containingFile = this.getContainingFile();
        if (containingFile instanceof PyFile && ((PyFile)containingFile).getLanguageLevel().isPy3K()) {
            return true;
        }
        PyClass objClass = PyBuiltinCache.getInstance((PsiElement)this).getClass("object");
        if (this == objClass) {
            return true;
        }
        if (PyClassImpl.hasNewStyleMetaClass(this)) {
            return true;
        }
        TypeEvalContext contextToUse = context != null ? context : TypeEvalContext.codeInsightFallback(this.getProject());
        for (PyClassLikeType type : this.getOldStyleAncestorTypes(contextToUse)) {
            PyClass pyClass;
            if (type == null) {
                return true;
            }
            if (!(type instanceof PyClassType) || (pyClass = ((PyClassType)type).getPyClass()) != objClass && !PyClassImpl.hasNewStyleMetaClass(pyClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNewStyleMetaClass(PyClass pyClass) {
        QualifiedName qName;
        PsiElement element;
        PsiFile containingFile = pyClass.getContainingFile();
        if (containingFile instanceof PyFile && (element = ((PyFile)containingFile).getElementNamed("__metaclass__")) instanceof PyTargetExpression && (qName = ((PyTargetExpression)element).getAssignedQName()) != null && qName.matches(new String[]{"type"})) {
            return true;
        }
        return pyClass.findClassAttribute("__metaclass__", false, null) != null;
    }

    @Override
    public boolean processClassLevelDeclarations(@NotNull PsiScopeProcessor processor) {
        PyClassStub stub;
        if (processor == null) {
            PyClassImpl.$$$reportNull$$$0(52);
        }
        if ((stub = (PyClassStub)this.getStub()) != null) {
            List children = stub.getChildrenStubs();
            for (StubElement child : children) {
                if (processor.execute(child.getPsi(), ResolveState.initial())) continue;
                return false;
            }
        } else {
            PyResolveUtil.scopeCrawlUp(processor, this, null, (PsiElement)this);
        }
        return true;
    }

    @Override
    public boolean processInstanceLevelDeclarations(@NotNull PsiScopeProcessor processor, @Nullable PsiElement location) {
        PyClass containingClass;
        if (processor == null) {
            PyClassImpl.$$$reportNull$$$0(53);
        }
        HashMap<String, PyTargetExpression> declarationsInMethod = new HashMap<String, PyTargetExpression>();
        PyFunction instanceMethod = (PyFunction)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)location, PyFunction.class);
        PyClass pyClass = containingClass = instanceMethod != null ? instanceMethod.getContainingClass() : null;
        if (instanceMethod != null && containingClass != null && CompletionUtil.getOriginalElement((PsiElement)containingClass) == this) {
            PyClassImpl.collectInstanceAttributes(instanceMethod, declarationsInMethod);
            for (PyTargetExpression targetExpression : declarationsInMethod.values()) {
                if (processor.execute((PsiElement)targetExpression, ResolveState.initial())) continue;
                return false;
            }
        }
        for (PyTargetExpression expr : this.getInstanceAttributes()) {
            if (declarationsInMethod.containsKey(expr.getName()) || processor.execute((PsiElement)expr, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    public int getTextOffset() {
        ASTNode name = this.getNameNode();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    @Override
    @Nullable
    public PyStringLiteralExpression getDocStringExpression() {
        return DocStringUtil.findDocStringExpression(this.getStatementList());
    }

    @Override
    public String getDocStringValue() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString(this);
    }

    @Override
    public String toString() {
        return "PyClass: " + this.getName();
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        ControlFlowCache.clear(this);
        if (this.myInstanceAttributes != null) {
            this.myInstanceAttributes = null;
        }
        this.myLocalPropertyCache = null;
    }

    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)this);
        if (scopeOwner instanceof PyFunction) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)scopeOwner);
            if (localSearchScope == null) {
                PyClassImpl.$$$reportNull$$$0(54);
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            PyClassImpl.$$$reportNull$$$0(55);
        }
        return searchScope;
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(56);
        }
        if ("types.InstanceType".equals(this.getQualifiedName())) {
            List<PyClassLikeType> list = Collections.emptyList();
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(57);
            }
            return list;
        }
        ArrayList<PyClassLikeType> result = new ArrayList<PyClassLikeType>();
        if (!context.maySwitchToAST((PsiElement)this)) {
            this.fillSuperClassesNoSwitchToAst(context, (PyClassStub)this.getStub(), result);
        } else {
            this.fillSuperClassesSwitchingToAst(context, result);
        }
        PyPsiUtils.assertValid((PsiElement)this);
        if (result.isEmpty()) {
            List<PyClassLikeType> list = Optional.ofNullable(this.getImplicitSuper(context)).map(Collections::singletonList).orElse(Collections.emptyList());
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(58);
            }
            return list;
        }
        ArrayList<PyClassLikeType> arrayList = result;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(59);
        }
        return arrayList;
    }

    private void fillSuperClassesSwitchingToAst(@NotNull TypeEvalContext context, List<PyClassLikeType> result) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(60);
        }
        for (PyExpression expression : PyClassImpl.getUnfoldedSuperClassExpressions(this)) {
            PyType type = context.getType(expression);
            PyClassLikeType classLikeType = null;
            if (type instanceof PyClassLikeType) {
                classLikeType = (PyClassLikeType)type;
            } else {
                PyType resolvedType;
                PsiElement resolved;
                PyReferenceExpression referenceExpr = PyUtil.as(expression, PyReferenceExpression.class);
                if (referenceExpr != null) {
                    resolved = referenceExpr.followAssignmentsChain(PyResolveContext.noImplicits().withTypeEvalContext(context)).getElement();
                } else {
                    PsiReference ref = expression.getReference();
                    PsiElement psiElement = resolved = ref != null ? ref.resolve() : null;
                }
                if (resolved instanceof PyClass && (resolvedType = context.getType((PyClass)resolved)) instanceof PyClassLikeType) {
                    classLikeType = (PyClassLikeType)resolvedType;
                }
            }
            result.add(classLikeType);
        }
    }

    private void fillSuperClassesNoSwitchToAst(@NotNull TypeEvalContext context, @Nullable PyClassStub stub, @NotNull List<PyClassLikeType> result) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(61);
        }
        if (result == null) {
            PyClassImpl.$$$reportNull$$$0(62);
        }
        Map<QualifiedName, QualifiedName> superClasses = stub != null ? stub.getSuperClasses() : PyClassElementType.getSuperClassQNames(this);
        PsiFile file = this.getContainingFile();
        if (file instanceof PyFile) {
            for (QualifiedName name : superClasses.keySet()) {
                result.add(name != null ? PyClassImpl.classTypeFromQName(name, (PyFile)file, context) : null);
            }
        }
    }

    @Nullable
    private PyClassLikeType getImplicitSuper(@NotNull TypeEvalContext context) {
        PyBuiltinCache builtinCache;
        PyClassType objectType;
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(63);
        }
        if ((objectType = (builtinCache = PyBuiltinCache.getInstance((PsiElement)this)).getObjectType()) != null && this == objectType.getPyClass()) {
            return null;
        }
        if (LanguageLevel.forElement((PsiElement)this).isPython2() && this.getMetaClassQName() == null && !PyClassImpl.hasNewStyleMetaClass(this)) {
            QualifiedName typesInstanceTypeQName = QualifiedName.fromDottedString((String)"types.InstanceType");
            PsiElement typesInstanceType = PyResolveImportUtil.resolveTopLevelMember(typesInstanceTypeQName, PyResolveImportUtil.fromFoothold((PsiElement)this));
            return Optional.ofNullable(PyUtil.as(typesInstanceType, PyClass.class)).map(context::getType).map(type -> PyUtil.as(type, PyClassLikeType.class)).orElse(null);
        }
        return objectType == null ? null : (PyClassLikeType)objectType.toClass();
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getAncestorTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(64);
        }
        List list = ContainerUtil.filter(this.getAncestorTypesWithMetaClassInstances(context), type -> type == null || type.isDefinition());
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(65);
        }
        return list;
    }

    @NotNull
    private List<PyClassLikeType> getAncestorTypesWithMetaClassInstances(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(66);
        }
        List list = (List)PyUtil.getParameterizedCachedValue((PsiElement)this, context, contextArgument -> {
            List<PyClassLikeType> ancestorTypes;
            if (this.isNewStyleClass((TypeEvalContext)contextArgument)) {
                try {
                    ancestorTypes = this.getMROAncestorTypes((TypeEvalContext)contextArgument);
                }
                catch (MROException ignored) {
                    ancestorTypes = this.getOldStyleAncestorTypes((TypeEvalContext)contextArgument);
                    boolean hasUnresolvedAncestorTypes = false;
                    for (PyClassLikeType type : ancestorTypes) {
                        if (type != null) continue;
                        hasUnresolvedAncestorTypes = true;
                        break;
                    }
                    if (!hasUnresolvedAncestorTypes) {
                        ancestorTypes = Collections.singletonList(null);
                    }
                }
            } else {
                ancestorTypes = this.getOldStyleAncestorTypes((TypeEvalContext)contextArgument);
            }
            return ancestorTypes;
        });
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(67);
        }
        return list;
    }

    @Override
    @Nullable
    public PyType getMetaClassType(@NotNull TypeEvalContext context) {
        PsiElement element;
        LanguageLevel level;
        PyFile pyFile;
        PsiFile file;
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(68);
        }
        PyPsiUtils.assertValid((PsiElement)this);
        if (context.maySwitchToAST((PsiElement)this)) {
            PyType type;
            PyExpression expression = this.getMetaClassExpression();
            if (expression != null && (type = context.getType(expression)) != null) {
                return type;
            }
        } else {
            QualifiedName name = this.getMetaClassQName();
            file = this.getContainingFile();
            if (file instanceof PyFile) {
                pyFile = (PyFile)file;
                if (name != null) {
                    return PyClassImpl.classTypeFromQName(name, pyFile, context);
                }
            }
        }
        if ((level = LanguageLevel.forElement((PsiElement)this)).isPython2() && (file = this.getContainingFile()) instanceof PyFile && (element = (pyFile = (PyFile)file).getElementNamed("__metaclass__")) instanceof PyTypedElement) {
            return context.getType((PyTypedElement)element);
        }
        return null;
    }

    @Override
    @Nullable
    public PyClassLikeType getMetaClassType(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(69);
        }
        if (!inherited) {
            return PyUtil.as(this.getMetaClassType(context), PyClassLikeType.class);
        }
        List<PyClassLikeType> metaClassTypes = this.getAllPossibleMetaClassTypes(context);
        PyClassLikeType mostDerivedMeta = PyClassImpl.getMostDerivedClassType(metaClassTypes, context);
        return mostDerivedMeta != null ? mostDerivedMeta : PyBuiltinCache.getInstance((PsiElement)this).getObjectType("type");
    }

    @Nullable
    private static PyClassLikeType getMostDerivedClassType(@NotNull List<PyClassLikeType> classTypes, @NotNull TypeEvalContext context) {
        if (classTypes == null) {
            PyClassImpl.$$$reportNull$$$0(70);
        }
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(71);
        }
        if (classTypes.isEmpty()) {
            return null;
        }
        try {
            return classTypes.stream().filter(t -> !"abc.ABCMeta".equals(t.getClassQName())).max((t1, t2) -> {
                if (Objects.equals(t1, t2)) {
                    return 0;
                }
                if (t2 == null || t1 != null && t1.getAncestorTypes(context).contains(t2)) {
                    return 1;
                }
                if (t1 == null || t2.getAncestorTypes(context).contains(t1)) {
                    return -1;
                }
                throw new NotDerivedClassTypeException();
            }).orElse(null);
        }
        catch (NotDerivedClassTypeException ignored) {
            return null;
        }
    }

    @NotNull
    private List<PyClassLikeType> getAllPossibleMetaClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(72);
        }
        ArrayList results = Lists.newArrayList();
        PyClassLikeType ownMeta = this.getMetaClassType(false, context);
        if (ownMeta != null) {
            results.add(ownMeta);
        }
        for (PyClassLikeType ancestor : this.getAncestorTypesWithMetaClassInstances(context)) {
            if (ancestor == null) continue;
            if (!ancestor.isDefinition()) {
                results.add(ancestor.toClass());
                continue;
            }
            PyClassLikeType ancestorMeta = ancestor.getMetaClassType(context, false);
            if (ancestorMeta == null) continue;
            results.add(ancestorMeta);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(73);
        }
        return arrayList;
    }

    @Nullable
    private QualifiedName getMetaClassQName() {
        PyClassStub stub = (PyClassStub)this.getStub();
        return stub != null ? stub.getMetaClass() : PyPsiUtils.asQualifiedName(this.getMetaClassExpression());
    }

    @Override
    @Nullable
    public PyExpression getMetaClassExpression() {
        LanguageLevel level = LanguageLevel.forElement((PsiElement)this);
        if (!level.isPython2()) {
            for (PyExpression expression : this.getSuperClassExpressions()) {
                PyKeywordArgument argument;
                if (!(expression instanceof PyKeywordArgument) || !"metaclass".equals((argument = (PyKeywordArgument)expression).getKeyword())) continue;
                return argument.getValueExpression();
            }
        } else {
            PyExpression[] attribute = this.findClassAttribute("__metaclass__", false, null);
            if (attribute != null) {
                return attribute.findAssignedValue();
            }
        }
        for (PyExpression expression : this.getSuperClassExpressions()) {
            PyExpression[] arguments;
            if (!PyClassImpl.isSixWithMetaclassCall(expression) || (arguments = ((PyCallExpression)expression).getArguments()).length == 0) continue;
            return arguments[0];
        }
        PyDecoratorList decoratorList = this.getDecoratorList();
        if (decoratorList != null) {
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                PyExpression[] arguments;
                if (!PyClassImpl.isSixAddMetaclass(decorator) || (arguments = decorator.getArguments()).length == 0) continue;
                return arguments[0];
            }
        }
        return null;
    }

    private static boolean isSixAddMetaclass(@NotNull PyDecorator decorator) {
        PyExpression callee;
        if (decorator == null) {
            PyClassImpl.$$$reportNull$$$0(74);
        }
        if ((callee = decorator.getCallee()) instanceof PyReferenceExpression) {
            QualifiedName sixAddMetaclass = QualifiedName.fromComponents((String[])new String[]{"six", "add_metaclass"});
            QualifiedName djangoAddMetaclass = QualifiedName.fromDottedString((String)"django.utils.six.add_metaclass");
            return ContainerUtil.exists(PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)callee), name -> name.equals((Object)sixAddMetaclass) || name.equals((Object)djangoAddMetaclass));
        }
        return false;
    }

    @NotNull
    private List<PyClassLikeType> getMROAncestorTypes(@NotNull TypeEvalContext context) throws MROException {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(75);
        }
        PyPsiUtils.assertValid((PsiElement)this);
        PyType thisType = context.getType(this);
        if (thisType instanceof PyClassLikeType) {
            List<PyClassLikeType> ancestorTypes = PyClassImpl.mroLinearize((PyClassLikeType)thisType, false, context, new HashMap<PyClassLikeType, Ref<List<PyClassLikeType>>>());
            if (this.isOverriddenMRO(ancestorTypes, context)) {
                ArrayList<PyClassLikeType> withNull = new ArrayList<PyClassLikeType>(ancestorTypes);
                withNull.add(null);
                ArrayList<PyClassLikeType> arrayList = withNull;
                if (arrayList == null) {
                    PyClassImpl.$$$reportNull$$$0(76);
                }
                return arrayList;
            }
            List<PyClassLikeType> list = ancestorTypes;
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(77);
            }
            return list;
        }
        List<PyClassLikeType> list = Collections.emptyList();
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(78);
        }
        return list;
    }

    private boolean isOverriddenMRO(@NotNull List<PyClassLikeType> ancestorTypes, @NotNull TypeEvalContext context) {
        if (ancestorTypes == null) {
            PyClassImpl.$$$reportNull$$$0(79);
        }
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(80);
        }
        ArrayList<PyClass> classes = new ArrayList<PyClass>();
        classes.add(this);
        for (PyClassLikeType ancestorType : ancestorTypes) {
            if (!(ancestorType instanceof PyClassType)) continue;
            PyClassType classType = (PyClassType)ancestorType;
            classes.add(classType.getPyClass());
        }
        PyClass typeClass = PyBuiltinCache.getInstance((PsiElement)this).getClass("type");
        for (PyClass cls : classes) {
            PyClass mroClass;
            PyType metaClassType = cls.getMetaClassType(context);
            if (!(metaClassType instanceof PyClassType)) continue;
            PyClass metaClass = ((PyClassType)metaClassType).getPyClass();
            if (cls == metaClass) {
                return false;
            }
            PyFunction mroMethod = metaClass.findMethodByName("mro", true, null);
            if (mroMethod == null || (mroClass = mroMethod.getContainingClass()) == null || mroClass == typeClass) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<PyClassLikeType> getOldStyleAncestorTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(81);
        }
        ArrayList<PyClassLikeType> results = new ArrayList<PyClassLikeType>();
        LinkedList<PyClassLikeType> toProcess = new LinkedList<PyClassLikeType>();
        HashSet<PyClassLikeType> seen = new HashSet<PyClassLikeType>();
        HashSet<PyClassLikeType> visited = new HashSet<PyClassLikeType>();
        PyType thisType = context.getType(this);
        if (thisType instanceof PyClassLikeType) {
            toProcess.add((PyClassLikeType)thisType);
        }
        while (!toProcess.isEmpty()) {
            PyClassLikeType currentType = (PyClassLikeType)toProcess.pollFirst();
            if (!visited.add(currentType)) continue;
            for (PyClassLikeType superType : currentType.getSuperClassTypes(context)) {
                if (superType == null || !seen.contains(superType)) {
                    results.add(superType);
                    seen.add(superType);
                }
                if (superType == null || visited.contains(superType)) continue;
                toProcess.addLast(superType);
            }
        }
        ArrayList<PyClassLikeType> arrayList = results;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(82);
        }
        return arrayList;
    }

    @Nullable
    private static PyClassLikeType classTypeFromQName(@NotNull QualifiedName qualifiedName, @NotNull PyFile containingFile, @NotNull TypeEvalContext context) {
        PyType type;
        PsiElement element;
        if (qualifiedName == null) {
            PyClassImpl.$$$reportNull$$$0(83);
        }
        if (containingFile == null) {
            PyClassImpl.$$$reportNull$$$0(84);
        }
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(85);
        }
        if ((element = (PsiElement)ContainerUtil.getFirstItem(PyResolveUtil.resolveQualifiedNameInScope(qualifiedName, containingFile, context))) instanceof PyTypedElement && (type = context.getType((PyTypedElement)element)) instanceof PyClassLikeType) {
            return (PyClassLikeType)type;
        }
        return null;
    }

    @Override
    @Nullable
    public PyClassLikeType getType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassImpl.$$$reportNull$$$0(86);
        }
        return PyUtil.as(context.getType(this), PyClassLikeType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 65: 
            case 67: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 65: 
            case 67: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 6: 
            case 37: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 65: 
            case 67: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyClassImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassQName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequences";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenClass";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 44: 
            case 46: 
            case 48: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classTypes";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorTypes";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyClassImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassExpressions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnfoldedSuperClassExpressions";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "unfoldSuperClassExpression";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorClasses";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "mroMerge";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "mroLinearize";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNotNullDuplicates";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassChildren";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "multiFindMethodByName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "multiFindInitOrNew";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAttributesInherited";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetExpressions";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassTypes";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorTypes";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorTypesWithMetaClassInstances";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPossibleMetaClassTypes";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getMROAncestorTypes";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldStyleAncestorTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 65: 
            case 67: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 82: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUnfoldedSuperClassExpressions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unfoldSuperClassExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSixWithMetaclassCall";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSubclass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mroMerge";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mroLinearize";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeNotNullDuplicates";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getClassChildren";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "multiFindMethodByName";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getClassAttributesInherited";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findClassAttribute";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "collectAttributesInNew";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "collectInstanceAttributes";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTargetExpressions";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processClassLevelDeclarations";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processInstanceLevelDeclarations";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypes";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "fillSuperClassesSwitchingToAst";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "fillSuperClassesNoSwitchToAst";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitSuper";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorTypes";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorTypesWithMetaClassInstances";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClassType";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getMostDerivedClassType";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getAllPossibleMetaClassTypes";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isSixAddMetaclass";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getMROAncestorTypes";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isOverriddenMRO";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getOldStyleAncestorTypes";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "classTypeFromQName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 65: 
            case 67: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyAttributesCollector
    implements Processor<PyTargetExpression> {
        private final List<PyTargetExpression> myAttributes = new ArrayList<PyTargetExpression>();

        private MyAttributesCollector() {
        }

        public boolean process(PyTargetExpression expression) {
            this.myAttributes.add(expression);
            return true;
        }

        @NotNull
        List<PyTargetExpression> getAttributes() {
            List<PyTargetExpression> list = Collections.unmodifiableList(this.myAttributes);
            if (list == null) {
                MyAttributesCollector.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$MyAttributesCollector", "getAttributes"));
        }
    }

    private static final class NotDerivedClassTypeException
    extends RuntimeException {
        private NotDerivedClassTypeException() {
        }
    }

    private static class PropertyImpl
    extends PropertyBunch<PyCallable>
    implements Property {
        private final String myName;

        private PropertyImpl(String name, Maybe<PyCallable> getter, Maybe<PyCallable> setter, Maybe<PyCallable> deleter, String doc, PyTargetExpression site) {
            this.myName = name;
            this.myDeleter = deleter;
            this.myGetter = getter;
            this.mySetter = setter;
            this.myDoc = doc;
            this.mySite = site;
        }

        @Override
        @NotNull
        public Maybe<PyCallable> getGetter() {
            Maybe<PyCallable> maybe = PropertyImpl.filterNonStubExpression(this.myGetter);
            if (maybe == null) {
                PropertyImpl.$$$reportNull$$$0(0);
            }
            return maybe;
        }

        @Override
        @NotNull
        public Maybe<PyCallable> getSetter() {
            Maybe<PyCallable> maybe = PropertyImpl.filterNonStubExpression(this.mySetter);
            if (maybe == null) {
                PropertyImpl.$$$reportNull$$$0(1);
            }
            return maybe;
        }

        @Override
        @NotNull
        public Maybe<PyCallable> getDeleter() {
            Maybe<PyCallable> maybe = PropertyImpl.filterNonStubExpression(this.myDeleter);
            if (maybe == null) {
                PropertyImpl.$$$reportNull$$$0(2);
            }
            return maybe;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        @Nullable
        public PyTargetExpression getDefinitionSite() {
            return this.mySite;
        }

        @Override
        @NotNull
        public Maybe<PyCallable> getByDirection(@NotNull AccessDirection direction) {
            if (direction == null) {
                PropertyImpl.$$$reportNull$$$0(3);
            }
            switch (direction) {
                case READ: {
                    Maybe<PyCallable> maybe = this.getGetter();
                    if (maybe == null) {
                        PropertyImpl.$$$reportNull$$$0(4);
                    }
                    return maybe;
                }
                case WRITE: {
                    Maybe<PyCallable> maybe = this.getSetter();
                    if (maybe == null) {
                        PropertyImpl.$$$reportNull$$$0(5);
                    }
                    return maybe;
                }
                case DELETE: {
                    Maybe<PyCallable> maybe = this.getDeleter();
                    if (maybe == null) {
                        PropertyImpl.$$$reportNull$$$0(6);
                    }
                    return maybe;
                }
            }
            throw new IllegalArgumentException("Unknown direction " + PyUtil.nvl((Object)direction));
        }

        @Override
        @Nullable
        public PyType getType(@Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
            PyType targetDocStringType;
            if (context == null) {
                PropertyImpl.$$$reportNull$$$0(7);
            }
            if (this.mySite instanceof PyTargetExpressionImpl && (targetDocStringType = ((PyTargetExpressionImpl)this.mySite).getTypeFromDocString()) != null) {
                return targetDocStringType;
            }
            PyCallable callable = (PyCallable)this.myGetter.valueOrNull();
            if (callable != null) {
                if (!(callable instanceof StubBasedPsiElement) && !context.maySwitchToAST((PsiElement)callable)) {
                    return null;
                }
                return callable.getCallType(receiver, Collections.emptyMap(), context);
            }
            return null;
        }

        @Override
        @NotNull
        protected Maybe<PyCallable> translate(@Nullable PyExpression expr) {
            PsiElement something;
            if (expr == null || expr instanceof PyNoneLiteralExpression) {
                Maybe maybe = NONE;
                if (maybe == null) {
                    PropertyImpl.$$$reportNull$$$0(8);
                }
                return maybe;
            }
            if (expr instanceof PyCallable) {
                Maybe<PyCallable> maybe = new Maybe<PyCallable>((PyCallable)((Object)expr));
                if (maybe == null) {
                    PropertyImpl.$$$reportNull$$$0(9);
                }
                return maybe;
            }
            PsiReference ref = expr.getReference();
            if (ref != null && (something = ref.resolve()) instanceof PyCallable) {
                Maybe<PyCallable> maybe = new Maybe<PyCallable>((PyCallable)something);
                if (maybe == null) {
                    PropertyImpl.$$$reportNull$$$0(10);
                }
                return maybe;
            }
            Maybe maybe = NONE;
            if (maybe == null) {
                PropertyImpl.$$$reportNull$$$0(11);
            }
            return maybe;
        }

        @NotNull
        private static Maybe<PyCallable> filterNonStubExpression(@NotNull Maybe<PyCallable> maybeCallable) {
            PyCallable callable;
            if (maybeCallable == null) {
                PropertyImpl.$$$reportNull$$$0(12);
            }
            if ((callable = maybeCallable.valueOrNull()) != null && !(callable instanceof StubBasedPsiElement)) {
                Maybe maybe = UNKNOWN_CALL;
                if (maybe == null) {
                    PropertyImpl.$$$reportNull$$$0(13);
                }
                return maybe;
            }
            Maybe<PyCallable> maybe = maybeCallable;
            if (maybe == null) {
                PropertyImpl.$$$reportNull$$$0(14);
            }
            return maybe;
        }

        public String toString() {
            return "property(" + this.myGetter + ", " + this.mySetter + ", " + this.myDeleter + ", " + this.myDoc + ")";
        }

        @Nullable
        public static PropertyImpl fromTarget(PyTargetExpression target) {
            PropertyImpl prop;
            PyExpression expr = target.findAssignedValue();
            boolean success = PropertyImpl.fillFromCall(expr, prop = new PropertyImpl(target.getName(), null, null, null, null, target));
            return success ? prop : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 7: 
                case 12: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 7: 
                case 12: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "direction";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maybeCallable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGetter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSetter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeleter";
                    break;
                }
                case 3: 
                case 7: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getByDirection";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "translate";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterNonStubExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getByDirection";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "filterNonStubExpression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 7: 
                case 12: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MultiNameFinder<T extends PyElement>
    implements Processor<T> {
        @NotNull
        private final List<T> myResult;
        @NotNull
        private final String[] myNames;
        @Nullable
        private PyClass myLastVisitedClass;

        MultiNameFinder(String ... names) {
            if (names == null) {
                MultiNameFinder.$$$reportNull$$$0(0);
            }
            this.myResult = new ArrayList<T>();
            this.myNames = names;
            this.myLastVisitedClass = null;
        }

        public boolean process(T t) {
            PyClass currentClass;
            PyClass pyClass = currentClass = t instanceof PyPossibleClassMember ? ((PyPossibleClassMember)t).getContainingClass() : null;
            if (this.myLastVisitedClass != null && currentClass != this.myLastVisitedClass && !this.myResult.isEmpty()) {
                return false;
            }
            this.myLastVisitedClass = currentClass;
            if (ArrayUtil.contains((String)t.getName(), (String[])this.myNames)) {
                this.myResult.add(t);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/python/psi/impl/PyClassImpl$MultiNameFinder", "<init>"));
        }
    }

    private static class NameFinder<T extends PyElement>
    implements Processor<T> {
        private T myResult;
        private final String[] myNames;
        private int myLastResultIndex = -1;
        private PyClass myLastVisitedClass = null;

        NameFinder(String ... names) {
            this.myNames = names;
            this.myResult = null;
        }

        public T getResult() {
            return this.myResult;
        }

        @Nullable
        protected PyClass getContainingClass(@NotNull T element) {
            if (element == null) {
                NameFinder.$$$reportNull$$$0(0);
            }
            return null;
        }

        public boolean process(T target) {
            PyClass currentClass = this.getContainingClass(target);
            if (this.myLastVisitedClass != null && this.myLastVisitedClass != currentClass && this.myResult != null) {
                return false;
            }
            this.myLastVisitedClass = currentClass;
            int index = ArrayUtil.indexOf((Object[])this.myNames, (Object)target.getName());
            if (index >= 0 && (this.myLastResultIndex == -1 || index < this.myLastResultIndex)) {
                this.myLastResultIndex = index;
                this.myResult = target;
                if (index == 0) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyClassImpl$NameFinder", "getContainingClass"));
        }
    }

    public static class MROException
    extends Exception {
        public MROException(String s) {
            super(s);
        }
    }
}

