/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import processing.app.Base;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class Welcome2
extends JFrame {
    Base base;
    boolean newSketchbook;

    public Welcome2(Base base, boolean oldSketchbook) throws IOException {
        this.base = base;
        Color insetColor = new Color(224, 253, 251);
        Color linkColor = new Color(44, 123, 181);
        Font headerFont = Toolkit.getSansFont(20, 1);
        Font bodyFont = Toolkit.getSansFont(12, 0);
        this.setTitle("Welcome to Processing 3");
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel(new GridBagLayout());
        Toolkit.setBorder(panel, 20, 20, 20, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        int width = 400;
        int height = oldSketchbook ? 400 : 250;
        panel.setPreferredSize(Toolkit.zoom(width, height));
        panel.setBackground(Color.white);
        JLabel logo = new JLabel(Toolkit.getLibIcon("/icons/pde-64.png"));
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)logo, c);
        JLabel header = new JLabel("Welcome to Processing 3");
        header.setFont(headerFont);
        c.gridx = 1;
        c.gridy = 0;
        panel.add((Component)header, c);
        JLabel readNew = new JLabel("Read about what's new in 3.0 \u2192");
        readNew.setForeground(linkColor);
        readNew.setFont(bodyFont);
        readNew.setCursor(new Cursor(12));
        readNew.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Platform.openURL("https://github.com/processing/processing/wiki/Changes-in-3.0");
            }
        });
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)readNew, c);
        JPanel compatible = new JPanel(new GridBagLayout());
        GridBagConstraints compc = new GridBagConstraints();
        compatible.setBackground(insetColor);
        Toolkit.setBorder(compatible, 10, 0, 10, 0);
        compc.anchor = 23;
        compc.fill = 2;
        JLabel compatibleNotice = new JLabel("Note that some sketches from Processing 2 may not be compatible.");
        compatibleNotice.setFont(bodyFont);
        compc.gridx = 0;
        compc.gridy = 0;
        compatible.add((Component)compatibleNotice, compc);
        JLabel changed = new JLabel("What has changed?");
        changed.setFont(bodyFont);
        changed.setForeground(linkColor);
        changed.setCursor(new Cursor(12));
        changed.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Platform.openURL("https://github.com/processing/processing/wiki/Changes-in-3.0");
            }
        });
        compc.gridx = 0;
        compc.gridy = 1;
        compatible.add((Component)changed, compc);
        c.gridx = 0;
        c.gridy = 2;
        panel.add((Component)compatible, c);
        if (oldSketchbook) {
            JTextArea newSketchbookPrompt = new JTextArea("Since older sketches may not be compatible, we recommend creating a new sketchbook folder, so Processing 2 and 3 can happily coexist. This is a one-time process.");
            newSketchbookPrompt.setFont(bodyFont);
            newSketchbookPrompt.setEditable(false);
            newSketchbookPrompt.setLineWrap(true);
            newSketchbookPrompt.setWrapStyleWord(true);
            c.gridx = 0;
            c.gridy = 3;
            panel.add((Component)newSketchbookPrompt, c);
            JLabel readMore = new JLabel("Read more about it");
            readMore.setFont(bodyFont);
            c.gridx = 0;
            c.gridy = 4;
            panel.add((Component)readMore, c);
            JPanel chooseSketchbook = new JPanel(new GridBagLayout());
            Toolkit.setBorder(chooseSketchbook, 10, 0, 10, 0);
            GridBagConstraints choosec = new GridBagConstraints();
            choosec.fill = 2;
            choosec.anchor = 21;
            chooseSketchbook.setBackground(insetColor);
            ButtonGroup sketchbookGroup = new ButtonGroup();
            JRadioButton createNew = new JRadioButton("Create a new sketchbook folder for use with Processing 3 sketches (recommended!)");
            sketchbookGroup.add(createNew);
            createNew.setSelected(true);
            createNew.setFont(bodyFont);
            createNew.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        Welcome2.this.newSketchbook = true;
                    }
                }
            });
            this.newSketchbook = true;
            choosec.gridx = 0;
            choosec.gridy = 0;
            chooseSketchbook.add((Component)createNew, choosec);
            JRadioButton useOld = new JRadioButton("<html>Use the existing sketchbook for both old and new sketches (may cause conflicts with installed libraries)");
            sketchbookGroup.add(useOld);
            useOld.setFont(bodyFont);
            useOld.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        Welcome2.this.newSketchbook = false;
                    }
                }
            });
            choosec.gridx = 0;
            choosec.gridy = 1;
            chooseSketchbook.add((Component)useOld, choosec);
            c.gridx = 0;
            c.gridy = 5;
            panel.add((Component)chooseSketchbook, c);
        }
        JCheckBox showEachTime = new JCheckBox("<html>Show this welcome message each time");
        showEachTime.setSelected("true".equals(Preferences.get("welcome.show")));
        showEachTime.setFont(bodyFont);
        showEachTime.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Preferences.setBoolean("welcome.show", true);
                } else if (e.getStateChange() == 2) {
                    Preferences.setBoolean("welcome.show", false);
                }
            }
        });
        c.gridx = 0;
        c.gridy = 6;
        panel.add((Component)showEachTime, c);
        JButton getStarted = new JButton("Get Started");
        getStarted.setFont(bodyFont);
        getStarted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Welcome2.this.handleClose();
            }
        });
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 7;
        c.anchor = 26;
        panel.add((Component)getStarted, c);
        this.add(panel);
        this.pack();
        Toolkit.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Welcome2.this.handleClose();
            }
        });
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void sketchbookCallback(File folder) {
        if (folder != null) {
            if (this.base != null) {
                this.base.setSketchbookFolder(folder);
            } else {
                System.out.println("user selected " + folder);
            }
        }
    }

    public void handleClose() {
        Preferences.save();
        if (this.newSketchbook) {
            File folder = new File(Preferences.getSketchbookPath()).getParentFile();
            PApplet.selectFolder((String)Language.text("preferences.sketchbook_location.popup"), (String)"sketchbookCallback", (File)folder, (Object)this, (Frame)this);
        }
        this.dispose();
    }
}

