/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;

final class TimelineSelectionOverlay
extends ChartOverlay {
    private TimelineChart chart;
    private TimelineSupport support;
    private int selectionExtent;
    private ConfigurationListener configurationListener;
    private SelectionListener selectionListener;
    private TimeSelectionListener timeSelectionListener;
    private final Set<Point> highlightedValues;
    private final Set<Point> selectedValues;
    private Paint sMarkPaint;
    private Paint sOddPerfPaint;
    private Paint sEvenPerfPaint;
    private Paint hMarkPaint;
    private Paint hOddPerfPaint;
    private Paint hEvenPerfPaint;
    private Stroke markStroke;
    private Stroke oddPerfStroke;
    private Stroke evenPerfStroke;
    private final Set<Integer> paintedLines = new HashSet<Integer>();

    TimelineSelectionOverlay() {
        this.configurationListener = new ConfigurationListener();
        this.selectionListener = new SelectionListener();
        this.timeSelectionListener = new TimeSelectionListener();
        this.highlightedValues = new HashSet<Point>();
        this.selectedValues = new HashSet<Point>();
        this.initDefaultValues();
    }

    final void registerChart(TimelineSupport timelineSupport) {
        this.unregisterListener();
        this.support = timelineSupport;
        this.chart = timelineSupport.getChart();
        this.registerListener();
    }

    final void unregisterChart(TimelineSupport timelineSupport) {
        this.unregisterListener();
        this.support = null;
        this.chart = null;
    }

    private void registerListener() {
        if (this.support == null || this.chart == null) {
            return;
        }
        this.chart.addConfigurationListener((ChartConfigurationListener)this.configurationListener);
        this.chart.addRowListener(this.configurationListener);
        this.chart.getSelectionModel().addSelectionListener((ChartSelectionListener)this.selectionListener);
        this.support.addSelectionListener(this.timeSelectionListener);
    }

    private void unregisterListener() {
        if (this.support == null || this.chart == null) {
            return;
        }
        this.chart.removeConfigurationListener((ChartConfigurationListener)this.configurationListener);
        this.chart.removeRowListener(this.configurationListener);
        this.chart.getSelectionModel().removeSelectionListener((ChartSelectionListener)this.selectionListener);
        this.support.removeSelectionListener(this.timeSelectionListener);
    }

    private void initDefaultValues() {
        this.sMarkPaint = new Color(120, 120, 120);
        this.sOddPerfPaint = new Color(120, 120, 120);
        this.sEvenPerfPaint = Color.WHITE;
        this.hMarkPaint = new Color(80, 80, 80);
        this.hOddPerfPaint = Color.BLACK;
        this.hEvenPerfPaint = Color.WHITE;
        this.markStroke = new BasicStroke(2.8f, 1, 1);
        this.oddPerfStroke = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{1.0f, 3.0f}, 0.0f);
        this.evenPerfStroke = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{1.0f, 3.0f}, 2.0f);
        this.selectionExtent = 3;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Point point;
        if (this.highlightedValues.isEmpty() && this.selectedValues.isEmpty()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(this.chart.getRenderingHints());
        Iterator<Point> iterator = this.selectedValues.iterator();
        this.paintedLines.clear();
        int n3 = this.getHeight();
        int n4 = 1 - this.selectionExtent;
        int n5 = this.selectionExtent * 2 - 1;
        while (iterator.hasNext()) {
            point = iterator.next();
            n2 = point.x;
            n = point.y;
            if (n == -1) continue;
            if (!this.paintedLines.contains(n2)) {
                graphics2D.setPaint(this.sEvenPerfPaint);
                graphics2D.setStroke(this.evenPerfStroke);
                graphics2D.drawLine(n2, 0, n2, n3);
                graphics2D.setPaint(this.sOddPerfPaint);
                graphics2D.setStroke(this.oddPerfStroke);
                graphics2D.drawLine(n2, 0, n2, n3);
                graphics2D.setPaint(this.sMarkPaint);
                graphics2D.setStroke(this.markStroke);
                this.paintedLines.add(n2);
            }
            if (n - this.selectionExtent < 0 || n + this.selectionExtent > n3) continue;
            graphics2D.fillOval(n2 + n4, n + n4, n5, n5);
        }
        iterator = this.highlightedValues.iterator();
        this.paintedLines.clear();
        while (iterator.hasNext()) {
            point = iterator.next();
            n2 = point.x;
            n = point.y;
            if (n == -1) continue;
            if (!this.paintedLines.contains(n2)) {
                graphics2D.setPaint(this.hEvenPerfPaint);
                graphics2D.setStroke(this.evenPerfStroke);
                graphics2D.drawLine(n2, 0, n2, n3);
                graphics2D.setPaint(this.hOddPerfPaint);
                graphics2D.setStroke(this.oddPerfStroke);
                graphics2D.drawLine(n2, 0, n2, n3);
                graphics2D.setPaint(this.hMarkPaint);
                graphics2D.setStroke(this.markStroke);
                this.paintedLines.add(n2);
            }
            if (n - this.selectionExtent < 0 || n + this.selectionExtent > n3) continue;
            graphics2D.fillOval(n2 + n4, n + n4, n5, n5);
        }
    }

    private void vLineBoundsChanged(Set<Point> set, Set<Point> set2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Point object : set) {
            treeSet.add(object.x);
        }
        int n = treeSet.size();
        if (n == 1) {
            this.repaint((Integer)treeSet.first() - this.selectionExtent, 0, this.selectionExtent * 2, this.getHeight());
            treeSet.clear();
        }
        for (Point n3 : set2) {
            treeSet.add(n3.x);
        }
        n = treeSet.size();
        if (n == 1) {
            this.repaint((Integer)treeSet.first() - this.selectionExtent, 0, this.selectionExtent * 2, this.getHeight());
        } else if (n > 1) {
            int n2 = (Integer)treeSet.first() - this.selectionExtent;
            int n3 = (Integer)treeSet.last() + this.selectionExtent;
            this.repaint(n2, 0, n3 - n2, this.getHeight());
        }
    }

    private List<ItemSelection> getSelections() {
        ArrayList<ItemSelection> arrayList = new ArrayList<ItemSelection>();
        Set<Integer> set = this.support.getSelectedTimestamps();
        SynchronousXYItemsModel synchronousXYItemsModel = (SynchronousXYItemsModel)this.chart.getItemsModel();
        int n = synchronousXYItemsModel.getItemsCount();
        for (int i = 0; i < n; ++i) {
            for (int n2 : set) {
                arrayList.add((ItemSelection)new XYItemSelection.Default((XYItem)synchronousXYItemsModel.getItem(i), n2, Integer.MAX_VALUE));
            }
        }
        return arrayList;
    }

    private static void updateValues(Set<Point> set, List<ItemSelection> list, TimelineChart timelineChart) {
        set.clear();
        for (ItemSelection itemSelection : list) {
            XYItemSelection xYItemSelection = (XYItemSelection)itemSelection;
            XYItem xYItem = xYItemSelection.getItem();
            TimelineXYPainter timelineXYPainter = (TimelineXYPainter)timelineChart.getPaintersModel().getPainter((ChartItem)xYItem);
            ChartContext chartContext = timelineChart.getChartContext((ChartItem)xYItem);
            long l = xYItem.getXValue(xYItemSelection.getValueIndex());
            long l2 = xYItem.getYValue(xYItemSelection.getValueIndex());
            int n = Utils.checkedInt((double)Math.ceil(chartContext.getViewX((double)l)));
            int n2 = Utils.checkedInt((double)Math.ceil(timelineXYPainter.getItemView(l2, xYItem, chartContext)));
            if (n < 0 || n > timelineChart.getWidth()) continue;
            set.add(new Point(n, n2));
        }
    }

    private class TimeSelectionListener
    implements TimelineSupport.SelectionListener {
        private TimeSelectionListener() {
        }

        @Override
        public void intervalsSelectionChanged() {
        }

        @Override
        public void indexSelectionChanged() {
        }

        @Override
        public void timeSelectionChanged(boolean bl, boolean bl2) {
            HashSet hashSet = new HashSet(TimelineSelectionOverlay.this.selectedValues);
            TimelineSelectionOverlay.updateValues(TimelineSelectionOverlay.this.selectedValues, TimelineSelectionOverlay.this.getSelections(), TimelineSelectionOverlay.this.chart);
            TimelineSelectionOverlay.this.vLineBoundsChanged(hashSet, TimelineSelectionOverlay.this.selectedValues);
        }
    }

    private class SelectionListener
    implements ChartSelectionListener {
        private SelectionListener() {
        }

        public void selectionModeChanged(int n, int n2) {
        }

        public void selectionBoundsChanged(Rectangle rectangle, Rectangle rectangle2) {
        }

        public void selectedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
        }

        public void highlightedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
            HashSet hashSet = new HashSet(TimelineSelectionOverlay.this.highlightedValues);
            TimelineSelectionOverlay.updateValues(TimelineSelectionOverlay.this.highlightedValues, list, TimelineSelectionOverlay.this.chart);
            TimelineSelectionOverlay.this.vLineBoundsChanged(hashSet, TimelineSelectionOverlay.this.highlightedValues);
        }
    }

    private class ConfigurationListener
    extends ChartConfigurationListener.Adapter
    implements TimelineChart.RowListener {
        private final Runnable selectionUpdater = new Runnable(){

            @Override
            public void run() {
                HashSet hashSet = new HashSet(TimelineSelectionOverlay.this.selectedValues);
                TimelineSelectionOverlay.updateValues(TimelineSelectionOverlay.this.selectedValues, TimelineSelectionOverlay.this.getSelections(), TimelineSelectionOverlay.this.chart);
                TimelineSelectionOverlay.this.vLineBoundsChanged(hashSet, TimelineSelectionOverlay.this.selectedValues);
                HashSet hashSet2 = new HashSet(TimelineSelectionOverlay.this.highlightedValues);
                TimelineSelectionOverlay.updateValues(TimelineSelectionOverlay.this.highlightedValues, TimelineSelectionOverlay.this.chart.getSelectionModel().getHighlightedItems(), TimelineSelectionOverlay.this.chart);
                TimelineSelectionOverlay.this.vLineBoundsChanged(hashSet2, TimelineSelectionOverlay.this.highlightedValues);
            }
        };

        private ConfigurationListener() {
        }

        public void contentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
            if (TimelineSelectionOverlay.this.highlightedValues.isEmpty() && !TimelineSelectionOverlay.this.support.isTimestampSelection(true)) {
                return;
            }
            if (l3 != l || l4 != l2 || d != d3 || d2 != d4) {
                SwingUtilities.invokeLater(this.selectionUpdater);
            }
        }

        @Override
        public void rowsAdded(List<TimelineChart.Row> list) {
            this.selectionUpdater.run();
        }

        @Override
        public void rowsRemoved(List<TimelineChart.Row> list) {
            this.selectionUpdater.run();
        }

        @Override
        public void rowsResized(List<TimelineChart.Row> list) {
            this.selectionUpdater.run();
        }
    }
}

