/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.latex.MathDeclaration;
import java.io.IOException;

public class L2LMathDeclaration
extends MathDeclaration {
    public L2LMathDeclaration() {
    }

    public L2LMathDeclaration(String string) {
        super(string);
    }

    public L2LMathDeclaration(String string, int n) {
        super(string, n);
    }

    public L2LMathDeclaration(String string, int n, boolean bl) {
        super(string, n, bl);
    }

    @Override
    public Object clone() {
        return new L2LMathDeclaration(this.getName(), this.getMode(), this.isNumbered());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        super.process(teXParser);
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (this.getMode() == 2) {
            l2HConverter.write("<div id=\"displaymath\">");
        }
        if (l2HConverter.useMathJax()) {
            l2HConverter.write("$");
        }
    }

    @Override
    public void end(TeXParser teXParser) throws IOException {
        super.end(teXParser);
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (l2HConverter.useMathJax()) {
            l2HConverter.write("$");
        }
        if (this.getMode() == 2) {
            l2HConverter.write("</div>");
        }
    }
}

