/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.swing.JDialog;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.security.dialogs.AccessWarningPane;
import net.sourceforge.jnlp.security.dialogs.AppletWarningPane;
import net.sourceforge.jnlp.security.dialogs.CertWarningPane;
import net.sourceforge.jnlp.security.dialogs.CertsInfoPane;
import net.sourceforge.jnlp.security.dialogs.InetSecurity511Panel;
import net.sourceforge.jnlp.security.dialogs.MissingALACAttributePanel;
import net.sourceforge.jnlp.security.dialogs.MissingPermissionsAttributePanel;
import net.sourceforge.jnlp.security.dialogs.MoreInfoPane;
import net.sourceforge.jnlp.security.dialogs.PasswordAuthenticationPane;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.security.dialogs.SingleCertInfoPane;
import net.sourceforge.jnlp.security.dialogs.ViwableDialog;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.AppTrustWarningDialog;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityDialog {
    private final SecurityDialogs.DialogType dialogType;
    private final SecurityDialogs.AccessType accessType;
    private SecurityDialogPanel panel;
    private final JNLPFile file;
    private final CertVerifier certVerifier;
    private final X509Certificate cert;
    private final Object[] extras;
    private boolean initialized = false;
    private DialogResult value;
    private ViwableDialog viwableDialog = new ViwableDialog();
    private boolean requiresSignedJNLPWarning;

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile file, CertVerifier JarCertVerifier2, X509Certificate cert, Object[] extras) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = file;
        this.certVerifier = JarCertVerifier2;
        this.cert = cert;
        this.extras = extras;
        this.initialized = true;
        if (file != null) {
            this.requiresSignedJNLPWarning = file.requiresSignedJNLPWarning();
        }
        this.initDialog();
    }

    private SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile file) {
        this(dialogType, accessType, file, null, null, null);
    }

    private SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile file, CertVerifier certVerifier) {
        this(dialogType, accessType, file, certVerifier, null, null);
    }

    private SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, CertVerifier certVerifier) {
        this(dialogType, accessType, null, certVerifier, null, null);
    }

    private SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile file, Object[] extras) {
        this(dialogType, accessType, file, null, null, extras);
    }

    private SecurityDialog(SecurityDialogs.DialogType dialogType, X509Certificate c) {
        this(dialogType, null, null, null, c, null);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static void showMoreInfoDialog(CertVerifier certVerifier, SecurityDialog parent) {
        JNLPFile file = parent.getFile();
        SecurityDialog dialog = new SecurityDialog(SecurityDialogs.DialogType.MORE_INFO, null, file, certVerifier);
        dialog.getViwableDialog().setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.getViwableDialog().show();
        dialog.getViwableDialog().dispose();
    }

    public static void showCertInfoDialog(CertVerifier certVerifier, Component parent) {
        SecurityDialog dialog = new SecurityDialog(SecurityDialogs.DialogType.CERT_INFO, null, null, certVerifier);
        dialog.getViwableDialog().setLocationRelativeTo(parent);
        dialog.getViwableDialog().setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.getViwableDialog().show();
        dialog.getViwableDialog().dispose();
    }

    public static void showSingleCertInfoDialog(X509Certificate c, JDialog parent) {
        SecurityDialog dialog = new SecurityDialog(SecurityDialogs.DialogType.SINGLE_CERT_INFO, c);
        dialog.getViwableDialog().setLocationRelativeTo(parent);
        dialog.getViwableDialog().setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.getViwableDialog().show();
        dialog.getViwableDialog().dispose();
    }

    private void initDialog() {
        String dialogTitle = this.createTitle();
        this.getViwableDialog().setTitle(dialogTitle);
        this.getViwableDialog().setModalityType(Dialog.ModalityType.MODELESS);
        this.getViwableDialog().setDefaultCloseOperation(2);
        this.installPanel();
        this.getViwableDialog().pack();
        this.getViwableDialog().centerDialog();
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    SecurityDialog.this.selectDefaultButton();
                    this.gotFocus = true;
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                if (e.getSource() instanceof SecurityDialog) {
                    SecurityDialog dialog = (SecurityDialog)e.getSource();
                    dialog.getViwableDialog().setResizable(true);
                    dialog.setValue(null);
                }
            }
        };
        this.getViwableDialog().addWindowListener(adapter);
        this.getViwableDialog().addWindowFocusListener(adapter);
    }

    private String createTitle() {
        return SecurityDialog.createTitle(this.dialogType, this.accessType);
    }

    private static String createTitle(SecurityDialogs.DialogType dtype, SecurityDialogs.AccessType atype) {
        String dialogTitle = "";
        if (dtype == SecurityDialogs.DialogType.CERT_WARNING) {
            dialogTitle = atype == SecurityDialogs.AccessType.VERIFIED ? "Security Approval Required" : "Security Warning";
        } else if (dtype == SecurityDialogs.DialogType.MORE_INFO) {
            dialogTitle = "More Information";
        } else if (dtype == SecurityDialogs.DialogType.CERT_INFO) {
            dialogTitle = "Details - Certificate";
        } else if (dtype == SecurityDialogs.DialogType.ACCESS_WARNING) {
            dialogTitle = "Security Warning";
        } else if (dtype == SecurityDialogs.DialogType.APPLET_WARNING) {
            dialogTitle = "Applet Warning";
        } else if (dtype == SecurityDialogs.DialogType.PARTIALLYSIGNED_WARNING) {
            dialogTitle = "Security Warning";
        } else if (dtype == SecurityDialogs.DialogType.AUTHENTICATION) {
            dialogTitle = "Authentication Required";
        }
        return dialogTitle;
    }

    public SecurityDialogs.AccessType getAccessType() {
        return this.accessType;
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public CertVerifier getCertVerifier() {
        return this.certVerifier;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    private SecurityDialogPanel getPanel() {
        return SecurityDialog.getPanel(this);
    }

    static SecurityDialogPanel getPanel(SecurityDialog sd) {
        return SecurityDialog.getPanel(sd.dialogType, sd);
    }

    static SecurityDialogPanel getPanel(SecurityDialogs.DialogType type, SecurityDialog sd) {
        SecurityDialogPanel lpanel = null;
        if (type == SecurityDialogs.DialogType.CERT_WARNING) {
            lpanel = new CertWarningPane(sd, sd.certVerifier, (JNLPClassLoader.SecurityDelegate)sd.extras[0]);
        } else if (type == SecurityDialogs.DialogType.MORE_INFO) {
            lpanel = new MoreInfoPane(sd, sd.certVerifier);
        } else if (type == SecurityDialogs.DialogType.CERT_INFO) {
            lpanel = new CertsInfoPane(sd, sd.certVerifier);
        } else if (type == SecurityDialogs.DialogType.SINGLE_CERT_INFO) {
            lpanel = new SingleCertInfoPane(sd, sd.certVerifier);
        } else if (type == SecurityDialogs.DialogType.ACCESS_WARNING) {
            lpanel = new AccessWarningPane(sd, sd.extras, sd.certVerifier);
        } else if (type == SecurityDialogs.DialogType.APPLET_WARNING) {
            lpanel = new AppletWarningPane(sd, sd.certVerifier);
        } else if (type == SecurityDialogs.DialogType.PARTIALLYSIGNED_WARNING) {
            lpanel = AppTrustWarningDialog.partiallySigned(sd, sd.file, (JNLPClassLoader.SecurityDelegate)sd.extras[0]);
        } else if (type == SecurityDialogs.DialogType.UNSIGNED_WARNING) {
            lpanel = AppTrustWarningDialog.unsigned(sd, sd.file);
        } else if (type == SecurityDialogs.DialogType.AUTHENTICATION) {
            lpanel = new PasswordAuthenticationPane(sd, sd.extras);
        } else if (type == SecurityDialogs.DialogType.UNSIGNED_EAS_NO_PERMISSIONS_WARNING) {
            lpanel = new MissingPermissionsAttributePanel(sd, sd.file.getTitle(), sd.file.getNotNullProbalbeCodeBase().toExternalForm());
        } else if (type == SecurityDialogs.DialogType.MISSING_ALACA) {
            lpanel = new MissingALACAttributePanel(sd, sd.file.getTitle(), (String)sd.extras[0], (String)sd.extras[1]);
        } else if (type == SecurityDialogs.DialogType.MATCHING_ALACA) {
            lpanel = AppTrustWarningDialog.matchingAlaca(sd, sd.file, (String)sd.extras[0], (String)sd.extras[1]);
        } else if (type == SecurityDialogs.DialogType.SECURITY_511) {
            lpanel = new InetSecurity511Panel(sd, (URL)sd.extras[0]);
        } else {
            throw new RuntimeException("Unknown value of " + (Object)((Object)sd.dialogType) + ". Panel will be null. Tahts not allowed.");
        }
        return lpanel;
    }

    private void installPanel() {
        this.panel = this.getPanel();
        this.getViwableDialog().add(this.panel, "Center");
    }

    private void selectDefaultButton() {
        if (this.panel == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "initial value panel is null");
        } else {
            this.panel.requestFocusOnDefaultButton();
        }
    }

    public void setValue(DialogResult value) {
        OutputController.getLogger().log("Setting value:" + value);
        this.value = value;
    }

    public DialogResult getValue() {
        OutputController.getLogger().log("Returning value:" + this.value);
        return this.value;
    }

    public boolean requiresSignedJNLPWarning() {
        return this.requiresSignedJNLPWarning;
    }

    DialogResult getDefaultNegativeAnswer() {
        return this.panel.getDefaultNegativeAnswer();
    }

    DialogResult getDefaultPositiveAnswer() {
        return this.panel.getDefaultPositiveAnswer();
    }

    String getText() {
        return this.panel.getText();
    }

    DialogResult readFromStdIn(String what) {
        return this.panel.readFromStdIn(what);
    }

    String helpToStdIn() {
        return this.panel.helpToStdIn();
    }

    public ViwableDialog getViwableDialog() {
        return this.viwableDialog;
    }

    public SecurityDialogPanel getSecurityDialogPanel() {
        return this.panel;
    }
}

