/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.network.ByteBufferAllocator;
import com.sun.webkit.network.ByteBufferPool;
import com.sun.webkit.network.DirectoryURLConnection;
import com.sun.webkit.network.FormDataElement;
import com.sun.webkit.network.URLs;
import com.sun.webkit.network.Util;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLHandshakeException;

final class URLLoader
implements Runnable {
    private static final Logger logger = Logger.getLogger(URLLoader.class.getName());
    private static final int MAX_REDIRECTS = 10;
    private static final int MAX_BUF_COUNT = 3;
    private static final String GET = "GET";
    private static final String HEAD = "HEAD";
    private static final String DELETE = "DELETE";
    private final WebPage webPage;
    private final ByteBufferPool byteBufferPool;
    private final boolean asynchronous;
    private String url;
    private String method;
    private final String headers;
    private FormDataElement[] formDataElements;
    private final long data;
    private volatile boolean canceled = false;

    URLLoader(WebPage webPage, ByteBufferPool byteBufferPool, boolean asynchronous, String url, String method, String headers, FormDataElement[] formDataElements, long data) {
        this.webPage = webPage;
        this.byteBufferPool = byteBufferPool;
        this.asynchronous = asynchronous;
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.formDataElements = formDataElements;
        this.data = data;
    }

    private void fwkCancel() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("data: [0x%016X]", this.data));
        }
        this.canceled = true;
    }

    @Override
    public void run() {
        AccessController.doPrivileged(() -> {
            this.doRun();
            return null;
        }, this.webPage.getAccessControlContext());
    }

    private void doRun() {
        Throwable error = null;
        int errorCode = 0;
        try {
            int redirectCount = 0;
            boolean streaming = true;
            boolean connectionResetRetry = true;
            while (true) {
                int questionMarkPosition;
                String actualUrl = this.url;
                if (this.url.startsWith("file:") && (questionMarkPosition = this.url.indexOf(63)) != -1) {
                    actualUrl = this.url.substring(0, questionMarkPosition);
                }
                URL urlObject = URLs.newURL(actualUrl);
                URLLoader.workaround7177996(urlObject);
                URLConnection c = urlObject.openConnection();
                this.prepareConnection(c);
                Redirect redirect = null;
                try {
                    this.sendRequest(c, streaming);
                    redirect = this.receiveResponse(c);
                }
                catch (HttpRetryException ex) {
                    if (streaming) {
                        streaming = false;
                        continue;
                    }
                    throw ex;
                }
                catch (SocketException ex) {
                    if ("Connection reset".equals(ex.getMessage()) && connectionResetRetry) {
                        connectionResetRetry = false;
                        continue;
                    }
                    throw ex;
                }
                finally {
                    URLLoader.close(c);
                    continue;
                }
                if (redirect != null) {
                    if (redirectCount++ >= 10) {
                        throw new TooManyRedirectsException();
                    }
                    boolean resetRequest = !redirect.preserveRequest && !this.method.equals(GET) && !this.method.equals(HEAD);
                    String newMethod = resetRequest ? GET : this.method;
                    this.willSendRequest(redirect.url, newMethod, c);
                    if (!this.canceled) {
                        this.url = redirect.url;
                        this.method = newMethod;
                        this.formDataElements = resetRequest ? null : this.formDataElements;
                        continue;
                    }
                }
                break;
            }
        }
        catch (MalformedURLException ex) {
            error = ex;
            errorCode = 2;
        }
        catch (AccessControlException ex) {
            error = ex;
            errorCode = 8;
        }
        catch (UnknownHostException ex) {
            error = ex;
            errorCode = 1;
        }
        catch (NoRouteToHostException ex) {
            error = ex;
            errorCode = 6;
        }
        catch (ConnectException ex) {
            error = ex;
            errorCode = 4;
        }
        catch (SocketException ex) {
            error = ex;
            errorCode = 5;
        }
        catch (SSLHandshakeException ex) {
            error = ex;
            errorCode = 3;
        }
        catch (SocketTimeoutException ex) {
            error = ex;
            errorCode = 7;
        }
        catch (InvalidResponseException ex) {
            error = ex;
            errorCode = 9;
        }
        catch (TooManyRedirectsException ex) {
            error = ex;
            errorCode = 10;
        }
        catch (FileNotFoundException ex) {
            error = ex;
            errorCode = 11;
        }
        catch (Throwable th) {
            error = th;
            errorCode = 99;
        }
        if (error != null) {
            if (errorCode == 99) {
                logger.log(Level.WARNING, "Unexpected error", error);
            } else {
                logger.log(Level.FINEST, "Load error", error);
            }
            this.didFail(errorCode, error.getMessage());
        }
    }

    private static void workaround7177996(URL url) throws FileNotFoundException {
        if (!url.getProtocol().equals("file")) {
            return;
        }
        String host = url.getHost();
        if (host == null || host.equals("") || host.equals("~") || host.equalsIgnoreCase("localhost")) {
            return;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            String path = null;
            try {
                path = URLDecoder.decode(url.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            path = path.replace('/', '\\');
            path = path.replace('|', ':');
            File file = new File("\\\\" + host + path);
            if (!file.exists()) {
                throw new FileNotFoundException("File not found: " + url);
            }
        } else {
            throw new FileNotFoundException("File not found: " + url);
        }
    }

    private void prepareConnection(URLConnection c) throws IOException {
        c.setConnectTimeout(30000);
        c.setReadTimeout(3600000);
        c.setUseCaches(false);
        Locale loc = Locale.getDefault();
        String lang = "";
        if (!loc.equals(Locale.US) && !loc.equals(Locale.ENGLISH)) {
            lang = loc.getCountry().isEmpty() ? loc.getLanguage() + "," : loc.getLanguage() + "-" + loc.getCountry() + ",";
        }
        c.setRequestProperty("Accept-Language", lang.toLowerCase() + "en-us;q=0.8,en;q=0.7");
        c.setRequestProperty("Accept-Encoding", "gzip");
        c.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        if (this.headers != null && this.headers.length() > 0) {
            for (String h : this.headers.split("\n")) {
                int i = h.indexOf(58);
                if (i <= 0) continue;
                c.addRequestProperty(h.substring(0, i), h.substring(i + 2));
            }
        }
        if (c instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)c;
            httpConnection.setRequestMethod(this.method);
            httpConnection.setInstanceFollowRedirects(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(URLConnection c, boolean streaming) throws IOException {
        OutputStream out = null;
        try {
            boolean isGetOrHead;
            long bytesToBeSent = 0L;
            boolean sendFormData = this.formDataElements != null && c instanceof HttpURLConnection && !this.method.equals(DELETE);
            boolean bl = isGetOrHead = this.method.equals(GET) || this.method.equals(HEAD);
            if (sendFormData) {
                c.setDoOutput(true);
                for (FormDataElement formDataElement : this.formDataElements) {
                    formDataElement.open();
                    bytesToBeSent += formDataElement.getSize();
                }
                if (streaming) {
                    HttpURLConnection http = (HttpURLConnection)c;
                    if (bytesToBeSent <= Integer.MAX_VALUE) {
                        http.setFixedLengthStreamingMode((int)bytesToBeSent);
                    } else {
                        http.setChunkedStreamingMode(0);
                    }
                }
            } else if (!isGetOrHead && c instanceof HttpURLConnection) {
                c.setRequestProperty("Content-Length", "0");
            }
            int maxTryCount = isGetOrHead ? 3 : 1;
            c.setConnectTimeout(c.getConnectTimeout() / maxTryCount);
            int tryCount = 0;
            while (!this.canceled) {
                try {
                    c.connect();
                    break;
                }
                catch (SocketTimeoutException ex) {
                    if (++tryCount < maxTryCount) continue;
                    throw ex;
                }
                catch (IllegalArgumentException ex) {
                    throw new MalformedURLException(this.url);
                }
            }
            if (sendFormData) {
                out = c.getOutputStream();
                byte[] buffer = new byte[4096];
                long bytesSent = 0L;
                for (FormDataElement formDataElement : this.formDataElements) {
                    int count;
                    InputStream in = formDataElement.getInputStream();
                    while ((count = in.read(buffer)) > 0) {
                        out.write(buffer, 0, count);
                        this.didSendData(bytesSent += (long)count, bytesToBeSent);
                    }
                    formDataElement.close();
                }
                out.flush();
                out.close();
                out = null;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (this.formDataElements != null && c instanceof HttpURLConnection) {
                for (FormDataElement formDataElement : this.formDataElements) {
                    try {
                        formDataElement.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Redirect receiveResponse(URLConnection c) throws IOException, InterruptedException {
        InputStream inputStream;
        block40: {
            block39: {
                if (this.canceled) {
                    return null;
                }
                InputStream errorStream = null;
                if (c instanceof HttpURLConnection) {
                    HttpURLConnection http = (HttpURLConnection)c;
                    int code = http.getResponseCode();
                    if (code == -1) {
                        throw new InvalidResponseException();
                    }
                    if (this.canceled) {
                        return null;
                    }
                    switch (code) {
                        case 301: 
                        case 302: 
                        case 303: 
                        case 307: {
                            URL newUrl;
                            String newLoc = http.getHeaderField("Location");
                            if (newLoc == null) break;
                            try {
                                newUrl = URLs.newURL(newLoc);
                            }
                            catch (MalformedURLException mue) {
                                newUrl = URLs.newURL(c.getURL(), newLoc);
                            }
                            return new Redirect(newUrl.toExternalForm(), code == 307);
                        }
                        case 304: {
                            this.didReceiveResponse(c);
                            this.didFinishLoading();
                            return null;
                        }
                    }
                    if (code >= 400 && !this.method.equals(HEAD)) {
                        errorStream = http.getErrorStream();
                    }
                }
                if (this.url.startsWith("ftp:") || this.url.startsWith("ftps:")) {
                    boolean dir = false;
                    boolean notsure = false;
                    String path = c.getURL().getPath();
                    if (path == null || path.isEmpty() || path.endsWith("/") || path.contains(";type=d")) {
                        dir = true;
                    } else {
                        String type = c.getContentType();
                        if ("text/plain".equalsIgnoreCase(type) || "text/html".equalsIgnoreCase(type)) {
                            dir = true;
                            notsure = true;
                        }
                    }
                    if (dir) {
                        c = new DirectoryURLConnection(c, notsure);
                    }
                }
                if (this.url.startsWith("file:") && "text/plain".equals(c.getContentType()) && c.getHeaderField("content-length") == null) {
                    c = new DirectoryURLConnection(c);
                }
                this.didReceiveResponse(c);
                if (this.method.equals(HEAD)) {
                    this.didFinishLoading();
                    return null;
                }
                inputStream = null;
                try {
                    inputStream = errorStream == null ? c.getInputStream() : errorStream;
                }
                catch (HttpRetryException ex) {
                    throw ex;
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINE)) break block39;
                    logger.log(Level.FINE, String.format("Exception caught: [%s], %s", e.getClass().getSimpleName(), e.getMessage()));
                }
            }
            String encoding = c.getContentEncoding();
            if (inputStream != null) {
                try {
                    if ("gzip".equalsIgnoreCase(encoding)) {
                        inputStream = new GZIPInputStream(inputStream);
                    } else if ("deflate".equalsIgnoreCase(encoding)) {
                        inputStream = new InflaterInputStream(inputStream);
                    }
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINE)) break block40;
                    logger.log(Level.FINE, String.format("Exception caught: [%s], %s", e.getClass().getSimpleName(), e.getMessage()));
                }
            }
        }
        ByteBufferAllocator allocator = this.byteBufferPool.newAllocator(3);
        ByteBuffer byteBuffer = null;
        try {
            if (inputStream != null) {
                byte[] buffer = new byte[8192];
                while (!this.canceled) {
                    int remaining;
                    int count;
                    try {
                        count = inputStream.read(buffer);
                    }
                    catch (EOFException ex) {
                        count = -1;
                    }
                    if (count == -1) break;
                    if (byteBuffer == null) {
                        byteBuffer = allocator.allocate();
                    }
                    if (count < (remaining = byteBuffer.remaining())) {
                        byteBuffer.put(buffer, 0, count);
                        continue;
                    }
                    byteBuffer.put(buffer, 0, remaining);
                    byteBuffer.flip();
                    this.didReceiveData(byteBuffer, allocator);
                    byteBuffer = null;
                    int outstanding = count - remaining;
                    if (outstanding <= 0) continue;
                    byteBuffer = allocator.allocate();
                    byteBuffer.put(buffer, remaining, outstanding);
                }
            }
            if (!this.canceled) {
                if (byteBuffer != null && byteBuffer.position() > 0) {
                    byteBuffer.flip();
                    this.didReceiveData(byteBuffer, allocator);
                    byteBuffer = null;
                }
                this.didFinishLoading();
            }
        }
        finally {
            if (byteBuffer != null) {
                byteBuffer.clear();
                allocator.release(byteBuffer);
            }
        }
        return null;
    }

    private static void close(URLConnection c) {
        InputStream errorStream;
        if (c instanceof HttpURLConnection && (errorStream = ((HttpURLConnection)c).getErrorStream()) != null) {
            try {
                errorStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            c.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void didSendData(long totalBytesSent, long totalBytesToBeSent) {
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidSendData(totalBytesSent, totalBytesToBeSent);
            }
        });
    }

    private void notifyDidSendData(long totalBytesSent, long totalBytesToBeSent) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("totalBytesSent: [%d], totalBytesToBeSent: [%d], data: [0x%016X]", totalBytesSent, totalBytesToBeSent, this.data));
        }
        URLLoader.twkDidSendData(totalBytesSent, totalBytesToBeSent, this.data);
    }

    private void willSendRequest(String newUrl, String newMethod, URLConnection c) throws InterruptedException {
        String adjustedNewUrl = URLLoader.adjustUrlForWebKit(newUrl);
        int status = URLLoader.extractStatus(c);
        String contentType = c.getContentType();
        String contentEncoding = URLLoader.extractContentEncoding(c);
        long contentLength = URLLoader.extractContentLength(c);
        String responseHeaders = URLLoader.extractHeaders(c);
        String adjustedUrl = URLLoader.adjustUrlForWebKit(this.url);
        CountDownLatch latch = this.asynchronous ? new CountDownLatch(1) : null;
        this.callBack(() -> {
            try {
                boolean keepGoing;
                if (!this.canceled && !(keepGoing = this.notifyWillSendRequest(adjustedNewUrl, newMethod, status, contentType, contentEncoding, contentLength, responseHeaders, adjustedUrl))) {
                    this.fwkCancel();
                }
            }
            finally {
                if (latch != null) {
                    latch.countDown();
                }
            }
        });
        if (latch != null) {
            latch.await();
        }
    }

    private boolean notifyWillSendRequest(String newUrl, String newMethod, int status, String contentType, String contentEncoding, long contentLength, String headers, String url) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("newUrl: [%s], newMethod: [%s], status: [%d], contentType: [%s], contentEncoding: [%s], contentLength: [%d], url: [%s], data: [0x%016X], headers:%n%s", newUrl, newMethod, status, contentType, contentEncoding, contentLength, url, this.data, Util.formatHeaders(headers)));
        }
        boolean result = URLLoader.twkWillSendRequest(newUrl, newMethod, status, contentType, contentEncoding, contentLength, headers, url, this.data);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("result: [%s]", result));
        }
        return result;
    }

    private void didReceiveResponse(URLConnection c) {
        int status = URLLoader.extractStatus(c);
        String contentType = c.getContentType();
        String contentEncoding = URLLoader.extractContentEncoding(c);
        long contentLength = URLLoader.extractContentLength(c);
        String responseHeaders = URLLoader.extractHeaders(c);
        String adjustedUrl = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidReceiveResponse(status, contentType, contentEncoding, contentLength, responseHeaders, adjustedUrl);
            }
        });
    }

    private void notifyDidReceiveResponse(int status, String contentType, String contentEncoding, long contentLength, String headers, String url) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("status: [%d], contentType: [%s], contentEncoding: [%s], contentLength: [%d], url: [%s], data: [0x%016X], headers:%n%s", status, contentType, contentEncoding, contentLength, url, this.data, Util.formatHeaders(headers)));
        }
        URLLoader.twkDidReceiveResponse(status, contentType, contentEncoding, contentLength, headers, url, this.data);
    }

    private void didReceiveData(ByteBuffer byteBuffer, ByteBufferAllocator allocator) {
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidReceiveData(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
            }
            byteBuffer.clear();
            allocator.release(byteBuffer);
        });
    }

    private void notifyDidReceiveData(ByteBuffer byteBuffer, int position, int remaining) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("byteBuffer: [%s], position: [%s], remaining: [%s], data: [0x%016X]", byteBuffer, position, remaining, this.data));
        }
        URLLoader.twkDidReceiveData(byteBuffer, position, remaining, this.data);
    }

    private void didFinishLoading() {
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidFinishLoading();
            }
        });
    }

    private void notifyDidFinishLoading() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("data: [0x%016X]", this.data));
        }
        URLLoader.twkDidFinishLoading(this.data);
    }

    private void didFail(int errorCode, String message) {
        String adjustedUrl = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidFail(errorCode, adjustedUrl, message);
            }
        });
    }

    private void notifyDidFail(int errorCode, String url, String message) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("errorCode: [%d], url: [%s], message: [%s], data: [0x%016X]", errorCode, url, message, this.data));
        }
        URLLoader.twkDidFail(errorCode, url, message, this.data);
    }

    private void callBack(Runnable runnable) {
        if (this.asynchronous) {
            Invoker.getInvoker().invokeOnEventThread(runnable);
        } else {
            runnable.run();
        }
    }

    private static native void twkDidSendData(long var0, long var2, long var4);

    private static native boolean twkWillSendRequest(String var0, String var1, int var2, String var3, String var4, long var5, String var7, String var8, long var9);

    private static native void twkDidReceiveResponse(int var0, String var1, String var2, long var3, String var5, String var6, long var7);

    private static native void twkDidReceiveData(ByteBuffer var0, int var1, int var2, long var3);

    private static native void twkDidFinishLoading(long var0);

    private static native void twkDidFail(int var0, String var1, String var2, long var3);

    private static int extractStatus(URLConnection c) {
        int status = 0;
        if (c instanceof HttpURLConnection) {
            try {
                status = ((HttpURLConnection)c).getResponseCode();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return status;
    }

    private static String extractContentEncoding(URLConnection c) {
        String contentEncoding = c.getContentEncoding();
        if ("gzip".equalsIgnoreCase(contentEncoding) || "deflate".equalsIgnoreCase(contentEncoding)) {
            int i;
            contentEncoding = null;
            String contentType = c.getContentType();
            if (contentType != null && (i = contentType.indexOf("charset=")) >= 0 && (i = (contentEncoding = contentType.substring(i + 8)).indexOf(";")) > 0) {
                contentEncoding = contentEncoding.substring(0, i);
            }
        }
        return contentEncoding;
    }

    private static long extractContentLength(URLConnection c) {
        try {
            return Long.parseLong(c.getHeaderField("content-length"));
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    private static String extractHeaders(URLConnection c) {
        StringBuilder sb = new StringBuilder();
        Map<String, List<String>> headers = c.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                sb.append(key != null ? key : "");
                sb.append(':').append(value).append('\n');
            }
        }
        return sb.toString();
    }

    private static String adjustUrlForWebKit(String url) {
        try {
            url = Util.adjustUrlForWebKit(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private static final class TooManyRedirectsException
    extends IOException {
        private TooManyRedirectsException() {
            super("Too many redirects");
        }
    }

    private static final class InvalidResponseException
    extends IOException {
        private InvalidResponseException() {
            super("Invalid server response");
        }
    }

    private static final class Redirect {
        private final String url;
        private final boolean preserveRequest;

        private Redirect(String url, boolean preserveRequest) {
            this.url = url;
            this.preserveRequest = preserveRequest;
        }
    }
}

