/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.OptionButtonUI;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBOptionButton
extends JButton
implements Weighted {
    public static final String PROP_OPTIONS = "OptionActions";
    public static final String PROP_OPTION_TOOLTIP = "OptionTooltip";
    private Action[] myOptions;
    private String myOptionTooltipText;
    private final Set<OptionInfo> myOptionInfos = new HashSet<OptionInfo>();
    private boolean myOkToProcessDefaultMnemonics = true;

    public JBOptionButton(Action action, Action[] options) {
        super(action);
        this.setOptions(options);
    }

    @Override
    public String getUIClassID() {
        return "OptionButtonUI";
    }

    @Override
    public OptionButtonUI getUI() {
        return (OptionButtonUI)super.getUI();
    }

    @Override
    public double getWeight() {
        return 0.5;
    }

    public void togglePopup() {
        this.getUI().togglePopup();
    }

    public void showPopup(@Nullable Action actionToSelect, boolean ensureSelection) {
        this.getUI().showPopup(actionToSelect, ensureSelection);
    }

    public void closePopup() {
        this.getUI().closePopup();
    }

    @Nullable
    public Action[] getOptions() {
        return this.myOptions;
    }

    public void setOptions(@Nullable Action[] options) {
        Object[] oldOptions = this.myOptions;
        this.myOptions = options;
        this.fillOptionInfos();
        this.firePropertyChange(PROP_OPTIONS, oldOptions, this.myOptions);
        if (!Arrays.equals(oldOptions, this.myOptions)) {
            this.revalidate();
            this.repaint();
        }
    }

    @Deprecated
    public void updateOptions(@Nullable Action[] options) {
        this.setOptions(options);
    }

    public boolean isSimpleButton() {
        return this.myOptions == null || this.myOptions.length == 0;
    }

    private void fillOptionInfos() {
        this.myOptionInfos.clear();
        this.myOptionInfos.addAll(UtilKt.stream(this.myOptions).filter(action -> action != this.getAction()).map(this::getMenuInfo).collect(Collectors.toSet()));
    }

    public boolean isOkToProcessDefaultMnemonics() {
        return this.myOkToProcessDefaultMnemonics;
    }

    @NotNull
    private OptionInfo getMenuInfo(@NotNull Action each) {
        if (each == null) {
            JBOptionButton.$$$reportNull$$$0(0);
        }
        String text = StringUtil.notNullize((String)((String)each.getValue("Name")));
        int mnemonic = -1;
        int mnemonicIndex = -1;
        StringBuilder plainText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '&' || ch == '_') {
                if (i + 1 >= text.length()) continue;
                char mnemonicsChar = text.charAt(i + 1);
                mnemonic = Character.toUpperCase(mnemonicsChar);
                mnemonicIndex = i;
                continue;
            }
            plainText.append(ch);
        }
        OptionInfo optionInfo = new OptionInfo(plainText.toString(), mnemonic, mnemonicIndex, this, each);
        if (optionInfo == null) {
            JBOptionButton.$$$reportNull$$$0(1);
        }
        return optionInfo;
    }

    @NotNull
    public Set<OptionInfo> getOptionInfos() {
        Set<OptionInfo> set = this.myOptionInfos;
        if (set == null) {
            JBOptionButton.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Nullable
    public String getOptionTooltipText() {
        return this.myOptionTooltipText;
    }

    public void setOptionTooltipText(@Nullable String text) {
        String oldValue = this.myOptionTooltipText;
        this.myOptionTooltipText = text;
        this.firePropertyChange(PROP_OPTION_TOOLTIP, oldValue, this.myOptionTooltipText);
    }

    public void setOkToProcessDefaultMnemonics(boolean ok) {
        this.myOkToProcessDefaultMnemonics = ok;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/JBOptionButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/JBOptionButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMenuInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMenuInfo";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class OptionInfo {
        String myPlainText;
        int myMnemonic;
        int myMnemonicIndex;
        JBOptionButton myButton;
        Action myAction;

        OptionInfo(String plainText, int mnemonic, int mnemonicIndex, JBOptionButton button, Action action) {
            this.myPlainText = plainText;
            this.myMnemonic = mnemonic;
            this.myMnemonicIndex = mnemonicIndex;
            this.myButton = button;
            this.myAction = action;
        }

        public String getPlainText() {
            return this.myPlainText;
        }

        public int getMnemonic() {
            return this.myMnemonic;
        }

        public int getMnemonicIndex() {
            return this.myMnemonicIndex;
        }

        public JBOptionButton getButton() {
            return this.myButton;
        }

        public Action getAction() {
            return this.myAction;
        }
    }
}

