/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.util;

import java.util.LinkedHashSet;
import java.util.Set;

public final class StringUtils {
    private StringUtils() {
    }

    public static String normalizeWhitespace(String in) {
        String result = in.replaceAll("[\\n\\t\\r]", "").replaceAll("\\p{Z}", " ").replaceAll("\\s", " ");
        result = result.replace('\u00a0', ' ');
        return result;
    }

    public static String asUnicodes(String in) {
        int codepoint;
        if (in == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int offset = 0; offset < in.length(); offset += Character.charCount(codepoint)) {
            codepoint = in.codePointAt(offset);
            result.append("\\U+").append(Integer.toHexString(codepoint).toUpperCase());
        }
        return result.toString();
    }

    public static Set<Character> difference(String s1, String s2) {
        LinkedHashSet<Character> result = new LinkedHashSet<Character>();
        char[] cArray = s1.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (s2.contains(c.toString())) continue;
            result.add(c);
        }
        return result;
    }

    public static String normalizeLineEndings(String in) {
        return in.replaceAll("\\r\\n", "\n");
    }
}

