"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var luxon_1 = require("luxon");
function timeFormatter(format) {
    return function (value) {
        return luxon_1.DateTime.fromMillis(value).toFormat(format);
    };
}
exports.timeFormatter = timeFormatter;
function niceTimeFormatter(domain) {
    var minDate = luxon_1.DateTime.fromMillis(domain[0]);
    var maxDate = luxon_1.DateTime.fromMillis(domain[1]);
    var diff = luxon_1.Interval.fromDateTimes(minDate, maxDate);
    var format = niceTimeFormat(diff);
    return timeFormatter(format);
}
exports.niceTimeFormatter = niceTimeFormatter;
function niceTimeFormat(interval) {
    var days = interval.count('days');
    return niceTimeFormatByDay(days);
}
exports.niceTimeFormat = niceTimeFormat;
function niceTimeFormatByDay(days) {
    if (days > 30) {
        return 'yyyy-MM-dd';
    }
    if (days > 7 && days <= 30) {
        return 'MMMM dd';
    }
    if (days > 1 && days <= 7) {
        return 'MM-dd HH:mm';
    }
    return 'HH:mm:ss';
}
exports.niceTimeFormatByDay = niceTimeFormatByDay;
//# sourceMappingURL=formatters.js.map