"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KIBANA_METRICS = {
    metrics: {
        kibana_os_load: [
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.os.load.1m',
                    metricAgg: 'max',
                    label: '1m',
                    title: 'System Load',
                    description: 'Load average over the last minute.',
                    units: '',
                    format: '0,0.[00]',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 8.3203125],
                    [1551438030000, 7.9140625],
                    [1551438060000, 7.8671875],
                    [1551438090000, 7.125],
                    [1551438120000, 8.765625],
                    [1551438150000, 11.546875],
                    [1551438180000, 12.984375],
                    [1551438210000, 13.546875],
                    [1551438240000, 13.390625],
                    [1551438270000, 11.5625],
                    [1551438300000, 11.5859375],
                    [1551438330000, 10.0546875],
                    [1551438360000, 9.921875],
                    [1551438390000, 9.4921875],
                    [1551438420000, 9.78125],
                    [1551438450000, 10.046875],
                    [1551438480000, 14.0546875],
                    [1551438510000, 10.640625],
                    [1551438540000, 8.2421875],
                    [1551438570000, 8.5],
                    [1551438600000, 7.2578125],
                    [1551438630000, 8.515625],
                    [1551438660000, 10.796875],
                    [1551438690000, 11.125],
                    [1551438720000, 21.40625],
                    [1551438750000, 17.921875],
                    [1551438780000, 26.640625],
                    [1551438810000, 31.390625],
                    [1551438840000, 23.953125],
                    [1551438870000, 16],
                    [1551438900000, 11.9765625],
                    [1551438930000, 9.1640625],
                    [1551438960000, 7.98046875],
                    [1551438990000, 7.1640625],
                    [1551439020000, 7.39453125],
                    [1551439050000, 5.68359375],
                    [1551439080000, 4.95703125],
                    [1551439110000, 4.26171875],
                    [1551439140000, 11.1171875],
                    [1551439170000, 10.8515625],
                    [1551439200000, 12.6171875],
                    [1551439230000, 11.1171875],
                    [1551439260000, 11.6640625],
                    [1551439290000, 11.109375],
                    [1551439320000, 10.6015625],
                    [1551439350000, 11.21875],
                    [1551439380000, 13.53125],
                    [1551439410000, 15.4609375],
                    [1551439440000, 15.1796875],
                    [1551439470000, 11.984375],
                    [1551439500000, 24.8125],
                    [1551439530000, 21.46875],
                    [1551439560000, 14.484375],
                    [1551439590000, 9.9609375],
                    [1551439620000, 10.8515625],
                    [1551439650000, 12.1171875],
                    [1551439680000, 19.375],
                    [1551439710000, 20.609375],
                    [1551439740000, 16.484375],
                    [1551439770000, 15.515625],
                    [1551439800000, 14.9140625],
                    [1551439830000, 10.8828125],
                    [1551439860000, 9.7578125],
                    [1551439890000, 8.625],
                    [1551439920000, 9.21875],
                    [1551439950000, 8.5390625],
                    [1551439980000, 8.40625],
                    [1551440010000, 6.671875],
                    [1551440040000, 7.24609375],
                    [1551440070000, 7.1015625],
                    [1551440100000, 7.09375],
                    [1551440130000, 10.8125],
                    [1551440160000, 10.90625],
                    [1551440190000, 12.453125],
                    [1551440220000, 11.8984375],
                    [1551440250000, 10.875],
                    [1551440280000, 12.4140625],
                    [1551440310000, 12.78125],
                    [1551440340000, 34.28125],
                    [1551440370000, 29.84375],
                    [1551440400000, 22.40625],
                    [1551440430000, 16.046875],
                    [1551440460000, 12.6328125],
                    [1551440490000, 8.8125],
                    [1551440520000, 6.93359375],
                    [1551440550000, 6.12890625],
                    [1551440580000, 5.69921875],
                    [1551440610000, 5.48828125],
                    [1551440640000, 12.0234375],
                    [1551440670000, 14.484375],
                    [1551440700000, 12.890625],
                    [1551440730000, 11.578125],
                    [1551440760000, 10.7578125],
                    [1551440790000, 9.921875],
                    [1551440820000, 10.5078125],
                    [1551440850000, 11.375],
                    [1551440880000, 15.890625],
                    [1551440910000, 14.1953125],
                    [1551440940000, 11.625],
                    [1551440970000, 11.734375],
                    [1551441000000, 10.1640625],
                    [1551441030000, 9.296875],
                    [1551441060000, 7.5546875],
                    [1551441090000, 7.17578125],
                    [1551441120000, 5.8671875],
                    [1551441150000, 6.828125],
                    [1551441180000, 10.578125],
                    [1551441210000, 16.140625],
                    [1551441240000, 15.640625],
                    [1551441270000, 13.1484375],
                    [1551441300000, 11.9140625],
                    [1551441330000, 10.0625],
                    [1551441360000, 7.66015625],
                    [1551441390000, 9.0078125],
                    [1551441420000, 8.78125],
                    [1551441450000, 8.0390625],
                    [1551441480000, 25.515625],
                    [1551441510000, 18.640625],
                    [1551441540000, 13.1953125],
                    [1551441570000, 10.1953125],
                ],
            },
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.os.load.5m',
                    metricAgg: 'max',
                    label: '5m',
                    title: 'System Load',
                    description: 'Load average over the last 5 minutes.',
                    units: '',
                    format: '0,0.[00]',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 9.984375],
                    [1551438030000, 9.71875],
                    [1551438060000, 9.28125],
                    [1551438090000, 9.078125],
                    [1551438120000, 8.9921875],
                    [1551438150000, 9.640625],
                    [1551438180000, 10.171875],
                    [1551438210000, 10.421875],
                    [1551438240000, 10.625],
                    [1551438270000, 10.390625],
                    [1551438300000, 10.4296875],
                    [1551438330000, 10.1328125],
                    [1551438360000, 9.984375],
                    [1551438390000, 9.8203125],
                    [1551438420000, 9.8125],
                    [1551438450000, 9.78125],
                    [1551438480000, 10.625],
                    [1551438510000, 10.09375],
                    [1551438540000, 9.5546875],
                    [1551438570000, 9.390625],
                    [1551438600000, 9.015625],
                    [1551438630000, 8.8828125],
                    [1551438660000, 9.359375],
                    [1551438690000, 9.53125],
                    [1551438720000, 11.9453125],
                    [1551438750000, 11.828125],
                    [1551438780000, 14.4609375],
                    [1551438810000, 16.421875],
                    [1551438840000, 15.6875],
                    [1551438870000, 14.5625],
                    [1551438900000, 13.75],
                    [1551438930000, 12.8359375],
                    [1551438960000, 12.2109375],
                    [1551438990000, 11.6328125],
                    [1551439020000, 11.015625],
                    [1551439050000, 10.3828125],
                    [1551439080000, 9.7421875],
                    [1551439110000, 9.046875],
                    [1551439140000, 9.921875],
                    [1551439170000, 9.890625],
                    [1551439200000, 10.34375],
                    [1551439230000, 10.140625],
                    [1551439260000, 10.3515625],
                    [1551439290000, 10.28125],
                    [1551439320000, 10.203125],
                    [1551439350000, 10.296875],
                    [1551439380000, 10.875],
                    [1551439410000, 11.4765625],
                    [1551439440000, 11.484375],
                    [1551439470000, 11.046875],
                    [1551439500000, 13.53125],
                    [1551439530000, 13.1875],
                    [1551439560000, 12.3046875],
                    [1551439590000, 11.3984375],
                    [1551439620000, 11.1328125],
                    [1551439650000, 11.390625],
                    [1551439680000, 13.3046875],
                    [1551439710000, 13.71875],
                    [1551439740000, 13.3671875],
                    [1551439770000, 13.4296875],
                    [1551439800000, 13.3359375],
                    [1551439830000, 12.4765625],
                    [1551439860000, 12.09375],
                    [1551439890000, 11.4765625],
                    [1551439920000, 11.328125],
                    [1551439950000, 10.8984375],
                    [1551439980000, 10.7109375],
                    [1551440010000, 10.0546875],
                    [1551440040000, 9.6328125],
                    [1551440070000, 9.34375],
                    [1551440100000, 9.1953125],
                    [1551440130000, 9.6328125],
                    [1551440160000, 9.7109375],
                    [1551440190000, 10.1171875],
                    [1551440220000, 10.171875],
                    [1551440250000, 10.0546875],
                    [1551440280000, 10.4140625],
                    [1551440310000, 10.5234375],
                    [1551440340000, 15.140625],
                    [1551440370000, 14.90625],
                    [1551440400000, 14.4921875],
                    [1551440430000, 13.65625],
                    [1551440460000, 13.0390625],
                    [1551440490000, 12.09375],
                    [1551440520000, 11.3125],
                    [1551440550000, 10.7265625],
                    [1551440580000, 10.1640625],
                    [1551440610000, 9.4453125],
                    [1551440640000, 10.546875],
                    [1551440670000, 11.1328125],
                    [1551440700000, 10.96875],
                    [1551440730000, 10.875],
                    [1551440760000, 10.7109375],
                    [1551440790000, 10.453125],
                    [1551440820000, 10.546875],
                    [1551440850000, 10.671875],
                    [1551440880000, 11.78125],
                    [1551440910000, 11.5703125],
                    [1551440940000, 11.1640625],
                    [1551440970000, 11.1875],
                    [1551441000000, 10.8671875],
                    [1551441030000, 10.5390625],
                    [1551441060000, 10.03125],
                    [1551441090000, 9.6640625],
                    [1551441120000, 9.0859375],
                    [1551441150000, 8.90625],
                    [1551441180000, 9.453125],
                    [1551441210000, 10.7109375],
                    [1551441240000, 10.734375],
                    [1551441270000, 10.6484375],
                    [1551441300000, 10.5234375],
                    [1551441330000, 10.1796875],
                    [1551441360000, 9.546875],
                    [1551441390000, 9.5390625],
                    [1551441420000, 9.3984375],
                    [1551441450000, 9.21875],
                    [1551441480000, 12.671875],
                    [1551441510000, 12.0859375],
                    [1551441540000, 11.375],
                    [1551441570000, 10.84375],
                ],
            },
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.os.load.15m',
                    metricAgg: 'max',
                    label: '15m',
                    title: 'System Load',
                    description: 'Load average over the last 15 minutes.',
                    units: '',
                    format: '0,0.[00]',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 10.3359375],
                    [1551438030000, 10.234375],
                    [1551438060000, 10.046875],
                    [1551438090000, 9.9765625],
                    [1551438120000, 9.8828125],
                    [1551438150000, 10.078125],
                    [1551438180000, 10.234375],
                    [1551438210000, 10.3125],
                    [1551438240000, 10.3828125],
                    [1551438270000, 10.3046875],
                    [1551438300000, 10.3203125],
                    [1551438330000, 10.21875],
                    [1551438360000, 10.15625],
                    [1551438390000, 10.09375],
                    [1551438420000, 10.0859375],
                    [1551438450000, 10.0546875],
                    [1551438480000, 10.328125],
                    [1551438510000, 10.15625],
                    [1551438540000, 9.9765625],
                    [1551438570000, 9.8984375],
                    [1551438600000, 9.7578125],
                    [1551438630000, 9.65625],
                    [1551438660000, 9.796875],
                    [1551438690000, 9.84375],
                    [1551438720000, 10.640625],
                    [1551438750000, 10.6328125],
                    [1551438780000, 11.578125],
                    [1551438810000, 12.265625],
                    [1551438840000, 12.109375],
                    [1551438870000, 11.84375],
                    [1551438900000, 11.6640625],
                    [1551438930000, 11.421875],
                    [1551438960000, 11.2578125],
                    [1551438990000, 11.1015625],
                    [1551439020000, 10.90625],
                    [1551439050000, 10.703125],
                    [1551439080000, 10.4765625],
                    [1551439110000, 10.21875],
                    [1551439140000, 10.4375],
                    [1551439170000, 10.421875],
                    [1551439200000, 10.5390625],
                    [1551439230000, 10.4609375],
                    [1551439260000, 10.5234375],
                    [1551439290000, 10.5],
                    [1551439320000, 10.4609375],
                    [1551439350000, 10.4765625],
                    [1551439380000, 10.65625],
                    [1551439410000, 10.859375],
                    [1551439440000, 10.8671875],
                    [1551439470000, 10.734375],
                    [1551439500000, 11.5390625],
                    [1551439530000, 11.4453125],
                    [1551439560000, 11.203125],
                    [1551439590000, 10.9375],
                    [1551439620000, 10.859375],
                    [1551439650000, 10.9453125],
                    [1551439680000, 11.609375],
                    [1551439710000, 11.7578125],
                    [1551439740000, 11.703125],
                    [1551439770000, 11.8046875],
                    [1551439800000, 11.78125],
                    [1551439830000, 11.546875],
                    [1551439860000, 11.453125],
                    [1551439890000, 11.265625],
                    [1551439920000, 11.21875],
                    [1551439950000, 11.078125],
                    [1551439980000, 11.0078125],
                    [1551440010000, 10.78125],
                    [1551440040000, 10.6171875],
                    [1551440070000, 10.4921875],
                    [1551440100000, 10.3984375],
                    [1551440130000, 10.4765625],
                    [1551440160000, 10.4765625],
                    [1551440190000, 10.5859375],
                    [1551440220000, 10.5859375],
                    [1551440250000, 10.5390625],
                    [1551440280000, 10.625],
                    [1551440310000, 10.65625],
                    [1551440340000, 12.1328125],
                    [1551440370000, 12.125],
                    [1551440400000, 12.0390625],
                    [1551440430000, 11.8359375],
                    [1551440460000, 11.6875],
                    [1551440490000, 11.4140625],
                    [1551440520000, 11.1796875],
                    [1551440550000, 10.984375],
                    [1551440580000, 10.7890625],
                    [1551440610000, 10.53125],
                    [1551440640000, 10.8359375],
                    [1551440670000, 11.0234375],
                    [1551440700000, 10.96875],
                    [1551440730000, 10.9296875],
                    [1551440760000, 10.875],
                    [1551440790000, 10.7890625],
                    [1551440820000, 10.8046875],
                    [1551440850000, 10.828125],
                    [1551440880000, 11.1875],
                    [1551440910000, 11.125],
                    [1551440940000, 11],
                    [1551440970000, 11.015625],
                    [1551441000000, 10.9140625],
                    [1551441030000, 10.796875],
                    [1551441060000, 10.625],
                    [1551441090000, 10.4765625],
                    [1551441120000, 10.2578125],
                    [1551441150000, 10.1640625],
                    [1551441180000, 10.265625],
                    [1551441210000, 10.6484375],
                    [1551441240000, 10.65625],
                    [1551441270000, 10.625],
                    [1551441300000, 10.5859375],
                    [1551441330000, 10.46875],
                    [1551441360000, 10.2421875],
                    [1551441390000, 10.203125],
                    [1551441420000, 10.140625],
                    [1551441450000, 10.0625],
                    [1551441480000, 11.140625],
                    [1551441510000, 10.9921875],
                    [1551441540000, 10.7890625],
                    [1551441570000, 10.625],
                ],
            },
        ],
        kibana_average_concurrent_connections: [
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.concurrent_connections',
                    metricAgg: 'max',
                    label: 'HTTP Connections',
                    description: 'Total number of open socket connections to the Kibana instance.',
                    units: '',
                    format: '0.[00]',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 20],
                    [1551438030000, 18],
                    [1551438060000, 21],
                    [1551438090000, 21],
                    [1551438120000, 20],
                    [1551438150000, 19],
                    [1551438180000, 19],
                    [1551438210000, 19],
                    [1551438240000, 21],
                    [1551438270000, 21],
                    [1551438300000, 19],
                    [1551438330000, 21],
                    [1551438360000, 18],
                    [1551438390000, 18],
                    [1551438420000, 19],
                    [1551438450000, 19],
                    [1551438480000, 19],
                    [1551438510000, 19],
                    [1551438540000, 20],
                    [1551438570000, 23],
                    [1551438600000, 19],
                    [1551438630000, 21],
                    [1551438660000, 20],
                    [1551438690000, 19],
                    [1551438720000, 24],
                    [1551438750000, 20],
                    [1551438780000, 20],
                    [1551438810000, 19],
                    [1551438840000, 20],
                    [1551438870000, 21],
                    [1551438900000, 20],
                    [1551438930000, 19],
                    [1551438960000, 21],
                    [1551438990000, 20],
                    [1551439020000, 23],
                    [1551439050000, 18],
                    [1551439080000, 18],
                    [1551439110000, 18],
                    [1551439140000, 18],
                    [1551439170000, 17],
                    [1551439200000, 18],
                    [1551439230000, 19],
                    [1551439260000, 20],
                    [1551439290000, 20],
                    [1551439320000, 18],
                    [1551439350000, 20],
                    [1551439380000, 18],
                    [1551439410000, 20],
                    [1551439440000, 18],
                    [1551439470000, 19],
                    [1551439500000, 17],
                    [1551439530000, 17],
                    [1551439560000, 16],
                    [1551439590000, 15],
                    [1551439620000, 17],
                    [1551439650000, 18],
                    [1551439680000, 19],
                    [1551439710000, 20],
                    [1551439740000, 18],
                    [1551439770000, 21],
                    [1551439800000, 19],
                    [1551439830000, 20],
                    [1551439860000, 19],
                    [1551439890000, 18],
                    [1551439920000, 19],
                    [1551439950000, 19],
                    [1551439980000, 20],
                    [1551440010000, 19],
                    [1551440040000, 19],
                    [1551440070000, 19],
                    [1551440100000, 19],
                    [1551440130000, 17],
                    [1551440160000, 18],
                    [1551440190000, 18],
                    [1551440220000, 21],
                    [1551440250000, 18],
                    [1551440280000, 20],
                    [1551440310000, 17],
                    [1551440340000, 19],
                    [1551440370000, 20],
                    [1551440400000, 20],
                    [1551440430000, 20],
                    [1551440460000, 18],
                    [1551440490000, 16],
                    [1551440520000, 16],
                    [1551440550000, 17],
                    [1551440580000, 18],
                    [1551440610000, 16],
                    [1551440640000, 25],
                    [1551440670000, 16],
                    [1551440700000, 18],
                    [1551440730000, 17],
                    [1551440760000, 19],
                    [1551440790000, 17],
                    [1551440820000, 22],
                    [1551440850000, 20],
                    [1551440880000, 22],
                    [1551440910000, 31],
                    [1551440940000, 18],
                    [1551440970000, 17],
                    [1551441000000, 16],
                    [1551441030000, 17],
                    [1551441060000, 18],
                    [1551441090000, 16],
                    [1551441120000, 14],
                    [1551441150000, 14],
                    [1551441180000, 15],
                    [1551441210000, 19],
                    [1551441240000, 16],
                    [1551441270000, 17],
                    [1551441300000, 16],
                    [1551441330000, 16],
                    [1551441360000, 17],
                    [1551441390000, 18],
                    [1551441420000, 18],
                    [1551441450000, 17],
                    [1551441480000, 17],
                    [1551441510000, 16],
                    [1551441540000, 16],
                    [1551441570000, 17],
                ],
            },
        ],
        kibana_process_delay: [
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.process.event_loop_delay',
                    metricAgg: 'max',
                    label: 'Event Loop Delay',
                    description: 'Delay in Kibana server event loops.',
                    units: 'ms',
                    format: '0.[00]',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 1.917205810546875],
                    [1551438030000, 1.7739791870117188],
                    [1551438060000, 2.943075180053711],
                    [1551438090000, 5.207357406616211],
                    [1551438120000, 1.6650104522705078],
                    [1551438150000, 2.154033660888672],
                    [1551438180000, 2.118760108947754],
                    [1551438210000, 3.37868595123291],
                    [1551438240000, 2.1819963455200195],
                    [1551438270000, 2.568490982055664],
                    [1551438300000, 353.22412109375],
                    [1551438330000, 4.138860702514648],
                    [1551438360000, 1.835433006286621],
                    [1551438390000, 1.8117866516113281],
                    [1551438420000, 1.7387809753417969],
                    [1551438450000, 2.006241798400879],
                    [1551438480000, 1.8574104309082031],
                    [1551438510000, 2.101459503173828],
                    [1551438540000, 2.2292041778564453],
                    [1551438570000, 1.8641471862792969],
                    [1551438600000, 2.124319076538086],
                    [1551438630000, 2.1186132431030273],
                    [1551438660000, 1.7360162734985352],
                    [1551438690000, 2.1855764389038086],
                    [1551438720000, 3.210604667663574],
                    [1551438750000, 2.510148048400879],
                    [1551438780000, 1.6755142211914062],
                    [1551438810000, 1.9307565689086914],
                    [1551438840000, 9.354450225830078],
                    [1551438870000, 1.9756240844726562],
                    [1551438900000, 2.2764291763305664],
                    [1551438930000, 346.5954284667969],
                    [1551438960000, 4.56385612487793],
                    [1551438990000, 2.3435449600219727],
                    [1551439020000, 3.8228683471679688],
                    [1551439050000, 2.6483001708984375],
                    [1551439080000, 1.8082962036132812],
                    [1551439110000, 1.6172676086425781],
                    [1551439140000, 1.8350811004638672],
                    [1551439170000, 1.659804344177246],
                    [1551439200000, 2.4164390563964844],
                    [1551439230000, 1.999464988708496],
                    [1551439260000, 1.9630374908447266],
                    [1551439290000, 2.0218467712402344],
                    [1551439320000, 2.076573371887207],
                    [1551439350000, 2.4036598205566406],
                    [1551439380000, 2.602895736694336],
                    [1551439410000, 2.5561323165893555],
                    [1551439440000, 2.3957443237304688],
                    [1551439470000, 2.3182430267333984],
                    [1551439500000, 2.0863637924194336],
                    [1551439530000, 1.9851713180541992],
                    [1551439560000, 1.9189224243164062],
                    [1551439590000, 1.937936782836914],
                    [1551439620000, 3.844411849975586],
                    [1551439650000, 5.052459716796875],
                    [1551439680000, 2.012505531311035],
                    [1551439710000, 2.27213191986084],
                    [1551439740000, 1.951359748840332],
                    [1551439770000, 2.6224374771118164],
                    [1551439800000, 2.6582508087158203],
                    [1551439830000, 2.607870101928711],
                    [1551439860000, 2.4416723251342773],
                    [1551439890000, 2.369551658630371],
                    [1551439920000, 2.0154476165771484],
                    [1551439950000, 2.096695899963379],
                    [1551439980000, 1.9279394149780273],
                    [1551440010000, 3.023202896118164],
                    [1551440040000, 3.772576332092285],
                    [1551440070000, 2.4855575561523438],
                    [1551440100000, 4.25732421875],
                    [1551440130000, 2.0820703506469727],
                    [1551440160000, 2.489288330078125],
                    [1551440190000, 2.602682113647461],
                    [1551440220000, 4.733266830444336],
                    [1551440250000, 1.8897781372070312],
                    [1551440280000, 2.365001678466797],
                    [1551440310000, 2.295949935913086],
                    [1551440340000, 3.2801055908203125],
                    [1551440370000, 1.8901805877685547],
                    [1551440400000, 2.0735225677490234],
                    [1551440430000, 1.8940362930297852],
                    [1551440460000, 3.0348567962646484],
                    [1551440490000, 2.0472803115844727],
                    [1551440520000, 2.2077903747558594],
                    [1551440550000, 5.1581220626831055],
                    [1551440580000, 2.039125442504883],
                    [1551440610000, 1.6546344757080078],
                    [1551440640000, 3.1943721771240234],
                    [1551440670000, 2.0258655548095703],
                    [1551440700000, 2.2764244079589844],
                    [1551440730000, 1.8293533325195312],
                    [1551440760000, 2.745746612548828],
                    [1551440790000, 2.426107406616211],
                    [1551440820000, 2.497190475463867],
                    [1551440850000, 2.6376562118530273],
                    [1551440880000, 6.415732383728027],
                    [1551440910000, 22.362375259399414],
                    [1551440940000, 1.8069639205932617],
                    [1551440970000, 2.2364587783813477],
                    [1551441000000, 2.1819095611572266],
                    [1551441030000, 2.6490097045898438],
                    [1551441060000, 3.7438411712646484],
                    [1551441090000, 2.2370100021362305],
                    [1551441120000, 2.1098766326904297],
                    [1551441150000, 3.0454416275024414],
                    [1551441180000, 2.211244583129883],
                    [1551441210000, 2.860243797302246],
                    [1551441240000, 2.255979537963867],
                    [1551441270000, 2.0102500915527344],
                    [1551441300000, 2.06740665435791],
                    [1551441330000, 1.9841184616088867],
                    [1551441360000, 2.046261787414551],
                    [1551441390000, 5.3361921310424805],
                    [1551441420000, 3.9412336349487305],
                    [1551441450000, 2.885173797607422],
                    [1551441480000, 3.661712646484375],
                    [1551441510000, 1.8046932220458984],
                    [1551441540000, 1.9574308395385742],
                    [1551441570000, 1.9149093627929688],
                ],
            },
        ],
        kibana_memory: [
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.process.memory.heap.size_limit',
                    metricAgg: 'max',
                    label: 'Heap Size Limit',
                    title: 'Memory Size',
                    description: 'Limit of memory usage before garbage collection.',
                    units: 'B',
                    format: '0,0.0 b',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 1501560832],
                    [1551438030000, 1501560832],
                    [1551438060000, 1501560832],
                    [1551438090000, 1501560832],
                    [1551438120000, 1501560832],
                    [1551438150000, 1501560832],
                    [1551438180000, 1501560832],
                    [1551438210000, 1501560832],
                    [1551438240000, 1501560832],
                    [1551438270000, 1501560832],
                    [1551438300000, 1501560832],
                    [1551438330000, 1501560832],
                    [1551438360000, 1501560832],
                    [1551438390000, 1501560832],
                    [1551438420000, 1501560832],
                    [1551438450000, 1501560832],
                    [1551438480000, 1501560832],
                    [1551438510000, 1501560832],
                    [1551438540000, 1501560832],
                    [1551438570000, 1501560832],
                    [1551438600000, 1501560832],
                    [1551438630000, 1501560832],
                    [1551438660000, 1501560832],
                    [1551438690000, 1501560832],
                    [1551438720000, 1501560832],
                    [1551438750000, 1501560832],
                    [1551438780000, 1501560832],
                    [1551438810000, 1501560832],
                    [1551438840000, 1501560832],
                    [1551438870000, 1501560832],
                    [1551438900000, 1501560832],
                    [1551438930000, 1501560832],
                    [1551438960000, 1501560832],
                    [1551438990000, 1501560832],
                    [1551439020000, 1501560832],
                    [1551439050000, 1501560832],
                    [1551439080000, 1501560832],
                    [1551439110000, 1501560832],
                    [1551439140000, 1501560832],
                    [1551439170000, 1501560832],
                    [1551439200000, 1501560832],
                    [1551439230000, 1501560832],
                    [1551439260000, 1501560832],
                    [1551439290000, 1501560832],
                    [1551439320000, 1501560832],
                    [1551439350000, 1501560832],
                    [1551439380000, 1501560832],
                    [1551439410000, 1501560832],
                    [1551439440000, 1501560832],
                    [1551439470000, 1501560832],
                    [1551439500000, 1501560832],
                    [1551439530000, 1501560832],
                    [1551439560000, 1501560832],
                    [1551439590000, 1501560832],
                    [1551439620000, 1501560832],
                    [1551439650000, 1501560832],
                    [1551439680000, 1501560832],
                    [1551439710000, 1501560832],
                    [1551439740000, 1501560832],
                    [1551439770000, 1501560832],
                    [1551439800000, 1501560832],
                    [1551439830000, 1501560832],
                    [1551439860000, 1501560832],
                    [1551439890000, 1501560832],
                    [1551439920000, 1501560832],
                    [1551439950000, 1501560832],
                    [1551439980000, 1501560832],
                    [1551440010000, 1501560832],
                    [1551440040000, 1501560832],
                    [1551440070000, 1501560832],
                    [1551440100000, 1501560832],
                    [1551440130000, 1501560832],
                    [1551440160000, 1501560832],
                    [1551440190000, 1501560832],
                    [1551440220000, 1501560832],
                    [1551440250000, 1501560832],
                    [1551440280000, 1501560832],
                    [1551440310000, 1501560832],
                    [1551440340000, 1501560832],
                    [1551440370000, 1501560832],
                    [1551440400000, 1501560832],
                    [1551440430000, 1501560832],
                    [1551440460000, 1501560832],
                    [1551440490000, 1501560832],
                    [1551440520000, 1501560832],
                    [1551440550000, 1501560832],
                    [1551440580000, 1501560832],
                    [1551440610000, 1501560832],
                    [1551440640000, 1501560832],
                    [1551440670000, 1501560832],
                    [1551440700000, 1501560832],
                    [1551440730000, 1501560832],
                    [1551440760000, 1501560832],
                    [1551440790000, 1501560832],
                    [1551440820000, 1501560832],
                    [1551440850000, 1501560832],
                    [1551440880000, 1501560832],
                    [1551440910000, 1501560832],
                    [1551440940000, 1501560832],
                    [1551440970000, 1501560832],
                    [1551441000000, 1501560832],
                    [1551441030000, 1501560832],
                    [1551441060000, 1501560832],
                    [1551441090000, 1501560832],
                    [1551441120000, 1501560832],
                    [1551441150000, 1501560832],
                    [1551441180000, 1501560832],
                    [1551441210000, 1501560832],
                    [1551441240000, 1501560832],
                    [1551441270000, 1501560832],
                    [1551441300000, 1501560832],
                    [1551441330000, 1501560832],
                    [1551441360000, 1501560832],
                    [1551441390000, 1501560832],
                    [1551441420000, 1501560832],
                    [1551441450000, 1501560832],
                    [1551441480000, 1501560832],
                    [1551441510000, 1501560832],
                    [1551441540000, 1501560832],
                    [1551441570000, 1501560832],
                ],
            },
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.process.memory.resident_set_size_in_bytes',
                    metricAgg: 'max',
                    label: 'Memory Size',
                    title: 'Memory Size',
                    description: 'Total heap used by Kibana running in Node.js.',
                    units: 'B',
                    format: '0,0.0 b',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 645689344],
                    [1551438030000, 642293760],
                    [1551438060000, 649953280],
                    [1551438090000, 637751296],
                    [1551438120000, 643112960],
                    [1551438150000, 642781184],
                    [1551438180000, 642899968],
                    [1551438210000, 646262784],
                    [1551438240000, 643276800],
                    [1551438270000, 663547904],
                    [1551438300000, 654954496],
                    [1551438330000, 644222976],
                    [1551438360000, 645672960],
                    [1551438390000, 649728000],
                    [1551438420000, 646631424],
                    [1551438450000, 647000064],
                    [1551438480000, 647114752],
                    [1551438510000, 648630272],
                    [1551438540000, 647720960],
                    [1551438570000, 646979584],
                    [1551438600000, 651296768],
                    [1551438630000, 642248704],
                    [1551438660000, 645177344],
                    [1551438690000, 648171520],
                    [1551438720000, 670048256],
                    [1551438750000, 653139968],
                    [1551438780000, 644583424],
                    [1551438810000, 648630272],
                    [1551438840000, 647925760],
                    [1551438870000, 648986624],
                    [1551438900000, 644399104],
                    [1551438930000, 636719104],
                    [1551438960000, 650260480],
                    [1551438990000, 666669056],
                    [1551439020000, 661057536],
                    [1551439050000, 649957376],
                    [1551439080000, 655093760],
                    [1551439110000, 647913472],
                    [1551439140000, 642232320],
                    [1551439170000, 642490368],
                    [1551439200000, 643133440],
                    [1551439230000, 640008192],
                    [1551439260000, 648654848],
                    [1551439290000, 643506176],
                    [1551439320000, 647127040],
                    [1551439350000, 662966272],
                    [1551439380000, 646635520],
                    [1551439410000, 641519616],
                    [1551439440000, 658214912],
                    [1551439470000, 666677248],
                    [1551439500000, 651583488],
                    [1551439530000, 652963840],
                    [1551439560000, 662065152],
                    [1551439590000, 662417408],
                    [1551439620000, 665919488],
                    [1551439650000, 646316032],
                    [1551439680000, 643153920],
                    [1551439710000, 658288640],
                    [1551439740000, 662052864],
                    [1551439770000, 660353024],
                    [1551439800000, 649293824],
                    [1551439830000, 661753856],
                    [1551439860000, 663977984],
                    [1551439890000, 658100224],
                    [1551439920000, 657711104],
                    [1551439950000, 645820416],
                    [1551439980000, 648531968],
                    [1551440010000, 644272128],
                    [1551440040000, 649019392],
                    [1551440070000, 656228352],
                    [1551440100000, 643280896],
                    [1551440130000, 645763072],
                    [1551440160000, 649703424],
                    [1551440190000, 653647872],
                    [1551440220000, 647307264],
                    [1551440250000, 685629440],
                    [1551440280000, 711311360],
                    [1551440310000, 648220672],
                    [1551440340000, 645439488],
                    [1551440370000, 646225920],
                    [1551440400000, 650481664],
                    [1551440430000, 650178560],
                    [1551440460000, 651149312],
                    [1551440490000, 653852672],
                    [1551440520000, 651427840],
                    [1551440550000, 652050432],
                    [1551440580000, 646492160],
                    [1551440610000, 650129408],
                    [1551440640000, 659320832],
                    [1551440670000, 653029376],
                    [1551440700000, 661946368],
                    [1551440730000, 652808192],
                    [1551440760000, 656105472],
                    [1551440790000, 654086144],
                    [1551440820000, 649216000],
                    [1551440850000, 660570112],
                    [1551440880000, 663560192],
                    [1551440910000, 663306240],
                    [1551440940000, 750891008],
                    [1551440970000, 802795520],
                    [1551441000000, 682393600],
                    [1551441030000, 646311936],
                    [1551441060000, 648204288],
                    [1551441090000, 650903552],
                    [1551441120000, 648257536],
                    [1551441150000, 649920512],
                    [1551441180000, 643801088],
                    [1551441210000, 653606912],
                    [1551441240000, 654901248],
                    [1551441270000, 644833280],
                    [1551441300000, 658534400],
                    [1551441330000, 655249408],
                    [1551441360000, 647827456],
                    [1551441390000, 655147008],
                    [1551441420000, 652087296],
                    [1551441450000, 655159296],
                    [1551441480000, 655753216],
                    [1551441510000, 666820608],
                    [1551441540000, 662138880],
                    [1551441570000, 651341824],
                ],
            },
        ],
        kibana_response_times: [
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.response_times.max',
                    metricAgg: 'max',
                    label: 'Max',
                    title: 'Client Response Time',
                    description: 'Maximum response time for client requests to the Kibana instance.',
                    units: 'ms',
                    format: '0.[00]',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 11637],
                    [1551438030000, 12188],
                    [1551438060000, 11802],
                    [1551438090000, 11907],
                    [1551438120000, 11875],
                    [1551438150000, 11835],
                    [1551438180000, 12077],
                    [1551438210000, 11827],
                    [1551438240000, 11870],
                    [1551438270000, 11897],
                    [1551438300000, 12085],
                    [1551438330000, 11829],
                    [1551438360000, 11804],
                    [1551438390000, 12040],
                    [1551438420000, 11906],
                    [1551438450000, 11967],
                    [1551438480000, 11798],
                    [1551438510000, 11587],
                    [1551438540000, 11766],
                    [1551438570000, 11763],
                    [1551438600000, 11848],
                    [1551438630000, 12061],
                    [1551438660000, 11922],
                    [1551438690000, 11805],
                    [1551438720000, 12194],
                    [1551438750000, 11784],
                    [1551438780000, 12097],
                    [1551438810000, 11984],
                    [1551438840000, 11955],
                    [1551438870000, 11378],
                    [1551438900000, 12047],
                    [1551438930000, 11989],
                    [1551438960000, 11925],
                    [1551438990000, 12009],
                    [1551439020000, 11806],
                    [1551439050000, 11761],
                    [1551439080000, 11808],
                    [1551439110000, 11979],
                    [1551439140000, 11945],
                    [1551439170000, 11769],
                    [1551439200000, 12010],
                    [1551439230000, 11746],
                    [1551439260000, 12176],
                    [1551439290000, 12253],
                    [1551439320000, 12093],
                    [1551439350000, 12034],
                    [1551439380000, 12114],
                    [1551439410000, 12135],
                    [1551439440000, 12193],
                    [1551439470000, 12138],
                    [1551439500000, 12116],
                    [1551439530000, 11849],
                    [1551439560000, 12335],
                    [1551439590000, 11988],
                    [1551439620000, 12077],
                    [1551439650000, 11841],
                    [1551439680000, 11956],
                    [1551439710000, 11798],
                    [1551439740000, 11939],
                    [1551439770000, 11929],
                    [1551439800000, 11894],
                    [1551439830000, 11962],
                    [1551439860000, 12348],
                    [1551439890000, 11939],
                    [1551439920000, 12005],
                    [1551439950000, 12550],
                    [1551439980000, 11935],
                    [1551440010000, 11931],
                    [1551440040000, 11814],
                    [1551440070000, 11703],
                    [1551440100000, 11990],
                    [1551440130000, 12050],
                    [1551440160000, 11971],
                    [1551440190000, 11720],
                    [1551440220000, 12085],
                    [1551440250000, 11919],
                    [1551440280000, 12551],
                    [1551440310000, 11873],
                    [1551440340000, 11599],
                    [1551440370000, 11977],
                    [1551440400000, 12002],
                    [1551440430000, 11757],
                    [1551440460000, 11657],
                    [1551440490000, 11291],
                    [1551440520000, 11943],
                    [1551440550000, 12223],
                    [1551440580000, 1482],
                    [1551440610000, 12060],
                    [1551440640000, 12016],
                    [1551440670000, 12318],
                    [1551440700000, 11969],
                    [1551440730000, 11974],
                    [1551440760000, 11779],
                    [1551440790000, 11868],
                    [1551440820000, 12295],
                    [1551440850000, 12077],
                    [1551440880000, 12127],
                    [1551440910000, 12075],
                    [1551440940000, 12472],
                    [1551440970000, 11715],
                    [1551441000000, 12036],
                    [1551441030000, 12020],
                    [1551441060000, 12816],
                    [1551441090000, 12644],
                    [1551441120000, 11907],
                    [1551441150000, 11945],
                    [1551441180000, 12083],
                    [1551441210000, 11998],
                    [1551441240000, 12259],
                    [1551441270000, 11516],
                    [1551441300000, 11969],
                    [1551441330000, 12053],
                    [1551441360000, 12002],
                    [1551441390000, 12016],
                    [1551441420000, 12146],
                    [1551441450000, 11904],
                    [1551441480000, 11942],
                    [1551441510000, 12139],
                    [1551441540000, 11966],
                    [1551441570000, 12051],
                ],
            },
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.response_times.average',
                    metricAgg: 'max',
                    label: 'Average',
                    title: 'Client Response Time',
                    description: 'Average response time for client requests to the Kibana instance.',
                    units: 'ms',
                    format: '0.[00]',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 237.5],
                    [1551438030000, 606.875],
                    [1551438060000, 514.413818359375],
                    [1551438090000, 722.0555419921875],
                    [1551438120000, 512],
                    [1551438150000, 294.32073974609375],
                    [1551438180000, 538.6333618164062],
                    [1551438210000, 720.8333129882812],
                    [1551438240000, 468.56097412109375],
                    [1551438270000, 559.5184936523438],
                    [1551438300000, 549.888916015625],
                    [1551438330000, 636.6190185546875],
                    [1551438360000, 626.6818237304688],
                    [1551438390000, 578.8846435546875],
                    [1551438420000, 562.4615478515625],
                    [1551438450000, 582.75],
                    [1551438480000, 491.0967712402344],
                    [1551438510000, 527.5357055664062],
                    [1551438540000, 436.25714111328125],
                    [1551438570000, 504.17242431640625],
                    [1551438600000, 527.8928833007812],
                    [1551438630000, 419.20513916015625],
                    [1551438660000, 494.258056640625],
                    [1551438690000, 529.5184936523438],
                    [1551438720000, 511.2257995605469],
                    [1551438750000, 297.3492126464844],
                    [1551438780000, 622.3666381835938],
                    [1551438810000, 284.5199890136719],
                    [1551438840000, 805.5555419921875],
                    [1551438870000, 519.2857055664062],
                    [1551438900000, 609.4583129882812],
                    [1551438930000, 278.6333312988281],
                    [1551438960000, 537.3461303710938],
                    [1551438990000, 522.0344848632812],
                    [1551439020000, 440.8571472167969],
                    [1551439050000, 518],
                    [1551439080000, 232.17808532714844],
                    [1551439110000, 494.0322570800781],
                    [1551439140000, 597],
                    [1551439170000, 297.7321472167969],
                    [1551439200000, 552.2857055664062],
                    [1551439230000, 270.17742919921875],
                    [1551439260000, 563.3076782226562],
                    [1551439290000, 591.375],
                    [1551439320000, 613.0370483398438],
                    [1551439350000, 557.1142578125],
                    [1551439380000, 474.875],
                    [1551439410000, 282.0428466796875],
                    [1551439440000, 285.3492126464844],
                    [1551439470000, 466.2894592285156],
                    [1551439500000, 452.3714294433594],
                    [1551439530000, 445.9459533691406],
                    [1551439560000, 410.5],
                    [1551439590000, 434.6486511230469],
                    [1551439620000, 243.028564453125],
                    [1551439650000, 477.125],
                    [1551439680000, 245.6666717529297],
                    [1551439710000, 266.63934326171875],
                    [1551439740000, 398.4285583496094],
                    [1551439770000, 395.9761962890625],
                    [1551439800000, 233.9545440673828],
                    [1551439830000, 427.76922607421875],
                    [1551439860000, 366.05999755859375],
                    [1551439890000, 514],
                    [1551439920000, 421.452392578125],
                    [1551439950000, 445.5128173828125],
                    [1551439980000, 279.76812744140625],
                    [1551440010000, 225.01123046875],
                    [1551440040000, 520.6551513671875],
                    [1551440070000, 525],
                    [1551440100000, 317.6000061035156],
                    [1551440130000, 432.9756164550781],
                    [1551440160000, 454.4210510253906],
                    [1551440190000, 507.625],
                    [1551440220000, 300.015869140625],
                    [1551440250000, 512.625],
                    [1551440280000, 476.7250061035156],
                    [1551440310000, 485.8484802246094],
                    [1551440340000, 446.97222900390625],
                    [1551440370000, 519.2142944335938],
                    [1551440400000, 461.941162109375],
                    [1551440430000, 534.74072265625],
                    [1551440460000, 498.258056640625],
                    [1551440490000, 515.6666870117188],
                    [1551440520000, 564.137939453125],
                    [1551440550000, 515.933349609375],
                    [1551440580000, 148.50877380371094],
                    [1551440610000, 445.6388854980469],
                    [1551440640000, 569.923095703125],
                    [1551440670000, 328.4313659667969],
                    [1551440700000, 386.47369384765625],
                    [1551440730000, 514.6785888671875],
                    [1551440760000, 667.6818237304688],
                    [1551440790000, 589.6153564453125],
                    [1551440820000, 337.5918273925781],
                    [1551440850000, 435.868408203125],
                    [1551440880000, 569.774169921875],
                    [1551440910000, 532.0714111328125],
                    [1551440940000, 365.9818115234375],
                    [1551440970000, 616.0833129882812],
                    [1551441000000, 521.8965454101562],
                    [1551441030000, 557.1851806640625],
                    [1551441060000, 540.3793334960938],
                    [1551441090000, 588.076904296875],
                    [1551441120000, 610.2000122070312],
                    [1551441150000, 621.3333129882812],
                    [1551441180000, 534],
                    [1551441210000, 533.8571166992188],
                    [1551441240000, 459.8611145019531],
                    [1551441270000, 508.96429443359375],
                    [1551441300000, 556.8148193359375],
                    [1551441330000, 614.8695678710938],
                    [1551441360000, 469.8285827636719],
                    [1551441390000, 484.18182373046875],
                    [1551441420000, 644.09521484375],
                    [1551441450000, 524],
                    [1551441480000, 719.5789184570312],
                    [1551441510000, 564.4000244140625],
                    [1551441540000, 561.0740966796875],
                    [1551441570000, 329.6833190917969],
                ],
            },
        ],
        kibana_requests: [
            {
                bucket_size: '30 seconds',
                timeRange: { min: 1551438000000, max: 1551441600000 },
                metric: {
                    app: 'kibana',
                    field: 'kibana_stats.requests.total',
                    metricAgg: 'max',
                    label: 'Client Requests',
                    description: 'Total number of client requests received by the Kibana instance.',
                    units: '',
                    format: '0.[00]',
                    hasCalculation: false,
                    isDerivative: false,
                },
                data: [
                    [1551438000000, 62],
                    [1551438030000, 43],
                    [1551438060000, 64],
                    [1551438090000, 60],
                    [1551438120000, 44],
                    [1551438150000, 56],
                    [1551438180000, 32],
                    [1551438210000, 36],
                    [1551438240000, 56],
                    [1551438270000, 83],
                    [1551438300000, 59],
                    [1551438330000, 62],
                    [1551438360000, 34],
                    [1551438390000, 35],
                    [1551438420000, 30],
                    [1551438450000, 30],
                    [1551438480000, 32],
                    [1551438510000, 30],
                    [1551438540000, 62],
                    [1551438570000, 37],
                    [1551438600000, 33],
                    [1551438630000, 56],
                    [1551438660000, 36],
                    [1551438690000, 31],
                    [1551438720000, 85],
                    [1551438750000, 75],
                    [1551438780000, 53],
                    [1551438810000, 48],
                    [1551438840000, 39],
                    [1551438870000, 57],
                    [1551438900000, 37],
                    [1551438930000, 58],
                    [1551438960000, 91],
                    [1551438990000, 65],
                    [1551439020000, 43],
                    [1551439050000, 35],
                    [1551439080000, 71],
                    [1551439110000, 62],
                    [1551439140000, 34],
                    [1551439170000, 55],
                    [1551439200000, 61],
                    [1551439230000, 74],
                    [1551439260000, 62],
                    [1551439290000, 53],
                    [1551439320000, 97],
                    [1551439350000, 92],
                    [1551439380000, 37],
                    [1551439410000, 71],
                    [1551439440000, 64],
                    [1551439470000, 39],
                    [1551439500000, 60],
                    [1551439530000, 56],
                    [1551439560000, 39],
                    [1551439590000, 36],
                    [1551439620000, 70],
                    [1551439650000, 47],
                    [1551439680000, 66],
                    [1551439710000, 124],
                    [1551439740000, 52],
                    [1551439770000, 98],
                    [1551439800000, 86],
                    [1551439830000, 97],
                    [1551439860000, 50],
                    [1551439890000, 36],
                    [1551439920000, 42],
                    [1551439950000, 41],
                    [1551439980000, 72],
                    [1551440010000, 93],
                    [1551440040000, 53],
                    [1551440070000, 33],
                    [1551440100000, 66],
                    [1551440130000, 43],
                    [1551440160000, 44],
                    [1551440190000, 34],
                    [1551440220000, 104],
                    [1551440250000, 50],
                    [1551440280000, 38],
                    [1551440310000, 35],
                    [1551440340000, 37],
                    [1551440370000, 37],
                    [1551440400000, 40],
                    [1551440430000, 33],
                    [1551440460000, 34],
                    [1551440490000, 31],
                    [1551440520000, 35],
                    [1551440550000, 41],
                    [1551440580000, 59],
                    [1551440610000, 36],
                    [1551440640000, 80],
                    [1551440670000, 41],
                    [1551440700000, 53],
                    [1551440730000, 106],
                    [1551440760000, 62],
                    [1551440790000, 90],
                    [1551440820000, 67],
                    [1551440850000, 107],
                    [1551440880000, 83],
                    [1551440910000, 74],
                    [1551440940000, 91],
                    [1551440970000, 57],
                    [1551441000000, 36],
                    [1551441030000, 33],
                    [1551441060000, 55],
                    [1551441090000, 41],
                    [1551441120000, 32],
                    [1551441150000, 38],
                    [1551441180000, 57],
                    [1551441210000, 57],
                    [1551441240000, 43],
                    [1551441270000, 41],
                    [1551441300000, 34],
                    [1551441330000, 59],
                    [1551441360000, 36],
                    [1551441390000, 71],
                    [1551441420000, 55],
                    [1551441450000, 43],
                    [1551441480000, 67],
                    [1551441510000, 81],
                    [1551441540000, 58],
                    [1551441570000, 97],
                ],
            },
        ],
    },
    kibanaSummary: {
        uuid: '38cd1f5c-fc29-492e-b5b6-34777df7bdf6',
        name: 'demo.elastic.co',
        index: '.kibana',
        host: '0.0.0.0',
        transport_address: '0.0.0.0:5601',
        version: '6.5.4',
        snapshot: false,
        status: 'green',
        availability: true,
        os_memory_free: 74041475072,
        uptime: 243193903,
    },
};
//# sourceMappingURL=test_dataset_kibana.js.map