"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// import { toJS } from 'mobx';
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
// import { DataSeriesType } from '../commons/series/specs';
// import { AreaSeries } from '../components/area_series';
var axis_1 = require("./axis");
var bar_series_1 = require("./bar_series");
// interface BarSeriesDataGlyphs {
//   type: DataSeriesType;
//   bars: BarSeriesGlyph[];
// }
// interface LineSeriesDataGlyphs {
//   type: DataSeriesType;
//   line: LineSeriesGlyph;
// }
// interface AreaSeriesDataGlyphs {
//   type: DataSeriesType;
//   area: AreaSeriesGlyph;
// }
var Chart = /** @class */ (function (_super) {
    __extends(Chart, _super);
    function Chart() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderAxes = function () {
            var _a = _this.props.chartStore, axesVisibleTicks = _a.axesVisibleTicks, axesSpecs = _a.axesSpecs, axesTicksDimensions = _a.axesTicksDimensions, axesPositions = _a.axesPositions, chartTheme = _a.chartTheme;
            var axesComponents = [];
            axesVisibleTicks.forEach(function (axisTicks, axisId) {
                var axisSpec = axesSpecs.get(axisId);
                var axisTicksDimensions = axesTicksDimensions.get(axisId);
                var axisPosition = axesPositions.get(axisId);
                var ticks = axesVisibleTicks.get(axisId);
                if (!ticks || !axisSpec || !axisTicksDimensions || !axisPosition) {
                    return;
                }
                axesComponents.push(react_1.default.createElement(axis_1.Axis, { key: "axis-" + axisId, axisSpec: axisSpec, axisTicksDimensions: axisTicksDimensions, axisPosition: axisPosition, ticks: ticks, chartTheme: chartTheme }));
            });
            return axesComponents;
        };
        // public renderLineSeries = () => {
        //   const { seriesGlyphs } = this.props.chartStore!;
        //   const points: JSX.Element[] = [];
        //   seriesGlyphs.forEach((spec, specId) => {
        //     if (spec.type !== DataSeriesType.Line) {
        //       return;
        //     }
        //     const lineGlyph = spec as LineSeriesDataGlyphs;
        //     points.push(<LineSeries key={`line-series-${specId}`} line={lineGlyph.line} />);
        //   });
        //   return points;
        // }
        // public renderPointSeries = () => {
        //   return null;
        // }
        _this.renderBarSeries = function () {
            var _a = _this.props.chartStore, geometries = _a.geometries, canDataBeAnimated = _a.canDataBeAnimated;
            if (!geometries) {
                return;
            }
            return react_1.default.createElement(bar_series_1.BarSeries, { key: "data bars", animated: canDataBeAnimated, bars: geometries.bars });
        };
        return _this;
    }
    Chart.prototype.componentDidMount = function () {
        // tslint:disable-next-line:no-console
        console.log('Chart mounted');
    };
    Chart.prototype.componentWillUnmount = function () {
        // tslint:disable-next-line:no-console
        console.log('Chart unmounted');
    };
    // public renderAreaSeries = () => {
    //   const { seriesGlyphs } = this.props.chartStore!;
    //   const points: JSX.Element[] = [];
    //   seriesGlyphs.forEach((spec, specId) => {
    //     if (spec.type !== DataSeriesType.Area) {
    //       return;
    //     }
    //     const areaGlyph = spec as AreaSeriesDataGlyphs;
    //     // tslint:disable-next-line:no-console
    //     console.log('areaGlyph', areaGlyph);
    //     points.push(<AreaSeries key={`area-series-${specId}`} area={areaGlyph.area} />);
    //   });
    //   return points;
    // }
    Chart.prototype.render = function () {
        var initialized = this.props.chartStore.initialized;
        if (!initialized.get()) {
            return null;
        }
        var _a = this.props.chartStore, parentDimensions = _a.parentDimensions, chartDimensions = _a.chartDimensions, chartRotation = _a.chartRotation;
        // console.log({ lineSeriesSpecs: toJS(lineSeriesSpecs)})
        // console.log({ groupDomains: toJS(groupDomains)})
        // console.log({ vLeftAxisSpec: toJS(vLeftAxisSpec)})
        // console.log({ hBottomAxisSpec: toJS(hBottomAxisSpec)})
        // console.log({ chartDimensions});
        var chartTransform = '';
        if (chartRotation === 90) {
            chartTransform = "translate(" + chartDimensions.width + " 0) rotate(90)";
        }
        else if (chartRotation === -90) {
            chartTransform = "translate(0 " + chartDimensions.height + ") rotate(-90)";
        }
        return (react_1.default.createElement("div", { style: {
                position: 'absolute',
                top: 0,
                bottom: 0,
                right: 0,
                left: 0,
                // width: '100%',
                // height: '100%',
                // background: 'lightblue',
                // border: '10px solid blue',
                boxSizing: 'border-box',
            } },
            react_1.default.createElement("svg", { width: parentDimensions.width, height: parentDimensions.height, style: {
                    width: '100%',
                    height: '100%',
                } },
                react_1.default.createElement("g", { className: "euiSeriesChartChart_group", transform: "translate(" + chartDimensions.left + " " + chartDimensions.top + ")" },
                    react_1.default.createElement("g", { className: "euiSeriesChartSeries_barSeries", transform: chartTransform }, this.renderBarSeries())),
                react_1.default.createElement("g", { className: "euiSeriesChartAxis_group" }, this.renderAxes()))));
    };
    Chart.displayName = 'ReactiveChart';
    return Chart;
}(react_1.default.Component));
exports.ReactiveChart = mobx_react_1.inject('chartStore')(mobx_react_1.observer(Chart));
//# sourceMappingURL=reactive_chart.js.map