/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JavaProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;

public class JavaLibraryProjectInitDescriptor
extends JavaProjectInitDescriptor {
    private static final JavaProjectInitDescriptor.Description DESCRIPTION = new JavaProjectInitDescriptor.Description("Java Library", "Java Libraries", "java_library_plugin", "java-library");
    private final TemplateLibraryVersionProvider libraryVersionProvider;

    public JavaLibraryProjectInitDescriptor(TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(libraryVersionProvider, documentationRegistry);
        this.libraryVersionProvider = libraryVersionProvider;
    }

    @Override
    public String getId() {
        return "java-library";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.LIBRARY;
    }

    @Override
    protected TemplateOperation sourceTemplateOperation(InitSettings settings, TemplateFactory templateFactory) {
        return templateFactory.fromSourceTemplate("javalibrary/Library.java.template", "main");
    }

    @Override
    protected TemplateOperation testTemplateOperation(InitSettings settings, TemplateFactory templateFactory) {
        switch (settings.getTestFramework()) {
            case SPOCK: {
                return templateFactory.fromSourceTemplate("groovylibrary/LibraryTest.groovy.template", "test", Language.GROOVY);
            }
            case TESTNG: {
                return templateFactory.fromSourceTemplate("javalibrary/testng/LibraryTest.java.template", "test");
            }
            case JUNIT: {
                return templateFactory.fromSourceTemplate("javalibrary/LibraryTest.java.template", "test");
            }
            case JUNIT_JUPITER: {
                return templateFactory.fromSourceTemplate("javalibrary/junitjupiter/LibraryTest.java.template", "test");
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected JavaProjectInitDescriptor.Description getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.dependency("api", "This dependency is exported to consumers, that is to say found on their compile classpath.", "org.apache.commons:commons-math3:" + this.libraryVersionProvider.getVersion("commons-math"));
        buildScriptBuilder.implementationDependency("This dependency is used internally, and not exposed to consumers on their own compile classpath.", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava"));
    }
}

