/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.HtmlPageBuilder;
import org.gradle.reporting.HtmlReportBuilder;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.GFileUtils;

public class HtmlReportRenderer {
    public <T> void render(T model, ReportRenderer<T, HtmlReportBuilder> renderer, File outputDirectory) {
        try {
            outputDirectory.mkdirs();
            DefaultHtmlReportContext context = new DefaultHtmlReportContext(outputDirectory);
            renderer.render(model, context);
            for (Resource resource : context.resources.values()) {
                File destFile = new File(outputDirectory, resource.path);
                if (destFile.exists()) continue;
                GFileUtils.copyURLToFile((URL)resource.source, (File)destFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public <T> void renderSinglePage(T model, final ReportRenderer<T, HtmlPageBuilder<SimpleHtmlWriter>> renderer, final File outputFile) {
        this.render(model, new ReportRenderer<T, HtmlReportBuilder>(){

            @Override
            public void render(T model, HtmlReportBuilder output) throws IOException {
                output.renderHtmlPage(outputFile.getName(), model, renderer);
            }
        }, outputFile.getParentFile());
    }

    public <T> void renderRawSinglePage(T model, final ReportRenderer<T, HtmlPageBuilder<Writer>> renderer, final File outputFile) {
        this.render(model, new ReportRenderer<T, HtmlReportBuilder>(){

            @Override
            public void render(T model, HtmlReportBuilder output) throws IOException {
                output.renderRawHtmlPage(outputFile.getName(), model, renderer);
            }
        }, outputFile.getParentFile());
    }

    private static class DefaultHtmlReportContext
    implements HtmlReportBuilder {
        private final File outputDirectory;
        private final Map<String, Resource> resources = new HashMap<String, Resource>();

        public DefaultHtmlReportContext(File outputDirectory) {
            this.outputDirectory = outputDirectory;
        }

        Resource addResource(URL source) {
            String urlString = source.toString();
            Resource resource = this.resources.get(urlString);
            if (resource == null) {
                String name = StringUtils.substringAfterLast((String)source.getPath(), (String)"/");
                String type = StringUtils.substringAfterLast((String)source.getPath(), (String)".");
                if (type.equalsIgnoreCase("png") || type.equalsIgnoreCase("gif")) {
                    type = "images";
                }
                String path = type + "/" + name;
                resource = new Resource(source, path);
                this.resources.put(urlString, resource);
            }
            return resource;
        }

        @Override
        public void requireResource(URL source) {
            this.addResource(source);
        }

        @Override
        public <T> void renderHtmlPage(final String name, final T model, final ReportRenderer<T, HtmlPageBuilder<SimpleHtmlWriter>> renderer) {
            File outputFile = new File(this.outputDirectory, name);
            IoActions.writeTextFile((File)outputFile, (String)"utf-8", (Action)new ErroringAction<Writer>(){

                protected void doExecute(Writer writer) throws Exception {
                    SimpleHtmlWriter htmlWriter = new SimpleHtmlWriter(writer, "");
                    htmlWriter.startElement("html");
                    renderer.render(model, new DefaultHtmlPageBuilder<SimpleHtmlWriter>(DefaultHtmlReportContext.this.prefix(name), htmlWriter));
                    htmlWriter.endElement();
                }
            });
        }

        @Override
        public <T> void renderRawHtmlPage(final String name, final T model, final ReportRenderer<T, HtmlPageBuilder<Writer>> renderer) {
            File outputFile = new File(this.outputDirectory, name);
            IoActions.writeTextFile((File)outputFile, (String)"utf-8", (Action)new ErroringAction<Writer>(){

                protected void doExecute(Writer writer) throws Exception {
                    renderer.render(model, new DefaultHtmlPageBuilder<Writer>(DefaultHtmlReportContext.this.prefix(name), writer));
                }
            });
        }

        private String prefix(String name) {
            int next;
            StringBuilder builder = new StringBuilder();
            int pos = 0;
            while (pos < name.length() && (next = name.indexOf(47, pos)) >= 0) {
                builder.append("../");
                pos = next + 1;
            }
            return builder.toString();
        }

        private class DefaultHtmlPageBuilder<D>
        implements HtmlPageBuilder<D> {
            private final String prefix;
            private final D output;

            public DefaultHtmlPageBuilder(String prefix, D output) {
                this.prefix = prefix;
                this.output = output;
            }

            @Override
            public String requireResource(URL source) {
                Resource resource = DefaultHtmlReportContext.this.addResource(source);
                return this.prefix + resource.path;
            }

            @Override
            public String formatDate(Date date) {
                return DateFormat.getDateTimeInstance().format(date);
            }

            @Override
            public D getOutput() {
                return this.output;
            }
        }
    }

    private static class Resource {
        final URL source;
        final String path;

        private Resource(URL source, String path) {
            this.source = source;
            this.path = path;
        }
    }
}

