/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scan.config;

import org.gradle.util.VersionNumber;

class BuildScanPluginCompatibility {
    public static final VersionNumber MIN_SUPPORTED_VERSION = VersionNumber.parse("2.0.2");
    private static final String MIN_SUPPORTED_VERSION_DISPLAY = "2.0.2";
    public static final String UNSUPPORTED_PLUGIN_VERSION_MESSAGE = "This version of Gradle requires version 2.0.2 of the build scan plugin or later.\nPlease see https://gradle.com/scans/help/gradle-incompatible-plugin-version for more information.";
    public static final String UNSUPPORTED_TOGGLE = "org.gradle.internal.unsupported-scan-plugin";
    public static final String UNSUPPORTED_TOGGLE_MESSAGE = "Build scan support disabled by secret toggle";

    BuildScanPluginCompatibility() {
    }

    String unsupportedReason() {
        if (Boolean.getBoolean(UNSUPPORTED_TOGGLE)) {
            return UNSUPPORTED_TOGGLE_MESSAGE;
        }
        return null;
    }

    static boolean isNotSupported(VersionNumber pluginVersion) {
        return pluginVersion.compareTo(MIN_SUPPORTED_VERSION) < 0;
    }
}

